/*
 * Schism Tracker - a cross-platform Impulse Tracker clone
 * copyright (c) 2003-2005 Storlek <storlek@rigelseven.com>
 * copyright (c) 2005-2008 Mrs. Brisby <mrs.brisby@nimh.org>
 * copyright (c) 2009 Storlek & Mrs. Brisby
 * copyright (c) 2010-2012 Storlek
 * URL: http://schismtracker.org/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SCHISM_ATOMIC_H_
#define SCHISM_ATOMIC_H_

#include "headers.h"

struct atm {
	volatile int32_t x;
};

struct atm_ptr {
	void *volatile x;
};

/* init/quit functions are ONLY for mutexes */
int atm_init(void);
void atm_quit(void);

int32_t atm_load(struct atm *atm);
void atm_store(struct atm *atm, int32_t x);

void *atm_ptr_load(struct atm_ptr *atm);
void atm_ptr_store(struct atm_ptr *atm, void *x);

#endif /* SCHISM_ATOMIC_H_ */