/******************************************************************************
*       SOFA, Simulation Open-Framework Architecture, version 1.0 beta 4      *
*                (c) 2006-2009 MGH, INRIA, USTL, UJF, CNRS                    *
*                                                                             *
* This library is free software; you can redistribute it and/or modify it     *
* under the terms of the GNU Lesser General Public License as published by    *
* the Free Software Foundation; either version 2.1 of the License, or (at     *
* your option) any later version.                                             *
*                                                                             *
* This library is distributed in the hope that it will be useful, but WITHOUT *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License *
* for more details.                                                           *
*                                                                             *
* You should have received a copy of the GNU Lesser General Public License    *
* along with this library; if not, write to the Free Software Foundation,     *
* Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA.          *
*******************************************************************************
*                               SOFA :: Modules                               *
*                                                                             *
* Authors: The SOFA Team and external contributors (see Authors.txt)          *
*                                                                             *
* Contact information: contact@sofa-framework.org                             *
******************************************************************************/
#ifndef SOFA_COMPONENT_TOPOLOGY_EDGESETTOPOLOGYCHANGE_H
#define SOFA_COMPONENT_TOPOLOGY_EDGESETTOPOLOGYCHANGE_H

#include <sofa/core/componentmodel/topology/Topology.h>		// TopologyChange
#include <sofa/helper/vector.h>

namespace sofa
{

namespace component
{

namespace topology
{
	using core::componentmodel::topology::BaseMeshTopology;
	typedef BaseMeshTopology::Edge Edge;

	/** indicates that some edges were added */
	class EdgesAdded : public core::componentmodel::topology::TopologyChange  
	{
    public:
		EdgesAdded(const unsigned int nE) 
			: core::componentmodel::topology::TopologyChange(core::componentmodel::topology::EDGESADDED), 
			nEdges(nE)
		{ }

		EdgesAdded(const unsigned int nE, 
			const sofa::helper::vector< Edge >& edgesList,
			const sofa::helper::vector< unsigned int >& edgesIndex) 
			: core::componentmodel::topology::TopologyChange(core::componentmodel::topology::EDGESADDED), 
			nEdges(nE), 
			edgeArray(edgesList), 
			edgeIndexArray(edgesIndex)
		{ }

		EdgesAdded(const unsigned int nE, 
			const sofa::helper::vector< Edge >& edgesList,
			const sofa::helper::vector< unsigned int >& edgesIndex,
			const sofa::helper::vector< sofa::helper::vector< unsigned int > >& ancestors) 
			: core::componentmodel::topology::TopologyChange(core::componentmodel::topology::EDGESADDED), 
			nEdges(nE), 
			edgeArray(edgesList), 
			edgeIndexArray(edgesIndex), 
			ancestorsList(ancestors)
		{ }

		EdgesAdded(const unsigned int nE, 
			const sofa::helper::vector< Edge >& edgesList,
			const sofa::helper::vector< unsigned int >& edgesIndex,
			const sofa::helper::vector< sofa::helper::vector< unsigned int > >& ancestors,
			const sofa::helper::vector< sofa::helper::vector< double > >& baryCoefs) 
			: core::componentmodel::topology::TopologyChange(core::componentmodel::topology::EDGESADDED), 
			nEdges(nE), 
			edgeArray(edgesList), 
			edgeIndexArray(edgesIndex), 
			ancestorsList(ancestors), 
			coefs(baryCoefs) 
		{ }

		virtual ~EdgesAdded() {}

		unsigned int getNbAddedEdges() const { return nEdges;}

	public:
		unsigned int nEdges;
		sofa::helper::vector< Edge > edgeArray;
		sofa::helper::vector< unsigned int > edgeIndexArray;
		sofa::helper::vector< sofa::helper::vector< unsigned int > > ancestorsList;
		sofa::helper::vector< sofa::helper::vector< double > > coefs;
	};


	/** indicates that some edges are about to be removed */
	class EdgesRemoved : public core::componentmodel::topology::TopologyChange  
	{
	public:
		EdgesRemoved(const sofa::helper::vector<unsigned int> _eArray)
		: core::componentmodel::topology::TopologyChange(core::componentmodel::topology::EDGESREMOVED), 
		removedEdgesArray(_eArray) 
		{}

		~EdgesRemoved() {}

		virtual const sofa::helper::vector<unsigned int> &getArray() const 
		{ 
			return removedEdgesArray; 
		}

		virtual unsigned int getNbRemovedEdges() const 
		{ 
			return removedEdgesArray.size(); 
		}

	public:
		sofa::helper::vector<unsigned int> removedEdgesArray;
	};

} // namespace topology

} // namespace component

} // namespace sofa

#endif
