3.4 Sobres para sampleos

# Sobres para sampleos 

Es posible modificar la *duración* y *amplitud* de un sampleo usando un
sobre ADSR. sin embargo, esto funciona algo diferentemente que con los
sintetizadores (synths), ya que los sobres para sampleos sólo te permiten
reducir la amplitud y duración de un sampleo, pero nunca incrementarlo.
El sampleo terminará su ejecución ya sea cuando se acabe o cuando el sobre
lo haga, lo que suceda antes. Así que si utilizas un largo 'release', ello
no extenderá la duración del sampleo.


## Sobres para Amen

Volvamos a nuestro amigo, el Amen Break:

```
sample :loop_amen
```

Sin operandos, escuchamos el sampleo completo y amplitud completa. Si 
quisiéramos aparecerlo dentro de 1 segundo, podemos utilizar el parámetro
`attack:` :

```
sample :loop_amen, attack: 1
```

Para un desaparecimiento más corto, elegiríamos un valor de ataque menor:


```
sample :loop_amen, attack: 0.3
```

## Auto Sustain

Donde el sobre ADSR difiera en su conducta con el de un sintetizador es en 
el valor del *sustain*. En el sobre de un sintetizador, el sustain está
predeterminado a 0 si no lo cambias manualmente. Con sampleos, el valor
predeterminado de sustain está en *automágico* - el tiempo que resta para
terminar el resto del sampleo. A ello se debe que podamos escuchar el 
sampleo completo cuando no pasamos parámetros. Si los valores de ataque,
decaimiento,sustain y release fueran 0, nunca escucharíamos el sampleo.
Por eso Sonic Pi calcula qué tan largo es el sampleo, deduce su ataque,
decaimiento y tiempo de release, para utilizar esa sumatoria como tiempo
de sustain. Si los valores de ataque, decaimiento y release son mayores al
sampleo, el sustain se vuelve 0, simplemente.

## Apagando (fade out)

Para explorar esto, consideremos nuestra pista Amen break en detalle.
Si le preguntamos a Sonic Pi cuán largo es el sampleo:

```
print sample_duration :loop_amen
```

Imprimirá `1.753310657596372` que es el tamaño del sampleo en segundos.
Consideremos redondearlo a `1.75` por conveniencia. Ahora, si seteamos el
release a `0.75`, algo sorpresivo pasará:

```
sample :loop_amen, release: 0.75
```

Ejecutará el primer segundo del sampleo a amplitud completa antes de
desvanecerse por un periodo de 0.75 segundos. Esto es el *auto
sustain* en acción. Predeterminado, el release siempre trabaja al final
del sampleo. si tu sampleo fuera 10.75 segundos de largo, ejecutaría los
primeros 10 segundos a completa amplitud antes de comenzar a desvanecerse 
por los 0.75 segundos finales.

## Aparecimiento y desvanecimiento (Fade In and Out)


Podemos utilizar tanto el `attack:` como el `release:` juntos con el auto
sustain para aparecer y desvanecer en la duración del sampleo:

```
sample :loop_amen, attack: 0.75, release: 0.75
```
Como la duración total del sampleo + attack + release suman 1.5s, el sustain
queda automáticamente en 0.25s. Esto nos permite aparecer y desvanecer el
sampleo con facilidad.

## Explicit sustain

Podemos fácilmente volver a los parámetros normales de nuestro ADSR de
sintetizador al setear manualmente el `sustain:` a un valor como 0:

```
sample :loop_amen, sustain: 0, release: 0.75
```

Ahora bien, nuestro sampleo suena por 0.75 en total. Los parámetros pre-
determinados para 'attack:` y `decay:` son 0, el sampleo salta directamente
a full amplitud por 0s y después baja a 0 de amplitud por un periodo de 
release de 0.75s

## Percussive cymbals

Podemos utilizar esta conducta a buen efecto para sampleos más largos que
requieran los acortemos y percusivos. Considera el siguiente sampleo:

`:drum_cymbal_open`:

```
sample :drum_cymbal_open
```

Puedes escuchar el sonido del platillo por un periodo de tiempo. Sin embargo,
podemos usar el sobre para hacerlo más percusivo:

```
sample :drum_cymbal_open, attack: 0.01, sustain: 0, release: 0.1
```

Puedes emular el golpeo del platillo y después apagarlo, al incrementar
el periodo de sustain:

```
sample :drum_cymbal_open, attack: 0.01, sustain: 0.3, release: 0.1
```

Ahora ve y diviértete poniendo sobres en los sampleos. Intenta cambiar la
velocidad, también para unos resultados realmente interesantes.
