9.4 Ticking

# Ticking

Algo con lo que seguramente te encontrarás haciendo muchas veces al
hacer live coding es buclear a través de anillos (rings), para poner
notas a melodías, pausas a ritmos, progresiones de acordes, variaciones
timbrales, etc. etc.

## Ticking Anillos

Sonic Pi provee una herramienta muy útil para trabajar con anillos 
dentro de `bucles en vivo`. Se llama el sistema de `tick`, que provee
la habilidad de *tickear a través de anillos*. Veamos un ejemplo:

```
live_loop :arp do
  play (scale :e3, :minor_pentatonic).tick, release: 0.1
  sleep 0.125
end
```

Aquí, simplemente tomamos la escala pentatónica menor de E3 y tickeamos
a cada elemento al añadirles `.tick` al final de la declaración de escala.
Este tick es local al bucle en vivo, por lo que cada bucle debe tener su
propio e independiente tick:

```
live_loop :arp do
  play (scale :e3, :minor_pentatonic).tick, release: 0.1
  sleep 0.125
end

live_loop :arp2 do
  use_synth :dsaw
  play (scale :e2, :minor_pentatonic, num_octaves: 3).tick, release: 0.25
  sleep 0.25
end
```

## Tick

También puedes llamar `tick` como una función estándar y usar el valor como
un índice:

```
live_loop :arp do
  idx = tick
  play (scale :e3, :minor_pentatonic)[idx], release: 0.1
  sleep 0.125
end
```

Sin embargo, es mejor llamar `.tick` al final. La función `tick` está para
cuando quieras hacer cosas sofisticadas con el valor de tick y para cuando
quieras hacer más que indexar dentro de los anillos.


## Mirar

Lo mágico acerca de tick es que no sólo te da un nuevo índice (o el valor 
del anillo en ese índice), sino que también te asegura que al próximo
llamado de tick, será el próximo valor. Mira los documentos para ver
ejemplos de trabajar con `tick` . Sin embargo, por ahora es importante 
notar que a veces querrás mirar al valor tick actual sin que aumente, lo 
cual se logra con la función `look`. La cual puede ser utilizada como una
función estándar o añadiendo `.look` al final de un anillo.
to the end of a ring.

## Nombrando los ticks 

Finalmente, algunas veces necesitarás más de un tick por bucle en vivo.
Esto lo lograrás nombrando a tus ticks:


```
live_loop :arp do
  play (scale :e3, :minor_pentatonic).tick(:foo), release: 0.1
  sleep (ring 0.125, 0.25).tick(:bar)
end
```

Aquí estamos utilizando dos ticks, uno para la nota a ser tocada y otro
para el tiempo de pausa. Como ambos están en el mismo bucle, debemos 
separarlos nombrándolos diferentemente. Es lo mismo que hiciéramos con
`live_loop` - pasamos un símbolo prefijado con un `:`. En el anterior
ejemplo, llamamos a un tick `:foo` y al otro `:bar`. Si queremos mirarlos
sólo debemos pasar el nombre del tick a `look`.

## No lo compliques tanto..

La mayor parte del poder del sistema de tick no es útil al comenzar. No
intentes aprender todo en esta sección, enfócate en el tick de un sólo 
anillo. Eso es lo que más te beneficiará y simplificará tickear dentro de
anillos en `bucles en vivo`.

Mira la documentación de `tick`, donde tienes muchos ejemplos..

