; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-unknown-unknown | FileCheck %s --check-prefixes=SDAG
; RUN: llc < %s -mtriple=aarch64-unknown-unknown -global-isel | FileCheck %s --check-prefixes=GISEL

; These tests are taken from the combine-udiv.ll in X86.
define <8 x i16> @combine_vec_udiv_uniform(<8 x i16> %x) {
; SDAG-LABEL: combine_vec_udiv_uniform:
; SDAG:       // %bb.0:
; SDAG-NEXT:    mov w8, #25645
; SDAG-NEXT:    dup v1.8h, w8
; SDAG-NEXT:    umull2 v2.4s, v0.8h, v1.8h
; SDAG-NEXT:    umull v1.4s, v0.4h, v1.4h
; SDAG-NEXT:    uzp2 v1.8h, v1.8h, v2.8h
; SDAG-NEXT:    sub v0.8h, v0.8h, v1.8h
; SDAG-NEXT:    usra v1.8h, v0.8h, #1
; SDAG-NEXT:    ushr v0.8h, v1.8h, #4
; SDAG-NEXT:    ret
;
; GISEL-LABEL: combine_vec_udiv_uniform:
; GISEL:       // %bb.0:
; GISEL-NEXT:    adrp x8, .LCPI0_0
; GISEL-NEXT:    ldr q1, [x8, :lo12:.LCPI0_0]
; GISEL-NEXT:    umull2 v2.4s, v0.8h, v1.8h
; GISEL-NEXT:    umull v1.4s, v0.4h, v1.4h
; GISEL-NEXT:    uzp2 v1.8h, v1.8h, v2.8h
; GISEL-NEXT:    sub v0.8h, v0.8h, v1.8h
; GISEL-NEXT:    usra v1.8h, v0.8h, #1
; GISEL-NEXT:    ushr v0.8h, v1.8h, #4
; GISEL-NEXT:    ret
  %1 = udiv <8 x i16> %x, <i16 23, i16 23, i16 23, i16 23, i16 23, i16 23, i16 23, i16 23>
  ret <8 x i16> %1
}

define <8 x i16> @combine_vec_udiv_nonuniform(<8 x i16> %x) {
; SDAG-LABEL: combine_vec_udiv_nonuniform:
; SDAG:       // %bb.0:
; SDAG-NEXT:    adrp x8, .LCPI1_0
; SDAG-NEXT:    adrp x9, .LCPI1_1
; SDAG-NEXT:    ldr q1, [x8, :lo12:.LCPI1_0]
; SDAG-NEXT:    adrp x8, .LCPI1_2
; SDAG-NEXT:    ldr q2, [x9, :lo12:.LCPI1_1]
; SDAG-NEXT:    ushl v1.8h, v0.8h, v1.8h
; SDAG-NEXT:    umull2 v3.4s, v1.8h, v2.8h
; SDAG-NEXT:    umull v1.4s, v1.4h, v2.4h
; SDAG-NEXT:    ldr q2, [x8, :lo12:.LCPI1_2]
; SDAG-NEXT:    adrp x8, .LCPI1_3
; SDAG-NEXT:    uzp2 v1.8h, v1.8h, v3.8h
; SDAG-NEXT:    sub v0.8h, v0.8h, v1.8h
; SDAG-NEXT:    umull2 v3.4s, v0.8h, v2.8h
; SDAG-NEXT:    umull v0.4s, v0.4h, v2.4h
; SDAG-NEXT:    ldr q2, [x8, :lo12:.LCPI1_3]
; SDAG-NEXT:    uzp2 v0.8h, v0.8h, v3.8h
; SDAG-NEXT:    add v0.8h, v0.8h, v1.8h
; SDAG-NEXT:    ushl v0.8h, v0.8h, v2.8h
; SDAG-NEXT:    ret
;
; GISEL-LABEL: combine_vec_udiv_nonuniform:
; GISEL:       // %bb.0:
; GISEL-NEXT:    adrp x8, .LCPI1_4
; GISEL-NEXT:    adrp x9, .LCPI1_5
; GISEL-NEXT:    ldr q1, [x8, :lo12:.LCPI1_4]
; GISEL-NEXT:    adrp x8, .LCPI1_3
; GISEL-NEXT:    neg v1.8h, v1.8h
; GISEL-NEXT:    ldr q2, [x8, :lo12:.LCPI1_3]
; GISEL-NEXT:    adrp x8, .LCPI1_2
; GISEL-NEXT:    ushl v1.8h, v0.8h, v1.8h
; GISEL-NEXT:    umull2 v3.4s, v1.8h, v2.8h
; GISEL-NEXT:    umull v1.4s, v1.4h, v2.4h
; GISEL-NEXT:    ldr q2, [x8, :lo12:.LCPI1_2]
; GISEL-NEXT:    adrp x8, .LCPI1_1
; GISEL-NEXT:    uzp2 v1.8h, v1.8h, v3.8h
; GISEL-NEXT:    sub v3.8h, v0.8h, v1.8h
; GISEL-NEXT:    umull2 v4.4s, v3.8h, v2.8h
; GISEL-NEXT:    umull v2.4s, v3.4h, v2.4h
; GISEL-NEXT:    ldr q3, [x8, :lo12:.LCPI1_1]
; GISEL-NEXT:    adrp x8, .LCPI1_0
; GISEL-NEXT:    neg v3.8h, v3.8h
; GISEL-NEXT:    uzp2 v2.8h, v2.8h, v4.8h
; GISEL-NEXT:    ldr q4, [x9, :lo12:.LCPI1_5]
; GISEL-NEXT:    ldr q5, [x8, :lo12:.LCPI1_0]
; GISEL-NEXT:    add v1.8h, v2.8h, v1.8h
; GISEL-NEXT:    cmeq v2.8h, v4.8h, v5.8h
; GISEL-NEXT:    ushl v1.8h, v1.8h, v3.8h
; GISEL-NEXT:    bif v0.16b, v1.16b, v2.16b
; GISEL-NEXT:    ret
  %1 = udiv <8 x i16> %x, <i16 23, i16 34, i16 -23, i16 56, i16 128, i16 -1, i16 -256, i16 -32768>
  ret <8 x i16> %1
}

define <8 x i16> @combine_vec_udiv_nonuniform2(<8 x i16> %x) {
; SDAG-LABEL: combine_vec_udiv_nonuniform2:
; SDAG:       // %bb.0:
; SDAG-NEXT:    adrp x8, .LCPI2_0
; SDAG-NEXT:    adrp x9, .LCPI2_1
; SDAG-NEXT:    ldr q1, [x8, :lo12:.LCPI2_0]
; SDAG-NEXT:    adrp x8, .LCPI2_2
; SDAG-NEXT:    ldr q2, [x9, :lo12:.LCPI2_1]
; SDAG-NEXT:    ushl v0.8h, v0.8h, v1.8h
; SDAG-NEXT:    umull2 v1.4s, v0.8h, v2.8h
; SDAG-NEXT:    umull v0.4s, v0.4h, v2.4h
; SDAG-NEXT:    uzp2 v0.8h, v0.8h, v1.8h
; SDAG-NEXT:    ldr q1, [x8, :lo12:.LCPI2_2]
; SDAG-NEXT:    ushl v0.8h, v0.8h, v1.8h
; SDAG-NEXT:    ret
;
; GISEL-LABEL: combine_vec_udiv_nonuniform2:
; GISEL:       // %bb.0:
; GISEL-NEXT:    adrp x8, .LCPI2_3
; GISEL-NEXT:    adrp x9, .LCPI2_1
; GISEL-NEXT:    ldr q1, [x8, :lo12:.LCPI2_3]
; GISEL-NEXT:    adrp x8, .LCPI2_2
; GISEL-NEXT:    ldr q4, [x9, :lo12:.LCPI2_1]
; GISEL-NEXT:    neg v1.8h, v1.8h
; GISEL-NEXT:    ldr q2, [x8, :lo12:.LCPI2_2]
; GISEL-NEXT:    adrp x8, .LCPI2_4
; GISEL-NEXT:    ushl v1.8h, v0.8h, v1.8h
; GISEL-NEXT:    neg v4.8h, v4.8h
; GISEL-NEXT:    umull2 v3.4s, v1.8h, v2.8h
; GISEL-NEXT:    umull v1.4s, v1.4h, v2.4h
; GISEL-NEXT:    ldr q2, [x8, :lo12:.LCPI2_4]
; GISEL-NEXT:    adrp x8, .LCPI2_0
; GISEL-NEXT:    uzp2 v1.8h, v1.8h, v3.8h
; GISEL-NEXT:    ldr q3, [x8, :lo12:.LCPI2_0]
; GISEL-NEXT:    cmeq v2.8h, v2.8h, v3.8h
; GISEL-NEXT:    ushl v1.8h, v1.8h, v4.8h
; GISEL-NEXT:    bif v0.16b, v1.16b, v2.16b
; GISEL-NEXT:    ret
  %1 = udiv <8 x i16> %x, <i16 -34, i16 35, i16 36, i16 -37, i16 38, i16 -39, i16 40, i16 -41>
  ret <8 x i16> %1
}

define <8 x i16> @combine_vec_udiv_nonuniform3(<8 x i16> %x) {
; SDAG-LABEL: combine_vec_udiv_nonuniform3:
; SDAG:       // %bb.0:
; SDAG-NEXT:    adrp x8, .LCPI3_0
; SDAG-NEXT:    ldr q1, [x8, :lo12:.LCPI3_0]
; SDAG-NEXT:    adrp x8, .LCPI3_1
; SDAG-NEXT:    umull2 v2.4s, v0.8h, v1.8h
; SDAG-NEXT:    umull v1.4s, v0.4h, v1.4h
; SDAG-NEXT:    uzp2 v1.8h, v1.8h, v2.8h
; SDAG-NEXT:    sub v0.8h, v0.8h, v1.8h
; SDAG-NEXT:    usra v1.8h, v0.8h, #1
; SDAG-NEXT:    ldr q0, [x8, :lo12:.LCPI3_1]
; SDAG-NEXT:    ushl v0.8h, v1.8h, v0.8h
; SDAG-NEXT:    ret
;
; GISEL-LABEL: combine_vec_udiv_nonuniform3:
; GISEL:       // %bb.0:
; GISEL-NEXT:    adrp x8, .LCPI3_2
; GISEL-NEXT:    adrp x9, .LCPI3_3
; GISEL-NEXT:    ldr q1, [x8, :lo12:.LCPI3_2]
; GISEL-NEXT:    adrp x8, .LCPI3_1
; GISEL-NEXT:    ldr q4, [x9, :lo12:.LCPI3_3]
; GISEL-NEXT:    umull2 v2.4s, v0.8h, v1.8h
; GISEL-NEXT:    umull v1.4s, v0.4h, v1.4h
; GISEL-NEXT:    uzp2 v1.8h, v1.8h, v2.8h
; GISEL-NEXT:    ldr q2, [x8, :lo12:.LCPI3_1]
; GISEL-NEXT:    adrp x8, .LCPI3_0
; GISEL-NEXT:    neg v2.8h, v2.8h
; GISEL-NEXT:    sub v3.8h, v0.8h, v1.8h
; GISEL-NEXT:    usra v1.8h, v3.8h, #1
; GISEL-NEXT:    ldr q3, [x8, :lo12:.LCPI3_0]
; GISEL-NEXT:    ushl v1.8h, v1.8h, v2.8h
; GISEL-NEXT:    cmeq v2.8h, v4.8h, v3.8h
; GISEL-NEXT:    bif v0.16b, v1.16b, v2.16b
; GISEL-NEXT:    ret
  %1 = udiv <8 x i16> %x, <i16 7, i16 23, i16 25, i16 27, i16 31, i16 47, i16 63, i16 127>
  ret <8 x i16> %1
}

define <16 x i8> @combine_vec_udiv_nonuniform4(<16 x i8> %x) {
; SDAG-LABEL: combine_vec_udiv_nonuniform4:
; SDAG:       // %bb.0:
; SDAG-NEXT:    adrp x8, .LCPI4_0
; SDAG-NEXT:    adrp x9, .LCPI4_2
; SDAG-NEXT:    ldr q1, [x8, :lo12:.LCPI4_0]
; SDAG-NEXT:    adrp x8, .LCPI4_1
; SDAG-NEXT:    ldr q3, [x9, :lo12:.LCPI4_2]
; SDAG-NEXT:    umull2 v2.8h, v0.16b, v1.16b
; SDAG-NEXT:    umull v1.8h, v0.8b, v1.8b
; SDAG-NEXT:    uzp2 v1.16b, v1.16b, v2.16b
; SDAG-NEXT:    ldr q2, [x8, :lo12:.LCPI4_1]
; SDAG-NEXT:    adrp x8, .LCPI4_3
; SDAG-NEXT:    ushl v1.16b, v1.16b, v2.16b
; SDAG-NEXT:    ldr q2, [x8, :lo12:.LCPI4_3]
; SDAG-NEXT:    and v1.16b, v1.16b, v3.16b
; SDAG-NEXT:    and v0.16b, v0.16b, v2.16b
; SDAG-NEXT:    orr v0.16b, v0.16b, v1.16b
; SDAG-NEXT:    ret
;
; GISEL-LABEL: combine_vec_udiv_nonuniform4:
; GISEL:       // %bb.0:
; GISEL-NEXT:    adrp x8, .LCPI4_2
; GISEL-NEXT:    adrp x9, .LCPI4_1
; GISEL-NEXT:    ldr q1, [x8, :lo12:.LCPI4_2]
; GISEL-NEXT:    adrp x8, .LCPI4_3
; GISEL-NEXT:    ldr q4, [x9, :lo12:.LCPI4_1]
; GISEL-NEXT:    umull2 v2.8h, v0.16b, v1.16b
; GISEL-NEXT:    ldr q3, [x8, :lo12:.LCPI4_3]
; GISEL-NEXT:    umull v1.8h, v0.8b, v1.8b
; GISEL-NEXT:    adrp x8, .LCPI4_0
; GISEL-NEXT:    neg v4.16b, v4.16b
; GISEL-NEXT:    uzp2 v1.16b, v1.16b, v2.16b
; GISEL-NEXT:    ldr q2, [x8, :lo12:.LCPI4_0]
; GISEL-NEXT:    cmeq v2.16b, v3.16b, v2.16b
; GISEL-NEXT:    ushl v1.16b, v1.16b, v4.16b
; GISEL-NEXT:    bif v0.16b, v1.16b, v2.16b
; GISEL-NEXT:    ret
  %div = udiv <16 x i8> %x, <i8 -64, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  ret <16 x i8> %div
}

define <8 x i16> @pr38477(<8 x i16> %a0) {
; SDAG-LABEL: pr38477:
; SDAG:       // %bb.0:
; SDAG-NEXT:    adrp x8, .LCPI5_0
; SDAG-NEXT:    adrp x9, .LCPI5_3
; SDAG-NEXT:    ldr q1, [x8, :lo12:.LCPI5_0]
; SDAG-NEXT:    adrp x8, .LCPI5_1
; SDAG-NEXT:    umull2 v2.4s, v0.8h, v1.8h
; SDAG-NEXT:    umull v1.4s, v0.4h, v1.4h
; SDAG-NEXT:    uzp2 v1.8h, v1.8h, v2.8h
; SDAG-NEXT:    ldr q2, [x8, :lo12:.LCPI5_1]
; SDAG-NEXT:    adrp x8, .LCPI5_2
; SDAG-NEXT:    sub v3.8h, v0.8h, v1.8h
; SDAG-NEXT:    umull2 v4.4s, v3.8h, v2.8h
; SDAG-NEXT:    umull v2.4s, v3.4h, v2.4h
; SDAG-NEXT:    ldr q3, [x8, :lo12:.LCPI5_2]
; SDAG-NEXT:    adrp x8, .LCPI5_4
; SDAG-NEXT:    uzp2 v2.8h, v2.8h, v4.8h
; SDAG-NEXT:    ldr q4, [x9, :lo12:.LCPI5_3]
; SDAG-NEXT:    add v1.8h, v2.8h, v1.8h
; SDAG-NEXT:    ldr q2, [x8, :lo12:.LCPI5_4]
; SDAG-NEXT:    ushl v1.8h, v1.8h, v3.8h
; SDAG-NEXT:    and v0.16b, v0.16b, v2.16b
; SDAG-NEXT:    and v1.16b, v1.16b, v4.16b
; SDAG-NEXT:    orr v0.16b, v0.16b, v1.16b
; SDAG-NEXT:    ret
;
; GISEL-LABEL: pr38477:
; GISEL:       // %bb.0:
; GISEL-NEXT:    adrp x8, .LCPI5_3
; GISEL-NEXT:    adrp x9, .LCPI5_4
; GISEL-NEXT:    ldr q1, [x8, :lo12:.LCPI5_3]
; GISEL-NEXT:    adrp x8, .LCPI5_2
; GISEL-NEXT:    umull2 v2.4s, v0.8h, v1.8h
; GISEL-NEXT:    umull v1.4s, v0.4h, v1.4h
; GISEL-NEXT:    uzp2 v1.8h, v1.8h, v2.8h
; GISEL-NEXT:    ldr q2, [x8, :lo12:.LCPI5_2]
; GISEL-NEXT:    adrp x8, .LCPI5_1
; GISEL-NEXT:    sub v3.8h, v0.8h, v1.8h
; GISEL-NEXT:    umull2 v4.4s, v3.8h, v2.8h
; GISEL-NEXT:    umull v2.4s, v3.4h, v2.4h
; GISEL-NEXT:    ldr q3, [x8, :lo12:.LCPI5_1]
; GISEL-NEXT:    adrp x8, .LCPI5_0
; GISEL-NEXT:    neg v3.8h, v3.8h
; GISEL-NEXT:    uzp2 v2.8h, v2.8h, v4.8h
; GISEL-NEXT:    ldr q4, [x9, :lo12:.LCPI5_4]
; GISEL-NEXT:    ldr q5, [x8, :lo12:.LCPI5_0]
; GISEL-NEXT:    add v1.8h, v2.8h, v1.8h
; GISEL-NEXT:    cmeq v2.8h, v4.8h, v5.8h
; GISEL-NEXT:    ushl v1.8h, v1.8h, v3.8h
; GISEL-NEXT:    bif v0.16b, v1.16b, v2.16b
; GISEL-NEXT:    ret
  %1 = udiv <8 x i16> %a0, <i16 1, i16 119, i16 73, i16 -111, i16 -3, i16 118, i16 32, i16 31>
  ret <8 x i16> %1
}
