; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mattr=+rop-protect < %s | FileCheck %s --check-prefix LE-P10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mattr=+rop-protect < %s | FileCheck %s --check-prefix LE-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mattr=+rop-protect < %s | FileCheck %s --check-prefix LE-P8
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mattr=+rop-protect -O0 < %s | FileCheck %s --check-prefix LE-P10-O0
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mattr=+rop-protect -O0 < %s | FileCheck %s --check-prefix LE-P9-O0
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mattr=+rop-protect -O0 < %s | FileCheck %s --check-prefix LE-P8-O0
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mattr=+rop-protect < %s | FileCheck %s --check-prefix BE-P10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mattr=+rop-protect < %s | FileCheck %s --check-prefix BE-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mattr=+rop-protect < %s | FileCheck %s --check-prefix BE-P8
; RUN: llc -verify-machineinstrs -mtriple=powerpc-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mattr=+rop-protect < %s | FileCheck %s --check-prefix BE-32BIT-P10
; RUN: llc -verify-machineinstrs -mtriple=powerpc-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mattr=+rop-protect < %s | FileCheck %s --check-prefix BE-32BIT-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mattr=+rop-protect < %s | FileCheck %s --check-prefix BE-32BIT-P8
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mattr=+rop-protect -mattr=+privileged < %s | FileCheck %s --check-prefix LE-P10-PRIV
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mattr=+rop-protect -mattr=+privileged < %s | FileCheck %s --check-prefix LE-P9-PRIV
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mattr=+rop-protect -mattr=+privileged < %s | FileCheck %s --check-prefix LE-P8-PRIV
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mattr=+rop-protect -mattr=+privileged < %s | FileCheck %s --check-prefix BE-P10-PRIV
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mattr=+rop-protect -mattr=+privileged < %s | FileCheck %s --check-prefix BE-P9-PRIV
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mattr=+rop-protect -mattr=+privileged < %s | FileCheck %s --check-prefix BE-P8-PRIV



;; This test checks that the ROP protect instructions have been correctly
;; added when the ROP protect option has been specified. The hashst
;; instruction should be added to the prologue and the hashchk should be added
;; to the epilogue.

define dso_local zeroext i32 @caller(i32 zeroext %in, i32 zeroext %add_after) #0 {
; LE-P10-LABEL: caller:
; LE-P10:       # %bb.0: # %entry
; LE-P10-NEXT:    mflr r0
; LE-P10-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r0, 16(r1)
; LE-P10-NEXT:    hashst r0, -24(r1)
; LE-P10-NEXT:    stdu r1, -64(r1)
; LE-P10-NEXT:    mr r30, r4
; LE-P10-NEXT:    bl callee@notoc
; LE-P10-NEXT:    add r3, r3, r30
; LE-P10-NEXT:    clrldi r3, r3, 32
; LE-P10-NEXT:    addi r1, r1, 64
; LE-P10-NEXT:    ld r0, 16(r1)
; LE-P10-NEXT:    hashchk r0, -24(r1)
; LE-P10-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    mtlr r0
; LE-P10-NEXT:    blr
;
; LE-P9-LABEL: caller:
; LE-P9:       # %bb.0: # %entry
; LE-P9-NEXT:    mflr r0
; LE-P9-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    std r0, 16(r1)
; LE-P9-NEXT:    hashst r0, -24(r1)
; LE-P9-NEXT:    stdu r1, -64(r1)
; LE-P9-NEXT:    mr r30, r4
; LE-P9-NEXT:    bl callee
; LE-P9-NEXT:    nop
; LE-P9-NEXT:    add r3, r3, r30
; LE-P9-NEXT:    clrldi r3, r3, 32
; LE-P9-NEXT:    addi r1, r1, 64
; LE-P9-NEXT:    ld r0, 16(r1)
; LE-P9-NEXT:    mtlr r0
; LE-P9-NEXT:    hashchk r0, -24(r1)
; LE-P9-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    blr
;
; LE-P8-LABEL: caller:
; LE-P8:       # %bb.0: # %entry
; LE-P8-NEXT:    mflr r0
; LE-P8-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    std r0, 16(r1)
; LE-P8-NEXT:    hashst r0, -24(r1)
; LE-P8-NEXT:    stdu r1, -64(r1)
; LE-P8-NEXT:    mr r30, r4
; LE-P8-NEXT:    bl callee
; LE-P8-NEXT:    nop
; LE-P8-NEXT:    add r3, r3, r30
; LE-P8-NEXT:    clrldi r3, r3, 32
; LE-P8-NEXT:    addi r1, r1, 64
; LE-P8-NEXT:    ld r0, 16(r1)
; LE-P8-NEXT:    hashchk r0, -24(r1)
; LE-P8-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    mtlr r0
; LE-P8-NEXT:    blr
;
; LE-P10-O0-LABEL: caller:
; LE-P10-O0:       # %bb.0: # %entry
; LE-P10-O0-NEXT:    mflr r0
; LE-P10-O0-NEXT:    std r0, 16(r1)
; LE-P10-O0-NEXT:    hashst r0, -8(r1)
; LE-P10-O0-NEXT:    stdu r1, -48(r1)
; LE-P10-O0-NEXT:    # kill: def $r4 killed $r4 killed $x4
; LE-P10-O0-NEXT:    stw r4, 36(r1) # 4-byte Folded Spill
; LE-P10-O0-NEXT:    mr r4, r3
; LE-P10-O0-NEXT:    # implicit-def: $x3
; LE-P10-O0-NEXT:    mr r3, r4
; LE-P10-O0-NEXT:    clrldi r3, r3, 32
; LE-P10-O0-NEXT:    bl callee@notoc
; LE-P10-O0-NEXT:    lwz r4, 36(r1) # 4-byte Folded Reload
; LE-P10-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; LE-P10-O0-NEXT:    add r3, r3, r4
; LE-P10-O0-NEXT:    clrldi r3, r3, 32
; LE-P10-O0-NEXT:    addi r1, r1, 48
; LE-P10-O0-NEXT:    ld r0, 16(r1)
; LE-P10-O0-NEXT:    hashchk r0, -8(r1)
; LE-P10-O0-NEXT:    mtlr r0
; LE-P10-O0-NEXT:    blr
;
; LE-P9-O0-LABEL: caller:
; LE-P9-O0:       # %bb.0: # %entry
; LE-P9-O0-NEXT:    mflr r0
; LE-P9-O0-NEXT:    std r0, 16(r1)
; LE-P9-O0-NEXT:    hashst r0, -8(r1)
; LE-P9-O0-NEXT:    stdu r1, -112(r1)
; LE-P9-O0-NEXT:    # kill: def $r4 killed $r4 killed $x4
; LE-P9-O0-NEXT:    stw r4, 100(r1) # 4-byte Folded Spill
; LE-P9-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; LE-P9-O0-NEXT:    clrldi r3, r3, 32
; LE-P9-O0-NEXT:    bl callee
; LE-P9-O0-NEXT:    nop
; LE-P9-O0-NEXT:    lwz r4, 100(r1) # 4-byte Folded Reload
; LE-P9-O0-NEXT:    add r3, r3, r4
; LE-P9-O0-NEXT:    clrldi r3, r3, 32
; LE-P9-O0-NEXT:    addi r1, r1, 112
; LE-P9-O0-NEXT:    ld r0, 16(r1)
; LE-P9-O0-NEXT:    hashchk r0, -8(r1)
; LE-P9-O0-NEXT:    mtlr r0
; LE-P9-O0-NEXT:    blr
;
; LE-P8-O0-LABEL: caller:
; LE-P8-O0:       # %bb.0: # %entry
; LE-P8-O0-NEXT:    mflr r0
; LE-P8-O0-NEXT:    std r0, 16(r1)
; LE-P8-O0-NEXT:    hashst r0, -8(r1)
; LE-P8-O0-NEXT:    stdu r1, -112(r1)
; LE-P8-O0-NEXT:    # kill: def $r4 killed $r4 killed $x4
; LE-P8-O0-NEXT:    stw r4, 100(r1) # 4-byte Folded Spill
; LE-P8-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; LE-P8-O0-NEXT:    clrldi r3, r3, 32
; LE-P8-O0-NEXT:    bl callee
; LE-P8-O0-NEXT:    nop
; LE-P8-O0-NEXT:    lwz r4, 100(r1) # 4-byte Folded Reload
; LE-P8-O0-NEXT:    add r3, r3, r4
; LE-P8-O0-NEXT:    clrldi r3, r3, 32
; LE-P8-O0-NEXT:    addi r1, r1, 112
; LE-P8-O0-NEXT:    ld r0, 16(r1)
; LE-P8-O0-NEXT:    hashchk r0, -8(r1)
; LE-P8-O0-NEXT:    mtlr r0
; LE-P8-O0-NEXT:    blr
;
; BE-P10-LABEL: caller:
; BE-P10:       # %bb.0: # %entry
; BE-P10-NEXT:    mflr r0
; BE-P10-NEXT:    std r0, 16(r1)
; BE-P10-NEXT:    hashst r0, -24(r1)
; BE-P10-NEXT:    stdu r1, -144(r1)
; BE-P10-NEXT:    std r30, 128(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    mr r30, r4
; BE-P10-NEXT:    bl callee
; BE-P10-NEXT:    nop
; BE-P10-NEXT:    add r3, r3, r30
; BE-P10-NEXT:    ld r30, 128(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    clrldi r3, r3, 32
; BE-P10-NEXT:    addi r1, r1, 144
; BE-P10-NEXT:    ld r0, 16(r1)
; BE-P10-NEXT:    hashchk r0, -24(r1)
; BE-P10-NEXT:    mtlr r0
; BE-P10-NEXT:    blr
;
; BE-P9-LABEL: caller:
; BE-P9:       # %bb.0: # %entry
; BE-P9-NEXT:    mflr r0
; BE-P9-NEXT:    std r0, 16(r1)
; BE-P9-NEXT:    hashst r0, -24(r1)
; BE-P9-NEXT:    stdu r1, -144(r1)
; BE-P9-NEXT:    std r30, 128(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    mr r30, r4
; BE-P9-NEXT:    bl callee
; BE-P9-NEXT:    nop
; BE-P9-NEXT:    add r3, r3, r30
; BE-P9-NEXT:    ld r30, 128(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    clrldi r3, r3, 32
; BE-P9-NEXT:    addi r1, r1, 144
; BE-P9-NEXT:    ld r0, 16(r1)
; BE-P9-NEXT:    mtlr r0
; BE-P9-NEXT:    hashchk r0, -24(r1)
; BE-P9-NEXT:    blr
;
; BE-P8-LABEL: caller:
; BE-P8:       # %bb.0: # %entry
; BE-P8-NEXT:    mflr r0
; BE-P8-NEXT:    std r0, 16(r1)
; BE-P8-NEXT:    hashst r0, -24(r1)
; BE-P8-NEXT:    stdu r1, -144(r1)
; BE-P8-NEXT:    std r30, 128(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    mr r30, r4
; BE-P8-NEXT:    bl callee
; BE-P8-NEXT:    nop
; BE-P8-NEXT:    add r3, r3, r30
; BE-P8-NEXT:    ld r30, 128(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    clrldi r3, r3, 32
; BE-P8-NEXT:    addi r1, r1, 144
; BE-P8-NEXT:    ld r0, 16(r1)
; BE-P8-NEXT:    hashchk r0, -24(r1)
; BE-P8-NEXT:    mtlr r0
; BE-P8-NEXT:    blr
;
; BE-32BIT-P10-LABEL: caller:
; BE-32BIT-P10:       # %bb.0: # %entry
; BE-32BIT-P10-NEXT:    mflr r0
; BE-32BIT-P10-NEXT:    stw r0, 4(r1)
; BE-32BIT-P10-NEXT:    hashst r0, -16(r1)
; BE-32BIT-P10-NEXT:    stwu r1, -32(r1)
; BE-32BIT-P10-NEXT:    stw r30, 24(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    mr r30, r4
; BE-32BIT-P10-NEXT:    bl callee
; BE-32BIT-P10-NEXT:    add r3, r3, r30
; BE-32BIT-P10-NEXT:    lwz r30, 24(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r0, 36(r1)
; BE-32BIT-P10-NEXT:    addi r1, r1, 32
; BE-32BIT-P10-NEXT:    hashchk r0, -16(r1)
; BE-32BIT-P10-NEXT:    mtlr r0
; BE-32BIT-P10-NEXT:    blr
;
; BE-32BIT-P9-LABEL: caller:
; BE-32BIT-P9:       # %bb.0: # %entry
; BE-32BIT-P9-NEXT:    mflr r0
; BE-32BIT-P9-NEXT:    stw r0, 4(r1)
; BE-32BIT-P9-NEXT:    hashst r0, -16(r1)
; BE-32BIT-P9-NEXT:    stwu r1, -32(r1)
; BE-32BIT-P9-NEXT:    stw r30, 24(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    mr r30, r4
; BE-32BIT-P9-NEXT:    bl callee
; BE-32BIT-P9-NEXT:    add r3, r3, r30
; BE-32BIT-P9-NEXT:    lwz r30, 24(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r0, 36(r1)
; BE-32BIT-P9-NEXT:    addi r1, r1, 32
; BE-32BIT-P9-NEXT:    mtlr r0
; BE-32BIT-P9-NEXT:    hashchk r0, -16(r1)
; BE-32BIT-P9-NEXT:    blr
;
; BE-32BIT-P8-LABEL: caller:
; BE-32BIT-P8:       # %bb.0: # %entry
; BE-32BIT-P8-NEXT:    mflr r0
; BE-32BIT-P8-NEXT:    stw r0, 4(r1)
; BE-32BIT-P8-NEXT:    hashst r0, -16(r1)
; BE-32BIT-P8-NEXT:    stwu r1, -32(r1)
; BE-32BIT-P8-NEXT:    stw r30, 24(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    mr r30, r4
; BE-32BIT-P8-NEXT:    bl callee
; BE-32BIT-P8-NEXT:    add r3, r3, r30
; BE-32BIT-P8-NEXT:    lwz r30, 24(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r0, 36(r1)
; BE-32BIT-P8-NEXT:    addi r1, r1, 32
; BE-32BIT-P8-NEXT:    mtlr r0
; BE-32BIT-P8-NEXT:    hashchk r0, -16(r1)
; BE-32BIT-P8-NEXT:    blr
;
; LE-P10-PRIV-LABEL: caller:
; LE-P10-PRIV:       # %bb.0: # %entry
; LE-P10-PRIV-NEXT:    mflr r0
; LE-P10-PRIV-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r0, 16(r1)
; LE-P10-PRIV-NEXT:    hashstp r0, -24(r1)
; LE-P10-PRIV-NEXT:    stdu r1, -64(r1)
; LE-P10-PRIV-NEXT:    mr r30, r4
; LE-P10-PRIV-NEXT:    bl callee@notoc
; LE-P10-PRIV-NEXT:    add r3, r3, r30
; LE-P10-PRIV-NEXT:    clrldi r3, r3, 32
; LE-P10-PRIV-NEXT:    addi r1, r1, 64
; LE-P10-PRIV-NEXT:    ld r0, 16(r1)
; LE-P10-PRIV-NEXT:    hashchkp r0, -24(r1)
; LE-P10-PRIV-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    mtlr r0
; LE-P10-PRIV-NEXT:    blr
;
; LE-P9-PRIV-LABEL: caller:
; LE-P9-PRIV:       # %bb.0: # %entry
; LE-P9-PRIV-NEXT:    mflr r0
; LE-P9-PRIV-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r0, 16(r1)
; LE-P9-PRIV-NEXT:    hashstp r0, -24(r1)
; LE-P9-PRIV-NEXT:    stdu r1, -64(r1)
; LE-P9-PRIV-NEXT:    mr r30, r4
; LE-P9-PRIV-NEXT:    bl callee
; LE-P9-PRIV-NEXT:    nop
; LE-P9-PRIV-NEXT:    add r3, r3, r30
; LE-P9-PRIV-NEXT:    clrldi r3, r3, 32
; LE-P9-PRIV-NEXT:    addi r1, r1, 64
; LE-P9-PRIV-NEXT:    ld r0, 16(r1)
; LE-P9-PRIV-NEXT:    mtlr r0
; LE-P9-PRIV-NEXT:    hashchkp r0, -24(r1)
; LE-P9-PRIV-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    blr
;
; LE-P8-PRIV-LABEL: caller:
; LE-P8-PRIV:       # %bb.0: # %entry
; LE-P8-PRIV-NEXT:    mflr r0
; LE-P8-PRIV-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    std r0, 16(r1)
; LE-P8-PRIV-NEXT:    hashstp r0, -24(r1)
; LE-P8-PRIV-NEXT:    stdu r1, -64(r1)
; LE-P8-PRIV-NEXT:    mr r30, r4
; LE-P8-PRIV-NEXT:    bl callee
; LE-P8-PRIV-NEXT:    nop
; LE-P8-PRIV-NEXT:    add r3, r3, r30
; LE-P8-PRIV-NEXT:    clrldi r3, r3, 32
; LE-P8-PRIV-NEXT:    addi r1, r1, 64
; LE-P8-PRIV-NEXT:    ld r0, 16(r1)
; LE-P8-PRIV-NEXT:    hashchkp r0, -24(r1)
; LE-P8-PRIV-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    mtlr r0
; LE-P8-PRIV-NEXT:    blr
;
; BE-P10-PRIV-LABEL: caller:
; BE-P10-PRIV:       # %bb.0: # %entry
; BE-P10-PRIV-NEXT:    mflr r0
; BE-P10-PRIV-NEXT:    std r0, 16(r1)
; BE-P10-PRIV-NEXT:    hashstp r0, -24(r1)
; BE-P10-PRIV-NEXT:    stdu r1, -144(r1)
; BE-P10-PRIV-NEXT:    std r30, 128(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    mr r30, r4
; BE-P10-PRIV-NEXT:    bl callee
; BE-P10-PRIV-NEXT:    nop
; BE-P10-PRIV-NEXT:    add r3, r3, r30
; BE-P10-PRIV-NEXT:    ld r30, 128(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    clrldi r3, r3, 32
; BE-P10-PRIV-NEXT:    addi r1, r1, 144
; BE-P10-PRIV-NEXT:    ld r0, 16(r1)
; BE-P10-PRIV-NEXT:    hashchkp r0, -24(r1)
; BE-P10-PRIV-NEXT:    mtlr r0
; BE-P10-PRIV-NEXT:    blr
;
; BE-P9-PRIV-LABEL: caller:
; BE-P9-PRIV:       # %bb.0: # %entry
; BE-P9-PRIV-NEXT:    mflr r0
; BE-P9-PRIV-NEXT:    std r0, 16(r1)
; BE-P9-PRIV-NEXT:    hashstp r0, -24(r1)
; BE-P9-PRIV-NEXT:    stdu r1, -144(r1)
; BE-P9-PRIV-NEXT:    std r30, 128(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    mr r30, r4
; BE-P9-PRIV-NEXT:    bl callee
; BE-P9-PRIV-NEXT:    nop
; BE-P9-PRIV-NEXT:    add r3, r3, r30
; BE-P9-PRIV-NEXT:    ld r30, 128(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    clrldi r3, r3, 32
; BE-P9-PRIV-NEXT:    addi r1, r1, 144
; BE-P9-PRIV-NEXT:    ld r0, 16(r1)
; BE-P9-PRIV-NEXT:    mtlr r0
; BE-P9-PRIV-NEXT:    hashchkp r0, -24(r1)
; BE-P9-PRIV-NEXT:    blr
;
; BE-P8-PRIV-LABEL: caller:
; BE-P8-PRIV:       # %bb.0: # %entry
; BE-P8-PRIV-NEXT:    mflr r0
; BE-P8-PRIV-NEXT:    std r0, 16(r1)
; BE-P8-PRIV-NEXT:    hashstp r0, -24(r1)
; BE-P8-PRIV-NEXT:    stdu r1, -144(r1)
; BE-P8-PRIV-NEXT:    std r30, 128(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    mr r30, r4
; BE-P8-PRIV-NEXT:    bl callee
; BE-P8-PRIV-NEXT:    nop
; BE-P8-PRIV-NEXT:    add r3, r3, r30
; BE-P8-PRIV-NEXT:    ld r30, 128(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    clrldi r3, r3, 32
; BE-P8-PRIV-NEXT:    addi r1, r1, 144
; BE-P8-PRIV-NEXT:    ld r0, 16(r1)
; BE-P8-PRIV-NEXT:    hashchkp r0, -24(r1)
; BE-P8-PRIV-NEXT:    mtlr r0
; BE-P8-PRIV-NEXT:    blr
entry:
  %call = tail call zeroext i32 @callee(i32 zeroext %in)
  %add = add i32 %call, %add_after
  ret i32 %add
}

;; NOTE: This test is technically a violation of the ABI. The hash is saved
;; outside of the initial 288 byte volatile program storage region in the
;; Protected Zone. However, this restriction will be removed in an upcoming
;; revision of the ABI.
define dso_local zeroext i32 @spill(ptr nocapture readonly %in) #0 {
; LE-P10-LABEL: spill:
; LE-P10:       # %bb.0: # %entry
; LE-P10-NEXT:    mflr r0
; LE-P10-NEXT:    mfcr r12
; LE-P10-NEXT:    std r0, 16(r1)
; LE-P10-NEXT:    hashst r0, -488(r1)
; LE-P10-NEXT:    stw r12, 8(r1)
; LE-P10-NEXT:    stdu r1, -544(r1)
; LE-P10-NEXT:    lwz r4, 12(r3)
; LE-P10-NEXT:    std r14, 256(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r15, 264(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r16, 272(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r17, 280(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r18, 288(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r19, 296(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r20, 304(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r21, 312(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r22, 320(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r23, 328(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r24, 336(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r25, 344(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r26, 352(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r27, 360(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r28, 368(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r29, 376(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r30, 384(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r31, 392(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stfd f14, 400(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stfd f15, 408(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stfd f16, 416(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stfd f17, 424(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stfd f18, 432(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stfd f19, 440(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stfd f20, 448(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stfd f21, 456(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stfd f22, 464(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stfd f23, 472(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stfd f24, 480(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stfd f25, 488(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stfd f26, 496(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stfd f27, 504(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stfd f28, 512(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stfd f29, 520(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stfd f30, 528(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stfd f31, 536(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stxv v20, 64(r1) # 16-byte Folded Spill
; LE-P10-NEXT:    stxv v21, 80(r1) # 16-byte Folded Spill
; LE-P10-NEXT:    stxv v22, 96(r1) # 16-byte Folded Spill
; LE-P10-NEXT:    stxv v23, 112(r1) # 16-byte Folded Spill
; LE-P10-NEXT:    stxv v24, 128(r1) # 16-byte Folded Spill
; LE-P10-NEXT:    stxv v25, 144(r1) # 16-byte Folded Spill
; LE-P10-NEXT:    stxv v26, 160(r1) # 16-byte Folded Spill
; LE-P10-NEXT:    stxv v27, 176(r1) # 16-byte Folded Spill
; LE-P10-NEXT:    stxv v28, 192(r1) # 16-byte Folded Spill
; LE-P10-NEXT:    stxv v29, 208(r1) # 16-byte Folded Spill
; LE-P10-NEXT:    stxv v30, 224(r1) # 16-byte Folded Spill
; LE-P10-NEXT:    stxv v31, 240(r1) # 16-byte Folded Spill
; LE-P10-NEXT:    std r3, 40(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    stw r4, 52(r1)
; LE-P10-NEXT:    #APP
; LE-P10-NEXT:    nop
; LE-P10-NEXT:    #NO_APP
; LE-P10-NEXT:    addi r3, r1, 52
; LE-P10-NEXT:    bl callee2@notoc
; LE-P10-NEXT:    ld r4, 40(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lxv v31, 240(r1) # 16-byte Folded Reload
; LE-P10-NEXT:    lxv v30, 224(r1) # 16-byte Folded Reload
; LE-P10-NEXT:    lxv v29, 208(r1) # 16-byte Folded Reload
; LE-P10-NEXT:    lxv v28, 192(r1) # 16-byte Folded Reload
; LE-P10-NEXT:    lxv v27, 176(r1) # 16-byte Folded Reload
; LE-P10-NEXT:    lxv v26, 160(r1) # 16-byte Folded Reload
; LE-P10-NEXT:    lxv v25, 144(r1) # 16-byte Folded Reload
; LE-P10-NEXT:    lxv v24, 128(r1) # 16-byte Folded Reload
; LE-P10-NEXT:    lxv v23, 112(r1) # 16-byte Folded Reload
; LE-P10-NEXT:    lxv v22, 96(r1) # 16-byte Folded Reload
; LE-P10-NEXT:    lxv v21, 80(r1) # 16-byte Folded Reload
; LE-P10-NEXT:    lxv v20, 64(r1) # 16-byte Folded Reload
; LE-P10-NEXT:    lfd f31, 536(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lfd f30, 528(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lfd f29, 520(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lfd f28, 512(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lfd f27, 504(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lfd f26, 496(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lfd f25, 488(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lfd f24, 480(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lfd f23, 472(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lfd f22, 464(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lfd f21, 456(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lfd f20, 448(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lfd f19, 440(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lfd f18, 432(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lfd f17, 424(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lfd f16, 416(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lfd f15, 408(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lfd f14, 400(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    ld r31, 392(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    ld r30, 384(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    ld r29, 376(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    ld r28, 368(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    ld r27, 360(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    ld r26, 352(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    ld r25, 344(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    ld r24, 336(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    ld r23, 328(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    ld r22, 320(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    ld r21, 312(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    ld r20, 304(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    ld r19, 296(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    ld r18, 288(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    ld r17, 280(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    ld r16, 272(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    ld r15, 264(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    lwz r4, 16(r4)
; LE-P10-NEXT:    add r3, r4, r3
; LE-P10-NEXT:    clrldi r3, r3, 32
; LE-P10-NEXT:    ld r14, 256(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    addi r1, r1, 544
; LE-P10-NEXT:    ld r0, 16(r1)
; LE-P10-NEXT:    lwz r12, 8(r1)
; LE-P10-NEXT:    mtlr r0
; LE-P10-NEXT:    hashchk r0, -488(r1)
; LE-P10-NEXT:    mtocrf 32, r12
; LE-P10-NEXT:    mtocrf 16, r12
; LE-P10-NEXT:    mtocrf 8, r12
; LE-P10-NEXT:    blr
;
; LE-P9-LABEL: spill:
; LE-P9:       # %bb.0: # %entry
; LE-P9-NEXT:    mflr r0
; LE-P9-NEXT:    mfcr r12
; LE-P9-NEXT:    std r0, 16(r1)
; LE-P9-NEXT:    hashst r0, -488(r1)
; LE-P9-NEXT:    stw r12, 8(r1)
; LE-P9-NEXT:    stdu r1, -544(r1)
; LE-P9-NEXT:    lwz r4, 12(r3)
; LE-P9-NEXT:    std r14, 256(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    std r15, 264(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stxv v20, 64(r1) # 16-byte Folded Spill
; LE-P9-NEXT:    stxv v21, 80(r1) # 16-byte Folded Spill
; LE-P9-NEXT:    stxv v22, 96(r1) # 16-byte Folded Spill
; LE-P9-NEXT:    std r16, 272(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    std r17, 280(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stxv v23, 112(r1) # 16-byte Folded Spill
; LE-P9-NEXT:    std r18, 288(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stxv v24, 128(r1) # 16-byte Folded Spill
; LE-P9-NEXT:    std r19, 296(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stxv v25, 144(r1) # 16-byte Folded Spill
; LE-P9-NEXT:    std r20, 304(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    std r21, 312(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stxv v26, 160(r1) # 16-byte Folded Spill
; LE-P9-NEXT:    std r22, 320(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stxv v27, 176(r1) # 16-byte Folded Spill
; LE-P9-NEXT:    std r23, 328(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stxv v28, 192(r1) # 16-byte Folded Spill
; LE-P9-NEXT:    std r24, 336(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    std r25, 344(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stxv v29, 208(r1) # 16-byte Folded Spill
; LE-P9-NEXT:    std r26, 352(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stxv v30, 224(r1) # 16-byte Folded Spill
; LE-P9-NEXT:    std r27, 360(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stxv v31, 240(r1) # 16-byte Folded Spill
; LE-P9-NEXT:    std r28, 368(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    std r29, 376(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    std r30, 384(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    std r31, 392(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stfd f14, 400(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stfd f15, 408(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stfd f16, 416(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stfd f17, 424(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stfd f18, 432(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stfd f19, 440(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stfd f20, 448(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stfd f21, 456(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stfd f22, 464(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stfd f23, 472(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stfd f24, 480(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stfd f25, 488(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stfd f26, 496(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stfd f27, 504(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stfd f28, 512(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stfd f29, 520(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stfd f30, 528(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stfd f31, 536(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    std r3, 40(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    stw r4, 52(r1)
; LE-P9-NEXT:    #APP
; LE-P9-NEXT:    nop
; LE-P9-NEXT:    #NO_APP
; LE-P9-NEXT:    addi r3, r1, 52
; LE-P9-NEXT:    bl callee2
; LE-P9-NEXT:    nop
; LE-P9-NEXT:    ld r4, 40(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    lxv v31, 240(r1) # 16-byte Folded Reload
; LE-P9-NEXT:    lxv v30, 224(r1) # 16-byte Folded Reload
; LE-P9-NEXT:    lxv v29, 208(r1) # 16-byte Folded Reload
; LE-P9-NEXT:    lxv v28, 192(r1) # 16-byte Folded Reload
; LE-P9-NEXT:    lxv v27, 176(r1) # 16-byte Folded Reload
; LE-P9-NEXT:    lxv v26, 160(r1) # 16-byte Folded Reload
; LE-P9-NEXT:    lxv v25, 144(r1) # 16-byte Folded Reload
; LE-P9-NEXT:    lxv v24, 128(r1) # 16-byte Folded Reload
; LE-P9-NEXT:    lxv v23, 112(r1) # 16-byte Folded Reload
; LE-P9-NEXT:    lxv v22, 96(r1) # 16-byte Folded Reload
; LE-P9-NEXT:    lxv v21, 80(r1) # 16-byte Folded Reload
; LE-P9-NEXT:    lxv v20, 64(r1) # 16-byte Folded Reload
; LE-P9-NEXT:    lfd f31, 536(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    lfd f30, 528(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    lfd f29, 520(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    lfd f28, 512(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    lfd f27, 504(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    ld r31, 392(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    ld r30, 384(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    ld r29, 376(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    lfd f26, 496(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    ld r28, 368(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    ld r27, 360(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    ld r26, 352(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    lfd f25, 488(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    ld r25, 344(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    ld r24, 336(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    ld r23, 328(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    lfd f24, 480(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    ld r22, 320(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    ld r21, 312(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    lwz r4, 16(r4)
; LE-P9-NEXT:    add r3, r4, r3
; LE-P9-NEXT:    lfd f23, 472(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    lfd f22, 464(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    ld r20, 304(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    ld r19, 296(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    ld r18, 288(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    ld r17, 280(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    ld r16, 272(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    ld r15, 264(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    ld r14, 256(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    lfd f21, 456(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    lfd f20, 448(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    lfd f19, 440(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    lfd f18, 432(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    lfd f17, 424(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    lfd f16, 416(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    lfd f15, 408(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    lfd f14, 400(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    clrldi r3, r3, 32
; LE-P9-NEXT:    addi r1, r1, 544
; LE-P9-NEXT:    ld r0, 16(r1)
; LE-P9-NEXT:    lwz r12, 8(r1)
; LE-P9-NEXT:    mtlr r0
; LE-P9-NEXT:    hashchk r0, -488(r1)
; LE-P9-NEXT:    mtocrf 32, r12
; LE-P9-NEXT:    mtocrf 16, r12
; LE-P9-NEXT:    mtocrf 8, r12
; LE-P9-NEXT:    blr
;
; LE-P8-LABEL: spill:
; LE-P8:       # %bb.0: # %entry
; LE-P8-NEXT:    mfcr r12
; LE-P8-NEXT:    mflr r0
; LE-P8-NEXT:    std r0, 16(r1)
; LE-P8-NEXT:    hashst r0, -488(r1)
; LE-P8-NEXT:    stw r12, 8(r1)
; LE-P8-NEXT:    stdu r1, -544(r1)
; LE-P8-NEXT:    li r4, 64
; LE-P8-NEXT:    std r14, 256(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    std r15, 264(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    std r16, 272(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    std r17, 280(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stxvd2x v20, r1, r4 # 16-byte Folded Spill
; LE-P8-NEXT:    li r4, 80
; LE-P8-NEXT:    std r18, 288(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    std r19, 296(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    std r20, 304(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    std r21, 312(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stxvd2x v21, r1, r4 # 16-byte Folded Spill
; LE-P8-NEXT:    li r4, 96
; LE-P8-NEXT:    std r22, 320(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    std r23, 328(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    std r24, 336(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    std r25, 344(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    std r26, 352(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    std r27, 360(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    std r28, 368(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    std r29, 376(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    std r30, 384(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    std r31, 392(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    std r3, 40(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stxvd2x v22, r1, r4 # 16-byte Folded Spill
; LE-P8-NEXT:    li r4, 112
; LE-P8-NEXT:    stxvd2x v23, r1, r4 # 16-byte Folded Spill
; LE-P8-NEXT:    li r4, 128
; LE-P8-NEXT:    stfd f14, 400(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stxvd2x v24, r1, r4 # 16-byte Folded Spill
; LE-P8-NEXT:    li r4, 144
; LE-P8-NEXT:    stfd f15, 408(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stxvd2x v25, r1, r4 # 16-byte Folded Spill
; LE-P8-NEXT:    li r4, 160
; LE-P8-NEXT:    stfd f16, 416(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stxvd2x v26, r1, r4 # 16-byte Folded Spill
; LE-P8-NEXT:    li r4, 176
; LE-P8-NEXT:    stfd f17, 424(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stxvd2x v27, r1, r4 # 16-byte Folded Spill
; LE-P8-NEXT:    li r4, 192
; LE-P8-NEXT:    stfd f18, 432(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stxvd2x v28, r1, r4 # 16-byte Folded Spill
; LE-P8-NEXT:    li r4, 208
; LE-P8-NEXT:    stfd f19, 440(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stxvd2x v29, r1, r4 # 16-byte Folded Spill
; LE-P8-NEXT:    li r4, 224
; LE-P8-NEXT:    stfd f20, 448(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stxvd2x v30, r1, r4 # 16-byte Folded Spill
; LE-P8-NEXT:    li r4, 240
; LE-P8-NEXT:    stfd f21, 456(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stxvd2x v31, r1, r4 # 16-byte Folded Spill
; LE-P8-NEXT:    lwz r4, 12(r3)
; LE-P8-NEXT:    stfd f22, 464(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stfd f23, 472(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stfd f24, 480(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stfd f25, 488(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stfd f26, 496(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stfd f27, 504(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stfd f28, 512(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stfd f29, 520(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stfd f30, 528(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stfd f31, 536(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    stw r4, 52(r1)
; LE-P8-NEXT:    #APP
; LE-P8-NEXT:    nop
; LE-P8-NEXT:    #NO_APP
; LE-P8-NEXT:    addi r3, r1, 52
; LE-P8-NEXT:    bl callee2
; LE-P8-NEXT:    nop
; LE-P8-NEXT:    ld r4, 40(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    lfd f31, 536(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    lfd f30, 528(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    ld r31, 392(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    lfd f29, 520(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    lfd f28, 512(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    ld r30, 384(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    ld r29, 376(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    lwz r4, 16(r4)
; LE-P8-NEXT:    lfd f27, 504(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    lfd f26, 496(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    ld r28, 368(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    lfd f25, 488(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    lfd f24, 480(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    ld r27, 360(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    ld r26, 352(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    add r3, r4, r3
; LE-P8-NEXT:    li r4, 240
; LE-P8-NEXT:    lfd f23, 472(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    lfd f22, 464(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    ld r25, 344(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    ld r24, 336(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    lxvd2x v31, r1, r4 # 16-byte Folded Reload
; LE-P8-NEXT:    li r4, 224
; LE-P8-NEXT:    lfd f21, 456(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    ld r23, 328(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    ld r22, 320(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    clrldi r3, r3, 32
; LE-P8-NEXT:    lxvd2x v30, r1, r4 # 16-byte Folded Reload
; LE-P8-NEXT:    li r4, 208
; LE-P8-NEXT:    lfd f20, 448(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    ld r21, 312(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    ld r20, 304(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    lxvd2x v29, r1, r4 # 16-byte Folded Reload
; LE-P8-NEXT:    li r4, 192
; LE-P8-NEXT:    lfd f19, 440(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    ld r19, 296(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    ld r18, 288(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    lxvd2x v28, r1, r4 # 16-byte Folded Reload
; LE-P8-NEXT:    li r4, 176
; LE-P8-NEXT:    lfd f18, 432(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    ld r17, 280(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    ld r16, 272(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    lxvd2x v27, r1, r4 # 16-byte Folded Reload
; LE-P8-NEXT:    li r4, 160
; LE-P8-NEXT:    lfd f17, 424(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    ld r15, 264(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    ld r14, 256(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    lxvd2x v26, r1, r4 # 16-byte Folded Reload
; LE-P8-NEXT:    li r4, 144
; LE-P8-NEXT:    lfd f16, 416(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    lxvd2x v25, r1, r4 # 16-byte Folded Reload
; LE-P8-NEXT:    li r4, 128
; LE-P8-NEXT:    lfd f15, 408(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    lxvd2x v24, r1, r4 # 16-byte Folded Reload
; LE-P8-NEXT:    li r4, 112
; LE-P8-NEXT:    lfd f14, 400(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    lxvd2x v23, r1, r4 # 16-byte Folded Reload
; LE-P8-NEXT:    li r4, 96
; LE-P8-NEXT:    lxvd2x v22, r1, r4 # 16-byte Folded Reload
; LE-P8-NEXT:    li r4, 80
; LE-P8-NEXT:    lxvd2x v21, r1, r4 # 16-byte Folded Reload
; LE-P8-NEXT:    li r4, 64
; LE-P8-NEXT:    lxvd2x v20, r1, r4 # 16-byte Folded Reload
; LE-P8-NEXT:    addi r1, r1, 544
; LE-P8-NEXT:    ld r0, 16(r1)
; LE-P8-NEXT:    lwz r12, 8(r1)
; LE-P8-NEXT:    mtocrf 32, r12
; LE-P8-NEXT:    hashchk r0, -488(r1)
; LE-P8-NEXT:    mtlr r0
; LE-P8-NEXT:    mtocrf 16, r12
; LE-P8-NEXT:    mtocrf 8, r12
; LE-P8-NEXT:    blr
;
; LE-P10-O0-LABEL: spill:
; LE-P10-O0:       # %bb.0: # %entry
; LE-P10-O0-NEXT:    mflr r0
; LE-P10-O0-NEXT:    mfcr r12
; LE-P10-O0-NEXT:    std r0, 16(r1)
; LE-P10-O0-NEXT:    hashst r0, -488(r1)
; LE-P10-O0-NEXT:    stw r12, 8(r1)
; LE-P10-O0-NEXT:    stdu r1, -544(r1)
; LE-P10-O0-NEXT:    std r14, 256(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    std r15, 264(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    std r16, 272(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    std r17, 280(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    std r18, 288(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    std r19, 296(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    std r20, 304(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    std r21, 312(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    std r22, 320(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    std r23, 328(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    std r24, 336(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    std r25, 344(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    std r26, 352(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    std r27, 360(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    std r28, 368(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    std r29, 376(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    std r30, 384(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    std r31, 392(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stfd f14, 400(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stfd f15, 408(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stfd f16, 416(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stfd f17, 424(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stfd f18, 432(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stfd f19, 440(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stfd f20, 448(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stfd f21, 456(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stfd f22, 464(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stfd f23, 472(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stfd f24, 480(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stfd f25, 488(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stfd f26, 496(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stfd f27, 504(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stfd f28, 512(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stfd f29, 520(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stfd f30, 528(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stfd f31, 536(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    stxv v20, 64(r1) # 16-byte Folded Spill
; LE-P10-O0-NEXT:    stxv v21, 80(r1) # 16-byte Folded Spill
; LE-P10-O0-NEXT:    stxv v22, 96(r1) # 16-byte Folded Spill
; LE-P10-O0-NEXT:    stxv v23, 112(r1) # 16-byte Folded Spill
; LE-P10-O0-NEXT:    stxv v24, 128(r1) # 16-byte Folded Spill
; LE-P10-O0-NEXT:    stxv v25, 144(r1) # 16-byte Folded Spill
; LE-P10-O0-NEXT:    stxv v26, 160(r1) # 16-byte Folded Spill
; LE-P10-O0-NEXT:    stxv v27, 176(r1) # 16-byte Folded Spill
; LE-P10-O0-NEXT:    stxv v28, 192(r1) # 16-byte Folded Spill
; LE-P10-O0-NEXT:    stxv v29, 208(r1) # 16-byte Folded Spill
; LE-P10-O0-NEXT:    stxv v30, 224(r1) # 16-byte Folded Spill
; LE-P10-O0-NEXT:    stxv v31, 240(r1) # 16-byte Folded Spill
; LE-P10-O0-NEXT:    std r3, 40(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    lwz r3, 12(r3)
; LE-P10-O0-NEXT:    stw r3, 52(r1)
; LE-P10-O0-NEXT:    #APP
; LE-P10-O0-NEXT:    nop
; LE-P10-O0-NEXT:    #NO_APP
; LE-P10-O0-NEXT:    addi r3, r1, 52
; LE-P10-O0-NEXT:    bl callee2@notoc
; LE-P10-O0-NEXT:    mr r4, r3
; LE-P10-O0-NEXT:    ld r3, 40(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    # kill: def $r4 killed $r4 killed $x4
; LE-P10-O0-NEXT:    lwz r3, 16(r3)
; LE-P10-O0-NEXT:    add r3, r3, r4
; LE-P10-O0-NEXT:    clrldi r3, r3, 32
; LE-P10-O0-NEXT:    lxv v31, 240(r1) # 16-byte Folded Reload
; LE-P10-O0-NEXT:    lxv v30, 224(r1) # 16-byte Folded Reload
; LE-P10-O0-NEXT:    lxv v29, 208(r1) # 16-byte Folded Reload
; LE-P10-O0-NEXT:    lxv v28, 192(r1) # 16-byte Folded Reload
; LE-P10-O0-NEXT:    lxv v27, 176(r1) # 16-byte Folded Reload
; LE-P10-O0-NEXT:    lxv v26, 160(r1) # 16-byte Folded Reload
; LE-P10-O0-NEXT:    lxv v25, 144(r1) # 16-byte Folded Reload
; LE-P10-O0-NEXT:    lxv v24, 128(r1) # 16-byte Folded Reload
; LE-P10-O0-NEXT:    lxv v23, 112(r1) # 16-byte Folded Reload
; LE-P10-O0-NEXT:    lxv v22, 96(r1) # 16-byte Folded Reload
; LE-P10-O0-NEXT:    lxv v21, 80(r1) # 16-byte Folded Reload
; LE-P10-O0-NEXT:    lxv v20, 64(r1) # 16-byte Folded Reload
; LE-P10-O0-NEXT:    lfd f31, 536(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    lfd f30, 528(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    lfd f29, 520(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    lfd f28, 512(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    lfd f27, 504(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    lfd f26, 496(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    lfd f25, 488(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    lfd f24, 480(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    lfd f23, 472(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    lfd f22, 464(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    lfd f21, 456(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    lfd f20, 448(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    lfd f19, 440(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    lfd f18, 432(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    lfd f17, 424(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    lfd f16, 416(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    lfd f15, 408(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    lfd f14, 400(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    ld r31, 392(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    ld r30, 384(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    ld r29, 376(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    ld r28, 368(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    ld r27, 360(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    ld r26, 352(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    ld r25, 344(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    ld r24, 336(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    ld r23, 328(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    ld r22, 320(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    ld r21, 312(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    ld r20, 304(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    ld r19, 296(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    ld r18, 288(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    ld r17, 280(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    ld r16, 272(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    ld r15, 264(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    ld r14, 256(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    addi r1, r1, 544
; LE-P10-O0-NEXT:    ld r0, 16(r1)
; LE-P10-O0-NEXT:    lwz r12, 8(r1)
; LE-P10-O0-NEXT:    mtocrf 32, r12
; LE-P10-O0-NEXT:    mtocrf 16, r12
; LE-P10-O0-NEXT:    mtocrf 8, r12
; LE-P10-O0-NEXT:    hashchk r0, -488(r1)
; LE-P10-O0-NEXT:    mtlr r0
; LE-P10-O0-NEXT:    blr
;
; LE-P9-O0-LABEL: spill:
; LE-P9-O0:       # %bb.0: # %entry
; LE-P9-O0-NEXT:    mflr r0
; LE-P9-O0-NEXT:    mfcr r12
; LE-P9-O0-NEXT:    std r0, 16(r1)
; LE-P9-O0-NEXT:    hashst r0, -488(r1)
; LE-P9-O0-NEXT:    stw r12, 8(r1)
; LE-P9-O0-NEXT:    stdu r1, -608(r1)
; LE-P9-O0-NEXT:    std r14, 320(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    std r15, 328(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    std r16, 336(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    std r17, 344(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    std r18, 352(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    std r19, 360(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    std r20, 368(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    std r21, 376(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    std r22, 384(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    std r23, 392(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    std r24, 400(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    std r25, 408(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    std r26, 416(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    std r27, 424(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    std r28, 432(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    std r29, 440(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    std r30, 448(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    std r31, 456(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stfd f14, 464(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stfd f15, 472(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stfd f16, 480(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stfd f17, 488(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stfd f18, 496(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stfd f19, 504(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stfd f20, 512(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stfd f21, 520(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stfd f22, 528(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stfd f23, 536(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stfd f24, 544(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stfd f25, 552(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stfd f26, 560(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stfd f27, 568(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stfd f28, 576(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stfd f29, 584(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stfd f30, 592(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stfd f31, 600(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    stxv v20, 128(r1) # 16-byte Folded Spill
; LE-P9-O0-NEXT:    stxv v21, 144(r1) # 16-byte Folded Spill
; LE-P9-O0-NEXT:    stxv v22, 160(r1) # 16-byte Folded Spill
; LE-P9-O0-NEXT:    stxv v23, 176(r1) # 16-byte Folded Spill
; LE-P9-O0-NEXT:    stxv v24, 192(r1) # 16-byte Folded Spill
; LE-P9-O0-NEXT:    stxv v25, 208(r1) # 16-byte Folded Spill
; LE-P9-O0-NEXT:    stxv v26, 224(r1) # 16-byte Folded Spill
; LE-P9-O0-NEXT:    stxv v27, 240(r1) # 16-byte Folded Spill
; LE-P9-O0-NEXT:    stxv v28, 256(r1) # 16-byte Folded Spill
; LE-P9-O0-NEXT:    stxv v29, 272(r1) # 16-byte Folded Spill
; LE-P9-O0-NEXT:    stxv v30, 288(r1) # 16-byte Folded Spill
; LE-P9-O0-NEXT:    stxv v31, 304(r1) # 16-byte Folded Spill
; LE-P9-O0-NEXT:    std r3, 104(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    lwz r3, 12(r3)
; LE-P9-O0-NEXT:    stw r3, 116(r1)
; LE-P9-O0-NEXT:    #APP
; LE-P9-O0-NEXT:    nop
; LE-P9-O0-NEXT:    #NO_APP
; LE-P9-O0-NEXT:    addi r3, r1, 116
; LE-P9-O0-NEXT:    bl callee2
; LE-P9-O0-NEXT:    nop
; LE-P9-O0-NEXT:    mr r4, r3
; LE-P9-O0-NEXT:    ld r3, 104(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lwz r3, 16(r3)
; LE-P9-O0-NEXT:    add r3, r3, r4
; LE-P9-O0-NEXT:    clrldi r3, r3, 32
; LE-P9-O0-NEXT:    lxv v31, 304(r1) # 16-byte Folded Reload
; LE-P9-O0-NEXT:    lxv v30, 288(r1) # 16-byte Folded Reload
; LE-P9-O0-NEXT:    lxv v29, 272(r1) # 16-byte Folded Reload
; LE-P9-O0-NEXT:    lxv v28, 256(r1) # 16-byte Folded Reload
; LE-P9-O0-NEXT:    lxv v27, 240(r1) # 16-byte Folded Reload
; LE-P9-O0-NEXT:    lxv v26, 224(r1) # 16-byte Folded Reload
; LE-P9-O0-NEXT:    lxv v25, 208(r1) # 16-byte Folded Reload
; LE-P9-O0-NEXT:    lxv v24, 192(r1) # 16-byte Folded Reload
; LE-P9-O0-NEXT:    lxv v23, 176(r1) # 16-byte Folded Reload
; LE-P9-O0-NEXT:    lxv v22, 160(r1) # 16-byte Folded Reload
; LE-P9-O0-NEXT:    lxv v21, 144(r1) # 16-byte Folded Reload
; LE-P9-O0-NEXT:    lxv v20, 128(r1) # 16-byte Folded Reload
; LE-P9-O0-NEXT:    lfd f31, 600(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lfd f30, 592(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lfd f29, 584(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lfd f28, 576(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lfd f27, 568(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lfd f26, 560(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lfd f25, 552(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lfd f24, 544(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lfd f23, 536(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lfd f22, 528(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lfd f21, 520(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lfd f20, 512(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lfd f19, 504(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lfd f18, 496(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lfd f17, 488(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lfd f16, 480(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lfd f15, 472(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lfd f14, 464(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    ld r31, 456(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    ld r30, 448(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    ld r29, 440(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    ld r28, 432(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    ld r27, 424(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    ld r26, 416(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    ld r25, 408(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    ld r24, 400(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    ld r23, 392(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    ld r22, 384(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    ld r21, 376(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    ld r20, 368(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    ld r19, 360(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    ld r18, 352(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    ld r17, 344(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    ld r16, 336(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    ld r15, 328(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    ld r14, 320(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    addi r1, r1, 608
; LE-P9-O0-NEXT:    ld r0, 16(r1)
; LE-P9-O0-NEXT:    lwz r12, 8(r1)
; LE-P9-O0-NEXT:    mtocrf 32, r12
; LE-P9-O0-NEXT:    mtocrf 16, r12
; LE-P9-O0-NEXT:    mtocrf 8, r12
; LE-P9-O0-NEXT:    hashchk r0, -488(r1)
; LE-P9-O0-NEXT:    mtlr r0
; LE-P9-O0-NEXT:    blr
;
; LE-P8-O0-LABEL: spill:
; LE-P8-O0:       # %bb.0: # %entry
; LE-P8-O0-NEXT:    mflr r0
; LE-P8-O0-NEXT:    mfcr r12
; LE-P8-O0-NEXT:    std r0, 16(r1)
; LE-P8-O0-NEXT:    hashst r0, -488(r1)
; LE-P8-O0-NEXT:    stw r12, 8(r1)
; LE-P8-O0-NEXT:    stdu r1, -608(r1)
; LE-P8-O0-NEXT:    std r14, 320(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    std r15, 328(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    std r16, 336(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    std r17, 344(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    std r18, 352(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    std r19, 360(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    std r20, 368(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    std r21, 376(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    std r22, 384(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    std r23, 392(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    std r24, 400(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    std r25, 408(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    std r26, 416(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    std r27, 424(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    std r28, 432(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    std r29, 440(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    std r30, 448(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    std r31, 456(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    stfd f14, 464(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    stfd f15, 472(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    stfd f16, 480(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    stfd f17, 488(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    stfd f18, 496(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    stfd f19, 504(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    stfd f20, 512(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    stfd f21, 520(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    stfd f22, 528(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    stfd f23, 536(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    stfd f24, 544(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    stfd f25, 552(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    stfd f26, 560(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    stfd f27, 568(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    stfd f28, 576(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    stfd f29, 584(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    stfd f30, 592(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    stfd f31, 600(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    li r4, 128
; LE-P8-O0-NEXT:    stxvd2x v20, r1, r4 # 16-byte Folded Spill
; LE-P8-O0-NEXT:    li r4, 144
; LE-P8-O0-NEXT:    stxvd2x v21, r1, r4 # 16-byte Folded Spill
; LE-P8-O0-NEXT:    li r4, 160
; LE-P8-O0-NEXT:    stxvd2x v22, r1, r4 # 16-byte Folded Spill
; LE-P8-O0-NEXT:    li r4, 176
; LE-P8-O0-NEXT:    stxvd2x v23, r1, r4 # 16-byte Folded Spill
; LE-P8-O0-NEXT:    li r4, 192
; LE-P8-O0-NEXT:    stxvd2x v24, r1, r4 # 16-byte Folded Spill
; LE-P8-O0-NEXT:    li r4, 208
; LE-P8-O0-NEXT:    stxvd2x v25, r1, r4 # 16-byte Folded Spill
; LE-P8-O0-NEXT:    li r4, 224
; LE-P8-O0-NEXT:    stxvd2x v26, r1, r4 # 16-byte Folded Spill
; LE-P8-O0-NEXT:    li r4, 240
; LE-P8-O0-NEXT:    stxvd2x v27, r1, r4 # 16-byte Folded Spill
; LE-P8-O0-NEXT:    li r4, 256
; LE-P8-O0-NEXT:    stxvd2x v28, r1, r4 # 16-byte Folded Spill
; LE-P8-O0-NEXT:    li r4, 272
; LE-P8-O0-NEXT:    stxvd2x v29, r1, r4 # 16-byte Folded Spill
; LE-P8-O0-NEXT:    li r4, 288
; LE-P8-O0-NEXT:    stxvd2x v30, r1, r4 # 16-byte Folded Spill
; LE-P8-O0-NEXT:    li r4, 304
; LE-P8-O0-NEXT:    stxvd2x v31, r1, r4 # 16-byte Folded Spill
; LE-P8-O0-NEXT:    std r3, 104(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    lwz r3, 12(r3)
; LE-P8-O0-NEXT:    stw r3, 116(r1)
; LE-P8-O0-NEXT:    #APP
; LE-P8-O0-NEXT:    nop
; LE-P8-O0-NEXT:    #NO_APP
; LE-P8-O0-NEXT:    addi r3, r1, 116
; LE-P8-O0-NEXT:    bl callee2
; LE-P8-O0-NEXT:    nop
; LE-P8-O0-NEXT:    mr r4, r3
; LE-P8-O0-NEXT:    ld r3, 104(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lwz r3, 16(r3)
; LE-P8-O0-NEXT:    add r3, r3, r4
; LE-P8-O0-NEXT:    clrldi r3, r3, 32
; LE-P8-O0-NEXT:    li r4, 304
; LE-P8-O0-NEXT:    lxvd2x v31, r1, r4 # 16-byte Folded Reload
; LE-P8-O0-NEXT:    li r4, 288
; LE-P8-O0-NEXT:    lxvd2x v30, r1, r4 # 16-byte Folded Reload
; LE-P8-O0-NEXT:    li r4, 272
; LE-P8-O0-NEXT:    lxvd2x v29, r1, r4 # 16-byte Folded Reload
; LE-P8-O0-NEXT:    li r4, 256
; LE-P8-O0-NEXT:    lxvd2x v28, r1, r4 # 16-byte Folded Reload
; LE-P8-O0-NEXT:    li r4, 240
; LE-P8-O0-NEXT:    lxvd2x v27, r1, r4 # 16-byte Folded Reload
; LE-P8-O0-NEXT:    li r4, 224
; LE-P8-O0-NEXT:    lxvd2x v26, r1, r4 # 16-byte Folded Reload
; LE-P8-O0-NEXT:    li r4, 208
; LE-P8-O0-NEXT:    lxvd2x v25, r1, r4 # 16-byte Folded Reload
; LE-P8-O0-NEXT:    li r4, 192
; LE-P8-O0-NEXT:    lxvd2x v24, r1, r4 # 16-byte Folded Reload
; LE-P8-O0-NEXT:    li r4, 176
; LE-P8-O0-NEXT:    lxvd2x v23, r1, r4 # 16-byte Folded Reload
; LE-P8-O0-NEXT:    li r4, 160
; LE-P8-O0-NEXT:    lxvd2x v22, r1, r4 # 16-byte Folded Reload
; LE-P8-O0-NEXT:    li r4, 144
; LE-P8-O0-NEXT:    lxvd2x v21, r1, r4 # 16-byte Folded Reload
; LE-P8-O0-NEXT:    li r4, 128
; LE-P8-O0-NEXT:    lxvd2x v20, r1, r4 # 16-byte Folded Reload
; LE-P8-O0-NEXT:    lfd f31, 600(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lfd f30, 592(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lfd f29, 584(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lfd f28, 576(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lfd f27, 568(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lfd f26, 560(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lfd f25, 552(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lfd f24, 544(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lfd f23, 536(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lfd f22, 528(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lfd f21, 520(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lfd f20, 512(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lfd f19, 504(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lfd f18, 496(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lfd f17, 488(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lfd f16, 480(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lfd f15, 472(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lfd f14, 464(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    ld r31, 456(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    ld r30, 448(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    ld r29, 440(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    ld r28, 432(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    ld r27, 424(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    ld r26, 416(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    ld r25, 408(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    ld r24, 400(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    ld r23, 392(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    ld r22, 384(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    ld r21, 376(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    ld r20, 368(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    ld r19, 360(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    ld r18, 352(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    ld r17, 344(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    ld r16, 336(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    ld r15, 328(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    ld r14, 320(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    addi r1, r1, 608
; LE-P8-O0-NEXT:    ld r0, 16(r1)
; LE-P8-O0-NEXT:    lwz r12, 8(r1)
; LE-P8-O0-NEXT:    mtocrf 32, r12
; LE-P8-O0-NEXT:    mtocrf 16, r12
; LE-P8-O0-NEXT:    mtocrf 8, r12
; LE-P8-O0-NEXT:    hashchk r0, -488(r1)
; LE-P8-O0-NEXT:    mtlr r0
; LE-P8-O0-NEXT:    blr
;
; BE-P10-LABEL: spill:
; BE-P10:       # %bb.0: # %entry
; BE-P10-NEXT:    mflr r0
; BE-P10-NEXT:    mfcr r12
; BE-P10-NEXT:    std r0, 16(r1)
; BE-P10-NEXT:    hashst r0, -488(r1)
; BE-P10-NEXT:    stw r12, 8(r1)
; BE-P10-NEXT:    stdu r1, -624(r1)
; BE-P10-NEXT:    lwz r4, 12(r3)
; BE-P10-NEXT:    std r14, 336(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    std r15, 344(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    std r16, 352(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    std r17, 360(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    std r18, 368(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    std r19, 376(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    std r20, 384(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    std r21, 392(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    std r22, 400(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    std r23, 408(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    std r24, 416(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    std r25, 424(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    std r26, 432(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    std r27, 440(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    std r28, 448(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    std r29, 456(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    std r30, 464(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    std r31, 472(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stfd f14, 480(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stfd f15, 488(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stfd f16, 496(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stfd f17, 504(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stfd f18, 512(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stfd f19, 520(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stfd f20, 528(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stfd f21, 536(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stfd f22, 544(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stfd f23, 552(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stfd f24, 560(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stfd f25, 568(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stfd f26, 576(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stfd f27, 584(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stfd f28, 592(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stfd f29, 600(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stfd f30, 608(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stfd f31, 616(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stxv v20, 144(r1) # 16-byte Folded Spill
; BE-P10-NEXT:    stxv v21, 160(r1) # 16-byte Folded Spill
; BE-P10-NEXT:    stxv v22, 176(r1) # 16-byte Folded Spill
; BE-P10-NEXT:    stxv v23, 192(r1) # 16-byte Folded Spill
; BE-P10-NEXT:    stxv v24, 208(r1) # 16-byte Folded Spill
; BE-P10-NEXT:    stxv v25, 224(r1) # 16-byte Folded Spill
; BE-P10-NEXT:    stxv v26, 240(r1) # 16-byte Folded Spill
; BE-P10-NEXT:    stxv v27, 256(r1) # 16-byte Folded Spill
; BE-P10-NEXT:    stxv v28, 272(r1) # 16-byte Folded Spill
; BE-P10-NEXT:    stxv v29, 288(r1) # 16-byte Folded Spill
; BE-P10-NEXT:    stxv v30, 304(r1) # 16-byte Folded Spill
; BE-P10-NEXT:    stxv v31, 320(r1) # 16-byte Folded Spill
; BE-P10-NEXT:    std r3, 120(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    stw r4, 132(r1)
; BE-P10-NEXT:    #APP
; BE-P10-NEXT:    nop
; BE-P10-NEXT:    #NO_APP
; BE-P10-NEXT:    addi r3, r1, 132
; BE-P10-NEXT:    bl callee2
; BE-P10-NEXT:    nop
; BE-P10-NEXT:    ld r4, 120(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lxv v31, 320(r1) # 16-byte Folded Reload
; BE-P10-NEXT:    lxv v30, 304(r1) # 16-byte Folded Reload
; BE-P10-NEXT:    lxv v29, 288(r1) # 16-byte Folded Reload
; BE-P10-NEXT:    lxv v28, 272(r1) # 16-byte Folded Reload
; BE-P10-NEXT:    lxv v27, 256(r1) # 16-byte Folded Reload
; BE-P10-NEXT:    lxv v26, 240(r1) # 16-byte Folded Reload
; BE-P10-NEXT:    lxv v25, 224(r1) # 16-byte Folded Reload
; BE-P10-NEXT:    lxv v24, 208(r1) # 16-byte Folded Reload
; BE-P10-NEXT:    lxv v23, 192(r1) # 16-byte Folded Reload
; BE-P10-NEXT:    lxv v22, 176(r1) # 16-byte Folded Reload
; BE-P10-NEXT:    lxv v21, 160(r1) # 16-byte Folded Reload
; BE-P10-NEXT:    lxv v20, 144(r1) # 16-byte Folded Reload
; BE-P10-NEXT:    lfd f31, 616(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lfd f30, 608(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lfd f29, 600(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lfd f28, 592(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lfd f27, 584(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lfd f26, 576(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lfd f25, 568(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lfd f24, 560(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lfd f23, 552(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lfd f22, 544(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lfd f21, 536(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lfd f20, 528(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lfd f19, 520(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lfd f18, 512(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lfd f17, 504(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lfd f16, 496(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lfd f15, 488(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lfd f14, 480(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    ld r31, 472(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    ld r30, 464(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    ld r29, 456(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    ld r28, 448(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    ld r27, 440(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    ld r26, 432(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    ld r25, 424(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    ld r24, 416(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    ld r23, 408(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    ld r22, 400(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    ld r21, 392(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    ld r20, 384(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    ld r19, 376(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    ld r18, 368(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    ld r17, 360(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    ld r16, 352(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    ld r15, 344(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    lwz r4, 16(r4)
; BE-P10-NEXT:    add r3, r4, r3
; BE-P10-NEXT:    clrldi r3, r3, 32
; BE-P10-NEXT:    ld r14, 336(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    addi r1, r1, 624
; BE-P10-NEXT:    ld r0, 16(r1)
; BE-P10-NEXT:    lwz r12, 8(r1)
; BE-P10-NEXT:    mtlr r0
; BE-P10-NEXT:    hashchk r0, -488(r1)
; BE-P10-NEXT:    mtocrf 32, r12
; BE-P10-NEXT:    mtocrf 16, r12
; BE-P10-NEXT:    mtocrf 8, r12
; BE-P10-NEXT:    blr
;
; BE-P9-LABEL: spill:
; BE-P9:       # %bb.0: # %entry
; BE-P9-NEXT:    mflr r0
; BE-P9-NEXT:    mfcr r12
; BE-P9-NEXT:    std r0, 16(r1)
; BE-P9-NEXT:    hashst r0, -488(r1)
; BE-P9-NEXT:    stw r12, 8(r1)
; BE-P9-NEXT:    stdu r1, -624(r1)
; BE-P9-NEXT:    lwz r4, 12(r3)
; BE-P9-NEXT:    std r14, 336(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    std r15, 344(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stxv v20, 144(r1) # 16-byte Folded Spill
; BE-P9-NEXT:    stxv v21, 160(r1) # 16-byte Folded Spill
; BE-P9-NEXT:    stxv v22, 176(r1) # 16-byte Folded Spill
; BE-P9-NEXT:    std r16, 352(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    std r17, 360(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stxv v23, 192(r1) # 16-byte Folded Spill
; BE-P9-NEXT:    std r18, 368(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stxv v24, 208(r1) # 16-byte Folded Spill
; BE-P9-NEXT:    std r19, 376(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stxv v25, 224(r1) # 16-byte Folded Spill
; BE-P9-NEXT:    std r20, 384(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    std r21, 392(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stxv v26, 240(r1) # 16-byte Folded Spill
; BE-P9-NEXT:    std r22, 400(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stxv v27, 256(r1) # 16-byte Folded Spill
; BE-P9-NEXT:    std r23, 408(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stxv v28, 272(r1) # 16-byte Folded Spill
; BE-P9-NEXT:    std r24, 416(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    std r25, 424(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stxv v29, 288(r1) # 16-byte Folded Spill
; BE-P9-NEXT:    std r26, 432(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stxv v30, 304(r1) # 16-byte Folded Spill
; BE-P9-NEXT:    std r27, 440(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stxv v31, 320(r1) # 16-byte Folded Spill
; BE-P9-NEXT:    std r28, 448(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    std r29, 456(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    std r30, 464(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    std r31, 472(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stfd f14, 480(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stfd f15, 488(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stfd f16, 496(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stfd f17, 504(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stfd f18, 512(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stfd f19, 520(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stfd f20, 528(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stfd f21, 536(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stfd f22, 544(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stfd f23, 552(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stfd f24, 560(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stfd f25, 568(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stfd f26, 576(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stfd f27, 584(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stfd f28, 592(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stfd f29, 600(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stfd f30, 608(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stfd f31, 616(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    std r3, 120(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    stw r4, 132(r1)
; BE-P9-NEXT:    #APP
; BE-P9-NEXT:    nop
; BE-P9-NEXT:    #NO_APP
; BE-P9-NEXT:    addi r3, r1, 132
; BE-P9-NEXT:    bl callee2
; BE-P9-NEXT:    nop
; BE-P9-NEXT:    ld r4, 120(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    lxv v31, 320(r1) # 16-byte Folded Reload
; BE-P9-NEXT:    lxv v30, 304(r1) # 16-byte Folded Reload
; BE-P9-NEXT:    lxv v29, 288(r1) # 16-byte Folded Reload
; BE-P9-NEXT:    lxv v28, 272(r1) # 16-byte Folded Reload
; BE-P9-NEXT:    lxv v27, 256(r1) # 16-byte Folded Reload
; BE-P9-NEXT:    lxv v26, 240(r1) # 16-byte Folded Reload
; BE-P9-NEXT:    lxv v25, 224(r1) # 16-byte Folded Reload
; BE-P9-NEXT:    lxv v24, 208(r1) # 16-byte Folded Reload
; BE-P9-NEXT:    lxv v23, 192(r1) # 16-byte Folded Reload
; BE-P9-NEXT:    lxv v22, 176(r1) # 16-byte Folded Reload
; BE-P9-NEXT:    lxv v21, 160(r1) # 16-byte Folded Reload
; BE-P9-NEXT:    lxv v20, 144(r1) # 16-byte Folded Reload
; BE-P9-NEXT:    lfd f31, 616(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    lfd f30, 608(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    lfd f29, 600(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    lfd f28, 592(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    lfd f27, 584(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    ld r31, 472(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    ld r30, 464(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    ld r29, 456(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    lfd f26, 576(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    ld r28, 448(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    ld r27, 440(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    ld r26, 432(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    lfd f25, 568(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    ld r25, 424(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    ld r24, 416(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    ld r23, 408(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    lfd f24, 560(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    ld r22, 400(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    ld r21, 392(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    lwz r4, 16(r4)
; BE-P9-NEXT:    add r3, r4, r3
; BE-P9-NEXT:    lfd f23, 552(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    lfd f22, 544(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    ld r20, 384(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    ld r19, 376(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    ld r18, 368(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    ld r17, 360(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    ld r16, 352(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    ld r15, 344(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    ld r14, 336(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    lfd f21, 536(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    lfd f20, 528(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    lfd f19, 520(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    lfd f18, 512(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    lfd f17, 504(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    lfd f16, 496(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    lfd f15, 488(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    lfd f14, 480(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    clrldi r3, r3, 32
; BE-P9-NEXT:    addi r1, r1, 624
; BE-P9-NEXT:    ld r0, 16(r1)
; BE-P9-NEXT:    lwz r12, 8(r1)
; BE-P9-NEXT:    mtlr r0
; BE-P9-NEXT:    hashchk r0, -488(r1)
; BE-P9-NEXT:    mtocrf 32, r12
; BE-P9-NEXT:    mtocrf 16, r12
; BE-P9-NEXT:    mtocrf 8, r12
; BE-P9-NEXT:    blr
;
; BE-P8-LABEL: spill:
; BE-P8:       # %bb.0: # %entry
; BE-P8-NEXT:    mfcr r12
; BE-P8-NEXT:    mflr r0
; BE-P8-NEXT:    std r0, 16(r1)
; BE-P8-NEXT:    hashst r0, -488(r1)
; BE-P8-NEXT:    stw r12, 8(r1)
; BE-P8-NEXT:    stdu r1, -624(r1)
; BE-P8-NEXT:    li r4, 144
; BE-P8-NEXT:    std r14, 336(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    std r15, 344(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    std r16, 352(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    std r17, 360(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stxvd2x v20, r1, r4 # 16-byte Folded Spill
; BE-P8-NEXT:    li r4, 160
; BE-P8-NEXT:    std r18, 368(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    std r19, 376(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    std r20, 384(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    std r21, 392(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stxvd2x v21, r1, r4 # 16-byte Folded Spill
; BE-P8-NEXT:    li r4, 176
; BE-P8-NEXT:    std r22, 400(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    std r23, 408(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    std r24, 416(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    std r25, 424(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    std r26, 432(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    std r27, 440(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    std r28, 448(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    std r29, 456(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    std r30, 464(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    std r31, 472(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    std r3, 120(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stxvd2x v22, r1, r4 # 16-byte Folded Spill
; BE-P8-NEXT:    li r4, 192
; BE-P8-NEXT:    stxvd2x v23, r1, r4 # 16-byte Folded Spill
; BE-P8-NEXT:    li r4, 208
; BE-P8-NEXT:    stfd f14, 480(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stxvd2x v24, r1, r4 # 16-byte Folded Spill
; BE-P8-NEXT:    li r4, 224
; BE-P8-NEXT:    stfd f15, 488(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stxvd2x v25, r1, r4 # 16-byte Folded Spill
; BE-P8-NEXT:    li r4, 240
; BE-P8-NEXT:    stfd f16, 496(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stxvd2x v26, r1, r4 # 16-byte Folded Spill
; BE-P8-NEXT:    li r4, 256
; BE-P8-NEXT:    stfd f17, 504(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stxvd2x v27, r1, r4 # 16-byte Folded Spill
; BE-P8-NEXT:    li r4, 272
; BE-P8-NEXT:    stfd f18, 512(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stxvd2x v28, r1, r4 # 16-byte Folded Spill
; BE-P8-NEXT:    li r4, 288
; BE-P8-NEXT:    stfd f19, 520(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stxvd2x v29, r1, r4 # 16-byte Folded Spill
; BE-P8-NEXT:    li r4, 304
; BE-P8-NEXT:    stfd f20, 528(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stxvd2x v30, r1, r4 # 16-byte Folded Spill
; BE-P8-NEXT:    li r4, 320
; BE-P8-NEXT:    stfd f21, 536(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stxvd2x v31, r1, r4 # 16-byte Folded Spill
; BE-P8-NEXT:    lwz r4, 12(r3)
; BE-P8-NEXT:    stfd f22, 544(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stfd f23, 552(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stfd f24, 560(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stfd f25, 568(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stfd f26, 576(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stfd f27, 584(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stfd f28, 592(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stfd f29, 600(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stfd f30, 608(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stfd f31, 616(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    stw r4, 132(r1)
; BE-P8-NEXT:    #APP
; BE-P8-NEXT:    nop
; BE-P8-NEXT:    #NO_APP
; BE-P8-NEXT:    addi r3, r1, 132
; BE-P8-NEXT:    bl callee2
; BE-P8-NEXT:    nop
; BE-P8-NEXT:    ld r4, 120(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    lfd f31, 616(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    lfd f30, 608(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    ld r31, 472(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    lfd f29, 600(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    lfd f28, 592(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    ld r30, 464(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    ld r29, 456(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    lwz r4, 16(r4)
; BE-P8-NEXT:    lfd f27, 584(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    lfd f26, 576(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    ld r28, 448(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    lfd f25, 568(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    lfd f24, 560(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    ld r27, 440(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    ld r26, 432(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    add r3, r4, r3
; BE-P8-NEXT:    li r4, 320
; BE-P8-NEXT:    lfd f23, 552(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    lfd f22, 544(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    ld r25, 424(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    ld r24, 416(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    lxvd2x v31, r1, r4 # 16-byte Folded Reload
; BE-P8-NEXT:    li r4, 304
; BE-P8-NEXT:    lfd f21, 536(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    ld r23, 408(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    ld r22, 400(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    clrldi r3, r3, 32
; BE-P8-NEXT:    lxvd2x v30, r1, r4 # 16-byte Folded Reload
; BE-P8-NEXT:    li r4, 288
; BE-P8-NEXT:    lfd f20, 528(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    ld r21, 392(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    ld r20, 384(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    lxvd2x v29, r1, r4 # 16-byte Folded Reload
; BE-P8-NEXT:    li r4, 272
; BE-P8-NEXT:    lfd f19, 520(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    ld r19, 376(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    ld r18, 368(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    lxvd2x v28, r1, r4 # 16-byte Folded Reload
; BE-P8-NEXT:    li r4, 256
; BE-P8-NEXT:    lfd f18, 512(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    ld r17, 360(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    ld r16, 352(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    lxvd2x v27, r1, r4 # 16-byte Folded Reload
; BE-P8-NEXT:    li r4, 240
; BE-P8-NEXT:    lfd f17, 504(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    ld r15, 344(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    ld r14, 336(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    lxvd2x v26, r1, r4 # 16-byte Folded Reload
; BE-P8-NEXT:    li r4, 224
; BE-P8-NEXT:    lfd f16, 496(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    lxvd2x v25, r1, r4 # 16-byte Folded Reload
; BE-P8-NEXT:    li r4, 208
; BE-P8-NEXT:    lfd f15, 488(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    lxvd2x v24, r1, r4 # 16-byte Folded Reload
; BE-P8-NEXT:    li r4, 192
; BE-P8-NEXT:    lfd f14, 480(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    lxvd2x v23, r1, r4 # 16-byte Folded Reload
; BE-P8-NEXT:    li r4, 176
; BE-P8-NEXT:    lxvd2x v22, r1, r4 # 16-byte Folded Reload
; BE-P8-NEXT:    li r4, 160
; BE-P8-NEXT:    lxvd2x v21, r1, r4 # 16-byte Folded Reload
; BE-P8-NEXT:    li r4, 144
; BE-P8-NEXT:    lxvd2x v20, r1, r4 # 16-byte Folded Reload
; BE-P8-NEXT:    addi r1, r1, 624
; BE-P8-NEXT:    ld r0, 16(r1)
; BE-P8-NEXT:    lwz r12, 8(r1)
; BE-P8-NEXT:    mtocrf 32, r12
; BE-P8-NEXT:    hashchk r0, -488(r1)
; BE-P8-NEXT:    mtlr r0
; BE-P8-NEXT:    mtocrf 16, r12
; BE-P8-NEXT:    mtocrf 8, r12
; BE-P8-NEXT:    blr
;
; BE-32BIT-P10-LABEL: spill:
; BE-32BIT-P10:       # %bb.0: # %entry
; BE-32BIT-P10-NEXT:    mflr r0
; BE-32BIT-P10-NEXT:    stw r0, 4(r1)
; BE-32BIT-P10-NEXT:    hashst r0, -424(r1)
; BE-32BIT-P10-NEXT:    stwu r1, -448(r1)
; BE-32BIT-P10-NEXT:    mfcr r12
; BE-32BIT-P10-NEXT:    stw r14, 232(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r15, 236(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r16, 240(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r17, 244(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r18, 248(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r19, 252(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r20, 256(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r21, 260(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r22, 264(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r23, 268(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r24, 272(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r25, 276(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r26, 280(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r27, 284(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r28, 288(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r29, 292(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r30, 296(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r31, 300(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r12, 228(r1)
; BE-32BIT-P10-NEXT:    lwz r4, 12(r3)
; BE-32BIT-P10-NEXT:    stfd f14, 304(r1) # 8-byte Folded Spill
; BE-32BIT-P10-NEXT:    stfd f15, 312(r1) # 8-byte Folded Spill
; BE-32BIT-P10-NEXT:    stfd f16, 320(r1) # 8-byte Folded Spill
; BE-32BIT-P10-NEXT:    stfd f17, 328(r1) # 8-byte Folded Spill
; BE-32BIT-P10-NEXT:    stfd f18, 336(r1) # 8-byte Folded Spill
; BE-32BIT-P10-NEXT:    stfd f19, 344(r1) # 8-byte Folded Spill
; BE-32BIT-P10-NEXT:    stfd f20, 352(r1) # 8-byte Folded Spill
; BE-32BIT-P10-NEXT:    stfd f21, 360(r1) # 8-byte Folded Spill
; BE-32BIT-P10-NEXT:    stfd f22, 368(r1) # 8-byte Folded Spill
; BE-32BIT-P10-NEXT:    stfd f23, 376(r1) # 8-byte Folded Spill
; BE-32BIT-P10-NEXT:    stfd f24, 384(r1) # 8-byte Folded Spill
; BE-32BIT-P10-NEXT:    stfd f25, 392(r1) # 8-byte Folded Spill
; BE-32BIT-P10-NEXT:    stfd f26, 400(r1) # 8-byte Folded Spill
; BE-32BIT-P10-NEXT:    stfd f27, 408(r1) # 8-byte Folded Spill
; BE-32BIT-P10-NEXT:    stfd f28, 416(r1) # 8-byte Folded Spill
; BE-32BIT-P10-NEXT:    stfd f29, 424(r1) # 8-byte Folded Spill
; BE-32BIT-P10-NEXT:    stfd f30, 432(r1) # 8-byte Folded Spill
; BE-32BIT-P10-NEXT:    stfd f31, 440(r1) # 8-byte Folded Spill
; BE-32BIT-P10-NEXT:    stxv v20, 32(r1) # 16-byte Folded Spill
; BE-32BIT-P10-NEXT:    stxv v21, 48(r1) # 16-byte Folded Spill
; BE-32BIT-P10-NEXT:    stxv v22, 64(r1) # 16-byte Folded Spill
; BE-32BIT-P10-NEXT:    stxv v23, 80(r1) # 16-byte Folded Spill
; BE-32BIT-P10-NEXT:    stxv v24, 96(r1) # 16-byte Folded Spill
; BE-32BIT-P10-NEXT:    stxv v25, 112(r1) # 16-byte Folded Spill
; BE-32BIT-P10-NEXT:    stxv v26, 128(r1) # 16-byte Folded Spill
; BE-32BIT-P10-NEXT:    stxv v27, 144(r1) # 16-byte Folded Spill
; BE-32BIT-P10-NEXT:    stxv v28, 160(r1) # 16-byte Folded Spill
; BE-32BIT-P10-NEXT:    stxv v29, 176(r1) # 16-byte Folded Spill
; BE-32BIT-P10-NEXT:    stxv v30, 192(r1) # 16-byte Folded Spill
; BE-32BIT-P10-NEXT:    stxv v31, 208(r1) # 16-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r3, 16(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    stw r4, 20(r1)
; BE-32BIT-P10-NEXT:    #APP
; BE-32BIT-P10-NEXT:    nop
; BE-32BIT-P10-NEXT:    #NO_APP
; BE-32BIT-P10-NEXT:    addi r3, r1, 20
; BE-32BIT-P10-NEXT:    bl callee2
; BE-32BIT-P10-NEXT:    lwz r4, 16(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lxv v31, 208(r1) # 16-byte Folded Reload
; BE-32BIT-P10-NEXT:    lxv v30, 192(r1) # 16-byte Folded Reload
; BE-32BIT-P10-NEXT:    lxv v29, 176(r1) # 16-byte Folded Reload
; BE-32BIT-P10-NEXT:    lxv v28, 160(r1) # 16-byte Folded Reload
; BE-32BIT-P10-NEXT:    lxv v27, 144(r1) # 16-byte Folded Reload
; BE-32BIT-P10-NEXT:    lxv v26, 128(r1) # 16-byte Folded Reload
; BE-32BIT-P10-NEXT:    lxv v25, 112(r1) # 16-byte Folded Reload
; BE-32BIT-P10-NEXT:    lxv v24, 96(r1) # 16-byte Folded Reload
; BE-32BIT-P10-NEXT:    lxv v23, 80(r1) # 16-byte Folded Reload
; BE-32BIT-P10-NEXT:    lxv v22, 64(r1) # 16-byte Folded Reload
; BE-32BIT-P10-NEXT:    lxv v21, 48(r1) # 16-byte Folded Reload
; BE-32BIT-P10-NEXT:    lxv v20, 32(r1) # 16-byte Folded Reload
; BE-32BIT-P10-NEXT:    lfd f31, 440(r1) # 8-byte Folded Reload
; BE-32BIT-P10-NEXT:    lfd f30, 432(r1) # 8-byte Folded Reload
; BE-32BIT-P10-NEXT:    lfd f29, 424(r1) # 8-byte Folded Reload
; BE-32BIT-P10-NEXT:    lfd f28, 416(r1) # 8-byte Folded Reload
; BE-32BIT-P10-NEXT:    lfd f27, 408(r1) # 8-byte Folded Reload
; BE-32BIT-P10-NEXT:    lfd f26, 400(r1) # 8-byte Folded Reload
; BE-32BIT-P10-NEXT:    lfd f25, 392(r1) # 8-byte Folded Reload
; BE-32BIT-P10-NEXT:    lfd f24, 384(r1) # 8-byte Folded Reload
; BE-32BIT-P10-NEXT:    lfd f23, 376(r1) # 8-byte Folded Reload
; BE-32BIT-P10-NEXT:    lfd f22, 368(r1) # 8-byte Folded Reload
; BE-32BIT-P10-NEXT:    lfd f21, 360(r1) # 8-byte Folded Reload
; BE-32BIT-P10-NEXT:    lfd f20, 352(r1) # 8-byte Folded Reload
; BE-32BIT-P10-NEXT:    lfd f19, 344(r1) # 8-byte Folded Reload
; BE-32BIT-P10-NEXT:    lfd f18, 336(r1) # 8-byte Folded Reload
; BE-32BIT-P10-NEXT:    lfd f17, 328(r1) # 8-byte Folded Reload
; BE-32BIT-P10-NEXT:    lfd f16, 320(r1) # 8-byte Folded Reload
; BE-32BIT-P10-NEXT:    lfd f15, 312(r1) # 8-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r4, 16(r4)
; BE-32BIT-P10-NEXT:    add r3, r4, r3
; BE-32BIT-P10-NEXT:    lwz r12, 228(r1)
; BE-32BIT-P10-NEXT:    mtocrf 32, r12
; BE-32BIT-P10-NEXT:    mtocrf 16, r12
; BE-32BIT-P10-NEXT:    mtocrf 8, r12
; BE-32BIT-P10-NEXT:    lfd f14, 304(r1) # 8-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r31, 300(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r30, 296(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r29, 292(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r28, 288(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r27, 284(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r26, 280(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r25, 276(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r24, 272(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r23, 268(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r22, 264(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r21, 260(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r20, 256(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r19, 252(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r18, 248(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r17, 244(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r16, 240(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r15, 236(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r14, 232(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r0, 452(r1)
; BE-32BIT-P10-NEXT:    addi r1, r1, 448
; BE-32BIT-P10-NEXT:    hashchk r0, -424(r1)
; BE-32BIT-P10-NEXT:    mtlr r0
; BE-32BIT-P10-NEXT:    blr
;
; BE-32BIT-P9-LABEL: spill:
; BE-32BIT-P9:       # %bb.0: # %entry
; BE-32BIT-P9-NEXT:    mflr r0
; BE-32BIT-P9-NEXT:    stw r0, 4(r1)
; BE-32BIT-P9-NEXT:    hashst r0, -424(r1)
; BE-32BIT-P9-NEXT:    stwu r1, -448(r1)
; BE-32BIT-P9-NEXT:    mfcr r12
; BE-32BIT-P9-NEXT:    stw r14, 232(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r15, 236(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r16, 240(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r17, 244(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r18, 248(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r19, 252(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r20, 256(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r21, 260(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r22, 264(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r23, 268(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r24, 272(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r25, 276(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r26, 280(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r27, 284(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r28, 288(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r29, 292(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r30, 296(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r31, 300(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r12, 228(r1)
; BE-32BIT-P9-NEXT:    stxv v20, 32(r1) # 16-byte Folded Spill
; BE-32BIT-P9-NEXT:    stxv v21, 48(r1) # 16-byte Folded Spill
; BE-32BIT-P9-NEXT:    stxv v22, 64(r1) # 16-byte Folded Spill
; BE-32BIT-P9-NEXT:    stxv v23, 80(r1) # 16-byte Folded Spill
; BE-32BIT-P9-NEXT:    stxv v24, 96(r1) # 16-byte Folded Spill
; BE-32BIT-P9-NEXT:    stxv v25, 112(r1) # 16-byte Folded Spill
; BE-32BIT-P9-NEXT:    stxv v26, 128(r1) # 16-byte Folded Spill
; BE-32BIT-P9-NEXT:    stxv v27, 144(r1) # 16-byte Folded Spill
; BE-32BIT-P9-NEXT:    stxv v28, 160(r1) # 16-byte Folded Spill
; BE-32BIT-P9-NEXT:    stxv v29, 176(r1) # 16-byte Folded Spill
; BE-32BIT-P9-NEXT:    stxv v30, 192(r1) # 16-byte Folded Spill
; BE-32BIT-P9-NEXT:    stxv v31, 208(r1) # 16-byte Folded Spill
; BE-32BIT-P9-NEXT:    lwz r4, 12(r3)
; BE-32BIT-P9-NEXT:    stfd f14, 304(r1) # 8-byte Folded Spill
; BE-32BIT-P9-NEXT:    stfd f15, 312(r1) # 8-byte Folded Spill
; BE-32BIT-P9-NEXT:    stfd f16, 320(r1) # 8-byte Folded Spill
; BE-32BIT-P9-NEXT:    stfd f17, 328(r1) # 8-byte Folded Spill
; BE-32BIT-P9-NEXT:    stfd f18, 336(r1) # 8-byte Folded Spill
; BE-32BIT-P9-NEXT:    stfd f19, 344(r1) # 8-byte Folded Spill
; BE-32BIT-P9-NEXT:    stfd f20, 352(r1) # 8-byte Folded Spill
; BE-32BIT-P9-NEXT:    stfd f21, 360(r1) # 8-byte Folded Spill
; BE-32BIT-P9-NEXT:    stfd f22, 368(r1) # 8-byte Folded Spill
; BE-32BIT-P9-NEXT:    stfd f23, 376(r1) # 8-byte Folded Spill
; BE-32BIT-P9-NEXT:    stfd f24, 384(r1) # 8-byte Folded Spill
; BE-32BIT-P9-NEXT:    stfd f25, 392(r1) # 8-byte Folded Spill
; BE-32BIT-P9-NEXT:    stfd f26, 400(r1) # 8-byte Folded Spill
; BE-32BIT-P9-NEXT:    stfd f27, 408(r1) # 8-byte Folded Spill
; BE-32BIT-P9-NEXT:    stfd f28, 416(r1) # 8-byte Folded Spill
; BE-32BIT-P9-NEXT:    stfd f29, 424(r1) # 8-byte Folded Spill
; BE-32BIT-P9-NEXT:    stfd f30, 432(r1) # 8-byte Folded Spill
; BE-32BIT-P9-NEXT:    stfd f31, 440(r1) # 8-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r3, 16(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    stw r4, 20(r1)
; BE-32BIT-P9-NEXT:    #APP
; BE-32BIT-P9-NEXT:    nop
; BE-32BIT-P9-NEXT:    #NO_APP
; BE-32BIT-P9-NEXT:    addi r3, r1, 20
; BE-32BIT-P9-NEXT:    bl callee2
; BE-32BIT-P9-NEXT:    lwz r4, 16(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lxv v31, 208(r1) # 16-byte Folded Reload
; BE-32BIT-P9-NEXT:    lxv v30, 192(r1) # 16-byte Folded Reload
; BE-32BIT-P9-NEXT:    lxv v29, 176(r1) # 16-byte Folded Reload
; BE-32BIT-P9-NEXT:    lxv v28, 160(r1) # 16-byte Folded Reload
; BE-32BIT-P9-NEXT:    lxv v27, 144(r1) # 16-byte Folded Reload
; BE-32BIT-P9-NEXT:    lxv v26, 128(r1) # 16-byte Folded Reload
; BE-32BIT-P9-NEXT:    lxv v25, 112(r1) # 16-byte Folded Reload
; BE-32BIT-P9-NEXT:    lxv v24, 96(r1) # 16-byte Folded Reload
; BE-32BIT-P9-NEXT:    lxv v23, 80(r1) # 16-byte Folded Reload
; BE-32BIT-P9-NEXT:    lxv v22, 64(r1) # 16-byte Folded Reload
; BE-32BIT-P9-NEXT:    lxv v21, 48(r1) # 16-byte Folded Reload
; BE-32BIT-P9-NEXT:    lxv v20, 32(r1) # 16-byte Folded Reload
; BE-32BIT-P9-NEXT:    lfd f31, 440(r1) # 8-byte Folded Reload
; BE-32BIT-P9-NEXT:    lfd f30, 432(r1) # 8-byte Folded Reload
; BE-32BIT-P9-NEXT:    lfd f29, 424(r1) # 8-byte Folded Reload
; BE-32BIT-P9-NEXT:    lfd f28, 416(r1) # 8-byte Folded Reload
; BE-32BIT-P9-NEXT:    lfd f27, 408(r1) # 8-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r4, 16(r4)
; BE-32BIT-P9-NEXT:    lfd f26, 400(r1) # 8-byte Folded Reload
; BE-32BIT-P9-NEXT:    add r3, r4, r3
; BE-32BIT-P9-NEXT:    lfd f25, 392(r1) # 8-byte Folded Reload
; BE-32BIT-P9-NEXT:    lfd f24, 384(r1) # 8-byte Folded Reload
; BE-32BIT-P9-NEXT:    lfd f23, 376(r1) # 8-byte Folded Reload
; BE-32BIT-P9-NEXT:    lfd f22, 368(r1) # 8-byte Folded Reload
; BE-32BIT-P9-NEXT:    lfd f21, 360(r1) # 8-byte Folded Reload
; BE-32BIT-P9-NEXT:    lfd f20, 352(r1) # 8-byte Folded Reload
; BE-32BIT-P9-NEXT:    lfd f19, 344(r1) # 8-byte Folded Reload
; BE-32BIT-P9-NEXT:    lfd f18, 336(r1) # 8-byte Folded Reload
; BE-32BIT-P9-NEXT:    lfd f17, 328(r1) # 8-byte Folded Reload
; BE-32BIT-P9-NEXT:    lfd f16, 320(r1) # 8-byte Folded Reload
; BE-32BIT-P9-NEXT:    lfd f15, 312(r1) # 8-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r12, 228(r1)
; BE-32BIT-P9-NEXT:    lwz r31, 300(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r30, 296(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r29, 292(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r28, 288(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r27, 284(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r26, 280(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r25, 276(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r24, 272(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r23, 268(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r22, 264(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r21, 260(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r20, 256(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r19, 252(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r18, 248(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r17, 244(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r16, 240(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r15, 236(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r14, 232(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lfd f14, 304(r1) # 8-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r0, 452(r1)
; BE-32BIT-P9-NEXT:    mtocrf 32, r12
; BE-32BIT-P9-NEXT:    mtocrf 16, r12
; BE-32BIT-P9-NEXT:    mtocrf 8, r12
; BE-32BIT-P9-NEXT:    addi r1, r1, 448
; BE-32BIT-P9-NEXT:    mtlr r0
; BE-32BIT-P9-NEXT:    hashchk r0, -424(r1)
; BE-32BIT-P9-NEXT:    blr
;
; BE-32BIT-P8-LABEL: spill:
; BE-32BIT-P8:       # %bb.0: # %entry
; BE-32BIT-P8-NEXT:    mflr r0
; BE-32BIT-P8-NEXT:    stw r0, 4(r1)
; BE-32BIT-P8-NEXT:    hashst r0, -424(r1)
; BE-32BIT-P8-NEXT:    stwu r1, -448(r1)
; BE-32BIT-P8-NEXT:    mfcr r12
; BE-32BIT-P8-NEXT:    li r4, 32
; BE-32BIT-P8-NEXT:    stw r14, 232(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r15, 236(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r16, 240(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r17, 244(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r18, 248(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r19, 252(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r20, 256(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r21, 260(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r22, 264(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r23, 268(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r24, 272(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r25, 276(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r26, 280(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r27, 284(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r28, 288(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r29, 292(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r30, 296(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r31, 300(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r12, 228(r1)
; BE-32BIT-P8-NEXT:    stxvd2x v20, r1, r4 # 16-byte Folded Spill
; BE-32BIT-P8-NEXT:    li r4, 48
; BE-32BIT-P8-NEXT:    stxvd2x v21, r1, r4 # 16-byte Folded Spill
; BE-32BIT-P8-NEXT:    li r4, 64
; BE-32BIT-P8-NEXT:    stfd f14, 304(r1) # 8-byte Folded Spill
; BE-32BIT-P8-NEXT:    stxvd2x v22, r1, r4 # 16-byte Folded Spill
; BE-32BIT-P8-NEXT:    li r4, 80
; BE-32BIT-P8-NEXT:    stfd f15, 312(r1) # 8-byte Folded Spill
; BE-32BIT-P8-NEXT:    stxvd2x v23, r1, r4 # 16-byte Folded Spill
; BE-32BIT-P8-NEXT:    li r4, 96
; BE-32BIT-P8-NEXT:    stfd f16, 320(r1) # 8-byte Folded Spill
; BE-32BIT-P8-NEXT:    stxvd2x v24, r1, r4 # 16-byte Folded Spill
; BE-32BIT-P8-NEXT:    li r4, 112
; BE-32BIT-P8-NEXT:    stfd f17, 328(r1) # 8-byte Folded Spill
; BE-32BIT-P8-NEXT:    stxvd2x v25, r1, r4 # 16-byte Folded Spill
; BE-32BIT-P8-NEXT:    li r4, 128
; BE-32BIT-P8-NEXT:    stfd f18, 336(r1) # 8-byte Folded Spill
; BE-32BIT-P8-NEXT:    stxvd2x v26, r1, r4 # 16-byte Folded Spill
; BE-32BIT-P8-NEXT:    li r4, 144
; BE-32BIT-P8-NEXT:    stfd f19, 344(r1) # 8-byte Folded Spill
; BE-32BIT-P8-NEXT:    stxvd2x v27, r1, r4 # 16-byte Folded Spill
; BE-32BIT-P8-NEXT:    li r4, 160
; BE-32BIT-P8-NEXT:    stfd f20, 352(r1) # 8-byte Folded Spill
; BE-32BIT-P8-NEXT:    stxvd2x v28, r1, r4 # 16-byte Folded Spill
; BE-32BIT-P8-NEXT:    li r4, 176
; BE-32BIT-P8-NEXT:    stfd f21, 360(r1) # 8-byte Folded Spill
; BE-32BIT-P8-NEXT:    stxvd2x v29, r1, r4 # 16-byte Folded Spill
; BE-32BIT-P8-NEXT:    li r4, 192
; BE-32BIT-P8-NEXT:    stfd f22, 368(r1) # 8-byte Folded Spill
; BE-32BIT-P8-NEXT:    stxvd2x v30, r1, r4 # 16-byte Folded Spill
; BE-32BIT-P8-NEXT:    li r4, 208
; BE-32BIT-P8-NEXT:    stfd f23, 376(r1) # 8-byte Folded Spill
; BE-32BIT-P8-NEXT:    stxvd2x v31, r1, r4 # 16-byte Folded Spill
; BE-32BIT-P8-NEXT:    lwz r4, 12(r3)
; BE-32BIT-P8-NEXT:    stfd f24, 384(r1) # 8-byte Folded Spill
; BE-32BIT-P8-NEXT:    stfd f25, 392(r1) # 8-byte Folded Spill
; BE-32BIT-P8-NEXT:    stfd f26, 400(r1) # 8-byte Folded Spill
; BE-32BIT-P8-NEXT:    stfd f27, 408(r1) # 8-byte Folded Spill
; BE-32BIT-P8-NEXT:    stfd f28, 416(r1) # 8-byte Folded Spill
; BE-32BIT-P8-NEXT:    stfd f29, 424(r1) # 8-byte Folded Spill
; BE-32BIT-P8-NEXT:    stfd f30, 432(r1) # 8-byte Folded Spill
; BE-32BIT-P8-NEXT:    stfd f31, 440(r1) # 8-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r3, 16(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    stw r4, 20(r1)
; BE-32BIT-P8-NEXT:    #APP
; BE-32BIT-P8-NEXT:    nop
; BE-32BIT-P8-NEXT:    #NO_APP
; BE-32BIT-P8-NEXT:    addi r3, r1, 20
; BE-32BIT-P8-NEXT:    bl callee2
; BE-32BIT-P8-NEXT:    lwz r4, 16(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    lfd f31, 440(r1) # 8-byte Folded Reload
; BE-32BIT-P8-NEXT:    lfd f30, 432(r1) # 8-byte Folded Reload
; BE-32BIT-P8-NEXT:    lfd f29, 424(r1) # 8-byte Folded Reload
; BE-32BIT-P8-NEXT:    lfd f28, 416(r1) # 8-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r4, 16(r4)
; BE-32BIT-P8-NEXT:    lfd f27, 408(r1) # 8-byte Folded Reload
; BE-32BIT-P8-NEXT:    lfd f26, 400(r1) # 8-byte Folded Reload
; BE-32BIT-P8-NEXT:    lfd f25, 392(r1) # 8-byte Folded Reload
; BE-32BIT-P8-NEXT:    lfd f24, 384(r1) # 8-byte Folded Reload
; BE-32BIT-P8-NEXT:    add r3, r4, r3
; BE-32BIT-P8-NEXT:    li r4, 208
; BE-32BIT-P8-NEXT:    lfd f23, 376(r1) # 8-byte Folded Reload
; BE-32BIT-P8-NEXT:    lfd f22, 368(r1) # 8-byte Folded Reload
; BE-32BIT-P8-NEXT:    lxvd2x v31, r1, r4 # 16-byte Folded Reload
; BE-32BIT-P8-NEXT:    li r4, 192
; BE-32BIT-P8-NEXT:    lfd f21, 360(r1) # 8-byte Folded Reload
; BE-32BIT-P8-NEXT:    lxvd2x v30, r1, r4 # 16-byte Folded Reload
; BE-32BIT-P8-NEXT:    li r4, 176
; BE-32BIT-P8-NEXT:    lfd f20, 352(r1) # 8-byte Folded Reload
; BE-32BIT-P8-NEXT:    lxvd2x v29, r1, r4 # 16-byte Folded Reload
; BE-32BIT-P8-NEXT:    li r4, 160
; BE-32BIT-P8-NEXT:    lfd f19, 344(r1) # 8-byte Folded Reload
; BE-32BIT-P8-NEXT:    lxvd2x v28, r1, r4 # 16-byte Folded Reload
; BE-32BIT-P8-NEXT:    li r4, 144
; BE-32BIT-P8-NEXT:    lfd f18, 336(r1) # 8-byte Folded Reload
; BE-32BIT-P8-NEXT:    lxvd2x v27, r1, r4 # 16-byte Folded Reload
; BE-32BIT-P8-NEXT:    li r4, 128
; BE-32BIT-P8-NEXT:    lfd f17, 328(r1) # 8-byte Folded Reload
; BE-32BIT-P8-NEXT:    lxvd2x v26, r1, r4 # 16-byte Folded Reload
; BE-32BIT-P8-NEXT:    li r4, 112
; BE-32BIT-P8-NEXT:    lfd f16, 320(r1) # 8-byte Folded Reload
; BE-32BIT-P8-NEXT:    lxvd2x v25, r1, r4 # 16-byte Folded Reload
; BE-32BIT-P8-NEXT:    li r4, 96
; BE-32BIT-P8-NEXT:    lfd f15, 312(r1) # 8-byte Folded Reload
; BE-32BIT-P8-NEXT:    lxvd2x v24, r1, r4 # 16-byte Folded Reload
; BE-32BIT-P8-NEXT:    li r4, 80
; BE-32BIT-P8-NEXT:    lxvd2x v23, r1, r4 # 16-byte Folded Reload
; BE-32BIT-P8-NEXT:    li r4, 64
; BE-32BIT-P8-NEXT:    lxvd2x v22, r1, r4 # 16-byte Folded Reload
; BE-32BIT-P8-NEXT:    li r4, 48
; BE-32BIT-P8-NEXT:    lxvd2x v21, r1, r4 # 16-byte Folded Reload
; BE-32BIT-P8-NEXT:    li r4, 32
; BE-32BIT-P8-NEXT:    lxvd2x v20, r1, r4 # 16-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r12, 228(r1)
; BE-32BIT-P8-NEXT:    lfd f14, 304(r1) # 8-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r31, 300(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r30, 296(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r29, 292(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r28, 288(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r27, 284(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r26, 280(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r25, 276(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r24, 272(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r23, 268(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    mtocrf 32, r12
; BE-32BIT-P8-NEXT:    lwz r22, 264(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r21, 260(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r20, 256(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r19, 252(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    mtocrf 16, r12
; BE-32BIT-P8-NEXT:    lwz r18, 248(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r17, 244(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r16, 240(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r15, 236(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    mtocrf 8, r12
; BE-32BIT-P8-NEXT:    lwz r14, 232(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r0, 452(r1)
; BE-32BIT-P8-NEXT:    addi r1, r1, 448
; BE-32BIT-P8-NEXT:    mtlr r0
; BE-32BIT-P8-NEXT:    hashchk r0, -424(r1)
; BE-32BIT-P8-NEXT:    blr
;
; LE-P10-PRIV-LABEL: spill:
; LE-P10-PRIV:       # %bb.0: # %entry
; LE-P10-PRIV-NEXT:    mflr r0
; LE-P10-PRIV-NEXT:    mfcr r12
; LE-P10-PRIV-NEXT:    std r0, 16(r1)
; LE-P10-PRIV-NEXT:    hashstp r0, -488(r1)
; LE-P10-PRIV-NEXT:    stw r12, 8(r1)
; LE-P10-PRIV-NEXT:    stdu r1, -544(r1)
; LE-P10-PRIV-NEXT:    lwz r4, 12(r3)
; LE-P10-PRIV-NEXT:    std r14, 256(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r15, 264(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r16, 272(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r17, 280(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r18, 288(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r19, 296(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r20, 304(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r21, 312(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r22, 320(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r23, 328(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r24, 336(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r25, 344(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r26, 352(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r27, 360(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r28, 368(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r29, 376(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r30, 384(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r31, 392(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stfd f14, 400(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stfd f15, 408(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stfd f16, 416(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stfd f17, 424(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stfd f18, 432(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stfd f19, 440(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stfd f20, 448(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stfd f21, 456(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stfd f22, 464(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stfd f23, 472(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stfd f24, 480(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stfd f25, 488(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stfd f26, 496(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stfd f27, 504(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stfd f28, 512(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stfd f29, 520(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stfd f30, 528(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stfd f31, 536(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stxv v20, 64(r1) # 16-byte Folded Spill
; LE-P10-PRIV-NEXT:    stxv v21, 80(r1) # 16-byte Folded Spill
; LE-P10-PRIV-NEXT:    stxv v22, 96(r1) # 16-byte Folded Spill
; LE-P10-PRIV-NEXT:    stxv v23, 112(r1) # 16-byte Folded Spill
; LE-P10-PRIV-NEXT:    stxv v24, 128(r1) # 16-byte Folded Spill
; LE-P10-PRIV-NEXT:    stxv v25, 144(r1) # 16-byte Folded Spill
; LE-P10-PRIV-NEXT:    stxv v26, 160(r1) # 16-byte Folded Spill
; LE-P10-PRIV-NEXT:    stxv v27, 176(r1) # 16-byte Folded Spill
; LE-P10-PRIV-NEXT:    stxv v28, 192(r1) # 16-byte Folded Spill
; LE-P10-PRIV-NEXT:    stxv v29, 208(r1) # 16-byte Folded Spill
; LE-P10-PRIV-NEXT:    stxv v30, 224(r1) # 16-byte Folded Spill
; LE-P10-PRIV-NEXT:    stxv v31, 240(r1) # 16-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r3, 40(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    stw r4, 52(r1)
; LE-P10-PRIV-NEXT:    #APP
; LE-P10-PRIV-NEXT:    nop
; LE-P10-PRIV-NEXT:    #NO_APP
; LE-P10-PRIV-NEXT:    addi r3, r1, 52
; LE-P10-PRIV-NEXT:    bl callee2@notoc
; LE-P10-PRIV-NEXT:    ld r4, 40(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lxv v31, 240(r1) # 16-byte Folded Reload
; LE-P10-PRIV-NEXT:    lxv v30, 224(r1) # 16-byte Folded Reload
; LE-P10-PRIV-NEXT:    lxv v29, 208(r1) # 16-byte Folded Reload
; LE-P10-PRIV-NEXT:    lxv v28, 192(r1) # 16-byte Folded Reload
; LE-P10-PRIV-NEXT:    lxv v27, 176(r1) # 16-byte Folded Reload
; LE-P10-PRIV-NEXT:    lxv v26, 160(r1) # 16-byte Folded Reload
; LE-P10-PRIV-NEXT:    lxv v25, 144(r1) # 16-byte Folded Reload
; LE-P10-PRIV-NEXT:    lxv v24, 128(r1) # 16-byte Folded Reload
; LE-P10-PRIV-NEXT:    lxv v23, 112(r1) # 16-byte Folded Reload
; LE-P10-PRIV-NEXT:    lxv v22, 96(r1) # 16-byte Folded Reload
; LE-P10-PRIV-NEXT:    lxv v21, 80(r1) # 16-byte Folded Reload
; LE-P10-PRIV-NEXT:    lxv v20, 64(r1) # 16-byte Folded Reload
; LE-P10-PRIV-NEXT:    lfd f31, 536(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lfd f30, 528(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lfd f29, 520(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lfd f28, 512(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lfd f27, 504(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lfd f26, 496(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lfd f25, 488(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lfd f24, 480(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lfd f23, 472(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lfd f22, 464(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lfd f21, 456(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lfd f20, 448(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lfd f19, 440(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lfd f18, 432(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lfd f17, 424(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lfd f16, 416(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lfd f15, 408(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lfd f14, 400(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    ld r31, 392(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    ld r30, 384(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    ld r29, 376(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    ld r28, 368(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    ld r27, 360(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    ld r26, 352(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    ld r25, 344(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    ld r24, 336(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    ld r23, 328(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    ld r22, 320(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    ld r21, 312(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    ld r20, 304(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    ld r19, 296(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    ld r18, 288(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    ld r17, 280(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    ld r16, 272(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    ld r15, 264(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    lwz r4, 16(r4)
; LE-P10-PRIV-NEXT:    add r3, r4, r3
; LE-P10-PRIV-NEXT:    clrldi r3, r3, 32
; LE-P10-PRIV-NEXT:    ld r14, 256(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    addi r1, r1, 544
; LE-P10-PRIV-NEXT:    ld r0, 16(r1)
; LE-P10-PRIV-NEXT:    lwz r12, 8(r1)
; LE-P10-PRIV-NEXT:    mtlr r0
; LE-P10-PRIV-NEXT:    hashchkp r0, -488(r1)
; LE-P10-PRIV-NEXT:    mtocrf 32, r12
; LE-P10-PRIV-NEXT:    mtocrf 16, r12
; LE-P10-PRIV-NEXT:    mtocrf 8, r12
; LE-P10-PRIV-NEXT:    blr
;
; LE-P9-PRIV-LABEL: spill:
; LE-P9-PRIV:       # %bb.0: # %entry
; LE-P9-PRIV-NEXT:    mflr r0
; LE-P9-PRIV-NEXT:    mfcr r12
; LE-P9-PRIV-NEXT:    std r0, 16(r1)
; LE-P9-PRIV-NEXT:    hashstp r0, -488(r1)
; LE-P9-PRIV-NEXT:    stw r12, 8(r1)
; LE-P9-PRIV-NEXT:    stdu r1, -544(r1)
; LE-P9-PRIV-NEXT:    lwz r4, 12(r3)
; LE-P9-PRIV-NEXT:    std r14, 256(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r15, 264(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stxv v20, 64(r1) # 16-byte Folded Spill
; LE-P9-PRIV-NEXT:    stxv v21, 80(r1) # 16-byte Folded Spill
; LE-P9-PRIV-NEXT:    stxv v22, 96(r1) # 16-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r16, 272(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r17, 280(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stxv v23, 112(r1) # 16-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r18, 288(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stxv v24, 128(r1) # 16-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r19, 296(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stxv v25, 144(r1) # 16-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r20, 304(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r21, 312(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stxv v26, 160(r1) # 16-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r22, 320(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stxv v27, 176(r1) # 16-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r23, 328(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stxv v28, 192(r1) # 16-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r24, 336(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r25, 344(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stxv v29, 208(r1) # 16-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r26, 352(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stxv v30, 224(r1) # 16-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r27, 360(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stxv v31, 240(r1) # 16-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r28, 368(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r29, 376(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r30, 384(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r31, 392(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stfd f14, 400(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stfd f15, 408(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stfd f16, 416(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stfd f17, 424(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stfd f18, 432(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stfd f19, 440(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stfd f20, 448(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stfd f21, 456(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stfd f22, 464(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stfd f23, 472(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stfd f24, 480(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stfd f25, 488(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stfd f26, 496(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stfd f27, 504(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stfd f28, 512(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stfd f29, 520(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stfd f30, 528(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stfd f31, 536(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r3, 40(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    stw r4, 52(r1)
; LE-P9-PRIV-NEXT:    #APP
; LE-P9-PRIV-NEXT:    nop
; LE-P9-PRIV-NEXT:    #NO_APP
; LE-P9-PRIV-NEXT:    addi r3, r1, 52
; LE-P9-PRIV-NEXT:    bl callee2
; LE-P9-PRIV-NEXT:    nop
; LE-P9-PRIV-NEXT:    ld r4, 40(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    lxv v31, 240(r1) # 16-byte Folded Reload
; LE-P9-PRIV-NEXT:    lxv v30, 224(r1) # 16-byte Folded Reload
; LE-P9-PRIV-NEXT:    lxv v29, 208(r1) # 16-byte Folded Reload
; LE-P9-PRIV-NEXT:    lxv v28, 192(r1) # 16-byte Folded Reload
; LE-P9-PRIV-NEXT:    lxv v27, 176(r1) # 16-byte Folded Reload
; LE-P9-PRIV-NEXT:    lxv v26, 160(r1) # 16-byte Folded Reload
; LE-P9-PRIV-NEXT:    lxv v25, 144(r1) # 16-byte Folded Reload
; LE-P9-PRIV-NEXT:    lxv v24, 128(r1) # 16-byte Folded Reload
; LE-P9-PRIV-NEXT:    lxv v23, 112(r1) # 16-byte Folded Reload
; LE-P9-PRIV-NEXT:    lxv v22, 96(r1) # 16-byte Folded Reload
; LE-P9-PRIV-NEXT:    lxv v21, 80(r1) # 16-byte Folded Reload
; LE-P9-PRIV-NEXT:    lxv v20, 64(r1) # 16-byte Folded Reload
; LE-P9-PRIV-NEXT:    lfd f31, 536(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    lfd f30, 528(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    lfd f29, 520(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    lfd f28, 512(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    lfd f27, 504(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    ld r31, 392(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    ld r30, 384(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    ld r29, 376(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    lfd f26, 496(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    ld r28, 368(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    ld r27, 360(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    ld r26, 352(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    lfd f25, 488(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    ld r25, 344(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    ld r24, 336(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    ld r23, 328(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    lfd f24, 480(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    ld r22, 320(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    ld r21, 312(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    lwz r4, 16(r4)
; LE-P9-PRIV-NEXT:    add r3, r4, r3
; LE-P9-PRIV-NEXT:    lfd f23, 472(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    lfd f22, 464(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    ld r20, 304(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    ld r19, 296(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    ld r18, 288(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    ld r17, 280(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    ld r16, 272(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    ld r15, 264(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    ld r14, 256(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    lfd f21, 456(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    lfd f20, 448(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    lfd f19, 440(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    lfd f18, 432(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    lfd f17, 424(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    lfd f16, 416(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    lfd f15, 408(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    lfd f14, 400(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    clrldi r3, r3, 32
; LE-P9-PRIV-NEXT:    addi r1, r1, 544
; LE-P9-PRIV-NEXT:    ld r0, 16(r1)
; LE-P9-PRIV-NEXT:    lwz r12, 8(r1)
; LE-P9-PRIV-NEXT:    mtlr r0
; LE-P9-PRIV-NEXT:    hashchkp r0, -488(r1)
; LE-P9-PRIV-NEXT:    mtocrf 32, r12
; LE-P9-PRIV-NEXT:    mtocrf 16, r12
; LE-P9-PRIV-NEXT:    mtocrf 8, r12
; LE-P9-PRIV-NEXT:    blr
;
; LE-P8-PRIV-LABEL: spill:
; LE-P8-PRIV:       # %bb.0: # %entry
; LE-P8-PRIV-NEXT:    mfcr r12
; LE-P8-PRIV-NEXT:    mflr r0
; LE-P8-PRIV-NEXT:    std r0, 16(r1)
; LE-P8-PRIV-NEXT:    hashstp r0, -488(r1)
; LE-P8-PRIV-NEXT:    stw r12, 8(r1)
; LE-P8-PRIV-NEXT:    stdu r1, -544(r1)
; LE-P8-PRIV-NEXT:    li r4, 64
; LE-P8-PRIV-NEXT:    std r14, 256(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    std r15, 264(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    std r16, 272(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    std r17, 280(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stxvd2x v20, r1, r4 # 16-byte Folded Spill
; LE-P8-PRIV-NEXT:    li r4, 80
; LE-P8-PRIV-NEXT:    std r18, 288(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    std r19, 296(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    std r20, 304(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    std r21, 312(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stxvd2x v21, r1, r4 # 16-byte Folded Spill
; LE-P8-PRIV-NEXT:    li r4, 96
; LE-P8-PRIV-NEXT:    std r22, 320(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    std r23, 328(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    std r24, 336(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    std r25, 344(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    std r26, 352(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    std r27, 360(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    std r28, 368(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    std r29, 376(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    std r30, 384(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    std r31, 392(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    std r3, 40(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stxvd2x v22, r1, r4 # 16-byte Folded Spill
; LE-P8-PRIV-NEXT:    li r4, 112
; LE-P8-PRIV-NEXT:    stxvd2x v23, r1, r4 # 16-byte Folded Spill
; LE-P8-PRIV-NEXT:    li r4, 128
; LE-P8-PRIV-NEXT:    stfd f14, 400(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stxvd2x v24, r1, r4 # 16-byte Folded Spill
; LE-P8-PRIV-NEXT:    li r4, 144
; LE-P8-PRIV-NEXT:    stfd f15, 408(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stxvd2x v25, r1, r4 # 16-byte Folded Spill
; LE-P8-PRIV-NEXT:    li r4, 160
; LE-P8-PRIV-NEXT:    stfd f16, 416(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stxvd2x v26, r1, r4 # 16-byte Folded Spill
; LE-P8-PRIV-NEXT:    li r4, 176
; LE-P8-PRIV-NEXT:    stfd f17, 424(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stxvd2x v27, r1, r4 # 16-byte Folded Spill
; LE-P8-PRIV-NEXT:    li r4, 192
; LE-P8-PRIV-NEXT:    stfd f18, 432(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stxvd2x v28, r1, r4 # 16-byte Folded Spill
; LE-P8-PRIV-NEXT:    li r4, 208
; LE-P8-PRIV-NEXT:    stfd f19, 440(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stxvd2x v29, r1, r4 # 16-byte Folded Spill
; LE-P8-PRIV-NEXT:    li r4, 224
; LE-P8-PRIV-NEXT:    stfd f20, 448(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stxvd2x v30, r1, r4 # 16-byte Folded Spill
; LE-P8-PRIV-NEXT:    li r4, 240
; LE-P8-PRIV-NEXT:    stfd f21, 456(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stxvd2x v31, r1, r4 # 16-byte Folded Spill
; LE-P8-PRIV-NEXT:    lwz r4, 12(r3)
; LE-P8-PRIV-NEXT:    stfd f22, 464(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stfd f23, 472(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stfd f24, 480(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stfd f25, 488(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stfd f26, 496(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stfd f27, 504(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stfd f28, 512(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stfd f29, 520(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stfd f30, 528(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stfd f31, 536(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    stw r4, 52(r1)
; LE-P8-PRIV-NEXT:    #APP
; LE-P8-PRIV-NEXT:    nop
; LE-P8-PRIV-NEXT:    #NO_APP
; LE-P8-PRIV-NEXT:    addi r3, r1, 52
; LE-P8-PRIV-NEXT:    bl callee2
; LE-P8-PRIV-NEXT:    nop
; LE-P8-PRIV-NEXT:    ld r4, 40(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    lfd f31, 536(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    lfd f30, 528(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    ld r31, 392(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    lfd f29, 520(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    lfd f28, 512(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    ld r30, 384(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    ld r29, 376(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    lwz r4, 16(r4)
; LE-P8-PRIV-NEXT:    lfd f27, 504(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    lfd f26, 496(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    ld r28, 368(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    lfd f25, 488(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    lfd f24, 480(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    ld r27, 360(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    ld r26, 352(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    add r3, r4, r3
; LE-P8-PRIV-NEXT:    li r4, 240
; LE-P8-PRIV-NEXT:    lfd f23, 472(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    lfd f22, 464(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    ld r25, 344(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    ld r24, 336(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    lxvd2x v31, r1, r4 # 16-byte Folded Reload
; LE-P8-PRIV-NEXT:    li r4, 224
; LE-P8-PRIV-NEXT:    lfd f21, 456(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    ld r23, 328(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    ld r22, 320(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    clrldi r3, r3, 32
; LE-P8-PRIV-NEXT:    lxvd2x v30, r1, r4 # 16-byte Folded Reload
; LE-P8-PRIV-NEXT:    li r4, 208
; LE-P8-PRIV-NEXT:    lfd f20, 448(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    ld r21, 312(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    ld r20, 304(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    lxvd2x v29, r1, r4 # 16-byte Folded Reload
; LE-P8-PRIV-NEXT:    li r4, 192
; LE-P8-PRIV-NEXT:    lfd f19, 440(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    ld r19, 296(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    ld r18, 288(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    lxvd2x v28, r1, r4 # 16-byte Folded Reload
; LE-P8-PRIV-NEXT:    li r4, 176
; LE-P8-PRIV-NEXT:    lfd f18, 432(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    ld r17, 280(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    ld r16, 272(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    lxvd2x v27, r1, r4 # 16-byte Folded Reload
; LE-P8-PRIV-NEXT:    li r4, 160
; LE-P8-PRIV-NEXT:    lfd f17, 424(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    ld r15, 264(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    ld r14, 256(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    lxvd2x v26, r1, r4 # 16-byte Folded Reload
; LE-P8-PRIV-NEXT:    li r4, 144
; LE-P8-PRIV-NEXT:    lfd f16, 416(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    lxvd2x v25, r1, r4 # 16-byte Folded Reload
; LE-P8-PRIV-NEXT:    li r4, 128
; LE-P8-PRIV-NEXT:    lfd f15, 408(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    lxvd2x v24, r1, r4 # 16-byte Folded Reload
; LE-P8-PRIV-NEXT:    li r4, 112
; LE-P8-PRIV-NEXT:    lfd f14, 400(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    lxvd2x v23, r1, r4 # 16-byte Folded Reload
; LE-P8-PRIV-NEXT:    li r4, 96
; LE-P8-PRIV-NEXT:    lxvd2x v22, r1, r4 # 16-byte Folded Reload
; LE-P8-PRIV-NEXT:    li r4, 80
; LE-P8-PRIV-NEXT:    lxvd2x v21, r1, r4 # 16-byte Folded Reload
; LE-P8-PRIV-NEXT:    li r4, 64
; LE-P8-PRIV-NEXT:    lxvd2x v20, r1, r4 # 16-byte Folded Reload
; LE-P8-PRIV-NEXT:    addi r1, r1, 544
; LE-P8-PRIV-NEXT:    ld r0, 16(r1)
; LE-P8-PRIV-NEXT:    lwz r12, 8(r1)
; LE-P8-PRIV-NEXT:    mtocrf 32, r12
; LE-P8-PRIV-NEXT:    hashchkp r0, -488(r1)
; LE-P8-PRIV-NEXT:    mtlr r0
; LE-P8-PRIV-NEXT:    mtocrf 16, r12
; LE-P8-PRIV-NEXT:    mtocrf 8, r12
; LE-P8-PRIV-NEXT:    blr
;
; BE-P10-PRIV-LABEL: spill:
; BE-P10-PRIV:       # %bb.0: # %entry
; BE-P10-PRIV-NEXT:    mflr r0
; BE-P10-PRIV-NEXT:    mfcr r12
; BE-P10-PRIV-NEXT:    std r0, 16(r1)
; BE-P10-PRIV-NEXT:    hashstp r0, -488(r1)
; BE-P10-PRIV-NEXT:    stw r12, 8(r1)
; BE-P10-PRIV-NEXT:    stdu r1, -624(r1)
; BE-P10-PRIV-NEXT:    lwz r4, 12(r3)
; BE-P10-PRIV-NEXT:    std r14, 336(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    std r15, 344(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    std r16, 352(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    std r17, 360(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    std r18, 368(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    std r19, 376(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    std r20, 384(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    std r21, 392(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    std r22, 400(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    std r23, 408(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    std r24, 416(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    std r25, 424(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    std r26, 432(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    std r27, 440(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    std r28, 448(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    std r29, 456(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    std r30, 464(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    std r31, 472(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stfd f14, 480(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stfd f15, 488(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stfd f16, 496(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stfd f17, 504(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stfd f18, 512(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stfd f19, 520(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stfd f20, 528(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stfd f21, 536(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stfd f22, 544(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stfd f23, 552(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stfd f24, 560(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stfd f25, 568(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stfd f26, 576(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stfd f27, 584(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stfd f28, 592(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stfd f29, 600(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stfd f30, 608(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stfd f31, 616(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stxv v20, 144(r1) # 16-byte Folded Spill
; BE-P10-PRIV-NEXT:    stxv v21, 160(r1) # 16-byte Folded Spill
; BE-P10-PRIV-NEXT:    stxv v22, 176(r1) # 16-byte Folded Spill
; BE-P10-PRIV-NEXT:    stxv v23, 192(r1) # 16-byte Folded Spill
; BE-P10-PRIV-NEXT:    stxv v24, 208(r1) # 16-byte Folded Spill
; BE-P10-PRIV-NEXT:    stxv v25, 224(r1) # 16-byte Folded Spill
; BE-P10-PRIV-NEXT:    stxv v26, 240(r1) # 16-byte Folded Spill
; BE-P10-PRIV-NEXT:    stxv v27, 256(r1) # 16-byte Folded Spill
; BE-P10-PRIV-NEXT:    stxv v28, 272(r1) # 16-byte Folded Spill
; BE-P10-PRIV-NEXT:    stxv v29, 288(r1) # 16-byte Folded Spill
; BE-P10-PRIV-NEXT:    stxv v30, 304(r1) # 16-byte Folded Spill
; BE-P10-PRIV-NEXT:    stxv v31, 320(r1) # 16-byte Folded Spill
; BE-P10-PRIV-NEXT:    std r3, 120(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    stw r4, 132(r1)
; BE-P10-PRIV-NEXT:    #APP
; BE-P10-PRIV-NEXT:    nop
; BE-P10-PRIV-NEXT:    #NO_APP
; BE-P10-PRIV-NEXT:    addi r3, r1, 132
; BE-P10-PRIV-NEXT:    bl callee2
; BE-P10-PRIV-NEXT:    nop
; BE-P10-PRIV-NEXT:    ld r4, 120(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lxv v31, 320(r1) # 16-byte Folded Reload
; BE-P10-PRIV-NEXT:    lxv v30, 304(r1) # 16-byte Folded Reload
; BE-P10-PRIV-NEXT:    lxv v29, 288(r1) # 16-byte Folded Reload
; BE-P10-PRIV-NEXT:    lxv v28, 272(r1) # 16-byte Folded Reload
; BE-P10-PRIV-NEXT:    lxv v27, 256(r1) # 16-byte Folded Reload
; BE-P10-PRIV-NEXT:    lxv v26, 240(r1) # 16-byte Folded Reload
; BE-P10-PRIV-NEXT:    lxv v25, 224(r1) # 16-byte Folded Reload
; BE-P10-PRIV-NEXT:    lxv v24, 208(r1) # 16-byte Folded Reload
; BE-P10-PRIV-NEXT:    lxv v23, 192(r1) # 16-byte Folded Reload
; BE-P10-PRIV-NEXT:    lxv v22, 176(r1) # 16-byte Folded Reload
; BE-P10-PRIV-NEXT:    lxv v21, 160(r1) # 16-byte Folded Reload
; BE-P10-PRIV-NEXT:    lxv v20, 144(r1) # 16-byte Folded Reload
; BE-P10-PRIV-NEXT:    lfd f31, 616(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lfd f30, 608(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lfd f29, 600(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lfd f28, 592(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lfd f27, 584(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lfd f26, 576(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lfd f25, 568(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lfd f24, 560(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lfd f23, 552(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lfd f22, 544(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lfd f21, 536(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lfd f20, 528(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lfd f19, 520(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lfd f18, 512(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lfd f17, 504(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lfd f16, 496(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lfd f15, 488(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lfd f14, 480(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    ld r31, 472(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    ld r30, 464(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    ld r29, 456(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    ld r28, 448(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    ld r27, 440(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    ld r26, 432(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    ld r25, 424(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    ld r24, 416(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    ld r23, 408(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    ld r22, 400(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    ld r21, 392(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    ld r20, 384(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    ld r19, 376(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    ld r18, 368(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    ld r17, 360(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    ld r16, 352(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    ld r15, 344(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    lwz r4, 16(r4)
; BE-P10-PRIV-NEXT:    add r3, r4, r3
; BE-P10-PRIV-NEXT:    clrldi r3, r3, 32
; BE-P10-PRIV-NEXT:    ld r14, 336(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    addi r1, r1, 624
; BE-P10-PRIV-NEXT:    ld r0, 16(r1)
; BE-P10-PRIV-NEXT:    lwz r12, 8(r1)
; BE-P10-PRIV-NEXT:    mtlr r0
; BE-P10-PRIV-NEXT:    hashchkp r0, -488(r1)
; BE-P10-PRIV-NEXT:    mtocrf 32, r12
; BE-P10-PRIV-NEXT:    mtocrf 16, r12
; BE-P10-PRIV-NEXT:    mtocrf 8, r12
; BE-P10-PRIV-NEXT:    blr
;
; BE-P9-PRIV-LABEL: spill:
; BE-P9-PRIV:       # %bb.0: # %entry
; BE-P9-PRIV-NEXT:    mflr r0
; BE-P9-PRIV-NEXT:    mfcr r12
; BE-P9-PRIV-NEXT:    std r0, 16(r1)
; BE-P9-PRIV-NEXT:    hashstp r0, -488(r1)
; BE-P9-PRIV-NEXT:    stw r12, 8(r1)
; BE-P9-PRIV-NEXT:    stdu r1, -624(r1)
; BE-P9-PRIV-NEXT:    lwz r4, 12(r3)
; BE-P9-PRIV-NEXT:    std r14, 336(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    std r15, 344(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stxv v20, 144(r1) # 16-byte Folded Spill
; BE-P9-PRIV-NEXT:    stxv v21, 160(r1) # 16-byte Folded Spill
; BE-P9-PRIV-NEXT:    stxv v22, 176(r1) # 16-byte Folded Spill
; BE-P9-PRIV-NEXT:    std r16, 352(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    std r17, 360(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stxv v23, 192(r1) # 16-byte Folded Spill
; BE-P9-PRIV-NEXT:    std r18, 368(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stxv v24, 208(r1) # 16-byte Folded Spill
; BE-P9-PRIV-NEXT:    std r19, 376(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stxv v25, 224(r1) # 16-byte Folded Spill
; BE-P9-PRIV-NEXT:    std r20, 384(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    std r21, 392(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stxv v26, 240(r1) # 16-byte Folded Spill
; BE-P9-PRIV-NEXT:    std r22, 400(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stxv v27, 256(r1) # 16-byte Folded Spill
; BE-P9-PRIV-NEXT:    std r23, 408(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stxv v28, 272(r1) # 16-byte Folded Spill
; BE-P9-PRIV-NEXT:    std r24, 416(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    std r25, 424(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stxv v29, 288(r1) # 16-byte Folded Spill
; BE-P9-PRIV-NEXT:    std r26, 432(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stxv v30, 304(r1) # 16-byte Folded Spill
; BE-P9-PRIV-NEXT:    std r27, 440(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stxv v31, 320(r1) # 16-byte Folded Spill
; BE-P9-PRIV-NEXT:    std r28, 448(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    std r29, 456(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    std r30, 464(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    std r31, 472(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stfd f14, 480(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stfd f15, 488(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stfd f16, 496(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stfd f17, 504(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stfd f18, 512(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stfd f19, 520(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stfd f20, 528(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stfd f21, 536(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stfd f22, 544(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stfd f23, 552(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stfd f24, 560(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stfd f25, 568(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stfd f26, 576(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stfd f27, 584(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stfd f28, 592(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stfd f29, 600(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stfd f30, 608(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stfd f31, 616(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    std r3, 120(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    stw r4, 132(r1)
; BE-P9-PRIV-NEXT:    #APP
; BE-P9-PRIV-NEXT:    nop
; BE-P9-PRIV-NEXT:    #NO_APP
; BE-P9-PRIV-NEXT:    addi r3, r1, 132
; BE-P9-PRIV-NEXT:    bl callee2
; BE-P9-PRIV-NEXT:    nop
; BE-P9-PRIV-NEXT:    ld r4, 120(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    lxv v31, 320(r1) # 16-byte Folded Reload
; BE-P9-PRIV-NEXT:    lxv v30, 304(r1) # 16-byte Folded Reload
; BE-P9-PRIV-NEXT:    lxv v29, 288(r1) # 16-byte Folded Reload
; BE-P9-PRIV-NEXT:    lxv v28, 272(r1) # 16-byte Folded Reload
; BE-P9-PRIV-NEXT:    lxv v27, 256(r1) # 16-byte Folded Reload
; BE-P9-PRIV-NEXT:    lxv v26, 240(r1) # 16-byte Folded Reload
; BE-P9-PRIV-NEXT:    lxv v25, 224(r1) # 16-byte Folded Reload
; BE-P9-PRIV-NEXT:    lxv v24, 208(r1) # 16-byte Folded Reload
; BE-P9-PRIV-NEXT:    lxv v23, 192(r1) # 16-byte Folded Reload
; BE-P9-PRIV-NEXT:    lxv v22, 176(r1) # 16-byte Folded Reload
; BE-P9-PRIV-NEXT:    lxv v21, 160(r1) # 16-byte Folded Reload
; BE-P9-PRIV-NEXT:    lxv v20, 144(r1) # 16-byte Folded Reload
; BE-P9-PRIV-NEXT:    lfd f31, 616(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    lfd f30, 608(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    lfd f29, 600(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    lfd f28, 592(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    lfd f27, 584(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    ld r31, 472(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    ld r30, 464(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    ld r29, 456(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    lfd f26, 576(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    ld r28, 448(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    ld r27, 440(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    ld r26, 432(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    lfd f25, 568(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    ld r25, 424(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    ld r24, 416(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    ld r23, 408(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    lfd f24, 560(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    ld r22, 400(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    ld r21, 392(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    lwz r4, 16(r4)
; BE-P9-PRIV-NEXT:    add r3, r4, r3
; BE-P9-PRIV-NEXT:    lfd f23, 552(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    lfd f22, 544(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    ld r20, 384(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    ld r19, 376(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    ld r18, 368(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    ld r17, 360(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    ld r16, 352(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    ld r15, 344(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    ld r14, 336(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    lfd f21, 536(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    lfd f20, 528(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    lfd f19, 520(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    lfd f18, 512(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    lfd f17, 504(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    lfd f16, 496(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    lfd f15, 488(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    lfd f14, 480(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    clrldi r3, r3, 32
; BE-P9-PRIV-NEXT:    addi r1, r1, 624
; BE-P9-PRIV-NEXT:    ld r0, 16(r1)
; BE-P9-PRIV-NEXT:    lwz r12, 8(r1)
; BE-P9-PRIV-NEXT:    mtlr r0
; BE-P9-PRIV-NEXT:    hashchkp r0, -488(r1)
; BE-P9-PRIV-NEXT:    mtocrf 32, r12
; BE-P9-PRIV-NEXT:    mtocrf 16, r12
; BE-P9-PRIV-NEXT:    mtocrf 8, r12
; BE-P9-PRIV-NEXT:    blr
;
; BE-P8-PRIV-LABEL: spill:
; BE-P8-PRIV:       # %bb.0: # %entry
; BE-P8-PRIV-NEXT:    mfcr r12
; BE-P8-PRIV-NEXT:    mflr r0
; BE-P8-PRIV-NEXT:    std r0, 16(r1)
; BE-P8-PRIV-NEXT:    hashstp r0, -488(r1)
; BE-P8-PRIV-NEXT:    stw r12, 8(r1)
; BE-P8-PRIV-NEXT:    stdu r1, -624(r1)
; BE-P8-PRIV-NEXT:    li r4, 144
; BE-P8-PRIV-NEXT:    std r14, 336(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    std r15, 344(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    std r16, 352(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    std r17, 360(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stxvd2x v20, r1, r4 # 16-byte Folded Spill
; BE-P8-PRIV-NEXT:    li r4, 160
; BE-P8-PRIV-NEXT:    std r18, 368(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    std r19, 376(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    std r20, 384(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    std r21, 392(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stxvd2x v21, r1, r4 # 16-byte Folded Spill
; BE-P8-PRIV-NEXT:    li r4, 176
; BE-P8-PRIV-NEXT:    std r22, 400(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    std r23, 408(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    std r24, 416(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    std r25, 424(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    std r26, 432(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    std r27, 440(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    std r28, 448(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    std r29, 456(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    std r30, 464(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    std r31, 472(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    std r3, 120(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stxvd2x v22, r1, r4 # 16-byte Folded Spill
; BE-P8-PRIV-NEXT:    li r4, 192
; BE-P8-PRIV-NEXT:    stxvd2x v23, r1, r4 # 16-byte Folded Spill
; BE-P8-PRIV-NEXT:    li r4, 208
; BE-P8-PRIV-NEXT:    stfd f14, 480(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stxvd2x v24, r1, r4 # 16-byte Folded Spill
; BE-P8-PRIV-NEXT:    li r4, 224
; BE-P8-PRIV-NEXT:    stfd f15, 488(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stxvd2x v25, r1, r4 # 16-byte Folded Spill
; BE-P8-PRIV-NEXT:    li r4, 240
; BE-P8-PRIV-NEXT:    stfd f16, 496(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stxvd2x v26, r1, r4 # 16-byte Folded Spill
; BE-P8-PRIV-NEXT:    li r4, 256
; BE-P8-PRIV-NEXT:    stfd f17, 504(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stxvd2x v27, r1, r4 # 16-byte Folded Spill
; BE-P8-PRIV-NEXT:    li r4, 272
; BE-P8-PRIV-NEXT:    stfd f18, 512(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stxvd2x v28, r1, r4 # 16-byte Folded Spill
; BE-P8-PRIV-NEXT:    li r4, 288
; BE-P8-PRIV-NEXT:    stfd f19, 520(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stxvd2x v29, r1, r4 # 16-byte Folded Spill
; BE-P8-PRIV-NEXT:    li r4, 304
; BE-P8-PRIV-NEXT:    stfd f20, 528(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stxvd2x v30, r1, r4 # 16-byte Folded Spill
; BE-P8-PRIV-NEXT:    li r4, 320
; BE-P8-PRIV-NEXT:    stfd f21, 536(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stxvd2x v31, r1, r4 # 16-byte Folded Spill
; BE-P8-PRIV-NEXT:    lwz r4, 12(r3)
; BE-P8-PRIV-NEXT:    stfd f22, 544(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stfd f23, 552(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stfd f24, 560(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stfd f25, 568(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stfd f26, 576(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stfd f27, 584(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stfd f28, 592(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stfd f29, 600(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stfd f30, 608(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stfd f31, 616(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    stw r4, 132(r1)
; BE-P8-PRIV-NEXT:    #APP
; BE-P8-PRIV-NEXT:    nop
; BE-P8-PRIV-NEXT:    #NO_APP
; BE-P8-PRIV-NEXT:    addi r3, r1, 132
; BE-P8-PRIV-NEXT:    bl callee2
; BE-P8-PRIV-NEXT:    nop
; BE-P8-PRIV-NEXT:    ld r4, 120(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    lfd f31, 616(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    lfd f30, 608(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    ld r31, 472(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    lfd f29, 600(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    lfd f28, 592(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    ld r30, 464(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    ld r29, 456(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    lwz r4, 16(r4)
; BE-P8-PRIV-NEXT:    lfd f27, 584(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    lfd f26, 576(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    ld r28, 448(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    lfd f25, 568(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    lfd f24, 560(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    ld r27, 440(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    ld r26, 432(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    add r3, r4, r3
; BE-P8-PRIV-NEXT:    li r4, 320
; BE-P8-PRIV-NEXT:    lfd f23, 552(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    lfd f22, 544(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    ld r25, 424(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    ld r24, 416(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    lxvd2x v31, r1, r4 # 16-byte Folded Reload
; BE-P8-PRIV-NEXT:    li r4, 304
; BE-P8-PRIV-NEXT:    lfd f21, 536(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    ld r23, 408(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    ld r22, 400(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    clrldi r3, r3, 32
; BE-P8-PRIV-NEXT:    lxvd2x v30, r1, r4 # 16-byte Folded Reload
; BE-P8-PRIV-NEXT:    li r4, 288
; BE-P8-PRIV-NEXT:    lfd f20, 528(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    ld r21, 392(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    ld r20, 384(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    lxvd2x v29, r1, r4 # 16-byte Folded Reload
; BE-P8-PRIV-NEXT:    li r4, 272
; BE-P8-PRIV-NEXT:    lfd f19, 520(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    ld r19, 376(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    ld r18, 368(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    lxvd2x v28, r1, r4 # 16-byte Folded Reload
; BE-P8-PRIV-NEXT:    li r4, 256
; BE-P8-PRIV-NEXT:    lfd f18, 512(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    ld r17, 360(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    ld r16, 352(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    lxvd2x v27, r1, r4 # 16-byte Folded Reload
; BE-P8-PRIV-NEXT:    li r4, 240
; BE-P8-PRIV-NEXT:    lfd f17, 504(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    ld r15, 344(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    ld r14, 336(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    lxvd2x v26, r1, r4 # 16-byte Folded Reload
; BE-P8-PRIV-NEXT:    li r4, 224
; BE-P8-PRIV-NEXT:    lfd f16, 496(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    lxvd2x v25, r1, r4 # 16-byte Folded Reload
; BE-P8-PRIV-NEXT:    li r4, 208
; BE-P8-PRIV-NEXT:    lfd f15, 488(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    lxvd2x v24, r1, r4 # 16-byte Folded Reload
; BE-P8-PRIV-NEXT:    li r4, 192
; BE-P8-PRIV-NEXT:    lfd f14, 480(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    lxvd2x v23, r1, r4 # 16-byte Folded Reload
; BE-P8-PRIV-NEXT:    li r4, 176
; BE-P8-PRIV-NEXT:    lxvd2x v22, r1, r4 # 16-byte Folded Reload
; BE-P8-PRIV-NEXT:    li r4, 160
; BE-P8-PRIV-NEXT:    lxvd2x v21, r1, r4 # 16-byte Folded Reload
; BE-P8-PRIV-NEXT:    li r4, 144
; BE-P8-PRIV-NEXT:    lxvd2x v20, r1, r4 # 16-byte Folded Reload
; BE-P8-PRIV-NEXT:    addi r1, r1, 624
; BE-P8-PRIV-NEXT:    ld r0, 16(r1)
; BE-P8-PRIV-NEXT:    lwz r12, 8(r1)
; BE-P8-PRIV-NEXT:    mtocrf 32, r12
; BE-P8-PRIV-NEXT:    hashchkp r0, -488(r1)
; BE-P8-PRIV-NEXT:    mtlr r0
; BE-P8-PRIV-NEXT:    mtocrf 16, r12
; BE-P8-PRIV-NEXT:    mtocrf 8, r12
; BE-P8-PRIV-NEXT:    blr
entry:
  %local = alloca i32, align 4
  call void @llvm.lifetime.start.p0(i64 4, ptr nonnull %local)
  %arrayidx = getelementptr inbounds i32, ptr %in, i64 3
  %0 = load i32, ptr %arrayidx, align 4
  store i32 %0, ptr %local, align 4
  tail call void asm sideeffect "nop", "~{cr2},~{cr3},~{cr4},~{r0},~{r1},~{r2},~{r3},~{r4},~{r5},~{r6},~{r7},~{r8},~{r9},~{r10},~{r11},~{r12},~{r13},~{r14},~{r15},~{r16},~{r17},~{r18},~{r19},~{r20},~{r21},~{r22},~{r23},~{r24},~{r25},~{r26},~{r27},~{r28},~{r29},~{r30},~{r31},~{f14},~{f15},~{f16},~{f17},~{f18},~{f19},~{f20},~{f21},~{f22},~{f23},~{f24},~{f25},~{f26},~{f27},~{f28},~{f29},~{f30},~{f31},~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29},~{v30},~{v31}"()
  %call = call zeroext i32 @callee2(ptr nonnull %local)
  %arrayidx1 = getelementptr inbounds i32, ptr %in, i64 4
  %1 = load i32, ptr %arrayidx1, align 4
  %add = add i32 %1, %call
  call void @llvm.lifetime.end.p0(i64 4, ptr nonnull %local)
  ret i32 %add
}

define dso_local zeroext i32 @shrinkwrap(ptr readonly %in) #0 {
; LE-P10-LABEL: shrinkwrap:
; LE-P10:       # %bb.0: # %entry
; LE-P10-NEXT:    cmpldi r3, 0
; LE-P10-NEXT:    beq cr0, .LBB2_2
; LE-P10-NEXT:  # %bb.1: # %if.end
; LE-P10-NEXT:    mflr r0
; LE-P10-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; LE-P10-NEXT:    std r0, 16(r1)
; LE-P10-NEXT:    hashst r0, -24(r1)
; LE-P10-NEXT:    stdu r1, -64(r1)
; LE-P10-NEXT:    mr r30, r3
; LE-P10-NEXT:    lwz r3, 12(r3)
; LE-P10-NEXT:    stw r3, 36(r1)
; LE-P10-NEXT:    addi r3, r1, 36
; LE-P10-NEXT:    bl callee2@notoc
; LE-P10-NEXT:    lwz r4, 16(r30)
; LE-P10-NEXT:    add r3, r4, r3
; LE-P10-NEXT:    addi r1, r1, 64
; LE-P10-NEXT:    ld r0, 16(r1)
; LE-P10-NEXT:    clrldi r3, r3, 32
; LE-P10-NEXT:    hashchk r0, -24(r1)
; LE-P10-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; LE-P10-NEXT:    mtlr r0
; LE-P10-NEXT:    blr
; LE-P10-NEXT:  .LBB2_2:
; LE-P10-NEXT:    li r3, 0
; LE-P10-NEXT:    blr
;
; LE-P9-LABEL: shrinkwrap:
; LE-P9:       # %bb.0: # %entry
; LE-P9-NEXT:    cmpldi r3, 0
; LE-P9-NEXT:    beq cr0, .LBB2_2
; LE-P9-NEXT:  # %bb.1: # %if.end
; LE-P9-NEXT:    mflr r0
; LE-P9-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; LE-P9-NEXT:    std r0, 16(r1)
; LE-P9-NEXT:    hashst r0, -24(r1)
; LE-P9-NEXT:    stdu r1, -64(r1)
; LE-P9-NEXT:    mr r30, r3
; LE-P9-NEXT:    lwz r3, 12(r3)
; LE-P9-NEXT:    stw r3, 36(r1)
; LE-P9-NEXT:    addi r3, r1, 36
; LE-P9-NEXT:    bl callee2
; LE-P9-NEXT:    nop
; LE-P9-NEXT:    lwz r4, 16(r30)
; LE-P9-NEXT:    add r3, r4, r3
; LE-P9-NEXT:    addi r1, r1, 64
; LE-P9-NEXT:    ld r0, 16(r1)
; LE-P9-NEXT:    clrldi r3, r3, 32
; LE-P9-NEXT:    mtlr r0
; LE-P9-NEXT:    hashchk r0, -24(r1)
; LE-P9-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; LE-P9-NEXT:    blr
; LE-P9-NEXT:  .LBB2_2:
; LE-P9-NEXT:    li r3, 0
; LE-P9-NEXT:    blr
;
; LE-P8-LABEL: shrinkwrap:
; LE-P8:       # %bb.0: # %entry
; LE-P8-NEXT:    cmpldi r3, 0
; LE-P8-NEXT:    beq cr0, .LBB2_2
; LE-P8-NEXT:  # %bb.1: # %if.end
; LE-P8-NEXT:    mflr r0
; LE-P8-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; LE-P8-NEXT:    std r0, 16(r1)
; LE-P8-NEXT:    hashst r0, -24(r1)
; LE-P8-NEXT:    stdu r1, -64(r1)
; LE-P8-NEXT:    mr r30, r3
; LE-P8-NEXT:    lwz r3, 12(r3)
; LE-P8-NEXT:    stw r3, 36(r1)
; LE-P8-NEXT:    addi r3, r1, 36
; LE-P8-NEXT:    bl callee2
; LE-P8-NEXT:    nop
; LE-P8-NEXT:    lwz r4, 16(r30)
; LE-P8-NEXT:    add r3, r4, r3
; LE-P8-NEXT:    addi r1, r1, 64
; LE-P8-NEXT:    ld r0, 16(r1)
; LE-P8-NEXT:    clrldi r3, r3, 32
; LE-P8-NEXT:    hashchk r0, -24(r1)
; LE-P8-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; LE-P8-NEXT:    mtlr r0
; LE-P8-NEXT:    blr
; LE-P8-NEXT:  .LBB2_2:
; LE-P8-NEXT:    li r3, 0
; LE-P8-NEXT:    blr
;
; LE-P10-O0-LABEL: shrinkwrap:
; LE-P10-O0:       # %bb.0: # %entry
; LE-P10-O0-NEXT:    mflr r0
; LE-P10-O0-NEXT:    std r0, 16(r1)
; LE-P10-O0-NEXT:    hashst r0, -8(r1)
; LE-P10-O0-NEXT:    stdu r1, -64(r1)
; LE-P10-O0-NEXT:    mr r4, r3
; LE-P10-O0-NEXT:    std r4, 40(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    li r3, 0
; LE-P10-O0-NEXT:    cmpdi r4, 0
; LE-P10-O0-NEXT:    stw r3, 48(r1) # 4-byte Folded Spill
; LE-P10-O0-NEXT:    beq cr0, .LBB2_2
; LE-P10-O0-NEXT:  # %bb.1: # %if.end
; LE-P10-O0-NEXT:    ld r3, 40(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    lwz r3, 12(r3)
; LE-P10-O0-NEXT:    stw r3, 52(r1)
; LE-P10-O0-NEXT:    addi r3, r1, 52
; LE-P10-O0-NEXT:    bl callee2@notoc
; LE-P10-O0-NEXT:    mr r4, r3
; LE-P10-O0-NEXT:    ld r3, 40(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    # kill: def $r4 killed $r4 killed $x4
; LE-P10-O0-NEXT:    lwz r3, 16(r3)
; LE-P10-O0-NEXT:    add r3, r3, r4
; LE-P10-O0-NEXT:    stw r3, 48(r1) # 4-byte Folded Spill
; LE-P10-O0-NEXT:  .LBB2_2: # %return
; LE-P10-O0-NEXT:    lwz r3, 48(r1) # 4-byte Folded Reload
; LE-P10-O0-NEXT:    clrldi r3, r3, 32
; LE-P10-O0-NEXT:    addi r1, r1, 64
; LE-P10-O0-NEXT:    ld r0, 16(r1)
; LE-P10-O0-NEXT:    hashchk r0, -8(r1)
; LE-P10-O0-NEXT:    mtlr r0
; LE-P10-O0-NEXT:    blr
;
; LE-P9-O0-LABEL: shrinkwrap:
; LE-P9-O0:       # %bb.0: # %entry
; LE-P9-O0-NEXT:    mflr r0
; LE-P9-O0-NEXT:    std r0, 16(r1)
; LE-P9-O0-NEXT:    hashst r0, -8(r1)
; LE-P9-O0-NEXT:    stdu r1, -128(r1)
; LE-P9-O0-NEXT:    mr r4, r3
; LE-P9-O0-NEXT:    std r4, 104(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    li r3, 0
; LE-P9-O0-NEXT:    cmpdi r4, 0
; LE-P9-O0-NEXT:    stw r3, 112(r1) # 4-byte Folded Spill
; LE-P9-O0-NEXT:    beq cr0, .LBB2_2
; LE-P9-O0-NEXT:  # %bb.1: # %if.end
; LE-P9-O0-NEXT:    ld r3, 104(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lwz r3, 12(r3)
; LE-P9-O0-NEXT:    stw r3, 116(r1)
; LE-P9-O0-NEXT:    addi r3, r1, 116
; LE-P9-O0-NEXT:    bl callee2
; LE-P9-O0-NEXT:    nop
; LE-P9-O0-NEXT:    mr r4, r3
; LE-P9-O0-NEXT:    ld r3, 104(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lwz r3, 16(r3)
; LE-P9-O0-NEXT:    add r3, r3, r4
; LE-P9-O0-NEXT:    stw r3, 112(r1) # 4-byte Folded Spill
; LE-P9-O0-NEXT:  .LBB2_2: # %return
; LE-P9-O0-NEXT:    lwz r3, 112(r1) # 4-byte Folded Reload
; LE-P9-O0-NEXT:    clrldi r3, r3, 32
; LE-P9-O0-NEXT:    addi r1, r1, 128
; LE-P9-O0-NEXT:    ld r0, 16(r1)
; LE-P9-O0-NEXT:    hashchk r0, -8(r1)
; LE-P9-O0-NEXT:    mtlr r0
; LE-P9-O0-NEXT:    blr
;
; LE-P8-O0-LABEL: shrinkwrap:
; LE-P8-O0:       # %bb.0: # %entry
; LE-P8-O0-NEXT:    mflr r0
; LE-P8-O0-NEXT:    std r0, 16(r1)
; LE-P8-O0-NEXT:    hashst r0, -8(r1)
; LE-P8-O0-NEXT:    stdu r1, -128(r1)
; LE-P8-O0-NEXT:    mr r4, r3
; LE-P8-O0-NEXT:    std r4, 104(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    li r3, 0
; LE-P8-O0-NEXT:    cmpdi r4, 0
; LE-P8-O0-NEXT:    stw r3, 112(r1) # 4-byte Folded Spill
; LE-P8-O0-NEXT:    beq cr0, .LBB2_2
; LE-P8-O0-NEXT:  # %bb.1: # %if.end
; LE-P8-O0-NEXT:    ld r3, 104(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lwz r3, 12(r3)
; LE-P8-O0-NEXT:    stw r3, 116(r1)
; LE-P8-O0-NEXT:    addi r3, r1, 116
; LE-P8-O0-NEXT:    bl callee2
; LE-P8-O0-NEXT:    nop
; LE-P8-O0-NEXT:    mr r4, r3
; LE-P8-O0-NEXT:    ld r3, 104(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lwz r3, 16(r3)
; LE-P8-O0-NEXT:    add r3, r3, r4
; LE-P8-O0-NEXT:    stw r3, 112(r1) # 4-byte Folded Spill
; LE-P8-O0-NEXT:  .LBB2_2: # %return
; LE-P8-O0-NEXT:    lwz r3, 112(r1) # 4-byte Folded Reload
; LE-P8-O0-NEXT:    clrldi r3, r3, 32
; LE-P8-O0-NEXT:    addi r1, r1, 128
; LE-P8-O0-NEXT:    ld r0, 16(r1)
; LE-P8-O0-NEXT:    hashchk r0, -8(r1)
; LE-P8-O0-NEXT:    mtlr r0
; LE-P8-O0-NEXT:    blr
;
; BE-P10-LABEL: shrinkwrap:
; BE-P10:       # %bb.0: # %entry
; BE-P10-NEXT:    cmpldi r3, 0
; BE-P10-NEXT:    beq cr0, .LBB2_2
; BE-P10-NEXT:  # %bb.1: # %if.end
; BE-P10-NEXT:    mflr r0
; BE-P10-NEXT:    std r0, 16(r1)
; BE-P10-NEXT:    hashst r0, -24(r1)
; BE-P10-NEXT:    stdu r1, -144(r1)
; BE-P10-NEXT:    std r30, 128(r1) # 8-byte Folded Spill
; BE-P10-NEXT:    mr r30, r3
; BE-P10-NEXT:    lwz r3, 12(r3)
; BE-P10-NEXT:    stw r3, 116(r1)
; BE-P10-NEXT:    addi r3, r1, 116
; BE-P10-NEXT:    bl callee2
; BE-P10-NEXT:    nop
; BE-P10-NEXT:    lwz r4, 16(r30)
; BE-P10-NEXT:    ld r30, 128(r1) # 8-byte Folded Reload
; BE-P10-NEXT:    add r3, r4, r3
; BE-P10-NEXT:    addi r1, r1, 144
; BE-P10-NEXT:    ld r0, 16(r1)
; BE-P10-NEXT:    clrldi r3, r3, 32
; BE-P10-NEXT:    hashchk r0, -24(r1)
; BE-P10-NEXT:    mtlr r0
; BE-P10-NEXT:    blr
; BE-P10-NEXT:  .LBB2_2:
; BE-P10-NEXT:    li r3, 0
; BE-P10-NEXT:    blr
;
; BE-P9-LABEL: shrinkwrap:
; BE-P9:       # %bb.0: # %entry
; BE-P9-NEXT:    cmpldi r3, 0
; BE-P9-NEXT:    beq cr0, .LBB2_2
; BE-P9-NEXT:  # %bb.1: # %if.end
; BE-P9-NEXT:    mflr r0
; BE-P9-NEXT:    std r0, 16(r1)
; BE-P9-NEXT:    hashst r0, -24(r1)
; BE-P9-NEXT:    stdu r1, -144(r1)
; BE-P9-NEXT:    std r30, 128(r1) # 8-byte Folded Spill
; BE-P9-NEXT:    mr r30, r3
; BE-P9-NEXT:    lwz r3, 12(r3)
; BE-P9-NEXT:    stw r3, 116(r1)
; BE-P9-NEXT:    addi r3, r1, 116
; BE-P9-NEXT:    bl callee2
; BE-P9-NEXT:    nop
; BE-P9-NEXT:    lwz r4, 16(r30)
; BE-P9-NEXT:    ld r30, 128(r1) # 8-byte Folded Reload
; BE-P9-NEXT:    add r3, r4, r3
; BE-P9-NEXT:    addi r1, r1, 144
; BE-P9-NEXT:    ld r0, 16(r1)
; BE-P9-NEXT:    clrldi r3, r3, 32
; BE-P9-NEXT:    mtlr r0
; BE-P9-NEXT:    hashchk r0, -24(r1)
; BE-P9-NEXT:    blr
; BE-P9-NEXT:  .LBB2_2:
; BE-P9-NEXT:    li r3, 0
; BE-P9-NEXT:    blr
;
; BE-P8-LABEL: shrinkwrap:
; BE-P8:       # %bb.0: # %entry
; BE-P8-NEXT:    cmpldi r3, 0
; BE-P8-NEXT:    beq cr0, .LBB2_2
; BE-P8-NEXT:  # %bb.1: # %if.end
; BE-P8-NEXT:    mflr r0
; BE-P8-NEXT:    std r0, 16(r1)
; BE-P8-NEXT:    hashst r0, -24(r1)
; BE-P8-NEXT:    stdu r1, -144(r1)
; BE-P8-NEXT:    std r30, 128(r1) # 8-byte Folded Spill
; BE-P8-NEXT:    mr r30, r3
; BE-P8-NEXT:    lwz r3, 12(r3)
; BE-P8-NEXT:    stw r3, 116(r1)
; BE-P8-NEXT:    addi r3, r1, 116
; BE-P8-NEXT:    bl callee2
; BE-P8-NEXT:    nop
; BE-P8-NEXT:    lwz r4, 16(r30)
; BE-P8-NEXT:    ld r30, 128(r1) # 8-byte Folded Reload
; BE-P8-NEXT:    add r3, r4, r3
; BE-P8-NEXT:    addi r1, r1, 144
; BE-P8-NEXT:    ld r0, 16(r1)
; BE-P8-NEXT:    clrldi r3, r3, 32
; BE-P8-NEXT:    hashchk r0, -24(r1)
; BE-P8-NEXT:    mtlr r0
; BE-P8-NEXT:    blr
; BE-P8-NEXT:  .LBB2_2:
; BE-P8-NEXT:    li r3, 0
; BE-P8-NEXT:    blr
;
; BE-32BIT-P10-LABEL: shrinkwrap:
; BE-32BIT-P10:       # %bb.0: # %entry
; BE-32BIT-P10-NEXT:    mflr r0
; BE-32BIT-P10-NEXT:    stw r0, 4(r1)
; BE-32BIT-P10-NEXT:    hashst r0, -16(r1)
; BE-32BIT-P10-NEXT:    stwu r1, -32(r1)
; BE-32BIT-P10-NEXT:    cmplwi r3, 0
; BE-32BIT-P10-NEXT:    stw r30, 24(r1) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    beq cr0, .LBB2_2
; BE-32BIT-P10-NEXT:  # %bb.1: # %if.end
; BE-32BIT-P10-NEXT:    mr r30, r3
; BE-32BIT-P10-NEXT:    lwz r3, 12(r3)
; BE-32BIT-P10-NEXT:    stw r3, 12(r1)
; BE-32BIT-P10-NEXT:    addi r3, r1, 12
; BE-32BIT-P10-NEXT:    bl callee2
; BE-32BIT-P10-NEXT:    lwz r4, 16(r30)
; BE-32BIT-P10-NEXT:    add r3, r4, r3
; BE-32BIT-P10-NEXT:    b .LBB2_3
; BE-32BIT-P10-NEXT:  .LBB2_2:
; BE-32BIT-P10-NEXT:    li r3, 0
; BE-32BIT-P10-NEXT:  .LBB2_3: # %return
; BE-32BIT-P10-NEXT:    lwz r30, 24(r1) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    lwz r0, 36(r1)
; BE-32BIT-P10-NEXT:    addi r1, r1, 32
; BE-32BIT-P10-NEXT:    hashchk r0, -16(r1)
; BE-32BIT-P10-NEXT:    mtlr r0
; BE-32BIT-P10-NEXT:    blr
;
; BE-32BIT-P9-LABEL: shrinkwrap:
; BE-32BIT-P9:       # %bb.0: # %entry
; BE-32BIT-P9-NEXT:    mflr r0
; BE-32BIT-P9-NEXT:    stw r0, 4(r1)
; BE-32BIT-P9-NEXT:    hashst r0, -16(r1)
; BE-32BIT-P9-NEXT:    stwu r1, -32(r1)
; BE-32BIT-P9-NEXT:    cmplwi r3, 0
; BE-32BIT-P9-NEXT:    stw r30, 24(r1) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    beq cr0, .LBB2_2
; BE-32BIT-P9-NEXT:  # %bb.1: # %if.end
; BE-32BIT-P9-NEXT:    mr r30, r3
; BE-32BIT-P9-NEXT:    lwz r3, 12(r3)
; BE-32BIT-P9-NEXT:    stw r3, 12(r1)
; BE-32BIT-P9-NEXT:    addi r3, r1, 12
; BE-32BIT-P9-NEXT:    bl callee2
; BE-32BIT-P9-NEXT:    lwz r4, 16(r30)
; BE-32BIT-P9-NEXT:    add r3, r4, r3
; BE-32BIT-P9-NEXT:    b .LBB2_3
; BE-32BIT-P9-NEXT:  .LBB2_2:
; BE-32BIT-P9-NEXT:    li r3, 0
; BE-32BIT-P9-NEXT:  .LBB2_3: # %return
; BE-32BIT-P9-NEXT:    lwz r30, 24(r1) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    lwz r0, 36(r1)
; BE-32BIT-P9-NEXT:    addi r1, r1, 32
; BE-32BIT-P9-NEXT:    mtlr r0
; BE-32BIT-P9-NEXT:    hashchk r0, -16(r1)
; BE-32BIT-P9-NEXT:    blr
;
; BE-32BIT-P8-LABEL: shrinkwrap:
; BE-32BIT-P8:       # %bb.0: # %entry
; BE-32BIT-P8-NEXT:    mflr r0
; BE-32BIT-P8-NEXT:    stw r0, 4(r1)
; BE-32BIT-P8-NEXT:    hashst r0, -16(r1)
; BE-32BIT-P8-NEXT:    stwu r1, -32(r1)
; BE-32BIT-P8-NEXT:    cmplwi r3, 0
; BE-32BIT-P8-NEXT:    stw r30, 24(r1) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    beq cr0, .LBB2_2
; BE-32BIT-P8-NEXT:  # %bb.1: # %if.end
; BE-32BIT-P8-NEXT:    mr r30, r3
; BE-32BIT-P8-NEXT:    lwz r3, 12(r3)
; BE-32BIT-P8-NEXT:    stw r3, 12(r1)
; BE-32BIT-P8-NEXT:    addi r3, r1, 12
; BE-32BIT-P8-NEXT:    bl callee2
; BE-32BIT-P8-NEXT:    lwz r4, 16(r30)
; BE-32BIT-P8-NEXT:    add r3, r4, r3
; BE-32BIT-P8-NEXT:    b .LBB2_3
; BE-32BIT-P8-NEXT:  .LBB2_2:
; BE-32BIT-P8-NEXT:    li r3, 0
; BE-32BIT-P8-NEXT:  .LBB2_3: # %return
; BE-32BIT-P8-NEXT:    lwz r30, 24(r1) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    lwz r0, 36(r1)
; BE-32BIT-P8-NEXT:    addi r1, r1, 32
; BE-32BIT-P8-NEXT:    mtlr r0
; BE-32BIT-P8-NEXT:    hashchk r0, -16(r1)
; BE-32BIT-P8-NEXT:    blr
;
; LE-P10-PRIV-LABEL: shrinkwrap:
; LE-P10-PRIV:       # %bb.0: # %entry
; LE-P10-PRIV-NEXT:    cmpldi r3, 0
; LE-P10-PRIV-NEXT:    beq cr0, .LBB2_2
; LE-P10-PRIV-NEXT:  # %bb.1: # %if.end
; LE-P10-PRIV-NEXT:    mflr r0
; LE-P10-PRIV-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    std r0, 16(r1)
; LE-P10-PRIV-NEXT:    hashstp r0, -24(r1)
; LE-P10-PRIV-NEXT:    stdu r1, -64(r1)
; LE-P10-PRIV-NEXT:    mr r30, r3
; LE-P10-PRIV-NEXT:    lwz r3, 12(r3)
; LE-P10-PRIV-NEXT:    stw r3, 36(r1)
; LE-P10-PRIV-NEXT:    addi r3, r1, 36
; LE-P10-PRIV-NEXT:    bl callee2@notoc
; LE-P10-PRIV-NEXT:    lwz r4, 16(r30)
; LE-P10-PRIV-NEXT:    add r3, r4, r3
; LE-P10-PRIV-NEXT:    addi r1, r1, 64
; LE-P10-PRIV-NEXT:    ld r0, 16(r1)
; LE-P10-PRIV-NEXT:    clrldi r3, r3, 32
; LE-P10-PRIV-NEXT:    hashchkp r0, -24(r1)
; LE-P10-PRIV-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    mtlr r0
; LE-P10-PRIV-NEXT:    blr
; LE-P10-PRIV-NEXT:  .LBB2_2:
; LE-P10-PRIV-NEXT:    li r3, 0
; LE-P10-PRIV-NEXT:    blr
;
; LE-P9-PRIV-LABEL: shrinkwrap:
; LE-P9-PRIV:       # %bb.0: # %entry
; LE-P9-PRIV-NEXT:    cmpldi r3, 0
; LE-P9-PRIV-NEXT:    beq cr0, .LBB2_2
; LE-P9-PRIV-NEXT:  # %bb.1: # %if.end
; LE-P9-PRIV-NEXT:    mflr r0
; LE-P9-PRIV-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    std r0, 16(r1)
; LE-P9-PRIV-NEXT:    hashstp r0, -24(r1)
; LE-P9-PRIV-NEXT:    stdu r1, -64(r1)
; LE-P9-PRIV-NEXT:    mr r30, r3
; LE-P9-PRIV-NEXT:    lwz r3, 12(r3)
; LE-P9-PRIV-NEXT:    stw r3, 36(r1)
; LE-P9-PRIV-NEXT:    addi r3, r1, 36
; LE-P9-PRIV-NEXT:    bl callee2
; LE-P9-PRIV-NEXT:    nop
; LE-P9-PRIV-NEXT:    lwz r4, 16(r30)
; LE-P9-PRIV-NEXT:    add r3, r4, r3
; LE-P9-PRIV-NEXT:    addi r1, r1, 64
; LE-P9-PRIV-NEXT:    ld r0, 16(r1)
; LE-P9-PRIV-NEXT:    clrldi r3, r3, 32
; LE-P9-PRIV-NEXT:    mtlr r0
; LE-P9-PRIV-NEXT:    hashchkp r0, -24(r1)
; LE-P9-PRIV-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    blr
; LE-P9-PRIV-NEXT:  .LBB2_2:
; LE-P9-PRIV-NEXT:    li r3, 0
; LE-P9-PRIV-NEXT:    blr
;
; LE-P8-PRIV-LABEL: shrinkwrap:
; LE-P8-PRIV:       # %bb.0: # %entry
; LE-P8-PRIV-NEXT:    cmpldi r3, 0
; LE-P8-PRIV-NEXT:    beq cr0, .LBB2_2
; LE-P8-PRIV-NEXT:  # %bb.1: # %if.end
; LE-P8-PRIV-NEXT:    mflr r0
; LE-P8-PRIV-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    std r0, 16(r1)
; LE-P8-PRIV-NEXT:    hashstp r0, -24(r1)
; LE-P8-PRIV-NEXT:    stdu r1, -64(r1)
; LE-P8-PRIV-NEXT:    mr r30, r3
; LE-P8-PRIV-NEXT:    lwz r3, 12(r3)
; LE-P8-PRIV-NEXT:    stw r3, 36(r1)
; LE-P8-PRIV-NEXT:    addi r3, r1, 36
; LE-P8-PRIV-NEXT:    bl callee2
; LE-P8-PRIV-NEXT:    nop
; LE-P8-PRIV-NEXT:    lwz r4, 16(r30)
; LE-P8-PRIV-NEXT:    add r3, r4, r3
; LE-P8-PRIV-NEXT:    addi r1, r1, 64
; LE-P8-PRIV-NEXT:    ld r0, 16(r1)
; LE-P8-PRIV-NEXT:    clrldi r3, r3, 32
; LE-P8-PRIV-NEXT:    hashchkp r0, -24(r1)
; LE-P8-PRIV-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    mtlr r0
; LE-P8-PRIV-NEXT:    blr
; LE-P8-PRIV-NEXT:  .LBB2_2:
; LE-P8-PRIV-NEXT:    li r3, 0
; LE-P8-PRIV-NEXT:    blr
;
; BE-P10-PRIV-LABEL: shrinkwrap:
; BE-P10-PRIV:       # %bb.0: # %entry
; BE-P10-PRIV-NEXT:    cmpldi r3, 0
; BE-P10-PRIV-NEXT:    beq cr0, .LBB2_2
; BE-P10-PRIV-NEXT:  # %bb.1: # %if.end
; BE-P10-PRIV-NEXT:    mflr r0
; BE-P10-PRIV-NEXT:    std r0, 16(r1)
; BE-P10-PRIV-NEXT:    hashstp r0, -24(r1)
; BE-P10-PRIV-NEXT:    stdu r1, -144(r1)
; BE-P10-PRIV-NEXT:    std r30, 128(r1) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    mr r30, r3
; BE-P10-PRIV-NEXT:    lwz r3, 12(r3)
; BE-P10-PRIV-NEXT:    stw r3, 116(r1)
; BE-P10-PRIV-NEXT:    addi r3, r1, 116
; BE-P10-PRIV-NEXT:    bl callee2
; BE-P10-PRIV-NEXT:    nop
; BE-P10-PRIV-NEXT:    lwz r4, 16(r30)
; BE-P10-PRIV-NEXT:    ld r30, 128(r1) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    add r3, r4, r3
; BE-P10-PRIV-NEXT:    addi r1, r1, 144
; BE-P10-PRIV-NEXT:    ld r0, 16(r1)
; BE-P10-PRIV-NEXT:    clrldi r3, r3, 32
; BE-P10-PRIV-NEXT:    hashchkp r0, -24(r1)
; BE-P10-PRIV-NEXT:    mtlr r0
; BE-P10-PRIV-NEXT:    blr
; BE-P10-PRIV-NEXT:  .LBB2_2:
; BE-P10-PRIV-NEXT:    li r3, 0
; BE-P10-PRIV-NEXT:    blr
;
; BE-P9-PRIV-LABEL: shrinkwrap:
; BE-P9-PRIV:       # %bb.0: # %entry
; BE-P9-PRIV-NEXT:    cmpldi r3, 0
; BE-P9-PRIV-NEXT:    beq cr0, .LBB2_2
; BE-P9-PRIV-NEXT:  # %bb.1: # %if.end
; BE-P9-PRIV-NEXT:    mflr r0
; BE-P9-PRIV-NEXT:    std r0, 16(r1)
; BE-P9-PRIV-NEXT:    hashstp r0, -24(r1)
; BE-P9-PRIV-NEXT:    stdu r1, -144(r1)
; BE-P9-PRIV-NEXT:    std r30, 128(r1) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    mr r30, r3
; BE-P9-PRIV-NEXT:    lwz r3, 12(r3)
; BE-P9-PRIV-NEXT:    stw r3, 116(r1)
; BE-P9-PRIV-NEXT:    addi r3, r1, 116
; BE-P9-PRIV-NEXT:    bl callee2
; BE-P9-PRIV-NEXT:    nop
; BE-P9-PRIV-NEXT:    lwz r4, 16(r30)
; BE-P9-PRIV-NEXT:    ld r30, 128(r1) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    add r3, r4, r3
; BE-P9-PRIV-NEXT:    addi r1, r1, 144
; BE-P9-PRIV-NEXT:    ld r0, 16(r1)
; BE-P9-PRIV-NEXT:    clrldi r3, r3, 32
; BE-P9-PRIV-NEXT:    mtlr r0
; BE-P9-PRIV-NEXT:    hashchkp r0, -24(r1)
; BE-P9-PRIV-NEXT:    blr
; BE-P9-PRIV-NEXT:  .LBB2_2:
; BE-P9-PRIV-NEXT:    li r3, 0
; BE-P9-PRIV-NEXT:    blr
;
; BE-P8-PRIV-LABEL: shrinkwrap:
; BE-P8-PRIV:       # %bb.0: # %entry
; BE-P8-PRIV-NEXT:    cmpldi r3, 0
; BE-P8-PRIV-NEXT:    beq cr0, .LBB2_2
; BE-P8-PRIV-NEXT:  # %bb.1: # %if.end
; BE-P8-PRIV-NEXT:    mflr r0
; BE-P8-PRIV-NEXT:    std r0, 16(r1)
; BE-P8-PRIV-NEXT:    hashstp r0, -24(r1)
; BE-P8-PRIV-NEXT:    stdu r1, -144(r1)
; BE-P8-PRIV-NEXT:    std r30, 128(r1) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    mr r30, r3
; BE-P8-PRIV-NEXT:    lwz r3, 12(r3)
; BE-P8-PRIV-NEXT:    stw r3, 116(r1)
; BE-P8-PRIV-NEXT:    addi r3, r1, 116
; BE-P8-PRIV-NEXT:    bl callee2
; BE-P8-PRIV-NEXT:    nop
; BE-P8-PRIV-NEXT:    lwz r4, 16(r30)
; BE-P8-PRIV-NEXT:    ld r30, 128(r1) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    add r3, r4, r3
; BE-P8-PRIV-NEXT:    addi r1, r1, 144
; BE-P8-PRIV-NEXT:    ld r0, 16(r1)
; BE-P8-PRIV-NEXT:    clrldi r3, r3, 32
; BE-P8-PRIV-NEXT:    hashchkp r0, -24(r1)
; BE-P8-PRIV-NEXT:    mtlr r0
; BE-P8-PRIV-NEXT:    blr
; BE-P8-PRIV-NEXT:  .LBB2_2:
; BE-P8-PRIV-NEXT:    li r3, 0
; BE-P8-PRIV-NEXT:    blr
entry:
  %local = alloca i32, align 4
  %tobool.not = icmp eq ptr %in, null
  br i1 %tobool.not, label %return, label %if.end

if.end:                                           ; preds = %entry
  call void @llvm.lifetime.start.p0(i64 4, ptr nonnull %local)
  %arrayidx = getelementptr inbounds i32, ptr %in, i64 3
  %0 = load i32, ptr %arrayidx, align 4
  store i32 %0, ptr %local, align 4
  %call = call zeroext i32 @callee2(ptr nonnull %local)
  %arrayidx1 = getelementptr inbounds i32, ptr %in, i64 4
  %1 = load i32, ptr %arrayidx1, align 4
  %add = add i32 %1, %call
  call void @llvm.lifetime.end.p0(i64 4, ptr nonnull %local)
  br label %return

return:                                           ; preds = %entry, %if.end
  %retval.0 = phi i32 [ %add, %if.end ], [ 0, %entry ]
  ret i32 %retval.0
}

define dso_local zeroext i32 @aligned(ptr nocapture readonly %in) #0 {
; LE-P10-LABEL: aligned:
; LE-P10:       # %bb.0: # %entry
; LE-P10-NEXT:    mflr r0
; LE-P10-NEXT:    std r30, -16(r1)
; LE-P10-NEXT:    lis r12, -1
; LE-P10-NEXT:    mr r30, r1
; LE-P10-NEXT:    std r0, 16(r1)
; LE-P10-NEXT:    hashst r0, -32(r1)
; LE-P10-NEXT:    clrldi r0, r1, 49
; LE-P10-NEXT:    subc r0, r12, r0
; LE-P10-NEXT:    stdux r1, r1, r0
; LE-P10-NEXT:    std r29, -24(r30) # 8-byte Folded Spill
; LE-P10-NEXT:    mr r29, r3
; LE-P10-NEXT:    lwz r3, 4(r3)
; LE-P10-NEXT:    lis r4, 0
; LE-P10-NEXT:    addi r5, r1, 32764
; LE-P10-NEXT:    ori r4, r4, 65500
; LE-P10-NEXT:    stwx r3, r1, r4
; LE-P10-NEXT:    lwz r3, 12(r29)
; LE-P10-NEXT:    lis r4, 0
; LE-P10-NEXT:    ori r4, r4, 32768
; LE-P10-NEXT:    stwx r3, r1, r4
; LE-P10-NEXT:    lwz r3, 20(r29)
; LE-P10-NEXT:    lis r4, 0
; LE-P10-NEXT:    ori r4, r4, 65500
; LE-P10-NEXT:    add r4, r1, r4
; LE-P10-NEXT:    stw r3, 32764(r1)
; LE-P10-NEXT:    lis r3, 0
; LE-P10-NEXT:    ori r3, r3, 32768
; LE-P10-NEXT:    add r3, r1, r3
; LE-P10-NEXT:    bl callee3@notoc
; LE-P10-NEXT:    lwz r4, 16(r29)
; LE-P10-NEXT:    ld r29, -24(r30) # 8-byte Folded Reload
; LE-P10-NEXT:    add r3, r4, r3
; LE-P10-NEXT:    clrldi r3, r3, 32
; LE-P10-NEXT:    mr r1, r30
; LE-P10-NEXT:    ld r0, 16(r1)
; LE-P10-NEXT:    ld r30, -16(r1)
; LE-P10-NEXT:    mtlr r0
; LE-P10-NEXT:    hashchk r0, -32(r1)
; LE-P10-NEXT:    blr
;
; LE-P9-LABEL: aligned:
; LE-P9:       # %bb.0: # %entry
; LE-P9-NEXT:    mflr r0
; LE-P9-NEXT:    std r30, -16(r1)
; LE-P9-NEXT:    lis r12, -1
; LE-P9-NEXT:    mr r30, r1
; LE-P9-NEXT:    std r0, 16(r1)
; LE-P9-NEXT:    hashst r0, -32(r1)
; LE-P9-NEXT:    clrldi r0, r1, 49
; LE-P9-NEXT:    subc r0, r12, r0
; LE-P9-NEXT:    stdux r1, r1, r0
; LE-P9-NEXT:    std r29, -24(r30) # 8-byte Folded Spill
; LE-P9-NEXT:    mr r29, r3
; LE-P9-NEXT:    lwz r3, 4(r3)
; LE-P9-NEXT:    lis r4, 0
; LE-P9-NEXT:    addi r5, r1, 32764
; LE-P9-NEXT:    ori r4, r4, 65500
; LE-P9-NEXT:    stwx r3, r1, r4
; LE-P9-NEXT:    lwz r3, 12(r29)
; LE-P9-NEXT:    lis r4, 0
; LE-P9-NEXT:    ori r4, r4, 32768
; LE-P9-NEXT:    stwx r3, r1, r4
; LE-P9-NEXT:    lwz r3, 20(r29)
; LE-P9-NEXT:    lis r4, 0
; LE-P9-NEXT:    ori r4, r4, 65500
; LE-P9-NEXT:    stw r3, 32764(r1)
; LE-P9-NEXT:    lis r3, 0
; LE-P9-NEXT:    add r4, r1, r4
; LE-P9-NEXT:    ori r3, r3, 32768
; LE-P9-NEXT:    add r3, r1, r3
; LE-P9-NEXT:    bl callee3
; LE-P9-NEXT:    nop
; LE-P9-NEXT:    lwz r4, 16(r29)
; LE-P9-NEXT:    ld r29, -24(r30) # 8-byte Folded Reload
; LE-P9-NEXT:    add r3, r4, r3
; LE-P9-NEXT:    clrldi r3, r3, 32
; LE-P9-NEXT:    mr r1, r30
; LE-P9-NEXT:    ld r0, 16(r1)
; LE-P9-NEXT:    ld r30, -16(r1)
; LE-P9-NEXT:    mtlr r0
; LE-P9-NEXT:    hashchk r0, -32(r1)
; LE-P9-NEXT:    blr
;
; LE-P8-LABEL: aligned:
; LE-P8:       # %bb.0: # %entry
; LE-P8-NEXT:    mflr r0
; LE-P8-NEXT:    std r30, -16(r1)
; LE-P8-NEXT:    lis r12, -1
; LE-P8-NEXT:    mr r30, r1
; LE-P8-NEXT:    std r0, 16(r1)
; LE-P8-NEXT:    hashst r0, -32(r1)
; LE-P8-NEXT:    clrldi r0, r1, 49
; LE-P8-NEXT:    subc r0, r12, r0
; LE-P8-NEXT:    stdux r1, r1, r0
; LE-P8-NEXT:    std r29, -24(r30) # 8-byte Folded Spill
; LE-P8-NEXT:    mr r29, r3
; LE-P8-NEXT:    lwz r3, 4(r3)
; LE-P8-NEXT:    lis r6, 0
; LE-P8-NEXT:    ori r6, r6, 65500
; LE-P8-NEXT:    lwz r4, 12(r29)
; LE-P8-NEXT:    lwz r5, 20(r29)
; LE-P8-NEXT:    stwx r3, r1, r6
; LE-P8-NEXT:    lis r3, 0
; LE-P8-NEXT:    ori r3, r3, 32768
; LE-P8-NEXT:    stw r5, 32764(r1)
; LE-P8-NEXT:    addi r5, r1, 32764
; LE-P8-NEXT:    stwx r4, r1, r3
; LE-P8-NEXT:    lis r3, 0
; LE-P8-NEXT:    lis r4, 0
; LE-P8-NEXT:    ori r3, r3, 32768
; LE-P8-NEXT:    ori r4, r4, 65500
; LE-P8-NEXT:    add r3, r1, r3
; LE-P8-NEXT:    add r4, r1, r4
; LE-P8-NEXT:    bl callee3
; LE-P8-NEXT:    nop
; LE-P8-NEXT:    lwz r4, 16(r29)
; LE-P8-NEXT:    ld r29, -24(r30) # 8-byte Folded Reload
; LE-P8-NEXT:    add r3, r4, r3
; LE-P8-NEXT:    clrldi r3, r3, 32
; LE-P8-NEXT:    mr r1, r30
; LE-P8-NEXT:    ld r0, 16(r1)
; LE-P8-NEXT:    ld r30, -16(r1)
; LE-P8-NEXT:    hashchk r0, -32(r1)
; LE-P8-NEXT:    mtlr r0
; LE-P8-NEXT:    blr
;
; LE-P10-O0-LABEL: aligned:
; LE-P10-O0:       # %bb.0: # %entry
; LE-P10-O0-NEXT:    mflr r0
; LE-P10-O0-NEXT:    std r30, -16(r1)
; LE-P10-O0-NEXT:    std r0, 16(r1)
; LE-P10-O0-NEXT:    hashst r0, -24(r1)
; LE-P10-O0-NEXT:    mr r30, r1
; LE-P10-O0-NEXT:    clrldi r0, r1, 49
; LE-P10-O0-NEXT:    lis r12, -1
; LE-P10-O0-NEXT:    subc r0, r12, r0
; LE-P10-O0-NEXT:    stdux r1, r1, r0
; LE-P10-O0-NEXT:    std r3, 32752(r1) # 8-byte Folded Spill
; LE-P10-O0-NEXT:    lwz r4, 4(r3)
; LE-P10-O0-NEXT:    lis r5, 0
; LE-P10-O0-NEXT:    ori r5, r5, 65508
; LE-P10-O0-NEXT:    stwx r4, r1, r5
; LE-P10-O0-NEXT:    lwz r4, 12(r3)
; LE-P10-O0-NEXT:    lis r5, 0
; LE-P10-O0-NEXT:    ori r5, r5, 32768
; LE-P10-O0-NEXT:    stwx r4, r1, r5
; LE-P10-O0-NEXT:    lwz r3, 20(r3)
; LE-P10-O0-NEXT:    stw r3, 32764(r1)
; LE-P10-O0-NEXT:    lis r3, 0
; LE-P10-O0-NEXT:    ori r3, r3, 32768
; LE-P10-O0-NEXT:    add r3, r1, r3
; LE-P10-O0-NEXT:    lis r4, 0
; LE-P10-O0-NEXT:    ori r4, r4, 65508
; LE-P10-O0-NEXT:    add r4, r1, r4
; LE-P10-O0-NEXT:    addi r5, r1, 32764
; LE-P10-O0-NEXT:    bl callee3@notoc
; LE-P10-O0-NEXT:    mr r4, r3
; LE-P10-O0-NEXT:    ld r3, 32752(r1) # 8-byte Folded Reload
; LE-P10-O0-NEXT:    # kill: def $r4 killed $r4 killed $x4
; LE-P10-O0-NEXT:    lwz r3, 16(r3)
; LE-P10-O0-NEXT:    add r3, r3, r4
; LE-P10-O0-NEXT:    clrldi r3, r3, 32
; LE-P10-O0-NEXT:    mr r1, r30
; LE-P10-O0-NEXT:    ld r0, 16(r1)
; LE-P10-O0-NEXT:    ld r30, -16(r1)
; LE-P10-O0-NEXT:    hashchk r0, -24(r1)
; LE-P10-O0-NEXT:    mtlr r0
; LE-P10-O0-NEXT:    blr
;
; LE-P9-O0-LABEL: aligned:
; LE-P9-O0:       # %bb.0: # %entry
; LE-P9-O0-NEXT:    mflr r0
; LE-P9-O0-NEXT:    std r30, -16(r1)
; LE-P9-O0-NEXT:    std r0, 16(r1)
; LE-P9-O0-NEXT:    hashst r0, -24(r1)
; LE-P9-O0-NEXT:    mr r30, r1
; LE-P9-O0-NEXT:    clrldi r0, r1, 49
; LE-P9-O0-NEXT:    lis r12, -1
; LE-P9-O0-NEXT:    subc r0, r12, r0
; LE-P9-O0-NEXT:    stdux r1, r1, r0
; LE-P9-O0-NEXT:    std r3, 32752(r1) # 8-byte Folded Spill
; LE-P9-O0-NEXT:    lwz r4, 4(r3)
; LE-P9-O0-NEXT:    lis r5, 0
; LE-P9-O0-NEXT:    ori r5, r5, 65508
; LE-P9-O0-NEXT:    stwx r4, r1, r5
; LE-P9-O0-NEXT:    lwz r4, 12(r3)
; LE-P9-O0-NEXT:    lis r5, 0
; LE-P9-O0-NEXT:    ori r5, r5, 32768
; LE-P9-O0-NEXT:    stwx r4, r1, r5
; LE-P9-O0-NEXT:    lwz r3, 20(r3)
; LE-P9-O0-NEXT:    stw r3, 32764(r1)
; LE-P9-O0-NEXT:    lis r3, 0
; LE-P9-O0-NEXT:    ori r3, r3, 32768
; LE-P9-O0-NEXT:    add r3, r1, r3
; LE-P9-O0-NEXT:    lis r4, 0
; LE-P9-O0-NEXT:    ori r4, r4, 65508
; LE-P9-O0-NEXT:    add r4, r1, r4
; LE-P9-O0-NEXT:    addi r5, r1, 32764
; LE-P9-O0-NEXT:    bl callee3
; LE-P9-O0-NEXT:    nop
; LE-P9-O0-NEXT:    mr r4, r3
; LE-P9-O0-NEXT:    ld r3, 32752(r1) # 8-byte Folded Reload
; LE-P9-O0-NEXT:    lwz r3, 16(r3)
; LE-P9-O0-NEXT:    add r3, r3, r4
; LE-P9-O0-NEXT:    clrldi r3, r3, 32
; LE-P9-O0-NEXT:    mr r1, r30
; LE-P9-O0-NEXT:    ld r0, 16(r1)
; LE-P9-O0-NEXT:    ld r30, -16(r1)
; LE-P9-O0-NEXT:    hashchk r0, -24(r1)
; LE-P9-O0-NEXT:    mtlr r0
; LE-P9-O0-NEXT:    blr
;
; LE-P8-O0-LABEL: aligned:
; LE-P8-O0:       # %bb.0: # %entry
; LE-P8-O0-NEXT:    mflr r0
; LE-P8-O0-NEXT:    std r30, -16(r1)
; LE-P8-O0-NEXT:    std r0, 16(r1)
; LE-P8-O0-NEXT:    hashst r0, -24(r1)
; LE-P8-O0-NEXT:    mr r30, r1
; LE-P8-O0-NEXT:    clrldi r0, r1, 49
; LE-P8-O0-NEXT:    lis r12, -1
; LE-P8-O0-NEXT:    subc r0, r12, r0
; LE-P8-O0-NEXT:    stdux r1, r1, r0
; LE-P8-O0-NEXT:    std r3, 32752(r1) # 8-byte Folded Spill
; LE-P8-O0-NEXT:    lwz r4, 4(r3)
; LE-P8-O0-NEXT:    lis r5, 0
; LE-P8-O0-NEXT:    ori r5, r5, 65508
; LE-P8-O0-NEXT:    stwx r4, r1, r5
; LE-P8-O0-NEXT:    lwz r4, 12(r3)
; LE-P8-O0-NEXT:    lis r5, 0
; LE-P8-O0-NEXT:    ori r5, r5, 32768
; LE-P8-O0-NEXT:    stwx r4, r1, r5
; LE-P8-O0-NEXT:    lwz r3, 20(r3)
; LE-P8-O0-NEXT:    stw r3, 32764(r1)
; LE-P8-O0-NEXT:    lis r3, 0
; LE-P8-O0-NEXT:    ori r3, r3, 32768
; LE-P8-O0-NEXT:    add r3, r1, r3
; LE-P8-O0-NEXT:    lis r4, 0
; LE-P8-O0-NEXT:    ori r4, r4, 65508
; LE-P8-O0-NEXT:    add r4, r1, r4
; LE-P8-O0-NEXT:    addi r5, r1, 32764
; LE-P8-O0-NEXT:    bl callee3
; LE-P8-O0-NEXT:    nop
; LE-P8-O0-NEXT:    mr r4, r3
; LE-P8-O0-NEXT:    ld r3, 32752(r1) # 8-byte Folded Reload
; LE-P8-O0-NEXT:    lwz r3, 16(r3)
; LE-P8-O0-NEXT:    add r3, r3, r4
; LE-P8-O0-NEXT:    clrldi r3, r3, 32
; LE-P8-O0-NEXT:    mr r1, r30
; LE-P8-O0-NEXT:    ld r0, 16(r1)
; LE-P8-O0-NEXT:    ld r30, -16(r1)
; LE-P8-O0-NEXT:    hashchk r0, -24(r1)
; LE-P8-O0-NEXT:    mtlr r0
; LE-P8-O0-NEXT:    blr
;
; BE-P10-LABEL: aligned:
; BE-P10:       # %bb.0: # %entry
; BE-P10-NEXT:    mflr r0
; BE-P10-NEXT:    std r30, -16(r1)
; BE-P10-NEXT:    lis r12, -1
; BE-P10-NEXT:    mr r30, r1
; BE-P10-NEXT:    std r0, 16(r1)
; BE-P10-NEXT:    hashst r0, -32(r1)
; BE-P10-NEXT:    clrldi r0, r1, 49
; BE-P10-NEXT:    subc r0, r12, r0
; BE-P10-NEXT:    stdux r1, r1, r0
; BE-P10-NEXT:    std r29, -24(r30) # 8-byte Folded Spill
; BE-P10-NEXT:    mr r29, r3
; BE-P10-NEXT:    lwz r3, 4(r3)
; BE-P10-NEXT:    lis r4, 0
; BE-P10-NEXT:    addi r5, r1, 32764
; BE-P10-NEXT:    ori r4, r4, 65500
; BE-P10-NEXT:    stwx r3, r1, r4
; BE-P10-NEXT:    lwz r3, 12(r29)
; BE-P10-NEXT:    lis r4, 0
; BE-P10-NEXT:    ori r4, r4, 32768
; BE-P10-NEXT:    stwx r3, r1, r4
; BE-P10-NEXT:    lwz r3, 20(r29)
; BE-P10-NEXT:    lis r4, 0
; BE-P10-NEXT:    ori r4, r4, 65500
; BE-P10-NEXT:    add r4, r1, r4
; BE-P10-NEXT:    stw r3, 32764(r1)
; BE-P10-NEXT:    lis r3, 0
; BE-P10-NEXT:    ori r3, r3, 32768
; BE-P10-NEXT:    add r3, r1, r3
; BE-P10-NEXT:    bl callee3
; BE-P10-NEXT:    nop
; BE-P10-NEXT:    lwz r4, 16(r29)
; BE-P10-NEXT:    ld r29, -24(r30) # 8-byte Folded Reload
; BE-P10-NEXT:    add r3, r4, r3
; BE-P10-NEXT:    clrldi r3, r3, 32
; BE-P10-NEXT:    mr r1, r30
; BE-P10-NEXT:    ld r0, 16(r1)
; BE-P10-NEXT:    ld r30, -16(r1)
; BE-P10-NEXT:    mtlr r0
; BE-P10-NEXT:    hashchk r0, -32(r1)
; BE-P10-NEXT:    blr
;
; BE-P9-LABEL: aligned:
; BE-P9:       # %bb.0: # %entry
; BE-P9-NEXT:    mflr r0
; BE-P9-NEXT:    std r30, -16(r1)
; BE-P9-NEXT:    lis r12, -1
; BE-P9-NEXT:    mr r30, r1
; BE-P9-NEXT:    std r0, 16(r1)
; BE-P9-NEXT:    hashst r0, -32(r1)
; BE-P9-NEXT:    clrldi r0, r1, 49
; BE-P9-NEXT:    subc r0, r12, r0
; BE-P9-NEXT:    stdux r1, r1, r0
; BE-P9-NEXT:    std r29, -24(r30) # 8-byte Folded Spill
; BE-P9-NEXT:    mr r29, r3
; BE-P9-NEXT:    lwz r3, 4(r3)
; BE-P9-NEXT:    lis r4, 0
; BE-P9-NEXT:    addi r5, r1, 32764
; BE-P9-NEXT:    ori r4, r4, 65500
; BE-P9-NEXT:    stwx r3, r1, r4
; BE-P9-NEXT:    lwz r3, 12(r29)
; BE-P9-NEXT:    lis r4, 0
; BE-P9-NEXT:    ori r4, r4, 32768
; BE-P9-NEXT:    stwx r3, r1, r4
; BE-P9-NEXT:    lwz r3, 20(r29)
; BE-P9-NEXT:    lis r4, 0
; BE-P9-NEXT:    ori r4, r4, 65500
; BE-P9-NEXT:    stw r3, 32764(r1)
; BE-P9-NEXT:    lis r3, 0
; BE-P9-NEXT:    add r4, r1, r4
; BE-P9-NEXT:    ori r3, r3, 32768
; BE-P9-NEXT:    add r3, r1, r3
; BE-P9-NEXT:    bl callee3
; BE-P9-NEXT:    nop
; BE-P9-NEXT:    lwz r4, 16(r29)
; BE-P9-NEXT:    ld r29, -24(r30) # 8-byte Folded Reload
; BE-P9-NEXT:    add r3, r4, r3
; BE-P9-NEXT:    clrldi r3, r3, 32
; BE-P9-NEXT:    mr r1, r30
; BE-P9-NEXT:    ld r0, 16(r1)
; BE-P9-NEXT:    ld r30, -16(r1)
; BE-P9-NEXT:    mtlr r0
; BE-P9-NEXT:    hashchk r0, -32(r1)
; BE-P9-NEXT:    blr
;
; BE-P8-LABEL: aligned:
; BE-P8:       # %bb.0: # %entry
; BE-P8-NEXT:    mflr r0
; BE-P8-NEXT:    std r30, -16(r1)
; BE-P8-NEXT:    lis r12, -1
; BE-P8-NEXT:    mr r30, r1
; BE-P8-NEXT:    std r0, 16(r1)
; BE-P8-NEXT:    hashst r0, -32(r1)
; BE-P8-NEXT:    clrldi r0, r1, 49
; BE-P8-NEXT:    subc r0, r12, r0
; BE-P8-NEXT:    stdux r1, r1, r0
; BE-P8-NEXT:    std r29, -24(r30) # 8-byte Folded Spill
; BE-P8-NEXT:    mr r29, r3
; BE-P8-NEXT:    lwz r3, 4(r3)
; BE-P8-NEXT:    lis r6, 0
; BE-P8-NEXT:    ori r6, r6, 65500
; BE-P8-NEXT:    lwz r4, 12(r29)
; BE-P8-NEXT:    lwz r5, 20(r29)
; BE-P8-NEXT:    stwx r3, r1, r6
; BE-P8-NEXT:    lis r3, 0
; BE-P8-NEXT:    ori r3, r3, 32768
; BE-P8-NEXT:    stw r5, 32764(r1)
; BE-P8-NEXT:    addi r5, r1, 32764
; BE-P8-NEXT:    stwx r4, r1, r3
; BE-P8-NEXT:    lis r3, 0
; BE-P8-NEXT:    lis r4, 0
; BE-P8-NEXT:    ori r3, r3, 32768
; BE-P8-NEXT:    ori r4, r4, 65500
; BE-P8-NEXT:    add r3, r1, r3
; BE-P8-NEXT:    add r4, r1, r4
; BE-P8-NEXT:    bl callee3
; BE-P8-NEXT:    nop
; BE-P8-NEXT:    lwz r4, 16(r29)
; BE-P8-NEXT:    ld r29, -24(r30) # 8-byte Folded Reload
; BE-P8-NEXT:    add r3, r4, r3
; BE-P8-NEXT:    clrldi r3, r3, 32
; BE-P8-NEXT:    mr r1, r30
; BE-P8-NEXT:    ld r0, 16(r1)
; BE-P8-NEXT:    ld r30, -16(r1)
; BE-P8-NEXT:    hashchk r0, -32(r1)
; BE-P8-NEXT:    mtlr r0
; BE-P8-NEXT:    blr
;
; BE-32BIT-P10-LABEL: aligned:
; BE-32BIT-P10:       # %bb.0: # %entry
; BE-32BIT-P10-NEXT:    mflr r0
; BE-32BIT-P10-NEXT:    lis r12, -1
; BE-32BIT-P10-NEXT:    stw r0, 4(r1)
; BE-32BIT-P10-NEXT:    hashst r0, -24(r1)
; BE-32BIT-P10-NEXT:    clrlwi r0, r1, 17
; BE-32BIT-P10-NEXT:    subc r0, r12, r0
; BE-32BIT-P10-NEXT:    stwux r1, r1, r0
; BE-32BIT-P10-NEXT:    sub r0, r1, r0
; BE-32BIT-P10-NEXT:    lis r4, 0
; BE-32BIT-P10-NEXT:    addi r5, r1, 32764
; BE-32BIT-P10-NEXT:    addic r0, r0, -8
; BE-32BIT-P10-NEXT:    ori r4, r4, 65508
; BE-32BIT-P10-NEXT:    stwx r30, 0, r0
; BE-32BIT-P10-NEXT:    addic r30, r0, 8
; BE-32BIT-P10-NEXT:    stw r29, -12(r30) # 4-byte Folded Spill
; BE-32BIT-P10-NEXT:    mr r29, r3
; BE-32BIT-P10-NEXT:    lwz r3, 4(r3)
; BE-32BIT-P10-NEXT:    stwx r3, r1, r4
; BE-32BIT-P10-NEXT:    lwz r3, 12(r29)
; BE-32BIT-P10-NEXT:    lis r4, 0
; BE-32BIT-P10-NEXT:    ori r4, r4, 32768
; BE-32BIT-P10-NEXT:    stwx r3, r1, r4
; BE-32BIT-P10-NEXT:    lwz r3, 20(r29)
; BE-32BIT-P10-NEXT:    lis r4, 0
; BE-32BIT-P10-NEXT:    ori r4, r4, 65508
; BE-32BIT-P10-NEXT:    add r4, r1, r4
; BE-32BIT-P10-NEXT:    stw r3, 32764(r1)
; BE-32BIT-P10-NEXT:    lis r3, 0
; BE-32BIT-P10-NEXT:    ori r3, r3, 32768
; BE-32BIT-P10-NEXT:    add r3, r1, r3
; BE-32BIT-P10-NEXT:    bl callee3
; BE-32BIT-P10-NEXT:    lwz r4, 16(r29)
; BE-32BIT-P10-NEXT:    lwz r29, -12(r30) # 4-byte Folded Reload
; BE-32BIT-P10-NEXT:    mr r0, r31
; BE-32BIT-P10-NEXT:    add r3, r4, r3
; BE-32BIT-P10-NEXT:    lwz r31, 0(r1)
; BE-32BIT-P10-NEXT:    lwz r30, -8(r31)
; BE-32BIT-P10-NEXT:    mr r1, r31
; BE-32BIT-P10-NEXT:    mr r31, r0
; BE-32BIT-P10-NEXT:    lwz r0, 4(r1)
; BE-32BIT-P10-NEXT:    hashchk r0, -24(r1)
; BE-32BIT-P10-NEXT:    mtlr r0
; BE-32BIT-P10-NEXT:    blr
;
; BE-32BIT-P9-LABEL: aligned:
; BE-32BIT-P9:       # %bb.0: # %entry
; BE-32BIT-P9-NEXT:    mflr r0
; BE-32BIT-P9-NEXT:    lis r12, -1
; BE-32BIT-P9-NEXT:    stw r0, 4(r1)
; BE-32BIT-P9-NEXT:    hashst r0, -24(r1)
; BE-32BIT-P9-NEXT:    clrlwi r0, r1, 17
; BE-32BIT-P9-NEXT:    subc r0, r12, r0
; BE-32BIT-P9-NEXT:    stwux r1, r1, r0
; BE-32BIT-P9-NEXT:    sub r0, r1, r0
; BE-32BIT-P9-NEXT:    lis r4, 0
; BE-32BIT-P9-NEXT:    addi r5, r1, 32764
; BE-32BIT-P9-NEXT:    addic r0, r0, -8
; BE-32BIT-P9-NEXT:    ori r4, r4, 65508
; BE-32BIT-P9-NEXT:    stwx r30, 0, r0
; BE-32BIT-P9-NEXT:    addic r30, r0, 8
; BE-32BIT-P9-NEXT:    stw r29, -12(r30) # 4-byte Folded Spill
; BE-32BIT-P9-NEXT:    mr r29, r3
; BE-32BIT-P9-NEXT:    lwz r3, 4(r3)
; BE-32BIT-P9-NEXT:    stwx r3, r1, r4
; BE-32BIT-P9-NEXT:    lwz r3, 12(r29)
; BE-32BIT-P9-NEXT:    lis r4, 0
; BE-32BIT-P9-NEXT:    ori r4, r4, 32768
; BE-32BIT-P9-NEXT:    stwx r3, r1, r4
; BE-32BIT-P9-NEXT:    lwz r3, 20(r29)
; BE-32BIT-P9-NEXT:    lis r4, 0
; BE-32BIT-P9-NEXT:    ori r4, r4, 65508
; BE-32BIT-P9-NEXT:    stw r3, 32764(r1)
; BE-32BIT-P9-NEXT:    lis r3, 0
; BE-32BIT-P9-NEXT:    add r4, r1, r4
; BE-32BIT-P9-NEXT:    ori r3, r3, 32768
; BE-32BIT-P9-NEXT:    add r3, r1, r3
; BE-32BIT-P9-NEXT:    bl callee3
; BE-32BIT-P9-NEXT:    lwz r4, 16(r29)
; BE-32BIT-P9-NEXT:    lwz r29, -12(r30) # 4-byte Folded Reload
; BE-32BIT-P9-NEXT:    mr r0, r31
; BE-32BIT-P9-NEXT:    lwz r31, 0(r1)
; BE-32BIT-P9-NEXT:    lwz r30, -8(r31)
; BE-32BIT-P9-NEXT:    add r3, r4, r3
; BE-32BIT-P9-NEXT:    mr r1, r31
; BE-32BIT-P9-NEXT:    mr r31, r0
; BE-32BIT-P9-NEXT:    lwz r0, 4(r1)
; BE-32BIT-P9-NEXT:    mtlr r0
; BE-32BIT-P9-NEXT:    hashchk r0, -24(r1)
; BE-32BIT-P9-NEXT:    blr
;
; BE-32BIT-P8-LABEL: aligned:
; BE-32BIT-P8:       # %bb.0: # %entry
; BE-32BIT-P8-NEXT:    mflr r0
; BE-32BIT-P8-NEXT:    lis r12, -1
; BE-32BIT-P8-NEXT:    stw r0, 4(r1)
; BE-32BIT-P8-NEXT:    hashst r0, -24(r1)
; BE-32BIT-P8-NEXT:    clrlwi r0, r1, 17
; BE-32BIT-P8-NEXT:    subc r0, r12, r0
; BE-32BIT-P8-NEXT:    stwux r1, r1, r0
; BE-32BIT-P8-NEXT:    sub r0, r1, r0
; BE-32BIT-P8-NEXT:    lis r6, 0
; BE-32BIT-P8-NEXT:    addic r0, r0, -8
; BE-32BIT-P8-NEXT:    ori r6, r6, 65508
; BE-32BIT-P8-NEXT:    stwx r30, 0, r0
; BE-32BIT-P8-NEXT:    addic r30, r0, 8
; BE-32BIT-P8-NEXT:    stw r29, -12(r30) # 4-byte Folded Spill
; BE-32BIT-P8-NEXT:    mr r29, r3
; BE-32BIT-P8-NEXT:    lwz r3, 4(r3)
; BE-32BIT-P8-NEXT:    lwz r4, 12(r29)
; BE-32BIT-P8-NEXT:    lwz r5, 20(r29)
; BE-32BIT-P8-NEXT:    stwx r3, r1, r6
; BE-32BIT-P8-NEXT:    lis r3, 0
; BE-32BIT-P8-NEXT:    ori r3, r3, 32768
; BE-32BIT-P8-NEXT:    stw r5, 32764(r1)
; BE-32BIT-P8-NEXT:    addi r5, r1, 32764
; BE-32BIT-P8-NEXT:    stwx r4, r1, r3
; BE-32BIT-P8-NEXT:    lis r3, 0
; BE-32BIT-P8-NEXT:    lis r4, 0
; BE-32BIT-P8-NEXT:    ori r3, r3, 32768
; BE-32BIT-P8-NEXT:    ori r4, r4, 65508
; BE-32BIT-P8-NEXT:    add r3, r1, r3
; BE-32BIT-P8-NEXT:    add r4, r1, r4
; BE-32BIT-P8-NEXT:    bl callee3
; BE-32BIT-P8-NEXT:    lwz r4, 16(r29)
; BE-32BIT-P8-NEXT:    lwz r29, -12(r30) # 4-byte Folded Reload
; BE-32BIT-P8-NEXT:    mr r0, r31
; BE-32BIT-P8-NEXT:    lwz r31, 0(r1)
; BE-32BIT-P8-NEXT:    lwz r30, -8(r31)
; BE-32BIT-P8-NEXT:    add r3, r4, r3
; BE-32BIT-P8-NEXT:    mr r1, r31
; BE-32BIT-P8-NEXT:    mr r31, r0
; BE-32BIT-P8-NEXT:    lwz r0, 4(r1)
; BE-32BIT-P8-NEXT:    hashchk r0, -24(r1)
; BE-32BIT-P8-NEXT:    mtlr r0
; BE-32BIT-P8-NEXT:    blr
;
; LE-P10-PRIV-LABEL: aligned:
; LE-P10-PRIV:       # %bb.0: # %entry
; LE-P10-PRIV-NEXT:    mflr r0
; LE-P10-PRIV-NEXT:    std r30, -16(r1)
; LE-P10-PRIV-NEXT:    lis r12, -1
; LE-P10-PRIV-NEXT:    mr r30, r1
; LE-P10-PRIV-NEXT:    std r0, 16(r1)
; LE-P10-PRIV-NEXT:    hashstp r0, -32(r1)
; LE-P10-PRIV-NEXT:    clrldi r0, r1, 49
; LE-P10-PRIV-NEXT:    subc r0, r12, r0
; LE-P10-PRIV-NEXT:    stdux r1, r1, r0
; LE-P10-PRIV-NEXT:    std r29, -24(r30) # 8-byte Folded Spill
; LE-P10-PRIV-NEXT:    mr r29, r3
; LE-P10-PRIV-NEXT:    lwz r3, 4(r3)
; LE-P10-PRIV-NEXT:    lis r4, 0
; LE-P10-PRIV-NEXT:    addi r5, r1, 32764
; LE-P10-PRIV-NEXT:    ori r4, r4, 65500
; LE-P10-PRIV-NEXT:    stwx r3, r1, r4
; LE-P10-PRIV-NEXT:    lwz r3, 12(r29)
; LE-P10-PRIV-NEXT:    lis r4, 0
; LE-P10-PRIV-NEXT:    ori r4, r4, 32768
; LE-P10-PRIV-NEXT:    stwx r3, r1, r4
; LE-P10-PRIV-NEXT:    lwz r3, 20(r29)
; LE-P10-PRIV-NEXT:    lis r4, 0
; LE-P10-PRIV-NEXT:    ori r4, r4, 65500
; LE-P10-PRIV-NEXT:    add r4, r1, r4
; LE-P10-PRIV-NEXT:    stw r3, 32764(r1)
; LE-P10-PRIV-NEXT:    lis r3, 0
; LE-P10-PRIV-NEXT:    ori r3, r3, 32768
; LE-P10-PRIV-NEXT:    add r3, r1, r3
; LE-P10-PRIV-NEXT:    bl callee3@notoc
; LE-P10-PRIV-NEXT:    lwz r4, 16(r29)
; LE-P10-PRIV-NEXT:    ld r29, -24(r30) # 8-byte Folded Reload
; LE-P10-PRIV-NEXT:    add r3, r4, r3
; LE-P10-PRIV-NEXT:    clrldi r3, r3, 32
; LE-P10-PRIV-NEXT:    mr r1, r30
; LE-P10-PRIV-NEXT:    ld r0, 16(r1)
; LE-P10-PRIV-NEXT:    ld r30, -16(r1)
; LE-P10-PRIV-NEXT:    mtlr r0
; LE-P10-PRIV-NEXT:    hashchkp r0, -32(r1)
; LE-P10-PRIV-NEXT:    blr
;
; LE-P9-PRIV-LABEL: aligned:
; LE-P9-PRIV:       # %bb.0: # %entry
; LE-P9-PRIV-NEXT:    mflr r0
; LE-P9-PRIV-NEXT:    std r30, -16(r1)
; LE-P9-PRIV-NEXT:    lis r12, -1
; LE-P9-PRIV-NEXT:    mr r30, r1
; LE-P9-PRIV-NEXT:    std r0, 16(r1)
; LE-P9-PRIV-NEXT:    hashstp r0, -32(r1)
; LE-P9-PRIV-NEXT:    clrldi r0, r1, 49
; LE-P9-PRIV-NEXT:    subc r0, r12, r0
; LE-P9-PRIV-NEXT:    stdux r1, r1, r0
; LE-P9-PRIV-NEXT:    std r29, -24(r30) # 8-byte Folded Spill
; LE-P9-PRIV-NEXT:    mr r29, r3
; LE-P9-PRIV-NEXT:    lwz r3, 4(r3)
; LE-P9-PRIV-NEXT:    lis r4, 0
; LE-P9-PRIV-NEXT:    addi r5, r1, 32764
; LE-P9-PRIV-NEXT:    ori r4, r4, 65500
; LE-P9-PRIV-NEXT:    stwx r3, r1, r4
; LE-P9-PRIV-NEXT:    lwz r3, 12(r29)
; LE-P9-PRIV-NEXT:    lis r4, 0
; LE-P9-PRIV-NEXT:    ori r4, r4, 32768
; LE-P9-PRIV-NEXT:    stwx r3, r1, r4
; LE-P9-PRIV-NEXT:    lwz r3, 20(r29)
; LE-P9-PRIV-NEXT:    lis r4, 0
; LE-P9-PRIV-NEXT:    ori r4, r4, 65500
; LE-P9-PRIV-NEXT:    stw r3, 32764(r1)
; LE-P9-PRIV-NEXT:    lis r3, 0
; LE-P9-PRIV-NEXT:    add r4, r1, r4
; LE-P9-PRIV-NEXT:    ori r3, r3, 32768
; LE-P9-PRIV-NEXT:    add r3, r1, r3
; LE-P9-PRIV-NEXT:    bl callee3
; LE-P9-PRIV-NEXT:    nop
; LE-P9-PRIV-NEXT:    lwz r4, 16(r29)
; LE-P9-PRIV-NEXT:    ld r29, -24(r30) # 8-byte Folded Reload
; LE-P9-PRIV-NEXT:    add r3, r4, r3
; LE-P9-PRIV-NEXT:    clrldi r3, r3, 32
; LE-P9-PRIV-NEXT:    mr r1, r30
; LE-P9-PRIV-NEXT:    ld r0, 16(r1)
; LE-P9-PRIV-NEXT:    ld r30, -16(r1)
; LE-P9-PRIV-NEXT:    mtlr r0
; LE-P9-PRIV-NEXT:    hashchkp r0, -32(r1)
; LE-P9-PRIV-NEXT:    blr
;
; LE-P8-PRIV-LABEL: aligned:
; LE-P8-PRIV:       # %bb.0: # %entry
; LE-P8-PRIV-NEXT:    mflr r0
; LE-P8-PRIV-NEXT:    std r30, -16(r1)
; LE-P8-PRIV-NEXT:    lis r12, -1
; LE-P8-PRIV-NEXT:    mr r30, r1
; LE-P8-PRIV-NEXT:    std r0, 16(r1)
; LE-P8-PRIV-NEXT:    hashstp r0, -32(r1)
; LE-P8-PRIV-NEXT:    clrldi r0, r1, 49
; LE-P8-PRIV-NEXT:    subc r0, r12, r0
; LE-P8-PRIV-NEXT:    stdux r1, r1, r0
; LE-P8-PRIV-NEXT:    std r29, -24(r30) # 8-byte Folded Spill
; LE-P8-PRIV-NEXT:    mr r29, r3
; LE-P8-PRIV-NEXT:    lwz r3, 4(r3)
; LE-P8-PRIV-NEXT:    lis r6, 0
; LE-P8-PRIV-NEXT:    ori r6, r6, 65500
; LE-P8-PRIV-NEXT:    lwz r4, 12(r29)
; LE-P8-PRIV-NEXT:    lwz r5, 20(r29)
; LE-P8-PRIV-NEXT:    stwx r3, r1, r6
; LE-P8-PRIV-NEXT:    lis r3, 0
; LE-P8-PRIV-NEXT:    ori r3, r3, 32768
; LE-P8-PRIV-NEXT:    stw r5, 32764(r1)
; LE-P8-PRIV-NEXT:    addi r5, r1, 32764
; LE-P8-PRIV-NEXT:    stwx r4, r1, r3
; LE-P8-PRIV-NEXT:    lis r3, 0
; LE-P8-PRIV-NEXT:    lis r4, 0
; LE-P8-PRIV-NEXT:    ori r3, r3, 32768
; LE-P8-PRIV-NEXT:    ori r4, r4, 65500
; LE-P8-PRIV-NEXT:    add r3, r1, r3
; LE-P8-PRIV-NEXT:    add r4, r1, r4
; LE-P8-PRIV-NEXT:    bl callee3
; LE-P8-PRIV-NEXT:    nop
; LE-P8-PRIV-NEXT:    lwz r4, 16(r29)
; LE-P8-PRIV-NEXT:    ld r29, -24(r30) # 8-byte Folded Reload
; LE-P8-PRIV-NEXT:    add r3, r4, r3
; LE-P8-PRIV-NEXT:    clrldi r3, r3, 32
; LE-P8-PRIV-NEXT:    mr r1, r30
; LE-P8-PRIV-NEXT:    ld r0, 16(r1)
; LE-P8-PRIV-NEXT:    ld r30, -16(r1)
; LE-P8-PRIV-NEXT:    hashchkp r0, -32(r1)
; LE-P8-PRIV-NEXT:    mtlr r0
; LE-P8-PRIV-NEXT:    blr
;
; BE-P10-PRIV-LABEL: aligned:
; BE-P10-PRIV:       # %bb.0: # %entry
; BE-P10-PRIV-NEXT:    mflr r0
; BE-P10-PRIV-NEXT:    std r30, -16(r1)
; BE-P10-PRIV-NEXT:    lis r12, -1
; BE-P10-PRIV-NEXT:    mr r30, r1
; BE-P10-PRIV-NEXT:    std r0, 16(r1)
; BE-P10-PRIV-NEXT:    hashstp r0, -32(r1)
; BE-P10-PRIV-NEXT:    clrldi r0, r1, 49
; BE-P10-PRIV-NEXT:    subc r0, r12, r0
; BE-P10-PRIV-NEXT:    stdux r1, r1, r0
; BE-P10-PRIV-NEXT:    std r29, -24(r30) # 8-byte Folded Spill
; BE-P10-PRIV-NEXT:    mr r29, r3
; BE-P10-PRIV-NEXT:    lwz r3, 4(r3)
; BE-P10-PRIV-NEXT:    lis r4, 0
; BE-P10-PRIV-NEXT:    addi r5, r1, 32764
; BE-P10-PRIV-NEXT:    ori r4, r4, 65500
; BE-P10-PRIV-NEXT:    stwx r3, r1, r4
; BE-P10-PRIV-NEXT:    lwz r3, 12(r29)
; BE-P10-PRIV-NEXT:    lis r4, 0
; BE-P10-PRIV-NEXT:    ori r4, r4, 32768
; BE-P10-PRIV-NEXT:    stwx r3, r1, r4
; BE-P10-PRIV-NEXT:    lwz r3, 20(r29)
; BE-P10-PRIV-NEXT:    lis r4, 0
; BE-P10-PRIV-NEXT:    ori r4, r4, 65500
; BE-P10-PRIV-NEXT:    add r4, r1, r4
; BE-P10-PRIV-NEXT:    stw r3, 32764(r1)
; BE-P10-PRIV-NEXT:    lis r3, 0
; BE-P10-PRIV-NEXT:    ori r3, r3, 32768
; BE-P10-PRIV-NEXT:    add r3, r1, r3
; BE-P10-PRIV-NEXT:    bl callee3
; BE-P10-PRIV-NEXT:    nop
; BE-P10-PRIV-NEXT:    lwz r4, 16(r29)
; BE-P10-PRIV-NEXT:    ld r29, -24(r30) # 8-byte Folded Reload
; BE-P10-PRIV-NEXT:    add r3, r4, r3
; BE-P10-PRIV-NEXT:    clrldi r3, r3, 32
; BE-P10-PRIV-NEXT:    mr r1, r30
; BE-P10-PRIV-NEXT:    ld r0, 16(r1)
; BE-P10-PRIV-NEXT:    ld r30, -16(r1)
; BE-P10-PRIV-NEXT:    mtlr r0
; BE-P10-PRIV-NEXT:    hashchkp r0, -32(r1)
; BE-P10-PRIV-NEXT:    blr
;
; BE-P9-PRIV-LABEL: aligned:
; BE-P9-PRIV:       # %bb.0: # %entry
; BE-P9-PRIV-NEXT:    mflr r0
; BE-P9-PRIV-NEXT:    std r30, -16(r1)
; BE-P9-PRIV-NEXT:    lis r12, -1
; BE-P9-PRIV-NEXT:    mr r30, r1
; BE-P9-PRIV-NEXT:    std r0, 16(r1)
; BE-P9-PRIV-NEXT:    hashstp r0, -32(r1)
; BE-P9-PRIV-NEXT:    clrldi r0, r1, 49
; BE-P9-PRIV-NEXT:    subc r0, r12, r0
; BE-P9-PRIV-NEXT:    stdux r1, r1, r0
; BE-P9-PRIV-NEXT:    std r29, -24(r30) # 8-byte Folded Spill
; BE-P9-PRIV-NEXT:    mr r29, r3
; BE-P9-PRIV-NEXT:    lwz r3, 4(r3)
; BE-P9-PRIV-NEXT:    lis r4, 0
; BE-P9-PRIV-NEXT:    addi r5, r1, 32764
; BE-P9-PRIV-NEXT:    ori r4, r4, 65500
; BE-P9-PRIV-NEXT:    stwx r3, r1, r4
; BE-P9-PRIV-NEXT:    lwz r3, 12(r29)
; BE-P9-PRIV-NEXT:    lis r4, 0
; BE-P9-PRIV-NEXT:    ori r4, r4, 32768
; BE-P9-PRIV-NEXT:    stwx r3, r1, r4
; BE-P9-PRIV-NEXT:    lwz r3, 20(r29)
; BE-P9-PRIV-NEXT:    lis r4, 0
; BE-P9-PRIV-NEXT:    ori r4, r4, 65500
; BE-P9-PRIV-NEXT:    stw r3, 32764(r1)
; BE-P9-PRIV-NEXT:    lis r3, 0
; BE-P9-PRIV-NEXT:    add r4, r1, r4
; BE-P9-PRIV-NEXT:    ori r3, r3, 32768
; BE-P9-PRIV-NEXT:    add r3, r1, r3
; BE-P9-PRIV-NEXT:    bl callee3
; BE-P9-PRIV-NEXT:    nop
; BE-P9-PRIV-NEXT:    lwz r4, 16(r29)
; BE-P9-PRIV-NEXT:    ld r29, -24(r30) # 8-byte Folded Reload
; BE-P9-PRIV-NEXT:    add r3, r4, r3
; BE-P9-PRIV-NEXT:    clrldi r3, r3, 32
; BE-P9-PRIV-NEXT:    mr r1, r30
; BE-P9-PRIV-NEXT:    ld r0, 16(r1)
; BE-P9-PRIV-NEXT:    ld r30, -16(r1)
; BE-P9-PRIV-NEXT:    mtlr r0
; BE-P9-PRIV-NEXT:    hashchkp r0, -32(r1)
; BE-P9-PRIV-NEXT:    blr
;
; BE-P8-PRIV-LABEL: aligned:
; BE-P8-PRIV:       # %bb.0: # %entry
; BE-P8-PRIV-NEXT:    mflr r0
; BE-P8-PRIV-NEXT:    std r30, -16(r1)
; BE-P8-PRIV-NEXT:    lis r12, -1
; BE-P8-PRIV-NEXT:    mr r30, r1
; BE-P8-PRIV-NEXT:    std r0, 16(r1)
; BE-P8-PRIV-NEXT:    hashstp r0, -32(r1)
; BE-P8-PRIV-NEXT:    clrldi r0, r1, 49
; BE-P8-PRIV-NEXT:    subc r0, r12, r0
; BE-P8-PRIV-NEXT:    stdux r1, r1, r0
; BE-P8-PRIV-NEXT:    std r29, -24(r30) # 8-byte Folded Spill
; BE-P8-PRIV-NEXT:    mr r29, r3
; BE-P8-PRIV-NEXT:    lwz r3, 4(r3)
; BE-P8-PRIV-NEXT:    lis r6, 0
; BE-P8-PRIV-NEXT:    ori r6, r6, 65500
; BE-P8-PRIV-NEXT:    lwz r4, 12(r29)
; BE-P8-PRIV-NEXT:    lwz r5, 20(r29)
; BE-P8-PRIV-NEXT:    stwx r3, r1, r6
; BE-P8-PRIV-NEXT:    lis r3, 0
; BE-P8-PRIV-NEXT:    ori r3, r3, 32768
; BE-P8-PRIV-NEXT:    stw r5, 32764(r1)
; BE-P8-PRIV-NEXT:    addi r5, r1, 32764
; BE-P8-PRIV-NEXT:    stwx r4, r1, r3
; BE-P8-PRIV-NEXT:    lis r3, 0
; BE-P8-PRIV-NEXT:    lis r4, 0
; BE-P8-PRIV-NEXT:    ori r3, r3, 32768
; BE-P8-PRIV-NEXT:    ori r4, r4, 65500
; BE-P8-PRIV-NEXT:    add r3, r1, r3
; BE-P8-PRIV-NEXT:    add r4, r1, r4
; BE-P8-PRIV-NEXT:    bl callee3
; BE-P8-PRIV-NEXT:    nop
; BE-P8-PRIV-NEXT:    lwz r4, 16(r29)
; BE-P8-PRIV-NEXT:    ld r29, -24(r30) # 8-byte Folded Reload
; BE-P8-PRIV-NEXT:    add r3, r4, r3
; BE-P8-PRIV-NEXT:    clrldi r3, r3, 32
; BE-P8-PRIV-NEXT:    mr r1, r30
; BE-P8-PRIV-NEXT:    ld r0, 16(r1)
; BE-P8-PRIV-NEXT:    ld r30, -16(r1)
; BE-P8-PRIV-NEXT:    hashchkp r0, -32(r1)
; BE-P8-PRIV-NEXT:    mtlr r0
; BE-P8-PRIV-NEXT:    blr
entry:
  %beforeLocal = alloca i32, align 4
  %local = alloca i32, align 32768
  %afterLocal = alloca i32, align 4
  call void @llvm.lifetime.start.p0(i64 4, ptr nonnull %beforeLocal)
  %arrayidx = getelementptr inbounds i32, ptr %in, i64 1
  %0 = load i32, ptr %arrayidx, align 4
  store i32 %0, ptr %beforeLocal, align 4
  call void @llvm.lifetime.start.p0(i64 4, ptr nonnull %local)
  %arrayidx1 = getelementptr inbounds i32, ptr %in, i64 3
  %1 = load i32, ptr %arrayidx1, align 4
  store i32 %1, ptr %local, align 32768
  call void @llvm.lifetime.start.p0(i64 4, ptr nonnull %afterLocal)
  %arrayidx2 = getelementptr inbounds i32, ptr %in, i64 5
  %2 = load i32, ptr %arrayidx2, align 4
  store i32 %2, ptr %afterLocal, align 4
  %call = call zeroext i32 @callee3(ptr nonnull %local, ptr nonnull %beforeLocal, ptr nonnull %afterLocal)
  %arrayidx3 = getelementptr inbounds i32, ptr %in, i64 4
  %3 = load i32, ptr %arrayidx3, align 4
  %add = add i32 %3, %call
  call void @llvm.lifetime.end.p0(i64 4, ptr nonnull %afterLocal)
  call void @llvm.lifetime.end.p0(i64 4, ptr nonnull %local)
  call void @llvm.lifetime.end.p0(i64 4, ptr nonnull %beforeLocal)
  ret i32 %add
}

declare zeroext i32 @callee(i32 zeroext) local_unnamed_addr
declare zeroext i32 @callee2(ptr) local_unnamed_addr
declare zeroext i32 @callee3(ptr, ptr, ptr) local_unnamed_addr
declare void @llvm.lifetime.start.p0(i64 immarg, ptr nocapture)
declare void @llvm.lifetime.end.p0(i64 immarg, ptr nocapture)

attributes #0 = { nounwind }
