; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+f,+d,+v -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64d -riscv-v-vector-bits-min=0 | FileCheck --check-prefix=CHECK-NOV %s
; RUN: llc -mtriple=riscv64 -mattr=+f,+d,+v -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64d -riscv-v-vector-bits-min=-1 | FileCheck --check-prefix=CHECK-V %s

; i32 saturate

define <2 x i32> @stest_f64i32(<2 x double> %x) {
; CHECK-NOV-LABEL: stest_f64i32:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.l.d a1, fa1, rtz
; CHECK-NOV-NEXT:    lui a2, 524288
; CHECK-NOV-NEXT:    addiw a3, a2, -1
; CHECK-NOV-NEXT:    fcvt.l.d a0, fa0, rtz
; CHECK-NOV-NEXT:    bge a1, a3, .LBB0_5
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    bge a0, a3, .LBB0_6
; CHECK-NOV-NEXT:  .LBB0_2: # %entry
; CHECK-NOV-NEXT:    bge a2, a0, .LBB0_7
; CHECK-NOV-NEXT:  .LBB0_3: # %entry
; CHECK-NOV-NEXT:    bge a2, a1, .LBB0_8
; CHECK-NOV-NEXT:  .LBB0_4: # %entry
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB0_5: # %entry
; CHECK-NOV-NEXT:    mv a1, a3
; CHECK-NOV-NEXT:    blt a0, a3, .LBB0_2
; CHECK-NOV-NEXT:  .LBB0_6: # %entry
; CHECK-NOV-NEXT:    mv a0, a3
; CHECK-NOV-NEXT:    blt a2, a0, .LBB0_3
; CHECK-NOV-NEXT:  .LBB0_7: # %entry
; CHECK-NOV-NEXT:    lui a0, 524288
; CHECK-NOV-NEXT:    blt a2, a1, .LBB0_4
; CHECK-NOV-NEXT:  .LBB0_8: # %entry
; CHECK-NOV-NEXT:    lui a1, 524288
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: stest_f64i32:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-V-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-V-NEXT:    lui a0, 524288
; CHECK-V-NEXT:    addiw a1, a0, -1
; CHECK-V-NEXT:    vmin.vx v8, v8, a1
; CHECK-V-NEXT:    vmax.vx v8, v8, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %0 = icmp slt <2 x i64> %conv, <i64 2147483647, i64 2147483647>
  %spec.store.select = select <2 x i1> %0, <2 x i64> %conv, <2 x i64> <i64 2147483647, i64 2147483647>
  %1 = icmp sgt <2 x i64> %spec.store.select, <i64 -2147483648, i64 -2147483648>
  %spec.store.select7 = select <2 x i1> %1, <2 x i64> %spec.store.select, <2 x i64> <i64 -2147483648, i64 -2147483648>
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @utest_f64i32(<2 x double> %x) {
; CHECK-NOV-LABEL: utest_f64i32:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.d a0, fa0, rtz
; CHECK-NOV-NEXT:    li a1, -1
; CHECK-NOV-NEXT:    srli a2, a1, 32
; CHECK-NOV-NEXT:    fcvt.lu.d a1, fa1, rtz
; CHECK-NOV-NEXT:    bgeu a0, a2, .LBB1_3
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    bgeu a1, a2, .LBB1_4
; CHECK-NOV-NEXT:  .LBB1_2: # %entry
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB1_3: # %entry
; CHECK-NOV-NEXT:    mv a0, a2
; CHECK-NOV-NEXT:    bltu a1, a2, .LBB1_2
; CHECK-NOV-NEXT:  .LBB1_4: # %entry
; CHECK-NOV-NEXT:    mv a1, a2
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: utest_f64i32:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-V-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-V-NEXT:    li a0, -1
; CHECK-V-NEXT:    srli a0, a0, 32
; CHECK-V-NEXT:    vminu.vx v8, v8, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptoui <2 x double> %x to <2 x i64>
  %0 = icmp ult <2 x i64> %conv, <i64 4294967295, i64 4294967295>
  %spec.store.select = select <2 x i1> %0, <2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>
  %conv6 = trunc <2 x i64> %spec.store.select to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @ustest_f64i32(<2 x double> %x) {
; CHECK-NOV-LABEL: ustest_f64i32:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.l.d a1, fa1, rtz
; CHECK-NOV-NEXT:    li a0, -1
; CHECK-NOV-NEXT:    srli a2, a0, 32
; CHECK-NOV-NEXT:    fcvt.l.d a0, fa0, rtz
; CHECK-NOV-NEXT:    blt a1, a2, .LBB2_2
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    mv a1, a2
; CHECK-NOV-NEXT:  .LBB2_2: # %entry
; CHECK-NOV-NEXT:    blt a0, a2, .LBB2_4
; CHECK-NOV-NEXT:  # %bb.3: # %entry
; CHECK-NOV-NEXT:    mv a0, a2
; CHECK-NOV-NEXT:  .LBB2_4: # %entry
; CHECK-NOV-NEXT:    sgtz a2, a0
; CHECK-NOV-NEXT:    neg a2, a2
; CHECK-NOV-NEXT:    and a0, a2, a0
; CHECK-NOV-NEXT:    sgtz a2, a1
; CHECK-NOV-NEXT:    neg a2, a2
; CHECK-NOV-NEXT:    and a1, a2, a1
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: ustest_f64i32:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-V-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-V-NEXT:    li a0, -1
; CHECK-V-NEXT:    srli a0, a0, 32
; CHECK-V-NEXT:    vmin.vx v8, v8, a0
; CHECK-V-NEXT:    vmax.vx v8, v8, zero
; CHECK-V-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %0 = icmp slt <2 x i64> %conv, <i64 4294967295, i64 4294967295>
  %spec.store.select = select <2 x i1> %0, <2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>
  %1 = icmp sgt <2 x i64> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i64> %spec.store.select, <2 x i64> zeroinitializer
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <4 x i32> @stest_f32i32(<4 x float> %x) {
; CHECK-NOV-LABEL: stest_f32i32:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a1, fa3, rtz
; CHECK-NOV-NEXT:    lui a3, 524288
; CHECK-NOV-NEXT:    addiw a6, a3, -1
; CHECK-NOV-NEXT:    fcvt.l.s a2, fa2, rtz
; CHECK-NOV-NEXT:    bge a1, a6, .LBB3_10
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a4, fa1, rtz
; CHECK-NOV-NEXT:    bge a2, a6, .LBB3_11
; CHECK-NOV-NEXT:  .LBB3_2: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a5, fa0, rtz
; CHECK-NOV-NEXT:    bge a4, a6, .LBB3_12
; CHECK-NOV-NEXT:  .LBB3_3: # %entry
; CHECK-NOV-NEXT:    bge a5, a6, .LBB3_13
; CHECK-NOV-NEXT:  .LBB3_4: # %entry
; CHECK-NOV-NEXT:    bge a3, a5, .LBB3_14
; CHECK-NOV-NEXT:  .LBB3_5: # %entry
; CHECK-NOV-NEXT:    bge a3, a4, .LBB3_15
; CHECK-NOV-NEXT:  .LBB3_6: # %entry
; CHECK-NOV-NEXT:    bge a3, a2, .LBB3_16
; CHECK-NOV-NEXT:  .LBB3_7: # %entry
; CHECK-NOV-NEXT:    blt a3, a1, .LBB3_9
; CHECK-NOV-NEXT:  .LBB3_8: # %entry
; CHECK-NOV-NEXT:    lui a1, 524288
; CHECK-NOV-NEXT:  .LBB3_9: # %entry
; CHECK-NOV-NEXT:    sw a1, 12(a0)
; CHECK-NOV-NEXT:    sw a2, 8(a0)
; CHECK-NOV-NEXT:    sw a4, 4(a0)
; CHECK-NOV-NEXT:    sw a5, 0(a0)
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB3_10: # %entry
; CHECK-NOV-NEXT:    mv a1, a6
; CHECK-NOV-NEXT:    fcvt.l.s a4, fa1, rtz
; CHECK-NOV-NEXT:    blt a2, a6, .LBB3_2
; CHECK-NOV-NEXT:  .LBB3_11: # %entry
; CHECK-NOV-NEXT:    mv a2, a6
; CHECK-NOV-NEXT:    fcvt.l.s a5, fa0, rtz
; CHECK-NOV-NEXT:    blt a4, a6, .LBB3_3
; CHECK-NOV-NEXT:  .LBB3_12: # %entry
; CHECK-NOV-NEXT:    mv a4, a6
; CHECK-NOV-NEXT:    blt a5, a6, .LBB3_4
; CHECK-NOV-NEXT:  .LBB3_13: # %entry
; CHECK-NOV-NEXT:    mv a5, a6
; CHECK-NOV-NEXT:    blt a3, a5, .LBB3_5
; CHECK-NOV-NEXT:  .LBB3_14: # %entry
; CHECK-NOV-NEXT:    lui a5, 524288
; CHECK-NOV-NEXT:    blt a3, a4, .LBB3_6
; CHECK-NOV-NEXT:  .LBB3_15: # %entry
; CHECK-NOV-NEXT:    lui a4, 524288
; CHECK-NOV-NEXT:    blt a3, a2, .LBB3_7
; CHECK-NOV-NEXT:  .LBB3_16: # %entry
; CHECK-NOV-NEXT:    lui a2, 524288
; CHECK-NOV-NEXT:    bge a3, a1, .LBB3_8
; CHECK-NOV-NEXT:    j .LBB3_9
;
; CHECK-V-LABEL: stest_f32i32:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-V-NEXT:    vfwcvt.rtz.x.f.v v10, v8
; CHECK-V-NEXT:    lui a0, 524288
; CHECK-V-NEXT:    addiw a1, a0, -1
; CHECK-V-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-V-NEXT:    vmin.vx v8, v10, a1
; CHECK-V-NEXT:    vmax.vx v10, v8, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %1 = icmp sgt <4 x i64> %spec.store.select, <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utest_f32i32(<4 x float> %x) {
; CHECK-NOV-LABEL: utest_f32i32:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a1, fa0, rtz
; CHECK-NOV-NEXT:    li a2, -1
; CHECK-NOV-NEXT:    srli a3, a2, 32
; CHECK-NOV-NEXT:    fcvt.lu.s a2, fa1, rtz
; CHECK-NOV-NEXT:    bgeu a1, a3, .LBB4_6
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a4, fa2, rtz
; CHECK-NOV-NEXT:    bgeu a2, a3, .LBB4_7
; CHECK-NOV-NEXT:  .LBB4_2: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a5, fa3, rtz
; CHECK-NOV-NEXT:    bgeu a4, a3, .LBB4_8
; CHECK-NOV-NEXT:  .LBB4_3: # %entry
; CHECK-NOV-NEXT:    bltu a5, a3, .LBB4_5
; CHECK-NOV-NEXT:  .LBB4_4: # %entry
; CHECK-NOV-NEXT:    mv a5, a3
; CHECK-NOV-NEXT:  .LBB4_5: # %entry
; CHECK-NOV-NEXT:    sw a5, 12(a0)
; CHECK-NOV-NEXT:    sw a4, 8(a0)
; CHECK-NOV-NEXT:    sw a2, 4(a0)
; CHECK-NOV-NEXT:    sw a1, 0(a0)
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB4_6: # %entry
; CHECK-NOV-NEXT:    mv a1, a3
; CHECK-NOV-NEXT:    fcvt.lu.s a4, fa2, rtz
; CHECK-NOV-NEXT:    bltu a2, a3, .LBB4_2
; CHECK-NOV-NEXT:  .LBB4_7: # %entry
; CHECK-NOV-NEXT:    mv a2, a3
; CHECK-NOV-NEXT:    fcvt.lu.s a5, fa3, rtz
; CHECK-NOV-NEXT:    bltu a4, a3, .LBB4_3
; CHECK-NOV-NEXT:  .LBB4_8: # %entry
; CHECK-NOV-NEXT:    mv a4, a3
; CHECK-NOV-NEXT:    bgeu a5, a3, .LBB4_4
; CHECK-NOV-NEXT:    j .LBB4_5
;
; CHECK-V-LABEL: utest_f32i32:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-V-NEXT:    vfwcvt.rtz.xu.f.v v10, v8
; CHECK-V-NEXT:    li a0, -1
; CHECK-V-NEXT:    srli a0, a0, 32
; CHECK-V-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-V-NEXT:    vminu.vx v10, v10, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptoui <4 x float> %x to <4 x i64>
  %0 = icmp ult <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f32i32(<4 x float> %x) {
; CHECK-NOV-LABEL: ustest_f32i32:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a1, fa3, rtz
; CHECK-NOV-NEXT:    li a2, -1
; CHECK-NOV-NEXT:    srli a4, a2, 32
; CHECK-NOV-NEXT:    fcvt.l.s a2, fa2, rtz
; CHECK-NOV-NEXT:    bge a1, a4, .LBB5_6
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a3, fa1, rtz
; CHECK-NOV-NEXT:    bge a2, a4, .LBB5_7
; CHECK-NOV-NEXT:  .LBB5_2: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a5, fa0, rtz
; CHECK-NOV-NEXT:    bge a3, a4, .LBB5_8
; CHECK-NOV-NEXT:  .LBB5_3: # %entry
; CHECK-NOV-NEXT:    blt a5, a4, .LBB5_5
; CHECK-NOV-NEXT:  .LBB5_4: # %entry
; CHECK-NOV-NEXT:    mv a5, a4
; CHECK-NOV-NEXT:  .LBB5_5: # %entry
; CHECK-NOV-NEXT:    sgtz a4, a5
; CHECK-NOV-NEXT:    neg a4, a4
; CHECK-NOV-NEXT:    and a4, a4, a5
; CHECK-NOV-NEXT:    sgtz a5, a3
; CHECK-NOV-NEXT:    neg a5, a5
; CHECK-NOV-NEXT:    and a3, a5, a3
; CHECK-NOV-NEXT:    sgtz a5, a2
; CHECK-NOV-NEXT:    neg a5, a5
; CHECK-NOV-NEXT:    and a2, a5, a2
; CHECK-NOV-NEXT:    sgtz a5, a1
; CHECK-NOV-NEXT:    neg a5, a5
; CHECK-NOV-NEXT:    and a1, a5, a1
; CHECK-NOV-NEXT:    sw a1, 12(a0)
; CHECK-NOV-NEXT:    sw a2, 8(a0)
; CHECK-NOV-NEXT:    sw a3, 4(a0)
; CHECK-NOV-NEXT:    sw a4, 0(a0)
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB5_6: # %entry
; CHECK-NOV-NEXT:    mv a1, a4
; CHECK-NOV-NEXT:    fcvt.l.s a3, fa1, rtz
; CHECK-NOV-NEXT:    blt a2, a4, .LBB5_2
; CHECK-NOV-NEXT:  .LBB5_7: # %entry
; CHECK-NOV-NEXT:    mv a2, a4
; CHECK-NOV-NEXT:    fcvt.l.s a5, fa0, rtz
; CHECK-NOV-NEXT:    blt a3, a4, .LBB5_3
; CHECK-NOV-NEXT:  .LBB5_8: # %entry
; CHECK-NOV-NEXT:    mv a3, a4
; CHECK-NOV-NEXT:    bge a5, a4, .LBB5_4
; CHECK-NOV-NEXT:    j .LBB5_5
;
; CHECK-V-LABEL: ustest_f32i32:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-V-NEXT:    vfwcvt.rtz.x.f.v v10, v8
; CHECK-V-NEXT:    li a0, -1
; CHECK-V-NEXT:    srli a0, a0, 32
; CHECK-V-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-V-NEXT:    vmin.vx v8, v10, a0
; CHECK-V-NEXT:    vmax.vx v10, v8, zero
; CHECK-V-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %1 = icmp sgt <4 x i64> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> zeroinitializer
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @stest_f16i32(<4 x half> %x) {
; CHECK-NOV-LABEL: stest_f16i32:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -64
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NOV-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s3, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs2, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset s2, -32
; CHECK-NOV-NEXT:    .cfi_offset s3, -40
; CHECK-NOV-NEXT:    .cfi_offset fs0, -48
; CHECK-NOV-NEXT:    .cfi_offset fs1, -56
; CHECK-NOV-NEXT:    .cfi_offset fs2, -64
; CHECK-NOV-NEXT:    lhu s1, 24(a1)
; CHECK-NOV-NEXT:    lhu s2, 0(a1)
; CHECK-NOV-NEXT:    lhu s3, 8(a1)
; CHECK-NOV-NEXT:    lhu a1, 16(a1)
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs2, fa0
; CHECK-NOV-NEXT:    mv a0, s3
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs1, fa0
; CHECK-NOV-NEXT:    mv a0, s2
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs0, fa0
; CHECK-NOV-NEXT:    fcvt.l.s s2, fs2, rtz
; CHECK-NOV-NEXT:    mv a0, s1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-NOV-NEXT:    lui a1, 524288
; CHECK-NOV-NEXT:    addiw a4, a1, -1
; CHECK-NOV-NEXT:    bge a0, a4, .LBB6_10
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a2, fs1, rtz
; CHECK-NOV-NEXT:    bge s2, a4, .LBB6_11
; CHECK-NOV-NEXT:  .LBB6_2: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a3, fs0, rtz
; CHECK-NOV-NEXT:    bge a2, a4, .LBB6_12
; CHECK-NOV-NEXT:  .LBB6_3: # %entry
; CHECK-NOV-NEXT:    bge a3, a4, .LBB6_13
; CHECK-NOV-NEXT:  .LBB6_4: # %entry
; CHECK-NOV-NEXT:    bge a1, a3, .LBB6_14
; CHECK-NOV-NEXT:  .LBB6_5: # %entry
; CHECK-NOV-NEXT:    bge a1, a2, .LBB6_15
; CHECK-NOV-NEXT:  .LBB6_6: # %entry
; CHECK-NOV-NEXT:    bge a1, s2, .LBB6_16
; CHECK-NOV-NEXT:  .LBB6_7: # %entry
; CHECK-NOV-NEXT:    blt a1, a0, .LBB6_9
; CHECK-NOV-NEXT:  .LBB6_8: # %entry
; CHECK-NOV-NEXT:    lui a0, 524288
; CHECK-NOV-NEXT:  .LBB6_9: # %entry
; CHECK-NOV-NEXT:    sw a0, 12(s0)
; CHECK-NOV-NEXT:    sw s2, 8(s0)
; CHECK-NOV-NEXT:    sw a2, 4(s0)
; CHECK-NOV-NEXT:    sw a3, 0(s0)
; CHECK-NOV-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s3, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs2, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 64
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB6_10: # %entry
; CHECK-NOV-NEXT:    mv a0, a4
; CHECK-NOV-NEXT:    fcvt.l.s a2, fs1, rtz
; CHECK-NOV-NEXT:    blt s2, a4, .LBB6_2
; CHECK-NOV-NEXT:  .LBB6_11: # %entry
; CHECK-NOV-NEXT:    mv s2, a4
; CHECK-NOV-NEXT:    fcvt.l.s a3, fs0, rtz
; CHECK-NOV-NEXT:    blt a2, a4, .LBB6_3
; CHECK-NOV-NEXT:  .LBB6_12: # %entry
; CHECK-NOV-NEXT:    mv a2, a4
; CHECK-NOV-NEXT:    blt a3, a4, .LBB6_4
; CHECK-NOV-NEXT:  .LBB6_13: # %entry
; CHECK-NOV-NEXT:    mv a3, a4
; CHECK-NOV-NEXT:    blt a1, a3, .LBB6_5
; CHECK-NOV-NEXT:  .LBB6_14: # %entry
; CHECK-NOV-NEXT:    lui a3, 524288
; CHECK-NOV-NEXT:    blt a1, a2, .LBB6_6
; CHECK-NOV-NEXT:  .LBB6_15: # %entry
; CHECK-NOV-NEXT:    lui a2, 524288
; CHECK-NOV-NEXT:    blt a1, s2, .LBB6_7
; CHECK-NOV-NEXT:  .LBB6_16: # %entry
; CHECK-NOV-NEXT:    lui s2, 524288
; CHECK-NOV-NEXT:    bge a1, a0, .LBB6_8
; CHECK-NOV-NEXT:    j .LBB6_9
;
; CHECK-V-LABEL: stest_f16i32:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -64
; CHECK-V-NEXT:    .cfi_def_cfa_offset 64
; CHECK-V-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    .cfi_offset s2, -32
; CHECK-V-NEXT:    lhu s0, 24(a0)
; CHECK-V-NEXT:    lhu s1, 16(a0)
; CHECK-V-NEXT:    lhu s2, 0(a0)
; CHECK-V-NEXT:    lhu a0, 8(a0)
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 24(sp)
; CHECK-V-NEXT:    mv a0, s2
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 0(sp)
; CHECK-V-NEXT:    mv a0, s1
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 16(sp)
; CHECK-V-NEXT:    mv a0, s0
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 8(sp)
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    mv a0, sp
; CHECK-V-NEXT:    vle64.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v10, v8, 1
; CHECK-V-NEXT:    addi a0, sp, 16
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 3, e64, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v10, v8, 2
; CHECK-V-NEXT:    addi a0, sp, 8
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 4, e64, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v10, v8, 3
; CHECK-V-NEXT:    lui a0, 524288
; CHECK-V-NEXT:    addiw a1, a0, -1
; CHECK-V-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-V-NEXT:    vmin.vx v8, v10, a1
; CHECK-V-NEXT:    vmax.vx v10, v8, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-V-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 64
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %1 = icmp sgt <4 x i64> %spec.store.select, <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utesth_f16i32(<4 x half> %x) {
; CHECK-NOV-LABEL: utesth_f16i32:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -64
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NOV-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s3, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs2, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset s2, -32
; CHECK-NOV-NEXT:    .cfi_offset s3, -40
; CHECK-NOV-NEXT:    .cfi_offset fs0, -48
; CHECK-NOV-NEXT:    .cfi_offset fs1, -56
; CHECK-NOV-NEXT:    .cfi_offset fs2, -64
; CHECK-NOV-NEXT:    lhu s1, 0(a1)
; CHECK-NOV-NEXT:    lhu s2, 24(a1)
; CHECK-NOV-NEXT:    lhu s3, 16(a1)
; CHECK-NOV-NEXT:    lhu a1, 8(a1)
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs2, fa0
; CHECK-NOV-NEXT:    mv a0, s3
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs1, fa0
; CHECK-NOV-NEXT:    mv a0, s2
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs0, fa0
; CHECK-NOV-NEXT:    fcvt.lu.s s2, fs2, rtz
; CHECK-NOV-NEXT:    mv a0, s1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-NOV-NEXT:    li a1, -1
; CHECK-NOV-NEXT:    srli a1, a1, 32
; CHECK-NOV-NEXT:    bgeu a0, a1, .LBB7_6
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a2, fs1, rtz
; CHECK-NOV-NEXT:    bgeu s2, a1, .LBB7_7
; CHECK-NOV-NEXT:  .LBB7_2: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a3, fs0, rtz
; CHECK-NOV-NEXT:    bgeu a2, a1, .LBB7_8
; CHECK-NOV-NEXT:  .LBB7_3: # %entry
; CHECK-NOV-NEXT:    bltu a3, a1, .LBB7_5
; CHECK-NOV-NEXT:  .LBB7_4: # %entry
; CHECK-NOV-NEXT:    mv a3, a1
; CHECK-NOV-NEXT:  .LBB7_5: # %entry
; CHECK-NOV-NEXT:    sw a3, 12(s0)
; CHECK-NOV-NEXT:    sw a2, 8(s0)
; CHECK-NOV-NEXT:    sw s2, 4(s0)
; CHECK-NOV-NEXT:    sw a0, 0(s0)
; CHECK-NOV-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s3, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs2, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 64
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB7_6: # %entry
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:    fcvt.lu.s a2, fs1, rtz
; CHECK-NOV-NEXT:    bltu s2, a1, .LBB7_2
; CHECK-NOV-NEXT:  .LBB7_7: # %entry
; CHECK-NOV-NEXT:    mv s2, a1
; CHECK-NOV-NEXT:    fcvt.lu.s a3, fs0, rtz
; CHECK-NOV-NEXT:    bltu a2, a1, .LBB7_3
; CHECK-NOV-NEXT:  .LBB7_8: # %entry
; CHECK-NOV-NEXT:    mv a2, a1
; CHECK-NOV-NEXT:    bgeu a3, a1, .LBB7_4
; CHECK-NOV-NEXT:    j .LBB7_5
;
; CHECK-V-LABEL: utesth_f16i32:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -64
; CHECK-V-NEXT:    .cfi_def_cfa_offset 64
; CHECK-V-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    .cfi_offset s2, -32
; CHECK-V-NEXT:    lhu s0, 24(a0)
; CHECK-V-NEXT:    lhu s1, 16(a0)
; CHECK-V-NEXT:    lhu s2, 0(a0)
; CHECK-V-NEXT:    lhu a0, 8(a0)
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 24(sp)
; CHECK-V-NEXT:    mv a0, s2
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 0(sp)
; CHECK-V-NEXT:    mv a0, s1
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 16(sp)
; CHECK-V-NEXT:    mv a0, s0
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 8(sp)
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    mv a0, sp
; CHECK-V-NEXT:    vle64.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v10, v8, 1
; CHECK-V-NEXT:    addi a0, sp, 16
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 3, e64, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v10, v8, 2
; CHECK-V-NEXT:    addi a0, sp, 8
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 4, e64, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v10, v8, 3
; CHECK-V-NEXT:    li a0, -1
; CHECK-V-NEXT:    srli a0, a0, 32
; CHECK-V-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-V-NEXT:    vminu.vx v10, v10, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-V-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 64
; CHECK-V-NEXT:    ret
entry:
  %conv = fptoui <4 x half> %x to <4 x i64>
  %0 = icmp ult <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f16i32(<4 x half> %x) {
; CHECK-NOV-LABEL: ustest_f16i32:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -64
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NOV-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s3, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs2, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset s2, -32
; CHECK-NOV-NEXT:    .cfi_offset s3, -40
; CHECK-NOV-NEXT:    .cfi_offset fs0, -48
; CHECK-NOV-NEXT:    .cfi_offset fs1, -56
; CHECK-NOV-NEXT:    .cfi_offset fs2, -64
; CHECK-NOV-NEXT:    lhu s1, 24(a1)
; CHECK-NOV-NEXT:    lhu s2, 0(a1)
; CHECK-NOV-NEXT:    lhu s3, 8(a1)
; CHECK-NOV-NEXT:    lhu a1, 16(a1)
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs2, fa0
; CHECK-NOV-NEXT:    mv a0, s3
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs1, fa0
; CHECK-NOV-NEXT:    mv a0, s2
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs0, fa0
; CHECK-NOV-NEXT:    fcvt.l.s s2, fs2, rtz
; CHECK-NOV-NEXT:    mv a0, s1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-NOV-NEXT:    li a1, -1
; CHECK-NOV-NEXT:    srli a2, a1, 32
; CHECK-NOV-NEXT:    bge a0, a2, .LBB8_6
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a1, fs1, rtz
; CHECK-NOV-NEXT:    bge s2, a2, .LBB8_7
; CHECK-NOV-NEXT:  .LBB8_2: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a3, fs0, rtz
; CHECK-NOV-NEXT:    bge a1, a2, .LBB8_8
; CHECK-NOV-NEXT:  .LBB8_3: # %entry
; CHECK-NOV-NEXT:    blt a3, a2, .LBB8_5
; CHECK-NOV-NEXT:  .LBB8_4: # %entry
; CHECK-NOV-NEXT:    mv a3, a2
; CHECK-NOV-NEXT:  .LBB8_5: # %entry
; CHECK-NOV-NEXT:    sgtz a2, a3
; CHECK-NOV-NEXT:    neg a2, a2
; CHECK-NOV-NEXT:    and a2, a2, a3
; CHECK-NOV-NEXT:    sgtz a3, a1
; CHECK-NOV-NEXT:    neg a3, a3
; CHECK-NOV-NEXT:    and a1, a3, a1
; CHECK-NOV-NEXT:    sgtz a3, s2
; CHECK-NOV-NEXT:    neg a3, a3
; CHECK-NOV-NEXT:    and a3, a3, s2
; CHECK-NOV-NEXT:    sgtz a4, a0
; CHECK-NOV-NEXT:    neg a4, a4
; CHECK-NOV-NEXT:    and a0, a4, a0
; CHECK-NOV-NEXT:    sw a0, 12(s0)
; CHECK-NOV-NEXT:    sw a3, 8(s0)
; CHECK-NOV-NEXT:    sw a1, 4(s0)
; CHECK-NOV-NEXT:    sw a2, 0(s0)
; CHECK-NOV-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s3, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs2, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 64
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB8_6: # %entry
; CHECK-NOV-NEXT:    mv a0, a2
; CHECK-NOV-NEXT:    fcvt.l.s a1, fs1, rtz
; CHECK-NOV-NEXT:    blt s2, a2, .LBB8_2
; CHECK-NOV-NEXT:  .LBB8_7: # %entry
; CHECK-NOV-NEXT:    mv s2, a2
; CHECK-NOV-NEXT:    fcvt.l.s a3, fs0, rtz
; CHECK-NOV-NEXT:    blt a1, a2, .LBB8_3
; CHECK-NOV-NEXT:  .LBB8_8: # %entry
; CHECK-NOV-NEXT:    mv a1, a2
; CHECK-NOV-NEXT:    bge a3, a2, .LBB8_4
; CHECK-NOV-NEXT:    j .LBB8_5
;
; CHECK-V-LABEL: ustest_f16i32:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -64
; CHECK-V-NEXT:    .cfi_def_cfa_offset 64
; CHECK-V-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    .cfi_offset s2, -32
; CHECK-V-NEXT:    lhu s0, 24(a0)
; CHECK-V-NEXT:    lhu s1, 16(a0)
; CHECK-V-NEXT:    lhu s2, 0(a0)
; CHECK-V-NEXT:    lhu a0, 8(a0)
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 24(sp)
; CHECK-V-NEXT:    mv a0, s2
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 0(sp)
; CHECK-V-NEXT:    mv a0, s1
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 16(sp)
; CHECK-V-NEXT:    mv a0, s0
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 8(sp)
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    mv a0, sp
; CHECK-V-NEXT:    vle64.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v10, v8, 1
; CHECK-V-NEXT:    addi a0, sp, 16
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 3, e64, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v10, v8, 2
; CHECK-V-NEXT:    addi a0, sp, 8
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 4, e64, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v10, v8, 3
; CHECK-V-NEXT:    li a0, -1
; CHECK-V-NEXT:    srli a0, a0, 32
; CHECK-V-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-V-NEXT:    vmin.vx v8, v10, a0
; CHECK-V-NEXT:    vmax.vx v10, v8, zero
; CHECK-V-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-V-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 64
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %1 = icmp sgt <4 x i64> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> zeroinitializer
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

; i16 saturate

define <2 x i16> @stest_f64i16(<2 x double> %x) {
; CHECK-NOV-LABEL: stest_f64i16:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.w.d a1, fa1, rtz
; CHECK-NOV-NEXT:    lui a0, 8
; CHECK-NOV-NEXT:    addiw a2, a0, -1
; CHECK-NOV-NEXT:    fcvt.w.d a0, fa0, rtz
; CHECK-NOV-NEXT:    bge a1, a2, .LBB9_5
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    bge a0, a2, .LBB9_6
; CHECK-NOV-NEXT:  .LBB9_2: # %entry
; CHECK-NOV-NEXT:    lui a2, 1048568
; CHECK-NOV-NEXT:    bge a2, a0, .LBB9_7
; CHECK-NOV-NEXT:  .LBB9_3: # %entry
; CHECK-NOV-NEXT:    bge a2, a1, .LBB9_8
; CHECK-NOV-NEXT:  .LBB9_4: # %entry
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB9_5: # %entry
; CHECK-NOV-NEXT:    mv a1, a2
; CHECK-NOV-NEXT:    blt a0, a2, .LBB9_2
; CHECK-NOV-NEXT:  .LBB9_6: # %entry
; CHECK-NOV-NEXT:    mv a0, a2
; CHECK-NOV-NEXT:    lui a2, 1048568
; CHECK-NOV-NEXT:    blt a2, a0, .LBB9_3
; CHECK-NOV-NEXT:  .LBB9_7: # %entry
; CHECK-NOV-NEXT:    lui a0, 1048568
; CHECK-NOV-NEXT:    blt a2, a1, .LBB9_4
; CHECK-NOV-NEXT:  .LBB9_8: # %entry
; CHECK-NOV-NEXT:    lui a1, 1048568
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: stest_f64i16:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-V-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-V-NEXT:    lui a0, 8
; CHECK-V-NEXT:    addiw a0, a0, -1
; CHECK-V-NEXT:    vmin.vx v8, v9, a0
; CHECK-V-NEXT:    lui a0, 1048568
; CHECK-V-NEXT:    vmax.vx v8, v8, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %0 = icmp slt <2 x i32> %conv, <i32 32767, i32 32767>
  %spec.store.select = select <2 x i1> %0, <2 x i32> %conv, <2 x i32> <i32 32767, i32 32767>
  %1 = icmp sgt <2 x i32> %spec.store.select, <i32 -32768, i32 -32768>
  %spec.store.select7 = select <2 x i1> %1, <2 x i32> %spec.store.select, <2 x i32> <i32 -32768, i32 -32768>
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @utest_f64i16(<2 x double> %x) {
; CHECK-NOV-LABEL: utest_f64i16:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.wu.d a0, fa0, rtz
; CHECK-NOV-NEXT:    lui a1, 16
; CHECK-NOV-NEXT:    addiw a2, a1, -1
; CHECK-NOV-NEXT:    fcvt.wu.d a1, fa1, rtz
; CHECK-NOV-NEXT:    bgeu a0, a2, .LBB10_3
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    bgeu a1, a2, .LBB10_4
; CHECK-NOV-NEXT:  .LBB10_2: # %entry
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB10_3: # %entry
; CHECK-NOV-NEXT:    mv a0, a2
; CHECK-NOV-NEXT:    bltu a1, a2, .LBB10_2
; CHECK-NOV-NEXT:  .LBB10_4: # %entry
; CHECK-NOV-NEXT:    mv a1, a2
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: utest_f64i16:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-V-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-V-NEXT:    lui a0, 16
; CHECK-V-NEXT:    addiw a0, a0, -1
; CHECK-V-NEXT:    vminu.vx v8, v9, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptoui <2 x double> %x to <2 x i32>
  %0 = icmp ult <2 x i32> %conv, <i32 65535, i32 65535>
  %spec.store.select = select <2 x i1> %0, <2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>
  %conv6 = trunc <2 x i32> %spec.store.select to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @ustest_f64i16(<2 x double> %x) {
; CHECK-NOV-LABEL: ustest_f64i16:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.w.d a1, fa1, rtz
; CHECK-NOV-NEXT:    lui a0, 16
; CHECK-NOV-NEXT:    addiw a2, a0, -1
; CHECK-NOV-NEXT:    fcvt.w.d a0, fa0, rtz
; CHECK-NOV-NEXT:    blt a1, a2, .LBB11_2
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    mv a1, a2
; CHECK-NOV-NEXT:  .LBB11_2: # %entry
; CHECK-NOV-NEXT:    blt a0, a2, .LBB11_4
; CHECK-NOV-NEXT:  # %bb.3: # %entry
; CHECK-NOV-NEXT:    mv a0, a2
; CHECK-NOV-NEXT:  .LBB11_4: # %entry
; CHECK-NOV-NEXT:    sgtz a2, a0
; CHECK-NOV-NEXT:    neg a2, a2
; CHECK-NOV-NEXT:    and a0, a2, a0
; CHECK-NOV-NEXT:    sgtz a2, a1
; CHECK-NOV-NEXT:    neg a2, a2
; CHECK-NOV-NEXT:    and a1, a2, a1
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: ustest_f64i16:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-V-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-V-NEXT:    lui a0, 16
; CHECK-V-NEXT:    addiw a0, a0, -1
; CHECK-V-NEXT:    vmin.vx v8, v9, a0
; CHECK-V-NEXT:    vmax.vx v8, v8, zero
; CHECK-V-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %0 = icmp slt <2 x i32> %conv, <i32 65535, i32 65535>
  %spec.store.select = select <2 x i1> %0, <2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>
  %1 = icmp sgt <2 x i32> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i32> %spec.store.select, <2 x i32> zeroinitializer
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <4 x i16> @stest_f32i16(<4 x float> %x) {
; CHECK-NOV-LABEL: stest_f32i16:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.w.s a1, fa3, rtz
; CHECK-NOV-NEXT:    lui a2, 8
; CHECK-NOV-NEXT:    addiw a5, a2, -1
; CHECK-NOV-NEXT:    fcvt.w.s a2, fa2, rtz
; CHECK-NOV-NEXT:    bge a1, a5, .LBB12_10
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.w.s a3, fa1, rtz
; CHECK-NOV-NEXT:    bge a2, a5, .LBB12_11
; CHECK-NOV-NEXT:  .LBB12_2: # %entry
; CHECK-NOV-NEXT:    fcvt.w.s a4, fa0, rtz
; CHECK-NOV-NEXT:    bge a3, a5, .LBB12_12
; CHECK-NOV-NEXT:  .LBB12_3: # %entry
; CHECK-NOV-NEXT:    bge a4, a5, .LBB12_13
; CHECK-NOV-NEXT:  .LBB12_4: # %entry
; CHECK-NOV-NEXT:    lui a5, 1048568
; CHECK-NOV-NEXT:    bge a5, a4, .LBB12_14
; CHECK-NOV-NEXT:  .LBB12_5: # %entry
; CHECK-NOV-NEXT:    bge a5, a3, .LBB12_15
; CHECK-NOV-NEXT:  .LBB12_6: # %entry
; CHECK-NOV-NEXT:    bge a5, a2, .LBB12_16
; CHECK-NOV-NEXT:  .LBB12_7: # %entry
; CHECK-NOV-NEXT:    blt a5, a1, .LBB12_9
; CHECK-NOV-NEXT:  .LBB12_8: # %entry
; CHECK-NOV-NEXT:    lui a1, 1048568
; CHECK-NOV-NEXT:  .LBB12_9: # %entry
; CHECK-NOV-NEXT:    sh a1, 6(a0)
; CHECK-NOV-NEXT:    sh a2, 4(a0)
; CHECK-NOV-NEXT:    sh a3, 2(a0)
; CHECK-NOV-NEXT:    sh a4, 0(a0)
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB12_10: # %entry
; CHECK-NOV-NEXT:    mv a1, a5
; CHECK-NOV-NEXT:    fcvt.w.s a3, fa1, rtz
; CHECK-NOV-NEXT:    blt a2, a5, .LBB12_2
; CHECK-NOV-NEXT:  .LBB12_11: # %entry
; CHECK-NOV-NEXT:    mv a2, a5
; CHECK-NOV-NEXT:    fcvt.w.s a4, fa0, rtz
; CHECK-NOV-NEXT:    blt a3, a5, .LBB12_3
; CHECK-NOV-NEXT:  .LBB12_12: # %entry
; CHECK-NOV-NEXT:    mv a3, a5
; CHECK-NOV-NEXT:    blt a4, a5, .LBB12_4
; CHECK-NOV-NEXT:  .LBB12_13: # %entry
; CHECK-NOV-NEXT:    mv a4, a5
; CHECK-NOV-NEXT:    lui a5, 1048568
; CHECK-NOV-NEXT:    blt a5, a4, .LBB12_5
; CHECK-NOV-NEXT:  .LBB12_14: # %entry
; CHECK-NOV-NEXT:    lui a4, 1048568
; CHECK-NOV-NEXT:    blt a5, a3, .LBB12_6
; CHECK-NOV-NEXT:  .LBB12_15: # %entry
; CHECK-NOV-NEXT:    lui a3, 1048568
; CHECK-NOV-NEXT:    blt a5, a2, .LBB12_7
; CHECK-NOV-NEXT:  .LBB12_16: # %entry
; CHECK-NOV-NEXT:    lui a2, 1048568
; CHECK-NOV-NEXT:    bge a5, a1, .LBB12_8
; CHECK-NOV-NEXT:    j .LBB12_9
;
; CHECK-V-LABEL: stest_f32i16:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-V-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-V-NEXT:    lui a0, 8
; CHECK-V-NEXT:    addiw a0, a0, -1
; CHECK-V-NEXT:    vmin.vx v8, v8, a0
; CHECK-V-NEXT:    lui a0, 1048568
; CHECK-V-NEXT:    vmax.vx v8, v8, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %0 = icmp slt <4 x i32> %conv, <i32 32767, i32 32767, i32 32767, i32 32767>
  %spec.store.select = select <4 x i1> %0, <4 x i32> %conv, <4 x i32> <i32 32767, i32 32767, i32 32767, i32 32767>
  %1 = icmp sgt <4 x i32> %spec.store.select, <i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %spec.store.select7 = select <4 x i1> %1, <4 x i32> %spec.store.select, <4 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @utest_f32i16(<4 x float> %x) {
; CHECK-NOV-LABEL: utest_f32i16:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.wu.s a1, fa0, rtz
; CHECK-NOV-NEXT:    lui a2, 16
; CHECK-NOV-NEXT:    addiw a3, a2, -1
; CHECK-NOV-NEXT:    fcvt.wu.s a2, fa1, rtz
; CHECK-NOV-NEXT:    bgeu a1, a3, .LBB13_6
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.wu.s a4, fa2, rtz
; CHECK-NOV-NEXT:    bgeu a2, a3, .LBB13_7
; CHECK-NOV-NEXT:  .LBB13_2: # %entry
; CHECK-NOV-NEXT:    fcvt.wu.s a5, fa3, rtz
; CHECK-NOV-NEXT:    bgeu a4, a3, .LBB13_8
; CHECK-NOV-NEXT:  .LBB13_3: # %entry
; CHECK-NOV-NEXT:    bltu a5, a3, .LBB13_5
; CHECK-NOV-NEXT:  .LBB13_4: # %entry
; CHECK-NOV-NEXT:    mv a5, a3
; CHECK-NOV-NEXT:  .LBB13_5: # %entry
; CHECK-NOV-NEXT:    sh a5, 6(a0)
; CHECK-NOV-NEXT:    sh a4, 4(a0)
; CHECK-NOV-NEXT:    sh a2, 2(a0)
; CHECK-NOV-NEXT:    sh a1, 0(a0)
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB13_6: # %entry
; CHECK-NOV-NEXT:    mv a1, a3
; CHECK-NOV-NEXT:    fcvt.wu.s a4, fa2, rtz
; CHECK-NOV-NEXT:    bltu a2, a3, .LBB13_2
; CHECK-NOV-NEXT:  .LBB13_7: # %entry
; CHECK-NOV-NEXT:    mv a2, a3
; CHECK-NOV-NEXT:    fcvt.wu.s a5, fa3, rtz
; CHECK-NOV-NEXT:    bltu a4, a3, .LBB13_3
; CHECK-NOV-NEXT:  .LBB13_8: # %entry
; CHECK-NOV-NEXT:    mv a4, a3
; CHECK-NOV-NEXT:    bgeu a5, a3, .LBB13_4
; CHECK-NOV-NEXT:    j .LBB13_5
;
; CHECK-V-LABEL: utest_f32i16:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-V-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-V-NEXT:    lui a0, 16
; CHECK-V-NEXT:    addiw a0, a0, -1
; CHECK-V-NEXT:    vminu.vx v8, v8, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptoui <4 x float> %x to <4 x i32>
  %0 = icmp ult <4 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <4 x i1> %0, <4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>
  %conv6 = trunc <4 x i32> %spec.store.select to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @ustest_f32i16(<4 x float> %x) {
; CHECK-NOV-LABEL: ustest_f32i16:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.w.s a1, fa3, rtz
; CHECK-NOV-NEXT:    lui a2, 16
; CHECK-NOV-NEXT:    addiw a4, a2, -1
; CHECK-NOV-NEXT:    fcvt.w.s a2, fa2, rtz
; CHECK-NOV-NEXT:    bge a1, a4, .LBB14_6
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.w.s a3, fa1, rtz
; CHECK-NOV-NEXT:    bge a2, a4, .LBB14_7
; CHECK-NOV-NEXT:  .LBB14_2: # %entry
; CHECK-NOV-NEXT:    fcvt.w.s a5, fa0, rtz
; CHECK-NOV-NEXT:    bge a3, a4, .LBB14_8
; CHECK-NOV-NEXT:  .LBB14_3: # %entry
; CHECK-NOV-NEXT:    blt a5, a4, .LBB14_5
; CHECK-NOV-NEXT:  .LBB14_4: # %entry
; CHECK-NOV-NEXT:    mv a5, a4
; CHECK-NOV-NEXT:  .LBB14_5: # %entry
; CHECK-NOV-NEXT:    sgtz a4, a5
; CHECK-NOV-NEXT:    neg a4, a4
; CHECK-NOV-NEXT:    and a4, a4, a5
; CHECK-NOV-NEXT:    sgtz a5, a3
; CHECK-NOV-NEXT:    neg a5, a5
; CHECK-NOV-NEXT:    and a3, a5, a3
; CHECK-NOV-NEXT:    sgtz a5, a2
; CHECK-NOV-NEXT:    neg a5, a5
; CHECK-NOV-NEXT:    and a2, a5, a2
; CHECK-NOV-NEXT:    sgtz a5, a1
; CHECK-NOV-NEXT:    neg a5, a5
; CHECK-NOV-NEXT:    and a1, a5, a1
; CHECK-NOV-NEXT:    sh a1, 6(a0)
; CHECK-NOV-NEXT:    sh a2, 4(a0)
; CHECK-NOV-NEXT:    sh a3, 2(a0)
; CHECK-NOV-NEXT:    sh a4, 0(a0)
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB14_6: # %entry
; CHECK-NOV-NEXT:    mv a1, a4
; CHECK-NOV-NEXT:    fcvt.w.s a3, fa1, rtz
; CHECK-NOV-NEXT:    blt a2, a4, .LBB14_2
; CHECK-NOV-NEXT:  .LBB14_7: # %entry
; CHECK-NOV-NEXT:    mv a2, a4
; CHECK-NOV-NEXT:    fcvt.w.s a5, fa0, rtz
; CHECK-NOV-NEXT:    blt a3, a4, .LBB14_3
; CHECK-NOV-NEXT:  .LBB14_8: # %entry
; CHECK-NOV-NEXT:    mv a3, a4
; CHECK-NOV-NEXT:    bge a5, a4, .LBB14_4
; CHECK-NOV-NEXT:    j .LBB14_5
;
; CHECK-V-LABEL: ustest_f32i16:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-V-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-V-NEXT:    lui a0, 16
; CHECK-V-NEXT:    addiw a0, a0, -1
; CHECK-V-NEXT:    vmin.vx v8, v8, a0
; CHECK-V-NEXT:    vmax.vx v8, v8, zero
; CHECK-V-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %0 = icmp slt <4 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <4 x i1> %0, <4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>
  %1 = icmp sgt <4 x i32> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <4 x i1> %1, <4 x i32> %spec.store.select, <4 x i32> zeroinitializer
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <8 x i16> @stest_f16i16(<8 x half> %x) {
; CHECK-NOV-LABEL: stest_f16i16:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -128
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 128
; CHECK-NOV-NEXT:    sd ra, 120(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 112(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 104(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s2, 96(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s3, 88(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s4, 80(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s5, 72(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s6, 64(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s7, 56(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 48(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs1, 40(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs2, 32(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs3, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs4, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs5, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs6, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset s2, -32
; CHECK-NOV-NEXT:    .cfi_offset s3, -40
; CHECK-NOV-NEXT:    .cfi_offset s4, -48
; CHECK-NOV-NEXT:    .cfi_offset s5, -56
; CHECK-NOV-NEXT:    .cfi_offset s6, -64
; CHECK-NOV-NEXT:    .cfi_offset s7, -72
; CHECK-NOV-NEXT:    .cfi_offset fs0, -80
; CHECK-NOV-NEXT:    .cfi_offset fs1, -88
; CHECK-NOV-NEXT:    .cfi_offset fs2, -96
; CHECK-NOV-NEXT:    .cfi_offset fs3, -104
; CHECK-NOV-NEXT:    .cfi_offset fs4, -112
; CHECK-NOV-NEXT:    .cfi_offset fs5, -120
; CHECK-NOV-NEXT:    .cfi_offset fs6, -128
; CHECK-NOV-NEXT:    lhu s1, 56(a1)
; CHECK-NOV-NEXT:    lhu s2, 0(a1)
; CHECK-NOV-NEXT:    lhu s3, 8(a1)
; CHECK-NOV-NEXT:    lhu s4, 16(a1)
; CHECK-NOV-NEXT:    lhu s5, 24(a1)
; CHECK-NOV-NEXT:    lhu s6, 32(a1)
; CHECK-NOV-NEXT:    lhu s7, 40(a1)
; CHECK-NOV-NEXT:    lhu a1, 48(a1)
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs6, fa0
; CHECK-NOV-NEXT:    mv a0, s7
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs5, fa0
; CHECK-NOV-NEXT:    mv a0, s6
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs4, fa0
; CHECK-NOV-NEXT:    mv a0, s5
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs3, fa0
; CHECK-NOV-NEXT:    mv a0, s4
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs2, fa0
; CHECK-NOV-NEXT:    mv a0, s3
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs1, fa0
; CHECK-NOV-NEXT:    mv a0, s2
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs0, fa0
; CHECK-NOV-NEXT:    fcvt.l.s s2, fs6, rtz
; CHECK-NOV-NEXT:    mv a0, s1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-NOV-NEXT:    lui a1, 8
; CHECK-NOV-NEXT:    addiw a7, a1, -1
; CHECK-NOV-NEXT:    bge a0, a7, .LBB15_18
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a1, fs5, rtz
; CHECK-NOV-NEXT:    bge s2, a7, .LBB15_19
; CHECK-NOV-NEXT:  .LBB15_2: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a2, fs4, rtz
; CHECK-NOV-NEXT:    bge a1, a7, .LBB15_20
; CHECK-NOV-NEXT:  .LBB15_3: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a3, fs3, rtz
; CHECK-NOV-NEXT:    bge a2, a7, .LBB15_21
; CHECK-NOV-NEXT:  .LBB15_4: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a4, fs2, rtz
; CHECK-NOV-NEXT:    bge a3, a7, .LBB15_22
; CHECK-NOV-NEXT:  .LBB15_5: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a5, fs1, rtz
; CHECK-NOV-NEXT:    bge a4, a7, .LBB15_23
; CHECK-NOV-NEXT:  .LBB15_6: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a6, fs0, rtz
; CHECK-NOV-NEXT:    bge a5, a7, .LBB15_24
; CHECK-NOV-NEXT:  .LBB15_7: # %entry
; CHECK-NOV-NEXT:    bge a6, a7, .LBB15_25
; CHECK-NOV-NEXT:  .LBB15_8: # %entry
; CHECK-NOV-NEXT:    lui a7, 1048568
; CHECK-NOV-NEXT:    bge a7, a6, .LBB15_26
; CHECK-NOV-NEXT:  .LBB15_9: # %entry
; CHECK-NOV-NEXT:    bge a7, a5, .LBB15_27
; CHECK-NOV-NEXT:  .LBB15_10: # %entry
; CHECK-NOV-NEXT:    bge a7, a4, .LBB15_28
; CHECK-NOV-NEXT:  .LBB15_11: # %entry
; CHECK-NOV-NEXT:    bge a7, a3, .LBB15_29
; CHECK-NOV-NEXT:  .LBB15_12: # %entry
; CHECK-NOV-NEXT:    bge a7, a2, .LBB15_30
; CHECK-NOV-NEXT:  .LBB15_13: # %entry
; CHECK-NOV-NEXT:    bge a7, a1, .LBB15_31
; CHECK-NOV-NEXT:  .LBB15_14: # %entry
; CHECK-NOV-NEXT:    bge a7, s2, .LBB15_32
; CHECK-NOV-NEXT:  .LBB15_15: # %entry
; CHECK-NOV-NEXT:    blt a7, a0, .LBB15_17
; CHECK-NOV-NEXT:  .LBB15_16: # %entry
; CHECK-NOV-NEXT:    lui a0, 1048568
; CHECK-NOV-NEXT:  .LBB15_17: # %entry
; CHECK-NOV-NEXT:    sh a0, 14(s0)
; CHECK-NOV-NEXT:    sh s2, 12(s0)
; CHECK-NOV-NEXT:    sh a1, 10(s0)
; CHECK-NOV-NEXT:    sh a2, 8(s0)
; CHECK-NOV-NEXT:    sh a3, 6(s0)
; CHECK-NOV-NEXT:    sh a4, 4(s0)
; CHECK-NOV-NEXT:    sh a5, 2(s0)
; CHECK-NOV-NEXT:    sh a6, 0(s0)
; CHECK-NOV-NEXT:    ld ra, 120(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 112(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 104(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s2, 96(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s3, 88(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s4, 80(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s5, 72(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s6, 64(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s7, 56(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 48(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs1, 40(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs2, 32(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs3, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs4, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs5, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs6, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 128
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB15_18: # %entry
; CHECK-NOV-NEXT:    mv a0, a7
; CHECK-NOV-NEXT:    fcvt.l.s a1, fs5, rtz
; CHECK-NOV-NEXT:    blt s2, a7, .LBB15_2
; CHECK-NOV-NEXT:  .LBB15_19: # %entry
; CHECK-NOV-NEXT:    mv s2, a7
; CHECK-NOV-NEXT:    fcvt.l.s a2, fs4, rtz
; CHECK-NOV-NEXT:    blt a1, a7, .LBB15_3
; CHECK-NOV-NEXT:  .LBB15_20: # %entry
; CHECK-NOV-NEXT:    mv a1, a7
; CHECK-NOV-NEXT:    fcvt.l.s a3, fs3, rtz
; CHECK-NOV-NEXT:    blt a2, a7, .LBB15_4
; CHECK-NOV-NEXT:  .LBB15_21: # %entry
; CHECK-NOV-NEXT:    mv a2, a7
; CHECK-NOV-NEXT:    fcvt.l.s a4, fs2, rtz
; CHECK-NOV-NEXT:    blt a3, a7, .LBB15_5
; CHECK-NOV-NEXT:  .LBB15_22: # %entry
; CHECK-NOV-NEXT:    mv a3, a7
; CHECK-NOV-NEXT:    fcvt.l.s a5, fs1, rtz
; CHECK-NOV-NEXT:    blt a4, a7, .LBB15_6
; CHECK-NOV-NEXT:  .LBB15_23: # %entry
; CHECK-NOV-NEXT:    mv a4, a7
; CHECK-NOV-NEXT:    fcvt.l.s a6, fs0, rtz
; CHECK-NOV-NEXT:    blt a5, a7, .LBB15_7
; CHECK-NOV-NEXT:  .LBB15_24: # %entry
; CHECK-NOV-NEXT:    mv a5, a7
; CHECK-NOV-NEXT:    blt a6, a7, .LBB15_8
; CHECK-NOV-NEXT:  .LBB15_25: # %entry
; CHECK-NOV-NEXT:    mv a6, a7
; CHECK-NOV-NEXT:    lui a7, 1048568
; CHECK-NOV-NEXT:    blt a7, a6, .LBB15_9
; CHECK-NOV-NEXT:  .LBB15_26: # %entry
; CHECK-NOV-NEXT:    lui a6, 1048568
; CHECK-NOV-NEXT:    blt a7, a5, .LBB15_10
; CHECK-NOV-NEXT:  .LBB15_27: # %entry
; CHECK-NOV-NEXT:    lui a5, 1048568
; CHECK-NOV-NEXT:    blt a7, a4, .LBB15_11
; CHECK-NOV-NEXT:  .LBB15_28: # %entry
; CHECK-NOV-NEXT:    lui a4, 1048568
; CHECK-NOV-NEXT:    blt a7, a3, .LBB15_12
; CHECK-NOV-NEXT:  .LBB15_29: # %entry
; CHECK-NOV-NEXT:    lui a3, 1048568
; CHECK-NOV-NEXT:    blt a7, a2, .LBB15_13
; CHECK-NOV-NEXT:  .LBB15_30: # %entry
; CHECK-NOV-NEXT:    lui a2, 1048568
; CHECK-NOV-NEXT:    blt a7, a1, .LBB15_14
; CHECK-NOV-NEXT:  .LBB15_31: # %entry
; CHECK-NOV-NEXT:    lui a1, 1048568
; CHECK-NOV-NEXT:    blt a7, s2, .LBB15_15
; CHECK-NOV-NEXT:  .LBB15_32: # %entry
; CHECK-NOV-NEXT:    lui s2, 1048568
; CHECK-NOV-NEXT:    bge a7, a0, .LBB15_16
; CHECK-NOV-NEXT:    j .LBB15_17
;
; CHECK-V-LABEL: stest_f16i16:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -96
; CHECK-V-NEXT:    .cfi_def_cfa_offset 96
; CHECK-V-NEXT:    sd ra, 88(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 80(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 72(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s2, 64(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s3, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s4, 48(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s5, 40(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s6, 32(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    .cfi_offset s2, -32
; CHECK-V-NEXT:    .cfi_offset s3, -40
; CHECK-V-NEXT:    .cfi_offset s4, -48
; CHECK-V-NEXT:    .cfi_offset s5, -56
; CHECK-V-NEXT:    .cfi_offset s6, -64
; CHECK-V-NEXT:    lhu s0, 56(a0)
; CHECK-V-NEXT:    lhu s1, 48(a0)
; CHECK-V-NEXT:    lhu s2, 40(a0)
; CHECK-V-NEXT:    lhu s3, 32(a0)
; CHECK-V-NEXT:    lhu s4, 24(a0)
; CHECK-V-NEXT:    lhu s5, 16(a0)
; CHECK-V-NEXT:    lhu s6, 0(a0)
; CHECK-V-NEXT:    lhu a0, 8(a0)
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 28(sp)
; CHECK-V-NEXT:    mv a0, s6
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 0(sp)
; CHECK-V-NEXT:    mv a0, s5
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 24(sp)
; CHECK-V-NEXT:    mv a0, s4
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 20(sp)
; CHECK-V-NEXT:    mv a0, s3
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 16(sp)
; CHECK-V-NEXT:    mv a0, s2
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 12(sp)
; CHECK-V-NEXT:    mv a0, s1
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 8(sp)
; CHECK-V-NEXT:    mv a0, s0
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 4(sp)
; CHECK-V-NEXT:    addi a0, sp, 28
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    mv a0, sp
; CHECK-V-NEXT:    vle32.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 1
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 3, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 2
; CHECK-V-NEXT:    addi a0, sp, 20
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 4, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 3
; CHECK-V-NEXT:    addi a0, sp, 16
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 5, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 4
; CHECK-V-NEXT:    addi a0, sp, 12
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 6, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 5
; CHECK-V-NEXT:    addi a0, sp, 8
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 7, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 6
; CHECK-V-NEXT:    addi a0, sp, 4
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 8, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 7
; CHECK-V-NEXT:    lui a0, 8
; CHECK-V-NEXT:    addiw a0, a0, -1
; CHECK-V-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-V-NEXT:    vmin.vx v8, v8, a0
; CHECK-V-NEXT:    lui a0, 1048568
; CHECK-V-NEXT:    vmax.vx v10, v8, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-V-NEXT:    ld ra, 88(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 80(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 72(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s2, 64(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s3, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s4, 48(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s5, 40(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s6, 32(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 96
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %0 = icmp slt <8 x i32> %conv, <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>
  %spec.store.select = select <8 x i1> %0, <8 x i32> %conv, <8 x i32> <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>
  %1 = icmp sgt <8 x i32> %spec.store.select, <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %spec.store.select7 = select <8 x i1> %1, <8 x i32> %spec.store.select, <8 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @utesth_f16i16(<8 x half> %x) {
; CHECK-NOV-LABEL: utesth_f16i16:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -128
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 128
; CHECK-NOV-NEXT:    sd ra, 120(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 112(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 104(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s2, 96(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s3, 88(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s4, 80(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s5, 72(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s6, 64(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s7, 56(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 48(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs1, 40(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs2, 32(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs3, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs4, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs5, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs6, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset s2, -32
; CHECK-NOV-NEXT:    .cfi_offset s3, -40
; CHECK-NOV-NEXT:    .cfi_offset s4, -48
; CHECK-NOV-NEXT:    .cfi_offset s5, -56
; CHECK-NOV-NEXT:    .cfi_offset s6, -64
; CHECK-NOV-NEXT:    .cfi_offset s7, -72
; CHECK-NOV-NEXT:    .cfi_offset fs0, -80
; CHECK-NOV-NEXT:    .cfi_offset fs1, -88
; CHECK-NOV-NEXT:    .cfi_offset fs2, -96
; CHECK-NOV-NEXT:    .cfi_offset fs3, -104
; CHECK-NOV-NEXT:    .cfi_offset fs4, -112
; CHECK-NOV-NEXT:    .cfi_offset fs5, -120
; CHECK-NOV-NEXT:    .cfi_offset fs6, -128
; CHECK-NOV-NEXT:    lhu s1, 0(a1)
; CHECK-NOV-NEXT:    lhu s2, 56(a1)
; CHECK-NOV-NEXT:    lhu s3, 48(a1)
; CHECK-NOV-NEXT:    lhu s4, 40(a1)
; CHECK-NOV-NEXT:    lhu s5, 32(a1)
; CHECK-NOV-NEXT:    lhu s6, 24(a1)
; CHECK-NOV-NEXT:    lhu s7, 16(a1)
; CHECK-NOV-NEXT:    lhu a1, 8(a1)
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs6, fa0
; CHECK-NOV-NEXT:    mv a0, s7
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs5, fa0
; CHECK-NOV-NEXT:    mv a0, s6
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs4, fa0
; CHECK-NOV-NEXT:    mv a0, s5
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs3, fa0
; CHECK-NOV-NEXT:    mv a0, s4
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs2, fa0
; CHECK-NOV-NEXT:    mv a0, s3
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs1, fa0
; CHECK-NOV-NEXT:    mv a0, s2
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs0, fa0
; CHECK-NOV-NEXT:    fcvt.lu.s s2, fs6, rtz
; CHECK-NOV-NEXT:    mv a0, s1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-NOV-NEXT:    lui a1, 16
; CHECK-NOV-NEXT:    addiw a1, a1, -1
; CHECK-NOV-NEXT:    bgeu a0, a1, .LBB16_10
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a2, fs5, rtz
; CHECK-NOV-NEXT:    bgeu s2, a1, .LBB16_11
; CHECK-NOV-NEXT:  .LBB16_2: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a3, fs4, rtz
; CHECK-NOV-NEXT:    bgeu a2, a1, .LBB16_12
; CHECK-NOV-NEXT:  .LBB16_3: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a4, fs3, rtz
; CHECK-NOV-NEXT:    bgeu a3, a1, .LBB16_13
; CHECK-NOV-NEXT:  .LBB16_4: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a5, fs2, rtz
; CHECK-NOV-NEXT:    bgeu a4, a1, .LBB16_14
; CHECK-NOV-NEXT:  .LBB16_5: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a6, fs1, rtz
; CHECK-NOV-NEXT:    bgeu a5, a1, .LBB16_15
; CHECK-NOV-NEXT:  .LBB16_6: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a7, fs0, rtz
; CHECK-NOV-NEXT:    bgeu a6, a1, .LBB16_16
; CHECK-NOV-NEXT:  .LBB16_7: # %entry
; CHECK-NOV-NEXT:    bltu a7, a1, .LBB16_9
; CHECK-NOV-NEXT:  .LBB16_8: # %entry
; CHECK-NOV-NEXT:    mv a7, a1
; CHECK-NOV-NEXT:  .LBB16_9: # %entry
; CHECK-NOV-NEXT:    sh a7, 14(s0)
; CHECK-NOV-NEXT:    sh a6, 12(s0)
; CHECK-NOV-NEXT:    sh a5, 10(s0)
; CHECK-NOV-NEXT:    sh a4, 8(s0)
; CHECK-NOV-NEXT:    sh a3, 6(s0)
; CHECK-NOV-NEXT:    sh a2, 4(s0)
; CHECK-NOV-NEXT:    sh s2, 2(s0)
; CHECK-NOV-NEXT:    sh a0, 0(s0)
; CHECK-NOV-NEXT:    ld ra, 120(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 112(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 104(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s2, 96(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s3, 88(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s4, 80(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s5, 72(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s6, 64(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s7, 56(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 48(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs1, 40(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs2, 32(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs3, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs4, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs5, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs6, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 128
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB16_10: # %entry
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:    fcvt.lu.s a2, fs5, rtz
; CHECK-NOV-NEXT:    bltu s2, a1, .LBB16_2
; CHECK-NOV-NEXT:  .LBB16_11: # %entry
; CHECK-NOV-NEXT:    mv s2, a1
; CHECK-NOV-NEXT:    fcvt.lu.s a3, fs4, rtz
; CHECK-NOV-NEXT:    bltu a2, a1, .LBB16_3
; CHECK-NOV-NEXT:  .LBB16_12: # %entry
; CHECK-NOV-NEXT:    mv a2, a1
; CHECK-NOV-NEXT:    fcvt.lu.s a4, fs3, rtz
; CHECK-NOV-NEXT:    bltu a3, a1, .LBB16_4
; CHECK-NOV-NEXT:  .LBB16_13: # %entry
; CHECK-NOV-NEXT:    mv a3, a1
; CHECK-NOV-NEXT:    fcvt.lu.s a5, fs2, rtz
; CHECK-NOV-NEXT:    bltu a4, a1, .LBB16_5
; CHECK-NOV-NEXT:  .LBB16_14: # %entry
; CHECK-NOV-NEXT:    mv a4, a1
; CHECK-NOV-NEXT:    fcvt.lu.s a6, fs1, rtz
; CHECK-NOV-NEXT:    bltu a5, a1, .LBB16_6
; CHECK-NOV-NEXT:  .LBB16_15: # %entry
; CHECK-NOV-NEXT:    mv a5, a1
; CHECK-NOV-NEXT:    fcvt.lu.s a7, fs0, rtz
; CHECK-NOV-NEXT:    bltu a6, a1, .LBB16_7
; CHECK-NOV-NEXT:  .LBB16_16: # %entry
; CHECK-NOV-NEXT:    mv a6, a1
; CHECK-NOV-NEXT:    bgeu a7, a1, .LBB16_8
; CHECK-NOV-NEXT:    j .LBB16_9
;
; CHECK-V-LABEL: utesth_f16i16:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -96
; CHECK-V-NEXT:    .cfi_def_cfa_offset 96
; CHECK-V-NEXT:    sd ra, 88(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 80(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 72(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s2, 64(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s3, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s4, 48(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s5, 40(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s6, 32(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    .cfi_offset s2, -32
; CHECK-V-NEXT:    .cfi_offset s3, -40
; CHECK-V-NEXT:    .cfi_offset s4, -48
; CHECK-V-NEXT:    .cfi_offset s5, -56
; CHECK-V-NEXT:    .cfi_offset s6, -64
; CHECK-V-NEXT:    lhu s0, 56(a0)
; CHECK-V-NEXT:    lhu s1, 48(a0)
; CHECK-V-NEXT:    lhu s2, 40(a0)
; CHECK-V-NEXT:    lhu s3, 32(a0)
; CHECK-V-NEXT:    lhu s4, 24(a0)
; CHECK-V-NEXT:    lhu s5, 16(a0)
; CHECK-V-NEXT:    lhu s6, 0(a0)
; CHECK-V-NEXT:    lhu a0, 8(a0)
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 28(sp)
; CHECK-V-NEXT:    mv a0, s6
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 0(sp)
; CHECK-V-NEXT:    mv a0, s5
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 24(sp)
; CHECK-V-NEXT:    mv a0, s4
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 20(sp)
; CHECK-V-NEXT:    mv a0, s3
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 16(sp)
; CHECK-V-NEXT:    mv a0, s2
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 12(sp)
; CHECK-V-NEXT:    mv a0, s1
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 8(sp)
; CHECK-V-NEXT:    mv a0, s0
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 4(sp)
; CHECK-V-NEXT:    addi a0, sp, 28
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    mv a0, sp
; CHECK-V-NEXT:    vle32.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 1
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 3, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 2
; CHECK-V-NEXT:    addi a0, sp, 20
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 4, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 3
; CHECK-V-NEXT:    addi a0, sp, 16
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 5, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 4
; CHECK-V-NEXT:    addi a0, sp, 12
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 6, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 5
; CHECK-V-NEXT:    addi a0, sp, 8
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 7, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 6
; CHECK-V-NEXT:    addi a0, sp, 4
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 8, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 7
; CHECK-V-NEXT:    lui a0, 16
; CHECK-V-NEXT:    addiw a0, a0, -1
; CHECK-V-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-V-NEXT:    vminu.vx v10, v8, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-V-NEXT:    ld ra, 88(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 80(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 72(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s2, 64(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s3, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s4, 48(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s5, 40(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s6, 32(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 96
; CHECK-V-NEXT:    ret
entry:
  %conv = fptoui <8 x half> %x to <8 x i32>
  %0 = icmp ult <8 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <8 x i1> %0, <8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %conv6 = trunc <8 x i32> %spec.store.select to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @ustest_f16i16(<8 x half> %x) {
; CHECK-NOV-LABEL: ustest_f16i16:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -128
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 128
; CHECK-NOV-NEXT:    sd ra, 120(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 112(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 104(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s2, 96(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s3, 88(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s4, 80(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s5, 72(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s6, 64(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s7, 56(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 48(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs1, 40(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs2, 32(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs3, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs4, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs5, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs6, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset s2, -32
; CHECK-NOV-NEXT:    .cfi_offset s3, -40
; CHECK-NOV-NEXT:    .cfi_offset s4, -48
; CHECK-NOV-NEXT:    .cfi_offset s5, -56
; CHECK-NOV-NEXT:    .cfi_offset s6, -64
; CHECK-NOV-NEXT:    .cfi_offset s7, -72
; CHECK-NOV-NEXT:    .cfi_offset fs0, -80
; CHECK-NOV-NEXT:    .cfi_offset fs1, -88
; CHECK-NOV-NEXT:    .cfi_offset fs2, -96
; CHECK-NOV-NEXT:    .cfi_offset fs3, -104
; CHECK-NOV-NEXT:    .cfi_offset fs4, -112
; CHECK-NOV-NEXT:    .cfi_offset fs5, -120
; CHECK-NOV-NEXT:    .cfi_offset fs6, -128
; CHECK-NOV-NEXT:    lhu s1, 56(a1)
; CHECK-NOV-NEXT:    lhu s2, 0(a1)
; CHECK-NOV-NEXT:    lhu s3, 8(a1)
; CHECK-NOV-NEXT:    lhu s4, 16(a1)
; CHECK-NOV-NEXT:    lhu s5, 24(a1)
; CHECK-NOV-NEXT:    lhu s6, 32(a1)
; CHECK-NOV-NEXT:    lhu s7, 40(a1)
; CHECK-NOV-NEXT:    lhu a1, 48(a1)
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs6, fa0
; CHECK-NOV-NEXT:    mv a0, s7
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs5, fa0
; CHECK-NOV-NEXT:    mv a0, s6
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs4, fa0
; CHECK-NOV-NEXT:    mv a0, s5
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs3, fa0
; CHECK-NOV-NEXT:    mv a0, s4
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs2, fa0
; CHECK-NOV-NEXT:    mv a0, s3
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs1, fa0
; CHECK-NOV-NEXT:    mv a0, s2
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs0, fa0
; CHECK-NOV-NEXT:    fcvt.l.s s2, fs6, rtz
; CHECK-NOV-NEXT:    mv a0, s1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-NOV-NEXT:    lui a1, 16
; CHECK-NOV-NEXT:    addiw a3, a1, -1
; CHECK-NOV-NEXT:    bge a0, a3, .LBB17_10
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a1, fs5, rtz
; CHECK-NOV-NEXT:    bge s2, a3, .LBB17_11
; CHECK-NOV-NEXT:  .LBB17_2: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a2, fs4, rtz
; CHECK-NOV-NEXT:    bge a1, a3, .LBB17_12
; CHECK-NOV-NEXT:  .LBB17_3: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a4, fs3, rtz
; CHECK-NOV-NEXT:    bge a2, a3, .LBB17_13
; CHECK-NOV-NEXT:  .LBB17_4: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a5, fs2, rtz
; CHECK-NOV-NEXT:    bge a4, a3, .LBB17_14
; CHECK-NOV-NEXT:  .LBB17_5: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a6, fs1, rtz
; CHECK-NOV-NEXT:    bge a5, a3, .LBB17_15
; CHECK-NOV-NEXT:  .LBB17_6: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a7, fs0, rtz
; CHECK-NOV-NEXT:    bge a6, a3, .LBB17_16
; CHECK-NOV-NEXT:  .LBB17_7: # %entry
; CHECK-NOV-NEXT:    blt a7, a3, .LBB17_9
; CHECK-NOV-NEXT:  .LBB17_8: # %entry
; CHECK-NOV-NEXT:    mv a7, a3
; CHECK-NOV-NEXT:  .LBB17_9: # %entry
; CHECK-NOV-NEXT:    sgtz a3, a7
; CHECK-NOV-NEXT:    neg a3, a3
; CHECK-NOV-NEXT:    and a3, a3, a7
; CHECK-NOV-NEXT:    sgtz a7, a6
; CHECK-NOV-NEXT:    neg a7, a7
; CHECK-NOV-NEXT:    and a6, a7, a6
; CHECK-NOV-NEXT:    sgtz a7, a5
; CHECK-NOV-NEXT:    neg a7, a7
; CHECK-NOV-NEXT:    and a5, a7, a5
; CHECK-NOV-NEXT:    sgtz a7, a4
; CHECK-NOV-NEXT:    neg a7, a7
; CHECK-NOV-NEXT:    and a4, a7, a4
; CHECK-NOV-NEXT:    sgtz a7, a2
; CHECK-NOV-NEXT:    neg a7, a7
; CHECK-NOV-NEXT:    and a2, a7, a2
; CHECK-NOV-NEXT:    sgtz a7, a1
; CHECK-NOV-NEXT:    neg a7, a7
; CHECK-NOV-NEXT:    and a1, a7, a1
; CHECK-NOV-NEXT:    sgtz a7, s2
; CHECK-NOV-NEXT:    neg a7, a7
; CHECK-NOV-NEXT:    and a7, a7, s2
; CHECK-NOV-NEXT:    sgtz t0, a0
; CHECK-NOV-NEXT:    neg t0, t0
; CHECK-NOV-NEXT:    and a0, t0, a0
; CHECK-NOV-NEXT:    sh a0, 14(s0)
; CHECK-NOV-NEXT:    sh a7, 12(s0)
; CHECK-NOV-NEXT:    sh a1, 10(s0)
; CHECK-NOV-NEXT:    sh a2, 8(s0)
; CHECK-NOV-NEXT:    sh a4, 6(s0)
; CHECK-NOV-NEXT:    sh a5, 4(s0)
; CHECK-NOV-NEXT:    sh a6, 2(s0)
; CHECK-NOV-NEXT:    sh a3, 0(s0)
; CHECK-NOV-NEXT:    ld ra, 120(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 112(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 104(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s2, 96(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s3, 88(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s4, 80(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s5, 72(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s6, 64(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s7, 56(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 48(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs1, 40(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs2, 32(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs3, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs4, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs5, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs6, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 128
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB17_10: # %entry
; CHECK-NOV-NEXT:    mv a0, a3
; CHECK-NOV-NEXT:    fcvt.l.s a1, fs5, rtz
; CHECK-NOV-NEXT:    blt s2, a3, .LBB17_2
; CHECK-NOV-NEXT:  .LBB17_11: # %entry
; CHECK-NOV-NEXT:    mv s2, a3
; CHECK-NOV-NEXT:    fcvt.l.s a2, fs4, rtz
; CHECK-NOV-NEXT:    blt a1, a3, .LBB17_3
; CHECK-NOV-NEXT:  .LBB17_12: # %entry
; CHECK-NOV-NEXT:    mv a1, a3
; CHECK-NOV-NEXT:    fcvt.l.s a4, fs3, rtz
; CHECK-NOV-NEXT:    blt a2, a3, .LBB17_4
; CHECK-NOV-NEXT:  .LBB17_13: # %entry
; CHECK-NOV-NEXT:    mv a2, a3
; CHECK-NOV-NEXT:    fcvt.l.s a5, fs2, rtz
; CHECK-NOV-NEXT:    blt a4, a3, .LBB17_5
; CHECK-NOV-NEXT:  .LBB17_14: # %entry
; CHECK-NOV-NEXT:    mv a4, a3
; CHECK-NOV-NEXT:    fcvt.l.s a6, fs1, rtz
; CHECK-NOV-NEXT:    blt a5, a3, .LBB17_6
; CHECK-NOV-NEXT:  .LBB17_15: # %entry
; CHECK-NOV-NEXT:    mv a5, a3
; CHECK-NOV-NEXT:    fcvt.l.s a7, fs0, rtz
; CHECK-NOV-NEXT:    blt a6, a3, .LBB17_7
; CHECK-NOV-NEXT:  .LBB17_16: # %entry
; CHECK-NOV-NEXT:    mv a6, a3
; CHECK-NOV-NEXT:    bge a7, a3, .LBB17_8
; CHECK-NOV-NEXT:    j .LBB17_9
;
; CHECK-V-LABEL: ustest_f16i16:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -96
; CHECK-V-NEXT:    .cfi_def_cfa_offset 96
; CHECK-V-NEXT:    sd ra, 88(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 80(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 72(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s2, 64(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s3, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s4, 48(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s5, 40(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s6, 32(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    .cfi_offset s2, -32
; CHECK-V-NEXT:    .cfi_offset s3, -40
; CHECK-V-NEXT:    .cfi_offset s4, -48
; CHECK-V-NEXT:    .cfi_offset s5, -56
; CHECK-V-NEXT:    .cfi_offset s6, -64
; CHECK-V-NEXT:    lhu s0, 56(a0)
; CHECK-V-NEXT:    lhu s1, 48(a0)
; CHECK-V-NEXT:    lhu s2, 40(a0)
; CHECK-V-NEXT:    lhu s3, 32(a0)
; CHECK-V-NEXT:    lhu s4, 24(a0)
; CHECK-V-NEXT:    lhu s5, 16(a0)
; CHECK-V-NEXT:    lhu s6, 0(a0)
; CHECK-V-NEXT:    lhu a0, 8(a0)
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 28(sp)
; CHECK-V-NEXT:    mv a0, s6
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 0(sp)
; CHECK-V-NEXT:    mv a0, s5
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 24(sp)
; CHECK-V-NEXT:    mv a0, s4
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 20(sp)
; CHECK-V-NEXT:    mv a0, s3
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 16(sp)
; CHECK-V-NEXT:    mv a0, s2
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 12(sp)
; CHECK-V-NEXT:    mv a0, s1
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 8(sp)
; CHECK-V-NEXT:    mv a0, s0
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 4(sp)
; CHECK-V-NEXT:    addi a0, sp, 28
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    mv a0, sp
; CHECK-V-NEXT:    vle32.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 1
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 3, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 2
; CHECK-V-NEXT:    addi a0, sp, 20
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 4, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 3
; CHECK-V-NEXT:    addi a0, sp, 16
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 5, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 4
; CHECK-V-NEXT:    addi a0, sp, 12
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 6, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 5
; CHECK-V-NEXT:    addi a0, sp, 8
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 7, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 6
; CHECK-V-NEXT:    addi a0, sp, 4
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 8, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 7
; CHECK-V-NEXT:    lui a0, 16
; CHECK-V-NEXT:    addiw a0, a0, -1
; CHECK-V-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-V-NEXT:    vmin.vx v8, v8, a0
; CHECK-V-NEXT:    vmax.vx v10, v8, zero
; CHECK-V-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-V-NEXT:    ld ra, 88(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 80(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 72(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s2, 64(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s3, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s4, 48(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s5, 40(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s6, 32(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 96
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %0 = icmp slt <8 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <8 x i1> %0, <8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %1 = icmp sgt <8 x i32> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <8 x i1> %1, <8 x i32> %spec.store.select, <8 x i32> zeroinitializer
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

; i64 saturate

define <2 x i64> @stest_f64i64(<2 x double> %x) {
; CHECK-NOV-LABEL: stest_f64i64:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -32
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOV-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset fs0, -32
; CHECK-NOV-NEXT:    fmv.d fs0, fa1
; CHECK-NOV-NEXT:    call __fixdfti@plt
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv s1, a1
; CHECK-NOV-NEXT:    fmv.d fa0, fs0
; CHECK-NOV-NEXT:    call __fixdfti@plt
; CHECK-NOV-NEXT:    mv a2, a0
; CHECK-NOV-NEXT:    li a0, -1
; CHECK-NOV-NEXT:    srli a3, a0, 1
; CHECK-NOV-NEXT:    beqz a1, .LBB18_3
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    slti a4, a1, 0
; CHECK-NOV-NEXT:    bnez s1, .LBB18_4
; CHECK-NOV-NEXT:  .LBB18_2:
; CHECK-NOV-NEXT:    sltu a5, s0, a3
; CHECK-NOV-NEXT:    seqz a6, a5
; CHECK-NOV-NEXT:    beqz a5, .LBB18_5
; CHECK-NOV-NEXT:    j .LBB18_6
; CHECK-NOV-NEXT:  .LBB18_3:
; CHECK-NOV-NEXT:    sltu a4, a2, a3
; CHECK-NOV-NEXT:    beqz s1, .LBB18_2
; CHECK-NOV-NEXT:  .LBB18_4: # %entry
; CHECK-NOV-NEXT:    slti a5, s1, 0
; CHECK-NOV-NEXT:    seqz a6, a5
; CHECK-NOV-NEXT:    bnez a5, .LBB18_6
; CHECK-NOV-NEXT:  .LBB18_5: # %entry
; CHECK-NOV-NEXT:    mv s0, a3
; CHECK-NOV-NEXT:  .LBB18_6: # %entry
; CHECK-NOV-NEXT:    addi a6, a6, -1
; CHECK-NOV-NEXT:    seqz a5, a4
; CHECK-NOV-NEXT:    addi a5, a5, -1
; CHECK-NOV-NEXT:    and a5, a5, a1
; CHECK-NOV-NEXT:    bnez a4, .LBB18_8
; CHECK-NOV-NEXT:  # %bb.7: # %entry
; CHECK-NOV-NEXT:    mv a2, a3
; CHECK-NOV-NEXT:  .LBB18_8: # %entry
; CHECK-NOV-NEXT:    and a4, a6, s1
; CHECK-NOV-NEXT:    slli a1, a0, 63
; CHECK-NOV-NEXT:    beq a5, a0, .LBB18_11
; CHECK-NOV-NEXT:  # %bb.9: # %entry
; CHECK-NOV-NEXT:    slti a3, a5, 0
; CHECK-NOV-NEXT:    xori a3, a3, 1
; CHECK-NOV-NEXT:    bne a4, a0, .LBB18_12
; CHECK-NOV-NEXT:  .LBB18_10:
; CHECK-NOV-NEXT:    sltu a0, a1, s0
; CHECK-NOV-NEXT:    beqz a0, .LBB18_13
; CHECK-NOV-NEXT:    j .LBB18_14
; CHECK-NOV-NEXT:  .LBB18_11:
; CHECK-NOV-NEXT:    sltu a3, a1, a2
; CHECK-NOV-NEXT:    beq a4, a0, .LBB18_10
; CHECK-NOV-NEXT:  .LBB18_12: # %entry
; CHECK-NOV-NEXT:    slti a0, a4, 0
; CHECK-NOV-NEXT:    xori a0, a0, 1
; CHECK-NOV-NEXT:    bnez a0, .LBB18_14
; CHECK-NOV-NEXT:  .LBB18_13: # %entry
; CHECK-NOV-NEXT:    mv s0, a1
; CHECK-NOV-NEXT:  .LBB18_14: # %entry
; CHECK-NOV-NEXT:    bnez a3, .LBB18_16
; CHECK-NOV-NEXT:  # %bb.15: # %entry
; CHECK-NOV-NEXT:    mv a2, a1
; CHECK-NOV-NEXT:  .LBB18_16: # %entry
; CHECK-NOV-NEXT:    mv a0, s0
; CHECK-NOV-NEXT:    mv a1, a2
; CHECK-NOV-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 32
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: stest_f64i64:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -80
; CHECK-V-NEXT:    .cfi_def_cfa_offset 80
; CHECK-V-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    sub sp, sp, a0
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vs1r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vslidedown.vi v9, v8, 1
; CHECK-V-NEXT:    vfmv.f.s fa0, v9
; CHECK-V-NEXT:    call __fixdfti@plt
; CHECK-V-NEXT:    mv s0, a0
; CHECK-V-NEXT:    mv s1, a1
; CHECK-V-NEXT:    vsetivli zero, 0, e64, m1, ta, ma
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vl1r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-V-NEXT:    vfmv.f.s fa0, v8
; CHECK-V-NEXT:    call __fixdfti@plt
; CHECK-V-NEXT:    li a2, -1
; CHECK-V-NEXT:    srli a3, a2, 1
; CHECK-V-NEXT:    beqz s1, .LBB18_3
; CHECK-V-NEXT:  # %bb.1: # %entry
; CHECK-V-NEXT:    slti a4, s1, 0
; CHECK-V-NEXT:    bnez a1, .LBB18_4
; CHECK-V-NEXT:  .LBB18_2:
; CHECK-V-NEXT:    sltu a5, a0, a3
; CHECK-V-NEXT:    j .LBB18_5
; CHECK-V-NEXT:  .LBB18_3:
; CHECK-V-NEXT:    sltu a4, s0, a3
; CHECK-V-NEXT:    beqz a1, .LBB18_2
; CHECK-V-NEXT:  .LBB18_4: # %entry
; CHECK-V-NEXT:    slti a5, a1, 0
; CHECK-V-NEXT:  .LBB18_5: # %entry
; CHECK-V-NEXT:    seqz a6, a4
; CHECK-V-NEXT:    addi a6, a6, -1
; CHECK-V-NEXT:    bnez a4, .LBB18_7
; CHECK-V-NEXT:  # %bb.6: # %entry
; CHECK-V-NEXT:    mv s0, a3
; CHECK-V-NEXT:  .LBB18_7: # %entry
; CHECK-V-NEXT:    and a6, a6, s1
; CHECK-V-NEXT:    seqz a4, a5
; CHECK-V-NEXT:    addi a4, a4, -1
; CHECK-V-NEXT:    bnez a5, .LBB18_9
; CHECK-V-NEXT:  # %bb.8: # %entry
; CHECK-V-NEXT:    mv a0, a3
; CHECK-V-NEXT:  .LBB18_9: # %entry
; CHECK-V-NEXT:    and a4, a4, a1
; CHECK-V-NEXT:    slli a1, a2, 63
; CHECK-V-NEXT:    beq a6, a2, .LBB18_12
; CHECK-V-NEXT:  # %bb.10: # %entry
; CHECK-V-NEXT:    slti a3, a6, 0
; CHECK-V-NEXT:    xori a3, a3, 1
; CHECK-V-NEXT:    bne a4, a2, .LBB18_13
; CHECK-V-NEXT:  .LBB18_11:
; CHECK-V-NEXT:    sltu a2, a1, a0
; CHECK-V-NEXT:    beqz a3, .LBB18_14
; CHECK-V-NEXT:    j .LBB18_15
; CHECK-V-NEXT:  .LBB18_12:
; CHECK-V-NEXT:    sltu a3, a1, s0
; CHECK-V-NEXT:    beq a4, a2, .LBB18_11
; CHECK-V-NEXT:  .LBB18_13: # %entry
; CHECK-V-NEXT:    slti a2, a4, 0
; CHECK-V-NEXT:    xori a2, a2, 1
; CHECK-V-NEXT:    bnez a3, .LBB18_15
; CHECK-V-NEXT:  .LBB18_14: # %entry
; CHECK-V-NEXT:    mv s0, a1
; CHECK-V-NEXT:  .LBB18_15: # %entry
; CHECK-V-NEXT:    bnez a2, .LBB18_17
; CHECK-V-NEXT:  # %bb.16: # %entry
; CHECK-V-NEXT:    mv a0, a1
; CHECK-V-NEXT:  .LBB18_17: # %entry
; CHECK-V-NEXT:    sd a0, 24(sp)
; CHECK-V-NEXT:    sd s0, 32(sp)
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    addi a0, sp, 32
; CHECK-V-NEXT:    vle64.v v9, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v9, 1
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    add sp, sp, a0
; CHECK-V-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 80
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 9223372036854775807, i128 9223372036854775807>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>
  %1 = icmp sgt <2 x i128> %spec.store.select, <i128 -9223372036854775808, i128 -9223372036854775808>
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f64i64(<2 x double> %x) {
; CHECK-NOV-LABEL: utest_f64i64:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -32
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOV-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset fs0, -32
; CHECK-NOV-NEXT:    fmv.d fs0, fa0
; CHECK-NOV-NEXT:    fmv.d fa0, fa1
; CHECK-NOV-NEXT:    call __fixunsdfti@plt
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv s1, a1
; CHECK-NOV-NEXT:    fmv.d fa0, fs0
; CHECK-NOV-NEXT:    call __fixunsdfti@plt
; CHECK-NOV-NEXT:    snez a1, a1
; CHECK-NOV-NEXT:    addi a1, a1, -1
; CHECK-NOV-NEXT:    and a0, a1, a0
; CHECK-NOV-NEXT:    snez a1, s1
; CHECK-NOV-NEXT:    addi a1, a1, -1
; CHECK-NOV-NEXT:    and a1, a1, s0
; CHECK-NOV-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 32
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: utest_f64i64:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -80
; CHECK-V-NEXT:    .cfi_def_cfa_offset 80
; CHECK-V-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    sub sp, sp, a0
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vs1r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vslidedown.vi v9, v8, 1
; CHECK-V-NEXT:    vfmv.f.s fa0, v9
; CHECK-V-NEXT:    call __fixunsdfti@plt
; CHECK-V-NEXT:    mv s0, a0
; CHECK-V-NEXT:    mv s1, a1
; CHECK-V-NEXT:    vsetivli zero, 0, e64, m1, ta, ma
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vl1r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-V-NEXT:    vfmv.f.s fa0, v8
; CHECK-V-NEXT:    call __fixunsdfti@plt
; CHECK-V-NEXT:    snez a2, s1
; CHECK-V-NEXT:    addi a2, a2, -1
; CHECK-V-NEXT:    and a2, a2, s0
; CHECK-V-NEXT:    snez a1, a1
; CHECK-V-NEXT:    addi a1, a1, -1
; CHECK-V-NEXT:    and a0, a1, a0
; CHECK-V-NEXT:    sd a0, 24(sp)
; CHECK-V-NEXT:    sd a2, 32(sp)
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    addi a0, sp, 32
; CHECK-V-NEXT:    vle64.v v9, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v9, 1
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    add sp, sp, a0
; CHECK-V-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 80
; CHECK-V-NEXT:    ret
entry:
  %conv = fptoui <2 x double> %x to <2 x i128>
  %0 = icmp ult <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f64i64(<2 x double> %x) {
; CHECK-NOV-LABEL: ustest_f64i64:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -32
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOV-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset fs0, -32
; CHECK-NOV-NEXT:    fmv.d fs0, fa0
; CHECK-NOV-NEXT:    fmv.d fa0, fa1
; CHECK-NOV-NEXT:    call __fixdfti@plt
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv s1, a1
; CHECK-NOV-NEXT:    fmv.d fa0, fs0
; CHECK-NOV-NEXT:    call __fixdfti@plt
; CHECK-NOV-NEXT:    mv a2, a1
; CHECK-NOV-NEXT:    blez a1, .LBB20_2
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    li a2, 1
; CHECK-NOV-NEXT:  .LBB20_2: # %entry
; CHECK-NOV-NEXT:    mv a3, s1
; CHECK-NOV-NEXT:    blez s1, .LBB20_4
; CHECK-NOV-NEXT:  # %bb.3: # %entry
; CHECK-NOV-NEXT:    li a3, 1
; CHECK-NOV-NEXT:  .LBB20_4: # %entry
; CHECK-NOV-NEXT:    sgtz a1, a1
; CHECK-NOV-NEXT:    addi a4, a1, -1
; CHECK-NOV-NEXT:    sgtz a1, s1
; CHECK-NOV-NEXT:    addi a1, a1, -1
; CHECK-NOV-NEXT:    and a1, a1, s0
; CHECK-NOV-NEXT:    beqz a3, .LBB20_7
; CHECK-NOV-NEXT:  # %bb.5: # %entry
; CHECK-NOV-NEXT:    sgtz a3, a3
; CHECK-NOV-NEXT:    and a0, a4, a0
; CHECK-NOV-NEXT:    bnez a2, .LBB20_8
; CHECK-NOV-NEXT:  .LBB20_6:
; CHECK-NOV-NEXT:    snez a2, a0
; CHECK-NOV-NEXT:    j .LBB20_9
; CHECK-NOV-NEXT:  .LBB20_7:
; CHECK-NOV-NEXT:    snez a3, a1
; CHECK-NOV-NEXT:    and a0, a4, a0
; CHECK-NOV-NEXT:    beqz a2, .LBB20_6
; CHECK-NOV-NEXT:  .LBB20_8: # %entry
; CHECK-NOV-NEXT:    sgtz a2, a2
; CHECK-NOV-NEXT:  .LBB20_9: # %entry
; CHECK-NOV-NEXT:    seqz a2, a2
; CHECK-NOV-NEXT:    addi a2, a2, -1
; CHECK-NOV-NEXT:    and a0, a2, a0
; CHECK-NOV-NEXT:    seqz a2, a3
; CHECK-NOV-NEXT:    addi a2, a2, -1
; CHECK-NOV-NEXT:    and a1, a2, a1
; CHECK-NOV-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 32
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: ustest_f64i64:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -80
; CHECK-V-NEXT:    .cfi_def_cfa_offset 80
; CHECK-V-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    sub sp, sp, a0
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vs1r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vslidedown.vi v9, v8, 1
; CHECK-V-NEXT:    vfmv.f.s fa0, v9
; CHECK-V-NEXT:    call __fixdfti@plt
; CHECK-V-NEXT:    mv s1, a0
; CHECK-V-NEXT:    mv s0, a1
; CHECK-V-NEXT:    vsetivli zero, 0, e64, m1, ta, ma
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vl1r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-V-NEXT:    vfmv.f.s fa0, v8
; CHECK-V-NEXT:    call __fixdfti@plt
; CHECK-V-NEXT:    mv a2, a1
; CHECK-V-NEXT:    blez a1, .LBB20_2
; CHECK-V-NEXT:  # %bb.1: # %entry
; CHECK-V-NEXT:    li a2, 1
; CHECK-V-NEXT:  .LBB20_2: # %entry
; CHECK-V-NEXT:    sgtz a3, s0
; CHECK-V-NEXT:    blez s0, .LBB20_4
; CHECK-V-NEXT:  # %bb.3: # %entry
; CHECK-V-NEXT:    li s0, 1
; CHECK-V-NEXT:  .LBB20_4: # %entry
; CHECK-V-NEXT:    addi a3, a3, -1
; CHECK-V-NEXT:    sgtz a1, a1
; CHECK-V-NEXT:    addi a1, a1, -1
; CHECK-V-NEXT:    and a0, a1, a0
; CHECK-V-NEXT:    beqz a2, .LBB20_7
; CHECK-V-NEXT:  # %bb.5: # %entry
; CHECK-V-NEXT:    sgtz a1, a2
; CHECK-V-NEXT:    and a2, a3, s1
; CHECK-V-NEXT:    bnez s0, .LBB20_8
; CHECK-V-NEXT:  .LBB20_6:
; CHECK-V-NEXT:    snez a3, a2
; CHECK-V-NEXT:    j .LBB20_9
; CHECK-V-NEXT:  .LBB20_7:
; CHECK-V-NEXT:    snez a1, a0
; CHECK-V-NEXT:    and a2, a3, s1
; CHECK-V-NEXT:    beqz s0, .LBB20_6
; CHECK-V-NEXT:  .LBB20_8: # %entry
; CHECK-V-NEXT:    sgtz a3, s0
; CHECK-V-NEXT:  .LBB20_9: # %entry
; CHECK-V-NEXT:    seqz a3, a3
; CHECK-V-NEXT:    addi a3, a3, -1
; CHECK-V-NEXT:    and a2, a3, a2
; CHECK-V-NEXT:    seqz a1, a1
; CHECK-V-NEXT:    addi a1, a1, -1
; CHECK-V-NEXT:    and a0, a1, a0
; CHECK-V-NEXT:    sd a0, 24(sp)
; CHECK-V-NEXT:    sd a2, 32(sp)
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    addi a0, sp, 32
; CHECK-V-NEXT:    vle64.v v9, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v9, 1
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    add sp, sp, a0
; CHECK-V-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 80
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %1 = icmp sgt <2 x i128> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> zeroinitializer
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f32i64(<2 x float> %x) {
; CHECK-NOV-LABEL: stest_f32i64:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -32
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOV-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset fs0, -32
; CHECK-NOV-NEXT:    fmv.s fs0, fa1
; CHECK-NOV-NEXT:    call __fixsfti@plt
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv s1, a1
; CHECK-NOV-NEXT:    fmv.s fa0, fs0
; CHECK-NOV-NEXT:    call __fixsfti@plt
; CHECK-NOV-NEXT:    mv a2, a0
; CHECK-NOV-NEXT:    li a0, -1
; CHECK-NOV-NEXT:    srli a3, a0, 1
; CHECK-NOV-NEXT:    beqz a1, .LBB21_3
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    slti a4, a1, 0
; CHECK-NOV-NEXT:    bnez s1, .LBB21_4
; CHECK-NOV-NEXT:  .LBB21_2:
; CHECK-NOV-NEXT:    sltu a5, s0, a3
; CHECK-NOV-NEXT:    seqz a6, a5
; CHECK-NOV-NEXT:    beqz a5, .LBB21_5
; CHECK-NOV-NEXT:    j .LBB21_6
; CHECK-NOV-NEXT:  .LBB21_3:
; CHECK-NOV-NEXT:    sltu a4, a2, a3
; CHECK-NOV-NEXT:    beqz s1, .LBB21_2
; CHECK-NOV-NEXT:  .LBB21_4: # %entry
; CHECK-NOV-NEXT:    slti a5, s1, 0
; CHECK-NOV-NEXT:    seqz a6, a5
; CHECK-NOV-NEXT:    bnez a5, .LBB21_6
; CHECK-NOV-NEXT:  .LBB21_5: # %entry
; CHECK-NOV-NEXT:    mv s0, a3
; CHECK-NOV-NEXT:  .LBB21_6: # %entry
; CHECK-NOV-NEXT:    addi a6, a6, -1
; CHECK-NOV-NEXT:    seqz a5, a4
; CHECK-NOV-NEXT:    addi a5, a5, -1
; CHECK-NOV-NEXT:    and a5, a5, a1
; CHECK-NOV-NEXT:    bnez a4, .LBB21_8
; CHECK-NOV-NEXT:  # %bb.7: # %entry
; CHECK-NOV-NEXT:    mv a2, a3
; CHECK-NOV-NEXT:  .LBB21_8: # %entry
; CHECK-NOV-NEXT:    and a4, a6, s1
; CHECK-NOV-NEXT:    slli a1, a0, 63
; CHECK-NOV-NEXT:    beq a5, a0, .LBB21_11
; CHECK-NOV-NEXT:  # %bb.9: # %entry
; CHECK-NOV-NEXT:    slti a3, a5, 0
; CHECK-NOV-NEXT:    xori a3, a3, 1
; CHECK-NOV-NEXT:    bne a4, a0, .LBB21_12
; CHECK-NOV-NEXT:  .LBB21_10:
; CHECK-NOV-NEXT:    sltu a0, a1, s0
; CHECK-NOV-NEXT:    beqz a0, .LBB21_13
; CHECK-NOV-NEXT:    j .LBB21_14
; CHECK-NOV-NEXT:  .LBB21_11:
; CHECK-NOV-NEXT:    sltu a3, a1, a2
; CHECK-NOV-NEXT:    beq a4, a0, .LBB21_10
; CHECK-NOV-NEXT:  .LBB21_12: # %entry
; CHECK-NOV-NEXT:    slti a0, a4, 0
; CHECK-NOV-NEXT:    xori a0, a0, 1
; CHECK-NOV-NEXT:    bnez a0, .LBB21_14
; CHECK-NOV-NEXT:  .LBB21_13: # %entry
; CHECK-NOV-NEXT:    mv s0, a1
; CHECK-NOV-NEXT:  .LBB21_14: # %entry
; CHECK-NOV-NEXT:    bnez a3, .LBB21_16
; CHECK-NOV-NEXT:  # %bb.15: # %entry
; CHECK-NOV-NEXT:    mv a2, a1
; CHECK-NOV-NEXT:  .LBB21_16: # %entry
; CHECK-NOV-NEXT:    mv a0, s0
; CHECK-NOV-NEXT:    mv a1, a2
; CHECK-NOV-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 32
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: stest_f32i64:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -80
; CHECK-V-NEXT:    .cfi_def_cfa_offset 80
; CHECK-V-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    sub sp, sp, a0
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vs1r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vslidedown.vi v9, v8, 1
; CHECK-V-NEXT:    vfmv.f.s fa0, v9
; CHECK-V-NEXT:    call __fixsfti@plt
; CHECK-V-NEXT:    mv s0, a0
; CHECK-V-NEXT:    mv s1, a1
; CHECK-V-NEXT:    vsetivli zero, 0, e32, mf2, ta, ma
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vl1r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-V-NEXT:    vfmv.f.s fa0, v8
; CHECK-V-NEXT:    call __fixsfti@plt
; CHECK-V-NEXT:    li a2, -1
; CHECK-V-NEXT:    srli a3, a2, 1
; CHECK-V-NEXT:    beqz s1, .LBB21_3
; CHECK-V-NEXT:  # %bb.1: # %entry
; CHECK-V-NEXT:    slti a4, s1, 0
; CHECK-V-NEXT:    bnez a1, .LBB21_4
; CHECK-V-NEXT:  .LBB21_2:
; CHECK-V-NEXT:    sltu a5, a0, a3
; CHECK-V-NEXT:    j .LBB21_5
; CHECK-V-NEXT:  .LBB21_3:
; CHECK-V-NEXT:    sltu a4, s0, a3
; CHECK-V-NEXT:    beqz a1, .LBB21_2
; CHECK-V-NEXT:  .LBB21_4: # %entry
; CHECK-V-NEXT:    slti a5, a1, 0
; CHECK-V-NEXT:  .LBB21_5: # %entry
; CHECK-V-NEXT:    seqz a6, a4
; CHECK-V-NEXT:    addi a6, a6, -1
; CHECK-V-NEXT:    bnez a4, .LBB21_7
; CHECK-V-NEXT:  # %bb.6: # %entry
; CHECK-V-NEXT:    mv s0, a3
; CHECK-V-NEXT:  .LBB21_7: # %entry
; CHECK-V-NEXT:    and a6, a6, s1
; CHECK-V-NEXT:    seqz a4, a5
; CHECK-V-NEXT:    addi a4, a4, -1
; CHECK-V-NEXT:    bnez a5, .LBB21_9
; CHECK-V-NEXT:  # %bb.8: # %entry
; CHECK-V-NEXT:    mv a0, a3
; CHECK-V-NEXT:  .LBB21_9: # %entry
; CHECK-V-NEXT:    and a4, a4, a1
; CHECK-V-NEXT:    slli a1, a2, 63
; CHECK-V-NEXT:    beq a6, a2, .LBB21_12
; CHECK-V-NEXT:  # %bb.10: # %entry
; CHECK-V-NEXT:    slti a3, a6, 0
; CHECK-V-NEXT:    xori a3, a3, 1
; CHECK-V-NEXT:    bne a4, a2, .LBB21_13
; CHECK-V-NEXT:  .LBB21_11:
; CHECK-V-NEXT:    sltu a2, a1, a0
; CHECK-V-NEXT:    beqz a3, .LBB21_14
; CHECK-V-NEXT:    j .LBB21_15
; CHECK-V-NEXT:  .LBB21_12:
; CHECK-V-NEXT:    sltu a3, a1, s0
; CHECK-V-NEXT:    beq a4, a2, .LBB21_11
; CHECK-V-NEXT:  .LBB21_13: # %entry
; CHECK-V-NEXT:    slti a2, a4, 0
; CHECK-V-NEXT:    xori a2, a2, 1
; CHECK-V-NEXT:    bnez a3, .LBB21_15
; CHECK-V-NEXT:  .LBB21_14: # %entry
; CHECK-V-NEXT:    mv s0, a1
; CHECK-V-NEXT:  .LBB21_15: # %entry
; CHECK-V-NEXT:    bnez a2, .LBB21_17
; CHECK-V-NEXT:  # %bb.16: # %entry
; CHECK-V-NEXT:    mv a0, a1
; CHECK-V-NEXT:  .LBB21_17: # %entry
; CHECK-V-NEXT:    sd a0, 24(sp)
; CHECK-V-NEXT:    sd s0, 32(sp)
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    addi a0, sp, 32
; CHECK-V-NEXT:    vle64.v v9, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v9, 1
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    add sp, sp, a0
; CHECK-V-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 80
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 9223372036854775807, i128 9223372036854775807>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>
  %1 = icmp sgt <2 x i128> %spec.store.select, <i128 -9223372036854775808, i128 -9223372036854775808>
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f32i64(<2 x float> %x) {
; CHECK-NOV-LABEL: utest_f32i64:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -32
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOV-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset fs0, -32
; CHECK-NOV-NEXT:    fmv.s fs0, fa0
; CHECK-NOV-NEXT:    fmv.s fa0, fa1
; CHECK-NOV-NEXT:    call __fixunssfti@plt
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv s1, a1
; CHECK-NOV-NEXT:    fmv.s fa0, fs0
; CHECK-NOV-NEXT:    call __fixunssfti@plt
; CHECK-NOV-NEXT:    snez a1, a1
; CHECK-NOV-NEXT:    addi a1, a1, -1
; CHECK-NOV-NEXT:    and a0, a1, a0
; CHECK-NOV-NEXT:    snez a1, s1
; CHECK-NOV-NEXT:    addi a1, a1, -1
; CHECK-NOV-NEXT:    and a1, a1, s0
; CHECK-NOV-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 32
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: utest_f32i64:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -80
; CHECK-V-NEXT:    .cfi_def_cfa_offset 80
; CHECK-V-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    sub sp, sp, a0
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vs1r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vslidedown.vi v9, v8, 1
; CHECK-V-NEXT:    vfmv.f.s fa0, v9
; CHECK-V-NEXT:    call __fixunssfti@plt
; CHECK-V-NEXT:    mv s0, a0
; CHECK-V-NEXT:    mv s1, a1
; CHECK-V-NEXT:    vsetivli zero, 0, e32, mf2, ta, ma
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vl1r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-V-NEXT:    vfmv.f.s fa0, v8
; CHECK-V-NEXT:    call __fixunssfti@plt
; CHECK-V-NEXT:    snez a2, s1
; CHECK-V-NEXT:    addi a2, a2, -1
; CHECK-V-NEXT:    and a2, a2, s0
; CHECK-V-NEXT:    snez a1, a1
; CHECK-V-NEXT:    addi a1, a1, -1
; CHECK-V-NEXT:    and a0, a1, a0
; CHECK-V-NEXT:    sd a0, 24(sp)
; CHECK-V-NEXT:    sd a2, 32(sp)
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    addi a0, sp, 32
; CHECK-V-NEXT:    vle64.v v9, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v9, 1
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    add sp, sp, a0
; CHECK-V-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 80
; CHECK-V-NEXT:    ret
entry:
  %conv = fptoui <2 x float> %x to <2 x i128>
  %0 = icmp ult <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f32i64(<2 x float> %x) {
; CHECK-NOV-LABEL: ustest_f32i64:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -32
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOV-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset fs0, -32
; CHECK-NOV-NEXT:    fmv.s fs0, fa0
; CHECK-NOV-NEXT:    fmv.s fa0, fa1
; CHECK-NOV-NEXT:    call __fixsfti@plt
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv s1, a1
; CHECK-NOV-NEXT:    fmv.s fa0, fs0
; CHECK-NOV-NEXT:    call __fixsfti@plt
; CHECK-NOV-NEXT:    mv a2, a1
; CHECK-NOV-NEXT:    blez a1, .LBB23_2
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    li a2, 1
; CHECK-NOV-NEXT:  .LBB23_2: # %entry
; CHECK-NOV-NEXT:    mv a3, s1
; CHECK-NOV-NEXT:    blez s1, .LBB23_4
; CHECK-NOV-NEXT:  # %bb.3: # %entry
; CHECK-NOV-NEXT:    li a3, 1
; CHECK-NOV-NEXT:  .LBB23_4: # %entry
; CHECK-NOV-NEXT:    sgtz a1, a1
; CHECK-NOV-NEXT:    addi a4, a1, -1
; CHECK-NOV-NEXT:    sgtz a1, s1
; CHECK-NOV-NEXT:    addi a1, a1, -1
; CHECK-NOV-NEXT:    and a1, a1, s0
; CHECK-NOV-NEXT:    beqz a3, .LBB23_7
; CHECK-NOV-NEXT:  # %bb.5: # %entry
; CHECK-NOV-NEXT:    sgtz a3, a3
; CHECK-NOV-NEXT:    and a0, a4, a0
; CHECK-NOV-NEXT:    bnez a2, .LBB23_8
; CHECK-NOV-NEXT:  .LBB23_6:
; CHECK-NOV-NEXT:    snez a2, a0
; CHECK-NOV-NEXT:    j .LBB23_9
; CHECK-NOV-NEXT:  .LBB23_7:
; CHECK-NOV-NEXT:    snez a3, a1
; CHECK-NOV-NEXT:    and a0, a4, a0
; CHECK-NOV-NEXT:    beqz a2, .LBB23_6
; CHECK-NOV-NEXT:  .LBB23_8: # %entry
; CHECK-NOV-NEXT:    sgtz a2, a2
; CHECK-NOV-NEXT:  .LBB23_9: # %entry
; CHECK-NOV-NEXT:    seqz a2, a2
; CHECK-NOV-NEXT:    addi a2, a2, -1
; CHECK-NOV-NEXT:    and a0, a2, a0
; CHECK-NOV-NEXT:    seqz a2, a3
; CHECK-NOV-NEXT:    addi a2, a2, -1
; CHECK-NOV-NEXT:    and a1, a2, a1
; CHECK-NOV-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 32
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: ustest_f32i64:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -80
; CHECK-V-NEXT:    .cfi_def_cfa_offset 80
; CHECK-V-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    sub sp, sp, a0
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vs1r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vslidedown.vi v9, v8, 1
; CHECK-V-NEXT:    vfmv.f.s fa0, v9
; CHECK-V-NEXT:    call __fixsfti@plt
; CHECK-V-NEXT:    mv s1, a0
; CHECK-V-NEXT:    mv s0, a1
; CHECK-V-NEXT:    vsetivli zero, 0, e32, mf2, ta, ma
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vl1r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-V-NEXT:    vfmv.f.s fa0, v8
; CHECK-V-NEXT:    call __fixsfti@plt
; CHECK-V-NEXT:    mv a2, a1
; CHECK-V-NEXT:    blez a1, .LBB23_2
; CHECK-V-NEXT:  # %bb.1: # %entry
; CHECK-V-NEXT:    li a2, 1
; CHECK-V-NEXT:  .LBB23_2: # %entry
; CHECK-V-NEXT:    sgtz a3, s0
; CHECK-V-NEXT:    blez s0, .LBB23_4
; CHECK-V-NEXT:  # %bb.3: # %entry
; CHECK-V-NEXT:    li s0, 1
; CHECK-V-NEXT:  .LBB23_4: # %entry
; CHECK-V-NEXT:    addi a3, a3, -1
; CHECK-V-NEXT:    sgtz a1, a1
; CHECK-V-NEXT:    addi a1, a1, -1
; CHECK-V-NEXT:    and a0, a1, a0
; CHECK-V-NEXT:    beqz a2, .LBB23_7
; CHECK-V-NEXT:  # %bb.5: # %entry
; CHECK-V-NEXT:    sgtz a1, a2
; CHECK-V-NEXT:    and a2, a3, s1
; CHECK-V-NEXT:    bnez s0, .LBB23_8
; CHECK-V-NEXT:  .LBB23_6:
; CHECK-V-NEXT:    snez a3, a2
; CHECK-V-NEXT:    j .LBB23_9
; CHECK-V-NEXT:  .LBB23_7:
; CHECK-V-NEXT:    snez a1, a0
; CHECK-V-NEXT:    and a2, a3, s1
; CHECK-V-NEXT:    beqz s0, .LBB23_6
; CHECK-V-NEXT:  .LBB23_8: # %entry
; CHECK-V-NEXT:    sgtz a3, s0
; CHECK-V-NEXT:  .LBB23_9: # %entry
; CHECK-V-NEXT:    seqz a3, a3
; CHECK-V-NEXT:    addi a3, a3, -1
; CHECK-V-NEXT:    and a2, a3, a2
; CHECK-V-NEXT:    seqz a1, a1
; CHECK-V-NEXT:    addi a1, a1, -1
; CHECK-V-NEXT:    and a0, a1, a0
; CHECK-V-NEXT:    sd a0, 24(sp)
; CHECK-V-NEXT:    sd a2, 32(sp)
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    addi a0, sp, 32
; CHECK-V-NEXT:    vle64.v v9, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v9, 1
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    add sp, sp, a0
; CHECK-V-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 80
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %1 = icmp sgt <2 x i128> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> zeroinitializer
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f16i64(<2 x half> %x) {
; CHECK-NOV-LABEL: stest_f16i64:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -32
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOV-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset s2, -32
; CHECK-NOV-NEXT:    mv s2, a1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    call __fixsfti@plt
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv s1, a1
; CHECK-NOV-NEXT:    mv a0, s2
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    call __fixsfti@plt
; CHECK-NOV-NEXT:    mv a2, a0
; CHECK-NOV-NEXT:    li a0, -1
; CHECK-NOV-NEXT:    srli a3, a0, 1
; CHECK-NOV-NEXT:    beqz a1, .LBB24_3
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    slti a4, a1, 0
; CHECK-NOV-NEXT:    bnez s1, .LBB24_4
; CHECK-NOV-NEXT:  .LBB24_2:
; CHECK-NOV-NEXT:    sltu a5, s0, a3
; CHECK-NOV-NEXT:    seqz a6, a5
; CHECK-NOV-NEXT:    beqz a5, .LBB24_5
; CHECK-NOV-NEXT:    j .LBB24_6
; CHECK-NOV-NEXT:  .LBB24_3:
; CHECK-NOV-NEXT:    sltu a4, a2, a3
; CHECK-NOV-NEXT:    beqz s1, .LBB24_2
; CHECK-NOV-NEXT:  .LBB24_4: # %entry
; CHECK-NOV-NEXT:    slti a5, s1, 0
; CHECK-NOV-NEXT:    seqz a6, a5
; CHECK-NOV-NEXT:    bnez a5, .LBB24_6
; CHECK-NOV-NEXT:  .LBB24_5: # %entry
; CHECK-NOV-NEXT:    mv s0, a3
; CHECK-NOV-NEXT:  .LBB24_6: # %entry
; CHECK-NOV-NEXT:    addi a6, a6, -1
; CHECK-NOV-NEXT:    seqz a5, a4
; CHECK-NOV-NEXT:    addi a5, a5, -1
; CHECK-NOV-NEXT:    and a5, a5, a1
; CHECK-NOV-NEXT:    bnez a4, .LBB24_8
; CHECK-NOV-NEXT:  # %bb.7: # %entry
; CHECK-NOV-NEXT:    mv a2, a3
; CHECK-NOV-NEXT:  .LBB24_8: # %entry
; CHECK-NOV-NEXT:    and a4, a6, s1
; CHECK-NOV-NEXT:    slli a1, a0, 63
; CHECK-NOV-NEXT:    beq a5, a0, .LBB24_11
; CHECK-NOV-NEXT:  # %bb.9: # %entry
; CHECK-NOV-NEXT:    slti a3, a5, 0
; CHECK-NOV-NEXT:    xori a3, a3, 1
; CHECK-NOV-NEXT:    bne a4, a0, .LBB24_12
; CHECK-NOV-NEXT:  .LBB24_10:
; CHECK-NOV-NEXT:    sltu a0, a1, s0
; CHECK-NOV-NEXT:    beqz a0, .LBB24_13
; CHECK-NOV-NEXT:    j .LBB24_14
; CHECK-NOV-NEXT:  .LBB24_11:
; CHECK-NOV-NEXT:    sltu a3, a1, a2
; CHECK-NOV-NEXT:    beq a4, a0, .LBB24_10
; CHECK-NOV-NEXT:  .LBB24_12: # %entry
; CHECK-NOV-NEXT:    slti a0, a4, 0
; CHECK-NOV-NEXT:    xori a0, a0, 1
; CHECK-NOV-NEXT:    bnez a0, .LBB24_14
; CHECK-NOV-NEXT:  .LBB24_13: # %entry
; CHECK-NOV-NEXT:    mv s0, a1
; CHECK-NOV-NEXT:  .LBB24_14: # %entry
; CHECK-NOV-NEXT:    bnez a3, .LBB24_16
; CHECK-NOV-NEXT:  # %bb.15: # %entry
; CHECK-NOV-NEXT:    mv a2, a1
; CHECK-NOV-NEXT:  .LBB24_16: # %entry
; CHECK-NOV-NEXT:    mv a0, s0
; CHECK-NOV-NEXT:    mv a1, a2
; CHECK-NOV-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 32
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: stest_f16i64:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -48
; CHECK-V-NEXT:    .cfi_def_cfa_offset 48
; CHECK-V-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    .cfi_offset s2, -32
; CHECK-V-NEXT:    mv s2, a1
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    call __fixsfti@plt
; CHECK-V-NEXT:    mv s0, a0
; CHECK-V-NEXT:    mv s1, a1
; CHECK-V-NEXT:    mv a0, s2
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    call __fixsfti@plt
; CHECK-V-NEXT:    li a2, -1
; CHECK-V-NEXT:    srli a3, a2, 1
; CHECK-V-NEXT:    beqz a1, .LBB24_3
; CHECK-V-NEXT:  # %bb.1: # %entry
; CHECK-V-NEXT:    slti a4, a1, 0
; CHECK-V-NEXT:    bnez s1, .LBB24_4
; CHECK-V-NEXT:  .LBB24_2:
; CHECK-V-NEXT:    sltu a5, s0, a3
; CHECK-V-NEXT:    seqz a6, a5
; CHECK-V-NEXT:    beqz a5, .LBB24_5
; CHECK-V-NEXT:    j .LBB24_6
; CHECK-V-NEXT:  .LBB24_3:
; CHECK-V-NEXT:    sltu a4, a0, a3
; CHECK-V-NEXT:    beqz s1, .LBB24_2
; CHECK-V-NEXT:  .LBB24_4: # %entry
; CHECK-V-NEXT:    slti a5, s1, 0
; CHECK-V-NEXT:    seqz a6, a5
; CHECK-V-NEXT:    bnez a5, .LBB24_6
; CHECK-V-NEXT:  .LBB24_5: # %entry
; CHECK-V-NEXT:    mv s0, a3
; CHECK-V-NEXT:  .LBB24_6: # %entry
; CHECK-V-NEXT:    addi a6, a6, -1
; CHECK-V-NEXT:    seqz a5, a4
; CHECK-V-NEXT:    addi a5, a5, -1
; CHECK-V-NEXT:    and a5, a5, a1
; CHECK-V-NEXT:    bnez a4, .LBB24_8
; CHECK-V-NEXT:  # %bb.7: # %entry
; CHECK-V-NEXT:    mv a0, a3
; CHECK-V-NEXT:  .LBB24_8: # %entry
; CHECK-V-NEXT:    and a4, a6, s1
; CHECK-V-NEXT:    slli a1, a2, 63
; CHECK-V-NEXT:    beq a5, a2, .LBB24_11
; CHECK-V-NEXT:  # %bb.9: # %entry
; CHECK-V-NEXT:    slti a3, a5, 0
; CHECK-V-NEXT:    xori a3, a3, 1
; CHECK-V-NEXT:    bne a4, a2, .LBB24_12
; CHECK-V-NEXT:  .LBB24_10:
; CHECK-V-NEXT:    sltu a2, a1, s0
; CHECK-V-NEXT:    beqz a2, .LBB24_13
; CHECK-V-NEXT:    j .LBB24_14
; CHECK-V-NEXT:  .LBB24_11:
; CHECK-V-NEXT:    sltu a3, a1, a0
; CHECK-V-NEXT:    beq a4, a2, .LBB24_10
; CHECK-V-NEXT:  .LBB24_12: # %entry
; CHECK-V-NEXT:    slti a2, a4, 0
; CHECK-V-NEXT:    xori a2, a2, 1
; CHECK-V-NEXT:    bnez a2, .LBB24_14
; CHECK-V-NEXT:  .LBB24_13: # %entry
; CHECK-V-NEXT:    mv s0, a1
; CHECK-V-NEXT:  .LBB24_14: # %entry
; CHECK-V-NEXT:    bnez a3, .LBB24_16
; CHECK-V-NEXT:  # %bb.15: # %entry
; CHECK-V-NEXT:    mv a0, a1
; CHECK-V-NEXT:  .LBB24_16: # %entry
; CHECK-V-NEXT:    sd a0, 8(sp)
; CHECK-V-NEXT:    sd s0, 0(sp)
; CHECK-V-NEXT:    addi a0, sp, 8
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v9, (a0)
; CHECK-V-NEXT:    mv a0, sp
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v9, 1
; CHECK-V-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 48
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 9223372036854775807, i128 9223372036854775807>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>
  %1 = icmp sgt <2 x i128> %spec.store.select, <i128 -9223372036854775808, i128 -9223372036854775808>
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utesth_f16i64(<2 x half> %x) {
; CHECK-NOV-LABEL: utesth_f16i64:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -32
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOV-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset s2, -32
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    call __fixunssfti@plt
; CHECK-NOV-NEXT:    mv s1, a0
; CHECK-NOV-NEXT:    mv s2, a1
; CHECK-NOV-NEXT:    mv a0, s0
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    call __fixunssfti@plt
; CHECK-NOV-NEXT:    snez a1, a1
; CHECK-NOV-NEXT:    addi a1, a1, -1
; CHECK-NOV-NEXT:    and a0, a1, a0
; CHECK-NOV-NEXT:    snez a1, s2
; CHECK-NOV-NEXT:    addi a1, a1, -1
; CHECK-NOV-NEXT:    and a1, a1, s1
; CHECK-NOV-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 32
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: utesth_f16i64:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -48
; CHECK-V-NEXT:    .cfi_def_cfa_offset 48
; CHECK-V-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    .cfi_offset s2, -32
; CHECK-V-NEXT:    mv s0, a0
; CHECK-V-NEXT:    mv a0, a1
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    call __fixunssfti@plt
; CHECK-V-NEXT:    mv s1, a0
; CHECK-V-NEXT:    mv s2, a1
; CHECK-V-NEXT:    mv a0, s0
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    call __fixunssfti@plt
; CHECK-V-NEXT:    snez a1, a1
; CHECK-V-NEXT:    addi a1, a1, -1
; CHECK-V-NEXT:    and a0, a1, a0
; CHECK-V-NEXT:    snez a1, s2
; CHECK-V-NEXT:    addi a1, a1, -1
; CHECK-V-NEXT:    and a1, a1, s1
; CHECK-V-NEXT:    sd a1, 8(sp)
; CHECK-V-NEXT:    sd a0, 0(sp)
; CHECK-V-NEXT:    addi a0, sp, 8
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v9, (a0)
; CHECK-V-NEXT:    mv a0, sp
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v9, 1
; CHECK-V-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 48
; CHECK-V-NEXT:    ret
entry:
  %conv = fptoui <2 x half> %x to <2 x i128>
  %0 = icmp ult <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f16i64(<2 x half> %x) {
; CHECK-NOV-LABEL: ustest_f16i64:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -32
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOV-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset s2, -32
; CHECK-NOV-NEXT:    mv s2, a0
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    call __fixsfti@plt
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv s1, a1
; CHECK-NOV-NEXT:    mv a0, s2
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    call __fixsfti@plt
; CHECK-NOV-NEXT:    mv a2, a1
; CHECK-NOV-NEXT:    blez a1, .LBB26_2
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    li a2, 1
; CHECK-NOV-NEXT:  .LBB26_2: # %entry
; CHECK-NOV-NEXT:    mv a3, s1
; CHECK-NOV-NEXT:    blez s1, .LBB26_4
; CHECK-NOV-NEXT:  # %bb.3: # %entry
; CHECK-NOV-NEXT:    li a3, 1
; CHECK-NOV-NEXT:  .LBB26_4: # %entry
; CHECK-NOV-NEXT:    sgtz a1, a1
; CHECK-NOV-NEXT:    addi a4, a1, -1
; CHECK-NOV-NEXT:    sgtz a1, s1
; CHECK-NOV-NEXT:    addi a1, a1, -1
; CHECK-NOV-NEXT:    and a1, a1, s0
; CHECK-NOV-NEXT:    beqz a3, .LBB26_7
; CHECK-NOV-NEXT:  # %bb.5: # %entry
; CHECK-NOV-NEXT:    sgtz a3, a3
; CHECK-NOV-NEXT:    and a0, a4, a0
; CHECK-NOV-NEXT:    bnez a2, .LBB26_8
; CHECK-NOV-NEXT:  .LBB26_6:
; CHECK-NOV-NEXT:    snez a2, a0
; CHECK-NOV-NEXT:    j .LBB26_9
; CHECK-NOV-NEXT:  .LBB26_7:
; CHECK-NOV-NEXT:    snez a3, a1
; CHECK-NOV-NEXT:    and a0, a4, a0
; CHECK-NOV-NEXT:    beqz a2, .LBB26_6
; CHECK-NOV-NEXT:  .LBB26_8: # %entry
; CHECK-NOV-NEXT:    sgtz a2, a2
; CHECK-NOV-NEXT:  .LBB26_9: # %entry
; CHECK-NOV-NEXT:    seqz a2, a2
; CHECK-NOV-NEXT:    addi a2, a2, -1
; CHECK-NOV-NEXT:    and a0, a2, a0
; CHECK-NOV-NEXT:    seqz a2, a3
; CHECK-NOV-NEXT:    addi a2, a2, -1
; CHECK-NOV-NEXT:    and a1, a2, a1
; CHECK-NOV-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 32
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: ustest_f16i64:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -48
; CHECK-V-NEXT:    .cfi_def_cfa_offset 48
; CHECK-V-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    .cfi_offset s2, -32
; CHECK-V-NEXT:    mv s2, a0
; CHECK-V-NEXT:    mv a0, a1
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    call __fixsfti@plt
; CHECK-V-NEXT:    mv s0, a0
; CHECK-V-NEXT:    mv s1, a1
; CHECK-V-NEXT:    mv a0, s2
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    call __fixsfti@plt
; CHECK-V-NEXT:    mv a2, a1
; CHECK-V-NEXT:    blez a1, .LBB26_2
; CHECK-V-NEXT:  # %bb.1: # %entry
; CHECK-V-NEXT:    li a2, 1
; CHECK-V-NEXT:  .LBB26_2: # %entry
; CHECK-V-NEXT:    mv a3, s1
; CHECK-V-NEXT:    blez s1, .LBB26_4
; CHECK-V-NEXT:  # %bb.3: # %entry
; CHECK-V-NEXT:    li a3, 1
; CHECK-V-NEXT:  .LBB26_4: # %entry
; CHECK-V-NEXT:    sgtz a1, a1
; CHECK-V-NEXT:    addi a4, a1, -1
; CHECK-V-NEXT:    sgtz a1, s1
; CHECK-V-NEXT:    addi a1, a1, -1
; CHECK-V-NEXT:    and a1, a1, s0
; CHECK-V-NEXT:    beqz a3, .LBB26_7
; CHECK-V-NEXT:  # %bb.5: # %entry
; CHECK-V-NEXT:    sgtz a3, a3
; CHECK-V-NEXT:    and a0, a4, a0
; CHECK-V-NEXT:    bnez a2, .LBB26_8
; CHECK-V-NEXT:  .LBB26_6:
; CHECK-V-NEXT:    snez a2, a0
; CHECK-V-NEXT:    j .LBB26_9
; CHECK-V-NEXT:  .LBB26_7:
; CHECK-V-NEXT:    snez a3, a1
; CHECK-V-NEXT:    and a0, a4, a0
; CHECK-V-NEXT:    beqz a2, .LBB26_6
; CHECK-V-NEXT:  .LBB26_8: # %entry
; CHECK-V-NEXT:    sgtz a2, a2
; CHECK-V-NEXT:  .LBB26_9: # %entry
; CHECK-V-NEXT:    seqz a2, a2
; CHECK-V-NEXT:    addi a2, a2, -1
; CHECK-V-NEXT:    and a0, a2, a0
; CHECK-V-NEXT:    seqz a2, a3
; CHECK-V-NEXT:    addi a2, a2, -1
; CHECK-V-NEXT:    and a1, a2, a1
; CHECK-V-NEXT:    sd a1, 8(sp)
; CHECK-V-NEXT:    sd a0, 0(sp)
; CHECK-V-NEXT:    addi a0, sp, 8
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v9, (a0)
; CHECK-V-NEXT:    mv a0, sp
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v9, 1
; CHECK-V-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 48
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %1 = icmp sgt <2 x i128> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> zeroinitializer
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}



; i32 saturate

define <2 x i32> @stest_f64i32_mm(<2 x double> %x) {
; CHECK-NOV-LABEL: stest_f64i32_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.l.d a1, fa1, rtz
; CHECK-NOV-NEXT:    lui a2, 524288
; CHECK-NOV-NEXT:    addiw a3, a2, -1
; CHECK-NOV-NEXT:    fcvt.l.d a0, fa0, rtz
; CHECK-NOV-NEXT:    bge a1, a3, .LBB27_5
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    bge a0, a3, .LBB27_6
; CHECK-NOV-NEXT:  .LBB27_2: # %entry
; CHECK-NOV-NEXT:    bge a2, a0, .LBB27_7
; CHECK-NOV-NEXT:  .LBB27_3: # %entry
; CHECK-NOV-NEXT:    bge a2, a1, .LBB27_8
; CHECK-NOV-NEXT:  .LBB27_4: # %entry
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB27_5: # %entry
; CHECK-NOV-NEXT:    mv a1, a3
; CHECK-NOV-NEXT:    blt a0, a3, .LBB27_2
; CHECK-NOV-NEXT:  .LBB27_6: # %entry
; CHECK-NOV-NEXT:    mv a0, a3
; CHECK-NOV-NEXT:    blt a2, a0, .LBB27_3
; CHECK-NOV-NEXT:  .LBB27_7: # %entry
; CHECK-NOV-NEXT:    lui a0, 524288
; CHECK-NOV-NEXT:    blt a2, a1, .LBB27_4
; CHECK-NOV-NEXT:  .LBB27_8: # %entry
; CHECK-NOV-NEXT:    lui a1, 524288
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: stest_f64i32_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-V-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-V-NEXT:    lui a0, 524288
; CHECK-V-NEXT:    addiw a1, a0, -1
; CHECK-V-NEXT:    vmin.vx v8, v8, a1
; CHECK-V-NEXT:    vmax.vx v8, v8, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %spec.store.select = call <2 x i64> @llvm.smin.v2i64(<2 x i64> %conv, <2 x i64> <i64 2147483647, i64 2147483647>)
  %spec.store.select7 = call <2 x i64> @llvm.smax.v2i64(<2 x i64> %spec.store.select, <2 x i64> <i64 -2147483648, i64 -2147483648>)
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @utest_f64i32_mm(<2 x double> %x) {
; CHECK-NOV-LABEL: utest_f64i32_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.d a0, fa0, rtz
; CHECK-NOV-NEXT:    li a1, -1
; CHECK-NOV-NEXT:    srli a2, a1, 32
; CHECK-NOV-NEXT:    fcvt.lu.d a1, fa1, rtz
; CHECK-NOV-NEXT:    bgeu a0, a2, .LBB28_3
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    bgeu a1, a2, .LBB28_4
; CHECK-NOV-NEXT:  .LBB28_2: # %entry
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB28_3: # %entry
; CHECK-NOV-NEXT:    mv a0, a2
; CHECK-NOV-NEXT:    bltu a1, a2, .LBB28_2
; CHECK-NOV-NEXT:  .LBB28_4: # %entry
; CHECK-NOV-NEXT:    mv a1, a2
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: utest_f64i32_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-V-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-V-NEXT:    li a0, -1
; CHECK-V-NEXT:    srli a0, a0, 32
; CHECK-V-NEXT:    vminu.vx v8, v8, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptoui <2 x double> %x to <2 x i64>
  %spec.store.select = call <2 x i64> @llvm.umin.v2i64(<2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>)
  %conv6 = trunc <2 x i64> %spec.store.select to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @ustest_f64i32_mm(<2 x double> %x) {
; CHECK-NOV-LABEL: ustest_f64i32_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.l.d a1, fa1, rtz
; CHECK-NOV-NEXT:    li a0, -1
; CHECK-NOV-NEXT:    srli a2, a0, 32
; CHECK-NOV-NEXT:    fcvt.l.d a0, fa0, rtz
; CHECK-NOV-NEXT:    blt a1, a2, .LBB29_2
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    mv a1, a2
; CHECK-NOV-NEXT:  .LBB29_2: # %entry
; CHECK-NOV-NEXT:    blt a0, a2, .LBB29_4
; CHECK-NOV-NEXT:  # %bb.3: # %entry
; CHECK-NOV-NEXT:    mv a0, a2
; CHECK-NOV-NEXT:  .LBB29_4: # %entry
; CHECK-NOV-NEXT:    sgtz a2, a0
; CHECK-NOV-NEXT:    neg a2, a2
; CHECK-NOV-NEXT:    and a0, a2, a0
; CHECK-NOV-NEXT:    sgtz a2, a1
; CHECK-NOV-NEXT:    neg a2, a2
; CHECK-NOV-NEXT:    and a1, a2, a1
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: ustest_f64i32_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-V-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-V-NEXT:    li a0, -1
; CHECK-V-NEXT:    srli a0, a0, 32
; CHECK-V-NEXT:    vmin.vx v8, v8, a0
; CHECK-V-NEXT:    vmax.vx v8, v8, zero
; CHECK-V-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %spec.store.select = call <2 x i64> @llvm.smin.v2i64(<2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>)
  %spec.store.select7 = call <2 x i64> @llvm.smax.v2i64(<2 x i64> %spec.store.select, <2 x i64> zeroinitializer)
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <4 x i32> @stest_f32i32_mm(<4 x float> %x) {
; CHECK-NOV-LABEL: stest_f32i32_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a1, fa3, rtz
; CHECK-NOV-NEXT:    lui a3, 524288
; CHECK-NOV-NEXT:    addiw a6, a3, -1
; CHECK-NOV-NEXT:    fcvt.l.s a2, fa2, rtz
; CHECK-NOV-NEXT:    bge a1, a6, .LBB30_10
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a4, fa1, rtz
; CHECK-NOV-NEXT:    bge a2, a6, .LBB30_11
; CHECK-NOV-NEXT:  .LBB30_2: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a5, fa0, rtz
; CHECK-NOV-NEXT:    bge a4, a6, .LBB30_12
; CHECK-NOV-NEXT:  .LBB30_3: # %entry
; CHECK-NOV-NEXT:    bge a5, a6, .LBB30_13
; CHECK-NOV-NEXT:  .LBB30_4: # %entry
; CHECK-NOV-NEXT:    bge a3, a5, .LBB30_14
; CHECK-NOV-NEXT:  .LBB30_5: # %entry
; CHECK-NOV-NEXT:    bge a3, a4, .LBB30_15
; CHECK-NOV-NEXT:  .LBB30_6: # %entry
; CHECK-NOV-NEXT:    bge a3, a2, .LBB30_16
; CHECK-NOV-NEXT:  .LBB30_7: # %entry
; CHECK-NOV-NEXT:    blt a3, a1, .LBB30_9
; CHECK-NOV-NEXT:  .LBB30_8: # %entry
; CHECK-NOV-NEXT:    lui a1, 524288
; CHECK-NOV-NEXT:  .LBB30_9: # %entry
; CHECK-NOV-NEXT:    sw a1, 12(a0)
; CHECK-NOV-NEXT:    sw a2, 8(a0)
; CHECK-NOV-NEXT:    sw a4, 4(a0)
; CHECK-NOV-NEXT:    sw a5, 0(a0)
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB30_10: # %entry
; CHECK-NOV-NEXT:    mv a1, a6
; CHECK-NOV-NEXT:    fcvt.l.s a4, fa1, rtz
; CHECK-NOV-NEXT:    blt a2, a6, .LBB30_2
; CHECK-NOV-NEXT:  .LBB30_11: # %entry
; CHECK-NOV-NEXT:    mv a2, a6
; CHECK-NOV-NEXT:    fcvt.l.s a5, fa0, rtz
; CHECK-NOV-NEXT:    blt a4, a6, .LBB30_3
; CHECK-NOV-NEXT:  .LBB30_12: # %entry
; CHECK-NOV-NEXT:    mv a4, a6
; CHECK-NOV-NEXT:    blt a5, a6, .LBB30_4
; CHECK-NOV-NEXT:  .LBB30_13: # %entry
; CHECK-NOV-NEXT:    mv a5, a6
; CHECK-NOV-NEXT:    blt a3, a5, .LBB30_5
; CHECK-NOV-NEXT:  .LBB30_14: # %entry
; CHECK-NOV-NEXT:    lui a5, 524288
; CHECK-NOV-NEXT:    blt a3, a4, .LBB30_6
; CHECK-NOV-NEXT:  .LBB30_15: # %entry
; CHECK-NOV-NEXT:    lui a4, 524288
; CHECK-NOV-NEXT:    blt a3, a2, .LBB30_7
; CHECK-NOV-NEXT:  .LBB30_16: # %entry
; CHECK-NOV-NEXT:    lui a2, 524288
; CHECK-NOV-NEXT:    bge a3, a1, .LBB30_8
; CHECK-NOV-NEXT:    j .LBB30_9
;
; CHECK-V-LABEL: stest_f32i32_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-V-NEXT:    vfwcvt.rtz.x.f.v v10, v8
; CHECK-V-NEXT:    lui a0, 524288
; CHECK-V-NEXT:    addiw a1, a0, -1
; CHECK-V-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-V-NEXT:    vmin.vx v8, v10, a1
; CHECK-V-NEXT:    vmax.vx v10, v8, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utest_f32i32_mm(<4 x float> %x) {
; CHECK-NOV-LABEL: utest_f32i32_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a1, fa0, rtz
; CHECK-NOV-NEXT:    li a2, -1
; CHECK-NOV-NEXT:    srli a3, a2, 32
; CHECK-NOV-NEXT:    fcvt.lu.s a2, fa1, rtz
; CHECK-NOV-NEXT:    bgeu a1, a3, .LBB31_6
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a4, fa2, rtz
; CHECK-NOV-NEXT:    bgeu a2, a3, .LBB31_7
; CHECK-NOV-NEXT:  .LBB31_2: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a5, fa3, rtz
; CHECK-NOV-NEXT:    bgeu a4, a3, .LBB31_8
; CHECK-NOV-NEXT:  .LBB31_3: # %entry
; CHECK-NOV-NEXT:    bltu a5, a3, .LBB31_5
; CHECK-NOV-NEXT:  .LBB31_4: # %entry
; CHECK-NOV-NEXT:    mv a5, a3
; CHECK-NOV-NEXT:  .LBB31_5: # %entry
; CHECK-NOV-NEXT:    sw a5, 12(a0)
; CHECK-NOV-NEXT:    sw a4, 8(a0)
; CHECK-NOV-NEXT:    sw a2, 4(a0)
; CHECK-NOV-NEXT:    sw a1, 0(a0)
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB31_6: # %entry
; CHECK-NOV-NEXT:    mv a1, a3
; CHECK-NOV-NEXT:    fcvt.lu.s a4, fa2, rtz
; CHECK-NOV-NEXT:    bltu a2, a3, .LBB31_2
; CHECK-NOV-NEXT:  .LBB31_7: # %entry
; CHECK-NOV-NEXT:    mv a2, a3
; CHECK-NOV-NEXT:    fcvt.lu.s a5, fa3, rtz
; CHECK-NOV-NEXT:    bltu a4, a3, .LBB31_3
; CHECK-NOV-NEXT:  .LBB31_8: # %entry
; CHECK-NOV-NEXT:    mv a4, a3
; CHECK-NOV-NEXT:    bgeu a5, a3, .LBB31_4
; CHECK-NOV-NEXT:    j .LBB31_5
;
; CHECK-V-LABEL: utest_f32i32_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-V-NEXT:    vfwcvt.rtz.xu.f.v v10, v8
; CHECK-V-NEXT:    li a0, -1
; CHECK-V-NEXT:    srli a0, a0, 32
; CHECK-V-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-V-NEXT:    vminu.vx v10, v10, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptoui <4 x float> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.umin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f32i32_mm(<4 x float> %x) {
; CHECK-NOV-LABEL: ustest_f32i32_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a1, fa3, rtz
; CHECK-NOV-NEXT:    li a2, -1
; CHECK-NOV-NEXT:    srli a4, a2, 32
; CHECK-NOV-NEXT:    fcvt.l.s a2, fa2, rtz
; CHECK-NOV-NEXT:    bge a1, a4, .LBB32_6
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a3, fa1, rtz
; CHECK-NOV-NEXT:    bge a2, a4, .LBB32_7
; CHECK-NOV-NEXT:  .LBB32_2: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a5, fa0, rtz
; CHECK-NOV-NEXT:    bge a3, a4, .LBB32_8
; CHECK-NOV-NEXT:  .LBB32_3: # %entry
; CHECK-NOV-NEXT:    blt a5, a4, .LBB32_5
; CHECK-NOV-NEXT:  .LBB32_4: # %entry
; CHECK-NOV-NEXT:    mv a5, a4
; CHECK-NOV-NEXT:  .LBB32_5: # %entry
; CHECK-NOV-NEXT:    sgtz a4, a5
; CHECK-NOV-NEXT:    neg a4, a4
; CHECK-NOV-NEXT:    and a4, a4, a5
; CHECK-NOV-NEXT:    sgtz a5, a3
; CHECK-NOV-NEXT:    neg a5, a5
; CHECK-NOV-NEXT:    and a3, a5, a3
; CHECK-NOV-NEXT:    sgtz a5, a2
; CHECK-NOV-NEXT:    neg a5, a5
; CHECK-NOV-NEXT:    and a2, a5, a2
; CHECK-NOV-NEXT:    sgtz a5, a1
; CHECK-NOV-NEXT:    neg a5, a5
; CHECK-NOV-NEXT:    and a1, a5, a1
; CHECK-NOV-NEXT:    sw a1, 12(a0)
; CHECK-NOV-NEXT:    sw a2, 8(a0)
; CHECK-NOV-NEXT:    sw a3, 4(a0)
; CHECK-NOV-NEXT:    sw a4, 0(a0)
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB32_6: # %entry
; CHECK-NOV-NEXT:    mv a1, a4
; CHECK-NOV-NEXT:    fcvt.l.s a3, fa1, rtz
; CHECK-NOV-NEXT:    blt a2, a4, .LBB32_2
; CHECK-NOV-NEXT:  .LBB32_7: # %entry
; CHECK-NOV-NEXT:    mv a2, a4
; CHECK-NOV-NEXT:    fcvt.l.s a5, fa0, rtz
; CHECK-NOV-NEXT:    blt a3, a4, .LBB32_3
; CHECK-NOV-NEXT:  .LBB32_8: # %entry
; CHECK-NOV-NEXT:    mv a3, a4
; CHECK-NOV-NEXT:    bge a5, a4, .LBB32_4
; CHECK-NOV-NEXT:    j .LBB32_5
;
; CHECK-V-LABEL: ustest_f32i32_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-V-NEXT:    vfwcvt.rtz.x.f.v v10, v8
; CHECK-V-NEXT:    li a0, -1
; CHECK-V-NEXT:    srli a0, a0, 32
; CHECK-V-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-V-NEXT:    vmin.vx v8, v10, a0
; CHECK-V-NEXT:    vmax.vx v10, v8, zero
; CHECK-V-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> zeroinitializer)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @stest_f16i32_mm(<4 x half> %x) {
; CHECK-NOV-LABEL: stest_f16i32_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -64
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NOV-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s3, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs2, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset s2, -32
; CHECK-NOV-NEXT:    .cfi_offset s3, -40
; CHECK-NOV-NEXT:    .cfi_offset fs0, -48
; CHECK-NOV-NEXT:    .cfi_offset fs1, -56
; CHECK-NOV-NEXT:    .cfi_offset fs2, -64
; CHECK-NOV-NEXT:    lhu s1, 24(a1)
; CHECK-NOV-NEXT:    lhu s2, 0(a1)
; CHECK-NOV-NEXT:    lhu s3, 8(a1)
; CHECK-NOV-NEXT:    lhu a1, 16(a1)
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs2, fa0
; CHECK-NOV-NEXT:    mv a0, s3
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs1, fa0
; CHECK-NOV-NEXT:    mv a0, s2
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs0, fa0
; CHECK-NOV-NEXT:    fcvt.l.s s2, fs2, rtz
; CHECK-NOV-NEXT:    mv a0, s1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-NOV-NEXT:    lui a1, 524288
; CHECK-NOV-NEXT:    addiw a4, a1, -1
; CHECK-NOV-NEXT:    bge a0, a4, .LBB33_10
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a2, fs1, rtz
; CHECK-NOV-NEXT:    bge s2, a4, .LBB33_11
; CHECK-NOV-NEXT:  .LBB33_2: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a3, fs0, rtz
; CHECK-NOV-NEXT:    bge a2, a4, .LBB33_12
; CHECK-NOV-NEXT:  .LBB33_3: # %entry
; CHECK-NOV-NEXT:    bge a3, a4, .LBB33_13
; CHECK-NOV-NEXT:  .LBB33_4: # %entry
; CHECK-NOV-NEXT:    bge a1, a3, .LBB33_14
; CHECK-NOV-NEXT:  .LBB33_5: # %entry
; CHECK-NOV-NEXT:    bge a1, a2, .LBB33_15
; CHECK-NOV-NEXT:  .LBB33_6: # %entry
; CHECK-NOV-NEXT:    bge a1, s2, .LBB33_16
; CHECK-NOV-NEXT:  .LBB33_7: # %entry
; CHECK-NOV-NEXT:    blt a1, a0, .LBB33_9
; CHECK-NOV-NEXT:  .LBB33_8: # %entry
; CHECK-NOV-NEXT:    lui a0, 524288
; CHECK-NOV-NEXT:  .LBB33_9: # %entry
; CHECK-NOV-NEXT:    sw a0, 12(s0)
; CHECK-NOV-NEXT:    sw s2, 8(s0)
; CHECK-NOV-NEXT:    sw a2, 4(s0)
; CHECK-NOV-NEXT:    sw a3, 0(s0)
; CHECK-NOV-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s3, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs2, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 64
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB33_10: # %entry
; CHECK-NOV-NEXT:    mv a0, a4
; CHECK-NOV-NEXT:    fcvt.l.s a2, fs1, rtz
; CHECK-NOV-NEXT:    blt s2, a4, .LBB33_2
; CHECK-NOV-NEXT:  .LBB33_11: # %entry
; CHECK-NOV-NEXT:    mv s2, a4
; CHECK-NOV-NEXT:    fcvt.l.s a3, fs0, rtz
; CHECK-NOV-NEXT:    blt a2, a4, .LBB33_3
; CHECK-NOV-NEXT:  .LBB33_12: # %entry
; CHECK-NOV-NEXT:    mv a2, a4
; CHECK-NOV-NEXT:    blt a3, a4, .LBB33_4
; CHECK-NOV-NEXT:  .LBB33_13: # %entry
; CHECK-NOV-NEXT:    mv a3, a4
; CHECK-NOV-NEXT:    blt a1, a3, .LBB33_5
; CHECK-NOV-NEXT:  .LBB33_14: # %entry
; CHECK-NOV-NEXT:    lui a3, 524288
; CHECK-NOV-NEXT:    blt a1, a2, .LBB33_6
; CHECK-NOV-NEXT:  .LBB33_15: # %entry
; CHECK-NOV-NEXT:    lui a2, 524288
; CHECK-NOV-NEXT:    blt a1, s2, .LBB33_7
; CHECK-NOV-NEXT:  .LBB33_16: # %entry
; CHECK-NOV-NEXT:    lui s2, 524288
; CHECK-NOV-NEXT:    bge a1, a0, .LBB33_8
; CHECK-NOV-NEXT:    j .LBB33_9
;
; CHECK-V-LABEL: stest_f16i32_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -64
; CHECK-V-NEXT:    .cfi_def_cfa_offset 64
; CHECK-V-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    .cfi_offset s2, -32
; CHECK-V-NEXT:    lhu s0, 24(a0)
; CHECK-V-NEXT:    lhu s1, 16(a0)
; CHECK-V-NEXT:    lhu s2, 0(a0)
; CHECK-V-NEXT:    lhu a0, 8(a0)
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 24(sp)
; CHECK-V-NEXT:    mv a0, s2
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 0(sp)
; CHECK-V-NEXT:    mv a0, s1
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 16(sp)
; CHECK-V-NEXT:    mv a0, s0
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 8(sp)
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    mv a0, sp
; CHECK-V-NEXT:    vle64.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v10, v8, 1
; CHECK-V-NEXT:    addi a0, sp, 16
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 3, e64, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v10, v8, 2
; CHECK-V-NEXT:    addi a0, sp, 8
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 4, e64, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v10, v8, 3
; CHECK-V-NEXT:    lui a0, 524288
; CHECK-V-NEXT:    addiw a1, a0, -1
; CHECK-V-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-V-NEXT:    vmin.vx v8, v10, a1
; CHECK-V-NEXT:    vmax.vx v10, v8, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-V-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 64
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utesth_f16i32_mm(<4 x half> %x) {
; CHECK-NOV-LABEL: utesth_f16i32_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -64
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NOV-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s3, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs2, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset s2, -32
; CHECK-NOV-NEXT:    .cfi_offset s3, -40
; CHECK-NOV-NEXT:    .cfi_offset fs0, -48
; CHECK-NOV-NEXT:    .cfi_offset fs1, -56
; CHECK-NOV-NEXT:    .cfi_offset fs2, -64
; CHECK-NOV-NEXT:    lhu s1, 0(a1)
; CHECK-NOV-NEXT:    lhu s2, 24(a1)
; CHECK-NOV-NEXT:    lhu s3, 16(a1)
; CHECK-NOV-NEXT:    lhu a1, 8(a1)
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs2, fa0
; CHECK-NOV-NEXT:    mv a0, s3
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs1, fa0
; CHECK-NOV-NEXT:    mv a0, s2
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs0, fa0
; CHECK-NOV-NEXT:    fcvt.lu.s s2, fs2, rtz
; CHECK-NOV-NEXT:    mv a0, s1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-NOV-NEXT:    li a1, -1
; CHECK-NOV-NEXT:    srli a1, a1, 32
; CHECK-NOV-NEXT:    bgeu a0, a1, .LBB34_6
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a2, fs1, rtz
; CHECK-NOV-NEXT:    bgeu s2, a1, .LBB34_7
; CHECK-NOV-NEXT:  .LBB34_2: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a3, fs0, rtz
; CHECK-NOV-NEXT:    bgeu a2, a1, .LBB34_8
; CHECK-NOV-NEXT:  .LBB34_3: # %entry
; CHECK-NOV-NEXT:    bltu a3, a1, .LBB34_5
; CHECK-NOV-NEXT:  .LBB34_4: # %entry
; CHECK-NOV-NEXT:    mv a3, a1
; CHECK-NOV-NEXT:  .LBB34_5: # %entry
; CHECK-NOV-NEXT:    sw a3, 12(s0)
; CHECK-NOV-NEXT:    sw a2, 8(s0)
; CHECK-NOV-NEXT:    sw s2, 4(s0)
; CHECK-NOV-NEXT:    sw a0, 0(s0)
; CHECK-NOV-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s3, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs2, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 64
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB34_6: # %entry
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:    fcvt.lu.s a2, fs1, rtz
; CHECK-NOV-NEXT:    bltu s2, a1, .LBB34_2
; CHECK-NOV-NEXT:  .LBB34_7: # %entry
; CHECK-NOV-NEXT:    mv s2, a1
; CHECK-NOV-NEXT:    fcvt.lu.s a3, fs0, rtz
; CHECK-NOV-NEXT:    bltu a2, a1, .LBB34_3
; CHECK-NOV-NEXT:  .LBB34_8: # %entry
; CHECK-NOV-NEXT:    mv a2, a1
; CHECK-NOV-NEXT:    bgeu a3, a1, .LBB34_4
; CHECK-NOV-NEXT:    j .LBB34_5
;
; CHECK-V-LABEL: utesth_f16i32_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -64
; CHECK-V-NEXT:    .cfi_def_cfa_offset 64
; CHECK-V-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    .cfi_offset s2, -32
; CHECK-V-NEXT:    lhu s0, 24(a0)
; CHECK-V-NEXT:    lhu s1, 16(a0)
; CHECK-V-NEXT:    lhu s2, 0(a0)
; CHECK-V-NEXT:    lhu a0, 8(a0)
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 24(sp)
; CHECK-V-NEXT:    mv a0, s2
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 0(sp)
; CHECK-V-NEXT:    mv a0, s1
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 16(sp)
; CHECK-V-NEXT:    mv a0, s0
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 8(sp)
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    mv a0, sp
; CHECK-V-NEXT:    vle64.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v10, v8, 1
; CHECK-V-NEXT:    addi a0, sp, 16
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 3, e64, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v10, v8, 2
; CHECK-V-NEXT:    addi a0, sp, 8
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 4, e64, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v10, v8, 3
; CHECK-V-NEXT:    li a0, -1
; CHECK-V-NEXT:    srli a0, a0, 32
; CHECK-V-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-V-NEXT:    vminu.vx v10, v10, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-V-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 64
; CHECK-V-NEXT:    ret
entry:
  %conv = fptoui <4 x half> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.umin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f16i32_mm(<4 x half> %x) {
; CHECK-NOV-LABEL: ustest_f16i32_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -64
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NOV-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s3, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs2, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset s2, -32
; CHECK-NOV-NEXT:    .cfi_offset s3, -40
; CHECK-NOV-NEXT:    .cfi_offset fs0, -48
; CHECK-NOV-NEXT:    .cfi_offset fs1, -56
; CHECK-NOV-NEXT:    .cfi_offset fs2, -64
; CHECK-NOV-NEXT:    lhu s1, 24(a1)
; CHECK-NOV-NEXT:    lhu s2, 0(a1)
; CHECK-NOV-NEXT:    lhu s3, 8(a1)
; CHECK-NOV-NEXT:    lhu a1, 16(a1)
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs2, fa0
; CHECK-NOV-NEXT:    mv a0, s3
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs1, fa0
; CHECK-NOV-NEXT:    mv a0, s2
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs0, fa0
; CHECK-NOV-NEXT:    fcvt.l.s s2, fs2, rtz
; CHECK-NOV-NEXT:    mv a0, s1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-NOV-NEXT:    li a1, -1
; CHECK-NOV-NEXT:    srli a2, a1, 32
; CHECK-NOV-NEXT:    bge a0, a2, .LBB35_6
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a1, fs1, rtz
; CHECK-NOV-NEXT:    bge s2, a2, .LBB35_7
; CHECK-NOV-NEXT:  .LBB35_2: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a3, fs0, rtz
; CHECK-NOV-NEXT:    bge a1, a2, .LBB35_8
; CHECK-NOV-NEXT:  .LBB35_3: # %entry
; CHECK-NOV-NEXT:    blt a3, a2, .LBB35_5
; CHECK-NOV-NEXT:  .LBB35_4: # %entry
; CHECK-NOV-NEXT:    mv a3, a2
; CHECK-NOV-NEXT:  .LBB35_5: # %entry
; CHECK-NOV-NEXT:    sgtz a2, a3
; CHECK-NOV-NEXT:    neg a2, a2
; CHECK-NOV-NEXT:    and a2, a2, a3
; CHECK-NOV-NEXT:    sgtz a3, a1
; CHECK-NOV-NEXT:    neg a3, a3
; CHECK-NOV-NEXT:    and a1, a3, a1
; CHECK-NOV-NEXT:    sgtz a3, s2
; CHECK-NOV-NEXT:    neg a3, a3
; CHECK-NOV-NEXT:    and a3, a3, s2
; CHECK-NOV-NEXT:    sgtz a4, a0
; CHECK-NOV-NEXT:    neg a4, a4
; CHECK-NOV-NEXT:    and a0, a4, a0
; CHECK-NOV-NEXT:    sw a0, 12(s0)
; CHECK-NOV-NEXT:    sw a3, 8(s0)
; CHECK-NOV-NEXT:    sw a1, 4(s0)
; CHECK-NOV-NEXT:    sw a2, 0(s0)
; CHECK-NOV-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s3, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs2, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 64
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB35_6: # %entry
; CHECK-NOV-NEXT:    mv a0, a2
; CHECK-NOV-NEXT:    fcvt.l.s a1, fs1, rtz
; CHECK-NOV-NEXT:    blt s2, a2, .LBB35_2
; CHECK-NOV-NEXT:  .LBB35_7: # %entry
; CHECK-NOV-NEXT:    mv s2, a2
; CHECK-NOV-NEXT:    fcvt.l.s a3, fs0, rtz
; CHECK-NOV-NEXT:    blt a1, a2, .LBB35_3
; CHECK-NOV-NEXT:  .LBB35_8: # %entry
; CHECK-NOV-NEXT:    mv a1, a2
; CHECK-NOV-NEXT:    bge a3, a2, .LBB35_4
; CHECK-NOV-NEXT:    j .LBB35_5
;
; CHECK-V-LABEL: ustest_f16i32_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -64
; CHECK-V-NEXT:    .cfi_def_cfa_offset 64
; CHECK-V-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    .cfi_offset s2, -32
; CHECK-V-NEXT:    lhu s0, 24(a0)
; CHECK-V-NEXT:    lhu s1, 16(a0)
; CHECK-V-NEXT:    lhu s2, 0(a0)
; CHECK-V-NEXT:    lhu a0, 8(a0)
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 24(sp)
; CHECK-V-NEXT:    mv a0, s2
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 0(sp)
; CHECK-V-NEXT:    mv a0, s1
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 16(sp)
; CHECK-V-NEXT:    mv a0, s0
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sd a0, 8(sp)
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    mv a0, sp
; CHECK-V-NEXT:    vle64.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v10, v8, 1
; CHECK-V-NEXT:    addi a0, sp, 16
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 3, e64, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v10, v8, 2
; CHECK-V-NEXT:    addi a0, sp, 8
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 4, e64, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v10, v8, 3
; CHECK-V-NEXT:    li a0, -1
; CHECK-V-NEXT:    srli a0, a0, 32
; CHECK-V-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-V-NEXT:    vmin.vx v8, v10, a0
; CHECK-V-NEXT:    vmax.vx v10, v8, zero
; CHECK-V-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-V-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 64
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> zeroinitializer)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

; i16 saturate

define <2 x i16> @stest_f64i16_mm(<2 x double> %x) {
; CHECK-NOV-LABEL: stest_f64i16_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.w.d a1, fa1, rtz
; CHECK-NOV-NEXT:    lui a0, 8
; CHECK-NOV-NEXT:    addiw a2, a0, -1
; CHECK-NOV-NEXT:    fcvt.w.d a0, fa0, rtz
; CHECK-NOV-NEXT:    bge a1, a2, .LBB36_5
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    bge a0, a2, .LBB36_6
; CHECK-NOV-NEXT:  .LBB36_2: # %entry
; CHECK-NOV-NEXT:    lui a2, 1048568
; CHECK-NOV-NEXT:    bge a2, a0, .LBB36_7
; CHECK-NOV-NEXT:  .LBB36_3: # %entry
; CHECK-NOV-NEXT:    bge a2, a1, .LBB36_8
; CHECK-NOV-NEXT:  .LBB36_4: # %entry
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB36_5: # %entry
; CHECK-NOV-NEXT:    mv a1, a2
; CHECK-NOV-NEXT:    blt a0, a2, .LBB36_2
; CHECK-NOV-NEXT:  .LBB36_6: # %entry
; CHECK-NOV-NEXT:    mv a0, a2
; CHECK-NOV-NEXT:    lui a2, 1048568
; CHECK-NOV-NEXT:    blt a2, a0, .LBB36_3
; CHECK-NOV-NEXT:  .LBB36_7: # %entry
; CHECK-NOV-NEXT:    lui a0, 1048568
; CHECK-NOV-NEXT:    blt a2, a1, .LBB36_4
; CHECK-NOV-NEXT:  .LBB36_8: # %entry
; CHECK-NOV-NEXT:    lui a1, 1048568
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: stest_f64i16_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-V-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-V-NEXT:    lui a0, 8
; CHECK-V-NEXT:    addiw a0, a0, -1
; CHECK-V-NEXT:    vmin.vx v8, v9, a0
; CHECK-V-NEXT:    lui a0, 1048568
; CHECK-V-NEXT:    vmax.vx v8, v8, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %spec.store.select = call <2 x i32> @llvm.smin.v2i32(<2 x i32> %conv, <2 x i32> <i32 32767, i32 32767>)
  %spec.store.select7 = call <2 x i32> @llvm.smax.v2i32(<2 x i32> %spec.store.select, <2 x i32> <i32 -32768, i32 -32768>)
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @utest_f64i16_mm(<2 x double> %x) {
; CHECK-NOV-LABEL: utest_f64i16_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.wu.d a0, fa0, rtz
; CHECK-NOV-NEXT:    lui a1, 16
; CHECK-NOV-NEXT:    addiw a2, a1, -1
; CHECK-NOV-NEXT:    fcvt.wu.d a1, fa1, rtz
; CHECK-NOV-NEXT:    bgeu a0, a2, .LBB37_3
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    bgeu a1, a2, .LBB37_4
; CHECK-NOV-NEXT:  .LBB37_2: # %entry
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB37_3: # %entry
; CHECK-NOV-NEXT:    mv a0, a2
; CHECK-NOV-NEXT:    bltu a1, a2, .LBB37_2
; CHECK-NOV-NEXT:  .LBB37_4: # %entry
; CHECK-NOV-NEXT:    mv a1, a2
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: utest_f64i16_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-V-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-V-NEXT:    lui a0, 16
; CHECK-V-NEXT:    addiw a0, a0, -1
; CHECK-V-NEXT:    vminu.vx v8, v9, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptoui <2 x double> %x to <2 x i32>
  %spec.store.select = call <2 x i32> @llvm.umin.v2i32(<2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>)
  %conv6 = trunc <2 x i32> %spec.store.select to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @ustest_f64i16_mm(<2 x double> %x) {
; CHECK-NOV-LABEL: ustest_f64i16_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.w.d a1, fa1, rtz
; CHECK-NOV-NEXT:    lui a0, 16
; CHECK-NOV-NEXT:    addiw a2, a0, -1
; CHECK-NOV-NEXT:    fcvt.w.d a0, fa0, rtz
; CHECK-NOV-NEXT:    blt a1, a2, .LBB38_2
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    mv a1, a2
; CHECK-NOV-NEXT:  .LBB38_2: # %entry
; CHECK-NOV-NEXT:    blt a0, a2, .LBB38_4
; CHECK-NOV-NEXT:  # %bb.3: # %entry
; CHECK-NOV-NEXT:    mv a0, a2
; CHECK-NOV-NEXT:  .LBB38_4: # %entry
; CHECK-NOV-NEXT:    sgtz a2, a0
; CHECK-NOV-NEXT:    neg a2, a2
; CHECK-NOV-NEXT:    and a0, a2, a0
; CHECK-NOV-NEXT:    sgtz a2, a1
; CHECK-NOV-NEXT:    neg a2, a2
; CHECK-NOV-NEXT:    and a1, a2, a1
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: ustest_f64i16_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-V-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-V-NEXT:    lui a0, 16
; CHECK-V-NEXT:    addiw a0, a0, -1
; CHECK-V-NEXT:    vmin.vx v8, v9, a0
; CHECK-V-NEXT:    vmax.vx v8, v8, zero
; CHECK-V-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %spec.store.select = call <2 x i32> @llvm.smin.v2i32(<2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>)
  %spec.store.select7 = call <2 x i32> @llvm.smax.v2i32(<2 x i32> %spec.store.select, <2 x i32> zeroinitializer)
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <4 x i16> @stest_f32i16_mm(<4 x float> %x) {
; CHECK-NOV-LABEL: stest_f32i16_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.w.s a1, fa3, rtz
; CHECK-NOV-NEXT:    lui a2, 8
; CHECK-NOV-NEXT:    addiw a5, a2, -1
; CHECK-NOV-NEXT:    fcvt.w.s a2, fa2, rtz
; CHECK-NOV-NEXT:    bge a1, a5, .LBB39_10
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.w.s a3, fa1, rtz
; CHECK-NOV-NEXT:    bge a2, a5, .LBB39_11
; CHECK-NOV-NEXT:  .LBB39_2: # %entry
; CHECK-NOV-NEXT:    fcvt.w.s a4, fa0, rtz
; CHECK-NOV-NEXT:    bge a3, a5, .LBB39_12
; CHECK-NOV-NEXT:  .LBB39_3: # %entry
; CHECK-NOV-NEXT:    bge a4, a5, .LBB39_13
; CHECK-NOV-NEXT:  .LBB39_4: # %entry
; CHECK-NOV-NEXT:    lui a5, 1048568
; CHECK-NOV-NEXT:    bge a5, a4, .LBB39_14
; CHECK-NOV-NEXT:  .LBB39_5: # %entry
; CHECK-NOV-NEXT:    bge a5, a3, .LBB39_15
; CHECK-NOV-NEXT:  .LBB39_6: # %entry
; CHECK-NOV-NEXT:    bge a5, a2, .LBB39_16
; CHECK-NOV-NEXT:  .LBB39_7: # %entry
; CHECK-NOV-NEXT:    blt a5, a1, .LBB39_9
; CHECK-NOV-NEXT:  .LBB39_8: # %entry
; CHECK-NOV-NEXT:    lui a1, 1048568
; CHECK-NOV-NEXT:  .LBB39_9: # %entry
; CHECK-NOV-NEXT:    sh a1, 6(a0)
; CHECK-NOV-NEXT:    sh a2, 4(a0)
; CHECK-NOV-NEXT:    sh a3, 2(a0)
; CHECK-NOV-NEXT:    sh a4, 0(a0)
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB39_10: # %entry
; CHECK-NOV-NEXT:    mv a1, a5
; CHECK-NOV-NEXT:    fcvt.w.s a3, fa1, rtz
; CHECK-NOV-NEXT:    blt a2, a5, .LBB39_2
; CHECK-NOV-NEXT:  .LBB39_11: # %entry
; CHECK-NOV-NEXT:    mv a2, a5
; CHECK-NOV-NEXT:    fcvt.w.s a4, fa0, rtz
; CHECK-NOV-NEXT:    blt a3, a5, .LBB39_3
; CHECK-NOV-NEXT:  .LBB39_12: # %entry
; CHECK-NOV-NEXT:    mv a3, a5
; CHECK-NOV-NEXT:    blt a4, a5, .LBB39_4
; CHECK-NOV-NEXT:  .LBB39_13: # %entry
; CHECK-NOV-NEXT:    mv a4, a5
; CHECK-NOV-NEXT:    lui a5, 1048568
; CHECK-NOV-NEXT:    blt a5, a4, .LBB39_5
; CHECK-NOV-NEXT:  .LBB39_14: # %entry
; CHECK-NOV-NEXT:    lui a4, 1048568
; CHECK-NOV-NEXT:    blt a5, a3, .LBB39_6
; CHECK-NOV-NEXT:  .LBB39_15: # %entry
; CHECK-NOV-NEXT:    lui a3, 1048568
; CHECK-NOV-NEXT:    blt a5, a2, .LBB39_7
; CHECK-NOV-NEXT:  .LBB39_16: # %entry
; CHECK-NOV-NEXT:    lui a2, 1048568
; CHECK-NOV-NEXT:    bge a5, a1, .LBB39_8
; CHECK-NOV-NEXT:    j .LBB39_9
;
; CHECK-V-LABEL: stest_f32i16_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-V-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-V-NEXT:    lui a0, 8
; CHECK-V-NEXT:    addiw a0, a0, -1
; CHECK-V-NEXT:    vmin.vx v8, v8, a0
; CHECK-V-NEXT:    lui a0, 1048568
; CHECK-V-NEXT:    vmax.vx v8, v8, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %spec.store.select = call <4 x i32> @llvm.smin.v4i32(<4 x i32> %conv, <4 x i32> <i32 32767, i32 32767, i32 32767, i32 32767>)
  %spec.store.select7 = call <4 x i32> @llvm.smax.v4i32(<4 x i32> %spec.store.select, <4 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768>)
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @utest_f32i16_mm(<4 x float> %x) {
; CHECK-NOV-LABEL: utest_f32i16_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.wu.s a1, fa0, rtz
; CHECK-NOV-NEXT:    lui a2, 16
; CHECK-NOV-NEXT:    addiw a3, a2, -1
; CHECK-NOV-NEXT:    fcvt.wu.s a2, fa1, rtz
; CHECK-NOV-NEXT:    bgeu a1, a3, .LBB40_6
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.wu.s a4, fa2, rtz
; CHECK-NOV-NEXT:    bgeu a2, a3, .LBB40_7
; CHECK-NOV-NEXT:  .LBB40_2: # %entry
; CHECK-NOV-NEXT:    fcvt.wu.s a5, fa3, rtz
; CHECK-NOV-NEXT:    bgeu a4, a3, .LBB40_8
; CHECK-NOV-NEXT:  .LBB40_3: # %entry
; CHECK-NOV-NEXT:    bltu a5, a3, .LBB40_5
; CHECK-NOV-NEXT:  .LBB40_4: # %entry
; CHECK-NOV-NEXT:    mv a5, a3
; CHECK-NOV-NEXT:  .LBB40_5: # %entry
; CHECK-NOV-NEXT:    sh a5, 6(a0)
; CHECK-NOV-NEXT:    sh a4, 4(a0)
; CHECK-NOV-NEXT:    sh a2, 2(a0)
; CHECK-NOV-NEXT:    sh a1, 0(a0)
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB40_6: # %entry
; CHECK-NOV-NEXT:    mv a1, a3
; CHECK-NOV-NEXT:    fcvt.wu.s a4, fa2, rtz
; CHECK-NOV-NEXT:    bltu a2, a3, .LBB40_2
; CHECK-NOV-NEXT:  .LBB40_7: # %entry
; CHECK-NOV-NEXT:    mv a2, a3
; CHECK-NOV-NEXT:    fcvt.wu.s a5, fa3, rtz
; CHECK-NOV-NEXT:    bltu a4, a3, .LBB40_3
; CHECK-NOV-NEXT:  .LBB40_8: # %entry
; CHECK-NOV-NEXT:    mv a4, a3
; CHECK-NOV-NEXT:    bgeu a5, a3, .LBB40_4
; CHECK-NOV-NEXT:    j .LBB40_5
;
; CHECK-V-LABEL: utest_f32i16_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-V-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-V-NEXT:    lui a0, 16
; CHECK-V-NEXT:    addiw a0, a0, -1
; CHECK-V-NEXT:    vminu.vx v8, v8, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptoui <4 x float> %x to <4 x i32>
  %spec.store.select = call <4 x i32> @llvm.umin.v4i32(<4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>)
  %conv6 = trunc <4 x i32> %spec.store.select to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @ustest_f32i16_mm(<4 x float> %x) {
; CHECK-NOV-LABEL: ustest_f32i16_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    fcvt.w.s a1, fa3, rtz
; CHECK-NOV-NEXT:    lui a2, 16
; CHECK-NOV-NEXT:    addiw a4, a2, -1
; CHECK-NOV-NEXT:    fcvt.w.s a2, fa2, rtz
; CHECK-NOV-NEXT:    bge a1, a4, .LBB41_6
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.w.s a3, fa1, rtz
; CHECK-NOV-NEXT:    bge a2, a4, .LBB41_7
; CHECK-NOV-NEXT:  .LBB41_2: # %entry
; CHECK-NOV-NEXT:    fcvt.w.s a5, fa0, rtz
; CHECK-NOV-NEXT:    bge a3, a4, .LBB41_8
; CHECK-NOV-NEXT:  .LBB41_3: # %entry
; CHECK-NOV-NEXT:    blt a5, a4, .LBB41_5
; CHECK-NOV-NEXT:  .LBB41_4: # %entry
; CHECK-NOV-NEXT:    mv a5, a4
; CHECK-NOV-NEXT:  .LBB41_5: # %entry
; CHECK-NOV-NEXT:    sgtz a4, a5
; CHECK-NOV-NEXT:    neg a4, a4
; CHECK-NOV-NEXT:    and a4, a4, a5
; CHECK-NOV-NEXT:    sgtz a5, a3
; CHECK-NOV-NEXT:    neg a5, a5
; CHECK-NOV-NEXT:    and a3, a5, a3
; CHECK-NOV-NEXT:    sgtz a5, a2
; CHECK-NOV-NEXT:    neg a5, a5
; CHECK-NOV-NEXT:    and a2, a5, a2
; CHECK-NOV-NEXT:    sgtz a5, a1
; CHECK-NOV-NEXT:    neg a5, a5
; CHECK-NOV-NEXT:    and a1, a5, a1
; CHECK-NOV-NEXT:    sh a1, 6(a0)
; CHECK-NOV-NEXT:    sh a2, 4(a0)
; CHECK-NOV-NEXT:    sh a3, 2(a0)
; CHECK-NOV-NEXT:    sh a4, 0(a0)
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB41_6: # %entry
; CHECK-NOV-NEXT:    mv a1, a4
; CHECK-NOV-NEXT:    fcvt.w.s a3, fa1, rtz
; CHECK-NOV-NEXT:    blt a2, a4, .LBB41_2
; CHECK-NOV-NEXT:  .LBB41_7: # %entry
; CHECK-NOV-NEXT:    mv a2, a4
; CHECK-NOV-NEXT:    fcvt.w.s a5, fa0, rtz
; CHECK-NOV-NEXT:    blt a3, a4, .LBB41_3
; CHECK-NOV-NEXT:  .LBB41_8: # %entry
; CHECK-NOV-NEXT:    mv a3, a4
; CHECK-NOV-NEXT:    bge a5, a4, .LBB41_4
; CHECK-NOV-NEXT:    j .LBB41_5
;
; CHECK-V-LABEL: ustest_f32i16_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-V-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-V-NEXT:    lui a0, 16
; CHECK-V-NEXT:    addiw a0, a0, -1
; CHECK-V-NEXT:    vmin.vx v8, v8, a0
; CHECK-V-NEXT:    vmax.vx v8, v8, zero
; CHECK-V-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %spec.store.select = call <4 x i32> @llvm.smin.v4i32(<4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>)
  %spec.store.select7 = call <4 x i32> @llvm.smax.v4i32(<4 x i32> %spec.store.select, <4 x i32> zeroinitializer)
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <8 x i16> @stest_f16i16_mm(<8 x half> %x) {
; CHECK-NOV-LABEL: stest_f16i16_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -128
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 128
; CHECK-NOV-NEXT:    sd ra, 120(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 112(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 104(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s2, 96(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s3, 88(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s4, 80(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s5, 72(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s6, 64(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s7, 56(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 48(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs1, 40(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs2, 32(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs3, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs4, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs5, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs6, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset s2, -32
; CHECK-NOV-NEXT:    .cfi_offset s3, -40
; CHECK-NOV-NEXT:    .cfi_offset s4, -48
; CHECK-NOV-NEXT:    .cfi_offset s5, -56
; CHECK-NOV-NEXT:    .cfi_offset s6, -64
; CHECK-NOV-NEXT:    .cfi_offset s7, -72
; CHECK-NOV-NEXT:    .cfi_offset fs0, -80
; CHECK-NOV-NEXT:    .cfi_offset fs1, -88
; CHECK-NOV-NEXT:    .cfi_offset fs2, -96
; CHECK-NOV-NEXT:    .cfi_offset fs3, -104
; CHECK-NOV-NEXT:    .cfi_offset fs4, -112
; CHECK-NOV-NEXT:    .cfi_offset fs5, -120
; CHECK-NOV-NEXT:    .cfi_offset fs6, -128
; CHECK-NOV-NEXT:    lhu s1, 56(a1)
; CHECK-NOV-NEXT:    lhu s2, 0(a1)
; CHECK-NOV-NEXT:    lhu s3, 8(a1)
; CHECK-NOV-NEXT:    lhu s4, 16(a1)
; CHECK-NOV-NEXT:    lhu s5, 24(a1)
; CHECK-NOV-NEXT:    lhu s6, 32(a1)
; CHECK-NOV-NEXT:    lhu s7, 40(a1)
; CHECK-NOV-NEXT:    lhu a1, 48(a1)
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs6, fa0
; CHECK-NOV-NEXT:    mv a0, s7
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs5, fa0
; CHECK-NOV-NEXT:    mv a0, s6
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs4, fa0
; CHECK-NOV-NEXT:    mv a0, s5
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs3, fa0
; CHECK-NOV-NEXT:    mv a0, s4
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs2, fa0
; CHECK-NOV-NEXT:    mv a0, s3
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs1, fa0
; CHECK-NOV-NEXT:    mv a0, s2
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs0, fa0
; CHECK-NOV-NEXT:    fcvt.l.s s2, fs6, rtz
; CHECK-NOV-NEXT:    mv a0, s1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-NOV-NEXT:    lui a1, 8
; CHECK-NOV-NEXT:    addiw a7, a1, -1
; CHECK-NOV-NEXT:    bge a0, a7, .LBB42_18
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a1, fs5, rtz
; CHECK-NOV-NEXT:    bge s2, a7, .LBB42_19
; CHECK-NOV-NEXT:  .LBB42_2: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a2, fs4, rtz
; CHECK-NOV-NEXT:    bge a1, a7, .LBB42_20
; CHECK-NOV-NEXT:  .LBB42_3: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a3, fs3, rtz
; CHECK-NOV-NEXT:    bge a2, a7, .LBB42_21
; CHECK-NOV-NEXT:  .LBB42_4: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a4, fs2, rtz
; CHECK-NOV-NEXT:    bge a3, a7, .LBB42_22
; CHECK-NOV-NEXT:  .LBB42_5: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a5, fs1, rtz
; CHECK-NOV-NEXT:    bge a4, a7, .LBB42_23
; CHECK-NOV-NEXT:  .LBB42_6: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a6, fs0, rtz
; CHECK-NOV-NEXT:    bge a5, a7, .LBB42_24
; CHECK-NOV-NEXT:  .LBB42_7: # %entry
; CHECK-NOV-NEXT:    bge a6, a7, .LBB42_25
; CHECK-NOV-NEXT:  .LBB42_8: # %entry
; CHECK-NOV-NEXT:    lui a7, 1048568
; CHECK-NOV-NEXT:    bge a7, a6, .LBB42_26
; CHECK-NOV-NEXT:  .LBB42_9: # %entry
; CHECK-NOV-NEXT:    bge a7, a5, .LBB42_27
; CHECK-NOV-NEXT:  .LBB42_10: # %entry
; CHECK-NOV-NEXT:    bge a7, a4, .LBB42_28
; CHECK-NOV-NEXT:  .LBB42_11: # %entry
; CHECK-NOV-NEXT:    bge a7, a3, .LBB42_29
; CHECK-NOV-NEXT:  .LBB42_12: # %entry
; CHECK-NOV-NEXT:    bge a7, a2, .LBB42_30
; CHECK-NOV-NEXT:  .LBB42_13: # %entry
; CHECK-NOV-NEXT:    bge a7, a1, .LBB42_31
; CHECK-NOV-NEXT:  .LBB42_14: # %entry
; CHECK-NOV-NEXT:    bge a7, s2, .LBB42_32
; CHECK-NOV-NEXT:  .LBB42_15: # %entry
; CHECK-NOV-NEXT:    blt a7, a0, .LBB42_17
; CHECK-NOV-NEXT:  .LBB42_16: # %entry
; CHECK-NOV-NEXT:    lui a0, 1048568
; CHECK-NOV-NEXT:  .LBB42_17: # %entry
; CHECK-NOV-NEXT:    sh a0, 14(s0)
; CHECK-NOV-NEXT:    sh s2, 12(s0)
; CHECK-NOV-NEXT:    sh a1, 10(s0)
; CHECK-NOV-NEXT:    sh a2, 8(s0)
; CHECK-NOV-NEXT:    sh a3, 6(s0)
; CHECK-NOV-NEXT:    sh a4, 4(s0)
; CHECK-NOV-NEXT:    sh a5, 2(s0)
; CHECK-NOV-NEXT:    sh a6, 0(s0)
; CHECK-NOV-NEXT:    ld ra, 120(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 112(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 104(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s2, 96(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s3, 88(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s4, 80(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s5, 72(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s6, 64(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s7, 56(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 48(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs1, 40(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs2, 32(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs3, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs4, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs5, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs6, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 128
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB42_18: # %entry
; CHECK-NOV-NEXT:    mv a0, a7
; CHECK-NOV-NEXT:    fcvt.l.s a1, fs5, rtz
; CHECK-NOV-NEXT:    blt s2, a7, .LBB42_2
; CHECK-NOV-NEXT:  .LBB42_19: # %entry
; CHECK-NOV-NEXT:    mv s2, a7
; CHECK-NOV-NEXT:    fcvt.l.s a2, fs4, rtz
; CHECK-NOV-NEXT:    blt a1, a7, .LBB42_3
; CHECK-NOV-NEXT:  .LBB42_20: # %entry
; CHECK-NOV-NEXT:    mv a1, a7
; CHECK-NOV-NEXT:    fcvt.l.s a3, fs3, rtz
; CHECK-NOV-NEXT:    blt a2, a7, .LBB42_4
; CHECK-NOV-NEXT:  .LBB42_21: # %entry
; CHECK-NOV-NEXT:    mv a2, a7
; CHECK-NOV-NEXT:    fcvt.l.s a4, fs2, rtz
; CHECK-NOV-NEXT:    blt a3, a7, .LBB42_5
; CHECK-NOV-NEXT:  .LBB42_22: # %entry
; CHECK-NOV-NEXT:    mv a3, a7
; CHECK-NOV-NEXT:    fcvt.l.s a5, fs1, rtz
; CHECK-NOV-NEXT:    blt a4, a7, .LBB42_6
; CHECK-NOV-NEXT:  .LBB42_23: # %entry
; CHECK-NOV-NEXT:    mv a4, a7
; CHECK-NOV-NEXT:    fcvt.l.s a6, fs0, rtz
; CHECK-NOV-NEXT:    blt a5, a7, .LBB42_7
; CHECK-NOV-NEXT:  .LBB42_24: # %entry
; CHECK-NOV-NEXT:    mv a5, a7
; CHECK-NOV-NEXT:    blt a6, a7, .LBB42_8
; CHECK-NOV-NEXT:  .LBB42_25: # %entry
; CHECK-NOV-NEXT:    mv a6, a7
; CHECK-NOV-NEXT:    lui a7, 1048568
; CHECK-NOV-NEXT:    blt a7, a6, .LBB42_9
; CHECK-NOV-NEXT:  .LBB42_26: # %entry
; CHECK-NOV-NEXT:    lui a6, 1048568
; CHECK-NOV-NEXT:    blt a7, a5, .LBB42_10
; CHECK-NOV-NEXT:  .LBB42_27: # %entry
; CHECK-NOV-NEXT:    lui a5, 1048568
; CHECK-NOV-NEXT:    blt a7, a4, .LBB42_11
; CHECK-NOV-NEXT:  .LBB42_28: # %entry
; CHECK-NOV-NEXT:    lui a4, 1048568
; CHECK-NOV-NEXT:    blt a7, a3, .LBB42_12
; CHECK-NOV-NEXT:  .LBB42_29: # %entry
; CHECK-NOV-NEXT:    lui a3, 1048568
; CHECK-NOV-NEXT:    blt a7, a2, .LBB42_13
; CHECK-NOV-NEXT:  .LBB42_30: # %entry
; CHECK-NOV-NEXT:    lui a2, 1048568
; CHECK-NOV-NEXT:    blt a7, a1, .LBB42_14
; CHECK-NOV-NEXT:  .LBB42_31: # %entry
; CHECK-NOV-NEXT:    lui a1, 1048568
; CHECK-NOV-NEXT:    blt a7, s2, .LBB42_15
; CHECK-NOV-NEXT:  .LBB42_32: # %entry
; CHECK-NOV-NEXT:    lui s2, 1048568
; CHECK-NOV-NEXT:    bge a7, a0, .LBB42_16
; CHECK-NOV-NEXT:    j .LBB42_17
;
; CHECK-V-LABEL: stest_f16i16_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -96
; CHECK-V-NEXT:    .cfi_def_cfa_offset 96
; CHECK-V-NEXT:    sd ra, 88(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 80(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 72(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s2, 64(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s3, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s4, 48(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s5, 40(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s6, 32(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    .cfi_offset s2, -32
; CHECK-V-NEXT:    .cfi_offset s3, -40
; CHECK-V-NEXT:    .cfi_offset s4, -48
; CHECK-V-NEXT:    .cfi_offset s5, -56
; CHECK-V-NEXT:    .cfi_offset s6, -64
; CHECK-V-NEXT:    lhu s0, 56(a0)
; CHECK-V-NEXT:    lhu s1, 48(a0)
; CHECK-V-NEXT:    lhu s2, 40(a0)
; CHECK-V-NEXT:    lhu s3, 32(a0)
; CHECK-V-NEXT:    lhu s4, 24(a0)
; CHECK-V-NEXT:    lhu s5, 16(a0)
; CHECK-V-NEXT:    lhu s6, 0(a0)
; CHECK-V-NEXT:    lhu a0, 8(a0)
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 28(sp)
; CHECK-V-NEXT:    mv a0, s6
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 0(sp)
; CHECK-V-NEXT:    mv a0, s5
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 24(sp)
; CHECK-V-NEXT:    mv a0, s4
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 20(sp)
; CHECK-V-NEXT:    mv a0, s3
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 16(sp)
; CHECK-V-NEXT:    mv a0, s2
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 12(sp)
; CHECK-V-NEXT:    mv a0, s1
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 8(sp)
; CHECK-V-NEXT:    mv a0, s0
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 4(sp)
; CHECK-V-NEXT:    addi a0, sp, 28
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    mv a0, sp
; CHECK-V-NEXT:    vle32.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 1
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 3, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 2
; CHECK-V-NEXT:    addi a0, sp, 20
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 4, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 3
; CHECK-V-NEXT:    addi a0, sp, 16
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 5, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 4
; CHECK-V-NEXT:    addi a0, sp, 12
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 6, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 5
; CHECK-V-NEXT:    addi a0, sp, 8
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 7, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 6
; CHECK-V-NEXT:    addi a0, sp, 4
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 8, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 7
; CHECK-V-NEXT:    lui a0, 8
; CHECK-V-NEXT:    addiw a0, a0, -1
; CHECK-V-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-V-NEXT:    vmin.vx v8, v8, a0
; CHECK-V-NEXT:    lui a0, 1048568
; CHECK-V-NEXT:    vmax.vx v10, v8, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-V-NEXT:    ld ra, 88(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 80(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 72(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s2, 64(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s3, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s4, 48(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s5, 40(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s6, 32(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 96
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %spec.store.select = call <8 x i32> @llvm.smin.v8i32(<8 x i32> %conv, <8 x i32> <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>)
  %spec.store.select7 = call <8 x i32> @llvm.smax.v8i32(<8 x i32> %spec.store.select, <8 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>)
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @utesth_f16i16_mm(<8 x half> %x) {
; CHECK-NOV-LABEL: utesth_f16i16_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -128
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 128
; CHECK-NOV-NEXT:    sd ra, 120(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 112(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 104(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s2, 96(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s3, 88(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s4, 80(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s5, 72(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s6, 64(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s7, 56(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 48(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs1, 40(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs2, 32(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs3, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs4, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs5, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs6, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset s2, -32
; CHECK-NOV-NEXT:    .cfi_offset s3, -40
; CHECK-NOV-NEXT:    .cfi_offset s4, -48
; CHECK-NOV-NEXT:    .cfi_offset s5, -56
; CHECK-NOV-NEXT:    .cfi_offset s6, -64
; CHECK-NOV-NEXT:    .cfi_offset s7, -72
; CHECK-NOV-NEXT:    .cfi_offset fs0, -80
; CHECK-NOV-NEXT:    .cfi_offset fs1, -88
; CHECK-NOV-NEXT:    .cfi_offset fs2, -96
; CHECK-NOV-NEXT:    .cfi_offset fs3, -104
; CHECK-NOV-NEXT:    .cfi_offset fs4, -112
; CHECK-NOV-NEXT:    .cfi_offset fs5, -120
; CHECK-NOV-NEXT:    .cfi_offset fs6, -128
; CHECK-NOV-NEXT:    lhu s1, 0(a1)
; CHECK-NOV-NEXT:    lhu s2, 56(a1)
; CHECK-NOV-NEXT:    lhu s3, 48(a1)
; CHECK-NOV-NEXT:    lhu s4, 40(a1)
; CHECK-NOV-NEXT:    lhu s5, 32(a1)
; CHECK-NOV-NEXT:    lhu s6, 24(a1)
; CHECK-NOV-NEXT:    lhu s7, 16(a1)
; CHECK-NOV-NEXT:    lhu a1, 8(a1)
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs5, fa0
; CHECK-NOV-NEXT:    mv a0, s7
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs6, fa0
; CHECK-NOV-NEXT:    mv a0, s6
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs4, fa0
; CHECK-NOV-NEXT:    mv a0, s5
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs3, fa0
; CHECK-NOV-NEXT:    mv a0, s4
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs2, fa0
; CHECK-NOV-NEXT:    mv a0, s3
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs1, fa0
; CHECK-NOV-NEXT:    mv a0, s2
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs0, fa0
; CHECK-NOV-NEXT:    fcvt.lu.s s3, fs6, rtz
; CHECK-NOV-NEXT:    fcvt.lu.s a0, fs5, rtz
; CHECK-NOV-NEXT:    sext.w s2, a0
; CHECK-NOV-NEXT:    mv a0, s1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-NOV-NEXT:    sext.w a0, a0
; CHECK-NOV-NEXT:    lui a1, 16
; CHECK-NOV-NEXT:    addiw a1, a1, -1
; CHECK-NOV-NEXT:    bltu a0, a1, .LBB43_2
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:  .LBB43_2: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a3, fs4, rtz
; CHECK-NOV-NEXT:    sext.w a2, s3
; CHECK-NOV-NEXT:    bltu s2, a1, .LBB43_4
; CHECK-NOV-NEXT:  # %bb.3: # %entry
; CHECK-NOV-NEXT:    mv s2, a1
; CHECK-NOV-NEXT:  .LBB43_4: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a4, fs3, rtz
; CHECK-NOV-NEXT:    sext.w a3, a3
; CHECK-NOV-NEXT:    bltu a2, a1, .LBB43_6
; CHECK-NOV-NEXT:  # %bb.5: # %entry
; CHECK-NOV-NEXT:    mv a2, a1
; CHECK-NOV-NEXT:  .LBB43_6: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a5, fs2, rtz
; CHECK-NOV-NEXT:    sext.w a4, a4
; CHECK-NOV-NEXT:    bltu a3, a1, .LBB43_8
; CHECK-NOV-NEXT:  # %bb.7: # %entry
; CHECK-NOV-NEXT:    mv a3, a1
; CHECK-NOV-NEXT:  .LBB43_8: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a6, fs1, rtz
; CHECK-NOV-NEXT:    sext.w a5, a5
; CHECK-NOV-NEXT:    bltu a4, a1, .LBB43_10
; CHECK-NOV-NEXT:  # %bb.9: # %entry
; CHECK-NOV-NEXT:    mv a4, a1
; CHECK-NOV-NEXT:  .LBB43_10: # %entry
; CHECK-NOV-NEXT:    fcvt.lu.s a7, fs0, rtz
; CHECK-NOV-NEXT:    sext.w a6, a6
; CHECK-NOV-NEXT:    bgeu a5, a1, .LBB43_15
; CHECK-NOV-NEXT:  # %bb.11: # %entry
; CHECK-NOV-NEXT:    sext.w a7, a7
; CHECK-NOV-NEXT:    bgeu a6, a1, .LBB43_16
; CHECK-NOV-NEXT:  .LBB43_12: # %entry
; CHECK-NOV-NEXT:    bltu a7, a1, .LBB43_14
; CHECK-NOV-NEXT:  .LBB43_13: # %entry
; CHECK-NOV-NEXT:    mv a7, a1
; CHECK-NOV-NEXT:  .LBB43_14: # %entry
; CHECK-NOV-NEXT:    sh a7, 14(s0)
; CHECK-NOV-NEXT:    sh a6, 12(s0)
; CHECK-NOV-NEXT:    sh a5, 10(s0)
; CHECK-NOV-NEXT:    sh a4, 8(s0)
; CHECK-NOV-NEXT:    sh a3, 6(s0)
; CHECK-NOV-NEXT:    sh a2, 4(s0)
; CHECK-NOV-NEXT:    sh s2, 2(s0)
; CHECK-NOV-NEXT:    sh a0, 0(s0)
; CHECK-NOV-NEXT:    ld ra, 120(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 112(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 104(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s2, 96(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s3, 88(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s4, 80(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s5, 72(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s6, 64(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s7, 56(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 48(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs1, 40(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs2, 32(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs3, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs4, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs5, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs6, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 128
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB43_15: # %entry
; CHECK-NOV-NEXT:    mv a5, a1
; CHECK-NOV-NEXT:    sext.w a7, a7
; CHECK-NOV-NEXT:    bltu a6, a1, .LBB43_12
; CHECK-NOV-NEXT:  .LBB43_16: # %entry
; CHECK-NOV-NEXT:    mv a6, a1
; CHECK-NOV-NEXT:    bgeu a7, a1, .LBB43_13
; CHECK-NOV-NEXT:    j .LBB43_14
;
; CHECK-V-LABEL: utesth_f16i16_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -96
; CHECK-V-NEXT:    .cfi_def_cfa_offset 96
; CHECK-V-NEXT:    sd ra, 88(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 80(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 72(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s2, 64(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s3, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s4, 48(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s5, 40(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s6, 32(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    .cfi_offset s2, -32
; CHECK-V-NEXT:    .cfi_offset s3, -40
; CHECK-V-NEXT:    .cfi_offset s4, -48
; CHECK-V-NEXT:    .cfi_offset s5, -56
; CHECK-V-NEXT:    .cfi_offset s6, -64
; CHECK-V-NEXT:    lhu s0, 56(a0)
; CHECK-V-NEXT:    lhu s1, 48(a0)
; CHECK-V-NEXT:    lhu s2, 40(a0)
; CHECK-V-NEXT:    lhu s3, 32(a0)
; CHECK-V-NEXT:    lhu s4, 24(a0)
; CHECK-V-NEXT:    lhu s5, 16(a0)
; CHECK-V-NEXT:    lhu s6, 0(a0)
; CHECK-V-NEXT:    lhu a0, 8(a0)
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 28(sp)
; CHECK-V-NEXT:    mv a0, s6
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 0(sp)
; CHECK-V-NEXT:    mv a0, s5
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 24(sp)
; CHECK-V-NEXT:    mv a0, s4
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 20(sp)
; CHECK-V-NEXT:    mv a0, s3
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 16(sp)
; CHECK-V-NEXT:    mv a0, s2
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 12(sp)
; CHECK-V-NEXT:    mv a0, s1
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 8(sp)
; CHECK-V-NEXT:    mv a0, s0
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.lu.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 4(sp)
; CHECK-V-NEXT:    addi a0, sp, 28
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    mv a0, sp
; CHECK-V-NEXT:    vle32.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 1
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 3, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 2
; CHECK-V-NEXT:    addi a0, sp, 20
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 4, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 3
; CHECK-V-NEXT:    addi a0, sp, 16
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 5, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 4
; CHECK-V-NEXT:    addi a0, sp, 12
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 6, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 5
; CHECK-V-NEXT:    addi a0, sp, 8
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 7, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 6
; CHECK-V-NEXT:    addi a0, sp, 4
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 8, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 7
; CHECK-V-NEXT:    lui a0, 16
; CHECK-V-NEXT:    addiw a0, a0, -1
; CHECK-V-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-V-NEXT:    vminu.vx v10, v8, a0
; CHECK-V-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-V-NEXT:    ld ra, 88(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 80(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 72(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s2, 64(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s3, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s4, 48(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s5, 40(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s6, 32(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 96
; CHECK-V-NEXT:    ret
entry:
  %conv = fptoui <8 x half> %x to <8 x i32>
  %spec.store.select = call <8 x i32> @llvm.umin.v8i32(<8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>)
  %conv6 = trunc <8 x i32> %spec.store.select to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @ustest_f16i16_mm(<8 x half> %x) {
; CHECK-NOV-LABEL: ustest_f16i16_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -128
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 128
; CHECK-NOV-NEXT:    sd ra, 120(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 112(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 104(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s2, 96(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s3, 88(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s4, 80(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s5, 72(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s6, 64(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s7, 56(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 48(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs1, 40(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs2, 32(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs3, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs4, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs5, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs6, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset s2, -32
; CHECK-NOV-NEXT:    .cfi_offset s3, -40
; CHECK-NOV-NEXT:    .cfi_offset s4, -48
; CHECK-NOV-NEXT:    .cfi_offset s5, -56
; CHECK-NOV-NEXT:    .cfi_offset s6, -64
; CHECK-NOV-NEXT:    .cfi_offset s7, -72
; CHECK-NOV-NEXT:    .cfi_offset fs0, -80
; CHECK-NOV-NEXT:    .cfi_offset fs1, -88
; CHECK-NOV-NEXT:    .cfi_offset fs2, -96
; CHECK-NOV-NEXT:    .cfi_offset fs3, -104
; CHECK-NOV-NEXT:    .cfi_offset fs4, -112
; CHECK-NOV-NEXT:    .cfi_offset fs5, -120
; CHECK-NOV-NEXT:    .cfi_offset fs6, -128
; CHECK-NOV-NEXT:    lhu s1, 56(a1)
; CHECK-NOV-NEXT:    lhu s2, 0(a1)
; CHECK-NOV-NEXT:    lhu s3, 8(a1)
; CHECK-NOV-NEXT:    lhu s4, 16(a1)
; CHECK-NOV-NEXT:    lhu s5, 24(a1)
; CHECK-NOV-NEXT:    lhu s6, 32(a1)
; CHECK-NOV-NEXT:    lhu s7, 40(a1)
; CHECK-NOV-NEXT:    lhu a1, 48(a1)
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs6, fa0
; CHECK-NOV-NEXT:    mv a0, s7
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs5, fa0
; CHECK-NOV-NEXT:    mv a0, s6
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs4, fa0
; CHECK-NOV-NEXT:    mv a0, s5
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs3, fa0
; CHECK-NOV-NEXT:    mv a0, s4
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs2, fa0
; CHECK-NOV-NEXT:    mv a0, s3
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs1, fa0
; CHECK-NOV-NEXT:    mv a0, s2
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fmv.s fs0, fa0
; CHECK-NOV-NEXT:    fcvt.l.s s2, fs6, rtz
; CHECK-NOV-NEXT:    mv a0, s1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-NOV-NEXT:    lui a1, 16
; CHECK-NOV-NEXT:    addiw a3, a1, -1
; CHECK-NOV-NEXT:    bge a0, a3, .LBB44_10
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a1, fs5, rtz
; CHECK-NOV-NEXT:    bge s2, a3, .LBB44_11
; CHECK-NOV-NEXT:  .LBB44_2: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a2, fs4, rtz
; CHECK-NOV-NEXT:    bge a1, a3, .LBB44_12
; CHECK-NOV-NEXT:  .LBB44_3: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a4, fs3, rtz
; CHECK-NOV-NEXT:    bge a2, a3, .LBB44_13
; CHECK-NOV-NEXT:  .LBB44_4: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a5, fs2, rtz
; CHECK-NOV-NEXT:    bge a4, a3, .LBB44_14
; CHECK-NOV-NEXT:  .LBB44_5: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a6, fs1, rtz
; CHECK-NOV-NEXT:    bge a5, a3, .LBB44_15
; CHECK-NOV-NEXT:  .LBB44_6: # %entry
; CHECK-NOV-NEXT:    fcvt.l.s a7, fs0, rtz
; CHECK-NOV-NEXT:    bge a6, a3, .LBB44_16
; CHECK-NOV-NEXT:  .LBB44_7: # %entry
; CHECK-NOV-NEXT:    blt a7, a3, .LBB44_9
; CHECK-NOV-NEXT:  .LBB44_8: # %entry
; CHECK-NOV-NEXT:    mv a7, a3
; CHECK-NOV-NEXT:  .LBB44_9: # %entry
; CHECK-NOV-NEXT:    sgtz a3, a7
; CHECK-NOV-NEXT:    neg a3, a3
; CHECK-NOV-NEXT:    and a3, a3, a7
; CHECK-NOV-NEXT:    sgtz a7, a6
; CHECK-NOV-NEXT:    neg a7, a7
; CHECK-NOV-NEXT:    and a6, a7, a6
; CHECK-NOV-NEXT:    sgtz a7, a5
; CHECK-NOV-NEXT:    neg a7, a7
; CHECK-NOV-NEXT:    and a5, a7, a5
; CHECK-NOV-NEXT:    sgtz a7, a4
; CHECK-NOV-NEXT:    neg a7, a7
; CHECK-NOV-NEXT:    and a4, a7, a4
; CHECK-NOV-NEXT:    sgtz a7, a2
; CHECK-NOV-NEXT:    neg a7, a7
; CHECK-NOV-NEXT:    and a2, a7, a2
; CHECK-NOV-NEXT:    sgtz a7, a1
; CHECK-NOV-NEXT:    neg a7, a7
; CHECK-NOV-NEXT:    and a1, a7, a1
; CHECK-NOV-NEXT:    sgtz a7, s2
; CHECK-NOV-NEXT:    neg a7, a7
; CHECK-NOV-NEXT:    and a7, a7, s2
; CHECK-NOV-NEXT:    sgtz t0, a0
; CHECK-NOV-NEXT:    neg t0, t0
; CHECK-NOV-NEXT:    and a0, t0, a0
; CHECK-NOV-NEXT:    sh a0, 14(s0)
; CHECK-NOV-NEXT:    sh a7, 12(s0)
; CHECK-NOV-NEXT:    sh a1, 10(s0)
; CHECK-NOV-NEXT:    sh a2, 8(s0)
; CHECK-NOV-NEXT:    sh a4, 6(s0)
; CHECK-NOV-NEXT:    sh a5, 4(s0)
; CHECK-NOV-NEXT:    sh a6, 2(s0)
; CHECK-NOV-NEXT:    sh a3, 0(s0)
; CHECK-NOV-NEXT:    ld ra, 120(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 112(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 104(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s2, 96(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s3, 88(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s4, 80(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s5, 72(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s6, 64(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s7, 56(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 48(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs1, 40(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs2, 32(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs3, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs4, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs5, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs6, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 128
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB44_10: # %entry
; CHECK-NOV-NEXT:    mv a0, a3
; CHECK-NOV-NEXT:    fcvt.l.s a1, fs5, rtz
; CHECK-NOV-NEXT:    blt s2, a3, .LBB44_2
; CHECK-NOV-NEXT:  .LBB44_11: # %entry
; CHECK-NOV-NEXT:    mv s2, a3
; CHECK-NOV-NEXT:    fcvt.l.s a2, fs4, rtz
; CHECK-NOV-NEXT:    blt a1, a3, .LBB44_3
; CHECK-NOV-NEXT:  .LBB44_12: # %entry
; CHECK-NOV-NEXT:    mv a1, a3
; CHECK-NOV-NEXT:    fcvt.l.s a4, fs3, rtz
; CHECK-NOV-NEXT:    blt a2, a3, .LBB44_4
; CHECK-NOV-NEXT:  .LBB44_13: # %entry
; CHECK-NOV-NEXT:    mv a2, a3
; CHECK-NOV-NEXT:    fcvt.l.s a5, fs2, rtz
; CHECK-NOV-NEXT:    blt a4, a3, .LBB44_5
; CHECK-NOV-NEXT:  .LBB44_14: # %entry
; CHECK-NOV-NEXT:    mv a4, a3
; CHECK-NOV-NEXT:    fcvt.l.s a6, fs1, rtz
; CHECK-NOV-NEXT:    blt a5, a3, .LBB44_6
; CHECK-NOV-NEXT:  .LBB44_15: # %entry
; CHECK-NOV-NEXT:    mv a5, a3
; CHECK-NOV-NEXT:    fcvt.l.s a7, fs0, rtz
; CHECK-NOV-NEXT:    blt a6, a3, .LBB44_7
; CHECK-NOV-NEXT:  .LBB44_16: # %entry
; CHECK-NOV-NEXT:    mv a6, a3
; CHECK-NOV-NEXT:    bge a7, a3, .LBB44_8
; CHECK-NOV-NEXT:    j .LBB44_9
;
; CHECK-V-LABEL: ustest_f16i16_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -96
; CHECK-V-NEXT:    .cfi_def_cfa_offset 96
; CHECK-V-NEXT:    sd ra, 88(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 80(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 72(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s2, 64(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s3, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s4, 48(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s5, 40(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s6, 32(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    .cfi_offset s2, -32
; CHECK-V-NEXT:    .cfi_offset s3, -40
; CHECK-V-NEXT:    .cfi_offset s4, -48
; CHECK-V-NEXT:    .cfi_offset s5, -56
; CHECK-V-NEXT:    .cfi_offset s6, -64
; CHECK-V-NEXT:    lhu s0, 56(a0)
; CHECK-V-NEXT:    lhu s1, 48(a0)
; CHECK-V-NEXT:    lhu s2, 40(a0)
; CHECK-V-NEXT:    lhu s3, 32(a0)
; CHECK-V-NEXT:    lhu s4, 24(a0)
; CHECK-V-NEXT:    lhu s5, 16(a0)
; CHECK-V-NEXT:    lhu s6, 0(a0)
; CHECK-V-NEXT:    lhu a0, 8(a0)
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 28(sp)
; CHECK-V-NEXT:    mv a0, s6
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 0(sp)
; CHECK-V-NEXT:    mv a0, s5
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 24(sp)
; CHECK-V-NEXT:    mv a0, s4
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 20(sp)
; CHECK-V-NEXT:    mv a0, s3
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 16(sp)
; CHECK-V-NEXT:    mv a0, s2
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 12(sp)
; CHECK-V-NEXT:    mv a0, s1
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 8(sp)
; CHECK-V-NEXT:    mv a0, s0
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    fcvt.l.s a0, fa0, rtz
; CHECK-V-NEXT:    sw a0, 4(sp)
; CHECK-V-NEXT:    addi a0, sp, 28
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    mv a0, sp
; CHECK-V-NEXT:    vle32.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 1
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 3, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 2
; CHECK-V-NEXT:    addi a0, sp, 20
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 4, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 3
; CHECK-V-NEXT:    addi a0, sp, 16
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 5, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 4
; CHECK-V-NEXT:    addi a0, sp, 12
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 6, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 5
; CHECK-V-NEXT:    addi a0, sp, 8
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 7, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 6
; CHECK-V-NEXT:    addi a0, sp, 4
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vle32.v v10, (a0)
; CHECK-V-NEXT:    vsetivli zero, 8, e32, m2, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v10, 7
; CHECK-V-NEXT:    lui a0, 16
; CHECK-V-NEXT:    addiw a0, a0, -1
; CHECK-V-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-V-NEXT:    vmin.vx v8, v8, a0
; CHECK-V-NEXT:    vmax.vx v10, v8, zero
; CHECK-V-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-V-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-V-NEXT:    ld ra, 88(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 80(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 72(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s2, 64(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s3, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s4, 48(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s5, 40(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s6, 32(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 96
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %spec.store.select = call <8 x i32> @llvm.smin.v8i32(<8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>)
  %spec.store.select7 = call <8 x i32> @llvm.smax.v8i32(<8 x i32> %spec.store.select, <8 x i32> zeroinitializer)
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

; i64 saturate

define <2 x i64> @stest_f64i64_mm(<2 x double> %x) {
; CHECK-NOV-LABEL: stest_f64i64_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -32
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOV-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset fs0, -32
; CHECK-NOV-NEXT:    fmv.d fs0, fa1
; CHECK-NOV-NEXT:    call __fixdfti@plt
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv s1, a1
; CHECK-NOV-NEXT:    fmv.d fa0, fs0
; CHECK-NOV-NEXT:    call __fixdfti@plt
; CHECK-NOV-NEXT:    mv a2, a0
; CHECK-NOV-NEXT:    li a0, -1
; CHECK-NOV-NEXT:    srli a3, a0, 1
; CHECK-NOV-NEXT:    mv a4, a2
; CHECK-NOV-NEXT:    bgez a1, .LBB45_15
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    bgeu a2, a3, .LBB45_16
; CHECK-NOV-NEXT:  .LBB45_2: # %entry
; CHECK-NOV-NEXT:    bnez a1, .LBB45_17
; CHECK-NOV-NEXT:  .LBB45_3: # %entry
; CHECK-NOV-NEXT:    mv a4, s0
; CHECK-NOV-NEXT:    bgez s1, .LBB45_18
; CHECK-NOV-NEXT:  .LBB45_4: # %entry
; CHECK-NOV-NEXT:    bgeu s0, a3, .LBB45_19
; CHECK-NOV-NEXT:  .LBB45_5: # %entry
; CHECK-NOV-NEXT:    beqz s1, .LBB45_7
; CHECK-NOV-NEXT:  .LBB45_6: # %entry
; CHECK-NOV-NEXT:    mv s0, a4
; CHECK-NOV-NEXT:  .LBB45_7: # %entry
; CHECK-NOV-NEXT:    slti a6, a1, 0
; CHECK-NOV-NEXT:    slti a3, s1, 0
; CHECK-NOV-NEXT:    neg a3, a3
; CHECK-NOV-NEXT:    and a4, a3, s1
; CHECK-NOV-NEXT:    slli a3, a0, 63
; CHECK-NOV-NEXT:    mv a5, s0
; CHECK-NOV-NEXT:    bltz a4, .LBB45_20
; CHECK-NOV-NEXT:  # %bb.8: # %entry
; CHECK-NOV-NEXT:    neg a6, a6
; CHECK-NOV-NEXT:    bgeu a3, s0, .LBB45_21
; CHECK-NOV-NEXT:  .LBB45_9: # %entry
; CHECK-NOV-NEXT:    and a1, a6, a1
; CHECK-NOV-NEXT:    bne a4, a0, .LBB45_22
; CHECK-NOV-NEXT:  .LBB45_10: # %entry
; CHECK-NOV-NEXT:    mv a4, a2
; CHECK-NOV-NEXT:    bltz a1, .LBB45_23
; CHECK-NOV-NEXT:  .LBB45_11: # %entry
; CHECK-NOV-NEXT:    bgeu a3, a2, .LBB45_24
; CHECK-NOV-NEXT:  .LBB45_12: # %entry
; CHECK-NOV-NEXT:    beq a1, a0, .LBB45_14
; CHECK-NOV-NEXT:  .LBB45_13: # %entry
; CHECK-NOV-NEXT:    mv a2, a4
; CHECK-NOV-NEXT:  .LBB45_14: # %entry
; CHECK-NOV-NEXT:    mv a0, s0
; CHECK-NOV-NEXT:    mv a1, a2
; CHECK-NOV-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 32
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB45_15: # %entry
; CHECK-NOV-NEXT:    mv a4, a3
; CHECK-NOV-NEXT:    bltu a2, a3, .LBB45_2
; CHECK-NOV-NEXT:  .LBB45_16: # %entry
; CHECK-NOV-NEXT:    mv a2, a3
; CHECK-NOV-NEXT:    beqz a1, .LBB45_3
; CHECK-NOV-NEXT:  .LBB45_17: # %entry
; CHECK-NOV-NEXT:    mv a2, a4
; CHECK-NOV-NEXT:    mv a4, s0
; CHECK-NOV-NEXT:    bltz s1, .LBB45_4
; CHECK-NOV-NEXT:  .LBB45_18: # %entry
; CHECK-NOV-NEXT:    mv a4, a3
; CHECK-NOV-NEXT:    bltu s0, a3, .LBB45_5
; CHECK-NOV-NEXT:  .LBB45_19: # %entry
; CHECK-NOV-NEXT:    mv s0, a3
; CHECK-NOV-NEXT:    bnez s1, .LBB45_6
; CHECK-NOV-NEXT:    j .LBB45_7
; CHECK-NOV-NEXT:  .LBB45_20: # %entry
; CHECK-NOV-NEXT:    mv a5, a3
; CHECK-NOV-NEXT:    neg a6, a6
; CHECK-NOV-NEXT:    bltu a3, s0, .LBB45_9
; CHECK-NOV-NEXT:  .LBB45_21: # %entry
; CHECK-NOV-NEXT:    mv s0, a3
; CHECK-NOV-NEXT:    and a1, a6, a1
; CHECK-NOV-NEXT:    beq a4, a0, .LBB45_10
; CHECK-NOV-NEXT:  .LBB45_22: # %entry
; CHECK-NOV-NEXT:    mv s0, a5
; CHECK-NOV-NEXT:    mv a4, a2
; CHECK-NOV-NEXT:    bgez a1, .LBB45_11
; CHECK-NOV-NEXT:  .LBB45_23: # %entry
; CHECK-NOV-NEXT:    mv a4, a3
; CHECK-NOV-NEXT:    bltu a3, a2, .LBB45_12
; CHECK-NOV-NEXT:  .LBB45_24: # %entry
; CHECK-NOV-NEXT:    mv a2, a3
; CHECK-NOV-NEXT:    bne a1, a0, .LBB45_13
; CHECK-NOV-NEXT:    j .LBB45_14
;
; CHECK-V-LABEL: stest_f64i64_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -80
; CHECK-V-NEXT:    .cfi_def_cfa_offset 80
; CHECK-V-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    sub sp, sp, a0
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vs1r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vslidedown.vi v9, v8, 1
; CHECK-V-NEXT:    vfmv.f.s fa0, v9
; CHECK-V-NEXT:    call __fixdfti@plt
; CHECK-V-NEXT:    mv s0, a0
; CHECK-V-NEXT:    mv s1, a1
; CHECK-V-NEXT:    vsetivli zero, 0, e64, m1, ta, ma
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vl1r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-V-NEXT:    vfmv.f.s fa0, v8
; CHECK-V-NEXT:    call __fixdfti@plt
; CHECK-V-NEXT:    li a2, -1
; CHECK-V-NEXT:    srli a3, a2, 1
; CHECK-V-NEXT:    mv a4, s0
; CHECK-V-NEXT:    bgez s1, .LBB45_15
; CHECK-V-NEXT:  # %bb.1: # %entry
; CHECK-V-NEXT:    bgeu s0, a3, .LBB45_16
; CHECK-V-NEXT:  .LBB45_2: # %entry
; CHECK-V-NEXT:    bnez s1, .LBB45_17
; CHECK-V-NEXT:  .LBB45_3: # %entry
; CHECK-V-NEXT:    mv a4, a0
; CHECK-V-NEXT:    bgez a1, .LBB45_18
; CHECK-V-NEXT:  .LBB45_4: # %entry
; CHECK-V-NEXT:    bgeu a0, a3, .LBB45_19
; CHECK-V-NEXT:  .LBB45_5: # %entry
; CHECK-V-NEXT:    beqz a1, .LBB45_7
; CHECK-V-NEXT:  .LBB45_6: # %entry
; CHECK-V-NEXT:    mv a0, a4
; CHECK-V-NEXT:  .LBB45_7: # %entry
; CHECK-V-NEXT:    slti a3, s1, 0
; CHECK-V-NEXT:    neg a3, a3
; CHECK-V-NEXT:    and a4, a3, s1
; CHECK-V-NEXT:    slti a6, a1, 0
; CHECK-V-NEXT:    slli a3, a2, 63
; CHECK-V-NEXT:    mv a5, s0
; CHECK-V-NEXT:    bltz a4, .LBB45_20
; CHECK-V-NEXT:  # %bb.8: # %entry
; CHECK-V-NEXT:    neg a6, a6
; CHECK-V-NEXT:    bgeu a3, s0, .LBB45_21
; CHECK-V-NEXT:  .LBB45_9: # %entry
; CHECK-V-NEXT:    and a1, a6, a1
; CHECK-V-NEXT:    bne a4, a2, .LBB45_22
; CHECK-V-NEXT:  .LBB45_10: # %entry
; CHECK-V-NEXT:    mv a4, a0
; CHECK-V-NEXT:    bltz a1, .LBB45_23
; CHECK-V-NEXT:  .LBB45_11: # %entry
; CHECK-V-NEXT:    bgeu a3, a0, .LBB45_24
; CHECK-V-NEXT:  .LBB45_12: # %entry
; CHECK-V-NEXT:    beq a1, a2, .LBB45_14
; CHECK-V-NEXT:  .LBB45_13: # %entry
; CHECK-V-NEXT:    mv a0, a4
; CHECK-V-NEXT:  .LBB45_14: # %entry
; CHECK-V-NEXT:    sd a0, 24(sp)
; CHECK-V-NEXT:    sd s0, 32(sp)
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    addi a0, sp, 32
; CHECK-V-NEXT:    vle64.v v9, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v9, 1
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    add sp, sp, a0
; CHECK-V-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 80
; CHECK-V-NEXT:    ret
; CHECK-V-NEXT:  .LBB45_15: # %entry
; CHECK-V-NEXT:    mv a4, a3
; CHECK-V-NEXT:    bltu s0, a3, .LBB45_2
; CHECK-V-NEXT:  .LBB45_16: # %entry
; CHECK-V-NEXT:    mv s0, a3
; CHECK-V-NEXT:    beqz s1, .LBB45_3
; CHECK-V-NEXT:  .LBB45_17: # %entry
; CHECK-V-NEXT:    mv s0, a4
; CHECK-V-NEXT:    mv a4, a0
; CHECK-V-NEXT:    bltz a1, .LBB45_4
; CHECK-V-NEXT:  .LBB45_18: # %entry
; CHECK-V-NEXT:    mv a4, a3
; CHECK-V-NEXT:    bltu a0, a3, .LBB45_5
; CHECK-V-NEXT:  .LBB45_19: # %entry
; CHECK-V-NEXT:    mv a0, a3
; CHECK-V-NEXT:    bnez a1, .LBB45_6
; CHECK-V-NEXT:    j .LBB45_7
; CHECK-V-NEXT:  .LBB45_20: # %entry
; CHECK-V-NEXT:    mv a5, a3
; CHECK-V-NEXT:    neg a6, a6
; CHECK-V-NEXT:    bltu a3, s0, .LBB45_9
; CHECK-V-NEXT:  .LBB45_21: # %entry
; CHECK-V-NEXT:    mv s0, a3
; CHECK-V-NEXT:    and a1, a6, a1
; CHECK-V-NEXT:    beq a4, a2, .LBB45_10
; CHECK-V-NEXT:  .LBB45_22: # %entry
; CHECK-V-NEXT:    mv s0, a5
; CHECK-V-NEXT:    mv a4, a0
; CHECK-V-NEXT:    bgez a1, .LBB45_11
; CHECK-V-NEXT:  .LBB45_23: # %entry
; CHECK-V-NEXT:    mv a4, a3
; CHECK-V-NEXT:    bltu a3, a0, .LBB45_12
; CHECK-V-NEXT:  .LBB45_24: # %entry
; CHECK-V-NEXT:    mv a0, a3
; CHECK-V-NEXT:    bne a1, a2, .LBB45_13
; CHECK-V-NEXT:    j .LBB45_14
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f64i64_mm(<2 x double> %x) {
; CHECK-NOV-LABEL: utest_f64i64_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -32
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOV-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset fs0, -32
; CHECK-NOV-NEXT:    fmv.d fs0, fa0
; CHECK-NOV-NEXT:    fmv.d fa0, fa1
; CHECK-NOV-NEXT:    call __fixunsdfti@plt
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv s1, a1
; CHECK-NOV-NEXT:    fmv.d fa0, fs0
; CHECK-NOV-NEXT:    call __fixunsdfti@plt
; CHECK-NOV-NEXT:    snez a2, a1
; CHECK-NOV-NEXT:    addi a2, a2, -1
; CHECK-NOV-NEXT:    and a0, a2, a0
; CHECK-NOV-NEXT:    addi a1, a1, -1
; CHECK-NOV-NEXT:    seqz a1, a1
; CHECK-NOV-NEXT:    addi a1, a1, -1
; CHECK-NOV-NEXT:    and a0, a1, a0
; CHECK-NOV-NEXT:    snez a1, s1
; CHECK-NOV-NEXT:    addi a1, a1, -1
; CHECK-NOV-NEXT:    and a1, a1, s0
; CHECK-NOV-NEXT:    addi a2, s1, -1
; CHECK-NOV-NEXT:    seqz a2, a2
; CHECK-NOV-NEXT:    addi a2, a2, -1
; CHECK-NOV-NEXT:    and a1, a2, a1
; CHECK-NOV-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 32
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: utest_f64i64_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -80
; CHECK-V-NEXT:    .cfi_def_cfa_offset 80
; CHECK-V-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    sub sp, sp, a0
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vs1r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vslidedown.vi v9, v8, 1
; CHECK-V-NEXT:    vfmv.f.s fa0, v9
; CHECK-V-NEXT:    call __fixunsdfti@plt
; CHECK-V-NEXT:    mv s0, a0
; CHECK-V-NEXT:    mv s1, a1
; CHECK-V-NEXT:    vsetivli zero, 0, e64, m1, ta, ma
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vl1r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-V-NEXT:    vfmv.f.s fa0, v8
; CHECK-V-NEXT:    call __fixunsdfti@plt
; CHECK-V-NEXT:    snez a2, s1
; CHECK-V-NEXT:    addi a2, a2, -1
; CHECK-V-NEXT:    and a2, a2, s0
; CHECK-V-NEXT:    addi a3, s1, -1
; CHECK-V-NEXT:    seqz a3, a3
; CHECK-V-NEXT:    addi a3, a3, -1
; CHECK-V-NEXT:    and a2, a3, a2
; CHECK-V-NEXT:    snez a3, a1
; CHECK-V-NEXT:    addi a3, a3, -1
; CHECK-V-NEXT:    and a0, a3, a0
; CHECK-V-NEXT:    addi a1, a1, -1
; CHECK-V-NEXT:    seqz a1, a1
; CHECK-V-NEXT:    addi a1, a1, -1
; CHECK-V-NEXT:    and a0, a1, a0
; CHECK-V-NEXT:    sd a0, 24(sp)
; CHECK-V-NEXT:    sd a2, 32(sp)
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    addi a0, sp, 32
; CHECK-V-NEXT:    vle64.v v9, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v9, 1
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    add sp, sp, a0
; CHECK-V-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 80
; CHECK-V-NEXT:    ret
entry:
  %conv = fptoui <2 x double> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.umin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f64i64_mm(<2 x double> %x) {
; CHECK-NOV-LABEL: ustest_f64i64_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -32
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOV-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset fs0, -32
; CHECK-NOV-NEXT:    fmv.d fs0, fa1
; CHECK-NOV-NEXT:    call __fixdfti@plt
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv s1, a1
; CHECK-NOV-NEXT:    fmv.d fa0, fs0
; CHECK-NOV-NEXT:    call __fixdfti@plt
; CHECK-NOV-NEXT:    mv a2, a1
; CHECK-NOV-NEXT:    blez a1, .LBB47_2
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    li a2, 1
; CHECK-NOV-NEXT:  .LBB47_2: # %entry
; CHECK-NOV-NEXT:    mv a4, s1
; CHECK-NOV-NEXT:    blez s1, .LBB47_4
; CHECK-NOV-NEXT:  # %bb.3: # %entry
; CHECK-NOV-NEXT:    li a4, 1
; CHECK-NOV-NEXT:  .LBB47_4: # %entry
; CHECK-NOV-NEXT:    sgtz a3, a1
; CHECK-NOV-NEXT:    addi a3, a3, -1
; CHECK-NOV-NEXT:    and a3, a3, a0
; CHECK-NOV-NEXT:    addi a0, a1, -1
; CHECK-NOV-NEXT:    seqz a0, a0
; CHECK-NOV-NEXT:    addi a1, a0, -1
; CHECK-NOV-NEXT:    sgtz a0, s1
; CHECK-NOV-NEXT:    addi a0, a0, -1
; CHECK-NOV-NEXT:    and a0, a0, s0
; CHECK-NOV-NEXT:    addi a5, s1, -1
; CHECK-NOV-NEXT:    seqz a5, a5
; CHECK-NOV-NEXT:    addi a5, a5, -1
; CHECK-NOV-NEXT:    and a0, a5, a0
; CHECK-NOV-NEXT:    beqz a4, .LBB47_6
; CHECK-NOV-NEXT:  # %bb.5: # %entry
; CHECK-NOV-NEXT:    sgtz a4, a4
; CHECK-NOV-NEXT:    neg a4, a4
; CHECK-NOV-NEXT:    and a0, a4, a0
; CHECK-NOV-NEXT:  .LBB47_6: # %entry
; CHECK-NOV-NEXT:    and a1, a1, a3
; CHECK-NOV-NEXT:    beqz a2, .LBB47_8
; CHECK-NOV-NEXT:  # %bb.7: # %entry
; CHECK-NOV-NEXT:    sgtz a2, a2
; CHECK-NOV-NEXT:    neg a2, a2
; CHECK-NOV-NEXT:    and a1, a2, a1
; CHECK-NOV-NEXT:  .LBB47_8: # %entry
; CHECK-NOV-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 32
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: ustest_f64i64_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -80
; CHECK-V-NEXT:    .cfi_def_cfa_offset 80
; CHECK-V-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    sub sp, sp, a0
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vs1r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vslidedown.vi v9, v8, 1
; CHECK-V-NEXT:    vfmv.f.s fa0, v9
; CHECK-V-NEXT:    call __fixdfti@plt
; CHECK-V-NEXT:    mv s1, a0
; CHECK-V-NEXT:    mv s0, a1
; CHECK-V-NEXT:    vsetivli zero, 0, e64, m1, ta, ma
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vl1r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-V-NEXT:    vfmv.f.s fa0, v8
; CHECK-V-NEXT:    call __fixdfti@plt
; CHECK-V-NEXT:    mv a2, a1
; CHECK-V-NEXT:    blez a1, .LBB47_2
; CHECK-V-NEXT:  # %bb.1: # %entry
; CHECK-V-NEXT:    li a2, 1
; CHECK-V-NEXT:  .LBB47_2: # %entry
; CHECK-V-NEXT:    sgtz a3, s0
; CHECK-V-NEXT:    addi a3, a3, -1
; CHECK-V-NEXT:    and a3, a3, s1
; CHECK-V-NEXT:    addi a4, s0, -1
; CHECK-V-NEXT:    seqz a4, a4
; CHECK-V-NEXT:    addi a4, a4, -1
; CHECK-V-NEXT:    sgtz a5, a1
; CHECK-V-NEXT:    addi a5, a5, -1
; CHECK-V-NEXT:    addi a1, a1, -1
; CHECK-V-NEXT:    seqz a6, a1
; CHECK-V-NEXT:    blez s0, .LBB47_4
; CHECK-V-NEXT:  # %bb.3: # %entry
; CHECK-V-NEXT:    li s0, 1
; CHECK-V-NEXT:  .LBB47_4: # %entry
; CHECK-V-NEXT:    and a1, a5, a0
; CHECK-V-NEXT:    addi a5, a6, -1
; CHECK-V-NEXT:    and a0, a4, a3
; CHECK-V-NEXT:    beqz s0, .LBB47_6
; CHECK-V-NEXT:  # %bb.5: # %entry
; CHECK-V-NEXT:    sgtz a3, s0
; CHECK-V-NEXT:    neg a3, a3
; CHECK-V-NEXT:    and a0, a3, a0
; CHECK-V-NEXT:  .LBB47_6: # %entry
; CHECK-V-NEXT:    and a1, a5, a1
; CHECK-V-NEXT:    beqz a2, .LBB47_8
; CHECK-V-NEXT:  # %bb.7: # %entry
; CHECK-V-NEXT:    sgtz a2, a2
; CHECK-V-NEXT:    neg a2, a2
; CHECK-V-NEXT:    and a1, a2, a1
; CHECK-V-NEXT:  .LBB47_8: # %entry
; CHECK-V-NEXT:    sd a1, 24(sp)
; CHECK-V-NEXT:    sd a0, 32(sp)
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    addi a0, sp, 32
; CHECK-V-NEXT:    vle64.v v9, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v9, 1
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    add sp, sp, a0
; CHECK-V-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 80
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> zeroinitializer)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f32i64_mm(<2 x float> %x) {
; CHECK-NOV-LABEL: stest_f32i64_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -32
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOV-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset fs0, -32
; CHECK-NOV-NEXT:    fmv.s fs0, fa1
; CHECK-NOV-NEXT:    call __fixsfti@plt
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv s1, a1
; CHECK-NOV-NEXT:    fmv.s fa0, fs0
; CHECK-NOV-NEXT:    call __fixsfti@plt
; CHECK-NOV-NEXT:    mv a2, a0
; CHECK-NOV-NEXT:    li a0, -1
; CHECK-NOV-NEXT:    srli a3, a0, 1
; CHECK-NOV-NEXT:    mv a4, a2
; CHECK-NOV-NEXT:    bgez a1, .LBB48_15
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    bgeu a2, a3, .LBB48_16
; CHECK-NOV-NEXT:  .LBB48_2: # %entry
; CHECK-NOV-NEXT:    bnez a1, .LBB48_17
; CHECK-NOV-NEXT:  .LBB48_3: # %entry
; CHECK-NOV-NEXT:    mv a4, s0
; CHECK-NOV-NEXT:    bgez s1, .LBB48_18
; CHECK-NOV-NEXT:  .LBB48_4: # %entry
; CHECK-NOV-NEXT:    bgeu s0, a3, .LBB48_19
; CHECK-NOV-NEXT:  .LBB48_5: # %entry
; CHECK-NOV-NEXT:    beqz s1, .LBB48_7
; CHECK-NOV-NEXT:  .LBB48_6: # %entry
; CHECK-NOV-NEXT:    mv s0, a4
; CHECK-NOV-NEXT:  .LBB48_7: # %entry
; CHECK-NOV-NEXT:    slti a6, a1, 0
; CHECK-NOV-NEXT:    slti a3, s1, 0
; CHECK-NOV-NEXT:    neg a3, a3
; CHECK-NOV-NEXT:    and a4, a3, s1
; CHECK-NOV-NEXT:    slli a3, a0, 63
; CHECK-NOV-NEXT:    mv a5, s0
; CHECK-NOV-NEXT:    bltz a4, .LBB48_20
; CHECK-NOV-NEXT:  # %bb.8: # %entry
; CHECK-NOV-NEXT:    neg a6, a6
; CHECK-NOV-NEXT:    bgeu a3, s0, .LBB48_21
; CHECK-NOV-NEXT:  .LBB48_9: # %entry
; CHECK-NOV-NEXT:    and a1, a6, a1
; CHECK-NOV-NEXT:    bne a4, a0, .LBB48_22
; CHECK-NOV-NEXT:  .LBB48_10: # %entry
; CHECK-NOV-NEXT:    mv a4, a2
; CHECK-NOV-NEXT:    bltz a1, .LBB48_23
; CHECK-NOV-NEXT:  .LBB48_11: # %entry
; CHECK-NOV-NEXT:    bgeu a3, a2, .LBB48_24
; CHECK-NOV-NEXT:  .LBB48_12: # %entry
; CHECK-NOV-NEXT:    beq a1, a0, .LBB48_14
; CHECK-NOV-NEXT:  .LBB48_13: # %entry
; CHECK-NOV-NEXT:    mv a2, a4
; CHECK-NOV-NEXT:  .LBB48_14: # %entry
; CHECK-NOV-NEXT:    mv a0, s0
; CHECK-NOV-NEXT:    mv a1, a2
; CHECK-NOV-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 32
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB48_15: # %entry
; CHECK-NOV-NEXT:    mv a4, a3
; CHECK-NOV-NEXT:    bltu a2, a3, .LBB48_2
; CHECK-NOV-NEXT:  .LBB48_16: # %entry
; CHECK-NOV-NEXT:    mv a2, a3
; CHECK-NOV-NEXT:    beqz a1, .LBB48_3
; CHECK-NOV-NEXT:  .LBB48_17: # %entry
; CHECK-NOV-NEXT:    mv a2, a4
; CHECK-NOV-NEXT:    mv a4, s0
; CHECK-NOV-NEXT:    bltz s1, .LBB48_4
; CHECK-NOV-NEXT:  .LBB48_18: # %entry
; CHECK-NOV-NEXT:    mv a4, a3
; CHECK-NOV-NEXT:    bltu s0, a3, .LBB48_5
; CHECK-NOV-NEXT:  .LBB48_19: # %entry
; CHECK-NOV-NEXT:    mv s0, a3
; CHECK-NOV-NEXT:    bnez s1, .LBB48_6
; CHECK-NOV-NEXT:    j .LBB48_7
; CHECK-NOV-NEXT:  .LBB48_20: # %entry
; CHECK-NOV-NEXT:    mv a5, a3
; CHECK-NOV-NEXT:    neg a6, a6
; CHECK-NOV-NEXT:    bltu a3, s0, .LBB48_9
; CHECK-NOV-NEXT:  .LBB48_21: # %entry
; CHECK-NOV-NEXT:    mv s0, a3
; CHECK-NOV-NEXT:    and a1, a6, a1
; CHECK-NOV-NEXT:    beq a4, a0, .LBB48_10
; CHECK-NOV-NEXT:  .LBB48_22: # %entry
; CHECK-NOV-NEXT:    mv s0, a5
; CHECK-NOV-NEXT:    mv a4, a2
; CHECK-NOV-NEXT:    bgez a1, .LBB48_11
; CHECK-NOV-NEXT:  .LBB48_23: # %entry
; CHECK-NOV-NEXT:    mv a4, a3
; CHECK-NOV-NEXT:    bltu a3, a2, .LBB48_12
; CHECK-NOV-NEXT:  .LBB48_24: # %entry
; CHECK-NOV-NEXT:    mv a2, a3
; CHECK-NOV-NEXT:    bne a1, a0, .LBB48_13
; CHECK-NOV-NEXT:    j .LBB48_14
;
; CHECK-V-LABEL: stest_f32i64_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -80
; CHECK-V-NEXT:    .cfi_def_cfa_offset 80
; CHECK-V-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    sub sp, sp, a0
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vs1r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vslidedown.vi v9, v8, 1
; CHECK-V-NEXT:    vfmv.f.s fa0, v9
; CHECK-V-NEXT:    call __fixsfti@plt
; CHECK-V-NEXT:    mv s0, a0
; CHECK-V-NEXT:    mv s1, a1
; CHECK-V-NEXT:    vsetivli zero, 0, e32, mf2, ta, ma
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vl1r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-V-NEXT:    vfmv.f.s fa0, v8
; CHECK-V-NEXT:    call __fixsfti@plt
; CHECK-V-NEXT:    li a2, -1
; CHECK-V-NEXT:    srli a3, a2, 1
; CHECK-V-NEXT:    mv a4, s0
; CHECK-V-NEXT:    bgez s1, .LBB48_15
; CHECK-V-NEXT:  # %bb.1: # %entry
; CHECK-V-NEXT:    bgeu s0, a3, .LBB48_16
; CHECK-V-NEXT:  .LBB48_2: # %entry
; CHECK-V-NEXT:    bnez s1, .LBB48_17
; CHECK-V-NEXT:  .LBB48_3: # %entry
; CHECK-V-NEXT:    mv a4, a0
; CHECK-V-NEXT:    bgez a1, .LBB48_18
; CHECK-V-NEXT:  .LBB48_4: # %entry
; CHECK-V-NEXT:    bgeu a0, a3, .LBB48_19
; CHECK-V-NEXT:  .LBB48_5: # %entry
; CHECK-V-NEXT:    beqz a1, .LBB48_7
; CHECK-V-NEXT:  .LBB48_6: # %entry
; CHECK-V-NEXT:    mv a0, a4
; CHECK-V-NEXT:  .LBB48_7: # %entry
; CHECK-V-NEXT:    slti a3, s1, 0
; CHECK-V-NEXT:    neg a3, a3
; CHECK-V-NEXT:    and a4, a3, s1
; CHECK-V-NEXT:    slti a6, a1, 0
; CHECK-V-NEXT:    slli a3, a2, 63
; CHECK-V-NEXT:    mv a5, s0
; CHECK-V-NEXT:    bltz a4, .LBB48_20
; CHECK-V-NEXT:  # %bb.8: # %entry
; CHECK-V-NEXT:    neg a6, a6
; CHECK-V-NEXT:    bgeu a3, s0, .LBB48_21
; CHECK-V-NEXT:  .LBB48_9: # %entry
; CHECK-V-NEXT:    and a1, a6, a1
; CHECK-V-NEXT:    bne a4, a2, .LBB48_22
; CHECK-V-NEXT:  .LBB48_10: # %entry
; CHECK-V-NEXT:    mv a4, a0
; CHECK-V-NEXT:    bltz a1, .LBB48_23
; CHECK-V-NEXT:  .LBB48_11: # %entry
; CHECK-V-NEXT:    bgeu a3, a0, .LBB48_24
; CHECK-V-NEXT:  .LBB48_12: # %entry
; CHECK-V-NEXT:    beq a1, a2, .LBB48_14
; CHECK-V-NEXT:  .LBB48_13: # %entry
; CHECK-V-NEXT:    mv a0, a4
; CHECK-V-NEXT:  .LBB48_14: # %entry
; CHECK-V-NEXT:    sd a0, 24(sp)
; CHECK-V-NEXT:    sd s0, 32(sp)
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    addi a0, sp, 32
; CHECK-V-NEXT:    vle64.v v9, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v9, 1
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    add sp, sp, a0
; CHECK-V-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 80
; CHECK-V-NEXT:    ret
; CHECK-V-NEXT:  .LBB48_15: # %entry
; CHECK-V-NEXT:    mv a4, a3
; CHECK-V-NEXT:    bltu s0, a3, .LBB48_2
; CHECK-V-NEXT:  .LBB48_16: # %entry
; CHECK-V-NEXT:    mv s0, a3
; CHECK-V-NEXT:    beqz s1, .LBB48_3
; CHECK-V-NEXT:  .LBB48_17: # %entry
; CHECK-V-NEXT:    mv s0, a4
; CHECK-V-NEXT:    mv a4, a0
; CHECK-V-NEXT:    bltz a1, .LBB48_4
; CHECK-V-NEXT:  .LBB48_18: # %entry
; CHECK-V-NEXT:    mv a4, a3
; CHECK-V-NEXT:    bltu a0, a3, .LBB48_5
; CHECK-V-NEXT:  .LBB48_19: # %entry
; CHECK-V-NEXT:    mv a0, a3
; CHECK-V-NEXT:    bnez a1, .LBB48_6
; CHECK-V-NEXT:    j .LBB48_7
; CHECK-V-NEXT:  .LBB48_20: # %entry
; CHECK-V-NEXT:    mv a5, a3
; CHECK-V-NEXT:    neg a6, a6
; CHECK-V-NEXT:    bltu a3, s0, .LBB48_9
; CHECK-V-NEXT:  .LBB48_21: # %entry
; CHECK-V-NEXT:    mv s0, a3
; CHECK-V-NEXT:    and a1, a6, a1
; CHECK-V-NEXT:    beq a4, a2, .LBB48_10
; CHECK-V-NEXT:  .LBB48_22: # %entry
; CHECK-V-NEXT:    mv s0, a5
; CHECK-V-NEXT:    mv a4, a0
; CHECK-V-NEXT:    bgez a1, .LBB48_11
; CHECK-V-NEXT:  .LBB48_23: # %entry
; CHECK-V-NEXT:    mv a4, a3
; CHECK-V-NEXT:    bltu a3, a0, .LBB48_12
; CHECK-V-NEXT:  .LBB48_24: # %entry
; CHECK-V-NEXT:    mv a0, a3
; CHECK-V-NEXT:    bne a1, a2, .LBB48_13
; CHECK-V-NEXT:    j .LBB48_14
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f32i64_mm(<2 x float> %x) {
; CHECK-NOV-LABEL: utest_f32i64_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -32
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOV-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset fs0, -32
; CHECK-NOV-NEXT:    fmv.s fs0, fa0
; CHECK-NOV-NEXT:    fmv.s fa0, fa1
; CHECK-NOV-NEXT:    call __fixunssfti@plt
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv s1, a1
; CHECK-NOV-NEXT:    fmv.s fa0, fs0
; CHECK-NOV-NEXT:    call __fixunssfti@plt
; CHECK-NOV-NEXT:    snez a2, a1
; CHECK-NOV-NEXT:    addi a2, a2, -1
; CHECK-NOV-NEXT:    and a0, a2, a0
; CHECK-NOV-NEXT:    addi a1, a1, -1
; CHECK-NOV-NEXT:    seqz a1, a1
; CHECK-NOV-NEXT:    addi a1, a1, -1
; CHECK-NOV-NEXT:    and a0, a1, a0
; CHECK-NOV-NEXT:    snez a1, s1
; CHECK-NOV-NEXT:    addi a1, a1, -1
; CHECK-NOV-NEXT:    and a1, a1, s0
; CHECK-NOV-NEXT:    addi a2, s1, -1
; CHECK-NOV-NEXT:    seqz a2, a2
; CHECK-NOV-NEXT:    addi a2, a2, -1
; CHECK-NOV-NEXT:    and a1, a2, a1
; CHECK-NOV-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 32
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: utest_f32i64_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -80
; CHECK-V-NEXT:    .cfi_def_cfa_offset 80
; CHECK-V-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    sub sp, sp, a0
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vs1r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vslidedown.vi v9, v8, 1
; CHECK-V-NEXT:    vfmv.f.s fa0, v9
; CHECK-V-NEXT:    call __fixunssfti@plt
; CHECK-V-NEXT:    mv s0, a0
; CHECK-V-NEXT:    mv s1, a1
; CHECK-V-NEXT:    vsetivli zero, 0, e32, mf2, ta, ma
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vl1r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-V-NEXT:    vfmv.f.s fa0, v8
; CHECK-V-NEXT:    call __fixunssfti@plt
; CHECK-V-NEXT:    snez a2, s1
; CHECK-V-NEXT:    addi a2, a2, -1
; CHECK-V-NEXT:    and a2, a2, s0
; CHECK-V-NEXT:    addi a3, s1, -1
; CHECK-V-NEXT:    seqz a3, a3
; CHECK-V-NEXT:    addi a3, a3, -1
; CHECK-V-NEXT:    and a2, a3, a2
; CHECK-V-NEXT:    snez a3, a1
; CHECK-V-NEXT:    addi a3, a3, -1
; CHECK-V-NEXT:    and a0, a3, a0
; CHECK-V-NEXT:    addi a1, a1, -1
; CHECK-V-NEXT:    seqz a1, a1
; CHECK-V-NEXT:    addi a1, a1, -1
; CHECK-V-NEXT:    and a0, a1, a0
; CHECK-V-NEXT:    sd a0, 24(sp)
; CHECK-V-NEXT:    sd a2, 32(sp)
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    addi a0, sp, 32
; CHECK-V-NEXT:    vle64.v v9, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v9, 1
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    add sp, sp, a0
; CHECK-V-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 80
; CHECK-V-NEXT:    ret
entry:
  %conv = fptoui <2 x float> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.umin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f32i64_mm(<2 x float> %x) {
; CHECK-NOV-LABEL: ustest_f32i64_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -32
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOV-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    fsd fs0, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset fs0, -32
; CHECK-NOV-NEXT:    fmv.s fs0, fa1
; CHECK-NOV-NEXT:    call __fixsfti@plt
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv s1, a1
; CHECK-NOV-NEXT:    fmv.s fa0, fs0
; CHECK-NOV-NEXT:    call __fixsfti@plt
; CHECK-NOV-NEXT:    mv a2, a1
; CHECK-NOV-NEXT:    blez a1, .LBB50_2
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    li a2, 1
; CHECK-NOV-NEXT:  .LBB50_2: # %entry
; CHECK-NOV-NEXT:    mv a4, s1
; CHECK-NOV-NEXT:    blez s1, .LBB50_4
; CHECK-NOV-NEXT:  # %bb.3: # %entry
; CHECK-NOV-NEXT:    li a4, 1
; CHECK-NOV-NEXT:  .LBB50_4: # %entry
; CHECK-NOV-NEXT:    sgtz a3, a1
; CHECK-NOV-NEXT:    addi a3, a3, -1
; CHECK-NOV-NEXT:    and a3, a3, a0
; CHECK-NOV-NEXT:    addi a0, a1, -1
; CHECK-NOV-NEXT:    seqz a0, a0
; CHECK-NOV-NEXT:    addi a1, a0, -1
; CHECK-NOV-NEXT:    sgtz a0, s1
; CHECK-NOV-NEXT:    addi a0, a0, -1
; CHECK-NOV-NEXT:    and a0, a0, s0
; CHECK-NOV-NEXT:    addi a5, s1, -1
; CHECK-NOV-NEXT:    seqz a5, a5
; CHECK-NOV-NEXT:    addi a5, a5, -1
; CHECK-NOV-NEXT:    and a0, a5, a0
; CHECK-NOV-NEXT:    beqz a4, .LBB50_6
; CHECK-NOV-NEXT:  # %bb.5: # %entry
; CHECK-NOV-NEXT:    sgtz a4, a4
; CHECK-NOV-NEXT:    neg a4, a4
; CHECK-NOV-NEXT:    and a0, a4, a0
; CHECK-NOV-NEXT:  .LBB50_6: # %entry
; CHECK-NOV-NEXT:    and a1, a1, a3
; CHECK-NOV-NEXT:    beqz a2, .LBB50_8
; CHECK-NOV-NEXT:  # %bb.7: # %entry
; CHECK-NOV-NEXT:    sgtz a2, a2
; CHECK-NOV-NEXT:    neg a2, a2
; CHECK-NOV-NEXT:    and a1, a2, a1
; CHECK-NOV-NEXT:  .LBB50_8: # %entry
; CHECK-NOV-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    fld fs0, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 32
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: ustest_f32i64_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -80
; CHECK-V-NEXT:    .cfi_def_cfa_offset 80
; CHECK-V-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 56(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    sub sp, sp, a0
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vs1r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-V-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-V-NEXT:    vslidedown.vi v9, v8, 1
; CHECK-V-NEXT:    vfmv.f.s fa0, v9
; CHECK-V-NEXT:    call __fixsfti@plt
; CHECK-V-NEXT:    mv s1, a0
; CHECK-V-NEXT:    mv s0, a1
; CHECK-V-NEXT:    vsetivli zero, 0, e32, mf2, ta, ma
; CHECK-V-NEXT:    addi a0, sp, 48
; CHECK-V-NEXT:    vl1r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-V-NEXT:    vfmv.f.s fa0, v8
; CHECK-V-NEXT:    call __fixsfti@plt
; CHECK-V-NEXT:    mv a2, a1
; CHECK-V-NEXT:    blez a1, .LBB50_2
; CHECK-V-NEXT:  # %bb.1: # %entry
; CHECK-V-NEXT:    li a2, 1
; CHECK-V-NEXT:  .LBB50_2: # %entry
; CHECK-V-NEXT:    sgtz a3, s0
; CHECK-V-NEXT:    addi a3, a3, -1
; CHECK-V-NEXT:    and a3, a3, s1
; CHECK-V-NEXT:    addi a4, s0, -1
; CHECK-V-NEXT:    seqz a4, a4
; CHECK-V-NEXT:    addi a4, a4, -1
; CHECK-V-NEXT:    sgtz a5, a1
; CHECK-V-NEXT:    addi a5, a5, -1
; CHECK-V-NEXT:    addi a1, a1, -1
; CHECK-V-NEXT:    seqz a6, a1
; CHECK-V-NEXT:    blez s0, .LBB50_4
; CHECK-V-NEXT:  # %bb.3: # %entry
; CHECK-V-NEXT:    li s0, 1
; CHECK-V-NEXT:  .LBB50_4: # %entry
; CHECK-V-NEXT:    and a1, a5, a0
; CHECK-V-NEXT:    addi a5, a6, -1
; CHECK-V-NEXT:    and a0, a4, a3
; CHECK-V-NEXT:    beqz s0, .LBB50_6
; CHECK-V-NEXT:  # %bb.5: # %entry
; CHECK-V-NEXT:    sgtz a3, s0
; CHECK-V-NEXT:    neg a3, a3
; CHECK-V-NEXT:    and a0, a3, a0
; CHECK-V-NEXT:  .LBB50_6: # %entry
; CHECK-V-NEXT:    and a1, a5, a1
; CHECK-V-NEXT:    beqz a2, .LBB50_8
; CHECK-V-NEXT:  # %bb.7: # %entry
; CHECK-V-NEXT:    sgtz a2, a2
; CHECK-V-NEXT:    neg a2, a2
; CHECK-V-NEXT:    and a1, a2, a1
; CHECK-V-NEXT:  .LBB50_8: # %entry
; CHECK-V-NEXT:    sd a1, 24(sp)
; CHECK-V-NEXT:    sd a0, 32(sp)
; CHECK-V-NEXT:    addi a0, sp, 24
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    addi a0, sp, 32
; CHECK-V-NEXT:    vle64.v v9, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v9, 1
; CHECK-V-NEXT:    csrr a0, vlenb
; CHECK-V-NEXT:    slli a0, a0, 1
; CHECK-V-NEXT:    add sp, sp, a0
; CHECK-V-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 56(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 80
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> zeroinitializer)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f16i64_mm(<2 x half> %x) {
; CHECK-NOV-LABEL: stest_f16i64_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -32
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOV-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset s2, -32
; CHECK-NOV-NEXT:    mv s2, a1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    call __fixsfti@plt
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv s1, a1
; CHECK-NOV-NEXT:    mv a0, s2
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    call __fixsfti@plt
; CHECK-NOV-NEXT:    mv a2, a0
; CHECK-NOV-NEXT:    li a0, -1
; CHECK-NOV-NEXT:    srli a3, a0, 1
; CHECK-NOV-NEXT:    mv a4, a2
; CHECK-NOV-NEXT:    bgez a1, .LBB51_15
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    bgeu a2, a3, .LBB51_16
; CHECK-NOV-NEXT:  .LBB51_2: # %entry
; CHECK-NOV-NEXT:    bnez a1, .LBB51_17
; CHECK-NOV-NEXT:  .LBB51_3: # %entry
; CHECK-NOV-NEXT:    mv a4, s0
; CHECK-NOV-NEXT:    bgez s1, .LBB51_18
; CHECK-NOV-NEXT:  .LBB51_4: # %entry
; CHECK-NOV-NEXT:    bgeu s0, a3, .LBB51_19
; CHECK-NOV-NEXT:  .LBB51_5: # %entry
; CHECK-NOV-NEXT:    beqz s1, .LBB51_7
; CHECK-NOV-NEXT:  .LBB51_6: # %entry
; CHECK-NOV-NEXT:    mv s0, a4
; CHECK-NOV-NEXT:  .LBB51_7: # %entry
; CHECK-NOV-NEXT:    slti a6, a1, 0
; CHECK-NOV-NEXT:    slti a3, s1, 0
; CHECK-NOV-NEXT:    neg a3, a3
; CHECK-NOV-NEXT:    and a4, a3, s1
; CHECK-NOV-NEXT:    slli a3, a0, 63
; CHECK-NOV-NEXT:    mv a5, s0
; CHECK-NOV-NEXT:    bltz a4, .LBB51_20
; CHECK-NOV-NEXT:  # %bb.8: # %entry
; CHECK-NOV-NEXT:    neg a6, a6
; CHECK-NOV-NEXT:    bgeu a3, s0, .LBB51_21
; CHECK-NOV-NEXT:  .LBB51_9: # %entry
; CHECK-NOV-NEXT:    and a1, a6, a1
; CHECK-NOV-NEXT:    bne a4, a0, .LBB51_22
; CHECK-NOV-NEXT:  .LBB51_10: # %entry
; CHECK-NOV-NEXT:    mv a4, a2
; CHECK-NOV-NEXT:    bltz a1, .LBB51_23
; CHECK-NOV-NEXT:  .LBB51_11: # %entry
; CHECK-NOV-NEXT:    bgeu a3, a2, .LBB51_24
; CHECK-NOV-NEXT:  .LBB51_12: # %entry
; CHECK-NOV-NEXT:    beq a1, a0, .LBB51_14
; CHECK-NOV-NEXT:  .LBB51_13: # %entry
; CHECK-NOV-NEXT:    mv a2, a4
; CHECK-NOV-NEXT:  .LBB51_14: # %entry
; CHECK-NOV-NEXT:    mv a0, s0
; CHECK-NOV-NEXT:    mv a1, a2
; CHECK-NOV-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 32
; CHECK-NOV-NEXT:    ret
; CHECK-NOV-NEXT:  .LBB51_15: # %entry
; CHECK-NOV-NEXT:    mv a4, a3
; CHECK-NOV-NEXT:    bltu a2, a3, .LBB51_2
; CHECK-NOV-NEXT:  .LBB51_16: # %entry
; CHECK-NOV-NEXT:    mv a2, a3
; CHECK-NOV-NEXT:    beqz a1, .LBB51_3
; CHECK-NOV-NEXT:  .LBB51_17: # %entry
; CHECK-NOV-NEXT:    mv a2, a4
; CHECK-NOV-NEXT:    mv a4, s0
; CHECK-NOV-NEXT:    bltz s1, .LBB51_4
; CHECK-NOV-NEXT:  .LBB51_18: # %entry
; CHECK-NOV-NEXT:    mv a4, a3
; CHECK-NOV-NEXT:    bltu s0, a3, .LBB51_5
; CHECK-NOV-NEXT:  .LBB51_19: # %entry
; CHECK-NOV-NEXT:    mv s0, a3
; CHECK-NOV-NEXT:    bnez s1, .LBB51_6
; CHECK-NOV-NEXT:    j .LBB51_7
; CHECK-NOV-NEXT:  .LBB51_20: # %entry
; CHECK-NOV-NEXT:    mv a5, a3
; CHECK-NOV-NEXT:    neg a6, a6
; CHECK-NOV-NEXT:    bltu a3, s0, .LBB51_9
; CHECK-NOV-NEXT:  .LBB51_21: # %entry
; CHECK-NOV-NEXT:    mv s0, a3
; CHECK-NOV-NEXT:    and a1, a6, a1
; CHECK-NOV-NEXT:    beq a4, a0, .LBB51_10
; CHECK-NOV-NEXT:  .LBB51_22: # %entry
; CHECK-NOV-NEXT:    mv s0, a5
; CHECK-NOV-NEXT:    mv a4, a2
; CHECK-NOV-NEXT:    bgez a1, .LBB51_11
; CHECK-NOV-NEXT:  .LBB51_23: # %entry
; CHECK-NOV-NEXT:    mv a4, a3
; CHECK-NOV-NEXT:    bltu a3, a2, .LBB51_12
; CHECK-NOV-NEXT:  .LBB51_24: # %entry
; CHECK-NOV-NEXT:    mv a2, a3
; CHECK-NOV-NEXT:    bne a1, a0, .LBB51_13
; CHECK-NOV-NEXT:    j .LBB51_14
;
; CHECK-V-LABEL: stest_f16i64_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -48
; CHECK-V-NEXT:    .cfi_def_cfa_offset 48
; CHECK-V-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    .cfi_offset s2, -32
; CHECK-V-NEXT:    mv s2, a1
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    call __fixsfti@plt
; CHECK-V-NEXT:    mv s0, a0
; CHECK-V-NEXT:    mv s1, a1
; CHECK-V-NEXT:    mv a0, s2
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    call __fixsfti@plt
; CHECK-V-NEXT:    li a2, -1
; CHECK-V-NEXT:    srli a3, a2, 1
; CHECK-V-NEXT:    mv a4, a0
; CHECK-V-NEXT:    bgez a1, .LBB51_15
; CHECK-V-NEXT:  # %bb.1: # %entry
; CHECK-V-NEXT:    bgeu a0, a3, .LBB51_16
; CHECK-V-NEXT:  .LBB51_2: # %entry
; CHECK-V-NEXT:    bnez a1, .LBB51_17
; CHECK-V-NEXT:  .LBB51_3: # %entry
; CHECK-V-NEXT:    mv a4, s0
; CHECK-V-NEXT:    bgez s1, .LBB51_18
; CHECK-V-NEXT:  .LBB51_4: # %entry
; CHECK-V-NEXT:    bgeu s0, a3, .LBB51_19
; CHECK-V-NEXT:  .LBB51_5: # %entry
; CHECK-V-NEXT:    beqz s1, .LBB51_7
; CHECK-V-NEXT:  .LBB51_6: # %entry
; CHECK-V-NEXT:    mv s0, a4
; CHECK-V-NEXT:  .LBB51_7: # %entry
; CHECK-V-NEXT:    slti a6, a1, 0
; CHECK-V-NEXT:    slti a3, s1, 0
; CHECK-V-NEXT:    neg a3, a3
; CHECK-V-NEXT:    and a4, a3, s1
; CHECK-V-NEXT:    slli a3, a2, 63
; CHECK-V-NEXT:    mv a5, s0
; CHECK-V-NEXT:    bltz a4, .LBB51_20
; CHECK-V-NEXT:  # %bb.8: # %entry
; CHECK-V-NEXT:    neg a6, a6
; CHECK-V-NEXT:    bgeu a3, s0, .LBB51_21
; CHECK-V-NEXT:  .LBB51_9: # %entry
; CHECK-V-NEXT:    and a1, a6, a1
; CHECK-V-NEXT:    bne a4, a2, .LBB51_22
; CHECK-V-NEXT:  .LBB51_10: # %entry
; CHECK-V-NEXT:    mv a4, a0
; CHECK-V-NEXT:    bltz a1, .LBB51_23
; CHECK-V-NEXT:  .LBB51_11: # %entry
; CHECK-V-NEXT:    bgeu a3, a0, .LBB51_24
; CHECK-V-NEXT:  .LBB51_12: # %entry
; CHECK-V-NEXT:    beq a1, a2, .LBB51_14
; CHECK-V-NEXT:  .LBB51_13: # %entry
; CHECK-V-NEXT:    mv a0, a4
; CHECK-V-NEXT:  .LBB51_14: # %entry
; CHECK-V-NEXT:    sd a0, 8(sp)
; CHECK-V-NEXT:    sd s0, 0(sp)
; CHECK-V-NEXT:    addi a0, sp, 8
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v9, (a0)
; CHECK-V-NEXT:    mv a0, sp
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v9, 1
; CHECK-V-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 48
; CHECK-V-NEXT:    ret
; CHECK-V-NEXT:  .LBB51_15: # %entry
; CHECK-V-NEXT:    mv a4, a3
; CHECK-V-NEXT:    bltu a0, a3, .LBB51_2
; CHECK-V-NEXT:  .LBB51_16: # %entry
; CHECK-V-NEXT:    mv a0, a3
; CHECK-V-NEXT:    beqz a1, .LBB51_3
; CHECK-V-NEXT:  .LBB51_17: # %entry
; CHECK-V-NEXT:    mv a0, a4
; CHECK-V-NEXT:    mv a4, s0
; CHECK-V-NEXT:    bltz s1, .LBB51_4
; CHECK-V-NEXT:  .LBB51_18: # %entry
; CHECK-V-NEXT:    mv a4, a3
; CHECK-V-NEXT:    bltu s0, a3, .LBB51_5
; CHECK-V-NEXT:  .LBB51_19: # %entry
; CHECK-V-NEXT:    mv s0, a3
; CHECK-V-NEXT:    bnez s1, .LBB51_6
; CHECK-V-NEXT:    j .LBB51_7
; CHECK-V-NEXT:  .LBB51_20: # %entry
; CHECK-V-NEXT:    mv a5, a3
; CHECK-V-NEXT:    neg a6, a6
; CHECK-V-NEXT:    bltu a3, s0, .LBB51_9
; CHECK-V-NEXT:  .LBB51_21: # %entry
; CHECK-V-NEXT:    mv s0, a3
; CHECK-V-NEXT:    and a1, a6, a1
; CHECK-V-NEXT:    beq a4, a2, .LBB51_10
; CHECK-V-NEXT:  .LBB51_22: # %entry
; CHECK-V-NEXT:    mv s0, a5
; CHECK-V-NEXT:    mv a4, a0
; CHECK-V-NEXT:    bgez a1, .LBB51_11
; CHECK-V-NEXT:  .LBB51_23: # %entry
; CHECK-V-NEXT:    mv a4, a3
; CHECK-V-NEXT:    bltu a3, a0, .LBB51_12
; CHECK-V-NEXT:  .LBB51_24: # %entry
; CHECK-V-NEXT:    mv a0, a3
; CHECK-V-NEXT:    bne a1, a2, .LBB51_13
; CHECK-V-NEXT:    j .LBB51_14
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utesth_f16i64_mm(<2 x half> %x) {
; CHECK-NOV-LABEL: utesth_f16i64_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -32
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOV-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset s2, -32
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv a0, a1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    call __fixunssfti@plt
; CHECK-NOV-NEXT:    mv s1, a0
; CHECK-NOV-NEXT:    mv s2, a1
; CHECK-NOV-NEXT:    mv a0, s0
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    call __fixunssfti@plt
; CHECK-NOV-NEXT:    snez a2, a1
; CHECK-NOV-NEXT:    addi a2, a2, -1
; CHECK-NOV-NEXT:    and a0, a2, a0
; CHECK-NOV-NEXT:    addi a1, a1, -1
; CHECK-NOV-NEXT:    seqz a1, a1
; CHECK-NOV-NEXT:    addi a1, a1, -1
; CHECK-NOV-NEXT:    and a0, a1, a0
; CHECK-NOV-NEXT:    snez a1, s2
; CHECK-NOV-NEXT:    addi a1, a1, -1
; CHECK-NOV-NEXT:    and a1, a1, s1
; CHECK-NOV-NEXT:    addi a2, s2, -1
; CHECK-NOV-NEXT:    seqz a2, a2
; CHECK-NOV-NEXT:    addi a2, a2, -1
; CHECK-NOV-NEXT:    and a1, a2, a1
; CHECK-NOV-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 32
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: utesth_f16i64_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -48
; CHECK-V-NEXT:    .cfi_def_cfa_offset 48
; CHECK-V-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    .cfi_offset s2, -32
; CHECK-V-NEXT:    mv s0, a0
; CHECK-V-NEXT:    mv a0, a1
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    call __fixunssfti@plt
; CHECK-V-NEXT:    mv s1, a0
; CHECK-V-NEXT:    mv s2, a1
; CHECK-V-NEXT:    mv a0, s0
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    call __fixunssfti@plt
; CHECK-V-NEXT:    snez a2, a1
; CHECK-V-NEXT:    addi a2, a2, -1
; CHECK-V-NEXT:    and a0, a2, a0
; CHECK-V-NEXT:    addi a1, a1, -1
; CHECK-V-NEXT:    seqz a1, a1
; CHECK-V-NEXT:    addi a1, a1, -1
; CHECK-V-NEXT:    and a0, a1, a0
; CHECK-V-NEXT:    snez a1, s2
; CHECK-V-NEXT:    addi a1, a1, -1
; CHECK-V-NEXT:    and a1, a1, s1
; CHECK-V-NEXT:    addi a2, s2, -1
; CHECK-V-NEXT:    seqz a2, a2
; CHECK-V-NEXT:    addi a2, a2, -1
; CHECK-V-NEXT:    and a1, a2, a1
; CHECK-V-NEXT:    sd a1, 8(sp)
; CHECK-V-NEXT:    sd a0, 0(sp)
; CHECK-V-NEXT:    addi a0, sp, 8
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v9, (a0)
; CHECK-V-NEXT:    mv a0, sp
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v9, 1
; CHECK-V-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 48
; CHECK-V-NEXT:    ret
entry:
  %conv = fptoui <2 x half> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.umin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f16i64_mm(<2 x half> %x) {
; CHECK-NOV-LABEL: ustest_f16i64_mm:
; CHECK-NOV:       # %bb.0: # %entry
; CHECK-NOV-NEXT:    addi sp, sp, -32
; CHECK-NOV-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOV-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NOV-NEXT:    .cfi_offset ra, -8
; CHECK-NOV-NEXT:    .cfi_offset s0, -16
; CHECK-NOV-NEXT:    .cfi_offset s1, -24
; CHECK-NOV-NEXT:    .cfi_offset s2, -32
; CHECK-NOV-NEXT:    mv s2, a1
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    call __fixsfti@plt
; CHECK-NOV-NEXT:    mv s0, a0
; CHECK-NOV-NEXT:    mv s1, a1
; CHECK-NOV-NEXT:    mv a0, s2
; CHECK-NOV-NEXT:    call __extendhfsf2@plt
; CHECK-NOV-NEXT:    call __fixsfti@plt
; CHECK-NOV-NEXT:    mv a2, a1
; CHECK-NOV-NEXT:    blez a1, .LBB53_2
; CHECK-NOV-NEXT:  # %bb.1: # %entry
; CHECK-NOV-NEXT:    li a2, 1
; CHECK-NOV-NEXT:  .LBB53_2: # %entry
; CHECK-NOV-NEXT:    mv a4, s1
; CHECK-NOV-NEXT:    blez s1, .LBB53_4
; CHECK-NOV-NEXT:  # %bb.3: # %entry
; CHECK-NOV-NEXT:    li a4, 1
; CHECK-NOV-NEXT:  .LBB53_4: # %entry
; CHECK-NOV-NEXT:    sgtz a3, a1
; CHECK-NOV-NEXT:    addi a3, a3, -1
; CHECK-NOV-NEXT:    and a3, a3, a0
; CHECK-NOV-NEXT:    addi a0, a1, -1
; CHECK-NOV-NEXT:    seqz a0, a0
; CHECK-NOV-NEXT:    addi a1, a0, -1
; CHECK-NOV-NEXT:    sgtz a0, s1
; CHECK-NOV-NEXT:    addi a0, a0, -1
; CHECK-NOV-NEXT:    and a0, a0, s0
; CHECK-NOV-NEXT:    addi a5, s1, -1
; CHECK-NOV-NEXT:    seqz a5, a5
; CHECK-NOV-NEXT:    addi a5, a5, -1
; CHECK-NOV-NEXT:    and a0, a5, a0
; CHECK-NOV-NEXT:    beqz a4, .LBB53_6
; CHECK-NOV-NEXT:  # %bb.5: # %entry
; CHECK-NOV-NEXT:    sgtz a4, a4
; CHECK-NOV-NEXT:    neg a4, a4
; CHECK-NOV-NEXT:    and a0, a4, a0
; CHECK-NOV-NEXT:  .LBB53_6: # %entry
; CHECK-NOV-NEXT:    and a1, a1, a3
; CHECK-NOV-NEXT:    beqz a2, .LBB53_8
; CHECK-NOV-NEXT:  # %bb.7: # %entry
; CHECK-NOV-NEXT:    sgtz a2, a2
; CHECK-NOV-NEXT:    neg a2, a2
; CHECK-NOV-NEXT:    and a1, a2, a1
; CHECK-NOV-NEXT:  .LBB53_8: # %entry
; CHECK-NOV-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NOV-NEXT:    addi sp, sp, 32
; CHECK-NOV-NEXT:    ret
;
; CHECK-V-LABEL: ustest_f16i64_mm:
; CHECK-V:       # %bb.0: # %entry
; CHECK-V-NEXT:    addi sp, sp, -48
; CHECK-V-NEXT:    .cfi_def_cfa_offset 48
; CHECK-V-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; CHECK-V-NEXT:    .cfi_offset ra, -8
; CHECK-V-NEXT:    .cfi_offset s0, -16
; CHECK-V-NEXT:    .cfi_offset s1, -24
; CHECK-V-NEXT:    .cfi_offset s2, -32
; CHECK-V-NEXT:    mv s2, a1
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    call __fixsfti@plt
; CHECK-V-NEXT:    mv s0, a0
; CHECK-V-NEXT:    mv s1, a1
; CHECK-V-NEXT:    mv a0, s2
; CHECK-V-NEXT:    call __extendhfsf2@plt
; CHECK-V-NEXT:    call __fixsfti@plt
; CHECK-V-NEXT:    mv a2, a1
; CHECK-V-NEXT:    blez a1, .LBB53_2
; CHECK-V-NEXT:  # %bb.1: # %entry
; CHECK-V-NEXT:    li a2, 1
; CHECK-V-NEXT:  .LBB53_2: # %entry
; CHECK-V-NEXT:    mv a4, s1
; CHECK-V-NEXT:    blez s1, .LBB53_4
; CHECK-V-NEXT:  # %bb.3: # %entry
; CHECK-V-NEXT:    li a4, 1
; CHECK-V-NEXT:  .LBB53_4: # %entry
; CHECK-V-NEXT:    sgtz a3, a1
; CHECK-V-NEXT:    addi a3, a3, -1
; CHECK-V-NEXT:    and a3, a3, a0
; CHECK-V-NEXT:    addi a0, a1, -1
; CHECK-V-NEXT:    seqz a0, a0
; CHECK-V-NEXT:    addi a1, a0, -1
; CHECK-V-NEXT:    sgtz a0, s1
; CHECK-V-NEXT:    addi a0, a0, -1
; CHECK-V-NEXT:    and a0, a0, s0
; CHECK-V-NEXT:    addi a5, s1, -1
; CHECK-V-NEXT:    seqz a5, a5
; CHECK-V-NEXT:    addi a5, a5, -1
; CHECK-V-NEXT:    and a0, a5, a0
; CHECK-V-NEXT:    beqz a4, .LBB53_6
; CHECK-V-NEXT:  # %bb.5: # %entry
; CHECK-V-NEXT:    sgtz a4, a4
; CHECK-V-NEXT:    neg a4, a4
; CHECK-V-NEXT:    and a0, a4, a0
; CHECK-V-NEXT:  .LBB53_6: # %entry
; CHECK-V-NEXT:    and a1, a1, a3
; CHECK-V-NEXT:    beqz a2, .LBB53_8
; CHECK-V-NEXT:  # %bb.7: # %entry
; CHECK-V-NEXT:    sgtz a2, a2
; CHECK-V-NEXT:    neg a2, a2
; CHECK-V-NEXT:    and a1, a2, a1
; CHECK-V-NEXT:  .LBB53_8: # %entry
; CHECK-V-NEXT:    sd a1, 8(sp)
; CHECK-V-NEXT:    sd a0, 0(sp)
; CHECK-V-NEXT:    addi a0, sp, 8
; CHECK-V-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-V-NEXT:    vle64.v v9, (a0)
; CHECK-V-NEXT:    mv a0, sp
; CHECK-V-NEXT:    vle64.v v8, (a0)
; CHECK-V-NEXT:    vsetivli zero, 2, e64, m1, tu, ma
; CHECK-V-NEXT:    vslideup.vi v8, v9, 1
; CHECK-V-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; CHECK-V-NEXT:    addi sp, sp, 48
; CHECK-V-NEXT:    ret
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> zeroinitializer)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

declare <2 x i32> @llvm.smin.v2i32(<2 x i32>, <2 x i32>)
declare <2 x i32> @llvm.smax.v2i32(<2 x i32>, <2 x i32>)
declare <2 x i32> @llvm.umin.v2i32(<2 x i32>, <2 x i32>)
declare <4 x i32> @llvm.smin.v4i32(<4 x i32>, <4 x i32>)
declare <4 x i32> @llvm.smax.v4i32(<4 x i32>, <4 x i32>)
declare <4 x i32> @llvm.umin.v4i32(<4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.smin.v8i32(<8 x i32>, <8 x i32>)
declare <8 x i32> @llvm.smax.v8i32(<8 x i32>, <8 x i32>)
declare <8 x i32> @llvm.umin.v8i32(<8 x i32>, <8 x i32>)
declare <2 x i64> @llvm.smin.v2i64(<2 x i64>, <2 x i64>)
declare <2 x i64> @llvm.smax.v2i64(<2 x i64>, <2 x i64>)
declare <2 x i64> @llvm.umin.v2i64(<2 x i64>, <2 x i64>)
declare <4 x i64> @llvm.smin.v4i64(<4 x i64>, <4 x i64>)
declare <4 x i64> @llvm.smax.v4i64(<4 x i64>, <4 x i64>)
declare <4 x i64> @llvm.umin.v4i64(<4 x i64>, <4 x i64>)
declare <2 x i128> @llvm.smin.v2i128(<2 x i128>, <2 x i128>)
declare <2 x i128> @llvm.smax.v2i128(<2 x i128>, <2 x i128>)
declare <2 x i128> @llvm.umin.v2i128(<2 x i128>, <2 x i128>)
