; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh,+experimental-zvfh,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh,+experimental-zvfh,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

define <vscale x 1 x half> @vsitofp_nxv1i1_nxv1f16(<vscale x 1 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv1i1_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i1> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x half> @vuitofp_nxv1i1_nxv1f16(<vscale x 1 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv1i1_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i1> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x float> @vsitofp_nxv1i1_nxv1f32(<vscale x 1 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv1i1_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i1> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x float> @vuitofp_nxv1i1_nxv1f32(<vscale x 1 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv1i1_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i1> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x double> @vsitofp_nxv1i1_nxv1f64(<vscale x 1 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv1i1_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i1> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 1 x double> @vuitofp_nxv1i1_nxv1f64(<vscale x 1 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv1i1_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i1> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 2 x half> @vsitofp_nxv2i1_nxv2f16(<vscale x 2 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv2i1_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i1> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x half> @vuitofp_nxv2i1_nxv2f16(<vscale x 2 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv2i1_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i1> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x float> @vsitofp_nxv2i1_nxv2f32(<vscale x 2 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv2i1_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i1> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x float> @vuitofp_nxv2i1_nxv2f32(<vscale x 2 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv2i1_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i1> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x double> @vsitofp_nxv2i1_nxv2f64(<vscale x 2 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv2i1_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i1> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 2 x double> @vuitofp_nxv2i1_nxv2f64(<vscale x 2 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv2i1_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i1> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 4 x half> @vsitofp_nxv4i1_nxv4f16(<vscale x 4 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv4i1_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i1> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x half> @vuitofp_nxv4i1_nxv4f16(<vscale x 4 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv4i1_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i1> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x float> @vsitofp_nxv4i1_nxv4f32(<vscale x 4 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv4i1_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i1> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x float> @vuitofp_nxv4i1_nxv4f32(<vscale x 4 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv4i1_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i1> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x double> @vsitofp_nxv4i1_nxv4f64(<vscale x 4 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv4i1_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i1> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 4 x double> @vuitofp_nxv4i1_nxv4f64(<vscale x 4 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv4i1_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i1> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 8 x half> @vsitofp_nxv8i1_nxv8f16(<vscale x 8 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv8i1_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i1> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x half> @vuitofp_nxv8i1_nxv8f16(<vscale x 8 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv8i1_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i1> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x float> @vsitofp_nxv8i1_nxv8f32(<vscale x 8 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv8i1_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i1> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x float> @vuitofp_nxv8i1_nxv8f32(<vscale x 8 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv8i1_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i1> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x double> @vsitofp_nxv8i1_nxv8f64(<vscale x 8 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv8i1_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i1> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}

define <vscale x 8 x double> @vuitofp_nxv8i1_nxv8f64(<vscale x 8 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv8i1_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i1> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}

define <vscale x 16 x half> @vsitofp_nxv16i1_nxv16f16(<vscale x 16 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv16i1_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 16 x i1> %va to <vscale x 16 x half>
  ret <vscale x 16 x half> %evec
}

define <vscale x 16 x half> @vuitofp_nxv16i1_nxv16f16(<vscale x 16 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv16i1_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 16 x i1> %va to <vscale x 16 x half>
  ret <vscale x 16 x half> %evec
}

define <vscale x 16 x float> @vsitofp_nxv16i1_nxv16f32(<vscale x 16 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv16i1_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 16 x i1> %va to <vscale x 16 x float>
  ret <vscale x 16 x float> %evec
}

define <vscale x 16 x float> @vuitofp_nxv16i1_nxv16f32(<vscale x 16 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv16i1_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 16 x i1> %va to <vscale x 16 x float>
  ret <vscale x 16 x float> %evec
}

define <vscale x 32 x half> @vsitofp_nxv32i1_nxv32f16(<vscale x 32 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv32i1_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 32 x i1> %va to <vscale x 32 x half>
  ret <vscale x 32 x half> %evec
}

define <vscale x 32 x half> @vuitofp_nxv32i1_nxv32f16(<vscale x 32 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv32i1_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 32 x i1> %va to <vscale x 32 x half>
  ret <vscale x 32 x half> %evec
}

define <vscale x 1 x half> @vsitofp_nxv1i8_nxv1f16(<vscale x 1 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv1i8_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i8> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x half> @vsitofp_nxv1i7_nxv1f16(<vscale x 1 x i7> %va) {
; CHECK-LABEL: vsitofp_nxv1i7_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v8
; CHECK-NEXT:    vsra.vi v9, v8, 1
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i7> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x half> @vuitofp_nxv1i7_nxv1f16(<vscale x 1 x i7> %va) {
; CHECK-LABEL: vuitofp_nxv1i7_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 127
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vand.vx v9, v8, a0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i7> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x half> @vuitofp_nxv1i8_nxv1f16(<vscale x 1 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv1i8_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i8> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x float> @vsitofp_nxv1i8_nxv1f32(<vscale x 1 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv1i8_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vsext.vf4 v9, v8
; CHECK-NEXT:    vfcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i8> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x float> @vuitofp_nxv1i8_nxv1f32(<vscale x 1 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv1i8_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vzext.vf4 v9, v8
; CHECK-NEXT:    vfcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i8> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x double> @vsitofp_nxv1i8_nxv1f64(<vscale x 1 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv1i8_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vsext.vf8 v9, v8
; CHECK-NEXT:    vfcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i8> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 1 x double> @vuitofp_nxv1i8_nxv1f64(<vscale x 1 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv1i8_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vzext.vf8 v9, v8
; CHECK-NEXT:    vfcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i8> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 2 x half> @vsitofp_nxv2i8_nxv2f16(<vscale x 2 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv2i8_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i8> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x half> @vuitofp_nxv2i8_nxv2f16(<vscale x 2 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv2i8_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i8> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x float> @vsitofp_nxv2i8_nxv2f32(<vscale x 2 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv2i8_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vsext.vf4 v9, v8
; CHECK-NEXT:    vfcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i8> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x float> @vuitofp_nxv2i8_nxv2f32(<vscale x 2 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv2i8_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vzext.vf4 v9, v8
; CHECK-NEXT:    vfcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i8> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x double> @vsitofp_nxv2i8_nxv2f64(<vscale x 2 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv2i8_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vsext.vf8 v10, v8
; CHECK-NEXT:    vfcvt.f.x.v v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i8> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 2 x double> @vuitofp_nxv2i8_nxv2f64(<vscale x 2 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv2i8_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vfcvt.f.xu.v v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i8> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 4 x half> @vsitofp_nxv4i8_nxv4f16(<vscale x 4 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv4i8_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i8> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x half> @vuitofp_nxv4i8_nxv4f16(<vscale x 4 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv4i8_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i8> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x float> @vsitofp_nxv4i8_nxv4f32(<vscale x 4 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv4i8_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vsext.vf4 v10, v8
; CHECK-NEXT:    vfcvt.f.x.v v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i8> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x float> @vuitofp_nxv4i8_nxv4f32(<vscale x 4 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv4i8_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf4 v10, v8
; CHECK-NEXT:    vfcvt.f.xu.v v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i8> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x double> @vsitofp_nxv4i8_nxv4f64(<vscale x 4 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv4i8_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vsext.vf8 v12, v8
; CHECK-NEXT:    vfcvt.f.x.v v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i8> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 4 x double> @vuitofp_nxv4i8_nxv4f64(<vscale x 4 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv4i8_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vzext.vf8 v12, v8
; CHECK-NEXT:    vfcvt.f.xu.v v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i8> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 8 x half> @vsitofp_nxv8i8_nxv8f16(<vscale x 8 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv8i8_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i8> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x half> @vuitofp_nxv8i8_nxv8f16(<vscale x 8 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv8i8_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i8> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x float> @vsitofp_nxv8i8_nxv8f32(<vscale x 8 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv8i8_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vsext.vf4 v12, v8
; CHECK-NEXT:    vfcvt.f.x.v v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i8> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x float> @vuitofp_nxv8i8_nxv8f32(<vscale x 8 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv8i8_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vzext.vf4 v12, v8
; CHECK-NEXT:    vfcvt.f.xu.v v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i8> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x double> @vsitofp_nxv8i8_nxv8f64(<vscale x 8 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv8i8_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vsext.vf8 v16, v8
; CHECK-NEXT:    vfcvt.f.x.v v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i8> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}

define <vscale x 8 x double> @vuitofp_nxv8i8_nxv8f64(<vscale x 8 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv8i8_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vzext.vf8 v16, v8
; CHECK-NEXT:    vfcvt.f.xu.v v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i8> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}

define <vscale x 16 x half> @vsitofp_nxv16i8_nxv16f16(<vscale x 16 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv16i8_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 16 x i8> %va to <vscale x 16 x half>
  ret <vscale x 16 x half> %evec
}

define <vscale x 16 x half> @vuitofp_nxv16i8_nxv16f16(<vscale x 16 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv16i8_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 16 x i8> %va to <vscale x 16 x half>
  ret <vscale x 16 x half> %evec
}

define <vscale x 16 x float> @vsitofp_nxv16i8_nxv16f32(<vscale x 16 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv16i8_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vsext.vf4 v16, v8
; CHECK-NEXT:    vfcvt.f.x.v v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 16 x i8> %va to <vscale x 16 x float>
  ret <vscale x 16 x float> %evec
}

define <vscale x 16 x float> @vuitofp_nxv16i8_nxv16f32(<vscale x 16 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv16i8_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vzext.vf4 v16, v8
; CHECK-NEXT:    vfcvt.f.xu.v v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 16 x i8> %va to <vscale x 16 x float>
  ret <vscale x 16 x float> %evec
}

define <vscale x 32 x half> @vsitofp_nxv32i8_nxv32f16(<vscale x 32 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv32i8_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v16, v8
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 32 x i8> %va to <vscale x 32 x half>
  ret <vscale x 32 x half> %evec
}

define <vscale x 32 x half> @vuitofp_nxv32i8_nxv32f16(<vscale x 32 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv32i8_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 32 x i8> %va to <vscale x 32 x half>
  ret <vscale x 32 x half> %evec
}

define <vscale x 1 x half> @vsitofp_nxv1i16_nxv1f16(<vscale x 1 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv1i16_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i16> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x half> @vuitofp_nxv1i16_nxv1f16(<vscale x 1 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv1i16_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i16> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x float> @vsitofp_nxv1i16_nxv1f32(<vscale x 1 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv1i16_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i16> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x float> @vuitofp_nxv1i16_nxv1f32(<vscale x 1 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv1i16_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i16> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x double> @vsitofp_nxv1i16_nxv1f64(<vscale x 1 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv1i16_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vsext.vf4 v9, v8
; CHECK-NEXT:    vfcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i16> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 1 x double> @vuitofp_nxv1i16_nxv1f64(<vscale x 1 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv1i16_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vzext.vf4 v9, v8
; CHECK-NEXT:    vfcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i16> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 2 x half> @vsitofp_nxv2i16_nxv2f16(<vscale x 2 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv2i16_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i16> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x half> @vuitofp_nxv2i16_nxv2f16(<vscale x 2 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv2i16_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i16> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x float> @vsitofp_nxv2i16_nxv2f32(<vscale x 2 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv2i16_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i16> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x float> @vuitofp_nxv2i16_nxv2f32(<vscale x 2 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv2i16_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i16> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x double> @vsitofp_nxv2i16_nxv2f64(<vscale x 2 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv2i16_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vsext.vf4 v10, v8
; CHECK-NEXT:    vfcvt.f.x.v v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i16> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 2 x double> @vuitofp_nxv2i16_nxv2f64(<vscale x 2 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv2i16_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf4 v10, v8
; CHECK-NEXT:    vfcvt.f.xu.v v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i16> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 4 x half> @vsitofp_nxv4i16_nxv4f16(<vscale x 4 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv4i16_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i16> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x half> @vuitofp_nxv4i16_nxv4f16(<vscale x 4 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv4i16_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i16> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x float> @vsitofp_nxv4i16_nxv4f32(<vscale x 4 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv4i16_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i16> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x float> @vuitofp_nxv4i16_nxv4f32(<vscale x 4 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv4i16_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i16> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x double> @vsitofp_nxv4i16_nxv4f64(<vscale x 4 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv4i16_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vsext.vf4 v12, v8
; CHECK-NEXT:    vfcvt.f.x.v v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i16> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 4 x double> @vuitofp_nxv4i16_nxv4f64(<vscale x 4 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv4i16_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vzext.vf4 v12, v8
; CHECK-NEXT:    vfcvt.f.xu.v v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i16> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 8 x half> @vsitofp_nxv8i16_nxv8f16(<vscale x 8 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv8i16_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i16> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x half> @vuitofp_nxv8i16_nxv8f16(<vscale x 8 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv8i16_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i16> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x float> @vsitofp_nxv8i16_nxv8f32(<vscale x 8 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv8i16_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i16> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x float> @vuitofp_nxv8i16_nxv8f32(<vscale x 8 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv8i16_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i16> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x double> @vsitofp_nxv8i16_nxv8f64(<vscale x 8 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv8i16_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vsext.vf4 v16, v8
; CHECK-NEXT:    vfcvt.f.x.v v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i16> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}

define <vscale x 8 x double> @vuitofp_nxv8i16_nxv8f64(<vscale x 8 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv8i16_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vzext.vf4 v16, v8
; CHECK-NEXT:    vfcvt.f.xu.v v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i16> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}

define <vscale x 16 x half> @vsitofp_nxv16i16_nxv16f16(<vscale x 16 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv16i16_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 16 x i16> %va to <vscale x 16 x half>
  ret <vscale x 16 x half> %evec
}

define <vscale x 16 x half> @vuitofp_nxv16i16_nxv16f16(<vscale x 16 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv16i16_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 16 x i16> %va to <vscale x 16 x half>
  ret <vscale x 16 x half> %evec
}

define <vscale x 16 x float> @vsitofp_nxv16i16_nxv16f32(<vscale x 16 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv16i16_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v16, v8
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 16 x i16> %va to <vscale x 16 x float>
  ret <vscale x 16 x float> %evec
}

define <vscale x 16 x float> @vuitofp_nxv16i16_nxv16f32(<vscale x 16 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv16i16_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 16 x i16> %va to <vscale x 16 x float>
  ret <vscale x 16 x float> %evec
}

define <vscale x 32 x half> @vsitofp_nxv32i16_nxv32f16(<vscale x 32 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv32i16_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 32 x i16> %va to <vscale x 32 x half>
  ret <vscale x 32 x half> %evec
}

define <vscale x 32 x half> @vuitofp_nxv32i16_nxv32f16(<vscale x 32 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv32i16_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 32 x i16> %va to <vscale x 32 x half>
  ret <vscale x 32 x half> %evec
}

define <vscale x 1 x half> @vsitofp_nxv1i32_nxv1f16(<vscale x 1 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv1i32_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i32> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x half> @vuitofp_nxv1i32_nxv1f16(<vscale x 1 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv1i32_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i32> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x float> @vsitofp_nxv1i32_nxv1f32(<vscale x 1 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv1i32_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i32> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x float> @vuitofp_nxv1i32_nxv1f32(<vscale x 1 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv1i32_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i32> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x double> @vsitofp_nxv1i32_nxv1f64(<vscale x 1 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv1i32_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i32> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 1 x double> @vuitofp_nxv1i32_nxv1f64(<vscale x 1 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv1i32_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i32> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 2 x half> @vsitofp_nxv2i32_nxv2f16(<vscale x 2 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv2i32_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i32> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x half> @vuitofp_nxv2i32_nxv2f16(<vscale x 2 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv2i32_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i32> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x float> @vsitofp_nxv2i32_nxv2f32(<vscale x 2 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv2i32_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i32> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x float> @vuitofp_nxv2i32_nxv2f32(<vscale x 2 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv2i32_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i32> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x double> @vsitofp_nxv2i32_nxv2f64(<vscale x 2 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv2i32_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i32> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 2 x double> @vuitofp_nxv2i32_nxv2f64(<vscale x 2 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv2i32_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i32> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 4 x half> @vsitofp_nxv4i32_nxv4f16(<vscale x 4 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv4i32_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i32> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x half> @vuitofp_nxv4i32_nxv4f16(<vscale x 4 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv4i32_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i32> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x float> @vsitofp_nxv4i32_nxv4f32(<vscale x 4 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv4i32_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i32> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x float> @vuitofp_nxv4i32_nxv4f32(<vscale x 4 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv4i32_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i32> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x double> @vsitofp_nxv4i32_nxv4f64(<vscale x 4 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv4i32_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i32> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 4 x double> @vuitofp_nxv4i32_nxv4f64(<vscale x 4 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv4i32_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i32> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 8 x half> @vsitofp_nxv8i32_nxv8f16(<vscale x 8 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv8i32_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i32> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x half> @vuitofp_nxv8i32_nxv8f16(<vscale x 8 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv8i32_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i32> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x float> @vsitofp_nxv8i32_nxv8f32(<vscale x 8 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv8i32_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i32> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x float> @vuitofp_nxv8i32_nxv8f32(<vscale x 8 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv8i32_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i32> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x double> @vsitofp_nxv8i32_nxv8f64(<vscale x 8 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv8i32_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v16, v8
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i32> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}

define <vscale x 8 x double> @vuitofp_nxv8i32_nxv8f64(<vscale x 8 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv8i32_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i32> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}

define <vscale x 16 x half> @vsitofp_nxv16i32_nxv16f16(<vscale x 16 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv16i32_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v16, v8
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 16 x i32> %va to <vscale x 16 x half>
  ret <vscale x 16 x half> %evec
}

define <vscale x 16 x half> @vuitofp_nxv16i32_nxv16f16(<vscale x 16 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv16i32_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v16, v8
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 16 x i32> %va to <vscale x 16 x half>
  ret <vscale x 16 x half> %evec
}

define <vscale x 16 x float> @vsitofp_nxv16i32_nxv16f32(<vscale x 16 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv16i32_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 16 x i32> %va to <vscale x 16 x float>
  ret <vscale x 16 x float> %evec
}

define <vscale x 16 x float> @vuitofp_nxv16i32_nxv16f32(<vscale x 16 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv16i32_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 16 x i32> %va to <vscale x 16 x float>
  ret <vscale x 16 x float> %evec
}

define <vscale x 1 x half> @vsitofp_nxv1i64_nxv1f16(<vscale x 1 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv1i64_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i64> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x half> @vuitofp_nxv1i64_nxv1f16(<vscale x 1 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv1i64_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i64> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x float> @vsitofp_nxv1i64_nxv1f32(<vscale x 1 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv1i64_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i64> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x float> @vuitofp_nxv1i64_nxv1f32(<vscale x 1 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv1i64_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i64> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x double> @vsitofp_nxv1i64_nxv1f64(<vscale x 1 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv1i64_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i64> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 1 x double> @vuitofp_nxv1i64_nxv1f64(<vscale x 1 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv1i64_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i64> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 2 x half> @vsitofp_nxv2i64_nxv2f16(<vscale x 2 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv2i64_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i64> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x half> @vuitofp_nxv2i64_nxv2f16(<vscale x 2 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv2i64_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i64> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x float> @vsitofp_nxv2i64_nxv2f32(<vscale x 2 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv2i64_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i64> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x float> @vuitofp_nxv2i64_nxv2f32(<vscale x 2 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv2i64_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i64> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x double> @vsitofp_nxv2i64_nxv2f64(<vscale x 2 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv2i64_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i64> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 2 x double> @vuitofp_nxv2i64_nxv2f64(<vscale x 2 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv2i64_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i64> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 4 x half> @vsitofp_nxv4i64_nxv4f16(<vscale x 4 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv4i64_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i64> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x half> @vuitofp_nxv4i64_nxv4f16(<vscale x 4 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv4i64_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i64> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x float> @vsitofp_nxv4i64_nxv4f32(<vscale x 4 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv4i64_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i64> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x float> @vuitofp_nxv4i64_nxv4f32(<vscale x 4 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv4i64_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i64> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x double> @vsitofp_nxv4i64_nxv4f64(<vscale x 4 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv4i64_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i64> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 4 x double> @vuitofp_nxv4i64_nxv4f64(<vscale x 4 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv4i64_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i64> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 8 x half> @vsitofp_nxv8i64_nxv8f16(<vscale x 8 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv8i64_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i64> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x half> @vuitofp_nxv8i64_nxv8f16(<vscale x 8 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv8i64_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i64> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x float> @vsitofp_nxv8i64_nxv8f32(<vscale x 8 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv8i64_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v16, v8
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i64> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x float> @vuitofp_nxv8i64_nxv8f32(<vscale x 8 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv8i64_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v16, v8
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i64> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x double> @vsitofp_nxv8i64_nxv8f64(<vscale x 8 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv8i64_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i64> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}

define <vscale x 8 x double> @vuitofp_nxv8i64_nxv8f64(<vscale x 8 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv8i64_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i64> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}
