from typing import Any

from selenium.webdriver.remote.command import Command as Command

from . import interaction as interaction
from .key_actions import KeyActions as KeyActions
from .key_input import KeyInput as KeyInput
from .pointer_actions import PointerActions as PointerActions
from .pointer_input import PointerInput as PointerInput

class ActionBuilder:
    devices: Any
    driver: Any
    def __init__(self, driver, mouse: Any | None = ..., keyboard: Any | None = ...) -> None: ...
    def get_device_with(self, name): ...
    @property
    def pointer_inputs(self): ...
    @property
    def key_inputs(self): ...
    @property
    def key_action(self): ...
    @property
    def pointer_action(self): ...
    def add_key_input(self, name): ...
    def add_pointer_input(self, kind, name): ...
    def perform(self) -> None: ...
    def clear_actions(self) -> None: ...
