from collections.abc import Callable, Generator, Iterable
from html.parser import HTMLParser
from typing import Any, TypeVar

_KT = TypeVar("_KT")
_VT = TypeVar("_VT")

unichr = chr

def camel2under(camel_string: str) -> str: ...
def under2camel(under_string: str) -> str: ...
def slugify(text: str, delim: str = "_", lower: bool = True, ascii: bool = False) -> str: ...
def split_punct_ws(text: str) -> str: ...
def unit_len(sized_iterable: Iterable[Any], unit_noun: str = "item") -> str: ...
def ordinalize(number: int | str, ext_only: bool = False) -> str: ...
def cardinalize(unit_noun: str, count: int) -> str: ...
def singularize(word: str) -> str: ...
def pluralize(word: str) -> str: ...
def find_hashtags(string: str) -> list[str]: ...
def a10n(string: str) -> str: ...
def strip_ansi(text: str) -> str: ...
def asciify(text: str, ignore: bool = False): ...
def is_ascii(text: str) -> bool: ...

class DeaccenterDict(dict[_KT, _VT]):
    def __missing__(self, key: _KT) -> _VT: ...
    def __getitem__(self, key: _KT) -> _VT: ...

def bytes2human(nbytes: int, ndigits: int = 0) -> str: ...

class HTMLTextExtractor(HTMLParser):
    strict: bool
    convert_charrefs: bool
    result: list[str]
    def __init__(self) -> None: ...
    def handle_data(self, d: str) -> None: ...
    def handle_charref(self, number: str) -> None: ...
    def handle_entityref(self, name: str) -> None: ...
    def get_text(self) -> str: ...

def html2text(html: str) -> str: ...
def gunzip_bytes(bytestring: bytes) -> bytes: ...
def gzip_bytes(bytestring: bytes, level: int = 6) -> int: ...
def iter_splitlines(text: str) -> Generator[str, None, None]: ...
def indent(text: str, margin: str, newline: str = "\n", key: Callable[..., bool] = ...) -> str: ...
def is_uuid(obj, version: int = 4) -> bool: ...
def escape_shell_args(args: list[str], sep: str = " ", style: str | None = None) -> str: ...
def args2sh(args: list[str], sep: str = " ") -> str: ...
def args2cmd(args: list[str], sep: str = " ") -> str: ...
def parse_int_list(range_string: str, delim: str = ",", range_delim: str = "-") -> list[int]: ...
def format_int_list(int_list: list[int], delim: str = ",", range_delim: str = "-", delim_space: bool = False) -> str: ...

class MultiReplace:
    group_map: dict[str, str]
    combined_pattern: str
    def __init__(self, sub_map: dict[str, str], **kwargs) -> None: ...
    def sub(self, text: str) -> str: ...

def multi_replace(text: str, sub_map: dict[str, str], **kwargs) -> str: ...
def unwrap_text(text: str, ending: str = "\n\n") -> str: ...

# Names in __all__ with no definition:
#   int_list_complement
#   int_list_to_int_tuples
