#!/usr/bin/python3
# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
#
# Copyright (C) 2010-2012 Bryce Harrington <bryce@canonical.com>
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

import os
import re
import glob
import DistUtilsExtra.auto

from xdiagnose import info

changelog = "debian/changelog"
if os.path.exists(changelog):
    head=open(changelog).readline()
    match = re.compile(r".*\(([^)]*)\).*").match(head)
    if match:
        version = match.group(1)
        # Remove possible suffixes like build*, ubuntu*, to solve
        # packaging.version.InvalidVersion: Invalid version: '3.8.11ubuntu1'
        version = re.sub(r"[A-Za-z~].*", '', version)
        
# TODO: Also set the VERSION in info.py

DistUtilsExtra.auto.setup(
    name             = info.PROGNAME,
    version          = version,
    url              = info.URL,
    author           = info.LEAD_DEVELOPER.name,
    author_email     = info.LEAD_DEVELOPER.email,
    description      = info.SHORT_DESCRIPTION,
    long_description = info.DESCRIPTION,
    license          = info.LICENSE_URL,
    platforms        = ['any'],
    requires         = ['gobject', 'pygtk'],
    # Note: Requires pep8 and pydoctor for make lint
    packages     = [
        'xdiagnose',
        'xdiagnose/utils',
        ],
    package_data = {
        },
    data_files   = [
        ('share/xdiagnose/workloads',     glob.glob('data/workloads/*')),
        ('share/xdiagnose',               glob.glob('data/failsafe*')),
        ('share/xdiagnose',               ['data/bubu.lib']),
        ],
    scripts      = [
        'bin/dpkg-log-summary',
        'bin/xdiagnose',
        'bin/xdiagnose-pkexec',
        'bin/xedid',
        'bin/xrandr-tool',
        'bin/xrotate',
        'bin/xpci',
        ],
    )
