/*
 * YICS: Connect a FICS interface to the Yahoo! Chess server.
 * Copyright (C) 2004  Chris Howie
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _VARS_H
#define _VARS_H

#include "types.h"

extern Variable variables[];
extern Variable tvariables[];

#if 0
extern int getvari(Variable *, const char *);
extern String *getvars(Variable *, const char *);
#endif

enum {
	VARSET_OK = 0,
	VARSET_NOTFOUND,
	VARSET_AMBIGUOUS,
	VARSET_BAD,
	VARSET_LOCKED
};

enum {
	VAR_AUTOSTART = 0,
	VAR_INC,
	VAR_LOCK,
	VAR_MS,
	VAR_NOTIMEOUT,
	VAR_OPEN,
	VAR_PIN,
	VAR_PTIME,
	VAR_RATED,
	VAR_SEEK,
	VAR_SHOUT,
	VAR_SINGLEBOARD,
	VAR_STYLE,
	VAR_TIME,
	VAR_TOLERANCE,

	VAR_INTERFACE,
	VAR_FORMULA,
	VAR_F1, VAR_F2, VAR_F3, VAR_F4, VAR_F5,
	VAR_F6, VAR_F7, VAR_F8, VAR_F9
};

extern int setvar(Variable *, const char *, const char *, Variable **);

#endif
