package ONVIF::Device::Types::OSDColor;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS = 'ONVIF::Device::Types::OSDColor::_OSDColor::XmlAttr';

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Color_of :ATTR(:get<Color>);

__PACKAGE__->_factory(
    [ qw(        Color

    ) ],
    {
        'Color' => \%Color_of,
    },
    {
        'Color' => 'ONVIF::Device::Types::Color',
    },
    {

        'Color' => 'Color',
    }
);

} # end BLOCK




package ONVIF::Device::Types::OSDColor::_OSDColor::XmlAttr;
use base qw(SOAP::WSDL::XSD::Typelib::AttributeSet);

{ # BLOCK to scope variables

my %Transparent_of :ATTR(:get<Transparent>);

__PACKAGE__->_factory(
    [ qw(
        Transparent
    ) ],
    {

        Transparent => \%Transparent_of,
    },
    {
        Transparent => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    }
);

} # end BLOCK




1;


=pod

=head1 NAME

ONVIF::Device::Types::OSDColor

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
OSDColor from the namespace http://www.onvif.org/ver10/schema.

The value range of "Transparent" could be defined by vendors only should follow this rule: the minimum value means non-transparent and the maximum value maens fully transparent.




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Color




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::OSDColor
   Color => ,
 },



=head2 attr

NOTE: Attribute documentation is experimental, and may be inaccurate.
See the correspondent WSDL/XML Schema if in question.

This class has additional attributes, accessibly via the C<attr()> method.

attr() returns an object of the class ONVIF::Device::Types::OSDColor::_OSDColor::XmlAttr.

The following attributes can be accessed on this object via the corresponding
get_/set_ methods:

=over

=item * Transparent



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::int|SOAP::WSDL::XSD::Typelib::Builtin::int>.


=back




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

