package ONVIF::PTZ::Types::WhiteBalance20;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Mode_of :ATTR(:get<Mode>);
my %CrGain_of :ATTR(:get<CrGain>);
my %CbGain_of :ATTR(:get<CbGain>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Mode
        CrGain
        CbGain
        Extension

    ) ],
    {
        'Mode' => \%Mode_of,
        'CrGain' => \%CrGain_of,
        'CbGain' => \%CbGain_of,
        'Extension' => \%Extension_of,
    },
    {
        'Mode' => 'ONVIF::PTZ::Types::WhiteBalanceMode',
        'CrGain' => 'SOAP::WSDL::XSD::Typelib::Builtin::float',
        'CbGain' => 'SOAP::WSDL::XSD::Typelib::Builtin::float',
        'Extension' => 'ONVIF::PTZ::Types::WhiteBalance20Extension',
    },
    {

        'Mode' => 'Mode',
        'CrGain' => 'CrGain',
        'CbGain' => 'CbGain',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::WhiteBalance20

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
WhiteBalance20 from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Mode


=item * CrGain


=item * CbGain


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::WhiteBalance20
   Mode => $some_value, # WhiteBalanceMode
   CrGain =>  $some_value, # float
   CbGain =>  $some_value, # float
   Extension =>  { # ONVIF::PTZ::Types::WhiteBalance20Extension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

