/*******************************************************************************
 * Copyright (C) 2004-2007 Intel Corp. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *   - Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 * 
 *   - Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 * 
 *   - Neither the name of Intel Corp. nor the names of its
 *     contributors may be used to endorse or promote products derived from this
 *     software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL Intel Corp. OR THE CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************/

//----------------------------------------------------------------------------
//
//  File:       PTHIcommand->h
//
//  Contents:   header file of PTHICommand class
//
//----------------------------------------------------------------------------
#ifndef __PTHI_COMMAND_H__
#define __PTHI_COMMAND_H__
#include "HECILinux.h"

#define CERT_HASH_MAX_LENGTH                    64
#define CERT_HASH_MAX_NUMBER                    23
#define NET_TLS_CERT_PKI_MAX_SERIAL_NUMS        3
#define NET_TLS_CERT_PKI_MAX_SERIAL_NUM_LENGTH  16

/*
* Type definitions
*/
typedef char    CHAR;
typedef unsigned char   UINT8;
typedef unsigned short  UINT16;
typedef unsigned int    UINT32;
typedef unsigned long   ULONG;
typedef UINT32 AMT_BOOLEAN;
typedef UINT32 AMT_STATUS;
typedef UINT32 CFG_PROVISIONING_MODE;

typedef enum _AMT_PROVISIONING_MODE
{
	PROVISIONING_MODE_NONE =0,
	PROVISIONING_MODE_ENTERPRISE,
	PROVISIONING_MODE_SMB
}AMT_PROVISIONING_MODE;

typedef enum _AMT_PROVISIONING_TLS_MODE
{
	NOT_READY = 0,
	PSK  = 1,
	PKI  = 2
} AMT_PROVISIONING_TLS_MODE;

typedef enum _AMT_PROVISIONING_STATE
{
	PROVISIONING_STATE_PRE  = 0,
	PROVISIONING_STATE_IN   = 1,
	PROVISIONING_STATE_POST = 2
} AMT_PROVISIONING_STATE;
typedef enum _AMT_RNG_STATUS
{
	RNG_STATUS_EXIST  = 0,
	RNG_STATUS_IN_PROGRESS = 1,
	RNG_STATUS_NOT_EXIST = 2
} AMT_RNG_STATUS;

static const UINT32 BIOS_VERSION_LEN = 65;
static const UINT32 VERSIONS_NUMBER  = 50;
static const UINT32 UNICODE_STRING_LEN = 20;


#pragma pack (1)
typedef struct _AMT_UNICODE_STRING
{
	UINT16  Length;
	UINT8   String[UNICODE_STRING_LEN];
} AMT_UNICODE_STRING;

typedef struct _AMT_VERSION_TYPE
{
	AMT_UNICODE_STRING   Description;
	AMT_UNICODE_STRING   Version;
}AMT_VERSION_TYPE;

typedef struct _PTHI_VERSION
{
	UINT8   MajorNumber;
	UINT8   MinorNumber;
} PTHI_VERSION;

typedef struct _CODE_VERSIONS
{
	UINT8   BiosVersion[BIOS_VERSION_LEN];
	UINT32  VersionsCount;
	AMT_VERSION_TYPE Versions[VERSIONS_NUMBER];
} CODE_VERSIONS;

typedef struct _COMMAND_FMT
{
	union
	{
		UINT32  val;
		struct
		{
			UINT32   Operation   : 23;
			UINT32   IsResponse  : 1;
			UINT32   Class       : 8;
		} fields;
	} cmd;

} COMMAND_FMT;
typedef struct _AMT_HASH_HANDLES
{
	UINT32	Length;
	UINT32	Handles[CERT_HASH_MAX_NUMBER];
}AMT_HASH_HANDLES;

typedef struct _AMT_ANSI_STRING
{
	UINT16	Length;
	CHAR*	Buffer;
}AMT_ANSI_STRING;

typedef struct _CERTHASH_ENTRY
{
	AMT_BOOLEAN     IsDefault;
	AMT_BOOLEAN     IsActive;
	UINT8           CertificateHash[CERT_HASH_MAX_LENGTH];
	UINT8           HashAlgorithm;
	AMT_ANSI_STRING Name;
}CERTHASH_ENTRY;


typedef struct _PTHI_MESSAGE_HEADER
{
	PTHI_VERSION Version;
	UINT16       Reserved;
	COMMAND_FMT  Command;
	UINT32       Length;

} PTHI_MESSAGE_HEADER;
typedef enum
{
	CERT_HASH_ALGORITHM_MD5 = 0,  // 16 bytes
	CERT_HASH_ALGORITHM_SHA1,     // 20 bytes
	CERT_HASH_ALGORITHM_SHA256,   // 32 bytes
	CERT_HASH_ALGORITHM_SHA512,   // 64 bytes
} CERT_HASH_ALGORITHM;
typedef struct
{
	UINT16      Year;
	UINT16      Month;
	UINT16      DayOfWeek;
	UINT16      Day;
	UINT16      Hour;
	UINT16      Minute;
	UINT16      Second;
} TIME_DATE;
typedef struct _AMT_PROV_AUDIT_RECORD
{
	UINT8                ProvisioningTLSMode;
	AMT_BOOLEAN          SecureDNS;
	AMT_BOOLEAN          HostInitiated;
	CERT_HASH_ALGORITHM  SelectedHashType;
	UINT8                SelectedHashData[CERT_HASH_MAX_LENGTH];
	UINT8                CaCertificateSerials[NET_TLS_CERT_PKI_MAX_SERIAL_NUMS*NET_TLS_CERT_PKI_MAX_SERIAL_NUM_LENGTH];
	AMT_BOOLEAN          AdditionalCaSerialNums;
	AMT_BOOLEAN          IsOemDefault;
	AMT_BOOLEAN          IsTimeValid;
	UINT32               ProvServerIP;
	TIME_DATE            TlsStartTime;
	AMT_ANSI_STRING      ProvServerFQDN;
}AMT_PROV_AUDIT_RECORD;

typedef struct _CFG_GET_CODE_VERSIONS_RESPONSE
{
	PTHI_MESSAGE_HEADER Header;
	AMT_STATUS   Status;
	CODE_VERSIONS CodeVersions;
} CFG_GET_CODE_VERSIONS_RESPONSE;
typedef struct _CFG_GET_PROVISIONING_MODE_RESPONSE
{
	PTHI_MESSAGE_HEADER	Header;
	AMT_STATUS	Status;
	CFG_PROVISIONING_MODE	ProvisioningMode;
	AMT_BOOLEAN	LegacyMode;
} CFG_GET_PROVISIONING_MODE_RESPONSE;

typedef struct _CFG_GET_PROVISIONING_STATE_RESPONSE
{
	PTHI_MESSAGE_HEADER	Header;
	AMT_STATUS	Status;
	AMT_PROVISIONING_STATE	ProvisioningState;
} CFG_GET_PROVISIONING_STATE_RESPONSE;

typedef struct _CFG_GENERATE_RNG_SEED_RESPONSE
{
	PTHI_MESSAGE_HEADER Header;
	AMT_STATUS   Status;
} CFG_GENERATE_RNG_SEED_RESPONSE;

typedef struct _CFG_GET_RNG_SEED_STATUS_RESPONSE
{
	PTHI_MESSAGE_HEADER Header;
	AMT_STATUS   Status;
	AMT_RNG_STATUS RngStatus;
} CFG_GET_RNG_SEED_STATUS_RESPONSE;


typedef struct _CFG_GET_ZERO_TOUCH_ENABLED_RESPONSE
{
	PTHI_MESSAGE_HEADER	Header;
	AMT_STATUS	Status;
	AMT_BOOLEAN	ZeroTouchEnabled;
} CFG_GET_ZERO_TOUCH_ENABLED_RESPONSE;

typedef struct _CFG_GET_PROVISIONING_TLS_MODE_RESPONSE
{
	PTHI_MESSAGE_HEADER	Header;
	AMT_STATUS	Status;
	AMT_PROVISIONING_TLS_MODE	ProvisioningTlsMode;
} CFG_GET_PROVISIONING_TLS_MODE_RESPONSE;

typedef struct _CFG_START_CONFIGURATION_RESPONSE
{
	PTHI_MESSAGE_HEADER Header;
	AMT_STATUS   Status;
} CFG_START_CONFIGURATION_RESPONSE;

typedef struct _CFG_SET_PROVISIONING_SERVER_OTP_RESPONSE
{
	PTHI_MESSAGE_HEADER Header;
	AMT_STATUS   Status;
} CFG_SET_PROVISIONING_SERVER_OTP_RESPONSE;

typedef struct _CFG_SET_DNS_SUFFIX_RESPONSE
{
	PTHI_MESSAGE_HEADER Header;
	AMT_STATUS   Status;
} CFG_SET_DNS_SUFFIX_RESPONSE;

typedef struct _CFG_GET_HASH_HANDLES_RESPONSE
{
	PTHI_MESSAGE_HEADER Header;
	AMT_STATUS          Status;
	AMT_HASH_HANDLES    HashHandles;
} CFG_GET_HASH_HANDLES_RESPONSE;

typedef struct _CFG_GET_CERTHASH_ENTRY_RESPONSE
{
	PTHI_MESSAGE_HEADER         Header;
	AMT_STATUS                  Status;
	CERTHASH_ENTRY              Hash;
} CFG_GET_CERTHASH_ENTRY_RESPONSE;
typedef struct _CFG_GET_PKI_FQDN_SUFFIX_RESPONSE
{
	PTHI_MESSAGE_HEADER      Header;
	AMT_STATUS               Status;
	AMT_ANSI_STRING          Suffix;
} CFG_GET_PKI_FQDN_SUFFIX_RESPONSE;
typedef struct _CFG_GET_AUDIT_RECORD_RESPONSE
{
	PTHI_MESSAGE_HEADER         Header;
	AMT_STATUS                  Status;
	AMT_PROV_AUDIT_RECORD       AuditRecord;
} CFG_GET_AUDIT_RECORD_RESPONSE;

typedef struct _CFG_GET_PID_RESPONSE
{
	PTHI_MESSAGE_HEADER		Header;
	AMT_STATUS		        Status;
	UINT8		            PID[8];
} CFG_GET_PID_RESPONSE;

typedef struct _CFG_SET_CONF_SERVER_FQDN_RESPONSE
{
	PTHI_MESSAGE_HEADER		Header;
	AMT_STATUS		        Status;
} CFG_SET_CONF_SERVER_FQDN_RESPONSE;
typedef struct _CFG_GET_CONF_SERVER_FQDN_RESPONSE
{
	PTHI_MESSAGE_HEADER		Header;
	AMT_STATUS		        Status;
	AMT_ANSI_STRING	        FQDN;
} CFG_GET_CONF_SERVER_FQDN_RESPONSE;

typedef struct _CFG_SET_CERTHASH_STATE_REQUEST
{
	PTHI_MESSAGE_HEADER	Header;
	UINT32	            Handle;
	AMT_BOOLEAN	        IsActive;
} CFG_SET_CERTHASH_STATE_REQUEST;

typedef struct _CFG_SET_CERTHASH_STATE_RESPONSE
{
	PTHI_MESSAGE_HEADER		Header;
	AMT_STATUS		        Status;
} CFG_SET_CERTHASH_STATE_RESPONSE;
typedef struct _CFG_ADD_CERTHASH_ENTRY_RESPONSE
{
	PTHI_MESSAGE_HEADER		Header;
	AMT_STATUS		        Status;
	UINT32		            Handle;
} CFG_ADD_CERTHASH_ENTRY_RESPONSE;
typedef struct _CFG_DELETE_CERTHASH_ENTRY_REQUEST
{
	PTHI_MESSAGE_HEADER	Header;
	UINT32	            Handle;
} CFG_DELETE_CERTHASH_ENTRY_REQUEST;
typedef struct _CFG_DELETE_CERTHASH_ENTRY_RESPONSE
{
	PTHI_MESSAGE_HEADER		Header;
	AMT_STATUS		        Status;
} CFG_DELETE_CERTHASH_ENTRY_RESPONSE;
typedef struct _CFG_SET_ZTC_MODE_REQUEST
{
	PTHI_MESSAGE_HEADER	Header;
	AMT_BOOLEAN	        Mode;
} CFG_SET_ZTC_MODE_REQUEST;
typedef struct _CFG_SET_ZTC_MODE_RESPONSE
{
	PTHI_MESSAGE_HEADER		Header;
	AMT_STATUS		        Status;
} CFG_SET_ZTC_MODE_RESPONSE;




#pragma pack ( )

class PTHICommand
{
public:
	PTHICommand(bool verbose = false);
	~PTHICommand();
	AMT_STATUS GetCodeVersions(CODE_VERSIONS *CodeVersions);
	VOID DisplayCodeVersions(const CODE_VERSIONS *versions);

	AMT_STATUS GetProvisioningMode(AMT_BOOLEAN *legacy,CFG_PROVISIONING_MODE *mode);
	VOID DisplayAMTMode(const AMT_BOOLEAN *legacy);

	AMT_STATUS GetProvisioningState(AMT_PROVISIONING_STATE *state);
	VOID DisplayProvisioningState(const AMT_PROVISIONING_STATE *state);

	AMT_STATUS GenerateRngKey();

	AMT_STATUS GetRngSeedStatus(AMT_RNG_STATUS *rngStatus);
	VOID DisplayRngSeedStatus(const AMT_RNG_STATUS *rngStatus);
	AMT_STATUS GetZeroTouchEnabled(AMT_BOOLEAN *zeroTouchEnabled);
	VOID DisplayZTCEnabled(const AMT_BOOLEAN *ztcEnabled);

	AMT_STATUS GetProvisioningTlsMode(AMT_PROVISIONING_TLS_MODE *provisioningTlsMode);
	VOID DisplayProvisioningTlsMode(const AMT_PROVISIONING_TLS_MODE *provisioningTlsMode);
	AMT_STATUS StartConfiguration();

	AMT_STATUS SetProvisioningServerOTP(AMT_ANSI_STRING passwordOTP);

	AMT_STATUS SetDnsSuffix(AMT_ANSI_STRING dnsSuffix);

	AMT_STATUS EnumerateHashHandles(AMT_HASH_HANDLES *hashHandles);
	AMT_STATUS GetCertificateHashEntry(UINT32 hashHandle, CERTHASH_ENTRY *hashEntry);
	AMT_STATUS GetDnsSuffix(AMT_ANSI_STRING *dnsSuffix);
	AMT_STATUS GetAMTSetupAuditRecord(AMT_PROV_AUDIT_RECORD *auditRecord);
	VOID DisplayHashEntry(CERTHASH_ENTRY hashEntry);
	AMT_STATUS GetPID(UINT8 *pid);
	AMT_STATUS SetConfServerFQDN(AMT_ANSI_STRING confServerFQDN);
	AMT_STATUS GetConfServerFQDN(AMT_ANSI_STRING *confServerFQDN);
	AMT_STATUS SetCertificateHashState(UINT32 handle , AMT_BOOLEAN isActive );
	AMT_STATUS AddCertificateHashEntry( AMT_BOOLEAN	isDefault,
		AMT_BOOLEAN	isActive,
		UINT8	certificateHash[20],
		AMT_ANSI_STRING	name ,
		UINT32 *handle);
	AMT_STATUS DeleteCustomizedCertificateHashEntry(UINT32 handle);
	AMT_STATUS SetZeroTouchEnabled( AMT_BOOLEAN mode );
	HECILinux PTHIClient;
private:
	AMT_STATUS _verifyResponseHeader(const UINT32 command,const PTHI_MESSAGE_HEADER *response_header,UINT32 response_size);
	AMT_STATUS _verifyProvisioningState(const CFG_GET_PROVISIONING_STATE_RESPONSE *response);
	AMT_STATUS _verifyProvisioningMode(const CFG_GET_PROVISIONING_MODE_RESPONSE *response);
	AMT_STATUS _verifyCodeVersions(const CFG_GET_CODE_VERSIONS_RESPONSE *response);
	AMT_STATUS _verifyGenerateRngKey(const CFG_GENERATE_RNG_SEED_RESPONSE *response);
	AMT_STATUS _verifyGetRngSeedStatus(const CFG_GET_RNG_SEED_STATUS_RESPONSE *response);
	AMT_STATUS _verifyGetZeroTouchEnabled(const CFG_GET_ZERO_TOUCH_ENABLED_RESPONSE *response);
	AMT_STATUS _verifyGetProvisioningTlsMode(const CFG_GET_PROVISIONING_TLS_MODE_RESPONSE *response);
	AMT_STATUS _verifyStartConfiguration(const CFG_START_CONFIGURATION_RESPONSE *response);
	AMT_STATUS _verifySetProvisioningServerOTP(const CFG_SET_PROVISIONING_SERVER_OTP_RESPONSE *response);
	AMT_STATUS _verifySetDnsSuffix(const CFG_SET_DNS_SUFFIX_RESPONSE *response);
	AMT_STATUS _verifyHashHandles(const CFG_GET_HASH_HANDLES_RESPONSE *response);
	AMT_STATUS _verifyGetCertificateHashEntry(const CFG_GET_CERTHASH_ENTRY_RESPONSE *response);
	AMT_STATUS _verifyGetDnsSuffix(const CFG_GET_PKI_FQDN_SUFFIX_RESPONSE *response);
	AMT_STATUS _verifyGetAMTSetupAuditRecord(const CFG_GET_AUDIT_RECORD_RESPONSE *response);
	AMT_STATUS _verifyGetPID(const CFG_GET_PID_RESPONSE *response);
	AMT_STATUS _verifySetConfServerFQDN(const CFG_SET_CONF_SERVER_FQDN_RESPONSE *response);
	AMT_STATUS _verifyGetConfServerFQDN(const CFG_GET_CONF_SERVER_FQDN_RESPONSE *response);
	AMT_STATUS _verifySetCertificateHashState(const CFG_SET_CERTHASH_STATE_RESPONSE *response);
	AMT_STATUS _verifyAddCertificateHashEntry(const CFG_ADD_CERTHASH_ENTRY_RESPONSE *response);
	AMT_STATUS _verifyDeleteCertificateHashEntry(const CFG_DELETE_CERTHASH_ENTRY_RESPONSE *response);
	AMT_STATUS _verifySetZeroTouchEnabled(const CFG_SET_ZTC_MODE_RESPONSE *response);

};

/*
* Constants
*/
const UINT8 AMT_MAJOR_VERSION = 1;
const UINT8 AMT_MINOR_VERSION = 1;

const UINT32 CODE_VERSIONS_REQUEST     = 0x0400001A;
const UINT32 CODE_VERSIONS_RESPONSE    = 0x0480001A;

const PTHI_MESSAGE_HEADER GET_CODE_VERSION_HEADER =
{
	{AMT_MAJOR_VERSION,AMT_MINOR_VERSION},0,{CODE_VERSIONS_REQUEST},0
};

const UINT32 PROVISIONING_MODE_REQUEST     = 0x04000008;
const UINT32 PROVISIONING_MODE_RESPONSE    = 0x04800008;

const PTHI_MESSAGE_HEADER GET_PROVISIONING_MODE_HEADER =
{
	{AMT_MAJOR_VERSION,AMT_MINOR_VERSION},0,{PROVISIONING_MODE_REQUEST},0
};

const UINT32 PROVISIONING_STATE_REQUEST    = 0x04000011;
const UINT32 PROVISIONING_STATE_RESPONSE   = 0x04800011;

const PTHI_MESSAGE_HEADER GET_PROVISIONING_STATE_HEADER =
{
	{AMT_MAJOR_VERSION,AMT_MINOR_VERSION},0,{PROVISIONING_STATE_REQUEST},0
};

const UINT32 GENERATE_RNG_SEED_REQUEST    = 0x04000028;
const UINT32 GENERATE_RNG_SEED_RESPONSE   = 0x04800028;

const PTHI_MESSAGE_HEADER GENERATE_RNG_SEED_HEADER =
{
	{AMT_MAJOR_VERSION,AMT_MINOR_VERSION},0,{GENERATE_RNG_SEED_REQUEST},0
};

const UINT32 GET_RNG_SEED_STATUS_REQUEST    = 0x0400002E;
const UINT32 GET_RNG_SEED_STATUS_RESPONSE   = 0x0480002E;

const PTHI_MESSAGE_HEADER GET_RNG_SEED_STATUS_HEADER =
{
	{AMT_MAJOR_VERSION,AMT_MINOR_VERSION},0,{GET_RNG_SEED_STATUS_REQUEST},0
};


const UINT32 GET_ZERO_TOUCH_ENABLED_REQUEST    = 0x04000030;
const UINT32 GET_ZERO_TOUCH_ENABLED_RESPONSE   = 0x04800030;

const PTHI_MESSAGE_HEADER GET_ZERO_TOUCH_ENABLED_HEADER =
{
	{AMT_MAJOR_VERSION,AMT_MINOR_VERSION},0,{GET_ZERO_TOUCH_ENABLED_REQUEST},0
};

const UINT32 GET_PROVISIONING_TLS_MODE_REQUEST     = 0x0400002B;
const UINT32 GET_PROVISIONING_TLS_MODE_RESPONSE    = 0x0480002B;

const PTHI_MESSAGE_HEADER GET_PROVISIONING_TLS_MODE_HEADER =
{
	{AMT_MAJOR_VERSION,AMT_MINOR_VERSION},0,{GET_PROVISIONING_TLS_MODE_REQUEST},0
};

const UINT32 START_CONFIGURATION_REQUEST     = 0x04000029;
const UINT32 START_CONFIGURATION_RESPONSE    = 0x04800029;

const PTHI_MESSAGE_HEADER START_CONFIGURATION_HEADER =
{
	{AMT_MAJOR_VERSION,AMT_MINOR_VERSION},0,{START_CONFIGURATION_REQUEST},0
};

const UINT32 SET_PROVISIONING_SERVER_OTP_REQUEST     = 0x0400002A;
const UINT32 SET_PROVISIONING_SERVER_OTP_RESPONSE    = 0x0480002A;

const UINT32 SET_DNS_SUFFIX_REQUEST     = 0x0400002F;
const UINT32 SET_DNS_SUFFIX_RESPONSE    = 0x0480002F;

const UINT32 ENUMERATE_HASH_HANDLES_REQUEST     = 0x0400002C;
const UINT32 ENUMERATE_HASH_HANDLES_RESPONSE    = 0x0480002C;

const PTHI_MESSAGE_HEADER ENUMERATE_HASH_HANDLES_HEADER =
{
	{AMT_MAJOR_VERSION,AMT_MINOR_VERSION},0,{ENUMERATE_HASH_HANDLES_REQUEST},0
};

const UINT32 GET_CERTHASH_ENTRY_REQUEST     = 0x0400002D;
const UINT32 GET_CERTHASH_ENTRY_RESPONSE    = 0x0480002D;

const UINT32 GET_PKI_FQDN_SUFFIX_REQUEST    = 0x04000036;
const UINT32 GET_PKI_FQDN_SUFFIX_RESPONSE   = 0x04800036;
const PTHI_MESSAGE_HEADER GET_PKI_FQDN_SUFFIX_HEADER =
{
	{AMT_MAJOR_VERSION,AMT_MINOR_VERSION},0,{GET_PKI_FQDN_SUFFIX_REQUEST},0
};
const UINT32  GET_AUDIT_RECORD_REQUEST      = 0x04000027;
const UINT32  GET_AUDIT_RECORD_RESPONSE     = 0x04800027;
const PTHI_MESSAGE_HEADER GET_AUDIT_RECORD_HEADER =
{
	{AMT_MAJOR_VERSION,AMT_MINOR_VERSION},0,{GET_AUDIT_RECORD_REQUEST},0
};

const UINT32  GET_PID_REQUEST      = 0x0400003B;
const UINT32  GET_PID_RESPONSE     = 0x0480003B;
const PTHI_MESSAGE_HEADER GET_PID_HEADER =
{
	{AMT_MAJOR_VERSION,AMT_MINOR_VERSION},0,{GET_PID_REQUEST},0
};
const UINT32 SET_CONF_SERVER_FQDN_REQUEST     = 0x04000034;
const UINT32 SET_CONF_SERVER_FQDN_RESPONSE    = 0x04800034;

const UINT32 GET_CONF_SERVER_FQDN_REQUEST     = 0x04000033;
const UINT32 GET_CONF_SERVER_FQDN_RESPONSE    = 0x04800033;
const PTHI_MESSAGE_HEADER GET_CONF_SERVER_FQDN_HEADER =
{
	{AMT_MAJOR_VERSION,AMT_MINOR_VERSION},0,{GET_CONF_SERVER_FQDN_REQUEST},0
};

const UINT32 SET_CERTHASH_STATE_REQUEST     = 0x04000037;
const UINT32 SET_CERTHASH_STATE_RESPONSE    = 0x04800037;

const PTHI_MESSAGE_HEADER  SET_CERTHASH_STATE_HEADER =
{
	{AMT_MAJOR_VERSION,AMT_MINOR_VERSION},0,{SET_CERTHASH_STATE_REQUEST},sizeof(CFG_SET_CERTHASH_STATE_REQUEST)
};


const UINT32 ADD_CERTHASH_ENTRY_REQUEST     = 0x04000038;
const UINT32 ADD_CERTHASH_ENTRY_RESPONSE    = 0x04800038;

const UINT32 DELETE_CERTHASH_ENTRY_REQUEST     = 0x04000039;
const UINT32 DELETE_CERTHASH_ENTRY_RESPONSE    = 0x04800039;

const PTHI_MESSAGE_HEADER  DELETE_CERTHASH_ENTRY_HEADER =
{
	{AMT_MAJOR_VERSION,AMT_MINOR_VERSION},0,{DELETE_CERTHASH_ENTRY_REQUEST},sizeof(CFG_SET_CERTHASH_STATE_REQUEST)
};

const UINT32 SET_ZTC_MODE_REQUEST     = 0x0400003A;
const UINT32 SET_ZTC_MODE_RESPONSE    = 0x0480003A;

const PTHI_MESSAGE_HEADER  SET_ZTC_MODE_HEADER =
{
	{AMT_MAJOR_VERSION,AMT_MINOR_VERSION},0,{SET_ZTC_MODE_REQUEST},sizeof(CFG_SET_ZTC_MODE_REQUEST)
};

#endif
