/****************************************************************************
**
** Copyright (C) 2012 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** GNU Lesser General Public License Usage
** This file may be used under the terms of the GNU Lesser General Public
** License version 2.1 as published by the Free Software Foundation and
** appearing in the file LICENSE.LGPL included in the packaging of this
** file. Please review the following information to ensure the GNU Lesser
** General Public License version 2.1 requirements will be met:
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU General
** Public License version 3.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of this
** file. Please review the following information to ensure the GNU General
** Public License version 3.0 requirements will be met:
** http://www.gnu.org/copyleft/gpl.html.
**
** Other Usage
** Alternatively, this file may be used in accordance with the terms and
** conditions contained in a signed written agreement between you and Nokia.
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QEGLPROPERTIES_P_H
#define QEGLPROPERTIES_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of the QtOpenGL and QtOpenVG modules.  This header file may change from
// version to version without notice, or even be removed.
//
// We mean it.
//

#include <QtCore/qvarlengtharray.h>
#include <QtGui/qimage.h>

#include <QtGui/private/qegl_p.h>

QT_BEGIN_NAMESPACE

class QX11Info;
class QPaintDevice;

class Q_GUI_EXPORT QEglProperties
{
public:
    QEglProperties();
    QEglProperties(EGLConfig);
    QEglProperties(const QEglProperties& other) : props(other.props) {}
    ~QEglProperties() {}

    int value(int name) const;
    void setValue(int name, int value);
    bool removeValue(int name);
    bool isEmpty() const { return props[0] == EGL_NONE; }

    const int *properties() const { return props.constData(); }

    void setPixelFormat(QImage::Format pixelFormat);
#ifdef Q_WS_X11
    void setVisualFormat(const QX11Info *xinfo);
#endif
    void setDeviceType(int devType);
    void setPaintDeviceFormat(QPaintDevice *dev);
    void setRenderableType(QEgl::API api);

    bool reduceConfiguration();

    QString toString() const;

private:
    QVarLengthArray<int> props;
};

QT_END_NAMESPACE

#endif // QEGLPROPERTIES_P_H
