/*****************************************************************************
 * Bitmaps.h
 *****************************************************************************
 * Copyright (C) 2001 VideoLAN
 * $Id: Bitmaps.h,v 1.4 2001/03/21 13:42:33 sam Exp $
 *
 * Authors: Tony Castley <tcastley@mail.powerup.com.au>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

// #include "Bitmaps.h"

const unsigned char eject16x11_raw[] = {
0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0x00,0x17,0x18,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0x00,0x17,0x17,0x18,0x17,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x00,0x17,0x18,0x17,0x18,0x17,0x17,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x17,0x18,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff};
const unsigned char pause16x10_raw[] = {
0x00,0x00,0x00,0x00,0x3f,0xff,0xff,0x00,0x00,0x00,0x00,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,
0x00,0x3f,0x3f,0x3f,0x3f,0xff,0xff,0x00,0x3f,0x3f,0x3f,0x3f,0xff,0xff,0xff,0xff};
const unsigned char play16x10_raw[] = {
0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x18,0x17,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x18,0x17,0x18,0x17,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x18,0x17,0x17,0x18,0x17,0x18,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x17,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x17,0x17,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff};
const unsigned char skipleft24x8_raw[] = {
0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,
0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x3f,
0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0x00,0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0x00,0x00,0x17,0x18,0x17,
0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x17,0x18,0x17,0x17,0x3f,
0xff,0x00,0x00,0x17,0x18,0x17,0x18,0x17,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x3f,0x3f,0x17,0x17,0x18,0x17,0x17,0x3f,0xff,0x3f,0x3f,0x17,0x17,0x18,0x17,0x17,
0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x3f,0x17,0x17,0x18,0x3f,
0xff,0xff,0xff,0x3f,0x3f,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0x3f,0x3f,0x17,0x3f,0xff,0xff,0xff,0xff,0xff,0x3f,0x3f,0x17,
0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x3f,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff};
const unsigned char skipright24x8_raw[] = {
0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x00,0x00,0xff,0xff,0xff,0xff,
0xff,0x00,0x18,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x00,0x00,0xff,0xff,0xff,0x00,0x18,0x17,0x17,0x00,0x00,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x18,0x17,0x17,0x00,0x00,
0xff,0x00,0x17,0x18,0x17,0x17,0x18,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x17,0x17,0x3f,0x3f,0xff,0x00,0x17,0x18,0x17,0x18,0x17,0x3f,
0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0x3f,0xff,0xff,
0xff,0x00,0x17,0x18,0x17,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x3f,0x3f,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff};
const unsigned char skiptrackleft24x8_raw[] = {
0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x3f,0xff,0xff,0xff,0xff,0xff,0x00,
0x00,0x17,0x3f,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x3f,0xff,0xff,0xff,0xff,
0x00,0x3f,0xff,0xff,0xff,0x00,0x00,0x17,0x18,0x17,0x3f,0xff,0xff,0xff,0x00,0x00,
0x17,0x18,0x17,0x3f,0xff,0xff,0xff,0xff,0x00,0x3f,0xff,0x00,0x00,0x17,0x18,0x17,
0x18,0x17,0x3f,0xff,0x00,0x00,0x17,0x18,0x17,0x18,0x17,0x3f,0xff,0xff,0xff,0xff,
0x00,0x3f,0xff,0x3f,0x3f,0x17,0x17,0x18,0x17,0x17,0x3f,0xff,0x3f,0x3f,0x17,0x17,
0x18,0x17,0x17,0x3f,0xff,0xff,0xff,0xff,0x00,0x3f,0xff,0xff,0xff,0x3f,0x3f,0x17,
0x17,0x18,0x3f,0xff,0xff,0xff,0x3f,0x3f,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,
0x00,0x3f,0xff,0xff,0xff,0xff,0xff,0x3f,0x3f,0x17,0x3f,0xff,0xff,0xff,0xff,0xff,
0x3f,0x3f,0x17,0x3f,0xff,0xff,0xff,0xff,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x3f,0xff,0xff,0xff,0xff};
const unsigned char skiptrackright24x8_raw[] = {
0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x17,0x00,0x00,0xff,0xff,0xff,0xff,
0xff,0x00,0x18,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x00,0x00,0xff,0xff,0xff,0x00,0x18,0x17,0x17,0x00,0x00,0xff,
0xff,0xff,0x00,0x3f,0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x18,0x17,0x17,0x00,0x00,
0xff,0x00,0x17,0x18,0x17,0x17,0x18,0x00,0x00,0xff,0x00,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x17,0x17,0x3f,0x3f,0xff,0x00,0x17,0x18,0x17,0x18,0x17,0x3f,
0x3f,0xff,0x00,0x3f,0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0x3f,0xff,0xff,
0xff,0x00,0x17,0x18,0x17,0x3f,0x3f,0xff,0xff,0xff,0x00,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x3f,0x3f,0xff,0xff,0xff,
0xff,0xff,0x00,0x3f,0xff,0xff,0xff,0xff,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x3f,0xff,0xff,0xff,0xff};
const unsigned char stop8x8_raw[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x3f,
0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x3f,0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x3f,
0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x3f,0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x3f,
0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x3f,0x00,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f};
const unsigned char LCDLarge96x16_raw[] = {
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x8d,0x21,0x21,0x22,0x21,0x8d,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,0xff,0x8d,0x22,0x21,0x21,0x22,0x8d,0x21,
0xff,0x8d,0x22,0x21,0x21,0x22,0x8d,0x21,0x21,0x8d,0xff,0xff,0xff,0xff,0x8d,0x22,
0x21,0x8d,0x21,0x21,0x22,0x21,0x8d,0xff,0x22,0x8d,0x21,0x21,0x22,0x21,0x8d,0xff,
0xff,0x8d,0x22,0x21,0x21,0x22,0x8d,0x21,0x21,0x8d,0x21,0x22,0x21,0x21,0x8d,0x22,
0x21,0x8d,0x21,0x22,0x21,0x21,0x8d,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0x21,0x22,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0x21,0x22,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0x21,0x22,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0x21,0x22,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x8d,0x22,0x21,0x21,0x22,0x8d,0xff,0x22,0x8d,0xff,0xff,0xff,0xff,0x8d,0x22,
0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,0xff,0x8d,0x22,0x21,0x21,0x22,0x8d,0x21,
0xff,0x8d,0x22,0x21,0x21,0x22,0x8d,0x21,0x21,0x8d,0x21,0x22,0x21,0x21,0x8d,0x22,
0x21,0x8d,0x21,0x22,0x21,0x21,0xff,0xff,0x22,0x8d,0x21,0x21,0x22,0x21,0x8d,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,0x21,0x8d,0x21,0x21,0x22,0x21,0x8d,0x21,
0x22,0x8d,0x21,0x21,0x22,0x21,0x8d,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,0x8d,0xff,0xff,0xff,0xff,0xff,0xff,0x8d,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x8d,0x22,0x21,0x21,0x21,0x22,0x21,0x8d,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0x8d,0x8d,0x21,0x22,0x21,0x21,0x22,0x21,0x8d,
0x8d,0x21,0x22,0x21,0x21,0x22,0x21,0x8d,0x8d,0x21,0x21,0x22,0x21,0x21,0x22,0x8d,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x8d,0x22,0x21,0x21,0x21,0x22,0x21,0x8d,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0x8d,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x8d,0xff,0xff,0xff,0xff,0x8d,0x22,
0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,0x21,0x8d,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,
0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,0x21,0x8d,0xff,0xff,0xff,0xff,0x8d,0x22,
0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,0x21,0x8d,0xff,0xff,0xff,0xff,0x8d,0x22,
0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x8d,0x21,0x21,0x22,0x21,0x8d,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,0x21,0x8d,0x21,0x21,0x22,0x21,0xff,0xff,
0xff,0xff,0x22,0x21,0x21,0x22,0x8d,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,
0xff,0x8d,0x22,0x21,0x21,0x22,0x8d,0x21,0x21,0x8d,0x21,0x22,0x21,0x21,0x8d,0x22,
0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,0x21,0x8d,0x21,0x21,0x22,0x21,0x8d,0x21,
0xff,0x8d,0x22,0x21,0x21,0x22,0x8d,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff};
const unsigned char LCDMedium64x9_raw[] = {
0xff,0xff,0xff,0xff,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0x34,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0x34,0xff,0xff,0xff,0x34,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0x34,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x34,0x34,0x34,0xff,0x8d,0xff,0xff,0xff,0x8d,0xff,0xff,0xff,0xff,0x8d,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0x8d,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x34,0x34,0x34,
0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0x34,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0x34,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0x34,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
};
const unsigned char LCDsmall64x8_raw[] = {
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0x22,0xff,
0x22,0x21,0x21,0xff,0xff,0x22,0x21,0x21,0xff,0x22,0xff,0xff,0xff,0x22,0xff,0x22,
0x21,0x21,0xff,0xff,0x22,0x21,0x21,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0x22,0x21,
0x21,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0xff,
0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0x22,0x21,0xff,
0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,
0xff,0x22,0x21,0xff,0xff,0xff,0x22,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0xff,
0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0x22,0x21,0xff,
0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,
0xff,0x22,0x21,0xff,0xff,0xff,0x22,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x22,0x21,0x21,0xff,0x8d,0xff,0xff,0xff,0x8d,0xff,0xff,0xff,0xff,0x8d,0xff,
0x22,0x21,0x21,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0x22,
0x21,0x21,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0x8d,0xff,0x22,0x21,
0x21,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,
0xff,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0xff,0xff,
0xff,0xff,0x22,0x21,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,
0xff,0x22,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0xff,0xff,
0xff,0xff,0x22,0x21,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,
0xff,0x22,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0xff,0xff,
0xff,0xff,0x22,0x21,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,
0xff,0x22,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0x22,0xff,
0x22,0x21,0x21,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0x22,0xff,0x22,
0x21,0x21,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0x22,0xff,0x22,0x21,
0x21,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
};

const int32 kSpeakerIconBitmapWidth = 16;
const int32 kSpeakerIconBitmapHeight = 9;
const BPoint kSpeakerButtonSize(kSpeakerIconBitmapWidth - 1, kSpeakerIconBitmapHeight - 1);


const unsigned char kSpeakerIconBits [] = {
	0xff,0xff,0xff,0xff,0xff,0x10,0x10,0xff,0xff,0xff,0xff,0x10,0xff,0xff,0xff,0xff,
	0x10,0x10,0x10,0xff,0x10,0x1d,0x10,0xff,0xff,0xff,0xff,0xff,0x10,0xff,0xff,0xff,
	0x10,0x1d,0x10,0x10,0x1d,0x1d,0x10,0xff,0xff,0x10,0xff,0xff,0x10,0xff,0xff,0xff,
	0x10,0x1d,0x10,0x1d,0x1d,0x1d,0x10,0xff,0xff,0xff,0x10,0xff,0xff,0x10,0xff,0xff,
	0x10,0x1d,0x10,0x1d,0x1d,0x1d,0x10,0xff,0x10,0xff,0x10,0xff,0xff,0x10,0xff,0xff,
	0x10,0x1d,0x10,0x1d,0x1d,0x1d,0x10,0xff,0xff,0xff,0x10,0xff,0xff,0x10,0xff,0xff,
	0x10,0x1d,0x10,0x10,0x1d,0x1d,0x10,0xff,0xff,0x10,0xff,0xff,0x10,0xff,0xff,0xff,
	0x10,0x10,0x10,0xff,0x10,0x1d,0x10,0xff,0xff,0xff,0xff,0xff,0x10,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0x10,0x10,0xff,0xff,0xff,0xff,0x10,0xff,0xff,0xff,0xff,
};

const unsigned char kPressedSpeakerIconBits [] = {
	0xff,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,
	0x34,0x34,0x34,0xff,0x34,0x1d,0x34,0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,
	0x34,0x1d,0x34,0x34,0x1d,0x1d,0x34,0xff,0xff,0x34,0xff,0xff,0x34,0xff,0xff,0xff,
	0x34,0x1d,0x34,0x1d,0x1d,0x1d,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0x34,0xff,0xff,
	0x34,0x1d,0x34,0x1d,0x1d,0x1d,0x34,0xff,0x34,0xff,0x34,0xff,0xff,0x34,0xff,0xff,
	0x34,0x1d,0x34,0x1d,0x1d,0x1d,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0x34,0xff,0xff,
	0x34,0x1d,0x34,0x34,0x1d,0x1d,0x34,0xff,0xff,0x34,0xff,0xff,0x34,0xff,0xff,0xff,
	0x34,0x34,0x34,0xff,0x34,0x1d,0x34,0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,
};


// #pragma mark play

const int32 kPlayPauseBitmapWidth = 48;
const int32 kPlayPauseBitmapHeight = 22;
const BPoint kPlayButtonSize(kPlayPauseBitmapWidth - 1, kPlayPauseBitmapHeight - 1);

const unsigned char kPlayButtonBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x1a,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x1a,0x15,0x14,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x18,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0x1a,0x14,0x11,0x11,0x16,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1c,0x19,0x16,0x12,0x11,0x11,0x19,0xff,0xff,0xff,0xff,
	0xff,0xff,0x19,0x12,0x10,0x17,0x1c,0x1e,0x1e,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x18,0x14,0x11,0x12,0x19,0xff,0xff,0xff,
	0xff,0x1a,0x16,0x10,0x17,0x1e,0x1e,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x14,0x11,0x16,0x1a,0xff,0xff,
	0xff,0x1a,0x11,0x12,0x1d,0x1e,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x11,0x1a,0xff,0xff,
	0xff,0x17,0x11,0x18,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x00,0x00,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x00,0x10,0x1a,0x1a,0x00,0x00,0x00,0x10,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x11,0x15,0xff,0xff,
	0xff,0x14,0x11,0x1d,0x1d,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x12,0x13,0xff,0xff,
	0xff,0x13,0x10,0x1e,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x1c,0xff,
	0xff,0x13,0x10,0x3f,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x10,0x3f,0xff,
	0xff,0x13,0x10,0x1d,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x10,0x3f,0xff,
	0xff,0x13,0x10,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x3f,0xff,
	0xff,0x15,0x10,0x15,0x18,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x16,0x1e,0xff,
	0xff,0x17,0x11,0x13,0x16,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x10,0x3f,0x3f,0x3f,0x1a,0x1a,0x10,0x3f,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x14,0x10,0x1a,0x1e,0xff,
	0xff,0xff,0x13,0x11,0x14,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x10,0x16,0x1e,0x1c,0xff,
	0xff,0xff,0x18,0x11,0x12,0x14,0x18,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x10,0x12,0x1b,0x3f,0xff,0xff,
	0xff,0xff,0xff,0x18,0x11,0x11,0x14,0x17,0x18,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x18,0x17,0x12,0x10,0x12,0x19,0x3f,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x19,0x12,0x11,0x12,0x12,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x12,0x10,0x10,0x16,0x1b,0x3f,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0x19,0x19,0x16,0x13,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x17,0x1a,0x1d,0x3f,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1e,0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
};


const unsigned char kDisabledPlayButtonBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x1a,0x1a,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1a,0x1a,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x1a,0x19,0x18,
	0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x1a,0x1a,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x1a,0x19,0x18,0x18,0x1a,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1b,0x19,0x18,0x18,0x1a,0x1a,0xff,0xff,0xff,0xff,0xff,0x1a,
	0x19,0x18,0x19,0x1c,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,
	0x18,0x18,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x18,0x19,0x1c,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x18,0x1a,0x1c,
	0xff,0xff,0xff,0x1a,0x19,0x18,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x18,0x1c,0xff,0xff,0xff,0x1a,
	0x18,0x1a,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x16,
	0x16,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,
	0x16,0x1b,0x1b,0x1b,0x16,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1a,0x18,0x1a,0x1c,0xff,0xff,0x19,0x17,0x1c,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x16,0x16,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x1c,0x1b,0x1b,
	0x16,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,
	0x19,0x1c,0xff,0xff,0x19,0x16,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x16,0x19,0x19,0x19,0x19,0x19,0x16,0x16,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x16,0x19,0x19,0x1c,0x1b,0x1b,0x16,0x19,0x19,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x17,0x1c,0xff,0xff,
	0x19,0x16,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x16,
	0x19,0x19,0x1c,0x1b,0x1b,0x16,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x1c,0xff,0xff,0x19,0x16,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x1c,0x1b,
	0x1b,0x16,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x18,0x18,0x1c,0xff,0xff,0x19,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x19,0x19,0x1c,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x1c,0x1b,0x1b,0x16,0x19,0x19,
	0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x1c,0xff,
	0xff,0x19,0x17,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,
	0x19,0x19,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x16,0x19,0x19,0x1c,0x1b,0x1b,0x16,0x19,0x19,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x19,0x1c,0xff,0xff,0x1a,0x18,0x19,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x1c,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,
	0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1a,0x17,0x1a,0x1c,0xff,0xff,0x1a,0x19,0x18,0x1a,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x18,0x18,0x1c,0x1c,
	0xff,0xff,0xff,0x1a,0x19,0x18,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x1b,0x1c,0xff,0xff,0xff,0xff,0xff,
	0xff,0x19,0x18,0x19,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x18,
	0x17,0x1a,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1c,0x1a,0x18,
	0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x18,0x1b,0x1c,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1c,0x1c,0x1a,0x19,0x17,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x19,0x1a,0x1c,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1d,0x1d,
	0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,
};


const unsigned char kPressedPlayButtonBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x1a,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x1a,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x15,0x14,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x18,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x1a,0x14,0x11,0x11,0x0e,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x12,0x11,0x11,0x19,0xff,0xff,0xff,0xff,0xff,0xff,0x19,
	0x12,0x10,0x0d,0x0a,0x0f,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x0f,
	0x11,0x12,0x19,0xff,0xff,0xff,0xff,0x1a,0x16,0x10,0x0d,0x0d,0x11,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x11,0x16,0x1a,
	0xff,0xff,0xff,0x1a,0x11,0x0d,0x0a,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x11,0x1a,0xff,0xff,0xff,0x17,0x11,0x0d,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x11,0x15,0xff,0xff,0xff,0x14,0x11,0x0a,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x00,0x10,0x13,0x13,0x00,0x00,0x00,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x13,0xff,0xff,0xff,0x13,0x10,0x0d,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x10,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x1c,0xff,0xff,0x13,0x10,0x0d,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,0xff,0x13,0x10,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,0xff,0x13,0x10,0x0d,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,0xff,0x15,0x10,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x10,0x10,0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x16,0x1e,0xff,0xff,0x17,0x11,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x1a,0x1e,0xff,0xff,0xff,0x13,0x11,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x10,0x19,0x19,0x19,0x13,0x13,0x10,0x19,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x16,0x1e,0x1c,0xff,0xff,0xff,0x18,0x11,0x12,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x12,0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0x18,0x11,0x11,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x12,0x19,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x10,0x11,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x10,0x10,0x16,0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x19,0x14,0x13,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x17,0x1a,0x1d,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1e,0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
};

const unsigned char kPlayingPlayButtonBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x1a,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x1a,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x15,0x14,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x18,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x1a,0x14,0x11,0x11,0x16,0x1d,0x1e,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1c,
	0x19,0x16,0x12,0x11,0x11,0x19,0xff,0xff,0xff,0xff,0xff,0xff,0x19,
	0x12,0x10,0x17,0x1c,0x1e,0x1e,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x18,0x14,
	0x11,0x12,0x19,0xff,0xff,0xff,0xff,0x1a,0x16,0x10,0x17,0x1e,0x1e,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x14,0x11,0x16,0x1a,
	0xff,0xff,0xff,0x1a,0x11,0x12,0x1d,0x1e,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x11,0x1a,0xff,0xff,0xff,0x17,
	0x11,0x18,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x00,
	0x00,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,
	0x00,0x10,0x1a,0x1a,0x00,0x00,0x00,0x10,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x19,0x14,0x11,0x15,0xff,0xff,0xff,0x14,0x11,0x1d,0x1d,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,0x00,0x00,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x12,
	0x13,0xff,0xff,0xff,0x13,0x10,0x1e,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x00,0x34,0x34,0x34,0x34,0x34,0x00,0x00,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,0x00,0x17,0x17,0x3f,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x1c,0xff,0xff,
	0x13,0x10,0x3f,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,
	0x34,0x34,0x34,0x34,0x34,0x34,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x00,
	0x17,0x17,0x3f,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x18,0x13,0x10,0x3f,0xff,0xff,0x13,0x10,0x1d,0x19,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,0x34,0x34,
	0x34,0x34,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,
	0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,
	0x13,0x10,0x3f,0xff,0xff,0x13,0x10,0x19,0x19,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,0x34,0x34,0x3f,0x3f,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,0x00,0x17,0x17,
	0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x3f,0xff,
	0xff,0x15,0x10,0x15,0x18,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,
	0x34,0x34,0x34,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x16,0x1e,0xff,0xff,0x17,0x11,0x13,
	0x16,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x3f,0x3f,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x10,0x3f,0x3f,0x3f,
	0x1a,0x1a,0x10,0x3f,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x14,0x10,0x1a,0x1e,0xff,0xff,0xff,0x13,0x11,0x14,0x19,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x10,0x16,0x1e,0x1c,
	0xff,0xff,0xff,0x18,0x11,0x12,0x14,0x18,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x15,0x10,0x12,0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,
	0x18,0x11,0x11,0x14,0x17,0x18,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x18,0x17,0x12,0x10,
	0x12,0x19,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x11,
	0x12,0x12,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x12,0x10,0x10,0x16,0x1b,0x3f,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x19,0x16,0x13,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x14,0x17,0x1a,0x1d,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1e,0x1d,
	0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,
};


const unsigned char kPressedPlayingPlayButtonBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x1a,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x1a,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x15,0x14,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x18,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x1a,0x14,0x11,0x11,0x0e,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x12,0x11,0x11,0x19,0xff,0xff,0xff,0xff,0xff,0xff,0x19,
	0x12,0x10,0x0d,0x0a,0x0f,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x0f,
	0x11,0x12,0x19,0xff,0xff,0xff,0xff,0x1a,0x16,0x10,0x0d,0x0d,0x11,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x11,0x16,0x1a,
	0xff,0xff,0xff,0x1a,0x11,0x0d,0x0a,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x11,0x1a,0xff,0xff,0xff,0x17,
	0x11,0x0d,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x0f,0x11,0x15,0xff,0xff,0xff,0x14,0x11,0x0a,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x00,0x00,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x00,0x10,0x13,
	0x13,0x00,0x00,0x00,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,
	0x13,0xff,0xff,0xff,0x13,0x10,0x0d,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x00,0x34,0x34,0x34,0x00,0x00,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x00,0x10,0x10,
	0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x1c,0xff,0xff,
	0x13,0x10,0x0d,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,
	0x34,0x34,0x34,0x34,0x34,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,
	0x00,0x10,0x10,0x19,0x13,0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,0xff,0x13,0x10,0x11,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x34,0x34,
	0x34,0x34,0x34,0x00,0x00,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,
	0x13,0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x0f,0x10,0x3f,0xff,0xff,0x13,0x10,0x0d,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x19,
	0x19,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x00,0x10,
	0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,
	0xff,0x15,0x10,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x00,0x34,0x34,0x34,0x34,0x34,0x19,0x19,0x13,0x13,0x13,0x13,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x00,0x10,0x10,0x19,0x13,0x13,
	0x13,0x13,0x13,0x13,0x12,0x0f,0x16,0x1e,0xff,0xff,0x17,0x11,0x11,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x34,
	0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x19,0x13,0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,
	0x12,0x10,0x1a,0x1e,0xff,0xff,0xff,0x13,0x11,0x11,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x19,0x19,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x10,0x19,0x19,0x19,0x13,0x13,0x10,
	0x19,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x16,0x1e,0x1c,
	0xff,0xff,0xff,0x18,0x11,0x12,0x10,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x0f,0x12,0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,
	0x18,0x11,0x11,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,
	0x12,0x19,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x10,
	0x11,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x10,0x10,0x16,0x1b,0x3f,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x19,0x14,0x13,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x14,0x17,0x1a,0x1d,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1e,0x1d,
	0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,
};

const unsigned char kPausedPlayButtonBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x1a,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x1a,0x15,0x14,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x18,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0x1a,0x14,0x11,0x11,0x16,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1c,0x19,0x16,0x12,0x11,0x11,0x19,0xff,0xff,0xff,0xff,
	0xff,0xff,0x19,0x12,0x10,0x17,0x1c,0x1e,0x1e,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x18,0x14,0x11,0x12,0x19,0xff,0xff,0xff,
	0xff,0x1a,0x16,0x10,0x17,0x1e,0x1e,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x14,0x11,0x16,0x1a,0xff,0xff,
	0xff,0x1a,0x11,0x12,0x1d,0x1e,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x11,0x1a,0xff,0xff,
	0xff,0x17,0x11,0x18,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x00,0x00,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x00,0x10,0x1a,0x1a,0x00,0x00,0x00,0x10,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x11,0x15,0xff,0xff,
	0xff,0x14,0x11,0x1d,0x1d,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x12,0x13,0xff,0xff,
	0xff,0x13,0x10,0x1e,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x1c,0xff,
	0xff,0x13,0x10,0x3f,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x10,0x3f,0xff,
	0xff,0x13,0x10,0x1d,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x10,0x3f,0xff,
	0xff,0x13,0x10,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x3f,0xff,
	0xff,0x15,0x10,0x15,0x18,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x16,0x1e,0xff,
	0xff,0x17,0x11,0x13,0x16,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x10,0x3f,0x3f,0x3f,0x1a,0x1a,0x10,0x3f,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x14,0x10,0x1a,0x1e,0xff,
	0xff,0xff,0x13,0x11,0x14,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x10,0x16,0x1e,0x1c,0xff,
	0xff,0xff,0x18,0x11,0x12,0x14,0x18,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x10,0x12,0x1b,0x3f,0xff,0xff,
	0xff,0xff,0xff,0x18,0x11,0x11,0x14,0x17,0x18,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x18,0x17,0x12,0x10,0x12,0x19,0x3f,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x19,0x12,0x11,0x12,0x12,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x12,0x10,0x10,0x16,0x1b,0x3f,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0x19,0x19,0x16,0x13,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x17,0x1a,0x1d,0x3f,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1e,0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
};

const unsigned char kPressedPausedPlayButtonBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x1a,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x1a,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x15,0x14,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x18,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x1a,0x14,0x11,0x11,0x0e,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x12,0x11,0x11,0x19,0xff,0xff,0xff,0xff,0xff,0xff,0x19,
	0x12,0x10,0x0d,0x0a,0x0f,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x0f,
	0x11,0x12,0x19,0xff,0xff,0xff,0xff,0x1a,0x16,0x10,0x0d,0x0d,0x11,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x11,0x16,0x1a,
	0xff,0xff,0xff,0x1a,0x11,0x0d,0x0a,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x11,0x1a,0xff,0xff,0xff,0x17,
	0x11,0x0d,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x0f,0x11,0x15,0xff,0xff,0xff,0x14,0x11,0x0a,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x00,0x00,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x00,0x10,0x13,
	0x13,0x00,0x00,0x00,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,
	0x13,0xff,0xff,0xff,0x13,0x10,0x0d,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x00,0x10,0x10,0x10,0x00,0x00,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x19,0x13,0x13,0x00,0x34,0x34,
	0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x1c,0xff,0xff,
	0x13,0x10,0x0d,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,
	0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,
	0x00,0x34,0x34,0x19,0x13,0x13,0x00,0x34,0x34,0x19,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,0xff,0x13,0x10,0x11,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x00,0x00,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x19,
	0x13,0x13,0x00,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x0f,0x10,0x3f,0xff,0xff,0x13,0x10,0x0d,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x19,
	0x19,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x19,0x13,0x13,0x00,0x34,
	0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,
	0xff,0x15,0x10,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x00,0x10,0x10,0x10,0x10,0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x13,
	0x13,0x00,0x34,0x34,0x19,0x13,0x13,0x00,0x34,0x34,0x19,0x13,0x13,
	0x13,0x13,0x13,0x13,0x12,0x0f,0x16,0x1e,0xff,0xff,0x17,0x11,0x11,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x10,
	0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,
	0x19,0x13,0x13,0x00,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,
	0x12,0x10,0x1a,0x1e,0xff,0xff,0xff,0x13,0x11,0x11,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x19,0x19,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x10,0x19,0x19,0x19,0x13,0x13,0x10,
	0x19,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x16,0x1e,0x1c,
	0xff,0xff,0xff,0x18,0x11,0x12,0x10,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x0f,0x12,0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,
	0x18,0x11,0x11,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,
	0x12,0x19,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x10,
	0x11,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x10,0x10,0x16,0x1b,0x3f,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x19,0x14,0x13,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x14,0x17,0x1a,0x1d,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1e,0x1d,
	0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,
};

// #pragma mark stop

const int32 kStopBitmapWidth = 32;
const int32 kStopBitmapHeight = 22;
const BPoint kStopButtonSize(kStopBitmapWidth - 1, kStopBitmapHeight - 1);


const unsigned char kStopButtonBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,
	0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x17,0x18,0x1a,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0x1a,0x15,0x14,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x18,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x14,0x11,0x11,0x16,
	0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x1c,0x19,0x16,0x12,0x11,0x11,0x19,0xff,0xff,0xff,0xff,0xff,0xff,
	0x19,0x12,0x10,0x17,0x1c,0x1e,0x1e,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x18,0x14,0x11,0x12,
	0x19,0xff,0xff,0xff,0xff,0x1a,0x16,0x10,0x17,0x1e,0x1e,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x18,0x14,0x11,0x16,0x1a,0xff,0xff,0xff,0x1a,0x11,
	0x12,0x1d,0x1e,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x11,
	0x1a,0xff,0xff,0xff,0x17,0x11,0x18,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x19,0x14,0x11,0x15,0xff,0xff,0xff,0x14,0x11,0x1d,
	0x1d,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x17,
	0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x12,0x13,
	0xff,0xff,0xff,0x13,0x10,0x1e,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x18,0x12,0x10,0x1c,0xff,0xff,0x13,0x10,0x3f,0x19,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,
	0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x10,0x3f,
	0xff,0xff,0x13,0x10,0x1d,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x00,0x17,0x17,0x17,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x18,0x13,0x10,0x3f,0xff,0xff,0x13,0x10,0x19,0x19,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x17,
	0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x3f,0xff,
	0xff,0x15,0x10,0x15,0x18,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,
	0x17,0x17,0x17,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x16,0x12,0x16,0x1e,0xff,0xff,0x17,0x11,0x13,0x16,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x10,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x14,0x10,0x1a,0x1e,0xff,0xff,
	0xff,0x13,0x11,0x14,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,
	0x10,0x16,0x1e,0x1c,0xff,0xff,0xff,0x18,0x11,0x12,0x14,0x18,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x15,0x10,0x12,0x1b,0x3f,0xff,0xff,0xff,0xff,
	0xff,0x18,0x11,0x11,0x14,0x17,0x18,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x18,0x17,0x12,0x10,0x12,0x19,
	0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x11,0x12,0x12,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x12,0x10,0x10,0x16,0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x19,0x19,0x16,0x13,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x17,0x1a,0x1d,0x3f,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1d,0x1e,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x1e,0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,
};


const unsigned char kDisabledStopButtonBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,
	0x1a,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x1a,0x1a,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0x1a,0x1a,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x1a,
	0x1a,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x19,0x18,0x18,0x1a,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1b,0x19,0x18,0x18,0x1a,0x1a,0xff,0xff,0xff,0xff,0xff,
	0x1a,0x19,0x18,0x19,0x1c,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x18,0x18,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x18,0x19,0x1c,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1c,0x1a,0x18,0x1a,0x1c,0xff,0xff,0xff,0x1a,0x19,
	0x18,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x18,
	0x1c,0xff,0xff,0xff,0x1a,0x18,0x1a,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1a,0x18,0x1a,0x1c,0xff,0xff,0x19,0x17,0x1c,
	0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x19,
	0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x19,
	0x1c,0xff,0xff,0x19,0x16,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x16,0x19,0x19,0x19,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x19,0x17,0x1c,0xff,0xff,0x19,0x16,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x19,0x19,
	0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x1c,
	0xff,0xff,0x19,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x16,0x19,0x19,0x19,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x18,0x18,0x1c,0xff,0xff,0x19,0x16,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x19,0x19,0x19,
	0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x1c,0xff,
	0xff,0x19,0x17,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,
	0x19,0x19,0x19,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x18,0x19,0x1c,0xff,0xff,0x1a,0x18,0x19,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x17,0x1a,0x1c,0xff,0xff,
	0x1a,0x19,0x18,0x1a,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,
	0x18,0x18,0x1c,0x1c,0xff,0xff,0xff,0x1a,0x19,0x18,0x1a,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x1b,0x1c,0xff,0xff,0xff,0xff,
	0xff,0xff,0x19,0x18,0x19,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x18,0x17,0x1a,
	0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1c,0x1a,0x18,0x18,0x18,
	0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x18,0x17,0x18,0x1b,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x1c,0x1c,0x1a,0x19,0x17,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x19,0x1a,0x1c,0x1c,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1d,0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,
};


const unsigned char kPressedStopButtonBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,
	0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x17,0x18,0x1a,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0x1a,0x15,0x14,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x18,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x14,0x11,0x11,0x0e,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x12,0x11,0x11,0x19,0xff,0xff,0xff,0xff,0xff,0xff,
	0x19,0x12,0x10,0x0d,0x0a,0x0f,0x10,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x0f,0x11,0x12,
	0x19,0xff,0xff,0xff,0xff,0x1a,0x16,0x10,0x0d,0x0d,0x11,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x0f,0x11,0x16,0x1a,0xff,0xff,0xff,0x1a,0x11,
	0x0d,0x0a,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x11,
	0x1a,0xff,0xff,0xff,0x17,0x11,0x0d,0x11,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x0f,0x11,0x15,0xff,0xff,0xff,0x14,0x11,0x0a,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x13,
	0xff,0xff,0xff,0x13,0x10,0x0d,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x19,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x0f,0x10,0x1c,0xff,0xff,0x13,0x10,0x0d,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x10,0x10,
	0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,
	0xff,0xff,0x13,0x10,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x19,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,0xff,0x13,0x10,0x0d,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x10,0x10,0x10,
	0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,
	0xff,0x15,0x10,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,
	0x13,0x12,0x0f,0x16,0x1e,0xff,0xff,0x17,0x11,0x11,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x10,0x10,0x10,0x10,
	0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x1a,0x1e,0xff,0xff,
	0xff,0x13,0x11,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,
	0x0f,0x16,0x1e,0x1c,0xff,0xff,0xff,0x18,0x11,0x12,0x10,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x0f,0x12,0x1b,0x3f,0xff,0xff,0xff,0xff,
	0xff,0x18,0x11,0x11,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x12,0x19,
	0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x10,0x11,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x10,0x10,0x16,0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x19,0x19,0x14,0x13,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x17,0x1a,0x1d,0x3f,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1d,0x1e,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x1e,0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,
};

// #pragma mark rewind

const int32 kRewindBitmapWidth = 40;
const int32 kRewindBitmapHeight = 22;
const BPoint kSkipButtonSize(kRewindBitmapWidth - 1, kRewindBitmapHeight - 1);

const unsigned char kRewindBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x1a,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x1a,0x15,0x14,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x18,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0x1a,0x14,0x11,0x11,0x16,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1c,0x19,0x16,0x12,0x11,0x11,0x19,0xff,0xff,0xff,0xff,
	0xff,0xff,0x19,0x12,0x10,0x17,0x1c,0x1e,0x1e,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x18,0x14,0x11,0x12,0x19,0xff,0xff,0xff,
	0xff,0x1a,0x16,0x10,0x17,0x1e,0x1e,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x14,0x11,0x16,0x1a,0xff,0xff,
	0xff,0x1a,0x11,0x12,0x1d,0x1e,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x11,0x1a,0xff,0xff,
	0xff,0x17,0x11,0x18,0x3f,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x11,0x15,0xff,0xff,
	0xff,0x14,0x11,0x1d,0x1d,0x1a,0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x12,0x13,0xff,0xff,
	0xff,0x13,0x10,0x1e,0x19,0x1a,0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x1c,0xff,
	0xff,0x13,0x10,0x3f,0x19,0x1a,0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x00,0x00,0x17,0x17,0x17,0x17,0x17,0x3f,0x1a,0x00,0x00,0x17,0x17,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x10,0x3f,0xff,
	0xff,0x13,0x10,0x1d,0x19,0x1a,0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x3f,0x3f,0x17,0x17,0x17,0x17,0x17,0x3f,0x1a,0x3f,0x3f,0x17,0x17,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x10,0x3f,0xff,
	0xff,0x13,0x10,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x3f,0xff,
	0xff,0x15,0x10,0x15,0x18,0x1a,0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x16,0x1e,0xff,
	0xff,0x17,0x11,0x13,0x16,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x14,0x10,0x1a,0x1e,0xff,
	0xff,0xff,0x13,0x11,0x14,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x10,0x16,0x1e,0x1c,0xff,
	0xff,0xff,0x18,0x11,0x12,0x14,0x18,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x10,0x12,0x1b,0x3f,0xff,0xff,
	0xff,0xff,0xff,0x18,0x11,0x11,0x14,0x17,0x18,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x18,0x17,0x12,0x10,0x12,0x19,0x3f,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x19,0x12,0x11,0x12,0x12,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x12,0x10,0x10,0x16,0x1b,0x3f,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0x19,0x19,0x16,0x13,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x17,0x1a,0x1d,0x3f,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1e,0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
};


const unsigned char kDisabledRewindBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x1a,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1a,0x1a,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x1a,0x19,0x18,0x17,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x1a,0x1a,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x19,0x18,0x18,0x1a,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1b,0x19,0x18,0x18,0x1a,
	0x1a,0xff,0xff,0xff,0xff,0xff,0x1a,0x19,0x18,0x19,0x1c,0x1c,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x18,
	0x18,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x18,0x19,0x1c,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,
	0x1a,0x18,0x1a,0x1c,0xff,0xff,0xff,0x1a,0x19,0x18,0x1c,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x19,0x18,0x1c,0xff,0xff,0xff,0x1a,0x18,0x1a,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,
	0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x18,0x1a,0x1c,0xff,0xff,0x19,0x17,0x1c,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,
	0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x19,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x19,0x1c,0xff,0xff,0x19,0x16,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,0x16,0x16,0x19,
	0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x16,0x16,0x19,0x19,0x19,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x17,0x1c,0xff,0xff,0x19,0x16,
	0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x16,0x16,0x19,0x19,
	0x19,0x19,0x19,0x1c,0x1b,0x16,0x16,0x19,0x19,0x19,0x19,0x19,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x1c,0xff,0xff,0x19,
	0x16,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1c,0x1c,0x19,
	0x19,0x19,0x19,0x19,0x1c,0x1b,0x1c,0x1c,0x19,0x19,0x19,0x19,0x19,
	0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x1c,0xff,0xff,
	0x19,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,
	0x1c,0x1c,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x19,
	0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x1c,0xff,
	0xff,0x19,0x17,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,
	0x1c,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x19,0x1c,
	0xff,0xff,0x1a,0x18,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x17,0x1a,
	0x1c,0xff,0xff,0x1a,0x19,0x18,0x1a,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x18,0x18,
	0x1c,0x1c,0xff,0xff,0xff,0x1a,0x19,0x18,0x1a,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,
	0x1b,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x18,0x19,0x1a,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x18,0x17,
	0x1a,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1c,0x1a,0x18,0x18,
	0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x18,
	0x1b,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1c,0x1c,
	0x1a,0x19,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x19,0x1a,
	0x1c,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1d,
	0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
};


const unsigned char kPressedRewindBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x1a,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x1a,0x15,0x14,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x18,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0x1a,0x14,0x11,0x11,0x0e,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x12,0x11,0x11,0x19,0xff,0xff,0xff,0xff,
	0xff,0xff,0x19,0x12,0x10,0x0d,0x0a,0x0f,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x0f,0x11,0x12,0x19,0xff,0xff,0xff,
	0xff,0x1a,0x16,0x10,0x0d,0x0d,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x11,0x16,0x1a,0xff,0xff,
	0xff,0x1a,0x11,0x0d,0x0a,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x11,0x1a,0xff,0xff,
	0xff,0x17,0x11,0x0d,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x11,0x15,0xff,0xff,
	0xff,0x14,0x11,0x0a,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x13,0xff,0xff,
	0xff,0x13,0x10,0x0d,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x19,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x1c,0xff,
	0xff,0x13,0x10,0x0d,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x19,0x13,0x13,0x13,0x00,0x00,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x00,0x00,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,
	0xff,0x13,0x10,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x19,0x13,0x00,0x00,0x34,0x34,0x34,0x34,0x34,0x19,0x13,0x00,0x00,0x34,0x34,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,
	0xff,0x13,0x10,0x0d,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x19,0x13,0x19,0x19,0x34,0x34,0x34,0x34,0x34,0x19,0x13,0x19,0x19,0x34,0x34,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,
	0xff,0x15,0x10,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x19,0x13,0x13,0x13,0x19,0x19,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x19,0x19,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x16,0x1e,0xff,
	0xff,0x17,0x11,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x19,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x1a,0x1e,0xff,
	0xff,0xff,0x13,0x11,0x11,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x0f,0x16,0x1e,0x1c,0xff,
	0xff,0xff,0x18,0x11,0x12,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x12,0x1b,0x3f,0xff,0xff,
	0xff,0xff,0xff,0x18,0x11,0x11,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x12,0x19,0x3f,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x19,0x12,0x10,0x11,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x10,0x10,0x16,0x1b,0x3f,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0x19,0x19,0x14,0x13,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x17,0x1a,0x1d,0x3f,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1e,0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
};

// #pragma mark skip back

const unsigned char kSkipBackBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x18,0x18,0x17,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x1a,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x15,0x14,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x18,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x14,0x11,0x11,0x16,0x1d,0x1e,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1c,0x19,0x16,0x12,0x11,0x11,0x19,
	0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x10,0x17,0x1c,0x1e,0x1e,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x18,0x14,0x11,
	0x12,0x19,0xff,0xff,0xff,0xff,0x1a,0x16,0x10,0x17,0x1e,0x1e,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,
	0x14,0x11,0x16,0x1a,0xff,0xff,0xff,0x1a,0x11,0x12,0x1d,0x1e,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x16,0x12,0x11,0x1a,0xff,0xff,0xff,0x17,0x11,0x18,0x3f,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x19,0x14,0x11,0x15,0xff,0xff,0xff,0x14,0x11,0x1d,0x1d,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x3f,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x15,0x12,0x13,0xff,0xff,0xff,0x13,0x10,0x1e,
	0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x17,0x17,
	0x3f,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x1c,0xff,0xff,0x13,0x10,
	0x3f,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x17,0x17,0x17,
	0x17,0x3f,0x1a,0x00,0x00,0x17,0x17,0x17,0x17,0x17,0x3f,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x10,0x3f,0xff,0xff,0x13,
	0x10,0x1d,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,0x17,0x17,
	0x17,0x17,0x3f,0x1a,0x3f,0x3f,0x17,0x17,0x17,0x17,0x17,0x3f,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x10,0x3f,0xff,0xff,
	0x13,0x10,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,
	0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,0x17,0x17,0x3f,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x3f,0xff,
	0xff,0x15,0x10,0x15,0x18,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x3f,0x3f,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,
	0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x16,0x1e,
	0xff,0xff,0x17,0x11,0x13,0x16,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x14,0x10,0x1a,
	0x1e,0xff,0xff,0xff,0x13,0x11,0x14,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x10,0x16,
	0x1e,0x1c,0xff,0xff,0xff,0x18,0x11,0x12,0x14,0x18,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x10,0x12,
	0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0x18,0x11,0x11,0x14,0x17,0x18,
	0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x18,0x17,0x12,0x10,0x12,
	0x19,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x11,0x12,
	0x12,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x12,0x10,0x10,0x16,
	0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x19,
	0x16,0x13,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x17,0x1a,
	0x1d,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1e,
	0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
};

const unsigned char kDisabledSkipBackBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x1a,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1a,0x1a,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x1a,0x19,0x18,0x17,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x1a,0x1a,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x19,0x18,0x18,0x1a,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1b,0x19,0x18,0x18,0x1a,
	0x1a,0xff,0xff,0xff,0xff,0xff,0x1a,0x19,0x18,0x19,0x1c,0x1c,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x18,
	0x18,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x18,0x19,0x1c,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,
	0x1a,0x18,0x1a,0x1c,0xff,0xff,0xff,0x1a,0x19,0x18,0x1c,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x19,0x18,0x1c,0xff,0xff,0xff,0x1a,0x18,0x1a,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x18,0x1a,0x1c,0xff,0xff,0x19,0x17,0x1c,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1c,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x19,0x1c,0xff,0xff,0x19,0x16,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,
	0x1c,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x17,0x1c,0xff,0xff,0x19,0x16,
	0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1c,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x1c,0xff,0xff,0x19,
	0x16,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x1c,0xff,0xff,
	0x19,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,
	0x1b,0x1b,0x1b,0x1c,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x1c,0xff,
	0xff,0x19,0x17,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1c,0x1c,0x1b,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,
	0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x19,0x1c,
	0xff,0xff,0x1a,0x18,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x17,0x1a,
	0x1c,0xff,0xff,0x1a,0x19,0x18,0x1a,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x18,0x18,
	0x1c,0x1c,0xff,0xff,0xff,0x1a,0x19,0x18,0x1a,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,
	0x1b,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x18,0x19,0x1a,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x18,0x17,
	0x1a,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1c,0x1a,0x18,0x18,
	0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x18,
	0x1b,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1c,0x1c,
	0x1a,0x19,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x19,0x1a,
	0x1c,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1d,
	0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
};


const unsigned char kPressedSkipBackBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x18,0x18,0x17,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x1a,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x15,0x14,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x18,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x14,0x11,0x11,0x0e,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x12,0x11,0x11,0x19,
	0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x10,0x0d,0x0a,0x0f,0x10,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x0f,0x11,
	0x12,0x19,0xff,0xff,0xff,0xff,0x1a,0x16,0x10,0x0d,0x0d,0x11,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x0f,0x11,0x16,0x1a,0xff,0xff,0xff,0x1a,0x11,0x0d,0x0a,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x0f,0x11,0x1a,0xff,0xff,0xff,0x17,0x11,0x0d,0x11,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x0f,0x11,0x15,0xff,0xff,0xff,0x14,0x11,0x0a,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,
	0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x12,0x0f,0x13,0xff,0xff,0xff,0x13,0x10,0x0d,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,
	0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x10,0x19,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x1c,0xff,0xff,0x13,0x10,
	0x0d,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x10,
	0x10,0x10,0x19,0x13,0x13,0x13,0x00,0x00,0x10,0x10,0x10,0x19,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,0xff,0x13,
	0x10,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x10,0x10,
	0x10,0x10,0x10,0x19,0x13,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x19,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,0xff,
	0x13,0x10,0x0d,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x10,
	0x10,0x10,0x10,0x10,0x19,0x13,0x19,0x19,0x10,0x10,0x10,0x10,0x10,
	0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,
	0xff,0x15,0x10,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x19,0x19,0x10,0x10,0x10,0x19,0x13,0x13,0x13,0x19,0x19,0x10,0x10,
	0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x16,0x1e,
	0xff,0xff,0x17,0x11,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x19,0x19,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x19,
	0x19,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x1a,
	0x1e,0xff,0xff,0xff,0x13,0x11,0x11,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x16,
	0x1e,0x1c,0xff,0xff,0xff,0x18,0x11,0x12,0x10,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x12,
	0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0x18,0x11,0x11,0x11,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x12,
	0x19,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x10,0x11,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x10,0x10,0x16,
	0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x19,
	0x14,0x13,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x17,0x1a,
	0x1d,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1e,
	0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
};


const unsigned char kSkippingSkipBackBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x18,0x18,0x17,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x1a,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x15,0x14,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x18,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x14,0x11,0x11,0x16,0x1d,0x1e,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1c,0x19,0x16,0x12,0x11,0x11,0x19,
	0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x10,0x17,0x1c,0x1e,0x1e,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x18,0x14,0x11,
	0x12,0x19,0xff,0xff,0xff,0xff,0x1a,0x16,0x10,0x17,0x1e,0x1e,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,
	0x14,0x11,0x16,0x1a,0xff,0xff,0xff,0x1a,0x11,0x12,0x1d,0x1e,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x16,0x12,0x11,0x1a,0xff,0xff,0xff,0x17,0x11,0x18,0x3f,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x19,0x14,0x11,0x15,0xff,0xff,0xff,0x14,0x11,0x1d,0x1d,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x34,0x3f,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x15,0x12,0x13,0xff,0xff,0xff,0x13,0x10,0x1e,
	0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x34,0x34,0x34,
	0x3f,0x1a,0x1a,0x1a,0x00,0x00,0x34,0x34,0x34,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x1c,0xff,0xff,0x13,0x10,
	0x3f,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x34,0x34,0x34,0x34,
	0x34,0x3f,0x1a,0x00,0x00,0x34,0x34,0x34,0x34,0x34,0x3f,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x10,0x3f,0xff,0xff,0x13,
	0x10,0x1d,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x34,0x34,0x34,
	0x34,0x34,0x3f,0x1a,0x3f,0x3f,0x34,0x34,0x34,0x34,0x34,0x3f,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x10,0x3f,0xff,0xff,
	0x13,0x10,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,
	0x34,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x3f,0x3f,0x34,0x34,0x34,0x3f,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x3f,0xff,
	0xff,0x15,0x10,0x15,0x18,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x3f,0x3f,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x34,
	0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x16,0x1e,
	0xff,0xff,0x17,0x11,0x13,0x16,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x14,0x10,0x1a,
	0x1e,0xff,0xff,0xff,0x13,0x11,0x14,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x10,0x16,
	0x1e,0x1c,0xff,0xff,0xff,0x18,0x11,0x12,0x14,0x18,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x10,0x12,
	0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0x18,0x11,0x11,0x14,0x17,0x18,
	0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x18,0x17,0x12,0x10,0x12,
	0x19,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x11,0x12,
	0x12,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x12,0x10,0x10,0x16,
	0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x19,
	0x16,0x13,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x17,0x1a,
	0x1d,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1e,
	0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
};


const unsigned char kPressedSkippingSkipBackBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x18,0x18,0x17,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x1a,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x15,0x14,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x18,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x14,0x11,0x11,0x0e,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x12,0x11,0x11,0x19,
	0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x10,0x0d,0x0a,0x0f,0x10,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x0f,0x11,
	0x12,0x19,0xff,0xff,0xff,0xff,0x1a,0x16,0x10,0x0d,0x0d,0x11,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x0f,0x11,0x16,0x1a,0xff,0xff,0xff,0x1a,0x11,0x0d,0x0a,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x0f,0x11,0x1a,0xff,0xff,0xff,0x17,0x11,0x0d,0x11,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x0f,0x11,0x15,0xff,0xff,0xff,0x14,0x11,0x0a,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,
	0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x12,0x0f,0x13,0xff,0xff,0xff,0x13,0x10,0x0d,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,
	0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x34,0x19,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x1c,0xff,0xff,0x13,0x10,
	0x0d,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x34,
	0x34,0x34,0x19,0x13,0x13,0x13,0x00,0x00,0x34,0x34,0x34,0x19,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,0xff,0x13,
	0x10,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x34,0x34,
	0x34,0x34,0x34,0x19,0x13,0x00,0x00,0x34,0x34,0x34,0x34,0x34,0x19,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,0xff,
	0x13,0x10,0x0d,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x34,
	0x34,0x34,0x34,0x34,0x19,0x13,0x19,0x19,0x34,0x34,0x34,0x34,0x34,
	0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,
	0xff,0x15,0x10,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x19,0x19,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x19,0x19,0x34,0x34,
	0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x16,0x1e,
	0xff,0xff,0x17,0x11,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x19,0x19,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x19,
	0x19,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x1a,
	0x1e,0xff,0xff,0xff,0x13,0x11,0x11,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x16,
	0x1e,0x1c,0xff,0xff,0xff,0x18,0x11,0x12,0x10,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x12,
	0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0x18,0x11,0x11,0x11,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x12,
	0x19,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x10,0x11,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x10,0x10,0x16,
	0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x19,
	0x14,0x13,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x17,0x1a,
	0x1d,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1e,
	0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
};

// #pragma mark skip forward

const unsigned char kSkipForwardBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x18,0x18,0x17,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x1a,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x15,0x14,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x18,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x14,0x11,0x11,0x16,0x1d,0x1e,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1c,0x19,0x16,0x12,0x11,0x11,0x19,
	0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x10,0x17,0x1c,0x1e,0x1e,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x18,0x14,0x11,
	0x12,0x19,0xff,0xff,0xff,0xff,0x1a,0x16,0x10,0x17,0x1e,0x1e,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,
	0x14,0x11,0x16,0x1a,0xff,0xff,0xff,0x1a,0x11,0x12,0x1d,0x1e,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x16,0x12,0x11,0x1a,0xff,0xff,0xff,0x17,0x11,0x18,0x3f,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x19,0x14,0x11,0x15,0xff,0xff,0xff,0x14,0x11,0x1d,0x1d,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x00,0x00,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x00,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x15,0x12,0x13,0xff,0xff,0xff,0x13,0x10,0x1e,
	0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x00,
	0x00,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x1c,0xff,0xff,0x13,0x10,
	0x3f,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x00,0x00,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x00,0x00,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x10,0x3f,0xff,0xff,0x13,
	0x10,0x1d,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,
	0x17,0x17,0x17,0x3f,0x3f,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x3f,
	0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x10,0x3f,0xff,0xff,
	0x13,0x10,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,
	0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x3f,0x3f,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x3f,0xff,
	0xff,0x15,0x10,0x15,0x18,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,
	0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x3f,0x3f,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x16,0x1e,
	0xff,0xff,0x17,0x11,0x13,0x16,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x14,0x10,0x1a,
	0x1e,0xff,0xff,0xff,0x13,0x11,0x14,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x10,0x16,
	0x1e,0x1c,0xff,0xff,0xff,0x18,0x11,0x12,0x14,0x18,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x10,0x12,
	0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0x18,0x11,0x11,0x14,0x17,0x18,
	0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x18,0x17,0x12,0x10,0x12,
	0x19,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x11,0x12,
	0x12,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x12,0x10,0x10,0x16,
	0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x19,
	0x16,0x13,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x17,0x1a,
	0x1d,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1e,
	0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
};


const unsigned char kDisabledSkipForwardBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x1a,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1a,0x1a,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x1a,0x19,0x18,0x17,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x1a,0x1a,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x19,0x18,0x18,0x1a,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1b,0x19,0x18,0x18,0x1a,
	0x1a,0xff,0xff,0xff,0xff,0xff,0x1a,0x19,0x18,0x19,0x1c,0x1c,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x18,
	0x18,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x18,0x19,0x1c,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,
	0x1a,0x18,0x1a,0x1c,0xff,0xff,0xff,0x1a,0x19,0x18,0x1c,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x19,0x18,0x1c,0xff,0xff,0xff,0x1a,0x18,0x1a,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x18,0x1a,0x1c,0xff,0xff,0x19,0x17,0x1c,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x16,0x16,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x16,0x19,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x19,0x1c,0xff,0xff,0x19,0x16,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x16,
	0x16,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x16,0x16,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x17,0x1c,0xff,0xff,0x19,0x16,
	0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x16,0x16,0x1b,0x16,0x19,0x19,0x19,0x19,0x19,0x16,0x16,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x1c,0xff,0xff,0x19,
	0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,
	0x19,0x19,0x19,0x1c,0x1c,0x1b,0x16,0x19,0x19,0x19,0x19,0x19,0x1c,
	0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x1c,0xff,0xff,
	0x19,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,
	0x19,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x1c,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x1c,0xff,
	0xff,0x19,0x17,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,
	0x19,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x1c,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x19,0x1c,
	0xff,0xff,0x1a,0x18,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x17,0x1a,
	0x1c,0xff,0xff,0x1a,0x19,0x18,0x1a,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x18,0x18,
	0x1c,0x1c,0xff,0xff,0xff,0x1a,0x19,0x18,0x1a,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,
	0x1b,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x18,0x19,0x1a,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x18,0x17,
	0x1a,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1c,0x1a,0x18,0x18,
	0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x18,
	0x1b,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1c,0x1c,
	0x1a,0x19,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x19,0x1a,
	0x1c,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1d,
	0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
};


const unsigned char kPressedSkipForwardBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x18,0x18,0x17,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x1a,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x15,0x14,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x18,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x14,0x11,0x11,0x0e,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x12,0x11,0x11,0x19,
	0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x10,0x0d,0x0a,0x0f,0x10,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x0f,0x11,
	0x12,0x19,0xff,0xff,0xff,0xff,0x1a,0x16,0x10,0x0d,0x0d,0x11,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x0f,0x11,0x16,0x1a,0xff,0xff,0xff,0x1a,0x11,0x0d,0x0a,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x0f,0x11,0x1a,0xff,0xff,0xff,0x17,0x11,0x0d,0x11,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x0f,0x11,0x15,0xff,0xff,0xff,0x14,0x11,0x0a,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x12,0x0f,0x13,0xff,0xff,0xff,0x13,0x10,0x0d,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x00,0x00,
	0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x00,0x00,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x1c,0xff,0xff,0x13,0x10,
	0x0d,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x00,0x00,0x13,0x13,0x13,0x00,0x10,0x10,0x10,0x00,0x00,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,0xff,0x13,
	0x10,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,
	0x10,0x10,0x10,0x10,0x00,0x00,0x13,0x00,0x10,0x10,0x10,0x10,0x10,
	0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,0xff,
	0x13,0x10,0x0d,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,
	0x10,0x10,0x10,0x10,0x10,0x19,0x19,0x13,0x00,0x10,0x10,0x10,0x10,
	0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,
	0xff,0x15,0x10,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x00,0x10,0x10,0x10,0x19,0x19,0x13,0x13,0x13,0x00,0x10,0x10,0x10,
	0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x16,0x1e,
	0xff,0xff,0x17,0x11,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x00,0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x19,
	0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x1a,
	0x1e,0xff,0xff,0xff,0x13,0x11,0x11,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x16,
	0x1e,0x1c,0xff,0xff,0xff,0x18,0x11,0x12,0x10,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x12,
	0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0x18,0x11,0x11,0x11,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x12,
	0x19,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x10,0x11,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x10,0x10,0x16,
	0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x19,
	0x14,0x13,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x17,0x1a,
	0x1d,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1e,
	0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
};


const unsigned char kSkippingSkipForwardBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x18,0x18,0x17,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x1a,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x15,0x14,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x18,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x14,0x11,0x11,0x16,0x1d,0x1e,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1c,0x19,0x16,0x12,0x11,0x11,0x19,
	0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x10,0x17,0x1c,0x1e,0x1e,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x18,0x14,0x11,
	0x12,0x19,0xff,0xff,0xff,0xff,0x1a,0x16,0x10,0x17,0x1e,0x1e,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,
	0x14,0x11,0x16,0x1a,0xff,0xff,0xff,0x1a,0x11,0x12,0x1d,0x1e,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x16,0x12,0x11,0x1a,0xff,0xff,0xff,0x17,0x11,0x18,0x3f,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x19,0x14,0x11,0x15,0xff,0xff,0xff,0x14,0x11,0x1d,0x1d,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x00,0x00,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x00,0x34,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x15,0x12,0x13,0xff,0xff,0xff,0x13,0x10,0x1e,
	0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,0x00,
	0x00,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,0x00,0x00,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x1c,0xff,0xff,0x13,0x10,
	0x3f,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,
	0x34,0x34,0x00,0x00,0x1a,0x00,0x34,0x34,0x34,0x34,0x34,0x00,0x00,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x10,0x3f,0xff,0xff,0x13,
	0x10,0x1d,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,
	0x34,0x34,0x34,0x3f,0x3f,0x1a,0x00,0x34,0x34,0x34,0x34,0x34,0x3f,
	0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x10,0x3f,0xff,0xff,
	0x13,0x10,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,
	0x34,0x34,0x3f,0x3f,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,0x3f,0x3f,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x3f,0xff,
	0xff,0x15,0x10,0x15,0x18,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,
	0x34,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x3f,0x3f,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x16,0x1e,
	0xff,0xff,0x17,0x11,0x13,0x16,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x14,0x10,0x1a,
	0x1e,0xff,0xff,0xff,0x13,0x11,0x14,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x10,0x16,
	0x1e,0x1c,0xff,0xff,0xff,0x18,0x11,0x12,0x14,0x18,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x15,0x10,0x12,
	0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0x18,0x11,0x11,0x14,0x17,0x18,
	0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x18,0x17,0x12,0x10,0x12,
	0x19,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x11,0x12,
	0x12,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x12,0x10,0x10,0x16,
	0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x19,
	0x16,0x13,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x17,0x1a,
	0x1d,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1e,
	0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
};


const unsigned char kPressedSkippingSkipForwardBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x18,0x18,0x17,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x1a,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x15,0x14,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x18,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x1a,0x14,0x11,0x11,0x0e,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x12,0x11,0x11,0x19,
	0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x10,0x0d,0x0a,0x0f,0x10,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x0f,0x11,
	0x12,0x19,0xff,0xff,0xff,0xff,0x1a,0x16,0x10,0x0d,0x0d,0x11,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x0f,0x11,0x16,0x1a,0xff,0xff,0xff,0x1a,0x11,0x0d,0x0a,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x0f,0x11,0x1a,0xff,0xff,0xff,0x17,0x11,0x0d,0x11,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x0f,0x11,0x15,0xff,0xff,0xff,0x14,0x11,0x0a,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x12,0x0f,0x13,0xff,0xff,0xff,0x13,0x10,0x0d,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x00,0x00,
	0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x00,0x00,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x1c,0xff,0xff,0x13,0x10,
	0x0d,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,
	0x34,0x00,0x00,0x13,0x13,0x13,0x00,0x34,0x34,0x34,0x00,0x00,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,0xff,0x13,
	0x10,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,
	0x34,0x34,0x34,0x34,0x00,0x00,0x13,0x00,0x34,0x34,0x34,0x34,0x34,
	0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,0xff,
	0x13,0x10,0x0d,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,
	0x34,0x34,0x34,0x34,0x34,0x19,0x19,0x13,0x00,0x34,0x34,0x34,0x34,
	0x34,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x10,0x3f,0xff,
	0xff,0x15,0x10,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x00,0x34,0x34,0x34,0x19,0x19,0x13,0x13,0x13,0x00,0x34,0x34,0x34,
	0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x16,0x1e,
	0xff,0xff,0x17,0x11,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x00,0x34,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x19,
	0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x1a,
	0x1e,0xff,0xff,0xff,0x13,0x11,0x11,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x16,
	0x1e,0x1c,0xff,0xff,0xff,0x18,0x11,0x12,0x10,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0f,0x12,
	0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0x18,0x11,0x11,0x11,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x12,
	0x19,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x12,0x10,0x11,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x10,0x10,0x16,
	0x1b,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x19,0x19,
	0x14,0x13,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
	0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x14,0x17,0x1a,
	0x1d,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x1d,0x1e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x1e,
	0x1d,0x1c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
};

