/*****************************************************************************
 * sapserver.cpp : SAP discovery service mini-server
 ****************************************************************************
 * Copyright (C) 1998-2002 VideoLAN
 * $Id: sapserver.cpp,v 1.10 2003/05/25 22:08:48 alexis Exp $ 
 *
 * Authors: Fabrice Ollivier <cif@via.ecp.fr>
 *          Arnaud Schauly <gitan@via.ecp.fr>
 *          Clment Stenac <zorglub@via.ecp.fr>
 *          Damien Lucas <nitrox@videolan.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string>
#include <vector>

using namespace std;

#include "program.h"
#include "message.h"
#include "broadcast.h"
#include "parser.h"
#include "sapserver.h"


/*************************************************
 * Display the help
 *************************************************/
void help(void)
{
  printf("Options:\n" \
  "-d : Use this to daemonize the process (run in the background)\n" \
  "-f or -c: Use this to give a configuration file (default is %s)\n" \
  "-h: Display this help\n"   ,DEFAULT_CONF);
}

/*************************************************
 * The main function
 *************************************************/
int main(int argc, char *argv[])
{
    int result=0;
    char getopt_string[128];
    Broadcast* broadcast;
    Message *message;
    Config *config;

    fprintf(stdout, "%s Version %s - (c)1999-2003 VideoLAN\n\n",
                                  PROGRAM_NAME,VERSION);
    config=new Config(DEFAULT_CONF);

    /* Parse the command line */
    sprintf(getopt_string,"dhf:c:");
    while(result !=-1)
    {
        result=getopt(argc,argv,getopt_string);
        if(result=='c' || result=='f')
        {
            config->SetFile(optarg);
        }
        if(result=='d')
        {
            config->SetDaemonMode(true);
        }
        if(result=='h')
        {
            help();
            return(0);
        }
    }


    /* Get the programs */
    fprintf(stdout, "+ Parsing configuration file\n");
    if(config->Parse())
    {
        fprintf(stderr, "+ Parsing failed\n");
        return(-1);
    }
    //TODO check configuration
    fprintf(stdout, "+ %d programs loaded\n",(int)config->Programs.size());
    fprintf(stdout, "+ Packet TTL set to %i\n",config->GetTTL());
    if(config->GetDaemonMode()) fprintf(stdout, "+ Running as daemon.\n");
    else fprintf(stdout, "+ Running as program.\n");

    /* Creating the broadcast object */
    broadcast = new Broadcast(config->GetTTL());
    broadcast->Init();


    /* Forking if necessary */
    if(config->GetDaemonMode())
    {
        fprintf(stdout, "+ Forking ... \n");
        daemon(0,0);
    }


    while(1)
    {
        for (unsigned int i=0; i<config->Programs.size(); i++)
        {
            /* Create a new message */
            message=new Message(SAP_ANNOUNCE, 0x4212, "1.2.3.4");
            /* Build the message header */
            message->BuildHeader("application/sdp");
            /* Add the program */
            message->AddProgram(config->Programs[i]);
            /* Send the message */
            broadcast->Send(message);
            /* Delete the message */
            delete message;
        }
        /* Wait for next sending */
        sleep(SAP_DELAY);
    }

    return 0;
}
