/*****************************************************************************
 * broadcast.cpp : SAP Broadcast class
 ****************************************************************************
 * Copyright (C) 1998-2003 VideoLAN
 * $Id: broadcast.cpp,v 1.5 2003/06/18 13:48:22 sam Exp $
 *
 * Authors: Damien Lucas <nitrox@videolan.org>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string>
#include <vector>
using namespace std;

#include "program.h"
#include "message.h"
#include "broadcast.h"

Broadcast::Broadcast(unsigned int t)
{
    port=HELLO_PORT;
    ttl=t;
    return;
}


Broadcast::~Broadcast(){return;}


int Broadcast::Initv4(void)
{
    group=SAP_IPV4_ADDR;
    if ((fd=socket(AF_INET,SOCK_DGRAM,0)) < 0)
    {
        perror("socket");
        return(-1);
    }

    /* set up destination address */
    memset( &addr , 0 , sizeof(addr) );
    addr.sin_family 	 = AF_INET;
    addr.sin_addr.s_addr = inet_addr(group);
    addr.sin_port	 = htons(port);

    if(setsockopt( fd, IPPROTO_IP, IP_MULTICAST_TTL, &ttl, sizeof(ttl) ))
    {
	perror("setsockopt");
	return(-1);
    }
    return 0;
}

int Broadcast::Initv6(char scope)
{
    group=(char *)malloc(32 * sizeof(char)); /* Size of an IPv6 address */
 
    if(!group)
    {
	perror("malloc");
	return(-1);
    }	

    sprintf( group , "%s%c%s" , SAP_IPV6_ADDR_1 , scope , SAP_IPV6_ADDR_2);
    unsigned char ip_address[sizeof(addr_v6.sin6_addr.s6_addr)];
    if ((fd=socket(AF_INET6,SOCK_DGRAM,0)) < 0)
    {
        perror("socket");
        return(-1);
    }

    /* XXX: under Win32, use _getaddrinfo and memcpy instead */
    int i_status 	 = inet_pton(AF_INET6,group,ip_address);
    if(i_status < 0 )
    {
	perror("inet_pton");
	return(-1);
    }
    else if(i_status == 0)
    {
	fprintf(stderr,"Adresse de diffusion SAP invalide\n");
	return(-1);
    }

    /* set up destination address */
    memset(&addr_v6,0,sizeof(addr_v6));
    addr_v6.sin6_family	      = AF_INET6;
    addr_v6.sin6_flowinfo     = 0;
    addr_v6.sin6_port         = htons(port);
    memcpy( &addr_v6.sin6_addr.s6_addr, ip_address,
            sizeof(addr_v6.sin6_addr.s6_addr) );

    if(setsockopt( fd, IPPROTO_IP, IP_MULTICAST_TTL, &ttl, sizeof(ttl) ))
    {
        perror("setsockopt");
        return(-1);
    }

    if(group) free(group);

    return 0;
}


int Broadcast::Send(Message* m,int version)
{
    /* Create the final message */
    m->CreateFinalMessage();

    int i_status;

    /* Get the message and the length */
    char* message 	= m->GetFinalMessage();
    unsigned int length = m->GetFinalMessageLen();

    if(message==NULL)
    {
        fprintf(stderr, "Bad message, skipping\n");
        return (-1);
    }
    if(version == 6)
	    i_status=sendto(fd,message,length,0,
                   (struct sockaddr *) &addr_v6,sizeof(addr_v6));

    else	
        i_status=sendto(fd,message,length,0,
                   (struct sockaddr *) &addr,sizeof(addr));


    if(i_status < 0 )
    {
        perror("sendto");
        return(-1);
    }

 
    return 0;
}
