/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui;

import java.awt.Image;
import java.awt.Point;
import org.havi.ui.HAnimateEffect;
import org.havi.ui.HMatte;
import org.videolan.Logger;

public class HImageEffectMatte
implements HMatte,
HAnimateEffect {
    private int delay = 1;
    private boolean isAnimated = false;
    private Image[] matteData = null;
    private int mode = 2;
    private Point[] offsets = null;
    private int position = 0;
    private int repeatCount = -1;

    public HImageEffectMatte() {
    }

    public HImageEffectMatte(Image[] data) {
        this();
        this.setMatteData(data);
    }

    public void setMatteData(Image[] data) {
        if (data == null) {
            this.matteData = null;
            this.offsets = null;
            return;
        }
        if (data.length == 0) {
            Logger.getLogger("HImageEffectMatte").error("setMatteData: empty image array");
            throw new IllegalArgumentException("empty image array");
        }
        this.matteData = data;
        this.offsets = new Point[this.matteData.length];
        for (int i = 0; i < this.matteData.length; ++i) {
            this.offsets[i] = new Point(0, 0);
        }
    }

    public Image[] getMatteData() {
        return this.matteData;
    }

    public void setOffset(Point p, int index) {
        if (p == null) {
            Logger.getLogger("HImageEffectMatte").error("setOffset(): no point");
            throw new IllegalArgumentException("setOffset(): point is null");
        }
        if (this.matteData == null || index < 0 || index >= this.matteData.length) {
            Logger.getLogger("HImageEffectMatte").error("setOffset(): invalid index");
            throw new IndexOutOfBoundsException("setOffset(): invalid index");
        }
        this.offsets[index] = p;
    }

    public Point getOffset(int index) {
        return this.offsets[index];
    }

    public void start() {
        this.isAnimated = true;
    }

    public void stop() {
        this.isAnimated = false;
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    public void setPosition(int position) {
        if (this.matteData == null) {
            return;
        }
        if (position < 0) {
            position = 0;
        }
        if (position >= this.matteData.length) {
            position = this.matteData.length - 1;
        }
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public void setRepeatCount(int count) {
        if (count <= 0 && count != -1) {
            Logger.getLogger("HImageEffectMatte").error("setRepeatCount(): invalid count");
            throw new IllegalArgumentException("setRepeatCount(): invalid count");
        }
        this.repeatCount = count;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setDelay(int count) {
        if (count < 1) {
            count = 1;
        }
        this.delay = count;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setPlayMode(int mode) {
        if (mode != 1 && mode != 2) {
            Logger.getLogger("HImageEffectMatte").error("setPlayMode(): invalid mode");
            throw new IllegalArgumentException("setPlayMode(): invalid mode");
        }
        this.mode = mode;
    }

    public int getPlayMode() {
        return this.mode;
    }
}

