/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.media.content.playlist;

import java.io.IOException;
import javax.media.ClockStartedError;
import javax.media.ConnectionErrorEvent;
import javax.media.Control;
import javax.media.ControllerErrorEvent;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.protocol.DataSource;
import javax.tv.locator.Locator;
import javax.tv.service.selection.ServiceContextFactory;
import org.bluray.media.InvalidPlayListException;
import org.bluray.net.BDLocator;
import org.bluray.system.RegisterAccess;
import org.bluray.ti.selection.TitleContextImpl;
import org.davic.net.InvalidLocatorException;
import org.videolan.BDJAction;
import org.videolan.Libbluray;
import org.videolan.Logger;
import org.videolan.PlaylistInfo;
import org.videolan.TIClip;
import org.videolan.TIMark;
import org.videolan.media.content.BDHandler;
import org.videolan.media.content.control.MediaTimePositionControlImpl;
import org.videolan.media.content.control.OverallGainControlImpl;
import org.videolan.media.content.control.PanningControlImpl;
import org.videolan.media.content.control.PrimaryGainControlImpl;
import org.videolan.media.content.control.SecondaryGainControlImpl;
import org.videolan.media.content.playlist.AngleControlImpl;
import org.videolan.media.content.playlist.AudioMetadataControlImpl;
import org.videolan.media.content.playlist.BackgroundVideoPresentationControlImpl;
import org.videolan.media.content.playlist.DVBMediaSelectControlImpl;
import org.videolan.media.content.playlist.MediaTimeEventControlImpl;
import org.videolan.media.content.playlist.PiPControlImpl;
import org.videolan.media.content.playlist.PlayListChangeControlImpl;
import org.videolan.media.content.playlist.PlaybackControlImpl;
import org.videolan.media.content.playlist.PrimaryAudioControlImpl;
import org.videolan.media.content.playlist.SecondaryAudioControlImpl;
import org.videolan.media.content.playlist.SubtitlingControlImpl;
import org.videolan.media.content.playlist.UOMaskTableControlImpl;
import org.videolan.media.content.playlist.VideoFormatControlImpl;

public class Handler
extends BDHandler {
    BDLocator lastMarkLocator = null;
    private PlaylistInfo pi = null;
    private BDLocator currentLocator = null;
    private BDLocator sourceLocator = null;
    private static final Logger logger = Logger.getLogger(Handler.class.getName());

    public Handler() {
        this.controls = new Control[18];
        this.controls[0] = new AngleControlImpl(this);
        this.controls[1] = new AudioMetadataControlImpl();
        this.controls[2] = new BackgroundVideoPresentationControlImpl(this);
        this.controls[3] = new DVBMediaSelectControlImpl(this);
        this.controls[4] = new MediaTimeEventControlImpl();
        this.controls[5] = new MediaTimePositionControlImpl(this);
        this.controls[6] = new OverallGainControlImpl(this);
        this.controls[7] = new PanningControlImpl(this);
        this.controls[8] = new PiPControlImpl(this);
        this.controls[9] = new PlaybackControlImpl(this);
        this.controls[10] = new PlayListChangeControlImpl(this);
        this.controls[11] = new PrimaryAudioControlImpl(this);
        this.controls[12] = new PrimaryGainControlImpl(this);
        this.controls[13] = new SecondaryAudioControlImpl(this);
        this.controls[14] = new SecondaryGainControlImpl(this);
        this.controls[15] = new SubtitlingControlImpl(this);
        this.controls[16] = new UOMaskTableControlImpl(this);
        this.controls[17] = new VideoFormatControlImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        BDLocator newLocator;
        try {
            newLocator = new BDLocator(source.getLocator().toExternalForm());
        }
        catch (InvalidLocatorException e) {
            logger.error("incompatible source: " + source);
            throw new IncompatibleSourceException();
        }
        catch (Exception e) {
            logger.error("unexpected expection: " + e);
            throw new IncompatibleSourceException();
        }
        if (!newLocator.isPlayListItem()) {
            logger.error("not playlist: " + newLocator);
            throw new IncompatibleSourceException();
        }
        PlaylistInfo newPi = Libbluray.getPlaylistInfo(newLocator.getPlayListId());
        if (newPi == null) {
            logger.error("getPlaylistInfo failed for " + newLocator);
            throw new IOException();
        }
        Handler handler = this;
        synchronized (handler) {
            this.sourceLocator = newLocator;
            this.currentLocator = null;
            this.pi = newPi;
            this.baseMediaTime = 0L;
            if (this.state == 500) {
                this.doPrefetch();
            }
        }
    }

    public Locator[] getServiceContentLocators() {
        if (this.sourceLocator == null) {
            return new Locator[0];
        }
        Locator[] locators = new Locator[]{this.currentLocator != null && this.getState() >= 500 ? this.currentLocator : this.sourceLocator};
        return locators;
    }

    public Time getDuration() {
        if (this.pi != null) {
            long duration = this.pi.getDuration();
            return new Time((double)duration * 1.1111111111111112E-5);
        }
        return DURATION_UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ControllerErrorEvent doPrefetch() {
        Handler handler = this;
        synchronized (handler) {
            try {
                int stream = this.sourceLocator.getPrimaryAudioStreamNumber();
                if (stream > 0) {
                    Libbluray.writePSR(1, stream);
                }
                if ((stream = this.sourceLocator.getPGTextStreamNumber()) > 0) {
                    Libbluray.writePSR(2, stream, 4095);
                }
                if ((stream = this.sourceLocator.getSecondaryVideoStreamNumber()) > 0) {
                    Libbluray.writePSR(14, stream << 8, 65280);
                }
                if ((stream = this.sourceLocator.getSecondaryAudioStreamNumber()) > 0) {
                    Libbluray.writePSR(14, stream, 255);
                }
                int plId = this.sourceLocator.getPlayListId();
                long time = -1L;
                int piId = -1;
                int mark = -1;
                if (this.baseMediaTime != 0L) {
                    time = (long)((double)this.baseMediaTime * 9.0E-5);
                }
                if (this.sourceLocator.getMarkId() > 0) {
                    mark = this.sourceLocator.getMarkId();
                }
                if (this.sourceLocator.getPlayItemId() > 0) {
                    piId = this.sourceLocator.getPlayItemId();
                }
                if (!Libbluray.selectPlaylist(plId, piId, mark, time)) {
                    return new ConnectionErrorEvent(this);
                }
                this.updateTime(new Time((double)Libbluray.tellTime() * 1.1111111111111112E-5));
                this.currentLocator = new BDLocator(this.sourceLocator.toExternalForm());
            }
            catch (Exception e) {
                return new ConnectionErrorEvent(this);
            }
            return super.doPrefetch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ControllerErrorEvent doStart(Time at) {
        Handler handler = this;
        synchronized (handler) {
            if (at != null) {
                try {
                    Libbluray.seekTime((long)(at.getSeconds() * 90000.0));
                }
                catch (Exception e) {
                    return new ConnectionErrorEvent(this);
                }
            }
            try {
                Libbluray.selectRate(this.rate, true);
            }
            catch (Exception e) {
                return new ConnectionErrorEvent(this);
            }
            at = new Time((double)Libbluray.tellTime() * 1.1111111111111112E-5);
            return super.doStart(at);
        }
    }

    protected ControllerErrorEvent doStop(boolean eof) {
        Libbluray.selectRate(0.0f, false);
        if (!eof) {
            Libbluray.stopPlaylist();
        }
        return super.doStop(eof);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSeekTime(Time at) {
        Handler handler = this;
        synchronized (handler) {
            if (this.state == 500 || this.state == 600) {
                try {
                    Libbluray.seekTime((long)(at.getSeconds() * 90000.0));
                }
                catch (Exception e) {
                    return;
                }
                at = new Time((double)Libbluray.tellTime() * 1.1111111111111112E-5);
            }
            super.doSeekTime(at);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetRate(Float factor) {
        Handler handler = this;
        synchronized (handler) {
            if (this.state == 600) {
                try {
                    Libbluray.selectRate(factor.floatValue());
                }
                catch (Exception e) {
                    return;
                }
                if (this.state == 600) {
                    this.baseMediaTime = this.getMediaNanoseconds();
                    this.baseTime = this.getTimeBase().getNanoseconds();
                }
            }
            super.doSetRate(factor);
        }
    }

    private void postMediaSelectSucceeded(BDLocator locator) {
        ((DVBMediaSelectControlImpl)this.controls[3]).postMediaSelectSucceededEvent(new Locator[]{locator});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRateChanged(float rate) {
        Handler handler = this;
        synchronized (handler) {
            if (this.state == 600) {
                this.baseMediaTime = this.getMediaNanoseconds();
                this.baseTime = this.getTimeBase().getNanoseconds();
            }
            super.doRateChanged(rate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doChapterReached(int chapter) {
        if (chapter <= 0) {
            return;
        }
        --chapter;
        Handler handler = this;
        synchronized (handler) {
            if (this.pi == null) {
                return;
            }
            TIMark[] marks = this.pi.getMarks();
            if (marks == null) {
                return;
            }
            int j = 0;
            for (int i = 0; i < marks.length; ++i) {
                if (marks[i].getType() != 1) continue;
                if (j == chapter) {
                    if (this.currentLocator == null || this.lastMarkLocator != this.currentLocator || i != this.currentLocator.getMarkId()) {
                        ((PlaybackControlImpl)this.controls[9]).onMarkReach(i);
                    }
                    return;
                }
                ++j;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMarkReached(int param) {
        Handler handler = this;
        synchronized (handler) {
            ((PlaybackControlImpl)this.controls[9]).onMarkReach(param);
            if (this.currentLocator != null) {
                this.currentLocator.setMarkId(param);
            }
            this.lastMarkLocator = this.currentLocator;
        }
    }

    protected void doPlaylistStarted(int param) {
    }

    protected void doPlayItemReached(int param) {
        TIClip[] clips;
        ((PlaybackControlImpl)this.controls[9]).onPlayItemReach(param);
        ((UOMaskTableControlImpl)this.controls[16]).onPlayItemReach(param);
        if (this.currentLocator != null) {
            this.currentLocator.setPlayItemId(param);
            this.postMediaSelectSucceeded(this.currentLocator);
        }
        try {
            ((TitleContextImpl)ServiceContextFactory.getInstance().getServiceContext(null)).presentationChanged();
        }
        catch (Exception e) {
            System.err.println("" + e + "\n" + Logger.dumpStack(e));
        }
        if (this.pi != null && (clips = this.pi.getClips()) != null && param >= 0 && param < clips.length) {
            ((SubtitlingControlImpl)this.controls[15]).onSubtitleAvailable(clips[param].getPgStreamCount() > 0);
        }
    }

    protected void doUOMasked(int position) {
        ((UOMaskTableControlImpl)this.controls[16]).onUOMasked(position);
    }

    protected void doAngleChanged(int param) {
        ((AngleControlImpl)this.controls[0]).onAngleChange(param);
    }

    protected void doSubtitleChanged(int param) {
        ((SubtitlingControlImpl)this.controls[15]).onSubtitleChange(param);
        if (this.currentLocator != null) {
            this.currentLocator.setPGTextStreamNumber(param & 0xFFF);
            this.postMediaSelectSucceeded(this.currentLocator);
        }
    }

    protected void doAudioStreamChanged(int param) {
        if (this.currentLocator != null) {
            this.currentLocator.setPrimaryAudioStreamNumber(param);
            this.postMediaSelectSucceeded(this.currentLocator);
        }
    }

    private void doSecondaryVideoChanged(int stream, boolean enable) {
        if (this.currentLocator != null) {
            this.currentLocator.setSecondaryVideoStreamNumber(stream);
            this.postMediaSelectSucceeded(this.currentLocator);
        }
        ((PiPControlImpl)this.controls[8]).onPiPStatusChange(enable);
    }

    private void doSecondaryAudioChanged(int stream, boolean enable) {
        if (this.currentLocator != null) {
            this.currentLocator.setSecondaryAudioStreamNumber(stream);
            this.postMediaSelectSucceeded(this.currentLocator);
        }
    }

    protected void doSecondaryStreamChanged(int param) {
        this.doSecondaryVideoChanged((param & 0xFF00) >> 8, (param & Integer.MIN_VALUE) != 0);
        this.doSecondaryAudioChanged(param & 0xFF, (param & 0x40000000) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doEndOfMediaReached(int playlist) {
        Handler handler = this;
        synchronized (handler) {
            if (this.currentLocator == null) {
                logger.error("endOfMedia(" + playlist + ") ignored: no current locator");
                return;
            }
            if (this.currentLocator.getPlayListId() != playlist) {
                logger.error("endOfMedia ignored: playlist does not match (" + playlist + " != " + this.currentLocator.getPlayListId());
                return;
            }
        }
        super.doEndOfMediaReached(playlist);
    }

    protected void doSeekNotify(long tick) {
        super.doSeekNotify(Libbluray.tellTime());
    }

    protected BDLocator getCurrentLocator() {
        if (this.currentLocator != null) {
            return this.currentLocator;
        }
        return this.sourceLocator;
    }

    protected PlaylistInfo getPlaylistInfo() {
        return this.pi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TIClip getCurrentClipInfo() {
        Handler handler = this;
        synchronized (handler) {
            TIClip[] clips;
            int state = this.getState();
            if (state != 500 && state != 600) {
                return null;
            }
            int playitem = RegisterAccess.getInstance().getPSR(7);
            if (playitem >= (clips = this.pi.getClips()).length) {
                return null;
            }
            return clips[playitem];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectPlayList(BDLocator locator) throws InvalidPlayListException, javax.tv.locator.InvalidLocatorException, ClockStartedError {
        if (locator == null) {
            logger.error("null locator");
            throw new NullPointerException();
        }
        if (!locator.isPlayListItem()) {
            logger.error("not playlist: " + locator);
            throw new javax.tv.locator.InvalidLocatorException(locator);
        }
        PlaylistInfo newPi = Libbluray.getPlaylistInfo(locator.getPlayListId());
        if (newPi == null) {
            logger.error("invalid playlist");
            throw new InvalidPlayListException();
        }
        Handler handler = this;
        synchronized (handler) {
            if (this.getState() == 600) {
                logger.error("throw ClockStartedError");
                throw new ClockStartedError();
            }
            this.pi = newPi;
            this.sourceLocator = locator;
            this.currentLocator = null;
            this.baseMediaTime = 0L;
            if (this.state == 500) {
                this.doPrefetch();
            }
        }
    }

    protected void seekMark(int mark) throws IllegalArgumentException {
        if (this.pi == null || mark < 0 || mark >= this.pi.getMarkCount()) {
            throw new IllegalArgumentException();
        }
        PlaylistPlayerAction action = new PlaylistPlayerAction(this, 1, mark);
        this.commandQueue.put(action);
        action.waitEnd();
    }

    protected void seekPlayItem(int item) throws IllegalArgumentException {
        if (this.pi == null || item < 0 || item >= this.pi.getClipCount()) {
            throw new IllegalArgumentException();
        }
        PlaylistPlayerAction action = new PlaylistPlayerAction(this, 2, item);
        this.commandQueue.put(action);
        action.waitEnd();
    }

    private static class PlaylistPlayerAction
    extends BDJAction {
        private Handler player;
        private int action;
        private int param;
        public static final int ACTION_SEEK_MARK = 1;
        public static final int ACTION_SEEK_PLAYITEM = 2;

        private PlaylistPlayerAction(Handler player, int action, int param) {
            this.player = player;
            this.action = action;
            this.param = param;
        }

        protected void doAction() {
            switch (this.action) {
                case 1: {
                    if (this.player.getState() == 500 || this.player.getState() == 600) {
                        Libbluray.seekMark(this.param);
                        this.player.updateTime(new Time((double)Libbluray.tellTime() * 1.1111111111111112E-5));
                        break;
                    }
                    if (this.player.sourceLocator == null) break;
                    this.player.sourceLocator.setMarkId(this.param);
                    this.player.sourceLocator.setPlayItemId(-1);
                    break;
                }
                case 2: {
                    if (this.player.getState() == 500 || this.player.getState() == 600) {
                        Libbluray.seekPlayItem(this.param);
                        this.player.updateTime(new Time((double)Libbluray.tellTime() * 1.1111111111111112E-5));
                        break;
                    }
                    if (this.player.sourceLocator == null) break;
                    this.player.sourceLocator.setMarkId(-1);
                    this.player.sourceLocator.setPlayItemId(this.param);
                }
            }
        }
    }
}

