/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.media.content.playlist;

import java.util.EventObject;
import org.bluray.media.StreamNotAvailableException;
import org.bluray.media.SubtitleStyleNotAvailableException;
import org.bluray.media.SubtitlingControl;
import org.bluray.media.TextSubtitleNotAvailableException;
import org.bluray.ti.CodingType;
import org.dvb.media.SubtitleListener;
import org.videolan.BDJListeners;
import org.videolan.Libbluray;
import org.videolan.StreamInfo;
import org.videolan.TIClip;
import org.videolan.media.content.playlist.Handler;
import org.videolan.media.content.playlist.StreamControl;

public class SubtitlingControlImpl
extends StreamControl
implements SubtitlingControl {
    private BDJListeners listeners = new BDJListeners();

    protected SubtitlingControlImpl(Handler player) {
        super(player);
    }

    protected StreamInfo[] getStreams() {
        TIClip ci = this.player.getCurrentClipInfo();
        if (ci == null) {
            return null;
        }
        return ci.getPgStreams();
    }

    protected String getDefaultLanguage() {
        return this.languageFromInteger(Libbluray.readPSR(17));
    }

    public int getCurrentStreamNumber() {
        return Libbluray.readPSR(2) & 0xFFF;
    }

    protected void setStreamNumber(int num) {
        Libbluray.writePSR(2, num, 4095);
    }

    public boolean isSubtitlingOn() {
        return (Libbluray.readPSR(2) & Integer.MIN_VALUE) != 0;
    }

    public boolean setSubtitling(boolean mode) {
        boolean oldMode = (Libbluray.readPSR(2) & Integer.MIN_VALUE) != 0;
        Libbluray.writePSR(2, mode ? Integer.MIN_VALUE : 0, Integer.MIN_VALUE);
        return oldMode;
    }

    public void selectSubtitle(int subtitle) throws StreamNotAvailableException {
        this.selectStreamNumber(subtitle);
    }

    public boolean isPipSubtitleMode() {
        return (Libbluray.readPSR(2) & 0x40000000) != 0;
    }

    public boolean setPipSubtitleMode(boolean mode) {
        boolean oldMode = (Libbluray.readPSR(2) & 0x40000000) != 0;
        Libbluray.writePSR(2, mode ? 0x40000000 : 0, 0x40000000);
        return oldMode;
    }

    public void setSubtitleStyle(int style) throws TextSubtitleNotAvailableException, SubtitleStyleNotAvailableException {
        if (style <= 0 || style > 25 && style != 255) {
            throw new SubtitleStyleNotAvailableException();
        }
        if (this.getCurrentSubtitleType() != CodingType.TEXT_SUBTITLE) {
            throw new TextSubtitleNotAvailableException();
        }
        Libbluray.writePSR(12, style);
    }

    public CodingType getCurrentSubtitleType() {
        StreamInfo[] streamInfo = this.getStreams();
        if (streamInfo == null) {
            return null;
        }
        int stream = this.getCurrentStreamNumber();
        if (stream <= 0 || stream > streamInfo.length) {
            return null;
        }
        return streamInfo[stream - 1].getCodingType();
    }

    public int getSubtitleStyle() throws TextSubtitleNotAvailableException, SubtitleStyleNotAvailableException {
        if (this.getCurrentSubtitleType() != CodingType.TEXT_SUBTITLE) {
            throw new TextSubtitleNotAvailableException();
        }
        int style = Libbluray.readPSR(12);
        if (style <= 0 || style > 25 && style != 255) {
            throw new SubtitleStyleNotAvailableException();
        }
        return style;
    }

    public void addSubtitleListener(SubtitleListener listener) {
        this.listeners.add(listener);
    }

    public void removeSubtitleListener(SubtitleListener listener) {
        this.listeners.remove(listener);
    }

    protected void onSubtitleChange(int param) {
        this.listeners.putCallback(new EventObject(this));
    }
}

