/*
 * Decompiled with CFR 0.152.
 */
package org.bluray.ui;

import java.awt.BDWindowGraphics;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.ImageObserver;
import org.bluray.ui.AnimationParameters;
import org.bluray.ui.FrameAccurateAnimation;
import org.videolan.GUIManager;
import org.videolan.Logger;

public class ImageFrameAccurateAnimation
extends FrameAccurateAnimation
implements ImageObserver {
    public static final int PLAY_REPEATING = 1;
    public static final int PLAY_ALTERNATING = 2;
    public static final int PLAY_ONCE = 3;
    private int playmode;
    private int position = 0;
    private Image[] images = null;
    private Image[] scaledImages = null;
    private boolean prepared = false;
    private Dimension size = null;
    private AnimationThread animation = null;
    private static final long serialVersionUID = 2691302238670178111L;
    private static final Logger logger = Logger.getLogger(FrameAccurateAnimation.class.getName());

    public static ImageFrameAccurateAnimation getInstance(Image[] images, Dimension size, AnimationParameters params, int playmode) throws NullPointerException, IllegalArgumentException {
        int i;
        if (images == null || size == null || params == null) {
            throw new NullPointerException();
        }
        if (playmode < 1 || playmode > 3) {
            throw new IllegalArgumentException();
        }
        if (images.length < 1) {
            throw new IllegalArgumentException();
        }
        for (i = 0; i < images.length; ++i) {
            if (images[i] != null) continue;
            throw new NullPointerException();
        }
        if (params.scaleFactor <= 0) {
            throw new IllegalArgumentException("the scaleFactor is neither 1 or 2");
        }
        if (params.repeatCount != null) {
            if (images.length != params.repeatCount.length) {
                throw new IllegalArgumentException();
            }
            for (i = 0; i < params.repeatCount.length; ++i) {
                if (params.repeatCount[i] >= 0) continue;
                throw new IllegalArgumentException();
            }
        }
        return new ImageFrameAccurateAnimation(images, size, params, playmode);
    }

    private ImageFrameAccurateAnimation(Image[] images, Dimension size, AnimationParameters params, int playmode) {
        super(params);
        this.images = (Image[])images.clone();
        this.size = (Dimension)size.clone();
        this.playmode = playmode;
    }

    public AnimationParameters getAnimationParameters() {
        return new AnimationParameters(this.params);
    }

    public Image[] getImages() {
        return (Image[])this.images.clone();
    }

    public int getPlayMode() {
        return this.playmode;
    }

    public int getPosition() {
        return this.position;
    }

    public void prepareImages() {
        if (this.prepared) {
            return;
        }
        MediaTracker mt = new MediaTracker(this);
        for (int i = 0; i < this.images.length; ++i) {
            mt.addImage(this.images[i], i);
        }
        try {
            mt.waitForAll();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.images.length; ++i) {
            mt.removeImage(this.images[i], i);
        }
        if (this.params.scaleFactor != 1) {
            logger.unimplemented("image_scaling");
        }
        this.prepared = true;
    }

    public void setPlayMode(int mode) throws IllegalArgumentException {
        if (mode < 1 || mode > 3) {
            throw new IllegalArgumentException();
        }
        this.playmode = mode;
    }

    public void setPosition(int position) {
        if (position < 0 || position >= this.images.length) {
            throw new IllegalArgumentException();
        }
        this.position = position;
    }

    protected void destroyImpl() {
        this.stopImpl();
        this.images = null;
        this.scaledImages = null;
    }

    protected void startImpl() {
        if (!this.prepared) {
            this.prepareImages();
        }
        if (this.animation == null) {
            this.animation = new AnimationThread(this);
        }
    }

    protected void stopImpl() {
        if (this.animation != null) {
            this.animation.stop();
            this.animation = null;
        }
    }

    public void paint(Graphics g) {
        if (this.images != null && this.images[this.position] != null && !g.drawImage(this.images[this.position], super.getBounds().x, super.getBounds().y, this)) {
            logger.warning("paint(" + this.position + ") failed");
        }
    }

    private class AnimationThread
    implements Runnable {
        private Thread thread = null;
        private boolean ready = false;
        private ImageFrameAccurateAnimation faa;

        AnimationThread(ImageFrameAccurateAnimation faa) {
            this.faa = faa;
            this.thread = new Thread(this);
            this.thread.start();
        }

        public void stop() {
            this.ready = true;
            if (this.thread != null) {
                try {
                    this.thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.thread = null;
            }
            this.faa = null;
        }

        public void run() {
            int increment = 1;
            while (!this.ready) {
                BDWindowGraphics g = new BDWindowGraphics(GUIManager.getInstance());
                this.faa.paint(g);
                ((Graphics)g).dispose();
                int count = 1;
                if (this.faa.params.repeatCount != null && this.faa.params.repeatCount.length < ImageFrameAccurateAnimation.this.position) {
                    count += this.faa.params.repeatCount[this.faa.position];
                }
                while (!this.ready && count > 0) {
                    try {
                        Thread.sleep(40L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    --count;
                }
                int position = this.faa.position + increment;
                if (position >= this.faa.images.length) {
                    if (this.faa.playmode == 1) {
                        position = 0;
                    } else if (ImageFrameAccurateAnimation.this.playmode == 2) {
                        increment = -1;
                        position = this.faa.images.length - 2;
                    } else if (ImageFrameAccurateAnimation.this.playmode == 3) {
                        this.ready = true;
                        break;
                    }
                }
                if (position < 0) {
                    position = 1;
                    increment = 1;
                }
                this.faa.position = position;
            }
            this.faa.running = false;
        }
    }
}

