/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.tv.media.MediaSelectEvent;
import javax.tv.media.MediaSelectListener;
import javax.tv.service.selection.ServiceContextEvent;
import javax.tv.service.selection.ServiceContextListener;
import org.bluray.bdplus.StatusListener;
import org.bluray.media.AngleChangeEvent;
import org.bluray.media.AngleChangeListener;
import org.bluray.media.PanningChangeEvent;
import org.bluray.media.PanningChangeListener;
import org.bluray.media.PiPStatusEvent;
import org.bluray.media.PiPStatusListener;
import org.bluray.media.PlaybackListener;
import org.bluray.media.PlaybackMarkEvent;
import org.bluray.media.PlaybackPlayItemEvent;
import org.bluray.media.UOMaskTableChangedEvent;
import org.bluray.media.UOMaskTableListener;
import org.bluray.media.UOMaskedEvent;
import org.davic.resources.ResourceStatusEvent;
import org.davic.resources.ResourceStatusListener;
import org.dvb.application.AppsDatabaseEvent;
import org.dvb.application.AppsDatabaseEventListener;
import org.dvb.media.SubtitleAvailableEvent;
import org.dvb.media.SubtitleListener;
import org.dvb.media.SubtitleNotAvailableEvent;
import org.dvb.media.SubtitleNotSelectedEvent;
import org.dvb.media.SubtitleSelectedEvent;
import org.dvb.media.VideoFormatEvent;
import org.dvb.media.VideoFormatListener;
import org.videolan.BDJAction;
import org.videolan.BDJXletContext;
import org.videolan.Logger;

public class BDJListeners {
    private LinkedList listeners = new LinkedList();
    private static final Logger logger = Logger.getLogger(BDJListeners.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object listener) {
        if (listener != null) {
            BDJXletContext ctx = BDJXletContext.getCurrentContext();
            if (ctx == null) {
                logger.error("Listener added from wrong thread: " + Logger.dumpStack());
                return;
            }
            LinkedList linkedList = this.listeners;
            synchronized (linkedList) {
                this.remove(listener);
                this.listeners.add(new BDJListener(ctx, listener));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object listener) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                BDJListener item = (BDJListener)it.next();
                if (item.listener != listener) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (null != BDJXletContext.getCurrentContext()) {
            logger.error("clear() from wrong thread: " + Logger.dumpStack());
            return;
        }
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.clear();
        }
    }

    public void putCallback(Object event) {
        boolean mediaQueue = true;
        if (event instanceof ServiceContextEvent) {
            mediaQueue = false;
        } else if (event instanceof ResourceStatusEvent) {
            mediaQueue = false;
        } else if (event instanceof AppsDatabaseEvent) {
            mediaQueue = false;
        } else if (event instanceof PSR102Status) {
            mediaQueue = false;
        }
        this.putCallback(event, mediaQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCallback(Object event, boolean mediaQueue) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                BDJListener item = (BDJListener)it.next();
                if (item.ctx == null || item.ctx.isReleased()) {
                    logger.info("Listener terminated: " + item.ctx);
                    it.remove();
                    continue;
                }
                if (mediaQueue) {
                    item.ctx.putMediaCallback(new Callback(event, item.listener));
                    continue;
                }
                item.ctx.putCallback(new Callback(event, item.listener));
            }
        }
    }

    public void putPSR102Callback(int value) {
        this.putCallback(new PSR102Status(value));
    }

    private static class Callback
    extends BDJAction {
        private Object listener;
        private Object event;

        private Callback(Object event, Object listener) {
            this.event = event;
            this.listener = listener;
        }

        public String toString() {
            return this.getClass().getName() + "[event=" + this.event + ", listener=" + this.listener;
        }

        protected void doAction() {
            if (this.event instanceof PlaybackMarkEvent) {
                ((PlaybackListener)this.listener).markReached((PlaybackMarkEvent)this.event);
            } else if (this.event instanceof PlaybackPlayItemEvent) {
                ((PlaybackListener)this.listener).playItemReached((PlaybackPlayItemEvent)this.event);
            } else if (this.event instanceof ServiceContextEvent) {
                ((ServiceContextListener)this.listener).receiveServiceContextEvent((ServiceContextEvent)this.event);
            } else if (this.event instanceof UOMaskTableChangedEvent) {
                ((UOMaskTableListener)this.listener).receiveUOMaskTableChangedEvent((UOMaskTableChangedEvent)this.event);
            } else if (this.event instanceof UOMaskedEvent) {
                ((UOMaskTableListener)this.listener).receiveUOMaskedEvent((UOMaskedEvent)this.event);
            } else if (this.event instanceof PiPStatusEvent) {
                ((PiPStatusListener)this.listener).piPStatusChange((PiPStatusEvent)this.event);
            } else if (this.event instanceof PanningChangeEvent) {
                ((PanningChangeListener)this.listener).panningChange((PanningChangeEvent)this.event);
            } else if (this.event instanceof AngleChangeEvent) {
                ((AngleChangeListener)this.listener).angleChange((AngleChangeEvent)this.event);
            } else if (this.event instanceof MediaSelectEvent) {
                ((MediaSelectListener)this.listener).selectionComplete((MediaSelectEvent)this.event);
            } else if (this.event instanceof GainChangeEvent) {
                ((GainChangeListener)this.listener).gainChange((GainChangeEvent)this.event);
            } else if (this.event instanceof ControllerEvent) {
                ((ControllerListener)this.listener).controllerUpdate((ControllerEvent)this.event);
            } else if (this.event instanceof ResourceStatusEvent) {
                ((ResourceStatusListener)this.listener).statusChanged((ResourceStatusEvent)this.event);
            } else if (this.event instanceof AppsDatabaseEvent) {
                AppsDatabaseEvent dbevent = (AppsDatabaseEvent)this.event;
                AppsDatabaseEventListener dblistener = (AppsDatabaseEventListener)this.listener;
                switch (dbevent.getEventId()) {
                    case 2: {
                        dblistener.entryAdded(dbevent);
                        break;
                    }
                    case 1: {
                        dblistener.entryChanged(dbevent);
                        break;
                    }
                    case 3: {
                        dblistener.entryRemoved(dbevent);
                        break;
                    }
                    case 0: {
                        dblistener.newDatabase(dbevent);
                    }
                }
            } else if (this.event instanceof SubtitleAvailableEvent || this.event instanceof SubtitleNotAvailableEvent || this.event instanceof SubtitleNotSelectedEvent || this.event instanceof SubtitleSelectedEvent) {
                ((SubtitleListener)this.listener).subtitleStatusChanged((EventObject)this.event);
            } else if (this.event instanceof VideoFormatEvent) {
                ((VideoFormatListener)this.listener).receiveVideoFormatEvent((VideoFormatEvent)this.event);
            } else if (this.event instanceof PSR102Status) {
                ((StatusListener)this.listener).receive(((PSR102Status)this.event).value);
            } else {
                System.err.println("Unknown event type: " + this.event.getClass().getName());
            }
        }
    }

    private static class BDJListener {
        public BDJXletContext ctx;
        public Object listener;

        BDJListener(BDJXletContext ctx, Object listener) {
            this.ctx = ctx;
            this.listener = listener;
        }
    }

    private static class PSR102Status {
        public int value;

        private PSR102Status(int value) {
            this.value = value;
        }
    }
}

