/*
 * Decompiled with CFR 0.152.
 */
package org.bluray.vfs;

import org.bluray.vfs.PreparingFailedException;
import org.bluray.vfs.VFSPermission;
import org.videolan.BUMFAsset;
import org.videolan.BUMFParser;
import org.videolan.Logger;

public class VFSManager {
    private static VFSManager instance = null;
    private static final Object instanceLock = new Object();
    private int state = 1;
    public static final int STABLE = 1;
    public static final int PREPARING = 2;
    public static final int PREPARED = 3;
    public static final int UPDATING = 4;
    private static final Logger logger = Logger.getLogger(VFSManager.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VFSManager getInstance() throws SecurityException, UnsupportedOperationException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new VFSPermission("*"));
        }
        Object object = instanceLock;
        synchronized (object) {
            if (instance == null) {
                instance = new VFSManager();
            }
            return instance;
        }
    }

    protected VFSManager() {
    }

    public boolean disableClip(String streamfile) {
        logger.unimplemented("disableClip");
        return true;
    }

    public boolean enableClip(String streamfile) {
        logger.unimplemented("enableClip");
        return true;
    }

    public String[] getDisabledClipIDs() {
        logger.unimplemented("getDisabledClipIDs");
        return new String[0];
    }

    public int getState() {
        return this.state;
    }

    public boolean isEnabledClip(String clipID) {
        logger.unimplemented("isEnabledClip");
        return true;
    }

    public void requestUpdating(String manifestfile, String signaturefile, boolean initBackupRegs) throws PreparingFailedException {
        this.state = 2;
        BUMFAsset[] assets = BUMFParser.parse(manifestfile);
        if (assets == null) {
            logger.error("manifest parsing failed");
            this.state = 1;
            throw new PreparingFailedException();
        }
        logger.unimplemented("requestUpdating(" + manifestfile + ")");
        this.state = 1;
        throw new PreparingFailedException();
    }
}

