/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.awt.Dimension;
import org.bluray.ti.CodingType;

public class StreamInfo {
    private final byte coding_type;
    private final byte format;
    private final byte rate;
    private final char char_code;
    private final String lang;
    private final byte aspect;
    private final byte subpath_id;

    public StreamInfo(byte coding_type, byte format, byte rate, char char_code, String lang, byte aspect, byte subpath_id) {
        this.coding_type = coding_type;
        this.format = format;
        this.rate = rate;
        this.char_code = char_code;
        this.lang = lang;
        this.aspect = aspect;
        this.subpath_id = subpath_id;
    }

    public CodingType getCodingType() {
        switch (this.coding_type) {
            case 2: {
                return CodingType.MPEG2_VIDEO;
            }
            case 27: {
                return CodingType.MPEG4_AVC_VIDEO;
            }
            case -22: {
                return CodingType.SMPTE_VC1_VIDEO;
            }
            case -128: {
                return CodingType.LPCM_AUDIO;
            }
            case -127: {
                return CodingType.DOLBY_AC3_AUDIO;
            }
            case -126: {
                return CodingType.DTS_AUDIO;
            }
            case -125: {
                return CodingType.DOLBY_LOSSLESS_AUDIO;
            }
            case -124: 
            case -95: {
                return CodingType.DOLBY_DIGITAL_PLUS_AUDIO;
            }
            case -123: {
                return CodingType.DTS_HD_AUDIO_EXCEPT_XLL;
            }
            case -122: {
                return CodingType.DTS_HD_AUDIO_XLL;
            }
            case -94: {
                return CodingType.DTS_HD_AUDIO_LBR;
            }
            case -112: {
                return CodingType.PRESENTATION_GRAPHICS;
            }
            case -111: {
                return CodingType.INTERACTIVE_GRAPHICS;
            }
            case -110: {
                return CodingType.TEXT_SUBTITLE;
            }
        }
        return null;
    }

    public byte getFormat() {
        return this.format;
    }

    public Dimension getVideoSize() {
        int height;
        int width;
        switch (this.format) {
            case 1: 
            case 3: {
                width = 720;
                height = 480;
                break;
            }
            case 2: 
            case 7: {
                width = 720;
                height = 576;
                break;
            }
            case 5: {
                width = 1280;
                height = 720;
                break;
            }
            case 4: 
            case 6: {
                width = 1920;
                height = 1080;
                break;
            }
            default: {
                return null;
            }
        }
        return new Dimension(width, height);
    }

    public Dimension getVideoAspectRatio() {
        int y;
        int x;
        switch (this.aspect) {
            case 2: {
                x = 4;
                y = 3;
                break;
            }
            case 3: {
                x = 16;
                y = 9;
                break;
            }
            default: {
                return null;
            }
        }
        return new Dimension(x, y);
    }

    public byte getRate() {
        return this.rate;
    }

    public char getChar_code() {
        return this.char_code;
    }

    public String getLang() {
        return this.lang;
    }

    public int getSubPathId() {
        return this.subpath_id;
    }
}

