/*
 * Decompiled with CFR 0.152.
 */
package org.dvb.dsmcc;

import java.io.FileNotFoundException;
import java.io.InterruptedIOException;
import java.net.URL;
import org.bluray.net.BDLocator;
import org.davic.net.InvalidLocatorException;
import org.davic.net.Locator;
import org.dvb.dsmcc.DSMCCException;
import org.dvb.dsmcc.DSMCCObject;
import org.dvb.dsmcc.InvalidAddressException;
import org.dvb.dsmcc.MPEGDeliveryException;
import org.dvb.dsmcc.NotLoadedException;
import org.dvb.dsmcc.ServiceXFRException;
import org.videolan.Logger;
import org.videolan.MountException;
import org.videolan.MountManager;

public class ServiceDomain {
    private DSMCCObject mountPoint = null;
    private Locator locator = null;

    public void attach(Locator dvbService, int carouselId) throws ServiceXFRException, InterruptedIOException, MPEGDeliveryException {
        Logger.unimplemented("ServiceDomain", "attach");
        throw new Error("Not implemented");
    }

    public void attach(Locator locator) throws DSMCCException, InterruptedIOException, MPEGDeliveryException {
        BDLocator bdl = ServiceDomain.checkLocator(locator);
        if (bdl == null) {
            throw new DSMCCException("invalid BDLocator");
        }
        if (!bdl.isJarFileItem()) {
            throw new DSMCCException("invalid BDLocator");
        }
        try {
            this.mountPoint = new DSMCCObject(MountManager.mount(bdl.getJarFileId()));
            this.locator = locator;
        }
        catch (MountException e) {
            e.printStackTrace();
            throw new DSMCCException("couldn't mount jar");
        }
    }

    public void attach(byte[] NSAPAddress) throws DSMCCException, InterruptedIOException, InvalidAddressException, MPEGDeliveryException {
        Logger.unimplemented("ServiceDomain", "attach");
        throw new Error("Not implemented");
    }

    public void detach() throws NotLoadedException {
        if (this.mountPoint == null) {
            throw new NotLoadedException();
        }
    }

    public byte[] getNSAPAddress() throws NotLoadedException {
        Logger.unimplemented("ServiceDomain", "getNSAPAddress");
        throw new Error("Not implemented");
    }

    public static URL getURL(Locator locator) throws NotLoadedException, InvalidLocatorException, FileNotFoundException {
        BDLocator bdl = ServiceDomain.checkLocator(locator);
        if (bdl == null) {
            throw new InvalidLocatorException("invalid BDLocator");
        }
        if (bdl.isJarFileItem()) {
            String mountPt = MountManager.getMount(bdl.getJarFileId());
            if (mountPt == null) {
                throw new NotLoadedException();
            }
            DSMCCObject obj = new DSMCCObject(mountPt, bdl.getPathSegments());
            if (!obj.exists()) {
                throw new FileNotFoundException();
            }
            return obj.getURL();
        }
        throw new InvalidLocatorException();
    }

    public DSMCCObject getMountPoint() {
        return this.mountPoint;
    }

    public boolean isNetworkConnectionAvailable() {
        Logger.unimplemented("ServiceDomain", "isNetworkConnectionAvailable");
        return false;
    }

    public boolean isAttached() {
        return this.mountPoint != null;
    }

    public Locator getLocator() {
        return this.locator;
    }

    private static BDLocator checkLocator(Locator locator) {
        if (!(locator instanceof BDLocator)) {
            return null;
        }
        BDLocator bdl = (BDLocator)locator;
        if (bdl.isJarFileItem()) {
            return bdl;
        }
        return null;
    }
}

