/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Hashtable;
import java.util.Map;
import org.havi.ui.HAnimateLook;
import org.havi.ui.HChangeData;
import org.havi.ui.HComponent;
import org.havi.ui.HDefaultTextLayoutManager;
import org.havi.ui.HGraphicLook;
import org.havi.ui.HInvalidLookException;
import org.havi.ui.HLook;
import org.havi.ui.HNavigable;
import org.havi.ui.HSelectionInputPreferred;
import org.havi.ui.HState;
import org.havi.ui.HTextLayoutManager;
import org.havi.ui.HTextLook;
import org.videolan.Logger;

public class HVisible
extends HComponent
implements HState {
    public static final int HALIGN_LEFT = 0;
    public static final int HALIGN_CENTER = 1;
    public static final int HALIGN_RIGHT = 2;
    public static final int HALIGN_JUSTIFY = 3;
    public static final int VALIGN_TOP = 0;
    public static final int VALIGN_CENTER = 4;
    public static final int VALIGN_BOTTOM = 8;
    public static final int VALIGN_JUSTIFY = 12;
    public static final int RESIZE_NONE = 0;
    public static final int RESIZE_PRESERVE_ASPECT = 1;
    public static final int RESIZE_ARBITRARY = 2;
    public static final int NO_BACKGROUND_FILL = 0;
    public static final int BACKGROUND_FILL = 1;
    public static final int FIRST_CHANGE = 0;
    public static final int TEXT_CONTENT_CHANGE = 0;
    public static final int GRAPHIC_CONTENT_CHANGE = 1;
    public static final int ANIMATE_CONTENT_CHANGE = 2;
    public static final int CONTENT_CHANGE = 3;
    public static final int STATE_CHANGE = 4;
    public static final int CARET_POSITION_CHANGE = 5;
    public static final int ECHO_CHAR_CHANGE = 6;
    public static final int EDIT_MODE_CHANGE = 7;
    public static final int MIN_MAX_CHANGE = 8;
    public static final int THUMB_OFFSETS_CHANGE = 9;
    public static final int ORIENTATION_CHANGE = 10;
    public static final int TEXT_VALUE_CHANGE = 11;
    public static final int ITEM_VALUE_CHANGE = 12;
    public static final int ADJUSTMENT_VALUE_CHANGE = 13;
    public static final int LIST_CONTENT_CHANGE = 14;
    public static final int LIST_ICONSIZE_CHANGE = 15;
    public static final int LIST_LABELSIZE_CHANGE = 16;
    public static final int LIST_MULTISELECTION_CHANGE = 17;
    public static final int LIST_SCROLLPOSITION_CHANGE = 18;
    public static final int SIZE_CHANGE = 19;
    public static final int BORDER_CHANGE = 20;
    public static final int REPEAT_COUNT_CHANGE = 21;
    public static final int ANIMATION_POSITION_CHANGE = 22;
    public static final int LIST_SELECTION_CHANGE = 23;
    public static final int UNKNOWN_CHANGE = 24;
    public static final int LAST_CHANGE = 24;
    public static final int NO_DEFAULT_WIDTH = -1;
    public static final int NO_DEFAULT_HEIGHT = -1;
    public static final Dimension NO_DEFAULT_SIZE = new Dimension(-1, -1);
    private static final long serialVersionUID = -2076075723286676347L;
    private transient HLook hLook;
    private Map lookData;
    private int BackgroundMode = 0;
    private boolean BordersEnabled = true;
    private int InteractionState = 0;
    private int halign = 0;
    private int valign = 0;
    private int resizeMode = 0;
    private transient HTextLayoutManager TextLayoutManager = null;
    private Object[] content;
    private Dimension defaultSize = NO_DEFAULT_SIZE;
    private static final Logger logger = Logger.getLogger(HVisible.class.getName());

    public HVisible() {
        this(null);
    }

    public HVisible(HLook hlook) {
        this(hlook, 0, 0, 0, 0);
    }

    public HVisible(HLook hlook, int x, int y, int width, int height) {
        super(x, y, width, height);
        this.hLook = hlook;
        this.TextLayoutManager = new HDefaultTextLayoutManager();
        this.content = new Object[8];
    }

    public boolean isFocusTraversable() {
        return this instanceof HNavigable || this instanceof HSelectionInputPreferred;
    }

    public void paint(Graphics g) {
        if (this.hLook != null) {
            this.hLook.showLook(g, this, this.InteractionState);
        }
    }

    public void update(Graphics g) {
        g.setColor(this.getBackground());
        this.paint(g);
    }

    public void setTextContent(String string, int state) {
        this.setContentImpl(string, state, 0);
    }

    public void setGraphicContent(Image image, int state) {
        this.setContentImpl(image, state, 1);
    }

    public void setAnimateContent(Image[] imageArray, int state) {
        this.setContentImpl(imageArray, state, 2);
    }

    public void setContent(Object object, int state) {
        this.setContentImpl(object, state, 3);
    }

    private void setContentImpl(Object object, int state, int hint) {
        int i;
        int states = 8;
        Object[] oldData = new Object[states + 1];
        oldData[0] = new Integer(state);
        for (i = 0; i < states; ++i) {
            oldData[i + 1] = this.content[i];
        }
        if (state == 7) {
            for (i = 0; i < states; ++i) {
                this.content[i] = object;
            }
        } else {
            if (state < 128 || state > 135) {
                logger.info("state out of range in getContext()");
                throw new IllegalArgumentException("state out of range");
            }
            this.content[state - 128] = object;
        }
        this.visibleChanged(hint, oldData);
    }

    private void visibleChanged(int hint, Object data) {
        if (this.hLook == null) {
            return;
        }
        HChangeData[] changeData = null;
        if (data != null) {
            changeData = new HChangeData[]{new HChangeData(hint, data)};
        }
        this.hLook.widgetChanged(this, changeData);
    }

    public String getTextContent(int state) {
        return (String)this.getContent(state);
    }

    public Image getGraphicContent(int state) {
        return (Image)this.getContent(state);
    }

    public Image[] getAnimateContent(int state) {
        return (Image[])this.getContent(state);
    }

    public Object getContent(int state) {
        if (state == 7) {
            logger.info("ALL_STATES not supported in getContent()");
            throw new IllegalArgumentException("ALL_STATES not supported in getContent()");
        }
        if (state < 128 || state > 135) {
            logger.info("state out of range in getContent()");
            throw new IllegalArgumentException("state out of range");
        }
        return this.content[state - 128];
    }

    public void setLook(HLook hlook) throws HInvalidLookException {
        this.hLook = hlook;
    }

    public HLook getLook() {
        return this.hLook;
    }

    public Dimension getPreferredSize() {
        if (this.hLook != null) {
            return this.hLook.getPreferredSize(this);
        }
        return this.getSize();
    }

    public Dimension getMaximumSize() {
        if (this.hLook != null) {
            return this.hLook.getMaximumSize(this);
        }
        return this.getSize();
    }

    public Dimension getMinimumSize() {
        if (this.hLook != null) {
            return this.hLook.getMinimumSize(this);
        }
        return this.getSize();
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.isFocusTraversable()) {
            this.setInteractionState(this.InteractionState | 1);
        }
    }

    protected void setInteractionState(int state) {
        if (this.InteractionState == state) {
            return;
        }
        Integer oldState = new Integer(this.InteractionState);
        this.InteractionState = state;
        this.visibleChanged(4, oldState);
    }

    public int getInteractionState() {
        return this.InteractionState;
    }

    public void setTextLayoutManager(HTextLayoutManager manager) {
        this.TextLayoutManager = manager;
    }

    public HTextLayoutManager getTextLayoutManager() {
        return this.TextLayoutManager;
    }

    public int getBackgroundMode() {
        return this.BackgroundMode;
    }

    public void setBackgroundMode(int mode) {
        if (mode != 1 && mode != 0) {
            logger.info("mode out of range in setBackgroundMode()");
            throw new IllegalArgumentException("Unknown background fill mode");
        }
        this.BackgroundMode = mode;
    }

    public boolean isOpaque() {
        if (this.hLook == null) {
            return false;
        }
        return this.hLook.isOpaque(this);
    }

    public void setDefaultSize(Dimension defaultSize) {
        this.defaultSize = defaultSize;
    }

    public Dimension getDefaultSize() {
        return this.defaultSize;
    }

    public Object getLookData(Object key) {
        if (this.lookData == null || !this.lookData.containsKey(key)) {
            return null;
        }
        return this.lookData.get(key);
    }

    public void setLookData(Object key, Object data) {
        if (this.lookData == null) {
            this.lookData = new Hashtable();
        }
        if (this.lookData.containsKey(key)) {
            this.lookData.remove(key);
        }
        if (data == null) {
            return;
        }
        this.lookData.put(key, data);
    }

    public void setHorizontalAlignment(int halign) {
        if (halign != 0 && halign != 1 && halign != 2 && halign != 3) {
            logger.info("align out of range in setHorizontalAlignment()");
            throw new IllegalArgumentException("Unknown halign");
        }
        this.halign = halign;
        this.visibleChanged(24, new Integer(24));
    }

    public void setVerticalAlignment(int valign) {
        if (valign != 0 && valign != 4 && valign != 8 && valign != 12) {
            logger.info("align out of range in setVerticalAlignment()");
            throw new IllegalArgumentException("Unknown valign");
        }
        this.valign = valign;
        this.visibleChanged(24, new Integer(24));
    }

    public int getHorizontalAlignment() {
        return this.halign;
    }

    public int getVerticalAlignment() {
        return this.valign;
    }

    public void setResizeMode(int resize) {
        if (resize != 0 && resize != 1 && resize != 2) {
            logger.info("resize out of range in setResizeMode()");
            throw new IllegalArgumentException("Unknown resize mode");
        }
        this.resizeMode = resize;
        this.visibleChanged(24, new Integer(24));
    }

    public int getResizeMode() {
        return this.resizeMode;
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (b) {
            this.setInteractionState(this.InteractionState & 0xFFFFFFFB);
        } else {
            this.setInteractionState(this.InteractionState | 4);
        }
    }

    public void setBordersEnabled(boolean enable) {
        if (enable == this.BordersEnabled) {
            return;
        }
        if (this.hLook instanceof HAnimateLook || this.hLook instanceof HGraphicLook || this.hLook instanceof HTextLook) {
            Boolean oldMode = new Boolean(this.BordersEnabled);
            this.BordersEnabled = enable;
            this.visibleChanged(20, oldMode);
        }
    }

    public boolean getBordersEnabled() {
        return this.BordersEnabled;
    }
}

