/*******************************************************************************
* dvd_reader.h: DVD reader
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: dvd_reader.h,v 1.1 2001/10/06 21:23:36 bozo Exp $
*
* Authors: Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


#ifndef _DVD_READER_H_
#define _DVD_READER_H_


//------------------------------------------------------------------------------
// Dvd Exception
//------------------------------------------------------------------------------
class E_Dvd : public E_Exception
{
public:
  E_Dvd(const C_String& strMsg);
};


//------------------------------------------------------------------------------
// C_DvdReader class
//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
class C_DvdReader : public C_MpegReader
{
protected:
  C_ProgramDescriptor* m_pPgrmDescriptor;

public:
  C_DvdReader(C_Broadcast* pBroadcast);
  virtual ~C_DvdReader();

  virtual void Init();

  virtual int Read(byte* pBuff, int iSize);
  virtual int Seek(s64 iOffset, int bStartPos);
  virtual s64 Size();

  void SetPgrmDescriptor(C_ProgramDescriptor* pPgrmDescriptor)
  {
    m_pPgrmDescriptor = pPgrmDescriptor;
  };

protected:
  int ReadBlock(bool bFill = true);

  C_String m_strDevice;
  int m_iTitleId;
  int m_iChapId;
  int m_iAngle;

  dvd_reader_t*         m_pDvd;
  dvd_file_t*           m_pTitle;
  ifo_handle_t*         m_pVmgFile;
  ifo_handle_t*         m_pVtsFile;

  pgc_t* m_pCurPgc;

  bool m_bJumpCell;
  bool m_bReadNav;

  int m_iFirstCell;
  int m_iStartCell;
  int m_iCurCell;
  int m_iNextCell;

  unsigned int m_uiCurBlock;
  unsigned int m_uiBlockLeft;

  unsigned int m_uiNextVobu;

  byte m_bBlock[DVD_VIDEO_LB_LEN];
  unsigned int m_uiByteLeft;

  bool m_bLoop;
};


#else
#error "Multiple inclusions of dvd_reader.h"
#endif

