/*******************************************************************************
* settings.h: Settings class definition
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: settings.h,v 1.2 2001/10/18 06:29:11 benny Exp $
*
* Authors: Benoit Steiner <benny@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


#ifndef _SETTINGS_H_
#define _SETTINGS_H_


//------------------------------------------------------------------------------
// C_Setting
//------------------------------------------------------------------------------
// Represents a single setting, ie a name and the associated value
//------------------------------------------------------------------------------
class C_Setting
{
 public:
  C_Setting(const C_String& strName, const C_String& strValue) : 
                                        m_strName(strName), m_strValue(strValue)
  {}

  C_Setting* Clone() const
  { return new C_Setting(*this); }
  
  const C_String& GetName() const
  { return m_strName; }
  const C_String& GetValue() const
  { return m_strValue; }

private:
  C_String m_strName;
  C_String m_strValue;
};



//------------------------------------------------------------------------------
// C_Settings
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
class C_Settings
{
 public:
  // Default constructor
  C_Settings();

  // Retrieve the config from both command line and config file
  void Load(const C_String& strDefaultCfgFile, bool bReadCmdLine = true);
  // Store it in an updated version of the cfg file
  void Store();

  // Update the value for a given property, or add it if it is not already
  // defined
  void Update(const C_String& strName, const C_String& strValue);

  // Access to the properties 
  C_String GetSetting(const C_String& strName, const C_String& strDflt) const;
  C_Vector<C_Setting> GetSettings(const C_String& strSection) const;

 private:
  C_HashTable<C_String, C_String> m_cSettings;  
};



#else
#error "Multiple inclusions of settings.h"
#endif

