/*******************************************************************************
* converter.cpp: Threaded Mpeg converters
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: converter.cpp,v 1.3 2002/04/02 16:15:11 bozo Exp $
*
* Authors: Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


//------------------------------------------------------------------------------
// Preamble
//------------------------------------------------------------------------------
#include "../core/defs.h"

#include "../core/core.h"

#include "mpeg.h"
#include "ts.h"

#include "../server/buffer.h"
#include "../server/program.h"
#include "../server/broadcast.h"
#include "../server/request.h"
#include "../server/input.h"

#include "reader.h"
#include "converter.h"


/*******************************************************************************
* C_MpegConverter
********************************************************************************
*
*******************************************************************************/


//------------------------------------------------------------------------------
// Constructor
//------------------------------------------------------------------------------
C_MpegConverter::C_MpegConverter(C_Module* pModule,
                                 C_MpegConverterConfig& cConfig)
{
  ASSERT(pModule);
  ASSERT(cConfig.m_hLog);
  ASSERT(cConfig.m_pBroadcast);
  ASSERT(cConfig.m_pReader);
  ASSERT(cConfig.m_pTsProvider);
  ASSERT(cConfig.m_pHandler);
  ASSERT(cConfig.m_pEventHandler);

  m_pModule             = pModule;
  m_hLog                = cConfig.m_hLog;
  m_pBroadcast          = cConfig.m_pBroadcast;
  m_pReader             = cConfig.m_pReader;
  m_pTsProvider         = cConfig.m_pTsProvider;
  m_pHandler            = cConfig.m_pHandler;
  m_iInitFill           = cConfig.m_iInitFill;
  m_pEventHandler       = cConfig.m_pEventHandler;
}


//------------------------------------------------------------------------------
// Destructor
//------------------------------------------------------------------------------
C_MpegConverter::~C_MpegConverter()
{
  m_pModule->Unref();

  delete m_pReader;
}


//------------------------------------------------------------------------------
// Initialization
//------------------------------------------------------------------------------
void C_MpegConverter::InitWork()
{
  m_iShortPauseStatus = m_iLongPauseStatus = STATUS_RUNNING;

  m_bStop = false;

  m_pReader->Init();
}


//------------------------------------------------------------------------------
// Stop request
//------------------------------------------------------------------------------
void C_MpegConverter::StopWork()
{
  m_bStop = true;

  DelayedInterruption();
}


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
void C_MpegConverter::CleanWork()
{
  m_pReader->Close();
}


//------------------------------------------------------------------------------
// Resume streaming
//------------------------------------------------------------------------------
void C_MpegConverter::Resume()
{
  m_cResumeCond.Protect();

  m_cResumeCond.Signal();
}


//------------------------------------------------------------------------------
// Suspend streaming
//------------------------------------------------------------------------------
void C_MpegConverter::Suspend()
{
  m_iLongPauseStatus = STATUS_PAUSE_REQUEST;
}


//------------------------------------------------------------------------------
// Short pause (use it to access for a very short time to the reader
//------------------------------------------------------------------------------
void C_MpegConverter::ShortPause()
{
  m_iShortPauseStatus = STATUS_PAUSE_REQUEST;
}


