


CTAGS(1)                                                 CTAGS(1)


NAME
       ctags - Generate C language tag files for use with vi(1)

SYNOPSIS
       ctags [ -aBdFnsStTuwWx ] [ -f tagfile ] [ -h list ]
             [ -i types ] [ -I ignorefile ] [ -L listfile ]
             [ -o tagfile ] [ --help ] [ file(s) ]

DESCRIPTION
       Ctags  generates  an  index  (or "tag") file of C language
       objects found in file(s) that allows  these  items  to  be
       quickly and easily located by a text editor or other util-
       ity. A "tag" signifies a C language object  for  which  an
       index  entry  is  available  (or, alternatively, the index
       entry created for that object).

       Alternatively, ctags can generate a cross  reference  file
       which lists, in human readable form, information about the
       various objects found in a set of C language files.

       Tag index files are supported by the vi(1) editor and  its
       derivatives  (such as vim, elvis, stevie, and xvi) through
       the use of the ":ta" command,  which  locates  the  object
       associated  with  a  name  appearing  in a source file and
       jumps to the file and line which  defines  the  name.  The
       following types of tags are supported by ctags:

           macro definitions (i.e. names created by #define)
           enumerated values (i.e. the values inside enum{...})
           function definitions
           function prototypes or declarations (optional)
           class, enum, struct and union tags
           typedefs
           variables

       Ctags  only  generates  tags for objects which have global
       scoping (file-wide visibility). This means that, with  the
       exception  of macro definitions, only objects defined out-
       side of brace enclosed function blocks are candidates  for
       a  tag.  For  every one of the qualified objects which are
       discovered in the source files supplied to ctags, a  sepa-
       rate  line is added to the tags file in the following for-
       mat:

           1.  tag name (a C language identifier)
           2.  a single tab character
           3.  the name of the file in which the  object  associ-
               ated with the tag is located
           4.  a single tab character
           5.  a  search  pattern (either /pattern/ or ?pattern?)
               or line number with which to locate the tag within
               the file

       Note  that,  unless  changed  via -n, line number are only



Darren Hiebert            18 August 1996                        1





CTAGS(1)                                                 CTAGS(1)


       used for tags for macro definitions,  while  patterns  are
       used for all other tags.

       Note that the name of each source file will be recorded in
       the tag file exactly as it appears on  the  command  line.
       Therefore,  if  the path you specified on the command line
       was relative to some directory, then it will  be  recorded
       in that same manner in the tag file.

       This  version of ctags imposes no formatting requirements.
       Other versions of ctags tended to rely upon  certain  for-
       matting  assumptions  in  order  to help it resolve coding
       dilemmas caused by preprocessor conditionals.

       In general, ctags tries to be smart about conditional pre-
       processor  directives.  If  a  preprocessor conditional is
       encountered within a statement which defines a tag,  ctags
       follows  only the first branch of that conditional (except
       in the special case of "#if 0", in which case  it  follows
       only the last branch). The reason for this is that failing
       to pursue only one branch can result in ambiguous  syntax,
       as in the following example:

              #ifdef STORE_SEPARATELY
              struct {
              #else
              union {
              #endif
                  short a;
                  long b;
              }

       Both  branches cannot be followed, or braces become unbal-
       anced and ctags would be unable to make sense of the  syn-
       tax.

       If  the  application  of  this heuristic fails to properly
       parse a file, generally due to complicated  and  inconsis-
       tent pairing within the conditionals, ctags will retry the
       file using a different heuristic  which  does  not  selec-
       tively   follow  conditional  preprocessor  branches,  but
       instead falls back to relying upon a closing  brace  ("}")
       in  column  1  as  indicating  the end of a block once any
       brace imbalance is detected within a #if conditional.

       Ctags will also try to specially  handle  arguments  lists
       enclosed  in double sets of parentheses in order to accept
       the following conditional construct:

              extern void (*fptr) __ARGS((int one, char two));

       Any name immediately preceding the "((" will be  discarded
       and the previous name will be used.




Darren Hiebert            18 August 1996                        2





CTAGS(1)                                                 CTAGS(1)


       After  creating or appending to the tag file, it is sorted
       by the tag name, removing identical tag lines.

OPTIONS
       Note that spaces separating options from their  parameters
       are optional.

       -a   Append the tags to an existing tag file.

       -B   Use backward searching patterns (?...?).

       -d   Include macro definitions in the output file. This is
            equivalent to -i+d and is supported  only  for  back-
            wards compatibility with other versions of ctags. Use
            of -i is preferred.

       -f tagfile
            Output  tags  to  the  specified  file  (default   is
            "tags"). If tagfile is specified as "-", then the tag
            file is written to standard  output  instead.   Ctags
            will  stubbornly  refuse  to  take  orders if tagfile
            exists and its first line  contains  something  other
            than  a valid tags line.  This will save your neck if
            you mistakenly type "ctags -o *.c", which would  oth-
            erwise overwrite your first C file with the tags gen-
            erated by the rest!

       -F   Use forward searching patterns (/.../) (default).

       -h list
            Specifies a list of file extensions used for headers,
            separated  by  either  periods or commas. The default
            list is ".h.H.hpp.hxx.h++".

       -i types
            Specifies the list of tag types  to  include  in  the
            output file.  Types is a group of letters designating
            the types of tags affected. Each letter or  group  of
            letters   may  be  preceded  by  either  a  '+'  sign
            (default, if omitted) to  add  it  to  those  already
            included,  a  '-'  sign  to  exclude it from the list
            (e.g.  to exclude a default tag type), or an '=' sign
            to  include  its corresponding tag type at the exclu-
            sion of those not listed. The following tag types are
            supported:
               d   macro definitions
               e   enumerated values (values inside enum{...})
               f   function and method definitions
               g   enum/struct/union tags (or new C++ types)
               p   external function prototypes
               t   typedefs
               v   variable declarations
            In   addition,   the   following  two  modifiers  are
            accepted:



Darren Hiebert            18 August 1996                        3





CTAGS(1)                                                 CTAGS(1)


               P   Prefix static tags (if included)  in  the  tag
                   file  with  the filename in which they appear,
                   followed by a colon (Elvis style;  not  widely
                   supported).
               S   Include static tags (those not visible outside
                   of a single source file).  Function and  vari-
                   able  definitions  are  considered static only
                   when their definitions are preceded  with  the
                   "static"  keyword. All other types of tags are
                   considered static when they appear in  a  non-
                   header file (see the -h option).
            The  default value of list is "=defgtvS" (i.e all tag
            types except for function prototypes; include  static
            tags but do not prefix them).

       -I ignorefile
            Read  from ignorefile a list of names of tokens which
            are to be  ignored  while  generating  tags  for  the
            source files. This is useful when preprocessor macros
            are used in such a way that they cause syntactic con-
            fusion due to their locations. In the following exam-
            ple, the macro "ARGDECL2" would be mistakenly  inter-
            preted  by  ctags  to  be  the  name  of the function
            instead of the correct name of "foo":

              int foo ARGDECL2(void *, ptr, long int, nbytes)

            Placing the name "ARGDECL2" into ignorefile and using
            the  -I  option causes ctags to ignore every instance
            of "ARGDECL2".

       -L listfile
            Read from listfile a list of  file  names  for  which
            tags should be generated. If listfile is specified as
            "-", then file names are read from standard input.

       -n   Places places the line numbers  in  the  source  file
            where  tags  are  located  rather than patterns to be
            searched for. This has two advantages:
            1.  Significantly reduces the size of  the  resulting
                tag file.
            2.  Eliminates failures to find tags because the line
                defining the tag has changed, causing the pattern
                match  to  fail  (note that some editors, such as
                vim, are able to recover in many such instances).
            3.  Eliminates finding identical matching, but incor-
                rect, source lines (see BUGS, below).
            However, this option has  one  significant  drawback:
            changes  to  the source files can cause the line num-
            bers recorded in the tag file to no longer correspond
            to  the  lines  in  the source file, causing jumps to
            some tags to miss the target  definition  by  one  or
            more  lines. Selecting this option causes the follow-
            ing options to be ignored: -F and -B.



Darren Hiebert            18 August 1996                        4





CTAGS(1)                                                 CTAGS(1)


       -o tagfile
            Alternative for -f.

       -s   Include static tags in the output file, each prefixed
            with  the  name  of the file in which it appears fol-
            lowed by a colon. This is equivalent to -i+SP and  is
            supported only for backwards compatibility with other
            versions of ctags. Use of -i is preferred.

       -S   Include static tags in the output file,  but  do  not
            prefix  them,  thereby making them appear the same as
            global tags. This is equivalent to -i+S-P and is sup-
            ported  only  for  backwards compatibility with other
            versions of ctags. Use of -i is preferred.

       -t   Include typedefs in the output file. This is  equiva-
            lent to -i+t and is supported only for backwards com-
            patibility with other versions of ctags. Use of -i is
            preferred.

       -T   Include  typedefs and class/enum/struct/union tags in
            the output file.  This is equivalent to -i+tg and  is
            supported only for backwards compatibility with other
            versions of ctags. Use of -i is preferred.

       -u   Unsorted; do not sort the tags. Please note that this
            disables the warning messages normally enabled by -W,
            because sorted tags  are  used  to  detect  duplicate
            tags. Note also that vi(1) requires sorted tags.

       -w   Exclude warnings about duplicate tags (default).

       -W   Generate warnings about duplicate tags.

       -x   Print   a  tabular,  human-readable  cross  reference
            (xref) file to standard output. The information  con-
            tained  in the output includes: the tag name; the tag
            type; the line number, file  name,  and  source  line
            (with  extra white space condensed) of the file which
            defines the tag. No tag file is written and the  fol-
            lowing options will be ignored: -a, -f, -i+P, -n, -o,
            -B and -F.  Example applications for this feature are
            generating  a  listing  of  all  functions (including
            statics) located in a source file (e.g.  ctags -xi=fS
            file), or generating a list of all externally visible
            global variables  located  in  a  source  file  (e.g.
            ctags -xi=v file).

       --help
            Prints  to  standard output a detailed usage descrip-
            tion.

ENVIRONMENT VARIABLES
       CTAGS   If found, this variable will be assumed to contain



Darren Hiebert            18 August 1996                        5





CTAGS(1)                                                 CTAGS(1)


               a  set  of  custom  default options which are read
               when ctags starts, but  before  any  command  line
               options  are read. Options in this variable should
               be in the same form as those on the command  line.
               Command  line options will override options speci-
               fied in this variable. Only options may be  speci-
               fied  with this variable; no source file names are
               read from its value.

HOW TO USE WITH VI
       Vi will, by default, expect a tag file by the name  "tags"
       in  the current directory. Once the tag file is build, the
       following vi commands take exercise the tag indexing  fea-
       ture:

       vi -t tag   Start  vi  and position the cursor at the file
                   and line where "tag" is defined.

       Control-]   Find the tag under the cursor.

       :ta tag     Find a tag.

       Control-T   Return to previous location before jump to tag
                   (not widely implemented).

BUGS
       Support for C++ features is quite limited.

       Because ctags does not look inside brace enclosed function
       blocks, local declarations of class/enum/struct/union tags
       and  enumeration  values  within  a function will not have
       tags generated for them.

       Note that because ctags generates search patterns for non-
       macro  tags,  it  is entirely possible that the wrong line
       may be found by your editor if there exists another, iden-
       tical,  line  (whose context prevents it from generating a
       tag) which is identical to the line  containing  the  tag.
       The following example demonstrates this condition:

              int variable;

              /* ... */
              void foo(variable)
              int variable;
              {
                  /* ... */
              }

       Depending  upon which editor you use and where in the code
       you happen to be, it is possible that the  search  pattern
       may locate the local parameter declaration in foo() before
       it finds the actual global variable definition, since  the
       lines (and therefore their search patterns are identical).



Darren Hiebert            18 August 1996                        6





CTAGS(1)                                                 CTAGS(1)


       Because ctags is neither a preprocessor  nor  a  compiler,
       some  complex  or  obscure  constructs can fool ctags into
       either missing a tag or improperly generating an  inappro-
       priate  tag.  In  particular, the use of preprocessor con-
       structs which alter the  textual  syntax  of  C  can  fool
       ctags, as demonstrated by the following example:

              #ifdef GLOBAL
              #define EXTERN
              #define INIT(assign)     assign
              #else
              #define EXTERN extern
              #define INIT(assign)
              #endif

              EXTERN BUF *firstbuf INIT(= NULL);

       This  looks  too  much  like  a declaration for a function
       called "INIT",  which  returns  a  pointer  to  a  typedef
       "firstbuf",  rather  than  the  actual variable definition
       that it is, since this distinction can only be resolved by
       the preprocessor. The moral of the story: don't do this if
       you want a tag generated for it.

FILES
       tags      The default tag file created by ctags.

SEE ALSO
       The official Exuberant Ctags web site at:

           http://fly.hiwaay.net/~darren/ctags.html

       Also ex(1), vi(1), elvis, or, better yet, vim,  the  offi-
       cial  editor  of  ctags.  For more information on vim, see
       the VIM Pages web site at:

           http://www.math.fu-berlin.de/~guckes/vim/

AUTHOR
       Darren  Hiebert,   (darren@sirsi.com,   darren@hiwaay.net,
       http://fly.hiwaay.net/~darren)

MOTIVATION
       "Think  ye at all times of rendering some service to every
       member of the human race."

       "All effort and exertion put forth by man from  the  full-
       ness  of  his  heart  is worship, if it is prompted by the
       highest motives and the will to do service to humanity."

                 -- From the Baha'i Writings

CREDITS
       This version of ctags is derived from and inspired by  the



Darren Hiebert            18 August 1996                        7





CTAGS(1)                                                 CTAGS(1)


       ctags  program  by  Steve Kirkendall (kirkenda@cs.pdx.edu)
       that comes with the Elvis vi clone (though almost none  of
       the original code remains).

       Credit  is also due Bram Moolenaar, the author of vim, who
       has devoted so much of his time and energy both to  devel-
       oping  the  editor  as a service to others, and to helping
       the orphans of Uganda.

















































Darren Hiebert            18 August 1996                        8


