.TH BITMAP 1 "1 March 1988" "X Version 11"
.SH NAME
bitmap \- bitmap editor for X

.SH SYNOPSIS
.B bitmap
[
.B \-options \.\.\.
] 
.I filename
[
.B WIDTHxHEIGHT
]
.SH DESCRIPTION

.I bitmap
lets you interactively create bitmaps, or edit previously created
bitmaps.  A bitmap is simply a rectangular
array of 0 and 1 bits.  The X Window System uses bitmaps in defining
clipping regions, cursor shapes, icon shapes, and tile and stipple
patterns.

When you run
.I bitmap,
you are given a magnified version of the bitmap, in which each
bit is shown as a large square, as if it were a piece of graph paper.
The pointer can be used to set, clear, or invert individual squares, and
to invoke commands to set, clear or invert larger rectangular areas of
the bitmap.  Other commands may be used to move or copy rectangular areas
from one part of the bitmap to another, and to define a `hot spot' (a
special single point on the bitmap, which is useful when the bitmap is
used as an X cursor).

The output of the
.I bitmap
program is a small C code fragment.  By #include'ing such a program
fragment in your program, you can easily declare the size and contents
of cursors, icons, and other bitmaps that your program creates to deal
with the X Window System.
.SH "OPTIONS"
.PP
This program accepts the following options:
.TP
.B \-help
This option (or any other unsupported option) will cause a brief description
of the allowable options and paramters to be printed.
.TP
.B \-display \fIdisplay\fP
This option specifies the server to be used.  See \fIX(1)\fP for details.
.TP
.B \-geometry \fIgeometry\fP
This option specifies the placement and size of the bitmap window on the
screen.  See \fIX(1)\fP for details.
.TP
.B \-nodashed
This option indicates that the grid lines in the work area should not be
drawn using dashed lines.  Although dashed lines are prettier than solid
lines, on some servers they are significantly slower.
.TP
.B \-bw \fInumber\fP
This option specifies the border width in pixels of the main window.
.TP
.B \-fn \fIfont\fP
This option specifies the font to be used in the buttons.
.TP
.B \-fg \fIcolor\fP
This option specifies the color to be used for the foreground.
.TP
.B \-bg \fIcolor\fP
This option specifies the color to be used for the background.
.TP
.B \-hl \fIcolor\fP
This option specifies the color to be used for highlighting.
.TP
.B \-bd \fIcolor\fP
This option specifies the color to be used for the window border.
.TP
.B \-ms \fIcolor\fP
This option specifies the color to be used for the pointer (mouse).
.PP

When 
.I bitmap
starts, it first tries to read the specified file
(see FILE FORMAT). If the file already exists, it
creates a window containing a grid of the
appropriate dimensions.

If the file does not exist, 
.I bitmap
will create a window for a
bitmap of the size specified by
.I WIDTHxHEIGHT
(e.g. 7x9, 13x21).
The bitmap will start out empty.  If 
.I WIDTHxHEIGHT 
is not specified specified either on the command line or in the 
"Dimensions" X Default, 16x16 will be assumed.

The window that 
.I bitmap
creates has four parts.  The largest
section is the checkerboard grid, which is a magnified version of the
bitmap you are editing.  At the upper right is a set of commands that you
can invoke with any pointer button.  Below the commands is an "actual size"
picture of the bitmap you are editing;  below that is an inverted
version of the same bitmap.  Each time you alter the image in the grid,
the change will be reflected in the actual-size versions of the bitmap.

If you use a window manager to make the
.I bitmap
window larger or smaller, the grid squares will automatically
get larger or smaller as well.

.SH COMMANDS

(Note for users of color displays:  In all of the following, 
``white'' means the background color, and ``black'' means the
foreground color.)

When the cursor is in the checkerboard region, each pointer button has
a different effect upon the single square that the cursor is over:

.PP
.TP 8
.I Button 1
(usually the left button) sets the indicated square.

.PP
.TP 8
.I Button 2
(usually the middle button) inverts the indicated square.
  
.PP
.TP 8
.I Button 3
(usually the right button) clear the indicated square.

.PP
The various commands are invoked by pressing any pointer button
in the corresponding command box:

.PP
.TP 8
.I Clear All
clears all squares in the bitmap.  This is irreversible, so invoke it with care.

.PP
.TP 8
.I Set All
sets all squares in the bitmap.  This is irreversible, so invoke it with care.

.PP
.TP 8
.I Invert All
inverts all squares in the bitmap.

.PP
.TP 8
.I Clear Area
clears a rectangular area of the bitmap.  After you click over this command, the
cursor turns into an `upper-left corner'.  Press any pointer button over the
upper-left corner of the area you want to invert,
.I hold the button down
while moving the pointer to the lower-right corner of the area you
want to invert, and then let the button up.

While you are holding down the button, the selected area will be
covered with X's, and the cursor will change to a `lower-right corner'.
If you now wish to abort the command without clearing an area, either press
another pointer button, move the cursor outside the grid, or move the
cursor to the left of or above the upper-left corner.

.PP
.TP 8
.I Set Area
sets a rectangular area of the bitmap.  It works the same way as the 
.I Clear Area
command.
    
.PP
.TP 8
.I Invert Area
inverts a rectangular area of the bitmap.  It works the same way as the 
.I Clear Area
command.

.PP
.TP 8
.I Copy Area
copies a rectangular area from
one part of the grid to another.  First, you select the rectangle to be
copied, in the manner described above under
.I Clear Area
above.  Then, the
cursor will change to an "upper-left corner".  When you press a pointer
button, a destination rectangle will overlay the grid;  moving the pointer
while holding down the button will move this destination rectangle.  The
copy will occur when you let up the button.  To cancel the copy, move
the pointer outside the grid and then let up the button.
.PP
.TP 8
.I Move Area
works identically to 
.I Copy Area, except
that it clears the source rectangle after copying to the destination.

.PP
.TP 8
.I Line
will draw a line between two points.

.PP
.TP 8
.I Overlay Area
works identically to \fICopy Area\fP, except that it does a binary OR
of the source rectangle with the destination.

.PP
.TP 8
.I Circle
will draw a circle specifying the center and a radius

.PP
.TP 8
.I Filled Circle
will draw a filled circle given the center and radius of the circle.
.PP
.TP 8
.I Set HotSpot
designates a point on the bitmap as the "hot spot".  If a program
is using your bitmap as a cursor, the hot spot indicates which point on
the bitmap is the "actual" location of the cursor.  For instance, if
your cursor is an arrow, the hot spot should be the tip of the arrow;  if
your cursor is a cross, the hot spot should be where the perpendicular
lines intersect.

.PP
.TP 8
.I Clear HotSpot
removes any hot spot that was defined on this bitmap.

.PP
.TP 8
.I Write Output
writes the current bitmap value to the
file specified in the original command line.  If the file already
exists, the original file is first renamed to 
.B filename~
(in the manner of \fIemacs(1)\fP and other text editors).
    
If either the renaming or the writing cause an error (e.g.
``Permission denied'), a dialog window will appear, asking
if you want to write the file \fI/tmp/filename\fP instead.  If you say yes,
all future ``Write Output'' commands will write to \fI/tmp/filename\fP as well.
See below for the format of the output file.

.PP
.TP 8
.I Quit
exits the 
.I bitmap
program.  If you have edited
the bitmap and have not invoked 
.I Write Output,
or you have edited it
since the last time you invoked 
.I Write Output,
a dialog
window will appear, asking if you want to save changes before quitting.
``Yes'' does a ``Write Output'' before exiting;  ``No'' just exits, losing
the edits;  ``Cancel'' means you decided not to quit after all.


.SH FILE FORMAT

\fIBitmap\fP reads and writes files in the following format,
which is suitable for #include'ing in a C program:
.nf
#define \fIname\fP_width 9
#define \fIname\fP_height 13
#define \fIname\fP_x_hot 4
#define \fIname\fP_y_hot 6
static char \fIname\fP_bits[] = {
   0x10, 0x00, 0x38, 0x00, 0x7c, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
   0xff, 0x01, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x7c, 0x00, 0x38, 0x00,
   0x10, 0x00};
.fi

The variables ending with
.I _x_hot
and 
.I _y_hot
are optional; they will be present only if a hot spot has been
defined for this bitmap.  The other variables must be present.

The \fIname\fP portion of the five variables will be
derived from the name of the file that you specified
on the original command line by
  (1) deleting the directory path (all characters up to and including
the last `/', if one is present)
  (2) deleting the extension (the first `.', if one is present,
and all characters beyond it)

For example, invoking 
.I bitmap
with filename
.I /usr/include/bitmaps/cross.bitmap
will produce a file with variable
names 
.I cross_width, cross_height,
and 
.I cross_bits
(and 
.I cross_x_hot
and 
.I cross_y_hot
if a hot spot is defined).

It's easy to define a bitmap or cursor in an X program by simply #include'ing
a bitmap file and referring to its variables.  For instance, to use a cursor
defined in the files
.I this.cursor
and
.I this_mask.cursor,
one simply writes
.sp
.nf
#include "this.cursor"
#include "this_mask.cursor"
Pixmap source = XCreateBitmapFromData (display, drawable, this_bits, this_width, this_height);
Pixmap mask = XCreateBitmapFromData (display, drawable, this_mask_bits,
   this_mask_width, this_mask_height);
Cursor cursor = XCreatePixmapCursor (display, source, mask, foreground, background,
   this_x_hot, this_y_hot);
.sp
.fi
where
.I foreground
and
.I background
are XColor values.

An X program can also read a bitmap file at runtime by using the function
.I XReadBitmapFile.

The bits are in XYBitmap format, with bitmap_unit = bitmap_pad = 8,
and byte_order = bitmap_bit_order = LSBFirst (least significant bit
and byte are leftmost).

For backward compatibility with X10, \fIbitmap\fP can also read in a file
where the "bits" array is declared as "static short foo_bits[]" and
consists of an array of 16-bit hex constants.  This is interpreted
as a XYBitmap with bitmap_unit = bitmap_pad = 16, byte_order =
bitmap_bit_order = LSBFirst.  If you modify the bitmap after reading
in such a file, \fIbitmap\fP will always write the file back out
in standard X11 format.

.SH X DEFAULTS
.PP
The
.I bitmap
program uses the routine 
.I XGetDefault(3X)
to read defaults, so its resource names are all capitalized.
.PP
.TP 8
.B Background
The window's background color.  Bits which are 0 in the bitmap are
displayed in this color.  This option is useful only on color
displays.  The default value is ``white''.
.PP
.TP 8
.B BorderColor
The border color.  This option is useful only on color displays. 
The default value is ``black''.
.PP
.TP 8
.B BorderWidth
The border width.  The default value is 2.
.PP
.TP 8
.B BodyFont
The text font.  The default value is ``variable''.
.PP
.TP 8
.B Foreground
The foreground color.  Bits which are 1 in the bitmap are
displayed in this color.  This option is useful only on color
displays. The default value is ``black''.
.PP
.TP 8
.B Highlight
The highlight color.
.I bitmap
uses this color to show the hot spot and to indicate rectangular areas
that will be affected by the
.I Move Area, Copy Area, Set Area, Clear Area,
and
.I Invert Area
commands.   If a highlight color is not given, then
.I bitmap
will highlight by inverting.  This option is useful only on color displays.
.PP
.TP 8
.B Mouse
The pointer (mouse) cursor's color.  This option is useful only on color displays.
The default value is ``black''.
.PP
.TP 8 
.B Geometry
The size and location of the bitmap window.
.PP
.TP 8
.B Dimensions
The 
.I WIDTHxHEIGHT
to use when creating a new bitmap.


.SH ENVIRONMENT
   DISPLAY - the default host and display number.
.br
   XENVIRONMENT - the name of the defaults file to use.

.SH "SEE ALSO"
X(1),
\fIXlib - C Language X Interface\fP,
particularly the section ``Manipulating Bitmaps''.

.SH DIAGNOSTICS

The following messages may be printed to the standard error output.
Any of these conditions aborts 
.I bitmap
before it can create its window.

  ``bitmap: could not connect to X server on \fIhost\fP:\fIdisplay\fP''

Either the display given on the command line or the DISPLAY
environment variable has an invalid host name or display number, or
the host is down, or the host is unreachable, or the host is not
running an X server, or the host is refusing connections.

  ``bitmap: no file name specified''

You invoked 
.I bitmap
with no command line arguments.  You must give a
file name as the first argument.

  ``bitmap: could not open file \fIfilename\fP for reading -- \fImessage\fP''

The specified file exists but cannot be read, for the reason given in
<message> (e.g., permission denied).

  ``bitmap: invalid dimensions \fIstring\fP''
  ``bitmap: dimensions must be positive''

The second command line argument was not a valid dimension
specification.

  ``bitmap: Bitmap file invalid"

The input file is not in the correct format;  the program gave up when
trying to read the specified data.

The following messages may be printed after \fIbitmap\fP
creates its window:
  
  ``bitmap: Unrecognized variable \fIname\fP in file \fIfilename\fP''

.I bitmap
encountered a variable ending in something other than
.I _x_hot, _y_hot, _width,
or
.I _height
while parsing the input file.  It will ignore this variable and
continue parsing the file.

  ``bitmap: XError: \fImessage\fP''
  ``bitmap: XIOError''

A protocol error occurred.  Something is wrong with either the X server
or the X library which the program was compiled with.  Possibly they are
incompatible.  If the server is not on the local host, maybe the
connection broke.


.SH BUGS
.PP
The old command line arguments aren't consistent with other X programs.
.PP
The foreground, background, and highlight colors will be ignored unless 
new values for all three are specified.
.PP  
If you move the pointer too fast while holding a pointer button down,
some squares may be `missed'.  This is caused by limitations in how
frequently the X server can sample the pointer location.
.PP
There is no way to write to a file other than the one specified on the
command line.
.PP
There is no way to change the size of the bitmap once the program
has started.
.PP
There is no ``undo'' command.
.PP
If you read in an X10-format bitmap, the "Quit" and "Write Output"
commands won't write out a new, X11-format, file unless you've changed
at least one square on the bitmap.  You can work around this by simply
inverting a square and then inverting it back again.
.PP
This program would make a wonderful X toolkit application.
.SH COPYRIGHT
Copyright 1988, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHOR
Ron Newman, MIT Project Athena
