.\"
.\" Copyright ([\d,\s]*) by Hewlett-Packard Company, Ardent Computer, 
.\" 
.\" Permission to use, copy, modify, distribute, and sell this documentation 
.\" for any purpose and without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\" Ardent, and Hewlett-Packard make no representations about the 
.\" suitability for any purpose of the information in this document.  It is 
.\" provided \`\`as is'' without express or implied warranty.
.\" 
.\" $Xorg: XGetDvMo.man,v 1.3 2000/08/17 19:41:56 cpqbld Exp $
.ds xL Programming with Xlib
.TH XGetDeviceMotionEvents 3X11 "Release 6.4" "X Version 11" "X FUNCTIONS"
.SH NAME
XGetDeviceMotionEvents, XDeviceTimeCoord \- get device motion history 
.SH SYNTAX
XDeviceTimeCoord *XGetDeviceMotionEvents\^(\fIdisplay\fP\^, \fIdevice\fP\^,
\fIstart\fP\^, \fIstop\fP\^,
.br
\fInevents_return\fP\^, \fImode_return\fP\^, \fIaxis_count_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      XDevice *\fIdevice\fP\^;
.br
      Time \fIstart\fP\^, \fIstop\fP\^;	
.br
      int *\fInevents_return\fP\^;
.br
      int *\fImode_return\fP\^;
.br
      int *\fIaxis_count_return\fP\^;
.SH ARGUMENTS
.TP 12
.I display
Specifies the connection to the X server.
.TP 12
.I device
Specifies the device whose motion history is to be queried.
.TP 12
.I start
.br
.ns
.TP 12
.I stop
Specify the time interval in which the events are returned from the motion
history buffer.
You can pass a timestamp or \fICurrentTime\fP.
.TP 12
.I nevents_return
Returns the number of events from the motion history buffer.
.TP 12
.I mode_return
Returns the mode of the device (\fIAbsolute\fP or \fIRelative\fP).
.TP 12
.I axis_count_return
Returns the count of axes being reported.
.SH DESCRIPTION
The server may retain the recent history of the device motion
and do so to a finer granularity than is reported by
\fIDeviceMotionNotify\fP
events.
The \fIXGetDeviceMotionEvents\fP request makes this history available.
.LP
The
\fIXGetDeviceMotionEvents\fP
request returns all events in the motion history buffer that fall between the
specified start and stop times, inclusive.
If the start time is later than the stop time or if the start time is in the
future, no events are returned.
If the stop time is in the future, it is equivalent to specifying
\fICurrentTime\fP.
.LP
The \fImode\fP indicates whether the device is reporting absolute positional
data (mode=\fIAbsolute\fP) or relative motion data (mode=\fIRelative\fP).
Some devices allow their mode to be changed via the \fIXSetDeviceMode\fP
request.
These constants are defined in the file XI.h.  The \fIaxis_count\fP
returns the number of axes or valuators being reported by the device.
.LP
\fIXGetDeviceMotionEvents\fP can generate a \fIBadDevice\fP, or \fIBadMatch\fP
error.
.SH STRUCTURES
The
\fIXDeviceTimeCoord\fP
structure contains:
.LP
.nf
typedef struct {
	Time time;
	int *data;
} XDeviceTimeCoord;
.fi
.LP
The time member is set to the time, in milliseconds. 
The data member is a pointer to an array of integers.  
These integers are set to the values of each valuator or
axis reported by the device.  There is one element in the array
per axis of motion reported by the device.  The value of the array elements
depends on the mode of the device.  If the mode is \fIAbsolute\fP, the
values are the raw values generated by the device.  These may be scaled by
client programs using the maximum values that the device can generate.  The
maximum value for each axis of the device is reported in the max_val
field of the \fIXAxisInfo\fP returned by the \fIXListInputDevices\fP 
request.  If the mode is \fIRelative\fP, the data values are the relative
values generated by the device.
.LP
You should use \fIXFreeDeviceMotionEvents\fP to free the data returned by
this request.
.LP
Errors returned by this request: \fIBadDevice\fP, \fIBadMatch\fP.
.SH DIAGNOSTICS
.TP 12
\fIBadDevice\fP
An invalid device was specified.  The specified device does not exist or has 
not been opened by this client via \fIXOpenInputDevice\fP.  This error may
also occur if the specified device is the X keyboard or X pointer device.
.TP 12
\fIBadMatch\fP
This error may occur if an \fIXGetDeviceMotionEvents\fP request is made 
specifying
a device that has no valuators and reports no axes of motion.
.SH "SEE ALSO"
.br
\fI\*(xL\fP
