.TH XvVideoNotify 3X  __vendorversion__
.\" $XFree86: xc/doc/man/Xv/XvVideoNotify.man,v 1.5 2001/01/27 18:20:36 dawes Exp $
.SH Name
XvVideoNotify \- event generated for video processing
.\"
.SH Syntax
.B #include <X11/extensions/Xvlib.h>
.br
.sp 1l
.EX

     typedef union {
       int type;
       XvVideoNotifyEvent xvvideo;
       XvPortNotifyEvent xvport;
       long pad[24];
     } XvEvent;

     typedef struct {
       int type;
       unsigned long serial;
       Bool send_event;
       Display *display;
       Drawable drawable;
       unsigned long reason;
       XvPortID port_id;
       Time time;
     } XvVideoNotifyEvent;

.EE
.\"
.IP \fItype\fR 8
Specifies the type of event: XvVideoNotify(3X).
.IP \fIserial\fR 8
Number of the last request processed by the server.
.IP \fIsend_event\fR 8
True if the event was generated by a SendEvent request.
.IP \fIdisplay\fR 8
A pointer to the display the event was read from.
.IP \fIdrawable\fR 8
The drawable for which the event was generated.
.IP \fIreason\fR 8
The reason the event was generated: \fBXvStarted\fR, \fBXvStopped\fR, 
\fBXvPreempted\fR, \fBXvBusy\fR, \fBXvHardError\fR.
.IP \fIport_id\fR 8
The port processing the video for which the event was generated.
.\"
.SH Description
.\"
XvVideoNotify(3X) events are generated when video
is started, stopped, preempted by another video
request, ignored because the port is grabbed by another client, or interrupted
because of a hard transmission or reception error.
.\"
.SH See Also
XvPutVideo(3X), XvPutStill(3X), XvGetVideo(3X), XvGetStill(3X), 
XvStopVideo(3X), XvSelectVideoNotify(3X)
.\"
