.\" $XFree86: xc/programs/Xserver/hw/xfree86/drivers/savage/savage.man,v 1.7 2003/11/09 20:43:57 dawes Exp $ 
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH SAVAGE __drivermansuffix__ __vendorversion__
.SH NAME
savage \- S3 Savage video driver
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qsavage\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B savage 
is an __xservername__ driver for the S3 Savage family video accelerator chips.  2D, 3D, and Xv acceleration
is supported on all chips except the Savage2000 (2D only).  Dualhead operation is supported on MX, IX, and
SuperSavage chips.  The
.B savage
driver supports PCI and AGP boards with the following chips:
.TP 16
.BI Savage3D
(8a20 and 8a21) (2D, 3D)
.TP 16
.B Savage4
(8a22) (2D, 3D)
.TP 16
.B Savage2000
(9102) (2D only)
.TP 16
.B Savage/MX
(8c10 and 8c11) (2D, 3D, Dualhead)
.TP 16
.B Savage/IX
(8c12 and 8c13) (2D, 3D, Dualhead)
.TP 16
.B SuperSavage/MX
(8c22, 8c24, and 8c26) (2D, 3D, Dualhead)
.TP 16
.B SuperSavage/IX
(8c2a, 8c2b, 8c2c, 8c2d, 8c2e, and 8c2f) (2D, 3D, Dualhead)
.TP 16
.B ProSavage PM133
(8a25) (2D, 3D)
.TP 16
.B ProSavage KM133
(8a26) (2D, 3D)
.TP 16
.B Twister (ProSavage PN133)
(8d01) (2D, 3D)
.TP 16
.B TwisterK (ProSavage KN133)
(8d02) (2D, 3D)
.TP 16
.B ProSavage DDR
(8d03) (2D, 3D)
.TP 16
.B ProSavage DDR-K
(8d04) (2D, 3D)
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to this
driver.
.PP
The following driver
.B Options
are supported:
.TP
.BI "Option \*qHWCursor\*q \*q" boolean \*q
.TP
.BI "Option \*qSWCursor\*q \*q" boolean \*q
These two options interact to specify hardware or software cursor.  If the
SWCursor option is specified, any HWCursor setting is ignored.  Thus, either
\*qHWCursor off\*q or \*qSWCursor on\*q will force the use of the software 
cursor.  On Savage/MX and Savage/IX chips which are connected to LCDs, a
software cursor will be forced, because the Savage hardware cursor does not 
correctly track the automatic panel expansion feature.
Default: hardware cursor.
.TP
.BI "Option \*qNoAccel\*q \*q" boolean \*q
Disable or enable acceleration.  Default: acceleration is enabled.
.TP
.BI "Option \*qRotate\*q \*qCW\*q"
.TP
.BI "Option \*qRotate\*q \*qCCW\*q"
Rotate the desktop 90 degrees clockwise or counterclockwise.  This option 
forces the ShadowFB option on, and disables acceleration.
Default: no rotation.
.TP
.BI "Option \*qShadowFB\*q \*q" boolean \*q
Enable or disable use of the shadow framebuffer layer.  This option
disables acceleration.  Default: off.
.TP
.BI "Option \*qLCDClock\*q \*q" frequency \*q
Override the maximum dot clock.  Some LCD panels produce incorrect results if
they are driven at too fast of a frequency.  If UseBIOS is on, the BIOS will
usually restrict the clock to the correct range.  If not, it might be 
necessary to override it here.  The
.B frequency
parameter may be specified as an integer in Hz (135750000), or with
standard suffixes like "k", "kHz", "M", or "MHz" (as in 135.75MHz).
.TP
.BI "Option \*qCrtOnly\*q \*q" boolean \*q  
This option disables output to the LCD and enables output to the CRT port only.  
It is useful on laptops if you only want to use the CRT port or to force the CRT 
output only on desktop cards that use mobile chips. Default: auto-detect active 
outputs
.TP
.BI "Option \*qUseBIOS\*q \*q" boolean \*q
Enable or disable use of the video BIOS to change modes.  Ordinarily, the 
.B savage 
driver tries to use the video BIOS to do mode switches.  This generally 
produces the best results with the mobile chips (/MX and /IX), since the BIOS
knows how to handle the critical but unusual timing requirements of the 
various LCD panels supported by the chip.  To do this, the driver searches
through the BIOS mode list, looking for the mode which most closely matches
the __xconfigfile__ mode line.  Some purists find this scheme objectionable.  If 
you would rather have the
.B savage
driver use your mode line timing exactly, turn off the UseBios option.
.B Note:
Use of the BIOS is required for dualhead operation. 
Default: on (use the BIOS).
.TP
.BI "Option \*qShadowStatus\*q \*q" boolean \*q
Enables the use of a shadow status register.  There is a chip bug in the 
Savage graphics engine that can cause a bus lock when reading the engine
status register under heavy load, such as when scrolling text or dragging
windows.  The bug affects about 4% of all Savage users without DRI and
a large fraction of users with DRI.  If your system
hangs regularly while scrolling text or dragging windows, try turning this
option on.  This uses an alternate method of reading the engine status
which is slightly more expensive, but avoids the problem.  When DRI is
enabled then the default is \*qon\*q (use shadow status), otherwise
the default is \*qoff\*q (use normal status register).
.TP
.BI "Option \*qDisableCOB\*q \*q" boolean \*q
Disables the COB (Command Overflow Buffer) on savage4 and newer chips.  
There is supposedly a HW cache coherency problem on certain savage4 and 
newer chips that renders the COB useless. If you are having problems with 
2D acceleration you can disable the COB, however you will lose some 
performance.  3D acceleration requires the COB to work.  This option only
applies to Savage4 and newer chips.  Default: \*qoff\*q (use COB).
.TP
.BI "Option \*qBCIforXv\*q \*q" boolean \*q  
Use the BCI to copy and reformat Xv pixel data.  Using the BCI for Xv causes 
graphics artifacts on some chips.  This option only applies to Savage4 and 
prosavage/twister chips.  Default: on for prosavage and twister (use BCI for Xv); 
off for savage4 (do not use the BCI for Xv).
.TP 
.BI "Option \*qAGPMode\*q \*q" integer \*q
Set AGP data transfer rate.
(used only when DRI is enabled)
.br
1      \-\- x1 (default)
.br
2      \-\- x2
.br
4      \-\- x4
.br
others \-\- invalid
.TP
.BI "Option \*qAGPSize\*q \*q" integer \*q
The amount of AGP memory that will allocated for DMA and textures in
MB. Valid sizes are 4, 8, 16, 32, 64, 128 and 256. The default is
16MB.
.TP
.BI "Option \*qDmaMode\*q \*q" string \*q
This option influences in which way DMA (direct memory access) is used
by the kernel and 3D drivers.
.br
Any      \-\- Try command DMA first, then vertex DMA (default)
.br
Command  \-\- Only use command DMA or don't use DMA at all
.br
Vertex   \-\- Only use vertex DMA or don't use DMA at all
.br
None     \-\- Disable DMA
.br
Command and vertex DMA cannot be enabled at the same time. Which DMA
mode is actually used in the end also depends on the DRM version (only
>= 2.4.0 supports command DMA) and the hardware (Savage3D/MX/IX
doesn't support command DMA).
.TP
.BI "Option \*qDmaType\*q \*q" string \*q
The type of memory that will be used by the 3D driver for DMA (direct
memory access).
.br
PCI    \-\- PCI memory (default on PCI cards)
.br
AGP    \-\- AGP memory (default on AGP cards)
.br
\*qAGP\*q only works if you have an AGP card.
.TP
.BI "Option \*qBusType\*q \*q" string \*q
The bus type that will be used to access the graphics card.
.br
PCI    \-\- PCI bus (default on PCI cards)
.br
AGP    \-\- AGP bus (default on AGP cards)
.br
\*qAGP\*q only works if you have an AGP card. If you choose \*qPCI\*q
on an AGP card the AGP bus speed is not set and no AGP aperture is
allocated. This implies
.BI DmaType
\*qPCI\*q.
.SH FILES
savage_drv.o
.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), xorgconfig(__appmansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__)
.SH AUTHORS
Authors include Tim Roberts (timr@probo.com) and Ani Joshi (ajoshi@unixbox.com)
for this version, and Tim Roberts and S. Marineau for the original driver from 
which this was derived.
