.LC 5/23/94 @(#)dox.man	9.1
.. 1994    Arthur David Olson
.. 
.. The X Consortium, and any party obtaining a copy of these files from
.. the X Consortium, directly or indirectly, is granted, free of charge, a
.. full and unrestricted irrevocable, world-wide, paid up, royalty-free,
.. nonexclusive right and license to deal in this software and
.. documentation files (the "Software"), including without limitation the
.. rights to use, copy, modify, merge, publish, distribute, sublicense,
.. and/or sell copies of the Software, and to permit persons who receive
.. copies from any such party to do so.  This license includes without
.. limitation a license to do the foregoing actions under any patents of
.. the party supplying this software to the X Consortium.
.TH DOX 1E \*(eH
.SH NAME
dox \- call Xlib function
.SH SYNOPSIS
.B dox
[
.B \-int 
] [
.B \-frame
] [
.B \-verbose
] [
.B \-display
displayname
] [ functionname [ argument ... ] ]
.= dox
.SH DESCRIPTION
.I Dox
calls the function whose name is given by
.I functionname
with the given
.IR argument s
(plus a leading
.I display
argument, which is automatically provided).
If the command line is
.IR functionname -free,
functions and arguments are read line-by-line from the standard input.
.PP
The leading `X' may be omitted from
function names;
alphabetic case is ignored in
function names.
Omit arguments that are pointers to
.BR XEvent s;
the contents of the returned
.B XEvent
is printed.
.PP
These options are available:
.TP
.BI "\-display " displayname
Use the given display.
.TP
.BI "\-int "
Always use decimal values in reports.
.TP
.BI "\-frame "
Allow window manager frames to be chosen when pointing and clicking.
.PP
When a window id is required,
.B root
may be used for the root window;
when a window id or Drawable or generic XID is required,
.B +
may be used to identify a window by pointing to it and clicking.
.PP
Use the command
.br
.ti +.5i
.B dox =
.br
to get a list of available functions (and arguments).
.SH EXAMPLE
The pauper's
.IR xkill :
.nf
.in +.5i
#! /bin/sh

: '@(#)xshkill.sh	8.1'

flags=
id=+

while :
do
	case $1 in
		--)		shift ; break ;;
		-display)	shift
				case $# in
					0)	set x ; break ;;
					*)	flags="$flags -display $1"
						shift ;;
				esac ;;
		-frame)		flags="$flags -frame" ; shift ;;
		-id)		shift
				case $# in
					0)	set x ; break ;;
					*)	id="$1" ; shift ;;
				esac ;;
		*)		break ;;
	esac
done

case $# in
	0)	;;
	*)	O=`basename "$0"`
		echo "$O: usage is $O" \e
			"[-display displayname]" \e
			"[-id resource]" \e
			"[-frame]" \e
			"# 8.1" >&2
		exit 1 ;;
esac

exec dox $flags killclient "$id"
.in -.5i
.fi
.. .SH "SEE ALSO"
.. awkx(1),
.. doc(1),
.. doxaw(1),
.. doxmu(1),
.. doxt(1)
