.\" emu.man,v 1.2 1994/06/02 20:05:00 me Exp
.\" 
.\" This file is part of the Emu system.
.\"
.\" Copyright 1990 by PCS Computer Systeme, GmbH. Munich, West Germany.
.\" 
.\" Copyright 1994 by Jordan K. Hubbard and Michael W. Elbel
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL PCS, THE AUTHORS, OR THEIR HOUSEPETS BE LIABLE FOR
.\" ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
.\" TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
.\" SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. SO DON'T SUE US.
.\" THANK YOU.
.\"
.\" emu.man,v
.\" Revision 1.2  1994/06/02  20:05:00  me
.\" Finally corrected and upgraded to reflect the features that are
.\" actually there.
.\" Added new copyright message
.\"
.\"
.TH EMU 1 "Release 6" "X Version 11"
.SH NAME
emu \- X Window System based extensible terminal emulator
.SH SYNOPSIS
.B emu
[ -option ...] [-\fItoolkitoption\fP ...]
.SH DESCRIPTION
The \fIemu\fP program is a terminal emulator for the X Window System.
It provides DEC VT200 as its basis emulation,
.br
including features like:
.PP
.in +0.5i
full support of DEC's international character set,

compose character processing,

blinking cursor and blinking text,

color

double height / double width characters.
.PP
Features not (yet) supported are:
.PP
.in +0.5i

down-line loadable character sets,

selective erasing,

printing.
.SH OPTIONS
The \fIemu\fP terminal emulator 
accepts all of the standard X Toolkit command line options as well
as the following:

.TP 8
.BI \-sl " nlines "
How many scroll lines to save off the top of the screen.
.TP 8
.BI \-rs " nbytes "
Sets the term widget's read size.
.TP 8
.BI \-e " command "
The command to execute on startup instead of the shell specified in
the environment variable \fBSHELL\fP.
.TP 8
.BI \-term " termtype "
The terminal type to emulate
.TP 8
.BI \-fb " fontname "
The font to be used when displaying bold text. This font must
have the same size as the normal font. If the bold font is not
specified, emu tries to derive a bold font from the normal font.
.TP 8
.BI \-t " title "
Set window title string to be \fItitle\fP.
.TP 8
.BI \-n " icon_name "
Set icon name for window to be \fIicon_name\fP.
.TP 8
.BI \-name " string "
Set application name, icon and title strings to be \fIstring\fP.
.TP 8
.BI \-/+rv
Turn on (off) reverse video.
.TP 8
.BI \-help
Display a message describing emu's options.
.TP 8
.BI \-/+mbar
Selects (unselects) menu bar option.
.TP 8
.BI \-/+sbar
Adds (removes) a vertical scrollbar.
.TP 8
.BI \-/+C
Turns on (off) console mode. This is not supported on all systems.
On systems that support it, the window will receive console output.
You must have read and write permission for the console device.
.TP 8
.BI \-/+ut
Add (don't add) utmp entry for session.
.TP 8
.BI \-/+ls
Turn on (off) login shell handling.
.TP 8
.BI \-ul " ulwidth "
The width of the line used to understroke characters.
.TP 8
.BI \-cfg " color "
The text cursor foreground color.
.TP 8
.BI \-cbg " color "
The text cursor background color.
.TP 8
.BI \-cbival " interval "
The cursor blink interval in milliseconds.
.TP 8
.BI \-cw " width "
The cursor width in pixels. 
If 0 is specified, the cursor will have the
width of the normal font.
.TP 8
.BI \-ch " height "
The cursor height in pixels.
If 0 is specified, the cursor will have the
height of the normal font.
.TP 8
.BI \-/+cbl
Turn off (on) cursor blink.
.TP 8
.BI \-/+bfocus
Turn off (on) blinking cursor without focus.
.TP 8
.BI \-mclick " interval "
The multi-click interval in milliseconds.
.TP 8
.BI \-tbival " interval "
The text blink interval in milliseconds.
.TP 8
.BI \-pcol " color "
The pointer color.
.TP 8
.BI \-pcur " cursor "
The pointer cursor to use.
.TP 8
.BI \-/+wrap
Enable (disable) text wrap.
.TP 8
.BI \-/+insert
Disable (enable) insert mode.
.TP 8
.BI \-bell " volume "
Set bell volume as a percentage.
.TP 8
.BI \-tab " n "
Set tabstops to be every <n> characters.


.SH "TERMINAL TYPES"
Emu supports three terminal types:
.TP 8
.B
vt220:
This emulation supplies most of the required functionality to
act as a vt220 terminal, including ANSI color sequences and
compose processing. It will work with all vt200 compatible
termcap and terminfo desriptions such as \fIno-220\fP and 
\fIwy-95\fP.
.br
Since \fBvt220\fP supports a superset of the capabilities of an ANSII terminal,
terminfo descriptions like \fIxterm\fP, \fIansii\fP or \fIvt100c\fP
also work.

.TP 8
.B
xterm: 
This is basically a subset of the vt220 parser (xterm + some extra 
features) which will work with the standard xterm termcap and
terminfo descriptions. \fIxterm\fP is the standard terminal type
for emu.

.TP 8
.B
emu:
This is an artificial terminal engineered to be as efficient to
parse as possible, although it understands some commonly used ansi and
xterm escape sequences such as those for text color setting and changing the
window and icon title.  This is also the only parser that's available
as a "hard parser" i.e. decoded by C-code instead of through a textual
description. Use the \fIemu\fP termtype if you're interested in a 
"lean-n-mean" 
terminal emulation that doesn't need to emulate anything existing. Terminfo 
and termcap entries are supplied.

.LP
On all operating systems that support the use of the \fBTERMCAP\fP
environment variable it will be set accordingly.

.SH "CUTTING AND PASTING"
Once the \fIemu\fP window is created, text can be cut and pasted
using the X Toolkit's selection mechanism.

Pressing the \fBleft\fP mouse button starts the selection. Moving the mouse 
while the button stays
depressed expands the selected area. Double clicking selects by words,
triple clicking selects by lines. Multiple click is determined by the
time from button up to button down, so you can change the selection unit in
the middle of a selection. In fact, both the selection mechanism and this
paragraph are closely modelled after the original \fIxterm\fP.

The \fBmiddle\fP button pastes the text from the PRIMARY selection, 
if any, otherwise fro the cut buffer.

The \fBright\fP button extends the current selection.

.SH MENUS
.PP
.I Emu
has three menus configured with the default resources. They are:
.TP 8
.B
Main Options:
General Operations like redrawing the window, setting tty modes and sending
signals to the process running under emu.
.TP 8
.B Term Options:
To set parameters of the emulation like line wrap, cursor blink, reverse mode
and so on as well as adding/removing the scroll and menu bar.
.TP 8
.B Fonts:
To change the fonts in use.
.PP
The menus can be invoked in two different ways:
.in +0.5i
By using the \fImenu bar\fP and activating the respective button in the bar

or by holding down the
.B Control Key
and pressing the:

.in +0.5i
.B left mouse button
for the \fIMain Options\fP menu,

.B middle mouse button
\fIfor the Term Options\fP menu,

.B right mouse button
\fIfor the Fonts\fP menu.
.SH ENVIRONMENT
.I emu
sets the environment variables 
.B TERM,
.B LINES
and
.B COLUMNS
properly for the size of the window created.
.br
If the operating system supports the use of the \fBTERMCAP\fP environment
variable, this will also be set and hold a termcap description for the
current emulation.

Note however, that upon resizing the window
.B LINES
and 
.B COLUMNS 
should be updated by the shell. Currently, not all shells support
this action (csh and ksh do not, bash does).

.SH "COMPOSE KEY"
For the \fBvt220\fP emulation,
the \fICompose Key\fP feature allows the generation of characters that
don't have a keytop on the keyboard.  In order for the \fICompose Key\fP
feature to work, there must be a key on the keyboard that produces the
key symbol
.B XK_Multi_key.
.br
However, most servers' keyboard mappings don't support a key which
generates this symbol.
See /fIxmodmap/fP for more information on this subject.

.SH RESOURCES
The program understands all of the core X Toolkit resource names and
classes as well as:

.TP 8
.B
columns:
The width of the canvas in terminal lines. The default is 80.

.TP 8
.B
font:
The font to use for normal text. The default is \fIfixed\fP.

.TP 8
.B
boldFont:
The font to use for bold text. If not set, it will be automatically derived
from \fIfont\fP}.

.TP 8
.B
dWideFont:
(Only present if emu is compiled with double sized fonts enabled)
The font to use for double width, single height, normal text.
If not set, it will be automatically derived from \fIfont\fP.

.TP 8
.B
dWHighFont:
(Only present if emu is compiled with double sized fonts enabled)
The font to use for double width, double height, normal text.
If not set, it will be automatically derived from \fIfont\fP.

.TP 8
.B
dWideBFont:
(Only present if emu is compiled with double sized fonts enabled)
The font to use for double width, single height, bold text.
If not set, it will be automatically derived from \fIfont\fP.

.TP 8
.B
dWHighBFont:
(Only present if emu is compiled with double sized fonts enabled)
The font to use for double width, double height bold text.
If not set, it will be automatically derived from \fIfont\fP.

.TP 8
.B
underlineWidth:
The thickness of the understrike line. The default is 1 pixel.

.TP 8
.B
foreground:
The text color. The default is ``black''}).

.TP 8
.B
background:
The window's background color. The default is ``white'').

.TP 8
.B
cursorFg:
The text cursor foreground color. The default is ``black''.

.TP 8
.B
cursorBg:
The text cursor background color. The default is @code{XtDefaultBackground}.

.TP 8
.B
cursorHeight:
The text cursor height in pixels. The maximum is the height of the font. 
To make the cursor as high as the cursor, specify 0. The default is 0.

.TP 8
.B
cursorWidth:
The cursor width in pixels. The maximum is the width of the font. 
To make the cursor as wide as the cursor, specify 0. The default is 0.

.TP 8
.B
cursorBlinking:
A boolean flag to determine whether the cursor should blink. 
The default is @code{True}.

.TP 8
.B
blinkInterval:
To specify how fast the cursor blinks, in milliseconds. 
The default is 500 msec.

.TP 8
.B
blinkWOFocus:
A boolean flag to determine whether the cursor should continue blinking 
when the canvas looses the input focus. The default is @code{False}.

.TP 8
.B
textBlinkInterval:
To specify how fast the blinking text blinks, in milliseconds. 
The default is 500 msec.

.TP 8
.B
wrapAround:
A boolean flag to determine whether text should wrap around the end of 
the line. The default is ``True''.

.TP 8
.B
insertMode:
A boolean flag to determine whether inserted Text should be inserted 
or overwrite the existing characters. The default is ``False''.

.TP 8
.B
bellVolume:
The volume of the bell in %. The default is 100.

.TP 8
.B
defTabWidth:
The default tabulator width to be used. The default is 8.

.TP 8
.B
termType:
The terminal type under which the canvas looks up its resources.
There is no default.

.TP 8
.B
pointerShape:
The font glyph of the cursor font to use for the mouse cursor
inside the canvas window. The default is ``xterm''

.TP 8
.B
saveLines:
The size of the \fIsave area\fP in lines. The default is 64 or \fIlines\fP,
whichever is larger.

.TP 8
.B
multiClickTime:
The maximum time interval between two subsequent mouse clicks that should be 
treated as belonging to a multi click. The default is 300 msec.

.TP 8
.B
jumpScrollLines:
The maximum number of lines that should be scrolled at a time if jump 
scrolling is enabled. The default is 10.

.SH "SEE ALSO"
resize(1), X(1), pty(4), tty(4)
.SH BUGS
.PP
Although we have tried our best to fix at least the ones we knew of,
there are certainly still more than enough left.
.SH COPYRIGHT
Copyright 1990, PCS Computer Systeme GmbH.
.br
Copyright 1994, Michael W. Elbel and Jordan K. Hubbard.
.br
See the source code or \fIemu.texinfo\fP
for a full statement of rights and permissions.
.SH AUTHORS
.sp
Michael Elbel, Jordan Hubbard, Terry Jones, Thomas Bagli.
.sp
For help in generally cleaning up the code and the reworking of
the vt220 emulation, that now actually is pretty close: Steve Crooks.
.sp
And for inspiration and guidance, all those far-too-many-people
who developed \fIxterm\fP.
