.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XStoreBytes 3X11 "Release 6" "X Version 11" "XLIB FUNCTIONS"
.SH NAME
XStoreBytes, XStoreBuffer, XFetchBytes, XFetchBuffer, XRotateBuffers \- manipulate cut and paste buffers
.SH SYNTAX
XStoreBytes\^(\^\fIdisplay\fP, \fIbytes\fP\^, \fInbytes\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      char *\fIbytes\fP\^;
.br
      int \^\fInbytes\fP\^;
.br
.LP
XStoreBuffer\^(\^\fIdisplay\fP, \fIbytes\fP\^, \fInbytes\fP\^, \fIbuffer\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      char *\fIbytes\fP\^;
.br
      int \^\fInbytes\fP\^;
.br
      int \fIbuffer\fP\^;
.LP
char *XFetchBytes\^(\^\fIdisplay\fP, \fInbytes_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      int *\fInbytes_return\fP\^;
.LP
char *XFetchBuffer\^(\^\fIdisplay\fP, \fInbytes_return\fP\^, \fIbuffer\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      int *\fInbytes_return\fP\^;
.br
      int \fIbuffer\fP\^;
.LP
XRotateBuffers\^(\^\fIdisplay\fP, \fIrotate\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      int \fIrotate\fP\^;
.SH ARGUMENTS
.ds Fn in which you want to store the bytes \
or from which you want the stored data returned
.IP \fIbuffer\fP 1i
Specifies the buffer \*(Fn.
.IP \fIbytes\fP 1i
Specifies the bytes, which are not necessarily ASCII or null-terminated.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fInbytes\fP 1i
Specifies the number of bytes to be stored.
.IP \fInbytes_return\fP 1i
Returns the number of bytes in the buffer.
.IP \fIrotate\fP 1i
Specifies how much to rotate the cut buffers.
.SH DESCRIPTION
The data can have embedded null characters
and need not be null-terminated.
The cut buffer's contents can be retrieved later by
any client calling
.ZN XFetchBytes .
.LP
.ZN XStoreBytes
can generate a
.ZN BadAlloc
error.
.LP
If an invalid buffer is specified, the call has no effect.
The data can have embedded null characters
and need not be null-terminated.
.LP
.ZN XStoreBuffer
can generate a
.ZN BadAlloc
error.
.LP
The
.ZN XFetchBytes
function
returns the number of bytes in the nbytes_return argument,
if the buffer contains data.
Otherwise, the function
returns NULL and sets nbytes to 0.
The appropriate amount of storage is allocated and the pointer returned.
The client must free this storage when finished with it by calling
.ZN XFree .
.LP
The
.ZN XFetchBuffer
function returns zero to the nbytes_return argument 
if there is no data in the buffer or if an invalid
buffer is specified.
.LP
.ZN XFetchBuffer
can generate a
.ZN BadValue 
error.
.LP
The
.ZN XRotateBuffers
function rotates the cut
buffers, such that buffer 0 becomes buffer n, 
buffer 1 becomes n + 1 mod 8, and so on.
This cut buffer numbering is global to the display.
Note that
.ZN XRotateBuffers
generates
.ZN BadMatch
errors if any of the eight buffers have not been created.
.LP
.ZN XRotateBuffers
can generate a
.ZN BadMatch
error.
.SH DIAGNOSTICS
.TP 1i
.ZN BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.ZN BadAtom
A value for an Atom argument does not name a defined Atom.
.TP 1i
.ZN BadMatch
Some argument or pair of arguments has the correct type and range but fails
to match in some other way required by the request.
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
XFree(3X11)
.br
\fI\*(xL\fP
