.TH PCLCOMP 1
.SH NAME
pclcomp \- Compress PCL graphics files.
.SH SYNOPSIS
.B pclcomp
[
.B "-0123drsvxz"
]
[
.B "-n"
.I num
]
[
.I infile
[
.I outfile
]]
.br
.SH DESCRIPTION
.PP
.B Pclcomp
compresses (or decompresses) HP-PCL (Printer Control Language) graphics data.
The supported compression modes are 0 (uncompressed), 1, 2 and 3.
.B Pclcomp
will read files using any of the modes 0 through 3, and will output using the
modes which will give the best compression.  This compressed version of
the file may be sent directly to a PCL compatible printer, thus reducing
I/O bandwidth.  Pictures may also be saved in compressed form, reducing
disk usage.
In addition, PCL "imaging" files for the PaintJet XL are also supported.
.PP
The options to
.B pclcomp
control the compression modes.  By default,
.B pclcomp
will use modes 0, 2 and 3, but the user may restrict which output
modes it uses by specifying them on the command line with the
.B -0,
.B -1,
.B -2
and
.B -3
options.  To decompress a file, simply specify
.B -0
as the only mode to use for output.  Mode 0 (
.B -0
) should always be allowed since modes 1, 2 and 3 cannot be guaranteed to
be better than mode 0 for all types of pictures.
.PP
The
.B -z
option disables the zero "strip" feature.  Since most printers do 
zero "filling",
.B pclcomp,
by default, "strips" the trailing zeros of each row (or plane) of data.
Some printers or programs may require that zero "stripping" be disabled.
.PP
By default,
.B pclcomp
expects the input raster width to be 2400 pixels (8" at 300 dpi), and if it is
different (e.g. PaintJet), then the raster width should be specified by
the Source Raster Width escape sequence
.I (<esc>*r#S).
However, many applications do not set the width and assume a default, therefore,
the user may use the 
.B -n
option to
.B pclcomp
to specify a new default raster width.  For PaintJet (8" at 180 dpi), the
number should be 1440.  If the PCL file contains the Source Raster Width
escape sequence, it will override this default.  If
.B pclcomp
thinks that more data is coming in than the specified width, it will
generate a warning, and continue processing (and perhaps truncating) data.
.PP
The
.B -x
option will cause
.B pclcomp
to remove any horizontal offset sequences from the data.  Only use this
option if white is defined to be zero (as with LaserJets).  This will
shrink the data more if modes 2 or 3 are used.
.PP
The
.B -r
option causes
.B pclcomp
to append a
reset sequence
.I "(<esc>E)"
to the end of the job.
.PP
Use the
.B "-d"
option to
.B pclcomp
if the output is to be sent to a DeskJet printer.
.PP
Some applications erroneously send
.I "<esc>*rB"
and
.I "<esc>*rA"
sequences between every row of graphics data.  The 
.B -s
option to
.B pclcomp
will "strip" all 
.I "<esc>*rB"
sequences, and all
.I "<esc>*rA"
sequences after the first occurrence of this sequence.  
In addition, text and control characters residing between
.I "<esc>*rA"
and
.I "<esc>*rB"
sequences will be discarded.
While this will work
well
for many jobs, it may have problems on multi-page or complex jobs.
.PP
The
.B -v
option simply gives statistics to
.I stderr
about which compression modes were used.
.SH EXAMPLES
.nf
To compress a PCL file for LaserJet III, use:
	pclcomp infile outfile

To compress a PCL file for the PaintJet (A size page at 180 dpi), use:
	pclcomp -01 -n 1440 infile outfile

To compress a PCL file for DeskJet, use:
	pclcomp -d012 infile outfile

To fully decompress a PCL file, use:
	pclcomp -0z < infile > outfile
.fi
.SH WARNINGS
.PP
The 
.B -z
option can cause the output to be larger than the input.
.PP
The 
.B -s
option is useful, but it can cause erroneous output.
.PP
The
.B -x
option can cause black areas on the left side of the picture on color
printers.
.SH AUTHOR
Tony Parkhurst, Hewlett-Packard, San Diego Division  (tony@sdd.hp.com)
