.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XTextExtents __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XTextExtents, XTextExtents16, XQueryTextExtents, XQueryTextExtents16 \- compute or query text extents
.SH SYNTAX
.HP
int XTextExtents\^(\^XFontStruct *\fIfont_struct\fP\^, _Xconst char *\fIstring\fP\^,
int \fInchars\fP\^, int *\fIdirection_return\fP\^, int
*\fIfont_ascent_return\fP, int *\fIfont_descent_return\fP\^, XCharStruct
*\fIoverall_return\fP\^);
.HP
int XTextExtents16\^(\^XFontStruct *\fIfont_struct\fP\^, _Xconst XChar2b
*\fIstring\fP\^, int \fInchars\fP\^, int *\fIdirection_return\fP\^, int
*\fIfont_ascent_return\fP, int *\fIfont_descent_return\fP\^, XCharStruct
*\fIoverall_return\fP\^);
.HP
int XQueryTextExtents\^(\^Display *\fIdisplay\fP\^, XID \fIfont_ID\fP\^, _Xconst char
*\fIstring\fP\^, int \fInchars\fP\^, int *\fIdirection_return\fP\^, int
*\fIfont_ascent_return\fP, int *\fIfont_descent_return\fP\^, XCharStruct
*\fIoverall_return\fP\^);
.HP
int XQueryTextExtents16\^(\^Display *\fIdisplay\fP\^, XID \fIfont_ID\fP\^,
_Xconst XChar2b *\fIstring\fP\^, int \fInchars\fP\^, int *\fIdirection_return\fP\^,
int *\fIfont_ascent_return\fP, int *\fIfont_descent_return\fP\^, XCharStruct
*\fIoverall_return\fP\^);
.SH ARGUMENTS
.IP \fIdirection_return\fP 1i
Returns the value of the direction hint
.Pn ( FontLeftToRight
or
.BR FontRightToLeft ).
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIfont_ID\fP 1i
Specifies either the font ID or the
.B GContext
ID that contains the font.
.IP \fIfont_ascent_return\fP 1i
Returns the font ascent.
.IP \fIfont_descent_return\fP 1i
Returns the font descent.
.IP \fIfont_struct\fP 1i
Specifies the
.B XFontStruct
structure.
.IP \fInchars\fP 1i
Specifies the number of characters in the character string.
.IP \fIstring\fP 1i
Specifies the character string.
.IP \fIoverall_return\fP 1i
Returns the overall size in the specified
.B XCharStruct
structure.
.SH DESCRIPTION
The
.B XTextExtents
and
.B XTextExtents16
functions
perform the size computation locally and, thereby,
avoid the round-trip overhead of
.B XQueryTextExtents
and
.BR XQueryTextExtents16 .
Both functions return an
.B XCharStruct
structure, whose members are set to the values as follows.
.LP
The ascent member is set to the maximum of the ascent metrics of all
characters in the string.
The descent member is set to the maximum of the descent metrics.
The width member is set to the sum of the character-width metrics of all
characters in the string.
For each character in the string,
let W be the sum of the character-width metrics of all characters preceding
it in the string.
Let L be the left-side-bearing metric of the character plus W.
Let R be the right-side-bearing metric of the character plus W.
The lbearing member is set to the minimum L of all characters in the string.
The rbearing member is set to the maximum R.
.LP
For fonts defined with linear indexing rather than 2-byte matrix indexing,
each
.B XChar2b
structure is interpreted as a 16-bit number with byte1 as the
most significant byte.
If the font has no defined default character,
undefined characters in the string are taken to have all zero metrics.
.LP
The
.B XQueryTextExtents
and
.B XQueryTextExtents16
functions return the bounding box of the specified 8-bit and 16-bit
character string in the specified font or the font contained in the
specified GC.
These functions query the X server and, therefore, suffer the round-trip
overhead that is avoided by
.B XTextExtents
and
.BR XTextExtents16 .
Both functions return a
.B XCharStruct
structure, whose members are set to the values as follows.
.LP
The ascent member is set to the maximum of the ascent metrics
of all characters in the string.
The descent member is set to the maximum of the descent metrics.
The width member is set to the sum of the character-width metrics
of all characters in the string.
For each character in the string,
let W be the sum of the character-width metrics of all characters preceding
it in the string.
Let L be the left-side-bearing metric of the character plus W.
Let R be the right-side-bearing metric of the character plus W.
The lbearing member is set to the minimum L of all characters in the string.
The rbearing member is set to the maximum R.
.LP
For fonts defined with linear indexing rather than 2-byte matrix indexing,
each
.B XChar2b
structure is interpreted as a 16-bit number with byte1 as the
most significant byte.
If the font has no defined default character,
undefined characters in the string are taken to have all zero metrics.
.LP
Characters with all zero metrics are ignored.
If the font has no defined default_char,
the undefined characters in the string are also ignored.
.LP
.B XQueryTextExtents
and
.B XQueryTextExtents16
can generate
.B BadFont
and
.B BadGC
errors.
.SH DIAGNOSTICS
.TP 1i
.B BadFont
A value for a Font or GContext argument does not name a defined Font.
.TP 1i
.B BadGC
A value for a GContext argument does not name a defined GContext.
.SH "SEE ALSO"
XLoadFont(__libmansuffix__),
XTextWidth(__libmansuffix__)
.br
\fI\*(xL\fP
