'\" t
.\"     Title: xselectextensionevent
.\"    Author: [FIXME: author] [see http://docbook.sf.net/el/author]
.\" Generator: DocBook XSL Stylesheets v1.75.2 <http://docbook.sf.net/>
.\"      Date: 08/04/2010
.\"    Manual: [FIXME: manual]
.\"    Source: [FIXME: source]
.\"  Language: English
.\"
.TH "XSELECTEXTENSIONEVEN" "libmansuffix" "08/04/2010" "[FIXME: source]" "[FIXME: manual]"
.\" -----------------------------------------------------------------
.\" * set default formatting
.\" -----------------------------------------------------------------
.\" disable hyphenation
.nh
.\" disable justification (adjust text to left margin only)
.ad l
.\" -----------------------------------------------------------------
.\" * MAIN CONTENT STARTS HERE *
.\" -----------------------------------------------------------------
.SH "NAME"
XSelectExtensionEvent, XGetSelectedExtensionEvents \- select extension events, get the list of currently selected extension events
.SH "SYNOPSIS"
.sp
.nf
#include <X11/extensions/XInput\&.h>
.fi
.sp
.nf
XSelectExtensionEvent( Display *display,
                       Window w,
                       XEventClass *event_list,
                       int event_count);
.fi
.sp
.nf
XGetSelectedExtensionEvents( Display *display,
                             Window w,
                             int *this_client_event_count_return,
                             XEventClass **this_client_event_list_return,
                             int *all_clients_event_count_return,
                             XEventClass **all_clients_event_list_return);
.fi
.sp
.nf
display
       Specifies the connection to the X server\&.
.fi
.sp
.nf
w
       Specifies the window whose events you are interested in\&.
.fi
.sp
.nf
event_list
       Specifies the list of event classes that describe the
       events you are interested in\&.
.fi
.sp
.nf
event_count
       Specifies the count of event classes in the event list\&.
.fi
.sp
.nf
this_client_event_count_return
       Returns the count of event classes selected by this
       client\&.
.fi
.sp
.nf
this_client_event_list_return
       Returns a pointer to the list of event classes selected
       by this client\&.
.fi
.sp
.nf
all_clients_event_count_return
       Returns the count of event classes selected by all
       clients\&.
.fi
.sp
.nf
all_clients_event_list_return
       Returns a pointer to the list of event classes selected
       by all clients\&.
.fi
.SH "DESCRIPTION"
.sp
.if n \{\
.RS 4
.\}
.nf
The XSelectExtensionEvent request causes the X server to report
the events associated with the specified list of event classes\&.
Initially, X will not report any of these events\&. Events are
reported relative to a window\&. If a window is not interested in
a device event, it usually propagates to the closest ancestor
that is interested, unless the do_not_propagate mask prohibits
it\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
Multiple clients can select for the same events on the same
window with the following restrictions:
  * Multiple clients can select events on the same window
    because their event masks are disjoint\&. When the X server
    generates an event, it reports it to all interested
    clients\&.
  * Only one client at a time can select a DeviceButtonPress
    event with automatic passive grabbing enabled, which is
    associated with the event class DeviceButtonPressGrab\&. To
    receive DeviceButtonPress events without automatic passive
    grabbing, use event class DeviceButtonPress but do not
    specify event class DeviceButtonPressGrab\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The server reports the event to all interested clients\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
Information contained in the XDevice structure returned by
XOpenDevice is used by macros to obtain the event classes that
clients use in making XSelectExtensionEvent requests\&. Currently
defined macros include DeviceKeyPress, DeviceKeyRelease,
DeviceButtonPress, DeviceButtonRelese, DeviceMotionNotify,
DeviceFocusIn, DeviceFocusOut, ProximityIn, ProximityOut,
DeviceStateNotify, DeviceMappiingNotify, ChangeDeviceNotify,
DevicePointerMotionHint, DeviceButton1Motion,
DeviceButton2Motion, DeviceButton3Motion, DeviceButton4Motion,
DeviceButton5Motion, DeviceButtonMotion, DeviceOwnerGrabButton,
DeviceButtonPressGrab, and NoExtensionEvent\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
To obtain the proper event class for a particular device, one
of the above macros is invoked using the XDevice structure for
that device\&. For example,
             DeviceKeyPress (*device, type, eventclass);
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
returns the DeviceKeyPress event type and the eventclass for
selecting DeviceKeyPress events from this device\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XSelectExtensionEvent can generate a BadWindow or BadClass
error\&. The XGetSelectedExtensionEvents request reports the
extension events selected by this client and all clients for
the specified window\&. This request returns pointers to two
XEventClass arrays\&. One lists the input extension events
selected by this client from the specified window\&. The other
lists the event classes selected by all clients from the
specified window\&. You should use XFree to free these two
arrays\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XGetSelectedExtensionEvents can generate a BadWindow error\&.
.fi
.if n \{\
.RE
.\}
.SH "DIAGNOSTICS"
.sp
.if n \{\
.RS 4
.\}
.nf
BadWindow
       A value for a Window argument does not name a defined
       window\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadClass
       A value for an XEventClass is invalid\&.
.fi
.if n \{\
.RE
.\}
