.\" Copyright 2004 Red Hat Inc., Durham, North Carolina.
.\" All Rights Reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation on the rights to use, copy, modify, merge,
.\" publish, distribute, sublicense, and/or sell copies of the Software,
.\" and to permit persons to whom the Software is furnished to do so,
.\" subject to the following conditions:
.\"
.\" he above copyright notice and this permission notice (including the
.\" next paragraph) shall be included in all copies or substantial
.\" portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
.\" NON-INFRINGEMENT.  IN NO EVENT SHALL RED HAT AND/OR THEIR SUPPLIERS
.\" BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
.\" ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
.\" CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.TH DMXAddScreen __libmansuffix__ __vendorversion__
.SH NAME
DMXAddScreen \- attach a new back-end screen
.SH SYNOPSIS
.B #include <X11/extensions/dmxext.h>
.sp
.nf
.BI "Bool DMXAddScreen(Display " *dpy ,
.BI "                  const char " *displayName ,
.BI "                  unsigned int " mask ,
.BI "                  DMXScreenAttributes " *attr ,
.BI "                  int " *screen );
.fi
.SH DESCRIPTION
.B DMXAddScreen()
attaches a back-end screen to the
.BR Xdmx (1)
server, in place of the previously detached back-end server specified by
.IR screen .
.PP
.I displayName
is the name of the new back-end display,
.I mask
specifies the field in
.I attr
that are active, and
.I screen
returns the new
.BR Xdmx (1)
screen number for the attached screen.
.PP
The information stored in
.I mask " and " attr
is identical to that used by the
.BR DMXChangeScreenAttributes (__libmansuffix__)
and
.BR DMXGetScreenAttribues (__libmansuffix__)
functions.
.SH "RETURN VALUE"
.B DMXAddScreen()
will return
.B True
if the screen was successfully attached, and
.B False
otherwise.
.B False
will be returned if the
.I \-addremovescreens
command line option was not specified on the
.BR Xdmx (1)
command line, the input value of
.I screen
is out of range,
.I screen
is not currently detached,
.I displayName
cannot be opened, has unexpected visuals, or has characteristics that do
not match the previously detached screen.
.PP
.B DMXAddScreen()
can generate
.BR BadLength ,
.BR BadAlloc ,
and
.B BadValue
errors.
.SH NOTES
Attributes that are not specified will default to 0.  This may lead to
unintended results.
.PP
Unlike other functions in the
.BR DMX (__libmansuffix__)
API, this function uses
.I screen
for both input and output.
.SH "SEE ALSO"
.BR DMXRemoveScreen "(__libmansuffix__), "
.BR DMXChangeScreenAttributes "(__libmansuffix__), " DMXGetScreenAttributes "(__libmansuffix__), "
.BR DMX "(__libmansuffix__), " Xdmx (1)
