/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XSaveContext(display, w, context, data)
 *   Display *display;
 *   Window w;
 *   XContext context;
 *   caddr_t data;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSaveContext	1
char    *TestName = "XSaveContext";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XSaveContext function
 */
static Display *display;
static Window w;
static XContext context;
static caddr_t data;


static int 	ValueReturn;


static char *xsc_ctxt ="set context";
static char *xsc_ctxt2 ="set context two";


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = defwin(display);
	context = XUniqueContext();
	data = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int a;
int ret;
caddr_t b;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSaveContext-1.(A)");
	report_assertion("A call to XSaveContext sets the table entry for context");
	report_assertion("data for display display, window w and context type context");
	report_assertion("to the specified value data, and returns zero.");

	report_strategy("Call XSaveContext to enter the context data.");
	report_strategy("Verify that zero was returned.");
	report_strategy("Call XFindContext to verify that the context data was added correctly.");

	tpstartup();
	setargs();
/* Call xname to enter the context data. */
	data = (caddr_t) xsc_ctxt;
	startcall(display);
	if (isdeleted())
		return;
	ret = XSaveContext(display, w, context, data);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that zero was returned. */
	if (ret != 0) {
		FAIL;
		report("%s returned non-zero when expected zero.",
			TestName);
		report("Returned value: %s", contexterrorname(ret));
	} else
		CHECK;

/* Call XFindContext to verify that the context data was added correctly. */
	a = XFindContext(display, w, context, &b);
	if (a != 0) {
		FAIL;
		report("XFindContext failed to find the context saved by %s", TestName);
		report("XFindContext returned %s", contexterrorname(a));
	} else {
		CHECK;

		if (b != (caddr_t)xsc_ctxt) {
			FAIL;
			report("XFindContext returned an unexpected context.");
			report("Expected context: %0x", (unsigned int)xsc_ctxt);
			report("Returned context: %0x", (unsigned int)b);
		} else
			CHECK;
	}

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int a;
int ret;
caddr_t b;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSaveContext-2.(A)");
	report_assertion("When there is previously saved context data for display");
	report_assertion("display, window w and context type context, then a call to");
	report_assertion("XSaveContext replaces the previously saved context data with");
	report_assertion("the specified value data, and returns zero.");

	report_strategy("Call XSaveContext to set the context data.");
	report_strategy("Verify that zero was returned.");
	report_strategy("Call XSaveContext to reset the context data.");
	report_strategy("Verify that zero was returned.");
	report_strategy("Call XFindContext to verify that the context data was added correctly.");

	tpstartup();
	setargs();
/* Call xname to set the context data. */
	data = (caddr_t) xsc_ctxt;
	startcall(display);
	if (isdeleted())
		return;
	ret = XSaveContext(display, w, context, data);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that zero was returned. */
	if (ret != 0) {
		FAIL;
		report("%s returned non-zero when expected zero when setting",
			TestName);
		report("context information.");
		report("Returned value: %s", contexterrorname(ret));
	} else
		CHECK;

/* Call xname to reset the context data. */
	data = (caddr_t) xsc_ctxt2;
	startcall(display);
	if (isdeleted())
		return;
	ret = XSaveContext(display, w, context, data);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that zero was returned. */
	if (ret != 0) {
		FAIL;
		report("%s returned non-zero when expected zero when resetting",
			TestName);
		report("context information.");
		report("Returned value: %s", contexterrorname(ret));
	} else
		CHECK;

/* Call XFindContext to verify that the context data was added correctly. */
	a = XFindContext(display, w, context, &b);
	if (a != 0) {
		FAIL;
		report("XFindContext failed to find the context saved by %s", TestName);
		report("XFindContext returned %s", contexterrorname(a));
	} else {
		CHECK;

		if (b != (caddr_t)xsc_ctxt2) {
			FAIL;
			report("XFindContext returned an unexpected context.");
			report("Original context: %0x", (unsigned int)xsc_ctxt);
			report("Expected context: %0x", (unsigned int)xsc_ctxt2);
			report("Returned context: %0x", (unsigned int)b);
		} else
			CHECK;
	}

	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.28804 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XSaveContext-3.(B)");
	report_assertion("When there is insufficient memory, then a call to");
	report_assertion("XSaveContext returns XCNOMEM.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.28804 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
