/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XChangeKeyboardDevice(display, device)
 *   Display	*display;
 *   XDevice *device;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XChangeKeyboardDevice	1
char    *TestName = "XChangeKeyboardDevice";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XChangeKeyboardDevice function
 */
static Display	*display;
static XDevice *device;


extern ExtDeviceInfo Devs;
extern int MinKeyCode;


verify_kbd(dpy, id)
	Display *dpy;
	int id;
	{
	XDeviceInfo *list;
	int i, ndevices;

	list = XListInputDevices (display, &ndevices);
	for (i=0; i<ndevices; i++,list++)
	    if (list->use==IsXKeyboard)
		if (list->id == id)
		    return(True);
		else
		    return(False);
	if (i==ndevices)
	    return(False);
	}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XDeviceInfo *list;
int i, ndevices, savid;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XChangeKeyboardDevice-1.(B)");
	report_assertion("A call to XChangeKeyboardDevice changes the X keyboard.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Change the X keyboard.  Verify via XListInputDevices that the keyboard");
	report_strategy("was changed.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	list = XListInputDevices (display, &ndevices);
	for (i=0; i<ndevices; i++,list++)
	    if (list->use==IsXKeyboard)
		savid = list->id;

	device = Devs.Key;
	startcall(display);
	if (isdeleted())
		return;
	XChangeKeyboardDevice(display, device);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (verify_kbd(display, Devs.Key->device_id))
	    CHECK;
	else
	    {
	    report("%s: Couldn't change X keyboard\n",TestName);
	    FAIL;
	    }

	device = XOpenDevice(display, savid);
	startcall(display);
	if (isdeleted())
		return;
	XChangeKeyboardDevice(display, device);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (verify_kbd(display, savid))
	    CHECK;
	else
	    {
	    report("%s: Couldn't restore X keyboard\n",TestName);
	    FAIL;
	    }
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Display	*client1, *client2;
XDeviceInfo *list;
int i, ndevices, savid;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XChangeKeyboardDevice-2.(B)");
	report_assertion("Termination of the client that changed the keyboard does");
	report_assertion("not affect which input device is the X keyboard.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Change the keyboard to a new device.");
	report_strategy("Terminate the client that made the change.");
	report_strategy("Verify that the X keyboard remains the same.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	list = XListInputDevices (display, &ndevices);
	for (i=0; i<ndevices; i++,list++)
	    if (list->use==IsXKeyboard)
		savid = list->id;

	device = Devs.Key;
/* Create client1, without causing resource registration. */
	if (config.display == (char *) NULL) {
		delete("config.display not set");
		return;
	}
	else
		CHECK;
	client1 = XOpenDisplay(config.display);
	if (client1 == (Display *) NULL) {
		delete("Couldn't create client1.");
		return;
	}
	else
		CHECK;

	display = client1;
	startcall(display);
	if (isdeleted())
		return;
	XChangeKeyboardDevice(display, device);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XCloseDisplay(display);

	if ((client2 = opendisplay()) == NULL)
		return;

	if (verify_kbd(client2, Devs.Key->device_id))
	    CHECK;
	else
	   {
    	   report("%s: Couldn't change X keyboard\n",TestName);
	   FAIL;
	   }

	device = XOpenDevice(display, savid);
	startcall(display);
	if (isdeleted())
		return;
	XChangeKeyboardDevice(display, device);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (verify_kbd(display, savid))
	    CHECK;
	else
	    {
	    report("%s: Couldn't restore X keyboard\n",TestName);
	    FAIL;
	    }
	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XDeviceInfo *list;
int i, ndevices, revert, savid;
Window focus, w;
Time time;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XChangeKeyboardDevice-3.(B)");
	report_assertion("After a successful call to ChangeKeyboardDevice, the focus");
	report_assertion("state of the new keyboard is the same as that of the old");
	report_assertion("keyboard.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create a window and set the keyboard focus to it.");
	report_strategy("Change the keyboard to a new device.");
	report_strategy("Verify that the X keyboard focus is the same as it was for the old device.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	device = Devs.Key;
	list = XListInputDevices (display, &ndevices);
	for (i=0; i<ndevices; i++,list++)
	    if (list->use==IsXKeyboard)
		savid = list->id;
	w = defwin(display);
	XSetDeviceFocus(display, device, None, RevertToNone, CurrentTime);
	XGetDeviceFocus(display, device, &focus, &revert, &time);
	if (focus != None || revert != RevertToNone)
	    {
	    report("%s: Unable to set focus for new kbd",TestName);
	    FAIL;
	    }
	else
	    CHECK;

	XSetInputFocus (display, w, RevertToPointerRoot, CurrentTime);
	XGetInputFocus (display, &focus, &revert);
	if (focus != w || revert != RevertToPointerRoot)
	    {
	    report("%s: Unable to set focus for old kbd");
	    FAIL;
	    }
	else
	    CHECK;

	startcall(display);
	if (isdeleted())
		return;
	XChangeKeyboardDevice(display, device);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (verify_kbd(display, Devs.Key->device_id))
	    CHECK;
	else
	   {
    	   report("%s: Couldn't change X keyboard\n",TestName);
	   FAIL;
	   }

	XGetInputFocus (display, &focus, &revert);
	if (focus != w || revert != RevertToPointerRoot)
		{
		report("%s: New kbd focus != old kbd focus: %x %x %x %x",TestName, focus, w, revert, RevertToPointerRoot);
	        FAIL;
		}
	    else
		CHECK;

	device = XOpenDevice(display, savid);
	startcall(display);
	if (isdeleted())
		return;
	XChangeKeyboardDevice(display, device);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (verify_kbd(display, savid))
	    CHECK;
	else
	    {
	    report("%s: Couldn't restore X keyboard\n",TestName);
	    FAIL;
	    }
	CHECKPASS(5);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.29182 */
static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XChangeKeyboardDevice-4.(B)");
	report_assertion("");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.29182 */

static void t005(){

int ret;
Display	*client2;
Window grab_window;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XChangeKeyboardDevice-5.(B)");
	report_assertion("A call to XChangeKeyboardDevice will fail with a status of");
	report_assertion("AlreadyGrabbed if some other client has grabbed the new");
	report_assertion("device.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Grab the new device.");
	report_strategy("Create client2.");
	report_strategy("Attempt to change the keyboard to the new device.");
	report_strategy("Verify AlreadyGrabbed error status");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	device = Devs.Key;
        grab_window = defwin(Dsp);

	XGrabDevice(Dsp, Devs.Key, grab_window, True, 0, 
		NULL, GrabModeAsync, GrabModeAsync, CurrentTime);
	if (isdeleted()) {
		delete("Could not set up initial grab");
		return;
	}

	if ((client2 = opendisplay()) == NULL)
		return;

	display = client2;
	startcall(display);
	if (isdeleted())
		return;
	ret = XChangeKeyboardDevice(display, device);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ret == AlreadyGrabbed)
		CHECK;
	else
		FAIL;

	CHECKPASS(1);
	XSync(display,0);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

XID baddevice;
int devicekeypress;
XDeviceInfo *list;
int i, ndevices, revert, nfeed, mask, ksyms_per;
int nevents, mode, evcount, valuators, count=0;
Window focus, w;
Time time;
XKbdFeedbackControl feedctl;
KeySym ksyms;
XModifierKeymap *modmap;
unsigned char bmap[8];
XDeviceResolutionControl dctl;
XEventClass devicekeypressclass;
XEvent ev;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XChangeKeyboardDevice-6.(B)");
	report_assertion("An attempt to call any input device extension request that");
	report_assertion("requires a Device specifying the new X keyboard will result");
	report_assertion("in a BadDevice error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Change the keyboard to a new device.");
	report_strategy("Verify that all input device extension requests that require a Device pointer");
	report_strategy("fail with a BadDevice error, when the new keyboard is specified.");

	tpstartup();
	setargs();

	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	w = defwin(display);
	device = Devs.Key;
	DeviceKeyPress(device, devicekeypress, devicekeypressclass);
	modmap = XGetDeviceModifierMapping(display, device);
	BadDevice (display, baddevice);
	startcall(display);
	if (isdeleted())
		return;
	XChangeKeyboardDevice(display, device);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	list = XListInputDevices (display, &ndevices);
	for (i=0; i<ndevices; i++,list++)
	    if (list->use==IsXKeyboard)
		if (list->id == Devs.Key->device_id)
		    {
		    CHECK;
		    count++;
		    break;
		    }
		else
		    {
	    	    report("%s: Couldn't change X keyboard\n",TestName);
		    FAIL;
		    break;
		    }
	if (i==ndevices)
	    {
	    report("%s: Failed to find X keyboard\n",TestName);
	    FAIL;
	    }

	XSetErrorHandler(error_status);
	XOpenDevice(display, device->device_id);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XCloseDevice(display, device);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XSetDeviceMode(display, device, Absolute);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGetDeviceMotionEvents(display, device, CurrentTime, CurrentTime,
	    &nevents, &mode, &evcount);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XChangeKeyboardDevice(display, device);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XChangePointerDevice(display, device, 0, 1);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGrabDevice(display, device, w, True, 1, &devicekeypressclass,
	   GrabModeAsync, GrabModeAsync, CurrentTime);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XUngrabDevice(display, device, CurrentTime);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGrabDeviceKey(display, device, AnyKey, AnyModifier, NULL, 
	   w, True, 0, NULL, GrabModeAsync, GrabModeAsync);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XUngrabDeviceKey(display, device, AnyKey, AnyModifier, NULL, w);

	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGrabDeviceButton(display, device, AnyButton, AnyModifier, NULL, 
	   w, True, 0, NULL, GrabModeAsync, GrabModeAsync);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XUngrabDeviceButton(display, device, AnyButton, AnyModifier, NULL, w);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XAllowDeviceEvents(display, device, AsyncAll, CurrentTime);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGetDeviceFocus(display, device, &focus, &revert, &time);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XSetDeviceFocus(display, device, None, RevertToNone, CurrentTime);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGetFeedbackControl(display, device, &nfeed);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	feedctl.class = KbdFeedbackClass;
	feedctl.percent = 0;
	mask = DvPercent;
	XChangeFeedbackControl(display, device, mask, (XFeedbackControl *) &feedctl);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGetDeviceKeyMapping(display, device, MinKeyCode, 1, &ksyms_per);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XChangeDeviceKeyMapping(display, device, MinKeyCode, 1, &ksyms, 1);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGetDeviceModifierMapping(display, device);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XSetDeviceModifierMapping(display, device, modmap);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGetDeviceButtonMapping(display, device, bmap, 8);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XSetDeviceButtonMapping(display, device, bmap, 8);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XQueryDeviceState(display, device);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XSetDeviceValuators(display, device, &valuators, 0, 1);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XDeviceBell(display, device, 0, 0, 100);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGetDeviceControl(display, device, DEVICE_RESOLUTION);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	dctl.length = sizeof(XDeviceResolutionControl);
	dctl.control = DEVICE_RESOLUTION;
	dctl.num_valuators=1;
	dctl.first_valuator=0;
	dctl.resolutions = &valuators;
	XChangeDeviceControl(display, device, DEVICE_RESOLUTION, (XDeviceControl *) &dctl);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	ev.type = devicekeypress;
	XSendExtensionEvent(display, device, PointerWindow, True, 0, NULL,
	    &ev);
	XSync(display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XSetErrorHandler(unexp_err);
	CHECKPASS(count);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.29182 */
static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XChangeKeyboardDevice-7.(B)");
	report_assertion("If the implementation does not support use of the specified");
	report_assertion("device as the X keyboard, a BadDevice error will result.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.29182 */

static void t008(){

XDevice nodevice;
XID baddevice;
int ximajor, first, err;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XChangeKeyboardDevice-8.(B)");
	report_assertion("A call to XChangeKeyboardDevice will fail with a BadDevice");
	report_assertion("error if an invalid device is specified.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with an invalid device.");

	tpstartup();
	setargs();
	if (!XQueryExtension (display, INAME, &ximajor, &first, &err))
	    {
	    untested("%s: Input extension not supported.\n", TestName);
	    return;
	    }
	BadDevice (display, baddevice);
	nodevice.device_id = -1;
	device = &nodevice;

	startcall(display);
	if (isdeleted())
		return;
	XChangeKeyboardDevice(display, device);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}

	if (geterr() == baddevice)
		CHECK;
	else
		FAIL;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int ret;
Display	*client2;
Window grab_window;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XChangeKeyboardDevice-9.(B)");
	report_assertion("A call to XChangeKeyboardDevice will fail with a status of");
	report_assertion("GrabFrozen if the device is frozen by the grab of some other");
	report_assertion("client.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Grab the new device when it is frozen by a grab of another device.");
	report_strategy("Create client2.");
	report_strategy("Attempt to change the keyboard to the new device.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask | NKeysMask))
	    {
	    untested("%s: Required input extension devices not present.\n", 
		TestName);
	    return;
	    }
	device = Devs.Key;
        grab_window = defwin (display);

	XGrabDevice(Dsp, Devs.NoKeys, grab_window, True, 0, 
		NULL, GrabModeSync, GrabModeSync, CurrentTime);
	if (isdeleted()) {
		delete("Could not set up initial grab");
		return;
	}

	if ((client2 = opendisplay()) == NULL)
		return;

	display = client2;
	startcall(display);
	if (isdeleted())
		return;
	ret = XChangeKeyboardDevice(display, device);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ret == GrabFrozen)
		CHECK;
	else
		{
		report("Device was not frozen by the grab of another device,ret=%d",ret);
		FAIL;
		}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XChangeKeyboardDevice-10.(B)");
	report_assertion("A call to XChangeKeyboardDevice will fail with a BadMatch");
	report_assertion("error if the specified device has no keys.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Attempt to change the keyboard to a device that has no keys.");
	report_strategy("Verify BadMatch");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(NKeysMask))
	    {
	    untested("%s: No input extension device without keys.\n", TestName);
	    return;
	    }
	device = Devs.NoKeys;

	startcall(display);
	if (isdeleted())
		return;
	XChangeKeyboardDevice(display, device);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		CHECK;
	else
		FAIL;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
