/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XChangePointerDevice(display, device, xaxis, yaxis)
 *   Display	*display;
 *   XDevice *device;
 *   int 	xaxis;
 *   int 	yaxis;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XChangePointerDevice	1
char    *TestName = "XChangePointerDevice";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XChangePointerDevice function
 */
static Display	*display;
static XDevice *device;
static int 	xaxis;
static int 	yaxis;


extern ExtDeviceInfo Devs;
extern int NumValuators, MinKeyCode;


verify_ptr(dpy, id)
	Display *dpy;
	int id;
	{
	XDeviceInfo *list;
	int i, ndevices;

	list = XListInputDevices (display, &ndevices);
	for (i=0; i<ndevices; i++,list++)
	    if (list->use==IsXPointer)
		if (list->id == id)
		    return(True);
		else
		    return(False);
	if (i==ndevices)
	    return(False);
	}

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
	xaxis = 1;
	yaxis = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XDeviceInfo *list;
int i, ndevices, savid;
	int motiontype;
	XEventClass motionclass;
	Display *client2;		/* Second connection */
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XChangePointerDevice-1.(B)");
	report_assertion("A call to XChangePointerDevice changes the X pointer.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Touch test.");

	tpstartup();
	setargs();
	if ((client2 = opendisplay()) == NULL)
		return;

	if (!Setup_Extension_DeviceInfo(ValMask) || NumValuators < 2)
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	list = XListInputDevices (display, &ndevices);
	for (i=0; i<ndevices; i++,list++)
	    if (list->use==IsXPointer)
		savid = list->id;

	device = Devs.Valuator;
	DeviceMotionNotify(device, motiontype, motionclass);
	XSelectExtensionEvent (client2, defwin(client2), &motionclass, 1);
	XSync(client2,0);

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerDevice(display, device, xaxis, yaxis);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (verify_ptr(display, Devs.Valuator->device_id))
	    CHECK;
	else
	    {
	    report("%s: Couldn't change X pointer\n",TestName);
	    FAIL;
	    }
	device = XOpenDevice(display, savid);
	startcall(display);
	if (isdeleted())
		return;
	XChangePointerDevice(display, device, xaxis, yaxis);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (verify_ptr(display, savid))
	    CHECK;
	else
	    {
	    report("%s: Couldn't restore X pointer\n",TestName);
	    FAIL;
	    }
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

#define BUTTONMAPLEN 32
XDevice *dev;
XDeviceInfo *list;
XDeviceState *state;
XButtonState *bs;
XEventClass dmnc;
XEvent ev;
int n, dmn, i, j, ndevices, savid, ax=0;
char *buttons;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XChangePointerDevice-2.(B)");
	report_assertion("If a button is pressed on the pointer device, then the");
	report_assertion("pointer device is changed to a new device, then the button");
	report_assertion("is released, the state of the old pointer device will show");
	report_assertion("all buttons up.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Press a button on the pointer device.");
	report_strategy("Change the pointer to a new device.");
	report_strategy("Release the button on the old pointer device.");
	report_strategy("Verify that the old X pointer device shows all buttons up.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(ValMask) || NumValuators < 2)
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }

	if (noext(1))
	    return;

	list = XListInputDevices (display, &ndevices);
	for (i=0; i<ndevices; i++,list++)
	    if (list->use==IsXPointer)
		savid = list->id;

	device = Devs.Valuator;
	buttonpress (display, Button1);
	XSync(display, 0);
	startcall(display);
	if (isdeleted())
		return;
	XChangePointerDevice(display, device, xaxis, yaxis);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display, 0);
	dev = XOpenDevice (display, savid);
	DeviceMotionNotify(dev, dmn, dmnc);
	XSelectExtensionEvent (display, DRW(display), &dmnc, 1);
	XSync(display, 0);
	devicebuttonrel(display, dev, Button1);
	SimulateDeviceMotionEvent(display, dev, 0, 1, &ax, 0);
	XSync(display, 0);

	state = XQueryDeviceState (display, dev);
	bs = (XButtonState *) state->data;
	for (i=0; i<state->num_classes; i++)
	    {
	    if (bs->class == ButtonClass)
		{
		for (j=0,buttons=bs->buttons; j<BUTTONMAPLEN; j++,buttons++)
		    if (j != Button1 >> 3 && *buttons != 0)
			{
			report("%s: byte %d of buttons was %x, should be 0\n",
			    TestName,j,*buttons);
			FAIL;
			}
		    else
			CHECK;
		}
	    bs = (XButtonState *) ((char *) bs + bs->length);
	    }
	if (((n = getevent(display, &ev)) != 2) || ev.type != MappingNotify) {
		report("Expected one MappingNotify event");
		report("Got %d events, first was type %d",n,ev.type);
		FAIL;
		return;
	} else
		CHECK;
	if (((n = getevent(display, &ev)) != 1) || ev.type != dmn) {
		report("Expected one DeviceMotion event");
		report("Got %d events, first was type %d",n,ev.type);
		FAIL;
		return;
	} else
		CHECK;

	if (((XDeviceMotionEvent *) &ev)->device_state != 0) {
	    report ("Device motion state was %x, not 0 after press/release\n",
		((XDeviceMotionEvent *) &ev)->device_state);
	    FAIL;
	    }
	else
		CHECK;
	CHECKPASS(BUTTONMAPLEN + 3);


	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Display	*client2, *client1;
XDeviceInfo *list;
int i, ndevices, savid;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XChangePointerDevice-3.(B)");
	report_assertion("Termination of the client that changed the pointer does not");
	report_assertion("affect which input device is the X pointer.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Change the pointer to a new device.");
	report_strategy("Terminate the client that made the change.");
	report_strategy("Verify that the X pointer remains the same.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(ValMask) || NumValuators < 2)
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	list = XListInputDevices (display, &ndevices);
	for (i=0; i<ndevices; i++,list++)
	    if (list->use==IsXPointer)
		savid = list->id;

	device = Devs.Valuator;
/* Create client1, without causing resource registration. */
	if (config.display == (char *) NULL) {
		delete("config.display not set");
		return;
	}
	else
		CHECK;
	client1 = XOpenDisplay(config.display);
	if (client1 == (Display *) NULL) {
		delete("Couldn't create client1.");
		return;
	}
	else
		CHECK;
		
	display = client1;
	startcall(display);
	if (isdeleted())
		return;
	XChangePointerDevice(display, device, xaxis, yaxis);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XCloseDisplay(display);

	if ((client2 = opendisplay()) == NULL)
		return;

	display = client2;
	if (verify_ptr(display, Devs.Valuator->device_id))
	    CHECK;
	else
	    {
	    report("%s: Couldn't change X pointer\n",TestName);
	    FAIL;
	    }
	device = XOpenDevice(display, savid);
	startcall(display);
	if (isdeleted())
		return;
	XChangePointerDevice(display, device, xaxis, yaxis);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (verify_ptr(display, savid))
	    CHECK;
	else
	    {
	    report("%s: Couldn't restore X pointer\n",TestName);
	    FAIL;
	    }
	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XChangePointerDevice-4.(B)");
	report_assertion("If the specified device has no valuators, a call to");
	report_assertion("XChangePointerDevice will result in a BadMatch error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XChangePointerDevice with a device that has no valuators.");
	report_strategy("Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(NValsMask))
	    {
	    untested("%s: No input extension device without valuators.\n", TestName);
	    return;
	    }
	device = Devs.NoValuators;

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerDevice(display, device, xaxis, yaxis);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.29183 */
static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XChangePointerDevice-5.(B)");
	report_assertion("If the implementation does not support use of the specified");
	report_assertion("device as the X pointer, a BadDevice error will result.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.29183 */

static void t006(){

XID baddevice;
int devicemotionnotify;
XDeviceInfo *list;
int i, ndevices, revert, nfeed, mask, ksyms_per, savid;
int nevents, mode, evcount, valuators, count=0;
Window focus, w;
Time time;
XKbdFeedbackControl feedctl;
KeySym ksyms;
XModifierKeymap *modmap;
unsigned char bmap[8];
XDeviceResolutionControl dctl;
XEventClass devicemotionnotifyclass;
XEvent ev;
XDevice bogus;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XChangePointerDevice-6.(B)");
	report_assertion("After a successful call to ChangePointerDevice, a call to");
	report_assertion("any other input device extension request that requires a");
	report_assertion("Device, specifying the new X pointer, will result in a");
	report_assertion("BadDevice error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Change the pointer to a new device.");
	report_strategy("Verify that all input device extension requests that require a Device pointer");
	report_strategy("fail with a BadDevice error, when the new pointer is specified.");

	tpstartup();
	setargs();

	if (!Setup_Extension_DeviceInfo(ValMask) || NumValuators < 2)
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	list = XListInputDevices (display, &ndevices);
	for (i=0; i<ndevices; i++,list++)
	    if (list->use==IsXPointer)
		savid = list->id;

	w = defwin(display);
	device = Devs.Valuator;
	bogus.device_id = Devs.Valuator->device_id;
	DeviceMotionNotify(device, devicemotionnotify, devicemotionnotifyclass);
	modmap = XGetModifierMapping(display);
	startcall(display);
	if (isdeleted())
		return;
	XChangePointerDevice(display, device, xaxis, yaxis);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (verify_ptr(display, Devs.Valuator->device_id))
	    {
	    CHECK;
	    count++;
	    }
	else
	    {
	    report("%s: Couldn't change X pointer\n",TestName);
	    FAIL;
	    }

	XSetErrorHandler(error_status);
	XOpenDevice(display, device->device_id);
	XSync(display,0);
	BadDevice (display, baddevice);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	device = &bogus;
	XCloseDevice(display, device);
	XSync(display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XSetDeviceMode(display, device, Absolute);
	XSync(display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGetDeviceMotionEvents(display, device, CurrentTime, CurrentTime,
	    &nevents, &mode, &evcount);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XChangeKeyboardDevice(display, device);
	XSync(display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XChangePointerDevice(display, device, 0, 1);
	XSync(display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGrabDevice(display, device, w, True, 1, &devicemotionnotifyclass,
	   GrabModeAsync, GrabModeAsync, CurrentTime);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XUngrabDevice(display, device, CurrentTime);
	XSync(display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGrabDeviceKey(display, device, AnyKey, AnyModifier, NULL, 
	   w, True, 0, NULL, GrabModeAsync, GrabModeAsync);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XUngrabDeviceKey(display, device, AnyKey, AnyModifier, NULL, w);
	XSync(display,0);

	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGrabDeviceButton(display, device, AnyButton, AnyModifier, NULL, 
	   w, True, 0, NULL, GrabModeAsync, GrabModeAsync);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XUngrabDeviceButton(display, device, AnyButton, AnyModifier, NULL, w);
	XSync(display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XAllowDeviceEvents(display, device, AsyncAll, CurrentTime);
	XSync(display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGetDeviceFocus(display, device, &focus, &revert, &time);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XSetDeviceFocus(display, device, None, RevertToNone, CurrentTime);
	XSync(display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGetFeedbackControl(display, device, &nfeed);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	feedctl.class = KbdFeedbackClass;
	feedctl.percent = 0;
	mask = DvPercent;
	XChangeFeedbackControl(display, device, mask, (XFeedbackControl*) &feedctl);
	XSync(display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGetDeviceKeyMapping(display, device, MinKeyCode, 1, &ksyms_per);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XChangeDeviceKeyMapping(display, device, MinKeyCode, 1, &ksyms, 1);
	XSync(display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGetDeviceModifierMapping(display, device);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XSetDeviceModifierMapping(display, device, modmap);
	XSync(display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGetDeviceButtonMapping(display, device, bmap, 8);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XSetDeviceButtonMapping(display, device, bmap, 8);
	XSync(display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XQueryDeviceState(display, device);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XSetDeviceValuators(display, device, &valuators, 0, 1);
	XSync(display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XDeviceBell(display, device, 0, 0, 100);
	XSync(display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	XGetDeviceControl(display, device, DEVICE_RESOLUTION);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	dctl.length = sizeof(XDeviceResolutionControl);
	dctl.control = DEVICE_RESOLUTION;
	dctl.num_valuators=1;
	dctl.first_valuator=0;
	dctl.resolutions = &valuators;
	XChangeDeviceControl(display, device, DEVICE_RESOLUTION, (XDeviceControl*) &dctl);
	XSync(display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	ev.type = devicemotionnotify;
	XSendExtensionEvent(display, device, PointerWindow, True, 0, NULL,
	    &ev);
	XSync(display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		FAIL;

	device = XOpenDevice(display, savid);
	startcall(display);
	if (isdeleted())
		return;
	XChangePointerDevice(display, device, xaxis, yaxis);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);
	if (verify_ptr(display, savid))
	    {
	    CHECK;
	    count++;
	    }
	else
	    {
	    report("%s: Couldn't restore X pointer\n",TestName);
	    FAIL;
	    }
	XSetErrorHandler(unexp_err);
	CHECKPASS(count);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

XDevice nodevice;
XID baddevice;
int ximajor, first, err;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XChangePointerDevice-7.(B)");
	report_assertion("When an invalid device is specified, a BadDevice error will");
	report_assertion("result.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with an invalid device.");

	tpstartup();
	setargs();
	if (!XQueryExtension (display, INAME, &ximajor, &first, &err))
	    {
	    untested("%s: Input extension not supported.\n", TestName);
	    return;
	    }

	BadDevice (display, baddevice);
	nodevice.device_id = -1;
	device = &nodevice;

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerDevice(display, device, xaxis, yaxis);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}

	if (geterr() == baddevice)
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XChangePointerDevice-8.(B)");
	report_assertion("When the specified axes are not in the range of axes");
	report_assertion("supported by the device, then a BadMatch error occurs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XChangePointerDevice with xaxis less than 0.");
	report_strategy("Verify that a BadMatch error occurs.");
	report_strategy("Call XChangePointerDevice with yaxis greater than the number of axes supported.");
	report_strategy("Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(ValMask))
	    {
	    untested("%s: No input extension valuator device.\n", TestName);
	    return;
	    }
	device = Devs.Valuator;

	xaxis = -1;
	startcall(display);
	if (isdeleted())
		return;
	XChangePointerDevice(display, device, xaxis, yaxis);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		CHECK;

	/*
	 * Since the protocol only has one byte for the key then this
	 * assertion cannot be tested when max_button is 255.
	 */
	if (yaxis < 255) {

		yaxis = 255;

		startcall(display);
		if (isdeleted())
			return;
		XChangePointerDevice(display, device, xaxis, yaxis);
		endcall(display);
		if (geterr() != BadMatch) {
			report("Got %s, Expecting BadMatch", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadMatch)
			CHECK;
	} else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int ret;
Display	*client2;
Window grab_window;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XChangePointerDevice-9.(B)");
	report_assertion("A call to XChangePointerDevice will fail with a status of");
	report_assertion("AlreadyGrabbed if some other client has grabbed the new");
	report_assertion("device.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Grab the new device.");
	report_strategy("Create client2.");
	report_strategy("Attempt to change the pointer to the new device.");

	tpstartup();
	setargs();
        grab_window = defwin (display);
	if (!Setup_Extension_DeviceInfo(ValMask))
	    {
	    untested("%s: No input extension valuator device.\n", TestName);
	    return;
	    }
	device = Devs.Valuator;

	XGrabDevice(Dsp, device, grab_window, True, 0, 
		NULL, GrabModeAsync, GrabModeAsync, CurrentTime);
	if (isdeleted()) {
		delete("Could not set up initial grab");
		return;
	}

	if ((client2 = opendisplay()) == NULL)
		return;

	display = client2;
	startcall(display);
	if (isdeleted())
		return;
	ret = XChangePointerDevice(display, device, xaxis, yaxis);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ret == AlreadyGrabbed)
		CHECK;
	else
		FAIL;

	CHECKPASS(1);
        XUngrabDevice(Dsp, device, CurrentTime);
	XSync(display,0);

	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

int ret;
Display	*client2;
Window grab_window;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XChangePointerDevice-10.(B)");
	report_assertion("A call to XChangePointerDevice will fail with a status of");
	report_assertion("GrabFrozen if the device is frozen by the grab of some other");
	report_assertion("client.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Grab the new device when it is frozen by a grab of another device.");
	report_strategy("Create client2.");
	report_strategy("Attempt to change the pointer to the new device.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(ValMask))
	    {
	    untested("%s: No input extension valuator device.\n", TestName);
	    return;
	    }
	device = Devs.Valuator;
        grab_window = defwin (display);

	XGrabKeyboard (Dsp, grab_window, True,
		GrabModeSync, GrabModeSync, CurrentTime);
	XSync(Dsp,0);
	if (isdeleted()) {
		delete("Could not set up initial grab");
		return;
	}

	if ((client2 = opendisplay()) == NULL)
		return;

	display = client2;
	startcall(display);
	if (isdeleted())
		return;
	ret = XChangePointerDevice(display, device, xaxis, yaxis);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ret == GrabFrozen)
		CHECK;
	else
		{
		FAIL;
		report("Wanted GrabFrozen, got %d", ret);
		}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
