/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XAllowEvents(display, event_mode, thetime)
 *   Display	*display;
 *   int 	event_mode;
 *   Time	thetime;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XAllowEvents	1
char    *TestName = "XAllowEvents";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XAllowEvents function
 */
static Display	*display;
static int 	event_mode;
static Time	thetime;



/*
 * The focus startup routines set the focus to the root window.
 */

/*
 * A window for use as a grab window in the freeze and freezecheck
 * routines.
 */
static	Window	grabwin;

/*
 * Grab and freeze the pointer.
 */
static void
grabfreezepointer(disp, thetime)
Display	*disp;
Time	thetime;
{

	grabwin = defwin(disp);

	XGrabPointer(disp, grabwin, False, PointerMotionMask,
		GrabModeSync, GrabModeAsync, None, None, thetime);
}

/*
 * Return True if the pointer is frozen.  We move the pointer and check
 * the reported new position as returned by warppointer.  If this is the
 * same as the old position then the pointer is frozen.
 */
static	Bool
ispfrozen(disp)
Display	*disp;
{
PointerPlace	*pp;

	warppointer(disp, grabwin, 0, 0);
	pp = warppointer(disp, grabwin, 1, 1);
	if (pp->ox == pp->nx)
		return True;
	else
		return False;
}



/*
 * Returns True if the keyboard is frozen.
 */
static
iskfrozen(display)
Display	*display;
{
XEvent	ev;
Window	win;
int 	res;
int 	key;

	XSync(display, True); /* Flush previous events */
	key = getkeycode(display);

	/*
	 * Try to provoke a keypress on win.
	 */
	win = defwin(display);
	XSelectInput(display, win, KeyPressMask);
	warppointer(display, win, 1, 1);
	keypress(display, key);
	if (XCheckMaskEvent(display, (long)KeyPressMask, &ev))
		res = False;
	else
		res = True;

	return(res);
}


/*
 * Set up for SyncBoth tests grab and freeze all devices
 */
int bothset()
{

#ifndef INPUTEXTENSION
	XUngrabPointer(display, CurrentTime);
	XUngrabKeyboard(display, CurrentTime);
#else
	int i, ndevices;
	int error;
	XDevice *xDevice;
	XDeviceInfo *list;

	if ((list = XListInputDevices (display, &ndevices)) == (XDeviceInfo *)NULL)
		{
		report("ERROR: XListInputDevices failed");
		tet_result(TET_FAIL);
		return -1;
		}
	report("ndevices(%d)", ndevices);
	for (i=0; i < ndevices; i++,list++)

		{
		switch(list->use)
			{
			case IsXPointer:
				XUngrabPointer(display, CurrentTime);
				break;
			case IsXKeyboard:
				XUngrabKeyboard(display, CurrentTime);
				break;
			case IsXExtensionDevice:
				if ((xDevice = XOpenDevice(display, list->id)) == (XDevice *)NULL)
					{
					report("WARNING: XOpenDevice(%s) failed", list->name);
					continue;
					}
				if ((error = XUngrabDevice(display, xDevice, CurrentTime)) != 0)
					{
					report("WARNING: XUngrab(%s) failed", list->name);
					}
				if ((error = XCloseDevice(display, xDevice)) != 0)
					{
					report("WARNING: XCloseDevice(%s)", list->name);
					}
				break;
				}
		}
#endif /* INPUTEXTENSION */

	grabwin = defwin(display);
	XSelectInput(display, grabwin, ButtonPressMask|ButtonReleaseMask|KeyPressMask|KeyReleaseMask);
	warppointer(display, grabwin, 5, 5);

	/* this grabs the pointer AND ALL OTHER DEVICES */
	XGrabPointer(display, grabwin, False,
	 	ButtonPressMask|ButtonReleaseMask|PointerMotionMask,
		GrabModeSync, GrabModeSync, None, None, CurrentTime);
	XGrabKeyboard(display, grabwin, False, GrabModeSync, GrabModeSync,
		CurrentTime);


	if (!ispfrozen(display)) {
		delete("Could not freeze pointer");
		return;
	}
	/*
	 * Can't check for the keyboard being frozen here since that requires
	 * pressing a key - and that would release the grab.
	 */

return 0;
}



/* Value list for use in test t029 */
static int 	event_modevallist[] = {
	AsyncPointer,
	SyncPointer,
	AsyncKeyboard,
	SyncKeyboard,
	ReplayPointer,
	ReplayKeyboard,
	AsyncBoth,
	SyncBoth,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	event_mode = AsyncPointer;
	thetime = CurrentTime;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XAllowEvents-1.(A)");
	report_assertion("When the specified time is earlier than the last-grab time");
	report_assertion("of the most recent active grab for the client or later than");
	report_assertion("the current X server time, then a call to XAllowEvents has");
	report_assertion("no effect.");

	report_strategy("Grab and freeze pointer with a given time.");
	report_strategy("Call XAllowEvents with earlier time and AsyncPointer.");
	report_strategy("Verify that the pointer is still frozen.");
	report_strategy("Get current server time.");
	report_strategy("Call XAllowEvents with a later time.");
	report_strategy("Verify that the pointer is still frozen.");

	tpstartup();
	setargs();
	/* get time from the server */
	thetime = gettime(display);
	grabfreezepointer(display, thetime);

	thetime -= 100;
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display))
		CHECK;
	else {
		report("Events allowed when time was earlier than last-grab time");
		FAIL;
	}

	/*
	 * Get current time again and add several minutes to get a time in the
	 * future.
	 */
	thetime = gettime(display);
	thetime += ((config.speedfactor+1) * 1000000);
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display))
		CHECK;
	else {
		report("Events allowed when time was later than current server time");
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XAllowEvents-2.(A)");
	report_assertion("When the event_mode argument is AsyncPointer and the");
	report_assertion("pointer is frozen by the client, then pointer event");
	report_assertion("processing is resumed.");

	report_strategy("Freeze pointer.");
	report_strategy("Call XAllowEvents with event_mode AsyncPointer.");
	report_strategy("Verify that pointer is not frozen.");

	tpstartup();
	setargs();
	grabfreezepointer(display, thetime);

	event_mode = AsyncPointer;
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display)) {
		report("Pointer was not released after AsyncPointer");
		FAIL;
	} else
		CHECK;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XAllowEvents-3.(A)");
	report_assertion("When the event_mode argument is AsyncPointer and the");
	report_assertion("pointer is frozen twice by the client on behalf of two");
	report_assertion("separate grabs, then a call to XAllowEvents thaws for both");
	report_assertion("grabs.");

	report_strategy("Freeze pointer with XGrabPointer.");
	report_strategy("Freeze pointer with XGrabKeyboard.");
	report_strategy("Call XAllowEvents with event_mode AsyncPointer.");
	report_strategy("Verify that pointer is not frozen.");

	tpstartup();
	setargs();
	grabfreezepointer(display, thetime);
	XGrabKeyboard(display, grabwin, False, GrabModeSync, GrabModeAsync,
		CurrentTime);

	if (isdeleted())
		return;

	event_mode = AsyncPointer;
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display)) {
		report("Pointer was not released from double grab after AsyncPointer");
		FAIL;
	} else
		CHECK;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XAllowEvents-4.(A)");
	report_assertion("When the event_mode argument is AsyncPointer and the");
	report_assertion("pointer is not frozen by the client, then a call to");
	report_assertion("XAllowEvents has no effect.");

	report_strategy("Call XAllowEvents with event_mode AsyncPointer.");
	report_strategy("Verify pointer is not frozen.");

	tpstartup();
	setargs();
	event_mode = AsyncPointer;
	grabwin = defwin(display);

	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (!ispfrozen(display))
		PASS;
	else {
		report("Pointer was frozen after AsyncPointer");
		FAIL;
	}
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XAllowEvents-5.(B)");
	report_assertion("When the event_mode argument is SyncPointer and the pointer");
	report_assertion("is frozen and actively grabbed by the client, then pointer");
	report_assertion("event processing is resumed normally until the next");
	report_assertion("ButtonPress or ButtonRelease event is reported to the");
	report_assertion("client, at which time the pointer again appears to freeze,");
	report_assertion("unless the reported event causes the pointer grab to be");
	report_assertion("released.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Grab and freeze the pointer.");
	report_strategy("Call XAllowEvents with event_mode SyncPointer.");
	report_strategy("Verify that pointer is not frozen.");
	report_strategy("If test extension available:");
	report_strategy("  Press a button.");
	report_strategy("  Verify that the pointer is frozen.");

	tpstartup();
	setargs();
	grabfreezepointer(display, thetime);
	XChangeActivePointerGrab(display, ButtonPressMask | PointerMotionMask,
				 None, CurrentTime);
	if (ispfrozen(display))
		CHECK;
	else {
		delete("Could not freeze pointer");
		return;
	}

	event_mode = SyncPointer;
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display)) {
		report("Pointer was not released after SyncPointer");
		FAIL;
	} else
		CHECK;

	if (noext(1) || nbuttons() <= 1) {
		CHECKUNTESTED(2);
		return;
	}

	/* If extension we can go on */
	(void)warppointer(display, grabwin, 1, 2);
	buttonpress(display, Button1);

	if (ispfrozen(display))
		CHECK;
	else {
		report("Pointer was not re-frozen by a button press");
		FAIL;
	}

	CHECKPASS(3);

	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XAllowEvents-6.(A)");
	report_assertion("When the event_mode argument is SyncPointer and the pointer");
	report_assertion("is not frozen by the client or the pointer is not grabbed by");
	report_assertion("the client, then a call to XAllowEvents has no effect.");

	report_strategy("Call XAllowEvents with event_mode SyncPointer.");
	report_strategy("Verify pointer is not frozen.");

	tpstartup();
	setargs();
	event_mode = SyncPointer;
	grabwin = defwin(display);

	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (!ispfrozen(display))
		PASS;
	else {
		report("Pointer was frozen after SyncPointer with no initial freeze");
		FAIL;
	}
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XAllowEvents-7.(A)");
	report_assertion("When the event_mode argument is SyncPointer and the pointer");
	report_assertion("is frozen twice by the client on behalf of two separate");
	report_assertion("grabs, then a call to XAllowEvents thaws for both grabs.");

	report_strategy("Freeze pointer with XGrabPointer.");
	report_strategy("Freeze pointer with XGrabKeyboard.");
	report_strategy("Call XAllowEvents with event_mode SyncPointer.");
	report_strategy("Verify that pointer is not frozen.");

	tpstartup();
	setargs();
	grabfreezepointer(display, thetime);
	XGrabKeyboard(display, grabwin, False, GrabModeSync, GrabModeAsync,
		CurrentTime);

	if (isdeleted())
		return;

	event_mode = SyncPointer;
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display)) {
		report("Pointer was not released after SyncPointer");
		FAIL;
	} else
		CHECK;

	CHECKPASS(1);
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

XEvent  ev;
XButtonPressedEvent    *bpp;
Window  chwin;
struct  area    area;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XAllowEvents-8.(B)");
	report_assertion("When the event_mode argument is ReplayPointer and the");
	report_assertion("pointer is actively grabbed by the client and is frozen as");
	report_assertion("the result of an event having been sent to the client, then");
	report_assertion("the pointer grab is released and the event is completely");
	report_assertion("reprocessed as though any passive grabs at or above the grab");
	report_assertion("window of the grab just released were not present.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Touch test for replay pointer.");
	report_strategy("If extensions are available:");
	report_strategy("  Create window.");
	report_strategy("  Create child of this window.");
	report_strategy("  Set passive grabs on both these windows.");
	report_strategy("  Warp pointer into child window.");
	report_strategy("  Press button to activate the grab.");
	report_strategy("  Check that parent window has the grab.");
	report_strategy("  Set event_mode to ReplayPointer.");
	report_strategy("  Call XAllowEvents.");
	report_strategy("  Verify that the child window now has the grab.");

	tpstartup();
	setargs();
	event_mode = ReplayPointer;
	if (noext(1)) {
		startcall(display);
		if (isdeleted())
			return;
		XAllowEvents(display, event_mode, thetime);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		untested("There is no reliable test method, but a touch test was performed");
		return;
	} else
		CHECK;

	/*
	 * Set up a pointer freeze as a result of a button press.
	 */
	grabwin = defwin(display);
	setarea(&area, 50, 50, 5, 5);
	chwin = crechild(display, grabwin, &area);

	/* XSelectInput(display, grabwin, ButtonPress); */
	XGrabButton(display, Button1, 0, grabwin,
		False, PointerMotionMask, GrabModeSync, GrabModeAsync,
		None, None);
	XGrabButton(display, Button1, 0, chwin,
		False, PointerMotionMask, GrabModeSync, GrabModeAsync,
		None, None);

	/*
	 * Activate the grab.
	 */
	XSync(display, True);	/* Discard any events */
	warppointer(display, chwin, 1, 1);
	buttonpress(display, Button1);

	/*
	 * Check that the grab was activated and that it occurs on the parent
	 * window.
	 */
	if (XCheckMaskEvent(display, ButtonPressMask, &ev)) {
		bpp = (XButtonPressedEvent*)&ev;
		if (bpp->window == grabwin)
			CHECK;
		else if (bpp->window == chwin) {
			delete("Child window had the grab");
			return;
		} else {
			delete("Could not get grab on parent window");
			return;
		}
	} else {
		delete("Did not get a button event when trying to activate grab");
		return;
	}

	/* Do the ReplayPointer */
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/*
	 * The effect should be as if the button were pressed again
	 * but without the passive grab on the parent window.  So this
	 * time the child should pick up the grab.
	 */
	if (XCheckMaskEvent(display, ButtonPressMask, &ev)) {
		bpp = (XButtonPressedEvent*)&ev;
		if (bpp->window == chwin)
			CHECK;
		else if (bpp->window == grabwin) {
			report("Parent window had the grab after a ReplayPointer");
			FAIL;
		} else {
			report("After ReplayPointer the grab on the child did not activate");
			FAIL;
		}
	} else {
		report("Did not get a button event when trying to activate grab");
		FAIL;
	}

	CHECKPASS(3);
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XAllowEvents-9.(A)");
	report_assertion("When the event_mode argument is ReplayPointer and the");
	report_assertion("pointer is not frozen as a result of an event or the pointer");
	report_assertion("is not grabbed by the client, then a call to XAllowEvents");
	report_assertion("has no effect.");

	report_strategy("Call XAllowEvents with event_mode ReplayPointer.");
	report_strategy("Verify pointer is not frozen.");

	tpstartup();
	setargs();
	event_mode = ReplayPointer;
	grabwin = defwin(display);

	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (!ispfrozen(display))
		PASS;
	else {
		report("Pointer was frozen after ReplayPointer");
		FAIL;
	}
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

int 	key;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XAllowEvents-10.(B)");
	report_assertion("When the event_mode argument is ReplayPointer and the");
	report_assertion("pointer is frozen twice by the client on behalf of two");
	report_assertion("separate grabs, then a call to XAllowEvents thaws for both");
	report_assertion("grabs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions are available:");
	report_strategy("  Freeze pointer with XGrabKeyboard.");
	report_strategy("  Set up passive grab.");
	report_strategy("  Freeze pointer by activating grab with a button press.");
	report_strategy("  Call XAllowEvents with event_mode of ReplayPointer.");
	report_strategy("  Verify that pointer was released.");

	tpstartup();
	setargs();
	if (noext(1))
		return;

	grabwin = defwin(display);
	warppointer(display, grabwin, 1, 1);

	key = getkeycode(display);
	XGrabKey(display, key, 0, grabwin, False, GrabModeSync, GrabModeAsync);
	XGrabButton(display, Button1, 0, grabwin,
		False, PointerMotionMask, GrabModeSync, GrabModeAsync,
		None, None);
	buttonpress(display, Button1);
	keypress(display, key);

	event_mode = ReplayPointer;
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display)) {
		report("Pointer was not released after ReplayPointer");
		report("  and the pointer was frozen by two grabs.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(1);

	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XAllowEvents-11.(B)");
	report_assertion("When the event_mode argument is AsyncKeyboard and the");
	report_assertion("keyboard is frozen by the client, then keyboard event");
	report_assertion("processing is resumed.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If no extensions:");
	report_strategy("  Touch test for AsyncKeyboard.");
	report_strategy("else");
	report_strategy("  Grab and freeze Keyboard.");
	report_strategy("  Call XAllowEvents with event_mode AsyncKeyboard.");
	report_strategy("  Verify that the keyboard is released.");

	tpstartup();
	setargs();
	if (noext(0)) {
		event_mode = AsyncKeyboard;
		startcall(display);
		if (isdeleted())
			return;
		XAllowEvents(display, event_mode, thetime);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		untested("There is no reliable test method, but a touch test was performed");
		return;
	} else
		CHECK;

	grabwin = defwin(display);
	XGrabKeyboard(display, grabwin, False, GrabModeAsync, GrabModeSync,
		CurrentTime);
	if (iskfrozen(display))
		CHECK;
	else {
		delete("Could not freeze keyboard");
		return;
	}

	event_mode = AsyncKeyboard;
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (iskfrozen(display)) {
		report("Keyboard was not released by AsyncKeyboard");
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);

	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XAllowEvents-12.(B)");
	report_assertion("When the event_mode argument is AsyncKeyboard and the");
	report_assertion("keyboard is frozen twice by the client on behalf of two");
	report_assertion("separate grabs, then a call to XAllowEvents thaws for both.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions available:");
	report_strategy("  Freeze keyboard with XGrabPointer.");
	report_strategy("  Freeze keyboard with XGrabKeyboard.");
	report_strategy("  Call XAllowEvents with AsyncKeyboard.");
	report_strategy("  Verify that keyboard is released.");

	tpstartup();
	setargs();
	if (noext(0))
		return;

	grabwin = defwin(display);
	XGrabPointer(display, grabwin, False, PointerMotionMask,
		GrabModeAsync, GrabModeSync, None, None, thetime);
	XGrabKeyboard(display, grabwin, False, GrabModeAsync, GrabModeSync,
		CurrentTime);

	if (iskfrozen(display))
		CHECK;
	else {
		delete("Could not not set up keyboard grab");
		return;
	}

	event_mode = AsyncKeyboard;
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (iskfrozen(display)) {
		report("Keyboard was not released by AsyncKeyboard");
		report("  when it was frozen on behalf of two separate grabs.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XAllowEvents-13.(B)");
	report_assertion("When the event_mode argument is AsyncKeyboard and the");
	report_assertion("keyboard is not frozen by the client, then a call to");
	report_assertion("XAllowEvents has no effect.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions available:");
	report_strategy("  Call XAllowEvents with AsyncKeyboard.");
	report_strategy("  Verify that keyboard is not frozen.");

	tpstartup();
	setargs();
	if (noext(0))
		return;

	event_mode = AsyncKeyboard;
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (iskfrozen(display)) {
		report("Keyboard was frozen by AsyncKeyboard");
		FAIL;
	} else
		CHECK;

	CHECKPASS(1);
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

int 	key;
int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XAllowEvents-14.(B)");
	report_assertion("When the event_mode argument is SyncKeyboard and the");
	report_assertion("keyboard is frozen and actively grabbed by the client, then");
	report_assertion("keyboard event processing is resumed normally until the next");
	report_assertion("KeyPress or KeyRelease event is reported to the client, at");
	report_assertion("which time the keyboard again appears to freeze unless the");
	report_assertion("reported event causes the keyboard grab to be released.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If no extensions:");
	report_strategy("  Touch test for SyncKeyboard.");
	report_strategy("else");
	report_strategy("  Freeze keyboard.");
	report_strategy("  Call XAllowEvents with event_mode of SyncKeyboard.");
	report_strategy("  Verify that keyboard is not frozen.");
	report_strategy("  Press key.");
	report_strategy("  Verify that keyboard is frozen.");

	tpstartup();
	setargs();
	event_mode = SyncKeyboard;
	if (noext(0)) {
		startcall(display);
		if (isdeleted())
			return;
		XAllowEvents(display, event_mode, thetime);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		untested("There is no reliable test method, but a touch test was performed");
		return;
	} else
		CHECK;

	grabwin = defwin(display);
	XSelectInput(display, grabwin, KeyPressMask);
	XGrabKeyboard(display, grabwin, False, GrabModeAsync, GrabModeSync,
		CurrentTime);

	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (iskfrozen(display)) {
		report("Keyboard remained frozen after a SyncKeyboard");
		FAIL;
	} else
		CHECK;

	key = getkeycode(display);
	keypress(display, key);

	if (iskfrozen(display))
		CHECK;
	else {
		report("Keyboard was not frozen by a keypress after a SyncKeyboard");
		FAIL;
	}

	CHECKPASS(3);
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion XAllowEvents-15.(B)");
	report_assertion("When the event_mode argument is SyncKeyboard and the");
	report_assertion("keyboard is not frozen by the client or the keyboard is not");
	report_assertion("grabbed by the client, then a call to XAllowEvents has no");
	report_assertion("effect.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions available:");
	report_strategy("  Call XAllowEvents with event_mode of SyncKeyboard.");
	report_strategy("  Verify that keyboard is not frozen.");
	report_strategy("  Press key.");
	report_strategy("  Verify that keyboard is not frozen.");

	tpstartup();
	setargs();
	if (noext(0))
		return;

	event_mode = SyncKeyboard;
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (iskfrozen(display)) {
		report("Keyboard was frozen by SyncKeyboard though there was no freeze in effect");
		FAIL;
	} else
		CHECK;

	keypress(display, getkeycode(display));
	if (iskfrozen(display)) {
		report("Keyboard was frozen by SyncKeyboard and a key press");
		report("  though there was no freeze in effect");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t016(){

int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion XAllowEvents-16.(B)");
	report_assertion("When the event_mode argument is SyncKeyboard and the");
	report_assertion("keyboard is frozen twice by the client on behalf of two");
	report_assertion("separate grabs, then a call to XAllowEvents thaws for both");
	report_assertion("grabs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions available:");
	report_strategy("  Freeze keyboard with XGrabPointer.");
	report_strategy("  Freeze keyboard with XGrabKeyboard.");
	report_strategy("  Call XAllowEvents with event_mode of SyncKeyboard.");
	report_strategy("  Verify that keyboard is not frozen.");

	tpstartup();
	setargs();
	if (noext(0))
		return;

	grabwin = defwin(display);
	XGrabPointer(display, grabwin, False, PointerMotionMask,
		GrabModeAsync, GrabModeSync, None, None, thetime);
	XGrabKeyboard(display, grabwin, False, GrabModeAsync, GrabModeSync,
		CurrentTime);

	event_mode = SyncKeyboard;
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (iskfrozen(display)) {
		report("Keyboard remained frozen after a SyncKeyboard with");
		report("  the keyboard frozen on behalf of two separate grabs");
		FAIL;
	} else
		CHECK;

	CHECKPASS(1);
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t017(){

XEvent	ev;
XKeyPressedEvent	*kpp;
Window	win;
Window	chwin;
struct	area	area;
int 	key;
int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion XAllowEvents-17.(B)");
	report_assertion("When the event_mode argument is ReplayKeyboard and the");
	report_assertion("keyboard is actively grabbed by the client and is frozen as");
	report_assertion("the result of an event having been sent to the client, then");
	report_assertion("the keyboard grab is released and the event is completely");
	report_assertion("reprocessed as though any passive grabs at or above the grab");
	report_assertion("window of the grab just released were not present.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If no extensions:");
	report_strategy("  Touch test for ReplayKeyboard.");
	report_strategy("else");
	report_strategy("  Create window.");
	report_strategy("  Create child of that window.");
	report_strategy("  Enable key events on windows.");
	report_strategy("  Place passive grab with GrabModeSync on each window.");
	report_strategy("  Warp pointer to child window.");
	report_strategy("  Press key.");
	report_strategy("  Check that the parent window has the grab.");
	report_strategy("");
	report_strategy("  Call XAllowEvents with ReplayKeyboard.");
	report_strategy("  Verify that child window has grab.");

	tpstartup();
	setargs();
	event_mode = ReplayKeyboard;

	if (noext(0)) {
		startcall(display);
		if (isdeleted())
			return;
		XAllowEvents(display, event_mode, thetime);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		untested("There is no reliable test method, but a touch test was performed");
		return;
	} else
		CHECK;

	win = defwin(display);
	setarea(&area, 50, 50, 5, 5);
	chwin = crechild(display, win, &area);
	XSelectInput(display, win, KeyPressMask);
	XSelectInput(display, chwin, KeyPressMask);

	key = getkeycode(display);
	XGrabKey(display, key, 0, win, False, GrabModeAsync, GrabModeSync);
	XGrabKey(display, key, 0, chwin, False, GrabModeAsync, GrabModeSync);

	warppointer(display, chwin, 1, 1);

	XSync(display, True);
	/* This should activate the grab */
	keypress(display, key);

	if (XCheckMaskEvent(display, KeyPressMask, &ev)) {
		kpp = (XKeyPressedEvent*)&ev;
		if (kpp->window == win)
			CHECK;
		else if (kpp->window == chwin) {
			/*
			 * This could also be because owner_events=False is being
			 * ignored.
			 */
			delete("Child window had the grab, rather than parent");
			return;
		} else {
			delete("Parent did not get the grab");
			return;
		}
	} else {
		delete("Did not get KeyPress event");
		return;
	}
	XSync(display, True);	/* Discard any other events */

	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/*
	 * When the event is replayed then we should now get the event on
	 * the child window.
	 */
	if (XCheckMaskEvent(display, KeyPressMask, &ev)) {
		kpp = (XKeyPressedEvent*)&ev;
		if (kpp->window == chwin)
			CHECK;
		else if (kpp->window == win) {
			report("Parent window had the grab after ReplayPointer");
			report("  expecting that child window would get grab");
			FAIL;
		} else {
			report("Child did not get the grab after ReplayPointer");
			FAIL;
		}
	} else {
		report("Did not get KeyPress event after ReplayPointer");
		FAIL;
	}

	CHECKPASS(3);
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t018(){

XEvent	ev;
XKeyPressedEvent	*kpp;
Window	win;
Window	chwin;
struct	area	area;
int 	key;
int 	pass = 0, fail = 0;

 	report_purpose(18);

	report_assertion("Assertion XAllowEvents-18.(B)");
	report_assertion("When the event_mode argument is ReplayKeyboard and the");
	report_assertion("keyboard is not frozen as a result of an event or the");
	report_assertion("keyboard is not grabbed by the client, then a call to");
	report_assertion("XAllowEvents has no effect.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions available:");
	report_strategy("  Create window.");
	report_strategy("  Create child of that window.");
	report_strategy("  Place passive grab with GrabModeAsync on each window.");
	report_strategy("  Warp pointer to child window.");
	report_strategy("  Press key.");
	report_strategy("  Check that the parent window has the grab.");
	report_strategy("");
	report_strategy("  Call XAllowEvents with ReplayKeyboard.");
	report_strategy("  Verify that no key event was received on the child.");

	tpstartup();
	setargs();
	event_mode = ReplayKeyboard;

	if (noext(0)) {
		startcall(display);
		if (isdeleted())
			return;
		XAllowEvents(display, event_mode, thetime);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		untested("There is no reliable test method, but a touch test was performed");
		return;
	} else
		CHECK;

	win = defwin(display);
	setarea(&area, 50, 50, 5, 5);
	chwin = crechild(display, win, &area);

	key = getkeycode(display);
	XGrabKey(display, key, 0, win, False, GrabModeAsync, GrabModeAsync);
	XGrabKey(display, key, 0, chwin, False, GrabModeAsync, GrabModeAsync);

	warppointer(display, chwin, 1, 1);

	XSync(display, True);
	/* This should activate the grab */
	keypress(display, key);

	if (XCheckMaskEvent(display, KeyPressMask, &ev)) {
		kpp = (XKeyPressedEvent*)&ev;
		if (kpp->window == win)
			CHECK;
		else if (kpp->window == chwin) {
			delete("Child window had the grab");
			return;
		} else {
			delete("Parent did not get the grab");
			return;
		}
	} else {
		delete("Did not get KeyPress event");
		return;
	}
	XSync(display, True);	/* Discard any other events */

	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/*
	 * Should be no event after the ReplayKeyboard.
	 */
	if (XCheckMaskEvent(display, KeyPressMask, &ev)) {
		report("ReplayKeyboard had an effect when the keyboard was not frozen.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t019(){

int	key;
int 	pass = 0, fail = 0;

 	report_purpose(19);

	report_assertion("Assertion XAllowEvents-19.(B)");
	report_assertion("When the event_mode argument is ReplayKeyboard and the");
	report_assertion("keyboard is frozen twice by the client on behalf of two");
	report_assertion("separate grabs, then a call to XAllowEvents thaws for both");
	report_assertion("grabs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions available:");
	report_strategy("  Freeze keyboard with XGrabButton.");
	report_strategy("  Freeze keyboard with XGrabKey.");
	report_strategy("  Call XAllowEvents with event_mode of ReplayKeyboard.");
	report_strategy("  Verify that keyboard is not frozen.");

	tpstartup();
	setargs();
	if (noext(1))
		return;

	grabwin = defwin(display);
	warppointer(display, grabwin, 1, 1);

	XGrabButton(display, Button1, 0, grabwin,
		False, PointerMotionMask, GrabModeSync, GrabModeAsync,
		None,  None);

	key = getkeycode(display);
	XGrabKey(display, key, 0, grabwin, False, GrabModeSync, GrabModeAsync);

	keypress(display, key);
	buttonpress(display, Button1);

	event_mode = ReplayKeyboard;
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (iskfrozen(display)) {
		report("Keyboard was not unfrozen by ReplayKeyboard when frozen");
		report("  on behalf of two separate grabs.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(1);

	restoredevstate();

	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t020(){

int 	key;
int 	pass = 0, fail = 0;

 	report_purpose(20);

	report_assertion("Assertion XAllowEvents-20.(B)");
	report_assertion("When the event_mode argument is SyncBoth and both pointer");
	report_assertion("and keyboard are frozen by the client, then event processing");
	report_assertion("for both devices continues normally until the next");
	report_assertion("ButtonPress, ButtonRelease, KeyPress, or KeyRelease event");
	report_assertion("is reported to the client for a grabbed device at which time");
	report_assertion("both devices again appear to freeze, unless the reported");
	report_assertion("event causes the grab to be released.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If no extensions:");
	report_strategy("  Touch test for SyncBoth.");
	report_strategy("else");
	report_strategy("  Create grabwindow.");
	report_strategy("  Select events on grab window.");
	report_strategy("  Freeze and grab all devices by calling XGrabPointer.");
	report_strategy("  Freeze and grab all devices by calling XGrabKeyboard.");
	report_strategy("  Check that pointer is frozen.");
	report_strategy("");
	report_strategy("  Call XAllowEvents with event_mode of SyncBoth.");
	report_strategy("  Verify that pointer has been released.");
	report_strategy("");
	report_strategy("  Press button.");
	report_strategy("  Verify that pointer is frozen.");
	report_strategy("  Verify that keyboard is frozen.");
	report_strategy("");
	report_strategy("  Call XAllowEvents with event_mode of SyncBoth.");
	report_strategy("  Check pointer released.");
	report_strategy("  Release button.");
	report_strategy("  Verify that pointer is frozen.");
	report_strategy("  Verify that keyboard is frozen.");
	report_strategy("");
	report_strategy("  Call XAllowEvents with event_mode of SyncBoth.");
	report_strategy("  Check pointer released.");
	report_strategy("  Press key.");
	report_strategy("  Verify that pointer is frozen.");
	report_strategy("  Verify that keyboard is frozen.");
	report_strategy("");
	report_strategy("  Call XAllowEvents with event_mode of SyncBoth.");
	report_strategy("  Check pointer released.");
	report_strategy("  Release key.");
	report_strategy("  Verify that pointer is frozen.");
	report_strategy("  Verify that keyboard is frozen.");

	tpstartup();
	setargs();
	event_mode = SyncBoth;

	if (noext(1)) {
		startcall(display);
		if (isdeleted())
			return;
		XAllowEvents(display, event_mode, thetime);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		untested("There is no reliable test method, but a touch test was performed");
		return;
	} else
		CHECK;


	bothset();
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display)) {
		report("SyncBoth did not release pointer and keyboard");
		FAIL;
	} else
		CHECK;

	/* 1. Button press */
	buttonpress(display, Button1);
	if (ispfrozen(display))
		CHECK;
	else {
		report("Pointer was not re-frozen by a button press after SyncBoth");
		FAIL;
	}
	if (iskfrozen(display))
		CHECK;
	else {
		report("Keyboard was not re-frozen by a button press after SyncBoth");
		FAIL;
	}

	/* Allow events again for next part */
	bothset();
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ispfrozen(display)) {
		report("SyncBoth did not release pointer and keyboard");
		FAIL;
	} else
		CHECK;

	/* 2. Button release */
	buttonrel(display, Button1);
	if (ispfrozen(display))
		CHECK;
	else {
		report("Pointer was not re-frozen by a button release after SyncBoth");
		FAIL;
	}
	if (iskfrozen(display))
		CHECK;
	else {
		report("Keyboard was not re-frozen by a button release after SyncBoth");
		FAIL;
	}

	/* Allow events again for next part */
	bothset();
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ispfrozen(display)) {
		report("SyncBoth did not release pointer and keyboard");
		FAIL;
	} else
		CHECK;

	/* 3. Press key. */
	key = getkeycode(display);
	keypress(display, key);
	if (ispfrozen(display))
		CHECK;
	else {
		report("Pointer was not re-frozen by a key press after SyncBoth");
		FAIL;
	}
	if (iskfrozen(display))
		CHECK;
	else {
		report("Keyboard was not re-frozen by a key press after SyncBoth");
		FAIL;
	}

	/* Allow events again for next part */
	bothset();
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ispfrozen(display)) {
		report("SyncBoth did not release pointer and keyboard");
		FAIL;
	} else
		CHECK;

	/* 4. Key release. */
	keyrel(display, key);
	if (ispfrozen(display))
		CHECK;
	else {
		report("Pointer was not re-frozen by a key release after SyncBoth");
		FAIL;
	}
	if (iskfrozen(display))
		CHECK;
	else {
		report("Keyboard was not re-frozen by a key release after SyncBoth");
		FAIL;
	}

	CHECKPASS(13);
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t021(){

int 	pass = 0, fail = 0;

 	report_purpose(21);

	report_assertion("Assertion XAllowEvents-21.(B)");
	report_assertion("When the event_mode argument is SyncBoth and an event has");
	report_assertion("caused the grab on one device to be released and a");
	report_assertion("subsequent event is reported for the other device that does");
	report_assertion("not cause the grab to be released, then both devices are");
	report_assertion("again frozen.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extension available:");
	report_strategy("  Grab and freeze Keyboard with XGrabKeyboard.");
	report_strategy("  Set passive grab on button with pointer_mode GrabModeSync.");
	report_strategy("  Activate pointer grab.");
	report_strategy("");
	report_strategy("  Call XAllowEvents with event_mode SyncBoth.");
	report_strategy("  Release button to release pointer grab.");
	report_strategy("  Check pointer not frozen.");
	report_strategy("");
	report_strategy("  Press key.");
	report_strategy("  Verify that pointer and keyboard are frozen.");

	tpstartup();
	setargs();
	if (noext(1))
		return;

	grabwin = defwin(display);
	XGrabKeyboard(display, grabwin, False, GrabModeAsync, GrabModeSync,
		CurrentTime);
	XGrabButton(display, Button1, 0, grabwin,
		False, PointerMotionMask, GrabModeSync, GrabModeAsync,
		None, None);

	warppointer(display, grabwin, 1, 1);
	buttonpress(display, Button1);

	if (ispfrozen(display))
		CHECK;
	else {
		delete("Could not freeze pointer and keyboard");
		return;
	}

	event_mode = SyncBoth;
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/*
	 * Release pointer grab.
	 */
	buttonrel(display, Button1);
	if (ispfrozen(display)) {
		report("Pointer remained frozen after releasing button");
		FAIL;
	} else
		CHECK;

	keypress(display, getkeycode(display));
	if (ispfrozen(display))
		CHECK;
	else {
		report("Pointer was not re-frozen by an event from the keyboard after the pointer grab was released.");
		FAIL;
	}
	if (iskfrozen(display))
		CHECK;
	else {
		report("Keyboard was not re-frozen by an event from the keyboard after the pointer grab was released");
		FAIL;
	}

	CHECKPASS(4);
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t022(){

int 	pass = 0, fail = 0;

 	report_purpose(22);

	report_assertion("Assertion XAllowEvents-22.(B)");
	report_assertion("When the event_mode argument is SyncBoth and the pointer or");
	report_assertion("keyboard is frozen twice by the client on behalf of two");
	report_assertion("separate grabs, then a call to XAllowEvents thaws for both");
	report_assertion("grabs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions are available:");
	report_strategy("  Grab and freeze pointer.");
	report_strategy("  Grab keyboard and freeze pointer.");
	report_strategy("");
	report_strategy("  Call XAllowEvents with event_mode of SyncBoth.");
	report_strategy("  Verify that pointer and keyboard are thawed.");

	tpstartup();
	setargs();
	if (noext(0))
		return;

	grabwin = defwin(display);
	XGrabPointer(display, grabwin, False, PointerMotionMask,
		GrabModeSync, GrabModeSync, None, None, thetime);
	XGrabKeyboard(display, grabwin, False, GrabModeSync, GrabModeSync,
		CurrentTime);

	event_mode = SyncBoth;
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display)) {
		report("Pointer was not thawed by SyncBoth when pointer was frozen");
		report("  on behalf of two grabs");
		FAIL;
	} else
		CHECK;
	if (iskfrozen(display)) {
		report("Keyboard was not thawed by SyncBoth when pointer was frozen");
		report("  on behalf of two grabs");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t023(){

int 	pass = 0, fail = 0;

 	report_purpose(23);

	report_assertion("Assertion XAllowEvents-23.(B)");
	report_assertion("When the event_mode argument is SyncBoth and either the");
	report_assertion("keyboard or pointer is not frozen by the client or neither");
	report_assertion("are grabbed by the client, then a call to XAllowEvents has");
	report_assertion("no effect.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions available:");
	report_strategy("  Call XAllowEvents with SyncBoth.");
	report_strategy("  Press button.");
	report_strategy("  Verify that pointer and keyboard are not frozen.");

	tpstartup();
	setargs();
	if (noext(0))
		return;

	grabwin = defwin(display);

	event_mode = SyncBoth;
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	buttonpress(display, Button1);
	if (ispfrozen(display)) {
		report("Pointer was frozen by button press after SyncBoth");
		report("  even though there were no grabs active");
		FAIL;
	} else
		CHECK;
	if (iskfrozen(display)) {
		report("Keyboard was frozen by button press after SyncBoth");
		report("  even though there were no grabs active");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t024(){

int 	pass = 0, fail = 0;

 	report_purpose(24);

	report_assertion("Assertion XAllowEvents-24.(B)");
	report_assertion("When the event_mode argument is AsyncBoth and the pointer");
	report_assertion("and the keyboard are frozen by the client, then event");
	report_assertion("processing for both devices is resumed normally.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If no extensions:");
	report_strategy("  Touch test for AsyncBoth.");
	report_strategy("else");
	report_strategy("  Grab and freeze all devices.");
	report_strategy("  Call XAllowEvents with AsyncBoth.");
	report_strategy("  Verify that pointer is released.");
	report_strategy("  Verify that keyboard is released.");

	tpstartup();
	setargs();
	event_mode = AsyncBoth;

	if (noext(0)) {
		startcall(display);
		if (isdeleted())
			return;
		XAllowEvents(display, event_mode, thetime);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		untested("There is no reliable test method, but a touch test was performed");
		return;
	} else
		CHECK;

	bothset();
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display)) {
		report("Pointer remained frozen after AsyncBoth");
		FAIL;
	} else
		CHECK;
	if (iskfrozen(display)) {
		report("Keyboard remained frozen after AsyncBoth");
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t025(){

int 	pass = 0, fail = 0;

 	report_purpose(25);

	report_assertion("Assertion XAllowEvents-25.(B)");
	report_assertion("When the event_mode argument is AsyncBoth and either the");
	report_assertion("keyboard or the pointer is not frozen by the client, then a");
	report_assertion("call to XAllowEvents has no effect.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions available:");
	report_strategy("  Grab and freeze pointer.");
	report_strategy("  Call XAllowEvents with AsyncBoth.");
	report_strategy("  Verify that pointer is not released.");

	tpstartup();
	setargs();
	if (noext(0))
		return;

	grabfreezepointer(display, CurrentTime);

	event_mode = AsyncBoth;
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display))
		CHECK;
	else {
		report("Pointer was released by AsyncBoth, although keyboard was not frozen");
		FAIL;
	}
	CHECKPASS(1);
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t026(){

int 	pass = 0, fail = 0;

 	report_purpose(26);

	report_assertion("Assertion XAllowEvents-26.(B)");
	report_assertion("When the event_mode argument is AsyncBoth and the pointer");
	report_assertion("or keyboard is frozen twice by the client on behalf of two");
	report_assertion("separate grabs, then a call to XAllowEvents thaws for both");
	report_assertion("grabs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions available:");
	report_strategy("  Freeze pointer and keyboard by calling XGrabPointer.");
	report_strategy("  Freeze pointer and keyboard again by calling XGrabKeyboard.");
	report_strategy("");
	report_strategy("  Call XAllowEvents with AsyncBoth.");
	report_strategy("  Verify that pointer and keyboard are not frozen.");

	tpstartup();
	setargs();
	if (noext(0))
		return;

	grabwin = defwin(display);
	XGrabPointer(display, grabwin, False, PointerMotionMask,
		GrabModeSync, GrabModeSync, None, None, thetime);
	XGrabKeyboard(display, grabwin, False, GrabModeSync, GrabModeSync,
		CurrentTime);

	event_mode = AsyncBoth;
	startcall(display);
	if (isdeleted())
		return;
	XAllowEvents(display, event_mode, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display)) {
		report("Pointer remained frozen after AsyncBoth");
		report("  when it was frozen twice");
		FAIL;
	} else
		CHECK;
	if (iskfrozen(display)) {
		report("Keyboard remained frozen after AsyncBoth");
		report("  when it was frozen twice");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t027(){

static	int 	modes[] = {
	AsyncPointer, SyncPointer, ReplayPointer};
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(27);

	report_assertion("Assertion XAllowEvents-27.(B)");
	report_assertion("When the event_mode argument is AsyncPointer, SyncPointer,");
	report_assertion("or ReplayPointer, then a call to XAllowEvents has no effect");
	report_assertion("on the processing of keyboard events.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions are available:");
	report_strategy("  Grab and freeze the keyboard.");
	report_strategy("  For each event_mode AsyncPointer SyncPointer ReplayPointer");
	report_strategy("    Call XAllowEvents.");
	report_strategy("    Verify that keyboard is still frozen.");

	tpstartup();
	setargs();
	if (noext(0))
		return;

	grabwin = defwin(display);
	XGrabKeyboard(display, grabwin, False, GrabModeAsync, GrabModeSync,
		CurrentTime);

	for (i = 0; i < NELEM(modes); i++) {
		event_mode = modes[i];
		startcall(display);
		if (isdeleted())
			return;
		XAllowEvents(display, event_mode, thetime);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if (iskfrozen(display))
			CHECK;
		else {
			report("Keyboard was released when event_mode was %s",
				alloweventmodename(modes[i]));
			FAIL;
		}
	}

	CHECKPASS(NELEM(modes));
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t028(){

static	int 	modes[] = {
	AsyncKeyboard, SyncKeyboard, ReplayKeyboard};
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(28);

	report_assertion("Assertion XAllowEvents-28.(A)");
	report_assertion("When the event_mode argument is AsyncKeyboard,");
	report_assertion("SyncKeyboard, or ReplayKeyboard, then a call to");
	report_assertion("XAllowEvents has no effect on the processing of pointer");
	report_assertion("events.");

	report_strategy("Grab and freeze pointer.");
	report_strategy("For each event_mode AsyncKeyboard SyncKeyboard ReplayKeyboard");
	report_strategy("  Call XAllowEvents.");
	report_strategy("  Verify that pointer is still frozen.");

	tpstartup();
	setargs();
	grabfreezepointer(display, thetime);

	for (i = 0; i < NELEM(modes); i++) {
		event_mode = modes[i];
		startcall(display);
		if (isdeleted())
			return;
		XAllowEvents(display, event_mode, thetime);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if (ispfrozen(display))
			CHECK;
		else {
			report("Pointer was released when event_mode was %s",
				alloweventmodename(modes[i]));
			FAIL;
		}
	}

	CHECKPASS(NELEM(modes));
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mval.tmc.27937 */
/* End of included file Mval.tmc.27937 */

/* Including from file error/EVal.mc */
static void t029(){

#undef	VALUE_ARG
#define	VALUE_ARG event_mode
#undef	VALUE_LIST
#define	VALUE_LIST event_modevallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(29);

	report_assertion("Assertion XAllowEvents-29.(A)");
	report_assertion("When the value of event_mode is other than AsyncPointer,");
	report_assertion("SyncPointer, AsyncKeyboard, SyncKeyboard, ReplayPointer,");
	report_assertion("ReplayKeyboard, AsyncBoth or SyncBoth, then a BadValue");
	report_assertion("error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XAllowEvents(display, event_mode, thetime);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ t021, 21 },
	{ t022, 22 },
	{ t023, 23 },
	{ t024, 24 },
	{ t025, 25 },
	{ t026, 26 },
	{ t027, 27 },
	{ t028, 28 },
	{ t029, 29 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = focusstartup;
void	(*tet_cleanup)() = focuscleanup;
