/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Atom
 *   XInternAtom(display, atom_name, only_if_exists)
 *   Display *display;
 *   char *atom_name;
 *   Bool only_if_exists;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XInternAtom	1
char    *TestName = "XInternAtom";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XInternAtom function
 */
static Display *display;
static char *atom_name;
static Bool only_if_exists;


/* Need to pick up the XA_RECTANGLE declaration */
#include "X11/Xatom.h"

#define XIA_ATOM_NAME_1 "XTEST_ATOM_ONE"
#define XIA_ATOM_NAME_2 "XTEST_ATOM_TWO"
#define XIA_ATOM_NAME_3a "XTEST_ATOM_THREE"
#define XIA_ATOM_NAME_3b "Xtest_Atom_Three"
#define XIA_ATOM_NAME_3c "xTeSt_aToM_tHrEe"
#define XIA_ATOM_NAME_4 "XTEST_ATOM_FOUR"
#define XIA_ATOM_NAME_5 "XTEST_ATOM_FIVE"


/* Value list for use in test t008 */
static int 	only_if_existsvallist[] = {
	True,
	False,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	atom_name = 0;
	only_if_exists = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Atom atom_return;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XInternAtom-1.(A)");
	report_assertion("A call to XInternAtom returns the atom identifier");
	report_assertion("associated with the specified atom_name.");

	report_strategy("Call XInternAtom to obtain the atom representation associated with \"RECTANGLE\".");
	report_strategy("Verify that the atom returned was as expected.");

	tpstartup();
	setargs();
/* Call xname to obtain the atom representation associated with "RECTANGLE". */
	atom_name = "RECTANGLE";
	only_if_exists = True;
	startcall(display);
	if (isdeleted())
		return;
	atom_return = XInternAtom(display, atom_name, only_if_exists);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the atom returned was as expected. */
	if (atom_return != XA_RECTANGLE) {
		FAIL;
		report("%s did not return the expected value",
			TestName);
		report("Expected value: %u (%s)", (unsigned long)XA_RECTANGLE,
			atomname(XA_RECTANGLE));
		report("Returned value: %u (%s)", (unsigned long)atom_return,
			atomname(atom_return));
	} else
		CHECK;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Atom atom_return;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XInternAtom-2.(A)");
	report_assertion("When XInternAtom is called with only_if_exists set to True");
	report_assertion("and the specified atom_name is not associated with an atom,");
	report_assertion("then None is returned.");

	report_strategy("Call XInternAtom with an atom_name not associated with an atom,");
	report_strategy("	with only_if_exists True.");
	report_strategy("Verify that None was returned.");

	tpstartup();
	setargs();
/* Call xname with an atom_name not associated with an atom, */
/* 	with only_if_exists True. */
	atom_name=XIA_ATOM_NAME_1;
	only_if_exists = True;
	startcall(display);
	if (isdeleted())
		return;
	atom_return = XInternAtom(display, atom_name, only_if_exists);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that None was returned. */
	if (atom_return != (Atom)None) {
		FAIL;
		report("%s did not return the expected value", TestName);
		report("Expected value: %u (None)", None);
		report("Returned value: %u (%s)", (unsigned long)atom_return,
			atomname(atom_return));
	} else
		CHECK;
	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Atom atom_return;
char *check_name;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XInternAtom-3.(A)");
	report_assertion("When XInternAtom is called with only_if_exists set to False");
	report_assertion("and the specified atom_name is not associated with an atom,");
	report_assertion("then an atom is created and its atom identifer is returned.");

	report_strategy("Call XInternAtom to ensure that atom_name is not associated with an atom.");
	report_strategy("Call XInternAtom with an atom_name not associated with an atom,");
	report_strategy("	with only_if_exists False.");
	report_strategy("Verify that None was not returned.");
	report_strategy("Verify that the returned atom id corresponds to atom_name.");

	tpstartup();
	setargs();
/* Call xname to ensure that atom_name is not associated with an atom. */
	atom_name=XIA_ATOM_NAME_2;
	only_if_exists = True;
	startcall(display);
	if (isdeleted())
		return;
	atom_return = XInternAtom(display, atom_name, only_if_exists);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(atom_return != None) {
		delete("Atom name %s has an identifier associated with it (%u)",
			XIA_ATOM_NAME_2, atom_return);
		report("Possible reason: Server was not reset");
		report("after a previous test run");
		return;
	} else
		CHECK;

/* Call xname with an atom_name not associated with an atom, */
/* 	with only_if_exists False. */
	atom_name=XIA_ATOM_NAME_2;
	only_if_exists = False;
	startcall(display);
	if (isdeleted())
		return;
	atom_return = XInternAtom(display, atom_name, only_if_exists);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that None was not returned. */
	trace("Atom id returned: %u (%s)", (unsigned long)atom_return,
		atomname(atom_return));

	if (atom_return == (Atom)None) {
		FAIL;
		report("%s did not return the expected value", TestName);
		report("Expected value: an atom identifier");
		report("Returned value: %u (None)", None);
		return;
	} else
		CHECK;

/* Verify that the returned atom id corresponds to atom_name. */
	check_name = XGetAtomName(display, atom_return);
	if (check_name == NULL) {
		delete("XGetAtomName returned NULL");
		return;
	} else
		CHECK;

	if(strcmp(check_name, XIA_ATOM_NAME_2) != 0) {
		FAIL;
		report("%s did not return an atom id associated with atom_name",
			TestName);
		report("Atom returned was %u", (unsigned long)atom_return);
		report("Expected associated name: %s", XIA_ATOM_NAME_2);
		report("Returned associated name: %s", check_name);
	} else
		CHECK;

	XFree(check_name);
	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Atom atom_a, atom_b, atom_return;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XInternAtom-4.(A)");
	report_assertion("On a call to XInternAtom, the case of the atom_name string");
	report_assertion("is significant for designating or identifying atoms.");

	report_strategy("Call XInternAtom to ensure that atom XIA_ATOM_NAME_3a does not exist.");
	report_strategy("Call XInternAtom to create an atom XIA_ATOM_NAME_3a.");
	report_strategy("Call XInternAtom to create an atom XIA_ATOM_NAME_3b.");
	report_strategy("Verify the atom identifiers are distinct.");
	report_strategy("Call XInternAtom to obtain the atom id associated with XIA_ATOM_NAME_3c.");
	report_strategy("Verify the atom identifier is None.");

	tpstartup();
	setargs();
/* Call xname to ensure that atom XIA_ATOM_NAME_3a does not exist. */
	atom_name=XIA_ATOM_NAME_3a;
	only_if_exists = True;
	startcall(display);
	if (isdeleted())
		return;
	atom_return = XInternAtom(display, atom_name, only_if_exists);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(atom_return != None) {
		delete("Atom name %s has an identifier associated with it (%u)",
			XIA_ATOM_NAME_3a, atom_return);
		report("Possible reason: Server was not reset");
		report("after a previous test run");
		return;
	} else
		CHECK;

/* Call xname to create an atom XIA_ATOM_NAME_3a. */
	atom_name=XIA_ATOM_NAME_3a;
	only_if_exists = False;
	startcall(display);
	if (isdeleted())
		return;
	atom_a = XInternAtom(display, atom_name, only_if_exists);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (atom_a == (Atom)None) {
		delete("%s did not return the expected value", TestName);
		report("Expected value: an atom identifier for %s",
			XIA_ATOM_NAME_3a);
		report("Returned value: %u (None)", None);
		return;
	} else
		CHECK;
	trace("XIA_ATOM_NAME_3a (%s) is %u", XIA_ATOM_NAME_3a,
		(unsigned long)atom_a);

/* Call xname to create an atom XIA_ATOM_NAME_3b. */
	atom_name=XIA_ATOM_NAME_3b;
	only_if_exists = False;
	startcall(display);
	if (isdeleted())
		return;
	atom_b = XInternAtom(display, atom_name, only_if_exists);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (atom_b == (Atom)None) {
		delete("%s did not return the expected value", TestName);
		report("Expected value: an atom identifier for %s",
			XIA_ATOM_NAME_3b);
		report("Returned value: %u (None)", None);
		return;
	} else
		CHECK;
	trace("XIA_ATOM_NAME_3b (%s) is %u", XIA_ATOM_NAME_3b,
		(unsigned long)atom_b);

/* Verify the atom identifiers are distinct. */
	if(atom_a == atom_b) {
		FAIL;
		report("%s did not return distinct atom identifiers for",
			TestName);
		report("atom %s and atom %s.",
			XIA_ATOM_NAME_3a, XIA_ATOM_NAME_3b);
	} else
		CHECK;

/* Call xname to obtain the atom id associated with XIA_ATOM_NAME_3c. */
	atom_name=XIA_ATOM_NAME_3c;
	only_if_exists = True;
	startcall(display);
	if (isdeleted())
		return;
	atom_return = XInternAtom(display, atom_name, only_if_exists);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify the atom id associated with XIA_ATOM_NAME_3c is None. */
	if (atom_return != (Atom)None) {
		char *check_name;
		check_name=XGetAtomName(display, atom_return);
		FAIL;
		report("%s did not return the expected value", TestName);
		report("Expected value: %u (None)", None);
		report("Returned value: %u (%s)", (unsigned long)atom_return,
			(check_name==NULL?"NO_NAME":check_name));
		XFree(check_name);
	} else
		CHECK;

	CHECKPASS(5);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Atom atom_return, atom_return2;
Display *display2;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XInternAtom-5.(A)");
	report_assertion("Atoms created by a call to XInternAtom will remain defined");
	report_assertion("after the client's connection closes.");

	report_strategy("Create a new client.");
	report_strategy("Call XInternAtom to ensure that XIA_ATOM_NAME_4 is not associated with an atom.");
	report_strategy("Call XInternAtom to create atom XIA_ATOM_NAME_4 on display2.");
	report_strategy("Close display2.");
	report_strategy("Allow sufficient time for the server to register the close display");
	report_strategy("Verify that atom XIA_ATOM_NAME_4 remains defined.");

	tpstartup();
	setargs();
/* Create a new client. */
	if (config.display == (char *) NULL) {
		delete("config.display not set");
		return;
	}
	else
		CHECK;

	display2 = XOpenDisplay(config.display);
	if (display2 == (Display *)NULL) {
		delete("Could not open display for display2");
		return;
	} else
		CHECK;

/* Call xname to ensure that atom_name is not associated with an atom. */
	display = display2;
	atom_name=XIA_ATOM_NAME_4;
	only_if_exists = True;
	startcall(display);
	if (isdeleted())
		return;
	atom_return = XInternAtom(display, atom_name, only_if_exists);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(atom_return != None) {
		delete("Atom name %s has an identifier associated with it (%u)",
			XIA_ATOM_NAME_4, atom_return);
		report("Possible reason: Server was not reset");
		report("after a previous test run");
		return;
	} else
		CHECK;

/* Call xname to create a new atom on display2. */
	atom_name=XIA_ATOM_NAME_4;
	only_if_exists = False;
	startcall(display);
	if (isdeleted())
		return;
	atom_return = XInternAtom(display, atom_name, only_if_exists);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	trace("Atom id %u returned for %s", (unsigned long)atom_return,
		XIA_ATOM_NAME_4);

	if (atom_return == (Atom)None) {
		delete("%s did not return the expected value", TestName);
		report("Expected value: an atom identifier");
		report("Returned value: %u (None)", None);
		return;
	} else
		CHECK;

/* Close display2. */
	XCloseDisplay(display2);

/* Allow sufficient time for the server to register the close display */
	reset_delay();

/* Verify that atom XIA_ATOM_NAME_4 remains defined. */
	display = Dsp;
	atom_name=XIA_ATOM_NAME_4;
	only_if_exists = True;
	startcall(display);
	if (isdeleted())
		return;
	atom_return2 = XInternAtom(display, atom_name, only_if_exists);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	trace("Atom id %u returned for %s", (unsigned long)atom_return,
		XIA_ATOM_NAME_4);

	if (atom_return2 != atom_return) {
		FAIL;
		report("%s did not return the expected value", TestName);
		report("Expected value: %u (%s)", atom_return,
			XIA_ATOM_NAME_4);
		report("Returned value: %u", (unsigned long)atom_return2);
	} else
		CHECK;

	CHECKPASS(5);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Atom atom_return;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XInternAtom-6.(A)");
	report_assertion("When the last connection to the server closes, then atoms");
	report_assertion("created by a call to XInternAtom will become undefined.");

	report_strategy("Ensure we can open a new display.");
	report_strategy("Create an atom by calling XInternAtom.");
	report_strategy("Close the last connection to the server.");
	report_strategy("Allow sufficient time for the server to register the close display");
	report_strategy("Open a new connection to the server.");
	report_strategy("Verify that the atom is undefined.");

	tpstartup();
	setargs();
/* Ensure we can open a new display. */
	if (config.display == (char *) NULL) {
		delete("config.display not set");
		return;
	}
	else
		CHECK;

/* Create an atom by calling xname. */
	atom_name=XIA_ATOM_NAME_5;
	only_if_exists = False;
	startcall(display);
	if (isdeleted())
		return;
	atom_return = XInternAtom(display, atom_name, only_if_exists);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	trace("Atom id %u returned for %s", (unsigned long)atom_return,
		XIA_ATOM_NAME_4);

#ifdef TESTING
	atom_return = None;
#endif
	if (atom_return == (Atom)None) {
		delete("%s did not return the expected value", TestName);
		report("Expected value: an atom identifier");
		report("Returned value: %u (None)", None);
		return;
	} else
		CHECK;

/* Close the last connection to the server. */
	XCloseDisplay(display);

/* Allow sufficient time for the server to register the close display */
	reset_delay();

/* Open a new connection to the server. */
	Dsp = XOpenDisplay(config.display);
	if (Dsp == (Display *)NULL) {
		delete("Could not open display");
		cancelrest("Could not open display");
		return;
	} else
		CHECK;

/* Verify that the atom is undefined. */
	display = Dsp;
	atom_name=XIA_ATOM_NAME_5;
	only_if_exists = True;
	startcall(display);
	if (isdeleted())
		return;
	atom_return = XInternAtom(display, atom_name, only_if_exists);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	trace("Atom id %u returned for %s", (unsigned long)atom_return,
		XIA_ATOM_NAME_5);

	if (atom_return != (Atom)None) {
		char *check_name;
		FAIL;
		report("Closing last connection to server did not");
		report("clear the defined atom %s", XIA_ATOM_NAME_5);
		report("Expected value: %u (None)", (unsigned long)None);
		check_name=XGetAtomName(display, atom_return);
		report("Returned value: %u (%s)", (unsigned long)atom_return,
			(check_name==NULL?"NO_NAME":check_name));
		report("Possible reason: Other connections open to server");
		report("during test run");
		XFree(check_name);
	} else
		CHECK;

	CHECKPASS(4);
		
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XInternAtom-7.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

/* Including from file Mval.tmc.7665 */
/* End of included file Mval.tmc.7665 */

/* Including from file error/EVal.mc */
static void t008(){

#undef	VALUE_ARG
#define	VALUE_ARG only_if_exists
#undef	VALUE_LIST
#define	VALUE_LIST only_if_existsvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XInternAtom-8.(A)");
	report_assertion("When the value of only_if_exists is other than True or");
	report_assertion("False, then a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XInternAtom(display, atom_name, only_if_exists);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
