/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtGetConstraintResourceList()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <AvsForm.h>
#include <AvsForm2.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

void XtWMH_Proc(str1, str2, str3, str4, str5, car)
String str1, str2, str3, str4, *str5;
Cardinal *car;
{
}



#define T_XtGetConstraintResourceList	1
char    *TestName = "XtGetConstraintResourceList";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget formw_good, labelw_good;
XtResourceList resources_return;
Cardinal num_resources_return;
Boolean resize_value;
int i;
int found;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtGetConstraintResourceList-1.(A)");
	report_assertion("When the widget class class is not initialized a successful");
	report_assertion("call to void XtGetConstraintResourceList(class,");
	report_assertion("resources_return, num_resources_return) shall return a");
	report_assertion("pointer to the resource list as specified in the widget");
	report_assertion("class Constraint part in resources_return and the number of");
	report_assertion("resources in this list in num_resources_return.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtconrsl1", "XtGetConstraintResourceList");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get avsform2 class resource list");
	XtGetConstraintResourceList(avsform2WidgetClass, &resources_return, &num_resources_return);
	tet_infoline("TEST: Resource count does not include superclass'");
	if (num_resources_return != 1) {
		sprintf(ebuf, "ERROR: Number of resources returned %d, should be 1", num_resources_return);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}

	tet_infoline("TEST: avsform2's XtNresizable resource in list");
	found = 0;
	for ( i = 0; i < num_resources_return; i++ ) {
		if (strcmp(XtNresizable, resources_return[i].resource_name) == 0 ) {
	 		found = 1;
	 		check_dec(FALSE, (long)resources_return[i].default_addr, XtNresizable);
	 	} /* end if */
	} /* end for */
	if (!found) {
		sprintf(ebuf, "ERROR: Did not find XtNresizable resource value");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	 }
	
	tet_infoline("TEST: Superclass' XtNfromVert resource not in list");
	found = 0;
	for ( i = 0; i < num_resources_return; i++ ) {
		if (strcmp(XtNfromVert, (char *)resources_return[i].resource_name) == 0 ) {
			sprintf(ebuf, "ERROR: Found XtNfromVert resource");
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
	 	}
	}
	tet_infoline("CLEANUP: Free the resource list.");
	XtFree((void *)resources_return);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.11698 */
/* End of included file Mdefcode.tmc.11698 */

static void t002(){

XtResourceList resources_return;
Cardinal num_resources_return;
int i , value;
Widget formw_good, labelw_msg;
int found;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtGetConstraintResourceList-2.(A)");
	report_assertion("When the widget class class is initialized a successful");
	report_assertion("call to void XtGetConstraintResourceList(class,");
	report_assertion("resources_return, num_resources_return) shall return a");
	report_assertion("pointer to the merged resource list that includes the");
	report_assertion("resources as specified in the widget class Constraint part");
	report_assertion("and for all Constraint superclasses in resources_return and");
	report_assertion("the number of resources in this list in");
	report_assertion("num_resources_return.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtconrsl2", "XtGetConstraintResourceList");
	XtAppSetWarningMsgHandler(app_ctext, XtWMH_Proc);
	tet_infoline("PREP: Create avs2form widget in boxw1 widget");
	formw_good = XtCreateManagedWidget("avsform2",
			avsform2WidgetClass,
			boxw1,
			NULL,
			0);
	labelw_msg = (Widget) CreateLabelWidget("ApTest", formw_good);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get avsform2 class resource list");
	XtGetConstraintResourceList(avsform2WidgetClass, &resources_return, &num_resources_return);
	tet_infoline("TEST: Resource count includes superclass'");
	if (num_resources_return != 9 ) {
		sprintf(ebuf, "ERROR: Resource list size was %d, expected 9 - did not include superclass resource.", num_resources_return);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Superclass' XtNfromVert resource in list");
	found = 0;
	for ( i = 0; i < num_resources_return; i++ ) {
		if (strcmp(XtNfromVert, resources_return[i].resource_name) == 0 ) {
			found = 1;
			check_dec(0, (long)resources_return[i].default_addr, "XtNfromVert value");
		} /* end if */
	} /* end for */
	if (!found) {
	 	sprintf(ebuf, "ERROR: Could not find XtNfromVert resource value");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: avsform2's XtNresizable resource in list");
	found = 0;
	for ( i = 0; i < num_resources_return; i++ ) {
		if (strcmp(XtNresizable, resources_return[i].resource_name) == 0 ) {
			found = 1;
			check_dec(FALSE, (long)resources_return[i].default_addr, "XtNresizable value");
		} /* end if */
	} /* end for */
	if (!found) {
	 	sprintf(ebuf, "ERROR: Could not find XtNresizable resource value");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.11698 */
/* End of included file Mdefcode.tmc.11698 */

static void t003(){

Widget labelw_good;
XtResourceList resources_return;
Cardinal num_resources_return;
pid_t pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtGetConstraintResourceList-3.(A)");
	report_assertion("A call to void XtGetConstraintResourceList(class,");
	report_assertion("resources_return, num_resources_return) when class is not a");
	report_assertion("subclass of constraintWidgetClass shall set resources_return");
	report_assertion("to NULL and num_resources_return to zero.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtconrsl3", "XtGetConstraintResourceList");
	tet_infoline("PREP: Create label widget");
	labelw_good = (Widget) CreateLabelWidget("ApTest", boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get label widget resource list");
	XtGetConstraintResourceList(labelWidgetClass, &resources_return, &num_resources_return);
	tet_infoline("TEST: Resources_return and num_resources_return values");
	if (resources_return != NULL) {
			sprintf(ebuf, "ERROR: Expected resources_return NULL");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	check_dec(0, (long)num_resources_return, "Number of Resources");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.11698 */
/* End of included file Mdefcode.tmc.11698 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
