/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XrmCombineFileDatabase()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <locale.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/Xresource.h>
#include <X11/Xproto.h>
#include <X11/Xcms.h>
#include <xtestlib.h>
#include <tet_api.h>
#include <r5structs.h>
#include <r5decl.h>
/*error messages created here*/
char	ebuf[4096];

#define T_XrmCombineFileDatabase	1
char    *TestName = "XrmCombineFileDatabase";




/******
 * User defined globals for test
 ******/
char *src_spec1 = "test.Quark:happy";
char *src_spec2 = "test1.Quark:happier";
char *src_spec3 = "test2.Quark:happiest";
char *dst_spec = "test.Quark:sad";

char *str_name = "test.Quark";
char *str2_name = "test1.Quark";
char *str3_name = "test2.Quark";
char *str_class = "";
char *str_type_return;
XrmValue value_return;

char *src_value = "happy";
char *src2_value = "happier";
char *src3_value = "happiest";
char *dst_value = "sad";

XrmDatabase gfd_return;
XrmDatabase dst_database_id;

char	*file_name_good = "xtestinfo.dat";

char *exec_file_name;
int x_init, y_init, h_init, w_init;

extern int  errcnt;
extern int  errflg;
extern int  chkflg;
extern int  signal_status();
extern int  unexp_err();
extern char *svc_user_arg;
extern char *strcpy();

char fmtstr[256], *call_string;
union msglst fmt_lst[1];        
int skip_pixcheck;

int 	ss_status,		/* save stat return status */	
	stat_status,		/* check stat return status */
	setup_status,
	cleanup_status,
	i1;

Status      svc_ret_value;



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){


 	report_purpose(1);

	report_assertion("Assertion XrmCombineFileDatabase-1.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to");
	report_assertion("XrmCombineFileDatabase shall merge the contents of a");
	report_assertion("resource file into a database.");
#if XT_X_RELEASE > 4
	display_arg = Dsp;
/*
 * Create a GC to save environmental data in
 */
	gc_save = XCreateGC(display_arg,XRootWindow(display_arg,XDefaultScreen(display_arg)),(unsigned long)0,(XGCValues *)0);

	regr_args.l_flags.check = 0;
	regr_args.l_flags.nostat = 0;
	regr_args.l_flags.perf = 0;
	regr_args.l_flags.setup = 0;
	regr_args.l_flags.cleanup = 0;
	regr_args.l_flags.chksta = 0;
	regr_args.l_flags.chkdpy = 0;
	regr_args.l_flags.verbose = 0;
	estatus[0] = 1;

        XrmInitialize();

	estatus[0] = 1;
	estatus[1] = Success;

	regr_args.l_flags.setup = 1;
	regr_args.l_flags.check = 1;
	regr_args.l_flags.chksta = 1;

	gfd_return = XrmGetStringDatabase(src_spec1);

	tet_infoline("PREP: Add data to resource file");
	(void)XrmPutFileDatabase(gfd_return, file_name_good);
	tet_infoline("PREP: Add to database");

	(void)XrmPutLineResource(&dst_database_id, dst_spec);

	tet_infoline("TEST: Call to XrmCombineFileDatabase merges resource file into database");
	XrmCombineFileDatabase(file_name_good, &dst_database_id, True);

	XSync(display_arg, 0);
	XSetErrorHandler(unexp_err);          
	/* no colormap by default */
	r_wait(display_arg, window_arg, time_delay, None);	
	if (regr_args.l_flags.chksta  == 1) 
		stat_status = chek_stat (0, gc_id, display_arg,
			 drawable_id, ss_status);
	else                              
		stat_status = REGR_NORMAL;

	if ((!errflg) && (!chkflg)) 
		if ((badstat(display_arg, estatus, Success)) != REGR_NORMAL)
			errflg = 1;

	if ((regr_args.l_flags.check) && (errflg == 0) && 
	    (stat_status == REGR_NORMAL)) 
	{
		XrmGetResource(dst_database_id, str_name, str_class, 
			&str_type_return, &value_return);


		if (strcmp(value_return.addr, src_value) != 0) {

			sprintf(ebuf, "ERROR: Expected value of %s to be \"%s\", is \"%s\"", str_name, src_value, value_return.addr);
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
	}
	XSync(display_arg, 0);
	chkflg = 0;
	regr_args.l_flags.bufrout = 0;
	dumpbuf();
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif
}

/* Including from file Mdefcode.tmc.9903 */
/* End of included file Mdefcode.tmc.9903 */

static void t002(){


 	report_purpose(2);

	report_assertion("Assertion XrmCombineFileDatabase-2.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to");
	report_assertion("XrmCombineFileDatabase when the same specifier is used for");
	report_assertion("an entry in both the file and the database and override is");
	report_assertion("True the entry in filename shall replace the entry in");
	report_assertion("target_db.");
#if XT_X_RELEASE > 4
	display_arg = Dsp;
/*
 * Create a GC to save environmental data in
 */
	gc_save = XCreateGC(display_arg,XRootWindow(display_arg,XDefaultScreen(display_arg)),(unsigned long)0,(XGCValues *)0);

	regr_args.l_flags.check = 0;
	regr_args.l_flags.nostat = 0;
	regr_args.l_flags.perf = 0;
	regr_args.l_flags.setup = 0;
	regr_args.l_flags.cleanup = 0;
	regr_args.l_flags.chksta = 0;
	regr_args.l_flags.chkdpy = 0;
	regr_args.l_flags.verbose = 0;
	estatus[0] = 1;

        XrmInitialize();

	estatus[1] = Success;

	regr_args.l_flags.setup = 1;
	regr_args.l_flags.check = 1;
	regr_args.l_flags.chksta = 1;

	gfd_return = XrmGetStringDatabase(src_spec1);
	(void)XrmPutLineResource(&gfd_return, src_spec2);
	(void)XrmPutLineResource(&gfd_return, src_spec3);

	tet_infoline("PREP: Add data to resource file");
	(void)XrmPutFileDatabase(gfd_return, file_name_good);

	tet_infoline("PREP: Add to database");
	(void)XrmPutLineResource(&dst_database_id, dst_spec);

	tet_infoline("TEST: Entry in the file replaces the database entry");
	XrmCombineFileDatabase(file_name_good, &dst_database_id, True);

	XSync(display_arg, 0);
	XSetErrorHandler(unexp_err);          
	/* no colormap by default */
	r_wait(display_arg, window_arg, time_delay, None);	
	if (regr_args.l_flags.chksta  == 1) 
		stat_status = chek_stat (0, gc_id, display_arg,
			 drawable_id, ss_status);
	else                              
		stat_status = REGR_NORMAL;

	if ((!errflg) && (!chkflg)) 
		if ((badstat(display_arg, estatus, Success)) != REGR_NORMAL)
			errflg = 1;

	if ((regr_args.l_flags.check) && (errflg == 0) && 
	    (stat_status == REGR_NORMAL)) 
	{
		XrmGetResource(dst_database_id, str_name, str_class, 
			&str_type_return, &value_return);


		if (strcmp(value_return.addr, src_value) != 0) {

			sprintf(ebuf, "ERROR: Expected value of %s to be \"%s\", is \"%s\"", str_name, src_value, value_return.addr);
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
	}
	XSync(display_arg, 0);
	chkflg = 0;
	regr_args.l_flags.bufrout = 0;
	dumpbuf();
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif
}

/* Including from file Mdefcode.tmc.9903 */
/* End of included file Mdefcode.tmc.9903 */

static void t003(){


 	report_purpose(3);

	report_assertion("Assertion XrmCombineFileDatabase-3.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to");
	report_assertion("XrmCombineFileDatabase when the same specifier is used for");
	report_assertion("an entry in both the file and the database and override is");
	report_assertion("not True the entry in filename shall not replace the entry");
	report_assertion("in target_db.");
#if XT_X_RELEASE > 4
	display_arg = Dsp;
/*
 * Create a GC to save environmental data in
 */
	gc_save = XCreateGC(display_arg,XRootWindow(display_arg,XDefaultScreen(display_arg)),(unsigned long)0,(XGCValues *)0);

	regr_args.l_flags.check = 0;
	regr_args.l_flags.nostat = 0;
	regr_args.l_flags.perf = 0;
	regr_args.l_flags.setup = 0;
	regr_args.l_flags.cleanup = 0;
	regr_args.l_flags.chksta = 0;
	regr_args.l_flags.chkdpy = 0;
	regr_args.l_flags.verbose = 0;
	estatus[0] = 1;

        XrmInitialize();

	estatus[1] = Success;

	regr_args.l_flags.setup = 1;
	regr_args.l_flags.check = 1;
	regr_args.l_flags.chksta = 1;

	gfd_return = XrmGetStringDatabase(src_spec1);
	(void)XrmPutLineResource(&gfd_return, src_spec2);
	(void)XrmPutLineResource(&gfd_return, src_spec3);

	tet_infoline("PREP: Add data to resource file");
	(void)XrmPutFileDatabase(gfd_return, file_name_good);

	tet_infoline("PREP: Add to database");
	(void)XrmPutLineResource(&dst_database_id, dst_spec);

	tet_infoline("TEST: Entry in the file does not replace the database entry");
	XrmCombineFileDatabase(file_name_good, &dst_database_id, False);

	XSync(display_arg, 0);
	XSetErrorHandler(unexp_err);          
	/* no colormap by default */
	r_wait(display_arg, window_arg, time_delay, None);	
	if (regr_args.l_flags.chksta  == 1) 
		stat_status = chek_stat (0, gc_id, display_arg,
			 drawable_id, ss_status);
	else                              
		stat_status = REGR_NORMAL;

	if ((!errflg) && (!chkflg)) 
		if ((badstat(display_arg, estatus, Success)) != REGR_NORMAL)
			errflg = 1;

	if ((regr_args.l_flags.check) && (errflg == 0) && 
	    (stat_status == REGR_NORMAL)) 
	{
		XrmGetResource(dst_database_id, str_name, str_class, 
			&str_type_return, &value_return);

		if (strcmp(value_return.addr, dst_value) != 0) {

			sprintf(ebuf, "ERROR: Expected value of %s to be \"%s\", is \"%s\"", str_name, dst_value, value_return.addr);
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
	}
	XSync(display_arg, 0);
	chkflg = 0;
	regr_args.l_flags.bufrout = 0;
	dumpbuf();
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif
}

/* Including from file Mdefcode.tmc.9903 */
/* End of included file Mdefcode.tmc.9903 */

static void t004(){


 	report_purpose(4);

	report_assertion("Assertion XrmCombineFileDatabase-4.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to");
	report_assertion("XrmCombineDatabase when target_db is NULL shall create a new");
	report_assertion("database with entries from filename in it.");
#if XT_X_RELEASE > 4
	display_arg = Dsp;

	/*
 	* Create a GC to save environmental data in
 	*/
	gc_save = XCreateGC(display_arg,XRootWindow(display_arg,XDefaultScreen(display_arg)),(unsigned long)0,(XGCValues *)0);

	regr_args.l_flags.check = 0;
	regr_args.l_flags.nostat = 0;
	regr_args.l_flags.perf = 0;
	regr_args.l_flags.setup = 0;
	regr_args.l_flags.cleanup = 0;
	regr_args.l_flags.chksta = 0;
	regr_args.l_flags.chkdpy = 0;
	regr_args.l_flags.verbose = 0;
	estatus[0] = 1;

        XrmInitialize();

	estatus[0] = 1;
	estatus[1] = Success;

	regr_args.l_flags.setup = 1;
	regr_args.l_flags.check = 1;
	regr_args.l_flags.chksta = 1;

	tet_infoline("PREP: Add data to resource file");
	gfd_return = XrmGetStringDatabase(src_spec1);
	(void)XrmPutLineResource(&gfd_return, src_spec2);
	(void)XrmPutLineResource(&gfd_return, src_spec3);
	(void)XrmPutFileDatabase(gfd_return, file_name_good);

	dst_database_id = NULL;

	tet_infoline("TEST: When target_db is NULL a new database is created");
	XrmCombineFileDatabase(file_name_good, &dst_database_id, True);

	XSync(display_arg, 0);
	XSetErrorHandler(unexp_err);          

	if (dst_database_id == NULL)
	{
		sprintf(ebuf, "ERROR: Expected value of target_db to be non-NULL is %p", dst_database_id);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	/* Search for entries */
	sprintf(ebuf, "	INFO: Check Resource: %s", str_name);
	tet_infoline(ebuf);
	XrmGetResource(dst_database_id, str_name, str_class, 
		&str_type_return, &value_return);
	if (strcmp(value_return.addr, src_value) != 0) {

		sprintf(ebuf, "ERROR: Expected value of %s to be \"%s\", is \"%s\"", str_name, src_value, value_return.addr);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}

	sprintf(ebuf, "	INFO: Check Resource: %s", str2_name);
	tet_infoline(ebuf);
	XrmGetResource(dst_database_id, str2_name, str_class, 
		&str_type_return, &value_return);
	if (strcmp(value_return.addr, src2_value) != 0) {

		sprintf(ebuf, "ERROR: Expected value of %s to be \"%s\", is \"%s\"", str2_name, src2_value, value_return.addr);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}

	sprintf(ebuf, "	INFO: Check Resource: %s", str3_name);
	tet_infoline(ebuf);
	XrmGetResource(dst_database_id, str3_name, str_class, 
		&str_type_return, &value_return);
	if (strcmp(value_return.addr, src3_value) != 0) {

		sprintf(ebuf, "ERROR: Expected value of %s to be \"%s\", is \"%s\"", str3_name, src3_value, value_return.addr);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	XSync(display_arg, 0);
	chkflg = 0;
	regr_args.l_flags.bufrout = 0;
	dumpbuf();
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif
}

/* Including from file Mdefcode.tmc.9903 */
/* End of included file Mdefcode.tmc.9903 */

/* Including from file Mdefcode.tmc.9903 */
static void t005(){


 	report_purpose(5);

	report_assertion("Assertion XrmCombineFileDatabase-5.(D)");
	report_assertion("If the implementation is X11R5 or later: A call to");
	report_assertion("XrmCombineFileDatabase shall merge entries from filename and");
	report_assertion("target_db without changing values of types, regardless of");
	report_assertion("the locales of the database.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");
	UNTESTED;
}

/* End of included file Mdefcode.tmc.9903 */

/* Including from file Mdefcode.tmc.9903 */
static void t006(){


 	report_purpose(6);

	report_assertion("Assertion XrmCombineFileDatabase-6.(D)");
	report_assertion("If the implementation is X11R5 or later: A call to");
	report_assertion("XrmCombineFileDatabase shall not modify the locale of the");
	report_assertion("target database.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");
	UNTESTED;
}

/* End of included file Mdefcode.tmc.9903 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = r5_startup;
void	(*tet_cleanup)() = r5_cleanup;
